/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimInvestRate;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractElimInvestRateListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptClientHelperUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ElimInvestRateEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ElimInvestRateQueryUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ElimInvestRateStructureUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.TemplatePromptDialog;
import com.kingdee.eas.fi.gr.fast.client.MgMergeElimInvestRateFilterUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class ElimInvestRateListUI
extends AbstractElimInvestRateListUI
implements ICSLContextUI {
    private static final Logger logger = CoreUIObject.getLogger(ElimInvestRateListUI.class);
    protected ICSLContext ctx = CSLContextHelper.getCSLContext();
    protected IElimInvestRate IElimInvestRate = null;
    protected int rptYear;
    protected RptPeriodTypeEnum rptPeriodType = null;
    protected int rptPeriod;
    protected OrgTreeInfo orgBound = null;
    protected Date reportDate = null;
    protected OrgUnitInfo curOrgGroup;
    private static final int DIALOG_WIDTH = 400;
    private static final int DIALOG_HEIGHT = 300;
    private static final String ELIM_INVEST = "4";
    protected boolean isDisplayIncludeHis = false;
    private String displayNew = null;
    private String displayHis = null;
    private boolean isDialogsFilter = false;
    protected Map params = new HashMap();

    public ElimInvestRateListUI() throws Exception {
        this.IElimInvestRate = ElimInvestRateFactory.getRemoteInstance();
        this.kDCalEquivShareRate.setEnabled(true);
        this.kDMenuItemCalEquivRate.setEnabled(true);
        this.displayNew = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"802_displayNew");
        this.displayHis = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"801_displayHis");
        this.KDHistory.setText(this.displayHis);
        this.KDHistory.setToolTipText(this.displayHis);
        this.menuItemHistory.setText(this.displayHis);
    }

    private void setTableStyle() {
        this.tblMain.getColumn("date").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("equivRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void listUIOnLoad() throws Exception {
        super.onLoad();
    }

    public void onLoad() throws Exception {
        boolean generateCalculationShow = false;
        try {
            generateCalculationShow = TypeConversionUtils.objToBoolean((Object)CslRptUtil.getParamValue(null, null, "GR_CSL_GenerateCalculation"));
        }
        catch (BOSException e) {
            logger.error((Object)"getParamValue_GR_CSL_GenerateCalculation_eror", (Throwable)e);
        }
        this.kDCreate.setVisible(generateCalculationShow);
        this.kDCreate.setEnabled(generateCalculationShow);
        this.kDCalEquivShareRate.setVisible(generateCalculationShow);
        this.kDCalEquivShareRate.setEnabled(generateCalculationShow);
        this.kDMenuItemCreate.setVisible(generateCalculationShow);
        this.kDMenuItemCreate.setEnabled(generateCalculationShow);
        this.kDMenuItemCalEquivRate.setVisible(generateCalculationShow);
        this.kDMenuItemCalEquivRate.setEnabled(generateCalculationShow);
        this.kDMenuItemCreateAndCal.setVisible(!generateCalculationShow);
        this.kDMenuItemCreateAndCal.setEnabled(!generateCalculationShow);
        this.kDCreateAndCal.setVisible(!generateCalculationShow);
        this.kDCreateAndCal.setEnabled(!generateCalculationShow);
        this.menuItemImportData.setVisible(true);
        this.menuItemImportData.setEnabled(true);
        this.menuItemExportData.setVisible(true);
        this.menuItemExportData.setEnabled(true);
        this.actionSetClearingCompany.setEnabled(true);
        if (!this.isManageMerge()) {
            this.initCslContext();
            this.listUIOnLoad();
        }
        if (this.ctx.getCurDataCollect() != null && !"ACTUALDATA".equals(this.ctx.getCurDataCollect().getNumber())) {
            MsgBox.showError((String)CslRptUtil.getCommonString("RightElimNoSupportDC"));
            SysUtil.abort();
        }
        this.initParameter();
        this.initParams2Map();
        String elimMethod = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(this.orgBound.getId()), (String)"GR_CSL_ELIMMETHOD_001");
        if (!ELIM_INVEST.equals(elimMethod)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvest_not_New"));
            SysUtil.abort();
        }
        MergeModeEnum mergeMode = CslRptUtil.getMergeMode(this.orgBound);
        if (this.rptPeriodType.getValue() != 3) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"periodType_not_monthly"));
            SysUtil.abort();
        }
        if (mergeMode.getValue() == 0 && !this.IElimInvestRate.IsTopUnit(this.curOrgGroup, this.orgBound)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_OnlyTop_UnderDirect"));
            SysUtil.abort();
        }
        this.initAction();
        this.groupTableRow();
        this.setTableStyle();
        this.autoCopyPrePeriodInvestRate();
        this.txtOrgBound.setEnabled(false);
        this.comboBoxCompany.setEnabled(false);
        if (this.orgBound != null && this.orgBound.getName() != null) {
            this.txtOrgBound.setText(this.orgBound.getName());
        }
        this.comboBoxCompany.removeAllItems();
        if (this.curOrgGroup != null) {
            this.comboBoxCompany.addItem((Object)this.curOrgGroup);
        }
        CslRptClientHelperUI.setCruYearAndPeriod(this.ctx, this.spCurYear, this.spCurPeriod);
    }

    protected void initParams2Map() {
        this.params.put("rptYear", new Integer(this.rptYear));
        this.params.put("rptPeriod", new Integer(this.rptPeriod));
        this.params.put("rptPeriodType", this.rptPeriodType);
        this.params.put("reportDate", this.reportDate);
        this.params.put("orgBound", this.orgBound);
        this.params.put("orgUnit", this.curOrgGroup);
        this.params.put("groupOrgLongNumber", this.curOrgGroup.getLongNumber());
    }

    protected void autoCopyPrePeriodInvestRate() {
        try {
            boolean success = this.IElimInvestRate.autoCopyElimInvestRatePrePeriod(this.params);
            if (success) {
                this.refresh(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initAction() {
        this.actionLocate.setVisible(false);
        this.actionLocate.setEnabled(false);
        this.actionView.setVisible(false);
        this.actionView.setEnabled(false);
    }

    protected boolean isExisElimInvestRateCurrentMonth() throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(this.reportDate.getTime())));
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)this.rptPeriodType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(this.rptPeriod)));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)this.orgBound.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.curOrgGroup.getId().toString()));
        return this.IElimInvestRate.exists(filterInfo);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.KDHistory.setIcon(EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.kDChange.setIcon(EASResource.getIcon((String)"imgTbtn_assetchange"));
        this.kDStructure.setIcon(EASResource.getIcon((String)"imgTbtn_viewbypos"));
        this.kDCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
        this.kDDistribute.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
        this.kDCreate.setIcon(EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.menuItemHistory.setIcon(EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.menuItemChange.setIcon(EASResource.getIcon((String)"imgTbtn_assetchange"));
        this.menuItemStructure.setIcon(EASResource.getIcon((String)"imgTbtn_viewbypos"));
        this.kDMenuItemCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
        this.kDMenuItemDistribute.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
        this.kDMenuItemCreate.setIcon(EASResource.getIcon((String)"imgTbtn_associatecreate"));
    }

    private void groupTableRow() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("targetCompany.name").setGroup(true);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            return;
        }
        if (this.tblMain.getSelectManager() != null && this.tblMain.getSelectManager().getActiveRowIndex() >= 0) {
            Object isLast = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("isLast").getValue();
            boolean isEnable = isLast != null && isLast instanceof Boolean && (Boolean)isLast != false;
            this.btnEdit.setEnabled(isEnable);
            this.btnRemove.setEnabled(isEnable);
        }
        super.tblMain_tableClicked(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    public boolean isAutoIgnoreZero() {
        return false;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (this.isDialogsFilter) {
            viewInfo = this.getDialog().getEntityViewInfoResult();
        }
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if (viewInfo.getFilter() == null || this.isManageMerge()) {
            viewInfo.setFilter(new FilterInfo());
        }
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        StringBuffer maskString = new StringBuffer();
        if (viewInfo.getFilter().getMaskString() != null) {
            maskString.append(viewInfo.getFilter().getMaskString());
        }
        int maskCount = viewInfo.getFilter().getFilterItems().size();
        try {
            if (!this.isDisplayIncludeHis) {
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("isLatest", (Object)1));
                if (maskCount == 0) {
                    maskString.append(" #").append(maskCount++);
                } else {
                    maskString.append(" AND #").append(maskCount++);
                }
            }
            if (this.ctx.getCurOrgBound() == null) {
                return queryExecutor;
            }
            if (!this.isDialogsFilter && this.getQuerySolutionInfo() != null && this.getQuerySolutionInfo().getName(Locale.ENGLISH) != null && this.getQuerySolutionInfo().getName(Locale.ENGLISH).equals("default Solution")) {
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("rate", (Object)new Integer(0), CompareType.NOTEQUALS));
                if (maskCount == 0) {
                    maskString.append(" #").append(maskCount++);
                } else {
                    maskString.append(" AND #").append(maskCount++);
                }
            }
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(this.ctx.getCurReportDate().getTime())));
            if (maskCount == 0) {
                maskString.append(" #").append(maskCount++);
            } else {
                maskString.append(" AND #").append(maskCount++);
            }
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)this.ctx.getCurOrgBound().getId().toString()));
            if (maskCount == 0) {
                maskString.append(" #").append(maskCount++);
            } else {
                maskString.append(" AND #").append(maskCount++);
            }
            this.builderOrgUnitFilter(viewInfo);
            if (maskCount == 0) {
                maskString.append(" #").append(maskCount++);
            } else {
                maskString.append(" AND #").append(maskCount++);
            }
            if (RptPeriodTypeEnum.MONTHLY.equals((Object)this.ctx.getCurRptPeriodType())) {
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(this.ctx.getCurRptPeriod())));
                if (maskCount == 0) {
                    maskString.append(" #").append(maskCount++);
                } else {
                    maskString.append(" AND #").append(maskCount++);
                }
            }
            viewInfo.getFilter().setMaskString(maskString.toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return queryExecutor;
    }

    protected void builderOrgUnitFilter(EntityViewInfo viewInfo) throws BOSException {
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.ctx.getCurOrgGroup().getId().toString()));
    }

    protected IIDList getSelectedKeyValues() {
        int rowNum;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length == 0) {
            return null;
        }
        HashSet<Object> set = new HashSet<Object>();
        RealModeIDList idList = new RealModeIDList();
        if (1 == selectRows.length) {
            rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cell = this.tblMain.getRow(rowNum).getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            long maxRow = this.tblMain.getRowCount();
            int i = 1;
            while ((long)i <= maxRow) {
                Object obj = this.tblMain.getRow(i - 1).getCell(this.getKeyFieldName()).getValue();
                Object company = this.tblMain.getRow(i - 1).getCell("targetCompany.name").getValue();
                if (!set.contains(company)) {
                    set.add(company);
                    idList.add(obj.toString());
                }
                ++i;
            }
        } else {
            rowNum = selectRows[0];
            for (int i = 0; i < selectRows.length; ++i) {
                ICell curCell = this.tblMain.getRow(selectRows[i]).getCell(this.getKeyFieldName());
                Object company = this.tblMain.getRow(selectRows[i]).getCell("targetCompany.name").getValue();
                if (curCell == null || curCell.getValue() == null || set.contains(company)) continue;
                idList.add(curCell.getValue().toString());
            }
        }
        idList.setCurrentIndex(rowNum);
        idList.setQuery(this.getMainQueryPK(), this.getMainQuery(), this.getQueryUuid());
        idList.setMaxRowCount(this.getMaxReturnRowCount());
        return idList;
    }

    @Override
    public void actionDistribute_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        TemplatePromptDialog dialog = null;
        Window owner = ComponentUtil.getOwnerWindow((Component)((Object)this));
        dialog = owner instanceof Frame ? new TemplatePromptDialog((Frame)owner) : new TemplatePromptDialog((Dialog)owner);
        if (1 == selectRows.length) {
            int row = this.tblMain.getSelectManager().get().getTop();
            IRow r = this.tblMain.getRow(row);
            String template = (String)r.getCell("template").getValue();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"template", (Object)template);
            dialog.setUIContext(uiContext);
        }
        QueryAgent queryAgent = new QueryAgent();
        queryAgent.setQueryInfoPK(new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.InvestTempleteQuery"));
        queryAgent.setEnabledMultiSelection(true);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        queryAgent.setSelectorCollection(sic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)0, CompareType.EQUALS));
        this.setTrackRecordCreatorFilter(filter);
        view.setFilter(filter);
        dialog.setQueryInfo(queryAgent.getQueryInfo());
        dialog.setSelectorCollection(queryAgent.getSelectorCollection());
        dialog.setQueryExecutor(queryAgent.getQueryExecutor());
        dialog.setEnabledMultiSelection(queryAgent.isEnabledMultiSelection());
        dialog.setReturnValueType(queryAgent.getReturnValueType());
        dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvest_Distribute_Template"));
        dialog.getQueryInfo().setAlias("template");
        dialog.setEntityViewInfo(view);
        dialog.show();
        Object object = dialog.getData();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tblMain.getRow(selectRows[i]);
            String id = (String)row.getCell("id").getValue();
            if (id == null) continue;
            list.add(id);
        }
        if ("cancel".equals(object) || object == null) {
            return;
        }
        if ("removeAll".equals(object)) {
            object = null;
        }
        this.IElimInvestRate.distributeTemplate(object, list);
        this.tblMain.removeRows();
    }

    private void setTrackRecordCreatorFilter(FilterInfo filterInfo) {
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)"com.kingdee.eas.fi.gr.cslrpt.client.InvestTempletListUI", null);
        }
        catch (Exception e) {
            logger.error((Object)"InvestTempletListUI.setTrackRecordCreatorFilter error: ", (Throwable)e);
        }
    }

    @Override
    public void actionChange_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"isChange", (Object)"true");
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.setActionEvent(e);
        if (this.isDoRefresh(uiWindow)) {
            this.setLocatePre(false);
            this.refresh(e);
            this.setPreSelecteRow();
            this.setLocatePre(true);
        }
    }

    @Override
    public void actionHistory_actionPerformed(ActionEvent e) throws Exception {
        this.isDisplayIncludeHis = !this.isDisplayIncludeHis;
        this.KDHistory.setText(this.isDisplayIncludeHis ? this.displayNew : this.displayHis);
        this.KDHistory.setToolTipText(this.isDisplayIncludeHis ? this.displayNew : this.displayHis);
        this.menuItemHistory.setText(this.isDisplayIncludeHis ? this.displayNew : this.displayHis);
        this.mainQuery = new EntityViewInfo();
        this.refresh(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            int[] selectedRows;
            HashMap<String, Object> param = new HashMap<String, Object>();
            ArrayList<String> selectIdList = new ArrayList<String>();
            ArrayList<String> ids = new ArrayList<String>();
            for (int rowIndex : selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain)) {
                IRow r = this.tblMain.getRow(rowIndex);
                if (r == null) continue;
                String id = (String)r.getCell("id").getValue();
                this.setOprtState("REMOVE");
                try {
                    this.pubFireVOChangeListener(id);
                }
                catch (Throwable e1) {
                    this.handUIException(e1);
                    this.abort();
                }
                finally {
                    try {
                        this.setOprtState("RELEASEALL");
                        this.pubFireVOChangeListener(id);
                    }
                    catch (Throwable e1) {
                        this.handUIException(e1);
                    }
                }
                selectIdList.add(id);
                if (r.getCell("rate").getValue() != null && !((BigDecimal)r.getCell("rate").getValue()).equals(BigDecimal.ZERO)) continue;
                ids.add((String)r.getCell("id").getValue());
            }
            if (!ids.isEmpty()) {
                Map<String, ElimInvestRateInfo> existHisInvestRates = CslRptUIUtil.getExistHisInvestRates(ids);
                if (existHisInvestRates != null && !existHisInvestRates.isEmpty()) {
                    MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"existHisRateCantDel"), existHisInvestRates.values().iterator().next().getCompany().getName()));
                    SysUtil.abort();
                }
                ids.clear();
            }
            param.put("selectIdList", selectIdList);
            param.put("orgBoundId", this.orgBound.getId().toString());
            param.put("reportDate", this.reportDate);
            param.put("orgUnit", this.curOrgGroup);
            param.put("rptPeriod", new Integer(this.rptPeriod));
            param.put("rptPeriodType", this.rptPeriodType);
            this.IElimInvestRate.deleteElimInvestRate(param);
            this.refresh(e);
        }
        this.tblMain.removeRows();
    }

    @Override
    public void actionStructure_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ElimInvestRateStructureUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        try {
            if (this.isExisElimInvestRateCurrentMonth()) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"MONTH_ELIMINVESTRATE_EXIS")))) {
                    this.IElimInvestRate.copyElimInvestRatePrePeriod(this.params);
                }
            } else {
                this.IElimInvestRate.copyElimInvestRatePrePeriod(this.params);
            }
            this.tblMain.removeRows();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    @Override
    public void actionCreate_actionPerformed(ActionEvent e) throws Exception {
        if (this.isExisElimInvestRateCurrentMonth()) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"GENERATE_ELIMINVESTRATE_EXIS")))) {
                this.IElimInvestRate.generateElimInvestRate(this.params);
            }
        } else {
            this.IElimInvestRate.generateElimInvestRate(this.params);
        }
        this.tblMain.removeRows();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.isManageMerge()) {
            super.actionQuery_actionPerformed(e);
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            String queryName = this.mainQueryPK.getFullName();
            CommonQueryDialog dialogs = this.getDialog();
            if (dialogs == null) {
                dialogs = this.initCommonQueryDialog();
            } else if (this.getUIWindow() == null) {
                dialogs.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                dialogs.setOwner((Component)((Object)this));
            }
            if (!this.isPerformDefaultQuery(iQuery, queryName) && !this.isFirstDefaultQuery()) {
                if (dialogs.show()) {
                    this.isDialogsFilter = true;
                    this.mainQuery = dialogs.getEntityViewInfoResult();
                    this.tblMain.removeRows();
                    this.groupTableRow();
                } else {
                    SysUtil.abort();
                }
            }
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        dlg.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"elimInvestRateQueryTitle"));
        dlg.setWidth(400);
        dlg.setHeight(300);
        dlg.setShowFilter(false);
        dlg.setShowSorter(false);
        CustomerQueryPanel queryPanel = null;
        try {
            queryPanel = this.isManageMerge() ? new MgMergeElimInvestRateFilterUI() : new ElimInvestRateQueryUI();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        dlg.addUserPanel((KDPanel)queryPanel);
        return dlg;
    }

    public boolean isManageMerge() {
        return false;
    }

    @Override
    public void actionCalEquivShareRate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Map notice = ElimInvestRateFactory.getRemoteInstance().calEquivShareRate(idList, this.params);
        if (notice != null && notice.get("report") != null) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"461_ElimInvestRateListUI"), (String)notice.get("report").toString(), (int)0);
        }
        this.refreshList();
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    protected String getEditUIName() {
        return ElimInvestRateEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ElimInvestRateFactory.getRemoteInstance();
    }

    @Override
    public void update(Observable observable, Object obj) {
        CSLContextHelper.update(observable, (CoreUI)this);
    }

    protected void initCslContext() {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
    }

    protected ArrayList getImportParam() {
        String solutionName = "eas.fi.gr.elimInvestRate";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = this.getUITitle();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        this.putContext(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        String solutionName = "eas.fi.gr.elimInvestRate";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = this.getUITitle();
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        this.putContext(param);
        return paramList;
    }

    protected void putContext(DatataskParameter param) {
        try {
            param.putContextParam((Object)"rptYear", (Object)this.ctx.getCurRptYear());
            param.putContextParam((Object)"rptPeriod", (Object)this.ctx.getCurRptPeriod());
            param.putContextParam((Object)"rptPeriodType", (Object)this.ctx.getCurRptPeriodType());
            param.putContextParam((Object)"reportDate", (Object)this.ctx.getCurReportDate());
            param.putContextParam((Object)"orgBound", (Object)this.ctx.getCurOrgBound());
            param.putContextParam((Object)"orgUnit", (Object)this.ctx.getCurOrgGroup());
        }
        catch (Exception e) {
            logger.error((Object)"putContext error", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void actionSetClearingCompany_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ElimInvestRateFactory.getRemoteInstance().setClearingCompanyFlag(this.getSelectedIdValues());
        this.refreshList();
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        int firstIndex = e.getFirstRow();
        int lastIndex = e.getLastRow();
        for (int r = firstIndex; r <= lastIndex; ++r) {
            IRow row = this.tblMain.getRow(r);
            if (row.getCell("isClearCompany").getValue() == null || !((Boolean)row.getCell("isClearCompany").getValue()).booleanValue()) continue;
            row.getStyleAttributes().setBackground(Color.PINK);
        }
    }

    @Override
    public void actionCreateAndCal_actionPerformed(ActionEvent e) throws Exception {
        this.initParameter();
        this.initParams2Map();
        if (this.isExisElimInvestRateCurrentMonth()) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"GENERATE_ELIMINVESTRATE_EXIS")))) {
                this.IElimInvestRate.createAndCalculateElimInvestRate(this.params);
            }
        } else {
            this.IElimInvestRate.createAndCalculateElimInvestRate(this.params);
        }
        this.actionRefresh_actionPerformed(e);
    }

    private void initParameter() throws BOSException {
        this.rptYear = this.ctx.getCurRptYear();
        this.rptPeriodType = this.ctx.getCurRptPeriodType();
        this.rptPeriod = this.ctx.getCurRptPeriod();
        this.reportDate = this.ctx.getCurReportDate();
        this.orgBound = this.ctx.getCurOrgBound();
        this.curOrgGroup = this.ctx.getCurOrgGroup();
    }

    @Override
    public void actionShowCalcLog_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.ShowElimInvestRateCalcLogUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }
}

