/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.fi.gr.cslrpt.IElimTemplet;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationMode;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractElimTempletGnlEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaSelector;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NameExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class ElimTempletGnlEditUI
extends AbstractElimTempletGnlEditUI {
    private static final Logger logger = Logger.getLogger(ElimTempletGnlEditUI.class);
    private static final String TB_ID = "id";
    private static final String TB_SUMMARY = "summary";
    private static final String TB_ITEM_NUMBER = "itemNumber";
    private static final String TB_ITEM_NAME = "itemName";
    private static final String TB_DATAELEMENT = "dataElement";
    private static final String TB_DC = "DC";
    private static final String TB_DEBITFORMULA = "debitFormula";
    private static final String TB_CREDITFORMULA = "creditFormula";
    private static final String TB_DATA_SRC_TYPE = "dataSrcType";
    private IDataElement iDataElement = null;
    String resName = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Adjust_DebitAndCredit";
    private CslRptUIUtil cslRptUIUtil;

    public ElimTempletGnlEditUI() throws Exception {
        if (this.iDataElement == null) {
            this.iDataElement = DataElementFactory.getRemoteInstance();
        }
        this.initHeadData();
        this.initEntryTable();
        this.btnAddBatch.setIcon(EASResource.getIcon((String)"imgTbtn_newbatch"));
        this.actionAddBatch.setEnabled(true);
        this.menuAddBatch.setIcon(EASResource.getIcon((String)"imgTbtn_newbatch"));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData == null) {
            return;
        }
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.comboIsCitedByLater.setSelectedIndex(0);
        }
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            ElimTempletEntryInfo entryInfo = this.editData.getEntries().get(i);
            this.loadEntries(this.kdtEntries, row, (IObjectValue)entryInfo);
        }
        try {
            if (this.getOprtState().equals(OprtState.ADDNEW) && this.getUIContext().get("isCopy") == null || this.kdtEntries.getRowCount() == 0) {
                this.actionAddLine_actionPerformed(null);
                this.actionAddLine_actionPerformed(null);
            } else if (this.getUIContext().get("isCopy") != null) {
                this.getUIContext().remove("isCopy");
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.showEditBtnByCreateOrg();
        if (this.editData.getEliminationMode() != null) {
            for (int i = 0; i < this.comboElimMode.getItemCount(); ++i) {
                EliminationModeInfo elimMode = (EliminationModeInfo)this.comboElimMode.getItemAt(i);
                if (elimMode == null || !this.editData.getEliminationMode().getId().equals((Object)elimMode.getId())) continue;
                this.comboElimMode.setSelectedIndex(i);
                break;
            }
        }
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.initBizActionStatus();
        }
    }

    private void loadEntries(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        ElimTempletEntryInfo lineInfo = (ElimTempletEntryInfo)obj;
        row.getCell(TB_SUMMARY).setValue((Object)lineInfo.getSummary());
        row.getCell(TB_ITEM_NUMBER).setValue((Object)(lineInfo.getItem() == null ? null : lineInfo.getItem()));
        row.getCell(TB_ITEM_NAME).setValue(lineInfo.getItem() == null ? null : lineInfo.getItem().getName());
        row.getCell(TB_DATA_SRC_TYPE).setValue((Object)lineInfo.getDataSrcType());
        row.getCell(TB_DC).setValue((Object)lineInfo.getDC());
        row.getCell(TB_DEBITFORMULA).setValue((Object)lineInfo.getDebitFormula());
        row.getCell(TB_CREDITFORMULA).setValue((Object)lineInfo.getCreditFormula());
        if (DataSrcTypeEnum.DIFF.equals((Object)lineInfo.getDataSrcType())) {
            row.getCell(TB_DEBITFORMULA).getStyleAttributes().setLocked(true);
            row.getCell(TB_CREDITFORMULA).getStyleAttributes().setLocked(true);
        }
        try {
            row.getCell(TB_DATAELEMENT).setValue((Object)this.iDataElement.getDataElementByInterSeq(lineInfo.getDataElement()));
        }
        catch (EASBizException e) {
            logger.error((Object)"getDataElementByInterSeq_EASBizException", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"getDataElementByInterSeq_BOSException", (Throwable)e);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk;
        IElimTemplet iElimTemplet;
        if (this.oprtState == OprtState.EDIT && (iElimTemplet = (IElimTemplet)this.getBizInterface()).getElimTempletInfo((IObjectPK)(pk = new ObjectUuidPK(this.editData.getId()))) != null && iElimTemplet.getElimTempletInfo((IObjectPK)pk).getCheckedStatus() == CheckedStatusEnum.AUDITED) {
            throw new AdjustException(AdjustException.HAVE_AUDITED);
        }
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            String summ;
            if (this.kdtEntries.getRow(i).getCell(1).getValue() == null || (summ = this.kdtEntries.getRow(i).getCell(1).getValue().toString()).length() <= 399) continue;
            this.kdtEntries.getRow(i).getCell(1).setValue((Object)summ.substring(0, 398));
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        ElimTempletEntryInfo lineInfo = (ElimTempletEntryInfo)obj;
        row.getCell(TB_SUMMARY).setValue((Object)lineInfo.getSummary());
        row.getCell(TB_ITEM_NUMBER).setValue((Object)(lineInfo.getItem() == null ? null : lineInfo.getItem()));
        row.getCell(TB_ITEM_NAME).setValue(lineInfo.getItem() == null ? null : lineInfo.getItem().getName(this.getCurrentLocale()));
        row.getCell(TB_DATA_SRC_TYPE).setValue((Object)lineInfo.getDataSrcType());
        row.getCell(TB_DC).setValue((Object)lineInfo.getDC());
        row.getCell(TB_DEBITFORMULA).setValue((Object)lineInfo.getDebitFormula());
        row.getCell(TB_CREDITFORMULA).setValue((Object)lineInfo.getCreditFormula());
        try {
            row.getCell(TB_DATAELEMENT).setValue((Object)this.iDataElement.getDataElementByInterSeq(lineInfo.getDataElement()));
        }
        catch (EASBizException e) {
            logger.error((Object)"getDataElementByInterSeq_EASBizException", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"getDataElementByInterSeq_BOSException", (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        this.addCreatrOrg();
        this.editData.copyNewToOld();
        super.storeFields();
        if (this.editData == null) {
            return;
        }
        this.editData.setSyncOldValue(true);
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            ElimTempletEntryInfo entryInfo = this.editData.getEntries().get(i);
            this.storeEntries(this.kdtEntries, row, (IObjectValue)entryInfo);
        }
        this.editData.setSyncOldValue(false);
    }

    private void addCreatrOrg() {
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
    }

    private void storeEntries(KDTable table, IRow row, IObjectValue obj) {
        ElimTempletEntryInfo lineInfo = (ElimTempletEntryInfo)obj;
        lineInfo.setSummary(row.getCell(TB_SUMMARY).getValue() == null ? null : row.getCell(TB_SUMMARY).getValue().toString());
        if (row.getCell(TB_ITEM_NUMBER).getValue() instanceof RPTItemInfo) {
            lineInfo.setItem((RPTItemInfo)row.getCell(TB_ITEM_NUMBER).getValue());
        } else {
            row.getCell(TB_ITEM_NUMBER).setValue(null);
        }
        lineInfo.setDataSrcType((DataSrcTypeEnum)((Object)row.getCell(TB_DATA_SRC_TYPE).getValue()));
        lineInfo.setDC((DebitOrCreditEnum)((Object)row.getCell(TB_DC).getValue()));
        lineInfo.setDebitFormula(row.getCell(TB_DEBITFORMULA).getValue() == null ? null : row.getCell(TB_DEBITFORMULA).getValue().toString());
        lineInfo.setCreditFormula(row.getCell(TB_CREDITFORMULA).getValue() == null ? null : row.getCell(TB_CREDITFORMULA).getValue().toString());
        lineInfo.setDataElement(((DataElementInfo)row.getCell(TB_DATAELEMENT).getValue()).getInterSeq());
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        ElimTempletEntryInfo lineInfo = new ElimTempletEntryInfo();
        lineInfo.setDataElement(4);
        lineInfo.setDataSrcType(DataSrcTypeEnum.AUTO);
        return lineInfo;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    private void initHeadData() throws BOSException {
        this.comboElimType.removeItem((Object)ElimTypeEnum.exchange);
        this.comboElimType.removeItem((Object)ElimTypeEnum.ComeAndGo);
        this.comboElimType.removeItem((Object)ElimTypeEnum.MAIN_INVEST);
        this.comboElimType.removeItem((Object)ElimTypeEnum.HK_COST);
        this.comboElimType.removeItem((Object)ElimTypeEnum.MAIN_COST);
        this.comboElimType.removeItem((Object)ElimTypeEnum.Main_Invest_New);
        this.comboElimType.setSelectedItem((Object)ElimTypeEnum.General);
        this.comboElimType.setReadOnly(true);
        this.comboElimMode.addItem((Object)new EliminationModeInfo());
        IEliminationMode iElimMode = EliminationModeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo(TB_ID));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        try {
            CslGradeManageUtil.filterElimModeGradeManage((EntityViewInfo)viewInfo, null);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        EliminationModeCollection collection = iElimMode.getEliminationModeCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                this.comboElimMode.addItem((Object)collection.get(i));
            }
        }
    }

    protected IObjectValue createNewData() {
        ElimTempletInfo templetInfo = new ElimTempletInfo();
        templetInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        templetInfo.setElimType(ElimTypeEnum.General);
        templetInfo.setValueType(ValueTypeEnum.MONEY);
        return templetInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ElimTempletFactory.getRemoteInstance();
    }

    private void initEntryTable() throws Exception {
        this.kdtEntries.checkParsed();
        KDPromptBox prmtBoxD = new KDPromptBox();
        prmtBoxD.setSelector((KDPromptSelector)new FormulaSelector((CoreUIObject)this, 3));
        prmtBoxD.setEditable(true);
        KDTDefaultCellEditor formulaEditorD = new KDTDefaultCellEditor((IKDEditor)prmtBoxD);
        this.getDetailTable().getColumn(TB_DEBITFORMULA).setEditor((ICellEditor)formulaEditorD);
        KDPromptBox prmtBoxC = new KDPromptBox();
        prmtBoxC.setSelector((KDPromptSelector)new FormulaSelector((CoreUIObject)this, 3));
        prmtBoxC.setEditable(true);
        KDTDefaultCellEditor formulaEditorC = new KDTDefaultCellEditor((IKDEditor)prmtBoxC);
        this.getDetailTable().getColumn(TB_CREDITFORMULA).setEditor((ICellEditor)formulaEditorC);
        KDBizPromptBox bizBoxDataElement = new KDBizPromptBox();
        bizBoxDataElement.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        bizBoxDataElement.setEditFormat("$number$");
        bizBoxDataElement.setDisplayFormat("$number$");
        bizBoxDataElement.setEditable(true);
        bizBoxDataElement.setCommitFormat("$number$");
        CslGradeManageUtil.setDataElementF7GMFilter((KDBizPromptBox)bizBoxDataElement, null, (boolean)false);
        this.kdtEntries.getColumn(TB_DATAELEMENT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBoxDataElement));
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)bizBoxItem);
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
        bizBoxItem.setEditFormat("$number$");
        bizBoxItem.setDisplayFormat("$number$");
        bizBoxItem.setEditable(true);
        bizBoxItem.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)bizBoxItem, null);
        this.getDetailTable().getColumn(TB_ITEM_NUMBER).setEditor((ICellEditor)itemEditor);
        KDComboBox cmDataSrcType = new KDComboBox();
        cmDataSrcType.addItems(DataSrcTypeEnum.getEnumList().toArray());
        this.kdtEntries.getColumn(TB_DATA_SRC_TYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmDataSrcType));
        KDComboBox cmbDC = new KDComboBox();
        cmbDC.addItem((Object)DebitOrCreditEnum.DEBIT);
        cmbDC.addItem((Object)DebitOrCreditEnum.CREDIT);
        this.kdtEntries.getColumn(TB_DC).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDC));
        this.kdtEntries.getColumn(TB_DC).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_DC).getStyleAttributes().setHided(true);
        this.kdtEntries.getColumn(TB_ITEM_NAME).getStyleAttributes().setLocked(true);
        this.kdtEntries.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
                ElimTempletGnlEditUI.this.tableValueChanged(e);
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                ElimTempletGnlEditUI.this.tableValueChanged(e);
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.kdtEntries.setBeforeAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                if (e.getType() == 5) {
                    e.setCancel(true);
                }
            }
        });
        this.kdtEntries.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                ElimTempletGnlEditUI.this.fillFormula(e);
            }
        });
    }

    private void fillFormula(KDTActiveCellEvent e) {
        int rowIndex = e.getRowIndex();
        if (rowIndex > this.kdtEntries.getRowCount() || rowIndex < 0) {
            return;
        }
        this.putClientProperty("clientProperty_formula_debit", null);
        this.putClientProperty("clientProperty_formula_credit", null);
        int colIndex = e.getColumnIndex();
        Object formulaObj = this.kdtEntries.getRow(rowIndex).getCell(colIndex).getValue();
        if (formulaObj != null && formulaObj.toString().trim().length() > 0) {
            this.putClientProperty("clientProperty_formula_credit", formulaObj.toString());
        }
    }

    private void tableValueChanged(KDTEditEvent e) {
        int selectRow = e.getRowIndex();
        KDTable kdtEntry = (KDTable)e.getSource();
        IRow row = this.kdtEntries.getRow(selectRow);
        if (e.getColIndex() == row.getCell(TB_ITEM_NUMBER).getColumnIndex() && e.getValue() != null && e.getOldValue() != e.getValue()) {
            kdtEntry.getRow(selectRow).getCell(TB_CREDITFORMULA).setValue(null);
            kdtEntry.getRow(selectRow).getCell(TB_DEBITFORMULA).setValue(null);
            RPTItemInfo rptItem = (RPTItemInfo)e.getValue();
            DebitOrCreditEnum dc = rptItem.getDc();
            DebitOrCreditEnum dc_new = null;
            if (dc == DebitOrCreditEnum.CREDIT) {
                dc_new = DebitOrCreditEnum.DEBIT;
            } else if (dc == DebitOrCreditEnum.DEBIT) {
                dc_new = DebitOrCreditEnum.CREDIT;
            }
            kdtEntry.getRow(selectRow).getCell(TB_ITEM_NAME).setValue((Object)rptItem.getName(this.getCurrentLocale()));
            kdtEntry.getRow(selectRow).getCell(TB_DC).setValue((Object)dc_new);
            try {
                IRPTItem ir = RPTItemFactory.getRemoteInstance();
                DataElementInfo dataElement = ir.getReportClassDataElement(rptItem.getId().toString());
                if (dataElement == null) {
                    dataElement = DataElementProvider.getDataElementInfo("ENDBALANCE");
                    row.getCell(TB_DATAELEMENT).setValue((Object)dataElement);
                } else {
                    row.getCell(TB_DATAELEMENT).setValue((Object)dataElement);
                }
            }
            catch (BOSException e1) {
                logger.error((Object)"getDataElementInfo_BOSException", (Throwable)e1);
            }
            catch (EASBizException e2) {
                logger.error((Object)"getDataElementInfo_EASBizException", (Throwable)e2);
            }
        }
        if (e.getColIndex() == row.getCell(TB_DEBITFORMULA).getColumnIndex() || e.getColIndex() == row.getCell(TB_CREDITFORMULA).getColumnIndex()) {
            Object formulaObj;
            Object debitFormula = row.getCell(TB_DEBITFORMULA).getValue();
            Object creditFormula = row.getCell(TB_CREDITFORMULA).getValue();
            if (debitFormula != null && creditFormula != null && debitFormula.toString().trim() != null && creditFormula.toString().trim() != null) {
                row.getCell(TB_DEBITFORMULA).setValue(null);
                row.getCell(TB_CREDITFORMULA).setValue(null);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resName));
                return;
            }
            if (debitFormula != null && debitFormula.toString().length() != 0) {
                try {
                    this.checkFormulaFormat(debitFormula.toString());
                    kdtEntry.getRow(selectRow).getCell(TB_DC).setValue((Object)DebitOrCreditEnum.DEBIT);
                }
                catch (CheckFormulaException e1) {
                    row.getCell(TB_DEBITFORMULA).setValue(null);
                    super.handleException((Exception)((Object)e1));
                }
            }
            if (creditFormula != null && creditFormula.toString().length() != 0) {
                try {
                    this.checkFormulaFormat(creditFormula.toString());
                    kdtEntry.getRow(selectRow).getCell(TB_DC).setValue((Object)DebitOrCreditEnum.CREDIT);
                }
                catch (CheckFormulaException e1) {
                    row.getCell(TB_CREDITFORMULA).setValue(null);
                    super.handleException((Exception)((Object)e1));
                }
            }
            if ((formulaObj = this.kdtEntries.getRow(selectRow).getCell(e.getColIndex()).getValue()) != null && formulaObj.toString().trim().length() > 0) {
                this.putClientProperty("clientProperty_formula_credit", formulaObj.toString());
            } else {
                this.putClientProperty("clientProperty_formula_credit", null);
            }
        }
        if (DataSrcTypeEnum.DIFF.equals(row.getCell(TB_DATA_SRC_TYPE).getValue())) {
            row.getCell(TB_DEBITFORMULA).getStyleAttributes().setLocked(true);
            row.getCell(TB_CREDITFORMULA).getStyleAttributes().setLocked(true);
            row.getCell(TB_DEBITFORMULA).setValue(null);
            row.getCell(TB_CREDITFORMULA).setValue(null);
        } else {
            row.getCell(TB_DEBITFORMULA).getStyleAttributes().setLocked(false);
            row.getCell(TB_CREDITFORMULA).getStyleAttributes().setLocked(false);
        }
    }

    private void checkFormulaFormat(String formulaString) throws CheckFormulaException {
        Expression expr;
        try {
            expr = ExcelFormulaPaserHelper.parse((String)formulaString);
        }
        catch (Exception e) {
            throw new CheckFormulaException(CheckFormulaException.ACCTITEMFORMULA_FORMAT_ERROR);
        }
        this.checkFormulaExpression(expr);
    }

    private void checkFormulaExpression(Expression expression) throws CheckFormulaException {
        if (expression instanceof FunctionExpr) {
            String funName = ((FunctionExpr)expression).funcionName;
            FunctionExpr expr = (FunctionExpr)expression;
            String pattern = "^[+-]?\\d+(\\.\\d+)?$|^([+-]?(AcctItem|ESP|InvData|ElimData|ElimRpt|EqtData|IF|Round)\\([^\\s^\\)]{1,}\\))+$|[+-][0-9]+(\\.[0-9]{1,4})?$";
            Pattern patt = Pattern.compile(pattern.toUpperCase());
            Matcher matcher = patt.matcher(funName);
            if (!matcher.find()) {
                throw new CheckFormulaException(CheckFormulaException.ACCTITEMFORMULA_FORMAT_ERROR);
            }
        } else if (expression instanceof BinaryOperationExpr) {
            Expression expr = ((BinaryOperationExpr)expression).left;
            this.checkFormulaExpression(expr);
            expr = ((BinaryOperationExpr)expression).right;
            this.checkFormulaExpression(expr);
        } else if (expression instanceof UnaryOperationExpr) {
            Expression expr = ((UnaryOperationExpr)expression).operand;
            this.checkFormulaExpression(expr);
        } else if (expression instanceof NameExpr) {
            throw new CheckFormulaException(CheckFormulaException.ACCTITEMFORMULA_FORMAT_ERROR);
        }
    }

    private void checkFormulaFormat2(String formulaString) throws CheckFormulaException {
        String pattern = "^[+-]?\\d+(\\.\\d+)?$|^([+-]?(AcctItem|ESP|InvData|ElimData|ElimRpt|EqtData)\\([^\\s^\\)]{1,}\\))+$|[+-][0-9]+(\\.[0-9]{1,4})?$";
        Pattern patt = Pattern.compile(pattern);
        String[] level1 = formulaString.split("\\+");
        for (int i = 0; i < level1.length; ++i) {
            List<String> level2Substract = this.splitBySubtract(level1[i], 0);
            String[] level2 = new String[level2Substract.size()];
            level2Substract.toArray(level2);
            for (int j = 0; j < level2.length; ++j) {
                String[] level3 = level2[j].split("\\*");
                for (int k = 0; k < level3.length; ++k) {
                    String[] level4 = level3[k].split("\\/");
                    for (int k2 = 0; k2 < level4.length; ++k2) {
                        Matcher matcher = patt.matcher(level4[k2]);
                        if (matcher.find()) continue;
                        throw new CheckFormulaException(CheckFormulaException.ACCTITEMFORMULA_FORMAT_ERROR);
                    }
                }
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.hideUnuseableButtons();
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
            this.txtNumber.setEditable(false);
            this.txtName.setEditable(false);
            this.comboValueType.setEditable(false);
            this.setEntriesLocked(true);
            if (this.editData.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
                this.btnEdit.setEnabled(false);
                this.actionEdit.setEnabled(false);
            }
        } else {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
            this.btnEdit.setEnabled(false);
        }
        this.initRowMoveListener();
    }

    private void initRowMoveListener() {
        final KDTableMoveAction rowMoveAction = new KDTableMoveAction(this.kdtEntries);
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToHead();
            }
        });
        this.btnMoveBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToTail();
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        for (int i = 0; i < this.comboValueType.getItemCount(); ++i) {
            ValueTypeEnum value = (ValueTypeEnum)((Object)this.comboValueType.getItemAt(i));
            if (value.getValue() != 3) continue;
            this.comboValueType.removeItem(this.comboValueType.getItemAt(i));
        }
        this.menuBiz.setVisible(false);
    }

    protected void hideUnuseableButtons() {
        this.btnSave.setVisible(false);
        this.actionSave.setEnabled(false);
        this.menuItemSave.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.menuItemCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.menuItemCopyFrom.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.actionCopyFrom.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.btnCancel.setVisible(false);
        this.actionCancel.setEnabled(false);
        this.btnCancelCancel.setVisible(false);
        this.actionCancelCancel.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.btnNextPerson.setVisible(false);
        this.menuItemNextPerson.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.btnMultiapprove.setVisible(false);
        this.menuItemMultiapprove.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.menuSubmitOption.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo(TB_ID));
        sic.add(new SelectorItemInfo("entries.item.*"));
        sic.add(new SelectorItemInfo("CheckedStatus"));
        sic.add(new SelectorItemInfo("trackRecordCreator"));
        sic.add(new SelectorItemInfo("entries.dataElement"));
        return sic;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int debitDiffCount = 0;
        int creditDiffCount = 0;
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().equals("")) {
            throw new AdjustException(AdjustException.NUMBER_BLANK);
        }
        if (this.editData.getName() == null || this.editData.getName().trim().equals("")) {
            throw new AdjustException(AdjustException.NAME_BLANK);
        }
        if (this.editData.getEntries() == null || this.editData.getEntries().size() == 0) {
            throw new AdjustException(AdjustException.LINE_NOT_EXIST);
        }
        ElimTempletEntryCollection col = this.editData.getEntries();
        for (int i = 0; i < col.size(); ++i) {
            ElimTempletEntryInfo info = col.get(i);
            if (DataSrcTypeEnum.DIFF.equals((Object)info.getDataSrcType()) && DebitOrCreditEnum.CREDIT.equals((Object)info.getDC())) {
                ++creditDiffCount;
            }
            if (DataSrcTypeEnum.DIFF.equals((Object)info.getDataSrcType()) && DebitOrCreditEnum.DEBIT.equals((Object)info.getDC())) {
                ++debitDiffCount;
            }
            if (info.getDebitFormula() != null && info.getDebitFormula().length() > 2000) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustTemplet_TooLongDebitFormula")), new Object[]{new Integer(i + 1)});
            }
            if (info.getCreditFormula() != null && info.getCreditFormula().length() > 2000) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustTemplet_TooLongCreditFormula")), new Object[]{new Integer(i + 1)});
            }
            if (debitDiffCount <= 1 && creditDiffCount <= 1) continue;
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"elimTEntryDiffMuch")));
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setUITitle(this.getUITitle().split("-")[0] + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        this.setEntriesLocked(false);
        this.txtNumber.setEditable(true);
        this.txtName.setEditable(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setEntriesLocked(false);
        this.txtNumber.setEditable(true);
        this.txtName.setEditable(true);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("isCopy", "isCopy");
        super.actionCopy_actionPerformed(e);
        this.setEntriesLocked(false);
        this.txtNumber.setText(null);
        if (this.getEditData() != null) {
            ((ElimTempletInfo)this.getEditData()).setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            ((ElimTempletInfo)this.getEditData()).setAuditDate(null);
            ((ElimTempletInfo)this.getEditData()).setAuditor(null);
        }
    }

    private void setEntriesLocked(boolean locked) {
        this.kdtEntries.getColumn(TB_DATAELEMENT).getStyleAttributes().setLocked(locked);
        this.kdtEntries.getColumn(TB_CREDITFORMULA).getStyleAttributes().setLocked(locked);
        this.kdtEntries.getColumn(TB_DEBITFORMULA).getStyleAttributes().setLocked(locked);
        this.kdtEntries.getColumn(TB_SUMMARY).getStyleAttributes().setLocked(locked);
        this.kdtEntries.getColumn(TB_ITEM_NUMBER).getStyleAttributes().setLocked(locked);
    }

    private void initBizActionStatus() {
        boolean isNotAudited = null == this.editData || !CheckedStatusEnum.AUDITED.equals((Object)this.editData.getCheckedStatus());
        this.btnEdit.setEnabled(isNotAudited);
        this.actionEdit.setEnabled(isNotAudited);
        this.actionRemove.setEnabled(isNotAudited);
    }

    @Override
    public void actionAddBatch_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddBatch_actionPerformed(e);
        this.getCslRptUIUtilInstance().addBatchRptItem((IUIObject)this, this.kdtEntries, TB_DATAELEMENT);
    }

    private CslRptUIUtil getCslRptUIUtilInstance() {
        if (this.cslRptUIUtil == null) {
            this.cslRptUIUtil = new CslRptUIUtil();
        }
        return this.cslRptUIUtil;
    }

    protected BOSObjectType getBOSObjectType() {
        return null;
    }

    private List<String> splitBySubtract(String srcStr, int startIndex) {
        ArrayList<String> al = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)srcStr)) {
            int index = srcStr.indexOf("-", startIndex);
            if (index <= 0) {
                al.add(srcStr);
                return al;
            }
            int curChar = 32;
            boolean isSubtract = false;
            for (int curIndex = index; curIndex > 0; --curIndex) {
                curChar = srcStr.charAt(curIndex - 1);
                if (curChar == 32) continue;
                isSubtract = curChar != 44;
                break;
            }
            if (isSubtract) {
                al.add(srcStr.substring(0, index));
                al.addAll(this.splitBySubtract(srcStr.substring(index), 0));
            } else {
                al.addAll(this.splitBySubtract(srcStr, index + 1));
            }
        } else {
            al.add(srcStr);
        }
        return al;
    }
}

