/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimTemplet;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractElimTempletImportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElimTempletImportUI
extends AbstractElimTempletImportUI {
    private static final Logger logger = Logger.getLogger(ElimTempletImportUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.checkBoxShow.setVisible(false);
        this.init();
        this.btnLocation.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.initTxtLocation();
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void init() throws BOSException {
        ElimTempletCollection templetCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("CheckedStatus", (Object)new Integer(2), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        Map uiContext = this.getUIContext();
        boolean hasTemplate = false;
        Map params = (Map)uiContext.get("params");
        boolean isFromMerge = false;
        if (params != null && params.containsKey("isFromMerge")) {
            isFromMerge = (Boolean)params.get("isFromMerge");
        }
        boolean isCommonElimTemp = false;
        if (params != null) {
            if (isFromMerge) {
                HashSet<Integer> elimTypeSet = new HashSet<Integer>(2);
                elimTypeSet.add(new Integer(1));
                elimTypeSet.add(new Integer(3));
                filterItem = new FilterItemInfo("elimType", elimTypeSet, CompareType.INCLUDE);
                filter.getFilterItems().add(filterItem);
                hasTemplate = true;
            } else {
                int elimtype = ((ElimTypeEnum)((Object)params.get("elimType"))).getValue();
                if (elimtype == 1) {
                    filterItem = new FilterItemInfo("elimType", (Object)new Integer(1));
                    filter.getFilterItems().add(filterItem);
                    hasTemplate = true;
                } else if (elimtype == 3) {
                    filterItem = new FilterItemInfo("elimType", (Object)new Integer(3));
                    filter.getFilterItems().add(filterItem);
                    hasTemplate = true;
                }
            }
        } else {
            filterItem = new FilterItemInfo("elimType", (Object)new Integer(2));
            filter.getFilterItems().add(filterItem);
            isCommonElimTemp = true;
        }
        String unitID = "";
        if (isFromMerge && params.get("orgUnitId") != null) {
            unitID = params.get("orgUnitId").toString();
        } else if (CSLContextHelper.getCSLContext().getCurOrgGroup() != null) {
            unitID = CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString();
        }
        if (uiContext.get("cslCtx") != null) {
            ICSLContext cslCtx = (ICSLContext)uiContext.get("cslCtx");
            unitID = cslCtx.getCurOrgGroup().getId().toString();
        }
        if (isCommonElimTemp) {
            filterItem = new FilterItemInfo("id", (Object)("select FDispenseSrcID from T_CSL_AdjustAndElimDispense where FSourceType = 2 and FCompanyID = '" + unitID + "'"), CompareType.INNER);
            filter.getFilterItems().add(filterItem);
        }
        if (hasTemplate) {
            String boolStr = uiContext.get("isByCompany").toString();
            boolean bool = false;
            if (boolStr != null && "true".equals(boolStr)) {
                bool = true;
            }
            String treeId = null;
            if (isFromMerge && params.containsKey("orgTreeId")) {
                treeId = (String)params.get("orgTreeId");
                filterItem = new FilterItemInfo("id", (Object)("select fid from T_CSL_ElimTemplet where FCheckedStatus= 2 and FElimType in (1,3) and felimGroupId in (select fid from T_CSL_ElimTempletGroup where fid in (select fdispensesrcid from T_CSL_TempletDispense where forgBoundID = '" + treeId + "' and fsourceType = 2))"), CompareType.INNER);
            } else {
                if (!bool && CSLContextHelper.getCSLContext().getCurOrgBound() != null) {
                    treeId = CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString();
                } else {
                    try {
                        treeId = params.get("orgTreeId") == null ? this.getBasicTree().getId().toString() : params.get("orgTreeId").toString();
                    }
                    catch (EASBizException e1) {
                        logger.error((Object)"getCurOrgBound()_EASBizException", (Throwable)e1);
                    }
                }
                int elimtype = ((ElimTypeEnum)((Object)params.get("elimType"))).getValue();
                filterItem = new FilterItemInfo("id", (Object)("select fid from T_CSL_ElimTemplet where FCheckedStatus= 2 and FElimType=" + elimtype + " and felimGroupId in (select fid from T_CSL_ElimTempletGroup where fid in (select fdispensesrcid from T_CSL_TempletDispense where forgBoundID = '" + treeId + "' and fsourceType = 2))"), CompareType.INNER);
            }
            filter.getFilterItems().add(filterItem);
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("isCitedByLater"));
        view.getSelector().add(new SelectorItemInfo("entries.summary"));
        view.getSelector().add(new SelectorItemInfo("entries.DC"));
        view.getSelector().add(new SelectorItemInfo("entries.item"));
        view.getSelector().add(new SelectorItemInfo("entries.item.name"));
        view.getSelector().add(new SelectorItemInfo("entries.debitFormula"));
        view.getSelector().add(new SelectorItemInfo("entries.creditFormula"));
        view.getSelector().add(new SelectorItemInfo("entries.dataElement"));
        view.getSelector().add(new SelectorItemInfo("elimType"));
        view.getSelector().add(new SelectorItemInfo("valueType"));
        view.getSelector().add(new SelectorItemInfo("entries.item.*"));
        view.getSelector().add(new SelectorItemInfo("eliminationMode.id"));
        view.getSelector().add(new SelectorItemInfo("eliminationMode.name"));
        view.getSelector().add(new SelectorItemInfo("entries.dataSrcType"));
        view.getSorter().add(new SorterItemInfo("number"));
        try {
            IElimTemplet iElimTemplet = ElimTempletFactory.getRemoteInstance();
            templetCollection = iElimTemplet.getElimTempletCollection(view);
        }
        catch (Exception _ex) {
            this.handUIException(_ex);
        }
        if (templetCollection != null && templetCollection.size() > 0) {
            this.tblTemplet.checkParsed();
            this.tblTemplet.getSelectManager().setSelectMode(2);
            for (int i = 0; i < templetCollection.size(); ++i) {
                ElimTempletInfo templet = templetCollection.get(i);
                IRow r = this.tblTemplet.addRow();
                r.getCell(0).setValue((Object)templet.getId());
                r.getCell(1).setValue((Object)templet.getNumber());
                r.getCell(2).setValue((Object)templet.getName());
                r.getCell(3).setValue((Object)templet.getElimType());
                r.getCell(4).setValue((Object)templet);
                this.tblTemplet.getRow(i).getStyleAttributes().setLocked(true);
            }
            this.tblTemplet.getSelectManager().select(0, 0, 0, 0);
        }
        this.tblTemplet.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        ElimTempletImportUI.this.actionConfirm_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        ElimTempletImportUI.this.handlerException(e1);
                    }
                }
            }
        });
    }

    private OrgTreeInfo getBasicTree() throws EASBizException, BOSException {
        OrgTreeInfo orgTree = null;
        if (orgTree == null) {
            orgTree = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo("select id where type =8 and basic = 1 and status=1 and isForBudget = 0");
        }
        return orgTree;
    }

    private void handlerException(Exception e1) {
        this.handUIException(e1);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        Map UiContext = this.getUIContext();
        Map params = (Map)UiContext.get("params");
        if (params != null) {
            this.getUIContext().put("Templet", this.getMultiSelectedTemplet());
        } else {
            this.getUIContext().put("Templet", this.getSelectedTemplet());
        }
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    public ElimTempletInfo getSelectedTemplet() {
        ElimTempletInfo templet = null;
        if (this.tblTemplet.getSelectManager().size() == 1) {
            int rowNum = this.tblTemplet.getSelectManager().get().getTop();
            ICell cell = this.tblTemplet.getRow(rowNum).getCell(4);
            templet = (ElimTempletInfo)cell.getValue();
        }
        return templet;
    }

    private List getMultiSelectedTemplet() throws Exception {
        ArrayList<Object> templetList = new ArrayList<Object>();
        String temNum = null;
        String temName = null;
        int temType = 0;
        int rowCount = this.tblTemplet.getSelectManager().size();
        IBlock selectBlock = null;
        int n = rowCount;
        for (int i = 0; i < n; ++i) {
            selectBlock = KDTSelectBlock.change((KDTable)this.tblTemplet, (IBlock)this.tblTemplet.getSelectManager().get(i));
            if (selectBlock == null) continue;
            int m = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= m; ++j) {
                temNum = this.tblTemplet.getRow(j).getCell(1).getValue().toString();
                temName = this.tblTemplet.getRow(j).getCell(2).getValue().toString();
                temType = ((ElimTypeEnum)((Object)this.tblTemplet.getRow(j).getCell(3).getValue())).getValue();
                templetList.add(temNum);
                templetList.add(temName);
                templetList.add(temType);
            }
        }
        return templetList;
    }

    @Override
    public void actionLocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocation_actionPerformed(e);
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblTemplet.getColumnIndex("templetNumber");
            int colIndex2 = this.tblTemplet.getColumnIndex("templetName");
            CslRptUIUtil.tableMainLocate(this.tblTemplet, search, new int[]{colIndex1, colIndex2});
        }
    }
}

