/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalYearPeriodDateTmp;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationMode;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationCopyFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EliminationCopyFilterUI
extends AbstractEliminationCopyFilterUI {
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private String orgTreeNumber = null;
    FiscalYearPeriodDateTmp fiscalRefCtrl;
    private String openSource = null;
    protected boolean isFromCslMerge = false;
    protected ICSLContext cslCtx = null;

    public EliminationCopyFilterUI() throws Exception {
    }

    public EliminationCopyFilterUI(String openSource) throws Exception {
        this.openSource = openSource;
    }

    public void onLoad() throws Exception {
        this.initCSLContext();
        this.init(this.openSource);
    }

    private void init(String openSource) throws Exception {
        this.orgTreeNumber = this.getCSLContext().getCurOrgBound().getNumber();
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.comboElimType.addItem((Object)this.selectAll);
        this.comboElimType.setSelectedItem((Object)this.selectAll);
        this.comboElimType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.comboElimType.addItem((Object)ElimTypeEnum.exchange);
        this.comboElimType.addItem((Object)ElimTypeEnum.General);
        this.comboElimType.addItem((Object)ElimTypeEnum.MAIN_INVEST);
        this.comboElimType.addItem((Object)ElimTypeEnum.HK_COST);
        this.comboElimType.addItem((Object)ElimTypeEnum.MAIN_COST);
        this.comboElimType.addItem((Object)ElimTypeEnum.Main_Invest_New);
        this.comboElimType.setSelectedIndex(0);
        this.comboElimType.setEnabled(true);
        this.comboCurrency.addItem((Object)this.selectAll);
        this.comboCurrency.setSelectedIndex(0);
        this.comboSourceCurrency.addItem((Object)this.selectAll);
        this.comboSourceCurrency.setSelectedIndex(0);
        this.bizPrmtItemFrom.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemFrom.setEditFormat("$number$");
        this.bizPrmtItemFrom.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemFrom.setEditable(true);
        this.bizPrmtItemFrom.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizPrmtItemFrom, null);
        this.bizPrmtItemTo.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemTo.setEditFormat("$number$");
        this.bizPrmtItemTo.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemTo.setEditable(true);
        this.bizPrmtItemTo.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizPrmtItemTo, null);
        CurrencyCollection currencyCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.comboCurrency.addItem((Object)currencyCollection.get(i));
                this.comboSourceCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        this.txtDebitFrom.setDataType(1);
        this.txtDebitFrom.setPrecision(2);
        this.txtDebitFrom.setNegatived(true);
        this.txtDebitFrom.setEditable(true);
        this.txtDebitTo.setDataType(1);
        this.txtDebitTo.setPrecision(2);
        this.txtDebitTo.setNegatived(true);
        this.txtDebitTo.setEditable(true);
        this.txtCreditFrom.setDataType(1);
        this.txtCreditFrom.setPrecision(2);
        this.txtCreditFrom.setNegatived(true);
        this.txtCreditFrom.setEditable(true);
        this.txtCreditTo.setDataType(1);
        this.txtCreditTo.setPrecision(2);
        this.txtCreditTo.setNegatived(true);
        this.txtCreditTo.setEditable(true);
        this.txtSummary.setMaxLength(255);
        this.kDCheckBox1.setSelected(true);
        try {
            this.initTimeCtrlValAndStatusByContextAndPrePeriod(true);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        this.comboElimMode.addItem((Object)this.selectAll);
        IEliminationMode iElimMode = EliminationModeFactory.getRemoteInstance();
        EntityViewInfo elimMode = new EntityViewInfo();
        elimMode.getSelector().add(new SelectorItemInfo("id"));
        elimMode.getSelector().add(new SelectorItemInfo("number"));
        elimMode.getSelector().add(new SelectorItemInfo("name"));
        CslGradeManageUtil.filterElimModeGradeManage((EntityViewInfo)elimMode, null);
        EliminationModeCollection collection = iElimMode.getEliminationModeCollection(elimMode);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                this.comboElimMode.addItem((Object)collection.get(i));
            }
        }
    }

    private void initTimeCtrlValAndStatusByContextAndPrePeriod(boolean isAddListener) throws BOSException, EASBizException {
        if (this.fiscalRefCtrl == null) {
            this.fiscalRefCtrl = new FiscalYearPeriodDateTmp(this.getCSLContext().getCurOrgBound(), this.comboPeriodType, this.pkRptDate, this.spYear, this.spPeriod);
        }
        this.fiscalRefCtrl.initTimeCtrlValAndStatusByContextAndPrePeriod(this.getCSLContext(), (CoreUIObject)this, null, true, isAddListener);
    }

    public SorterItemCollection getSorterItems() {
        return super.getSorterItems();
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterItemCurrency;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        try {
            String orgTreeId = null;
            if (this.pkRptDate.getTimestamp() != null) {
                orgTreeId = UnionVersionControllerFacadeFactory.getRemoteInstance().getID(this.orgTreeNumber, this.pkRptDate.getTimestamp());
            }
            if (orgTreeId == null) {
                orgTreeId = "";
            }
            FilterItemInfo filterItem = new FilterItemInfo("orgBound.id", (Object)orgTreeId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            ++formulaIndex;
            OrgUnitInfo uif = this.getCSLContext().getCurOrgGroup();
            String number = uif.getNumber();
            if (StringUtils.isEmpty((String)number) && uif.getId() != null && !StringUtils.isEmpty((String)uif.getId().toString())) {
                number = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select number where id='" + uif.getId().toString() + "'").getNumber();
            }
            filterItem = new FilterItemInfo("ORGUNIT.number", (Object)number, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            ++formulaIndex;
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        if (this.comboPeriodType.getSelectedItem() != null) {
            FilterItemInfo filterPeriodType = new FilterItemInfo("periodType", (Object)new Integer(((RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem()).getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriodType);
            ++formulaIndex;
        }
        if (this.spYear.getValue() != null) {
            FilterItemInfo filterYear = new FilterItemInfo("year", (Object)((Integer)this.spYear.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterYear);
            ++formulaIndex;
        }
        if (this.spPeriod.getValue() != null) {
            FilterItemInfo filterPeriod = new FilterItemInfo("period", (Object)((Integer)this.spPeriod.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriod);
            ++formulaIndex;
        }
        StringBuffer sbFormula = new StringBuffer();
        if (this.comboCurrency.getSelectedItem() != null && !this.comboCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            ++formulaIndex;
        }
        if (this.comboSourceCurrency.getSelectedItem() != null && !this.comboSourceCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("sourceCurrency.id", (Object)((CurrencyInfo)this.comboSourceCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            ++formulaIndex;
        }
        if (this.comboElimType.getSelectedItem() != null && !this.comboElimType.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterElimType = new FilterItemInfo("elimType", (Object)new Integer(((ElimTypeEnum)((Object)this.comboElimType.getSelectedItem())).getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterElimType);
            ++formulaIndex;
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            String numberFrom = this.txtNumberFrom.getText().trim();
            FilterItemInfo filterNumberFrom = new FilterItemInfo("number", (Object)numberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberFrom);
            ++formulaIndex;
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            String numberTo = this.txtNumberTo.getText().trim();
            FilterItemInfo filterNumberTo = new FilterItemInfo("number", (Object)numberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberTo);
            ++formulaIndex;
        }
        if (this.bizPrmtItemFrom.getData() != null) {
            String itemNumberFrom = ((RPTItemInfo)this.bizPrmtItemFrom.getData()).getNumber();
            FilterItemInfo filterItemFrom = new FilterItemInfo("item.number", (Object)itemNumberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemFrom);
            ++formulaIndex;
        }
        if (this.bizPrmtItemTo.getData() != null) {
            String itemNumberTo = ((RPTItemInfo)this.bizPrmtItemTo.getData()).getNumber();
            FilterItemInfo filterItemTo = new FilterItemInfo("item.number", (Object)itemNumberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            ++formulaIndex;
        }
        if (this.txtDebitFrom.getText() != null && this.txtDebitFrom.getText().trim().length() > 0) {
            BigDecimal debitFrom = this.txtDebitFrom.getBigDecimalValue();
            FilterItemInfo filterDebitFrom = new FilterItemInfo("entries.debit", (Object)debitFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitFrom);
            ++formulaIndex;
        }
        if (this.txtDebitTo.getText() != null && this.txtDebitTo.getText().trim().length() > 0) {
            BigDecimal debitTo = this.txtDebitTo.getBigDecimalValue();
            FilterItemInfo filterDebitTo = new FilterItemInfo("entries.debit", (Object)debitTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitTo);
            ++formulaIndex;
        }
        if (this.txtCreditFrom.getText() != null && this.txtCreditFrom.getText().trim().length() > 0) {
            BigDecimal creditFrom = this.txtCreditFrom.getBigDecimalValue();
            FilterItemInfo filterCreditFrom = new FilterItemInfo("entries.credit", (Object)creditFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditFrom);
            ++formulaIndex;
        }
        if (this.txtCreditTo.getText() != null && this.txtCreditTo.getText().trim().length() > 0) {
            BigDecimal creditTo = this.txtCreditTo.getBigDecimalValue();
            FilterItemInfo filterCreditTo = new FilterItemInfo("entries.credit", (Object)creditTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditTo);
            ++formulaIndex;
        }
        if (this.pkRptDate.getValue() != null) {
            Date startDate = (Date)this.pkRptDate.getValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            Timestamp startTime = new Timestamp(calendar.getTimeInMillis());
            FilterItemInfo filterItemStartDate = new FilterItemInfo("date", (Object)startTime, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemStartDate);
            ++formulaIndex;
        }
        FilterItemInfo citeByLater = new FilterItemInfo("isCitedByLater", (Object)new Integer(1), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(citeByLater);
        ++formulaIndex;
        if (this.txtSummary.getText() != null && this.txtSummary.getText().trim().length() > 0) {
            String summary = this.txtSummary.getText().trim();
            FilterItemInfo filterSummary = null;
            filterSummary = this.kDCheckBox1.isSelected() ? new FilterItemInfo("entries.summary", (Object)("%" + summary + "%"), CompareType.LIKE) : new FilterItemInfo("entries.summary", (Object)summary, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterSummary);
            ++formulaIndex;
        }
        if (this.comboElimMode.getSelectedItem() != null && !this.comboElimMode.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterModeInfo = new FilterItemInfo("eliminationMode.id", (Object)((EliminationModeInfo)this.comboElimMode.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterModeInfo);
            ++formulaIndex;
        }
        if (null != this.txtCustomNumber.getText() && this.txtCustomNumber.getText().length() > 0) {
            String customNumber = this.txtCustomNumber.getText();
            this.filterInfo.getFilterItems().add(new FilterItemInfo("customNumber", (Object)customNumber));
            ++formulaIndex;
        }
        for (int i = 0; i < formulaIndex; ++i) {
            if (i == 0) {
                sbFormula.append(" (#" + i + ")");
                continue;
            }
            sbFormula.append(" and (#" + i + ")");
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void clearUI() {
        this.comboCurrency.setSelectedItem((Object)this.selectAll);
        this.comboSourceCurrency.setSelectedItem((Object)this.selectAll);
        this.comboElimType.setSelectedItem((Object)this.selectAll);
        this.comboElimType.setEnabled(true);
        this.bizPrmtItemFrom.setData(null);
        this.bizPrmtItemTo.setData(null);
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.txtDebitFrom.setValue(null);
        this.txtDebitTo.setValue(null);
        this.txtCreditFrom.setValue(null);
        this.txtCreditTo.setValue(null);
        this.txtSummary.setText(null);
        this.kDCheckBox1.setSelected(true);
        try {
            this.initTimeCtrlValAndStatusByContextAndPrePeriod(false);
            this.refreshTimeInfo(this.pkRptDate.getSqlDate());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        this.comboElimMode.setSelectedItem((Object)this.selectAll);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    @Override
    protected void comboPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.refreshTimeInfo(this.pkRptDate.getSqlDate());
    }

    @Override
    protected void pkRptDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    private void refreshTimeInfo(Date newDate) throws BOSException {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (p == null || newDate == null) {
            return;
        }
        if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod()) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.spYear.setValue((Object)new Integer(times.get(0).toString()));
        this.setPeriodForJT13(times);
        this.pkRptDate.setValue(times.get(2));
    }

    private void setPeriodForJT13(List times) throws BOSException {
        String dataCollectNumber;
        DataCollectInfo dataCollect = this.getCSLContext().getCurDataCollect();
        String string = dataCollectNumber = dataCollect != null ? dataCollect.getNumber() : "ACTUALDATA";
        if (dataCollectNumber.equals("ACTUALDATA")) {
            CslRptUtil.setPeriodForJT13(times, (Date)this.pkRptDate.getValue(), (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem(), this.spPeriod, this.getCSLContext().getCurRptPeriod());
        } else {
            this.spPeriod.setEnabled(false);
            this.spPeriod.setValue((Object)new Integer(times.get(1).toString()));
            CslRptUIUtil.setSpineRange(this.spPeriod, 0, 365);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterItemCollection currentFilterItemCollection;
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection filterItemCollection = currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        if (currentFilterItemCollection.size() == 0) {
            this.kDCheckBox1.setSelected(true);
            return;
        }
        boolean isSetCheckBox = false;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        block2: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            String filterModeId;
            String currencyId;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)Integer.parseInt(filterItemInfo.getCompareValue().toString())));
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                this.spYear.setValue((Object)((Integer)filterItemInfo.getCompareValue()));
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                this.spPeriod.setValue((Object)((Integer)filterItemInfo.getCompareValue()));
                map.put("period", (Integer)filterItemInfo.getCompareValue());
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("elimType")) {
                this.comboElimType.setSelectedItem((Object)ElimTypeEnum.getEnum(Integer.parseInt(filterItemInfo.getCompareValue().toString())));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.comboCurrency.getItemCount(); ++j) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.comboCurrency.setSelectedIndex(j);
                    continue block2;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("sourceCurrency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.comboSourceCurrency.getItemCount(); ++j) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)this.comboSourceCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.comboSourceCurrency.setSelectedIndex(j);
                    continue block2;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("item.number")) {
                String itemNumber = (String)filterItemInfo.getCompareValue();
                try {
                    RPTItemInfo rptItemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo("select number, name where number = '" + itemNumber + "'");
                    if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                        this.bizPrmtItemFrom.setData((Object)rptItemInfo);
                        continue;
                    }
                    this.bizPrmtItemTo.setData((Object)rptItemInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtNumberFrom.setText(number);
                    continue;
                }
                this.txtNumberTo.setText(number);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.debit")) {
                BigDecimal debit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtDebitFrom.setValue((Object)debit);
                    continue;
                }
                this.txtDebitTo.setValue((Object)debit);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.credit")) {
                BigDecimal credit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtCreditFrom.setValue((Object)credit);
                    continue;
                }
                this.txtCreditTo.setValue((Object)credit);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("date")) {
                Date time = (Date)filterItemInfo.getCompareValue();
                if (!CompareType.EQUALS.equals((Object)filterItemInfo.getCompareType())) continue;
                this.pkRptDate.setValue((Object)new Date(time.getTime()));
                if (map.get("period") == null && "".equals(map.get("period"))) continue;
                this.spPeriod.setValue(map.get("period"));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.summary")) {
                String summary = (String)filterItemInfo.getCompareValue();
                isSetCheckBox = true;
                if (CompareType.LIKE.equals((Object)filterItemInfo.getCompareType())) {
                    this.kDCheckBox1.setSelected(true);
                    summary = summary.substring(1, summary.length() - 1);
                    this.txtSummary.setText(summary);
                    continue;
                }
                this.kDCheckBox1.setSelected(false);
                this.txtSummary.setText(summary);
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("eliminationMode.id") || StringUtils.isEmpty((String)(filterModeId = (String)filterItemInfo.getCompareValue()))) continue;
            int count = this.comboElimMode.getItemCount();
            for (int x = 0; x < count; ++x) {
                EliminationModeInfo eliminationModeInfo;
                Object elimMode = this.comboElimMode.getItemAt(x);
                if (!(elimMode instanceof EliminationModeInfo) || (eliminationModeInfo = (EliminationModeInfo)elimMode).getId() == null || !filterModeId.equals(eliminationModeInfo.getId().toString())) continue;
                this.comboElimMode.setSelectedIndex(x);
                continue block2;
            }
        }
        if (!isSetCheckBox) {
            this.kDCheckBox1.setSelected(true);
        }
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }
}

