/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IContextManager;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationCopyListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.EliminationCopyFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SortHelp;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataCatcherListener;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class EliminationCopyListUI
extends AbstractEliminationCopyListUI
implements ICSLContextUI {
    protected CommonQueryDialog conditionDialog = null;
    protected EliminationCopyFilterUI conditionPanel = null;
    private String ElimResName = "com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg";
    private String number = null;
    private SortHelp sortHelp;
    private boolean isSupportOtherDS;
    private boolean hasBgPermission = false;
    private boolean hasAcPermission = false;
    private boolean isMergeByFiscalPeriod;
    private boolean isSupport13Period;
    private PeriodCollection periods = null;
    private static final Logger logger = CoreUIObject.getLogger(EliminationCopyListUI.class);
    protected DataCatcherListener dcListener = null;
    protected boolean isFromCslMerge = false;
    protected ICSLContext cslCtx = null;

    public EliminationCopyListUI() throws Exception {
        this.initSortRule();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                EliminationCopyListUI.this.setSelectStatus(e.getFirstRow(), e.getLastRow());
                if (e.getFirstRow() > 0) {
                    EliminationCopyListUI.this.tblMain.checkParsed();
                    int idColIndex = EliminationCopyListUI.this.tblMain.getColumnIndex("id");
                    int selectColIndex = EliminationCopyListUI.this.tblMain.getColumnIndex("select");
                    Object id = EliminationCopyListUI.this.tblMain.getCell(e.getFirstRow() - 1, idColIndex).getValue();
                    int top = EliminationCopyListUI.this.tblMain.getMergeManager().getMergeBlockOfCell(e.getFirstRow() - 1, idColIndex).getTop();
                    Object select = EliminationCopyListUI.this.tblMain.getCell(top, selectColIndex).getValue();
                    if (select != null && Boolean.TRUE.equals(select)) {
                        Object curId = null;
                        for (int i = e.getFirstRow(); i <= e.getLastRow() && id.equals(curId = EliminationCopyListUI.this.tblMain.getCell(i, idColIndex).getValue()); ++i) {
                            EliminationCopyListUI.this.tblMain.getCell(i, selectColIndex).setValue(select);
                        }
                    }
                    EliminationCopyListUI.this.tblMain.getGroupManager().group(e.getFirstRow(), e.getLastRow());
                }
            }
        });
        this.initSysParamValue();
        if (this.isSupportOtherDS) {
            this.initPermissionForDS();
        }
        try {
            CslRptUIUtil.addTableSelectedListener(this.tblMain, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initSysParamValue() {
        String[] paramsKey = new String[]{"GR_CSL_SupportOtherDS", "GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"};
        boolean[] paramsVal = CSLParamUtil.batchGetParam(null, paramsKey);
        this.isSupportOtherDS = paramsVal[0];
        this.isMergeByFiscalPeriod = paramsVal[1];
        this.isSupport13Period = paramsVal[2];
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("isFromPC") == null) {
            this.initCSLContext();
        }
        super.onLoad();
        this.init();
    }

    protected void init() {
        this.hideUnuseableButtons();
        this.tblMain.setColumnMoveable(true);
        if (this.tblMain.getColumn("datacollect") != null) {
            this.tblMain.getColumn("datacollect").getStyleAttributes().setHided(!this.isSupportOtherDS);
        }
        this.tblMain.checkParsed();
        this.groupTableRow();
    }

    private void initPermissionForDS() throws BOSException, EASBizException {
        this.hasBgPermission = CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), DataCollectConstant.getBudgetDC());
        this.hasAcPermission = CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), DataCollectConstant.getActualDC());
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        try {
            if (this.isSupportOtherDS) {
                if (!this.hasBgPermission) {
                    viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA"));
                    viewInfo.getFilter().setMaskString("(" + viewInfo.getFilter().getMaskString() + ") and #" + (viewInfo.getFilter().getFilterItems().size() - 1));
                }
                if (!this.hasAcPermission) {
                    viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("dataCollect.number", (Object)"BUDGETDATA"));
                    viewInfo.getFilter().setMaskString("(" + viewInfo.getFilter().getMaskString() + ") and #" + (viewInfo.getFilter().getFilterItems().size() - 1));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        IQueryExecutor exc = super.getQueryExecutor(queryPK, viewInfo);
        exc.option().isAutoIgnoreZero = false;
        return exc;
    }

    private void setSelectStatus(int firstRow, int lastRow) {
        for (int i = firstRow; i <= lastRow; ++i) {
            ICell cell = this.tblMain.getRow(i).getCell("select");
            if (cell == null) continue;
            cell.getStyleAttributes().setLocked(false);
            cell.setValue((Object)Boolean.FALSE);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNone.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnCopyHisData.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
        this.menuItemSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.menuItemSelectNone.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.menuItemCopyCreate.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
    }

    protected void hideUnuseableButtons() {
        this.btnView.setVisible(false);
        this.actionView.setEnabled(false);
        this.menuItemView.setVisible(false);
        this.btnPrint.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.menuItemPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.menuItemPrintPreview.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.menuItemAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.menuItemEdit.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.actionViewDoProccess.setEnabled(false);
        this.menuItemViewDoProccess.setVisible(false);
        this.btnRemove.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.menuItemRemove.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.actionCreateTo.setEnabled(false);
        this.btnCopyTo.setVisible(false);
        this.actionCopyTo.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.btnTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.btnTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.btnDelVoucher.setVisible(false);
        this.actionDelVoucher.setEnabled(false);
        this.btnVoucher.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.btnNextPerson.setVisible(false);
        this.menuItemNextPerson.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.btnMultiapprove.setVisible(false);
        this.menuItemMultiapprove.setVisible(false);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            dialog = this.getConditionDialog();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"No_FilterUI"));
            this.handUIException(e);
        }
        return dialog;
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)((Object)this));
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)this.getQueryMetaDataPK());
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(455);
            this.conditionDialog.setHeight(360);
            this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Elimination_FilterUI_Title"));
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName(this.getClass().getName());
        }
        return this.conditionDialog;
    }

    protected MetaDataPK getQueryMetaDataPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"EliminationQuery");
    }

    public EliminationCopyFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new EliminationCopyFilterUI("All");
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
            this.conditionPanel.getUIContext().put("cslCtx", this.getCSLContext());
        }
        return this.conditionPanel;
    }

    protected void showFilterUI() throws Exception {
        if (this.getConditionDialog().show()) {
            this.mainQuery = this.getConditionDialog().getEntityViewInfoResult();
            this.tblMain.removeRows();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() != 0 && e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 1) {
            ICell cell;
            IRow row = this.tblMain.getRow(e.getRowIndex());
            boolean isSelect = (Boolean)(cell = row.getCell("select")).getValue();
            cell.setValue((Object)(!isSelect ? 1 : 0));
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (this.isFromCslMerge) {
            this.setCslContext2Server();
        }
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        this.groupTableRow();
        if (this.isFromCslMerge) {
            this.restoreCslContext2Server();
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    public void refreshList() throws Exception {
        this.updateCslCtxFilter();
        super.refreshList();
    }

    protected void updateCslCtxFilter() throws BOSException {
        this.mainQuery = this.getMainQuery();
        this.mainQuery.getSorter().clear();
        this.mainQuery.getSorter().add(new SorterItemInfo("number"));
        this.mainQuery.getSorter().add(new SorterItemInfo("entries.seq"));
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        try {
            FilterItemInfo filterItem1 = new FilterItemInfo("periodType", (Object)new Integer(this.getCSLContext().getCurRptPeriodType().getValue()), CompareType.EQUALS);
            int[] prePeriod = this.getPrePeriod(this.getCSLContext());
            FilterItemInfo filterItem2 = new FilterItemInfo("year", (Object)new Integer(prePeriod[0]), CompareType.EQUALS);
            FilterItemInfo filterItem3 = new FilterItemInfo("period", (Object)new Integer(prePeriod[1]), CompareType.EQUALS);
            Date rptDate = FiscalPeriodHelper.getRptDate(this.periods, prePeriod[0], prePeriod[1], this.getCSLContext().getCurRptPeriodType(), this.isMergeByFiscalPeriod);
            String orgTreeId = UnionVersionControllerFacadeFactory.getRemoteInstance().getID(this.getCSLContext().getCurOrgBound().getNumber().toString(), new Timestamp(rptDate.getTime()));
            FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.id", (Object)orgTreeId, CompareType.EQUALS);
            FilterItemInfo filterItem4 = new FilterItemInfo("isCitedByLater", (Object)new Integer(1), CompareType.EQUALS);
            OrgUnitInfo uif = this.getCSLContext().getCurOrgGroup();
            this.number = CslRptUIUtil.getCompanyStructureNumber(this.getCSLContext().getCurOrgBound(), uif);
            FilterItemInfo filterItem5 = new FilterItemInfo("structure.longNumber", (Object)this.number, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItem0);
            sbFormula.append(" #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem3);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem4);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem5);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.setMaskString(sbFormula.toString());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        this.addDataCollectFilterItems(filterInfo);
        evi.setFilter(filterInfo);
        return evi;
    }

    private int[] getPrePeriod(ICSLContext ctx) throws BOSException, EASBizException {
        int iPeriod;
        int iYear;
        int[] yearAndPeriod;
        if (this.isMergeByFiscalPeriod) {
            this.periods = FiscalPeriodHelper.getPeriodCollection(null, ctx.getCurOrgBound());
        }
        if ((yearAndPeriod = FiscalPeriodHelper.getPrevYearAndPeriod(this.periods, iYear = ctx.getCurRptYear(), iPeriod = ctx.getCurRptPeriod(), ctx.getCurRptPeriodType(), this.isMergeByFiscalPeriod, this.isSupport13Period, false)) != null && yearAndPeriod.length == 2) {
            return yearAndPeriod;
        }
        return new int[]{iYear, iPeriod};
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String dateTime;
        String format;
        this.groupTableRow();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = EliminationCopyListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        if (!this.isPerformDefaultQuery(iQuery, queryName)) {
            if (this.getConditionDialog().show()) {
                this.mainQuery = this.getConditionDialog().getEntityViewInfoResult();
                FilterInfo filter = this.mainQuery.getFilter();
                this.addDataCollectFilterItems(filter);
                this.mainQuery.setFilter(filter);
                this.doQuery(this.conditionDialog);
                this.refresh(e);
            } else {
                SysUtil.abort();
            }
        }
        if ((format = CslRptUIUtil.getNationalDateFormatString()) != null) {
            this.tblMain.getColumn("date").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
        }
        if ((dateTime = CslRptUIUtil.getNationalTimeFormatString()) != null) {
            this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(dateTime);
        }
    }

    private void groupTableRow() {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn(0).setGroup(true);
        this.tblMain.getColumn(1).setGroup(true);
        this.tblMain.getColumn(2).setGroup(true);
        this.tblMain.getColumn(3).setGroup(true);
        this.tblMain.getColumn(4).setGroup(true);
        this.tblMain.getColumn(5).setGroup(true);
        this.tblMain.getColumn(6).setGroup(true);
        this.tblMain.getColumn(7).setGroup(true);
        this.tblMain.getColumn(15).setGroup(true);
        this.tblMain.getColumn(16).setGroup(true);
        this.tblMain.getColumn(17).setGroup(true);
        this.tblMain.getColumn(18).setGroup(true);
        this.tblMain.getColumn(0).setMergeable(true);
        this.tblMain.getColumn(1).setMergeable(true);
        this.tblMain.getColumn(2).setMergeable(true);
        this.tblMain.getColumn(3).setMergeable(true);
        this.tblMain.getColumn(4).setMergeable(true);
        this.tblMain.getColumn(5).setMergeable(true);
        this.tblMain.getColumn(6).setMergeable(true);
        this.tblMain.getColumn(7).setMergeable(true);
        this.tblMain.getColumn(18).setMergeable(true);
        this.tblMain.getColumn(19).setMergeable(true);
        this.tblMain.getColumn(20).setMergeable(true);
        this.tblMain.getColumn(21).setMergeable(true);
        this.tblMain.getColumn(22).setMergeable(true);
    }

    @Override
    public void actionCopyHisData_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyHisData_actionPerformed(e);
        boolean isSunElimination = this.chkSumElimination.isSelected();
        boolean isInitYearProfit = this.chkInitYearProfit.isSelected();
        RptProperties pp = new RptProperties();
        pp.setString("treeId", this.getCSLContext().getCurOrgBound().getId().toString());
        pp.setString("orgUnitId", this.getCSLContext().getCurOrgGroup().getId().toString());
        pp.setInt("year", this.getCSLContext().getCurRptYear());
        pp.setInt("period", this.getCSLContext().getCurRptPeriod());
        pp.setInt("periodType", this.getCSLContext().getCurRptPeriodType().getValue());
        pp.setBoolean("isSunElimination", isSunElimination);
        pp.setBoolean("isInitYearProfit", isInitYearProfit);
        pp.setObject("list", this.getSelectedEliminationIDs());
        pp.setObject("dataCollect", this.getCSLContext().getCurDataCollect());
        pp.setObject("KEY_ORGTREE_INFO", this.getCSLContext().getCurOrgBound());
        pp.setObject("KEY_ORGUNIT_INFO", this.getCSLContext().getCurOrgGroup());
        String typeid = (String)this.getUIContext().get("displayTypeId");
        if (typeid != null) {
            pp.setString("displayTypeId", typeid);
        }
        Map map = ((IElimination)this.getBizInterface()).copyHisData(pp);
        int count = Integer.parseInt((String)map.get("iSuccessCount"));
        List lstResult = (List)map.get("successRecord");
        StringBuffer msg = new StringBuffer();
        StringBuffer msgDetail = new StringBuffer();
        msg.append(EASResource.getString((String)this.ElimResName, (String)"CopySuccess")).append(count);
        msgDetail.append(EASResource.getString((String)this.ElimResName, (String)"105_number_record")).append("\n");
        int iSize = lstResult.size();
        for (int i = 0; i < iSize; ++i) {
            msgDetail.append(lstResult.get(i)).append("\n");
        }
        this.refresh(e);
        this.groupTableRow();
        if (lstResult.isEmpty()) {
            MsgBox.showInfo((String)msg.toString());
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg.toString(), (String)msgDetail.toString(), (int)1);
        }
    }

    private ArrayList getSelectedEliminationIDs() {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, Boolean> selMap = new HashMap<String, Boolean>();
        boolean select = false;
        for (int i = 0; i < this.tblMain.getExpandedRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            String id = (String)row.getCell("id").getValue();
            if (!selMap.containsKey(id)) {
                boolean sel = (Boolean)row.getCell("select").getValue();
                selMap.put(id, sel);
                select = sel;
            } else {
                select = (Boolean)selMap.get(id);
            }
            if (!Boolean.TRUE.equals(select) || list.contains(id)) continue;
            list.add(id);
        }
        if (list.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        return list;
    }

    private boolean isZero(IRow row, String key) {
        BigDecimal value = (BigDecimal)row.getCell(key).getValue();
        return value != null && value.compareTo(CslConstant.BGZERO) == 0;
    }

    protected void showUnEditableData(IRow row) {
        if (row != null && row.getCell("currency.precision") != null) {
            int currencyPrecision = (Integer)row.getCell("currency.precision").getValue();
            if (!this.isZero(row, "entries.debit")) {
                CslClientHelper.setPrecision(currencyPrecision, row, "entries.debit");
            }
            if (!this.isZero(row, "entries.credit")) {
                CslClientHelper.setPrecision(currencyPrecision, row, "entries.credit");
            }
            boolean isVisible = true;
            if (row.getCell("isVisible") != null && row.getCell("isVisible").getValue() != null) {
                isVisible = (Boolean)row.getCell("isVisible").getValue();
            }
            if (!isVisible) {
                if (row.getCell("entries.debit") != null && row.getCell("entries.debit").getValue() != null) {
                    row.getCell("entries.debit").getStyleAttributes().setBackground(new Color(0xF6F6BF));
                }
                if (row.getCell("entries.credit") != null && row.getCell("entries.credit").getValue() != null) {
                    row.getCell("entries.credit").getStyleAttributes().setBackground(new Color(0xF6F6BF));
                }
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EliminationFactory.getRemoteInstance();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        CslRptUtil.selectTable(this.tblMain, "select", Boolean.TRUE);
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectNone_actionPerformed(e);
        CslRptUtil.selectTable(this.tblMain, "select", Boolean.FALSE);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!this.isFromCslMerge) {
            CSLContextHelper.update(o, (CoreUI)this);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public boolean destroyWindow() {
        Object owner = this.getUIContext().get("Owner");
        if (owner instanceof ListUI) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if (!this.isFromCslMerge) {
            CSLContextHelper.unRegistUIObject(this);
        }
        return super.destroyWindow();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void setSortForQuery(SorterItemInfo sortItem, SorterItemInfo oldSortItem) throws Exception {
        String field = sortItem.getPropertyName();
        this.sortHelp.setCurSortColumn(field);
        this.sortHelp.setMainQuery(this.mainQuery);
        if (this.sortHelp.isRequireSortField()) {
            this.refresh(null);
        } else {
            super.setSortForQuery(sortItem, oldSortItem);
        }
    }

    private void initSortRule() {
        this.sortHelp = new SortHelp();
        this.sortHelp.addSortItem("invCompany.name", "invCompany.number", 1, SortType.ASCEND);
        this.sortHelp.addSortItem("targetCompany.name", "targetCompany.number", 2, SortType.ASCEND);
        this.sortHelp.addSortItem("number", "number", 3, SortType.ASCEND);
        this.sortHelp.setExcludeFiled("number");
    }

    private void addDataCollectFilterItems(FilterInfo filterInfo) {
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        StringBuffer maskString = filterInfo.getMaskString() == null ? new StringBuffer() : new StringBuffer(filterInfo.getMaskString());
        try {
            if (this.isSupportOtherDS) {
                if (!this.hasBgPermission) {
                    FilterItemInfo filterItem6 = new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA", CompareType.EQUALS);
                    filterInfo.getFilterItems().add(filterItem6);
                    maskString.append(" and #" + (filterInfo.getFilterItems().size() - 1));
                }
                if (!this.hasAcPermission) {
                    FilterItemInfo filterItem8 = new FilterItemInfo("dataCollect.number", (Object)"BUDGETDATA", CompareType.EQUALS);
                    filterInfo.getFilterItems().add(filterItem8);
                    maskString.append(" and #" + (filterInfo.getFilterItems().size() - 1));
                }
            } else {
                FilterItemInfo filterItem7 = new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA", CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItem7);
                maskString.append(" and #" + (filterInfo.getFilterItems().size() - 1));
            }
            filterInfo.setMaskString(maskString.toString());
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.getUIWindow().getUIObject().getUIContentPane().setSize(1013, 629);
    }

    public void bindDataListener(DataCatcherListener dcListener) {
        this.dcListener = dcListener;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }

    private void setCslContext2Server() throws BOSException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(OrgType.UnionDebt, this.getCSLContext().getCurOrgGroup());
        map.put("KEY_ORGTREE_INFO", this.getCSLContext().getCurOrgBound());
        map.put("KEY_DATACOLLECT_NUMBER", this.getCSLContext().getCurDataCollect().getNumber());
        IContextManager imanager = ContextManagerFactory.getRemoteInstance();
        imanager.setContext(map);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        int firstIndex = e.getFirstRow();
        int lastIndex = e.getLastRow();
        for (int r = firstIndex; r <= lastIndex; ++r) {
            IRow row = this.tblMain.getRow(r);
            this.showUnEditableData(row);
        }
    }

    private void restoreCslContext2Server() throws BOSException {
        OrgUnitInfo curOrgGroup = null;
        OrgTreeInfo orgTree = null;
        String number = "";
        if (CSLContext.getInstance().isInitialized()) {
            curOrgGroup = CSLContext.getInstance().getCurOrgGroup();
            orgTree = CSLContext.getInstance().getCurOrgBound();
            number = CSLContext.getInstance().getCurDataCollect().getNumber();
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(OrgType.UnionDebt, curOrgGroup);
        map.put("KEY_ORGTREE_INFO", orgTree);
        map.put("KEY_DATACOLLECT_NUMBER", number);
        IContextManager imanager = ContextManagerFactory.getRemoteInstance();
        imanager.setContext(map);
    }
}

