/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaItem2ElimItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.DynamicItemBean;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisAdjustDynamicItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisElimDynaItemEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.HisElimDynaItemEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisEliminationEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.HisEliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IDynaItem2ElimItem;
import com.kingdee.eas.fi.gr.cslrpt.IElimDynaItemEntry;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationEntry;
import com.kingdee.eas.fi.gr.cslrpt.IHisElimDynaItemEntry;
import com.kingdee.eas.fi.gr.cslrpt.IHisEliminationEntry;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationDynamicEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.DynamicItemFilterF7UI;
import com.kingdee.eas.fi.gr.cslrpt.client.EliminationHandEditUI;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class EliminationDynamicEditUI
extends AbstractEliminationDynamicEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EliminationDynamicEditUI.class);
    private EliminationEntryInfo elimEntryInfo = null;
    private HisEliminationEntryInfo hisElimEntryInfo = null;
    private int isQueryBudget = 0;
    private IHisElimDynaItemEntry iHisElimDynaItemEntry;
    private String elimEntryId;
    private List contrastRptItems = new ArrayList();
    private Map asstActTypeNumbers;
    private List lst = null;
    private List existDyItemEntries;
    private Map rowMap;
    private IElimDynaItemEntry iElimDynaItemEntry;
    private int dc = 1;
    private boolean isAddedLine = false;
    private CoreBaseCollection localEditData;
    protected boolean isFromCslMerge = false;
    protected ICSLContext cslCtx = null;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("ISQUERYBUDGET") != null) {
            this.isQueryBudget = (Integer)this.getUIContext().get("ISQUERYBUDGET");
        }
        this.elimEntryId = (String)this.getUIContext().get("eliminationEntryId");
        this.existDyItemEntries = (List)this.getUIContext().get("existDyItemEntries");
        this.rowMap = (Map)this.getUIContext().get("rowmap");
        if (this.iElimDynaItemEntry == null) {
            this.iElimDynaItemEntry = ElimDynaItemEntryFactory.getRemoteInstance();
        }
        if (this.iHisElimDynaItemEntry == null) {
            this.iHisElimDynaItemEntry = HisElimDynaItemEntryFactory.getRemoteInstance();
        }
        this.kdtElimDynaItemEntries.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                EliminationDynamicEditUI.this.actionRemoveLine.setEnabled(e.getSelectBlock().getBeginRow() > -1);
            }
        });
        this.kdtElimDynaItemEntries.setBeforeAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                if (e.getType() == 5) {
                    e.setCancel(true);
                }
            }
        });
        this.kdtElimDynaItemEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
                    EliminationDynamicEditUI.this.tableValueChanged(e.getRowIndex(), e.getColIndex(), e.getValue());
                    EliminationDynamicEditUI.this.isAddedLine = true;
                }
            }
        });
    }

    private void tableValueChanged(int row, int col, Object value) {
        String columnKey = this.kdtElimDynaItemEntries.getColumnKey(col);
        if ("keyNumber".equals(columnKey)) {
            ICell cellKeyNumber = this.kdtElimDynaItemEntries.getRow(row).getCell("keyNumber");
            ICell cellKeyName = this.kdtElimDynaItemEntries.getRow(row).getCell("keyName");
            if (value instanceof DynamicItemBean) {
                DynamicItemBean dataInfo = (DynamicItemBean)value;
                cellKeyNumber.setValue((Object)dataInfo.getNumber());
                cellKeyName.setValue((Object)dataInfo.getName());
                this.kdtElimDynaItemEntries.getRow(row).setUserObject((Object)dataInfo);
            } else {
                cellKeyName.setValue(value);
                cellKeyNumber.setUserObject(value);
                this.kdtElimDynaItemEntries.getRow(row).setUserObject(null);
            }
        }
    }

    private void initDynaItemEditor(IRow row, RPTItemInfo itemInfo) throws BOSException, UIException {
        this.lst = new ArrayList();
        KDComboBox cbxRptItems = new KDComboBox();
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)cbxRptItems);
        row.getCell("rptItem").setEditor((ICellEditor)cellEditor);
        row.getCell("rptItemName").getStyleAttributes().setLocked(true);
        for (RPTItemInfo rptItemInfo : this.contrastRptItems) {
            cbxRptItems.addItem((Object)rptItemInfo);
            this.lst.add(rptItemInfo.getId().toString());
        }
        cbxRptItems.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    KDComboBox cb = (KDComboBox)e.getSource();
                    try {
                        EliminationDynamicEditUI.this.setRptItem(cb.getSelectedIndex());
                        EliminationDynamicEditUI.this.initDynaItemEditor(cb.getSelectedIndex());
                    }
                    catch (Exception e1) {
                        logger.error((Object)"cbxRptItems.addItemListenerException", (Throwable)e1);
                    }
                }
            }
        });
        cbxRptItems.setSelectedIndex(itemInfo == null ? 0 : this.lst.indexOf(itemInfo.getId().toString()));
        String itemId = itemInfo == null ? "" : itemInfo.getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        String actTypeNumber = (String)this.asstActTypeNumbers.get(itemId + this.elimEntryInfo.getDataElement());
        KDTDefaultCellEditor dyCellEditor = null;
        if (StringUtils.isEmpty((String)actTypeNumber) || "0".equals(actTypeNumber) || "NULL".equalsIgnoreCase(actTypeNumber) || "'NULL'".equals(actTypeNumber)) {
            HashMap<String, String> cslParam = new HashMap<String, String>();
            cslParam.put("KEY_CUR_ORGBOUND_ID", this.getCSLContext().getCurOrgBound().getId().toString());
            cslParam.put("KEY_CUR_ORGBOUNDGROUP_ID", this.getCSLContext().getCurOrgGroup().getId().toString());
            List dynamicElimnItems = null;
            dynamicElimnItems = itemInfo == null ? new ArrayList(1) : this.getDynamicElimnItems(itemInfo.getNumber());
            KDComboBox cbxDynamicItems = new KDComboBox();
            cbxDynamicItems.setEditable(true);
            cbxDynamicItems.addItems(dynamicElimnItems.toArray());
            dyCellEditor = new KDTDefaultCellEditor((JComboBox)cbxDynamicItems);
        } else {
            uiContext.put((Object)"ActTypeNumber", (Object)actTypeNumber);
            uiContext.put((Object)"CU.ID", (Object)this.getCurrEntryCompanyCU());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DynamicItemFilterF7UI.class.getName(), (Map)uiContext);
            DynamicItemFilterF7UI f7 = (DynamicItemFilterF7UI)uiWindow.getUIObject();
            KDBizPromptBox promptBox = new KDBizPromptBox();
            promptBox.addCommitListener((CommitListener)f7);
            promptBox.setSelector((KDPromptSelector)f7);
            promptBox.setEditFormat("$number$");
            promptBox.setDisplayFormat("$name$");
            promptBox.setCommitFormat("$number$");
            dyCellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
        }
        row.getCell("keyNumber").setEditor((ICellEditor)dyCellEditor);
    }

    private void initDynaItemEditor(int selectedIndex, int selectedRowIndex) throws BOSException, UIException {
        ICell cell;
        int selRow = selectedRowIndex == -1 ? this.kdtElimDynaItemEntries.getSelectManager().get().getBeginRow() : selectedRowIndex;
        String rptItemNumber = null;
        if (this.kdtElimDynaItemEntries.getRow(selRow) != null && (cell = this.kdtElimDynaItemEntries.getRow(selRow).getCell("rptItem")) != null && cell.getValue() != null && cell.getValue() instanceof RPTItemInfo) {
            rptItemNumber = ((RPTItemInfo)cell.getValue()).getNumber();
        }
        String itemId = (String)this.lst.get(selectedIndex);
        UIContext uiContext = new UIContext((Object)this);
        String actTypeNumber = (String)this.asstActTypeNumbers.get(itemId + this.elimEntryInfo.getDataElement());
        KDTDefaultCellEditor dyCellEditor = null;
        if (StringUtils.isEmpty((String)actTypeNumber) || "0".equals(actTypeNumber) || "NULL".equalsIgnoreCase(actTypeNumber) || "'NULL'".equals(actTypeNumber)) {
            List dynamicElimnItems = this.getDynamicElimnItems(rptItemNumber);
            KDComboBox cbxDynamicItems = new KDComboBox();
            cbxDynamicItems.setEditable(true);
            cbxDynamicItems.addItems(dynamicElimnItems.toArray());
            dyCellEditor = new KDTDefaultCellEditor((JComboBox)cbxDynamicItems);
        } else {
            uiContext.put((Object)"ActTypeNumber", (Object)actTypeNumber);
            uiContext.put((Object)"CU.ID", (Object)this.getCurrEntryCompanyCU());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DynamicItemFilterF7UI.class.getName(), (Map)uiContext);
            DynamicItemFilterF7UI f7 = (DynamicItemFilterF7UI)uiWindow.getUIObject();
            KDBizPromptBox promptBox = new KDBizPromptBox();
            promptBox.addCommitListener((CommitListener)f7);
            promptBox.setSelector((KDPromptSelector)f7);
            promptBox.setEditFormat("$number$");
            promptBox.setDisplayFormat("$name$");
            promptBox.setCommitFormat("$number$");
            dyCellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
        }
        this.kdtElimDynaItemEntries.getRow(selRow).getCell("keyNumber").setEditor((ICellEditor)dyCellEditor);
    }

    private void initDynaItemEditor(int selectedIndex) throws BOSException, UIException {
        this.initDynaItemEditor(selectedIndex, -1);
    }

    private String getCurrEntryCompanyCU() throws BOSException {
        String cuid = null;
        if (StringUtils.isEmpty((String)this.elimEntryId)) {
            return cuid;
        }
        String oql = "select company.cu.id where id ='" + this.elimEntryId + "'";
        EliminationEntryInfo entryInfo = null;
        HisEliminationEntryInfo hisElimEntryInfo = null;
        try {
            cuid = this.isQueryBudget == 1 ? ((hisElimEntryInfo = HisEliminationEntryFactory.getRemoteInstance().getHisEliminationEntryInfo(oql)) == null ? null : (hisElimEntryInfo.getCompany() == null ? null : hisElimEntryInfo.getCompany().getCU().getId().toString())) : ((entryInfo = EliminationEntryFactory.getRemoteInstance().getEliminationEntryInfo(oql)) == null ? null : (entryInfo.getCompany() == null ? null : entryInfo.getCompany().getCU().getId().toString()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return cuid;
    }

    private List getDynamicElimnItems(String rptItemNumber) throws BOSException {
        List dynamicElimnItems = null;
        HashMap<String, Object> cslParam = new HashMap<String, Object>();
        cslParam.put("KEY_CUR_ORGBOUND_ID", this.getCSLContext().getCurOrgBound().getId().toString());
        cslParam.put("KEY_CUR_ORGBOUNDGROUP_ID", this.getCSLContext().getCurOrgGroup().getId().toString());
        if (this.isQueryBudget == 1) {
            cslParam.put("RptItemNumber", this.hisElimEntryInfo.getItem().getNumber());
            cslParam.put("DataElement", new Integer(this.hisElimEntryInfo.getDataElement()));
            cslParam.put("ValueType", new Integer(this.hisElimEntryInfo.getElimination().getValueType().getValue()));
            dynamicElimnItems = this.iHisElimDynaItemEntry.getDynamicElimnItems(cslParam, this.hisElimEntryInfo.getId().toString());
        } else {
            cslParam.put("RptItemNumber", rptItemNumber == null ? this.elimEntryInfo.getItem().getNumber() : rptItemNumber);
            cslParam.put("DataElement", new Integer(this.elimEntryInfo.getDataElement()));
            cslParam.put("ValueType", new Integer(this.elimEntryInfo.getElimination().getValueType().getValue()));
            dynamicElimnItems = this.iElimDynaItemEntry.getDynamicElimnItems(cslParam, this.elimEntryInfo.getId().toString());
        }
        return dynamicElimnItems;
    }

    private void setRptItem(int index) {
        if (index > -1 && index < this.contrastRptItems.size()) {
            int selRow = this.kdtElimDynaItemEntries.getSelectManager().get().getBeginRow();
            ICell cell = this.kdtElimDynaItemEntries.getRow(selRow).getCell("rptItem");
            cell.setValue(this.contrastRptItems.get(index));
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initEditData();
    }

    protected void updateButtonStatus() {
        super.updateButtonStatus();
        int index = this.existDyItemEntries.indexOf(this.elimEntryId);
        this.actionFirst.setEnabled(index > 0);
        this.actionPre.setEnabled(index > 0);
        this.actionNext.setEnabled(index + 1 < this.existDyItemEntries.size());
        this.actionLast.setEnabled(index + 1 < this.existDyItemEntries.size());
        if (this.isQueryBudget == 1) {
            this.actionSubmit.setVisible(false);
            this.actionAddLine.setVisible(false);
            this.actionInsertLine.setVisible(false);
            this.actionRemoveLine.setVisible(false);
        } else {
            int audit = this.elimEntryInfo.getElimination().getCheckedStatus().getValue();
            this.actionSubmit.setEnabled(audit != 2);
        }
    }

    private void initEditData() throws Exception {
        this.initEliminationEntry();
        this.initAsstActTypeNumber();
        this.initContrastRptItems();
        this.initBillHeader();
        this.initTableEditors();
        this.initTableRows();
        this.updateButtonStatus();
    }

    private void initAsstActTypeNumber() throws BOSException {
        HashMap<String, Object> cslContext = new HashMap<String, Object>();
        cslContext.put("KEY_CUR_ORGBOUND_ID", this.getCSLContext().getCurOrgBound().getId().toString());
        cslContext.put("KEY_CUR_ORGBOUNDGROUP_ID", this.getCSLContext().getCurOrgGroup().getId().toString());
        cslContext.put("Year", new Integer(this.getCSLContext().getCurRptYear()));
        cslContext.put("Period", new Integer(this.getCSLContext().getCurRptPeriod()));
        cslContext.put("PeriodType", new Integer(this.getCSLContext().getCurRptPeriodType().getValue()));
        this.asstActTypeNumbers = this.isQueryBudget == 1 ? this.iHisElimDynaItemEntry.getAsstActTypeNumbers(cslContext, 2) : this.iElimDynaItemEntry.getAsstActTypeNumbers(cslContext, 2);
    }

    private void initTableEditors() throws Exception {
        int precision = 0;
        precision = this.isQueryBudget == 1 ? this.hisElimEntryInfo.getElimination().getCurrency().getPrecision() : this.elimEntryInfo.getElimination().getCurrency().getPrecision();
        KDFormattedTextField txtNumberFormate = new KDFormattedTextField();
        txtNumberFormate.setDataType(1);
        txtNumberFormate.setPrecision(6);
        KDTDefaultCellEditor numCellEditor = new KDTDefaultCellEditor((JTextField)txtNumberFormate);
        this.kdtElimDynaItemEntries.getColumn("money").setEditor((ICellEditor)numCellEditor);
        this.kdtElimDynaItemEntries.getColumn("money").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        String numberFmt = FMClientHelper.getNumberFtm((int)precision);
        this.kdtElimDynaItemEntries.getColumn("money").getStyleAttributes().setNumberFormat(numberFmt);
        KDTextField keyNameEditer = new KDTextField();
        keyNameEditer.setMaxLength(400);
        this.kdtElimDynaItemEntries.getColumn("keyName").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)keyNameEditer));
        this.kdtElimDynaItemEntries.getColumn("keyName").getStyleAttributes().setLocked(true);
        KDTextField remarkEditer = new KDTextField();
        remarkEditer.setMaxLength(200);
        this.kdtElimDynaItemEntries.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)remarkEditer));
    }

    private void initEliminationEntry() throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("elimination.number"));
        selector.add(new SelectorItemInfo("elimination.checkedStatus"));
        selector.add(new SelectorItemInfo("elimination.currency.name"));
        selector.add(new SelectorItemInfo("elimination.currency.precision"));
        selector.add(new SelectorItemInfo("elimination.sourceCurrency.name"));
        selector.add(new SelectorItemInfo("elimination.valueType"));
        selector.add(new SelectorItemInfo("item.id"));
        selector.add(new SelectorItemInfo("item.number"));
        selector.add(new SelectorItemInfo("item.name"));
        selector.add(new SelectorItemInfo("item.dc"));
        selector.add(new SelectorItemInfo("debit"));
        selector.add(new SelectorItemInfo("credit"));
        selector.add(new SelectorItemInfo("dataElement"));
        selector.add(new SelectorItemInfo("company.id"));
        ObjectStringPK pk = new ObjectStringPK(this.elimEntryId);
        if (this.isQueryBudget == 1) {
            IHisEliminationEntry iEliminationEntry = HisEliminationEntryFactory.getRemoteInstance();
            this.hisElimEntryInfo = iEliminationEntry.getHisEliminationEntryInfo((IObjectPK)pk, selector);
        } else {
            IEliminationEntry iEliminationEntry = EliminationEntryFactory.getRemoteInstance();
            this.elimEntryInfo = iEliminationEntry.getEliminationEntryInfo((IObjectPK)pk, selector);
        }
    }

    private void initTableRows() {
        this.kdtElimDynaItemEntries.removeRows();
        try {
            StringBuffer oSql = new StringBuffer("select");
            oSql.append(" rptItem.*");
            oSql.append(",keyNumber,keyLongNumber,keyName,value,remark");
            oSql.append(" where eliminationEntry='").append(this.elimEntryId).append("'");
            oSql.append(" order by rptItem.number");
            CoreBaseCollection collection = null;
            collection = this.isQueryBudget == 1 ? this.iHisElimDynaItemEntry.getCollection(oSql.toString()) : this.iElimDynaItemEntry.getCollection(oSql.toString());
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                BigDecimal value;
                IRow row;
                BillEntryBaseInfo element;
                if (this.isQueryBudget == 1) {
                    element = (HisElimDynaItemEntryInfo)iter.next();
                    row = this.kdtElimDynaItemEntries.addRow();
                    this.initDynaItemEditor(row, element.getRptItem());
                    row.getCell("rptItem").setValue((Object)element.getRptItem());
                    row.getCell("rptItemName").setValue((Object)element.getRptItem().getName());
                    row.getCell("keyNumber").setValue((Object)element.getKeyNumber());
                    row.getCell("keyNumber").setUserObject((Object)element.getKeyLongNumber());
                    row.getCell("keyName").setValue((Object)element.getKeyName());
                    value = element.getValue();
                    if (this.dc != element.getRptItem().getDc().getValue()) {
                        value = value.negate();
                    }
                    row.getCell("money").setValue((Object)value);
                    row.getCell("remark").setValue((Object)element.getRemark());
                    continue;
                }
                element = (ElimDynaItemEntryInfo)iter.next();
                row = this.kdtElimDynaItemEntries.addRow();
                this.initDynaItemEditor(row, element.getRptItem());
                row.getCell("rptItem").setValue((Object)element.getRptItem());
                row.getCell("rptItemName").setValue((Object)element.getRptItem().getName());
                row.getCell("keyNumber").setValue((Object)element.getKeyNumber());
                row.getCell("keyNumber").setUserObject((Object)element.getKeyLongNumber());
                row.getCell("keyName").setValue((Object)element.getKeyName());
                value = element.getValue();
                if (this.dc != element.getRptItem().getDc().getValue()) {
                    value = value.negate();
                }
                row.getCell("money").setValue((Object)value);
                row.getCell("remark").setValue((Object)element.getRemark());
            }
            this.saveLocalEditData(this.kdtElimDynaItemEntries, true);
        }
        catch (BOSException e) {
            logger.error((Object)"iElimDynaItemEntry.getCollectionBOSException", (Throwable)e);
        }
    }

    private void initContrastRptItems() throws BOSException {
        this.contrastRptItems.clear();
        String rptItemId = null;
        if (this.isQueryBudget == 1) {
            this.contrastRptItems.add(this.hisElimEntryInfo.getItem());
            rptItemId = this.hisElimEntryInfo.getItem().getId().toString();
        } else {
            this.contrastRptItems.add(this.elimEntryInfo.getItem());
            rptItemId = this.elimEntryInfo.getItem().getId().toString();
        }
        IDynaItem2ElimItem item2ElimItem = DynaItem2ElimItemFactory.getRemoteInstance();
        List rptItems = item2ElimItem.getContrastRptItems(rptItemId);
        this.contrastRptItems.addAll(rptItems);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionInsertLine.setEnabled(true);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void initBillHeader() {
        String resPath = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
        Integer rowNumber = (Integer)this.rowMap.get(this.elimEntryId);
        if (this.isQueryBudget == 1) {
            this.txtEliminationNumber.setText(this.hisElimEntryInfo.getElimination().getNumber() + "_" + rowNumber);
            this.txtCurrency.setText(this.hisElimEntryInfo.getElimination().getCurrency().getName());
            this.txtSourceCurrency.setText(this.hisElimEntryInfo.getElimination().getSourceCurrency().getName());
            this.txtRptItem.setText(this.hisElimEntryInfo.getItem().getName());
            DataElementInfo dataElement = DataElementProvider.getDataElementInfo(this.hisElimEntryInfo.getDataElement());
            this.txtDataElement.setText(String.valueOf(dataElement.getName()));
            this.txtValueType.setText(String.valueOf((Object)this.hisElimEntryInfo.getElimination().getValueType()));
            String tbHeader = EASResource.getString((String)resPath, (String)"TBH_DEBIT_MONEY");
            BigDecimal value = this.hisElimEntryInfo.getDebit();
            if (value == null || value.compareTo(new BigDecimal("0")) == 0) {
                this.dc = 0;
                value = this.hisElimEntryInfo.getCredit();
                tbHeader = EASResource.getString((String)resPath, (String)"TBH_CREDIT_MONEY");
            } else {
                this.dc = 1;
            }
            if (value == null) {
                value = new BigDecimal("0");
            }
            int precision = this.hisElimEntryInfo.getElimination().getCurrency().getPrecision();
            this.kdtElimDynaItemEntries.getHeadRow(0).getCell("money").setValue((Object)tbHeader);
            this.txtMoney.setText(CslRptUIUtil.groupBigDecimal(precision, value));
        } else {
            this.txtEliminationNumber.setText(this.elimEntryInfo.getElimination().getNumber() + "_" + rowNumber);
            this.txtCurrency.setText(this.elimEntryInfo.getElimination().getCurrency().getName());
            this.txtSourceCurrency.setText(this.elimEntryInfo.getElimination().getSourceCurrency().getName());
            this.txtRptItem.setText(this.elimEntryInfo.getItem().getName());
            DataElementInfo dataElement = DataElementProvider.getDataElementInfo(this.elimEntryInfo.getDataElement());
            this.txtDataElement.setText(String.valueOf(dataElement.getName()));
            this.txtValueType.setText(String.valueOf((Object)this.elimEntryInfo.getElimination().getValueType()));
            String tbHeader = EASResource.getString((String)resPath, (String)"TBH_DEBIT_MONEY");
            BigDecimal value = this.elimEntryInfo.getDebit();
            if (value == null || value.compareTo(new BigDecimal("0")) == 0) {
                this.dc = 0;
                value = this.elimEntryInfo.getCredit();
                tbHeader = EASResource.getString((String)resPath, (String)"TBH_CREDIT_MONEY");
            } else {
                this.dc = 1;
            }
            if (value == null) {
                value = new BigDecimal("0");
            }
            int precision = this.elimEntryInfo.getElimination().getCurrency().getPrecision();
            this.kdtElimDynaItemEntries.getHeadRow(0).getCell("money").setValue((Object)tbHeader);
            this.txtMoney.setText(CslRptUIUtil.groupBigDecimal(precision, value));
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Object owner = this.getUIContext().get("Owner");
        EliminationHandEditUI editOwner = null;
        List<String> ownerExDynaItemEntries = new ArrayList();
        if (owner instanceof EliminationHandEditUI) {
            editOwner = (EliminationHandEditUI)owner;
            ownerExDynaItemEntries = editOwner.existDyItemEntryIds;
        }
        this.setShowMessagePolicy(2);
        String resPath = "com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg";
        String hintInfo = EASResource.getString((String)resPath, (String)"SaveDataSuccess");
        BigDecimal sum = new BigDecimal("0");
        int count = this.kdtElimDynaItemEntries.getRowCount();
        if (count > 0) {
            ArrayList<ElimDynaItemEntryInfo> entries = new ArrayList<ElimDynaItemEntryInfo>();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                String msg;
                IRow row = this.kdtElimDynaItemEntries.getRow(i);
                Integer rowNumber = new Integer(i + 1);
                ElimDynaItemEntryInfo entryInfo = new ElimDynaItemEntryInfo();
                entryInfo.setEliminationEntry(this.elimEntryInfo);
                entryInfo.setAsstActTypeNumber((String)this.asstActTypeNumbers.get(this.elimEntryId + this.elimEntryInfo.getDataElement()));
                RPTItemInfo rptItem = (RPTItemInfo)row.getCell("rptItem").getValue();
                Object object = row.getCell("keyNumber").getValue();
                DynamicItemBean dynamicItem = (DynamicItemBean)row.getUserObject();
                if (rptItem == null) {
                    msg = EASResource.getString((String)resPath, (String)"RptItemIsNull");
                    MsgBox.showInfo((String)MessageFormat.format(msg, rowNumber));
                    SysUtil.abort();
                } else if (object == null || StringUtils.isEmpty((String)object.toString())) {
                    msg = EASResource.getString((String)resPath, (String)"DynamicItemIsNull");
                    MsgBox.showInfo((String)MessageFormat.format(msg, rowNumber));
                    SysUtil.abort();
                } else if (row.getCell("money").getValue() == null) {
                    msg = EASResource.getString((String)resPath, (String)"MoneyIsNull");
                    MsgBox.showInfo((String)MessageFormat.format(msg, rowNumber));
                    SysUtil.abort();
                } else if (list.contains(object)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"112_DynamicItem_Repeat"));
                    SysUtil.abort();
                }
                entryInfo.setRptItem(rptItem);
                list.add(object.toString());
                if (dynamicItem == null) {
                    entryInfo.setKeyNumber(row.getCell("keyNumber").getValue() != null ? row.getCell("keyNumber").getValue().toString() : (String)row.getCell("keyNumber").getValue());
                    if (row.getCell("keyNumber").getUserObject() == null) {
                        entryInfo.setKeyLongNumber((String)row.getCell("keyNumber").getValue());
                    } else {
                        entryInfo.setKeyLongNumber((String)row.getCell("keyNumber").getUserObject());
                    }
                    entryInfo.setKeyName(row.getCell("keyName").getValue() != null ? row.getCell("keyName").getValue().toString() : (String)row.getCell("keyName").getValue());
                } else {
                    entryInfo.setKeyNumber(dynamicItem.getNumber());
                    entryInfo.setKeyLongNumber(dynamicItem.getLongNumber());
                    entryInfo.setKeyName(dynamicItem.getName());
                }
                if (row.getCell("money").getValue() != null) {
                    BigDecimal value = (BigDecimal)row.getCell("money").getValue();
                    sum = sum.add(value);
                    if (this.dc != rptItem.getDc().getValue()) {
                        value = value.negate();
                    }
                    entryInfo.setValue(value);
                }
                entryInfo.setRemark((String)row.getCell("remark").getValue());
                entries.add(entryInfo);
            }
            BigDecimal elmiValue = this.elimEntryInfo.getDebit();
            if (elmiValue == null || elmiValue.compareTo(new BigDecimal("0")) == 0) {
                elmiValue = this.elimEntryInfo.getCredit();
            }
            if (sum.compareTo(elmiValue) != 0) {
                int precision = this.elimEntryInfo.getElimination().getCurrency().getPrecision();
                String msg = EASResource.getString((String)resPath, (String)"SumValueNotEqual");
                if (0 == MsgBox.showConfirm2((Component)((Object)this), (String)(msg = MessageFormat.format(msg, CslRptUIUtil.groupBigDecimal(precision, sum), CslRptUIUtil.groupBigDecimal(precision, elmiValue))))) {
                    this.iElimDynaItemEntry.saveDynamicElimnItems(entries);
                    this.saveLocalEditData(this.kdtElimDynaItemEntries, true);
                    this.setMessageText(hintInfo);
                    this.setIsShowTextOnly(false);
                    this.showMessage();
                    this.isAddedLine = false;
                }
            } else {
                this.iElimDynaItemEntry.saveDynamicElimnItems(entries);
                this.saveLocalEditData(this.kdtElimDynaItemEntries, true);
                this.setMessageText(hintInfo);
                this.setIsShowTextOnly(false);
                this.showMessage();
                this.isAddedLine = false;
            }
            if (!ownerExDynaItemEntries.contains(this.elimEntryId)) {
                ownerExDynaItemEntries.add(this.elimEntryId);
            }
        } else {
            this.iElimDynaItemEntry.deleteDyItemsByElimEntryId(this.elimEntryId);
            this.saveLocalEditData(this.kdtElimDynaItemEntries, true);
            this.setMessageText(hintInfo);
            this.setIsShowTextOnly(false);
            this.showMessage();
            this.isAddedLine = false;
            ownerExDynaItemEntries.remove(this.elimEntryId);
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.elimEntryId = (String)this.existDyItemEntries.get(0);
        this.initEditData();
        this.updateButtonStatus();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        int row = this.existDyItemEntries.indexOf(this.elimEntryId);
        this.elimEntryId = (String)this.existDyItemEntries.get(row - 1);
        this.initEditData();
        this.updateButtonStatus();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        int row = this.existDyItemEntries.indexOf(this.elimEntryId);
        this.elimEntryId = (String)this.existDyItemEntries.get(row + 1);
        this.initEditData();
        this.updateButtonStatus();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.elimEntryId = (String)this.existDyItemEntries.get(this.existDyItemEntries.size() - 1);
        this.initEditData();
        this.updateButtonStatus();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ElimDynaItemEntryFactory.getRemoteInstance();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        IRow row = this.kdtElimDynaItemEntries.addRow();
        this.initDynaItemEditor(row, null);
        this.autoSelectFirstRptItem(row);
        this.isAddedLine = true;
    }

    private void autoSelectFirstRptItem(IRow row) throws UIException, BOSException {
        int rowIndex = row.getRowIndex();
        if (this.contrastRptItems.size() > 0 && rowIndex > -1) {
            row.getCell("rptItemName").setValue((Object)((RPTItemInfo)this.contrastRptItems.get(0)).getName());
            row.getCell("rptItem").setValue(this.contrastRptItems.get(0));
            this.initDynaItemEditor(0, rowIndex);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
        int row = this.kdtElimDynaItemEntries.getRowCount();
        if (this.kdtElimDynaItemEntries.getSelectManager().get() != null) {
            row = this.kdtElimDynaItemEntries.getSelectManager().get().getBeginRow();
        }
        IRow tableRow = this.kdtElimDynaItemEntries.addRow(row);
        this.initDynaItemEditor(tableRow, null);
        this.autoSelectFirstRptItem(tableRow);
        this.isAddedLine = true;
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        if (this.kdtElimDynaItemEntries.getSelectManager().get() != null) {
            int row = this.kdtElimDynaItemEntries.getSelectManager().get().getBeginRow();
            this.kdtElimDynaItemEntries.removeRow(row);
            this.isAddedLine = true;
        }
    }

    public boolean isModify() {
        if (!this.btnSubmit.isEnabled()) {
            return false;
        }
        this.saveLocalEditData(this.kdtElimDynaItemEntries, false);
        if (super.isModify()) {
            return true;
        }
        return this.localEditData == null || this.localEditData.isValueChange();
    }

    private void saveLocalEditData(KDTable table, boolean isCopyNewToOld) {
        if (table == null) {
            return;
        }
        if (this.localEditData == null) {
            this.localEditData = new CoreBaseCollection();
        }
        this.localEditData.clear();
        for (int index = table.getRowCount() - 1; index >= 0; --index) {
            BillEntryBaseInfo entry;
            IRow row = table.getRow(index);
            if (row == null) continue;
            BigDecimal money = (BigDecimal)row.getCell("money").getValue();
            if (money != null) {
                money = money.setScale(8);
            }
            if (this.isQueryBudget == 1) {
                entry = new HisAdjustDynamicItemInfo();
                entry.setRptItem((RPTItemInfo)row.getCell("rptItem").getValue());
                entry.setKeyName((String)row.getCell("keyNumber").getValue());
                entry.setValue(money);
                entry.setRemark((String)row.getCell("remark").getValue());
                this.localEditData.add((CoreBaseInfo)entry);
                continue;
            }
            entry = new AdjustDynamicItemInfo();
            entry.setRptItem((RPTItemInfo)row.getCell("rptItem").getValue());
            entry.setKeyName((String)row.getCell("keyNumber").getValue());
            entry.setValue(money);
            entry.setRemark((String)row.getCell("remark").getValue());
            this.localEditData.add((CoreBaseInfo)entry);
        }
        if (isCopyNewToOld) {
            this.localEditData.copyNewToOld();
        }
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }
}

