/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationMode;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EliminationFilterUI
extends AbstractEliminationFilterUI {
    private static Logger logger = Logger.getLogger(EliminationFilterUI.class);
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private String whichOpen = null;
    private boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(null);
    private IDataElement iDataElement = null;
    private boolean isSupport13Period;
    protected ICSLContext cslCtx = null;
    protected boolean isLoaded = false;
    private boolean isFromCslMerge = false;

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }

    protected void initCSLContext() {
        if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    public EliminationFilterUI() throws Exception {
    }

    public void onLoad() throws Exception {
        this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        this.initCSLContext();
        super.onLoad();
        this.initInvCompanyAndTargetCompany();
        this.initElimTemplateF7();
    }

    public EliminationFilterUI(String openSource) throws Exception {
        this.init(openSource);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initListener() {
        super.initListener();
        CslRptUIUtil.addSynchValueListener((IKDComponent)this.bizPrmtItemFrom, (IKDComponent)this.bizPrmtItemTo);
        CslRptUIUtil.addSynchValueListener((IKDComponent)this.txtNumberFrom, (IKDComponent)this.txtNumberTo);
        CslRptUIUtil.addSynchValueListener((IKDComponent)this.txtDebitFrom, (IKDComponent)this.txtDebitTo);
        CslRptUIUtil.addSynchValueListener((IKDComponent)this.txtCreditFrom, (IKDComponent)this.txtCreditTo);
    }

    private void init(String openSource) throws Exception {
        this.whichOpen = openSource;
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.cbxElimType.addItem((Object)this.selectAll);
        this.cbxElimType.setSelectedItem((Object)this.selectAll);
        this.cbxElimType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.cbxElimType.addItem((Object)ElimTypeEnum.exchange);
        this.cbxElimType.addItem((Object)ElimTypeEnum.General);
        this.cbxElimType.addItem((Object)ElimTypeEnum.MAIN_INVEST);
        this.cbxElimType.addItem((Object)ElimTypeEnum.HK_COST);
        this.cbxElimType.addItem((Object)ElimTypeEnum.MAIN_COST);
        this.cbxElimType.addItem((Object)ElimTypeEnum.Main_Invest_New);
        this.bizDataElement.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        this.bizDataElement.setEditFormat("$number$");
        this.bizDataElement.setDisplayFormat("$name$");
        this.bizDataElement.setEditable(true);
        this.bizDataElement.setCommitFormat("$number$");
        CslGradeManageUtil.setDataElementF7GMFilter((KDBizPromptBox)this.bizDataElement, null, (boolean)false);
        if (this.whichOpen.equals("Hand")) {
            this.cbxElimType.setSelectedItem((Object)ElimTypeEnum.General);
            this.cbxElimType.setEnabled(false);
            this.bizDataElement.setEnabled(true);
        } else if (this.whichOpen.equals("Auto")) {
            this.cbxElimType.setSelectedItem((Object)this.selectAll);
            this.cbxElimType.removeItem((Object)ElimTypeEnum.General);
            this.bizDataElement.setEnabled(true);
        } else if (this.whichOpen.equals("All")) {
            this.cbxElimType.setSelectedIndex(0);
            this.cbxElimType.setEnabled(true);
            this.bizDataElement.setEnabled(true);
        }
        this.cbxCurrency.addItem((Object)this.selectAll);
        this.cbxCurrency.setSelectedIndex(0);
        this.cbxSourceCurrency.addItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedIndex(0);
        CurrencyCollection currencyCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cbxCurrency.addItem((Object)currencyCollection.get(i));
                this.cbxSourceCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        this.bizPrmtItemFrom.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemFrom.setEditFormat("$number$");
        this.bizPrmtItemFrom.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemFrom.setEditable(true);
        this.bizPrmtItemFrom.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizPrmtItemFrom, null);
        this.bizPrmtItemTo.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemTo.setEditFormat("$number$");
        this.bizPrmtItemTo.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemTo.setEditable(true);
        this.bizPrmtItemTo.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizPrmtItemTo, null);
        this.txtDebitFrom.setDataType(1);
        this.txtDebitFrom.setPrecision(2);
        this.txtDebitFrom.setNegatived(true);
        this.txtDebitFrom.setEditable(true);
        this.txtDebitFrom.setSupportedEmpty(true);
        this.txtDebitTo.setDataType(1);
        this.txtDebitTo.setPrecision(2);
        this.txtDebitTo.setNegatived(true);
        this.txtDebitTo.setEditable(true);
        this.txtDebitTo.setSupportedEmpty(true);
        this.txtCreditFrom.setDataType(1);
        this.txtCreditFrom.setPrecision(2);
        this.txtCreditFrom.setNegatived(true);
        this.txtCreditFrom.setEditable(true);
        this.txtCreditFrom.setSupportedEmpty(true);
        this.txtCreditTo.setDataType(1);
        this.txtCreditTo.setPrecision(2);
        this.txtCreditTo.setNegatived(true);
        this.txtCreditTo.setEditable(true);
        this.txtCreditTo.setSupportedEmpty(true);
        this.cmbxAuditStatus.addItem((Object)this.selectAll);
        this.cmbxAuditStatus.addItems(CheckedStatusEnum.getEnumList().toArray());
        this.comboElimMode.addItem((Object)this.selectAll);
        IEliminationMode iElimMode = EliminationModeFactory.getRemoteInstance();
        EntityViewInfo elimMode = new EntityViewInfo();
        elimMode.getSelector().add(new SelectorItemInfo("id"));
        elimMode.getSelector().add(new SelectorItemInfo("number"));
        elimMode.getSelector().add(new SelectorItemInfo("name"));
        elimMode.getSorter().add(new SorterItemInfo("number"));
        CslGradeManageUtil.filterElimModeGradeManage((EntityViewInfo)elimMode, null);
        EliminationModeCollection collection = iElimMode.getEliminationModeCollection(elimMode);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                this.comboElimMode.addItem((Object)collection.get(i));
            }
        }
    }

    private void initInvCompanyAndTargetCompany() throws Exception {
        if (this.isFromCslMerge) {
            return;
        }
        OrgTreeInfo tree = this.getCSLContext().getCurOrgBound();
        OrgUnitInfo unit = this.getCSLContext().getCurOrgGroup();
        if (tree != null && unit != null) {
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1);
            f7.setTreeID(tree.getId().toString());
            f7.setMultiSelect(false);
            f7.setNeedAddOrgRange(false);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            this.invCompanyF7.setSelector((KDPromptSelector)f7);
            this.invCompanyF7.setEditable(true);
            this.invCompanyF7.setHRHistoryEnbable(false);
            this.invCompanyF7.setCommitFormat("$number$");
            this.invCompanyF7.setDisplayFormat("$name$");
            this.targetCompanyF7.setSelector((KDPromptSelector)f7);
            this.targetCompanyF7.setEditable(true);
            this.targetCompanyF7.setHRHistoryEnbable(false);
            this.targetCompanyF7.setCommitFormat("$number$");
            this.targetCompanyF7.setDisplayFormat("$name$");
            this.bizCompany.setSelector((KDPromptSelector)f7);
            this.bizCompany.setEditable(true);
            this.bizCompany.setHRHistoryEnbable(false);
            this.bizCompany.setCommitFormat("$number$");
            this.bizCompany.setDisplayFormat("$name$");
        }
    }

    private void initElimTemplateF7() throws Exception {
        if (!this.isFromCslMerge) {
            this.templateF7.setEditable(false);
            this.templateF7.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.InvestTempleteQuery");
            this.templateF7.setHRHistoryEnbable(false);
            this.templateF7.setCommitFormat("$number$");
            this.templateF7.setDisplayFormat("$name$");
            this.templateF7.setEnabledMultiSelection(true);
        }
    }

    public SorterItemCollection getSorterItems() {
        return super.getSorterItems();
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterItemTo;
        String orgId;
        String summary;
        String customNumber;
        FilterItemInfo item;
        FilterItemInfo filterItemCurrency;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        try {
            FilterItemInfo filterItem5;
            FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.id", (Object)this.getCSLContext().getCurOrgBound().getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItem1 = new FilterItemInfo("periodType", (Object)new Integer(this.getCSLContext().getCurRptPeriodType().getValue()), CompareType.EQUALS);
            FilterItemInfo filterItem2 = new FilterItemInfo("year", (Object)new Integer(this.getCSLContext().getCurRptYear()), CompareType.EQUALS);
            FilterItemInfo filterItem3 = new FilterItemInfo("period", (Object)new Integer(this.getCSLContext().getCurRptPeriod()), CompareType.EQUALS);
            OrgUnitInfo uif = this.getCSLContext().getCurOrgGroup();
            String number = CslRptUIUtil.getCompanyStructureNumber(this.getCSLContext().getCurOrgBound(), uif);
            FilterItemInfo filterItem4 = new FilterItemInfo("structure.longNumber", (Object)number, CompareType.EQUALS);
            String dataCollectNumber = this.getCSLContext().getCurDataCollect().getNumber();
            if (dataCollectNumber == null || dataCollectNumber.length() == 0) {
                dataCollectNumber = "ACTUALDATA";
            }
            FilterItemInfo filterItem10 = new FilterItemInfo("dataCollect.number", (Object)dataCollectNumber, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem0);
            ++formulaIndex;
            this.filterInfo.getFilterItems().add(filterItem1);
            ++formulaIndex;
            this.filterInfo.getFilterItems().add(filterItem2);
            ++formulaIndex;
            this.filterInfo.getFilterItems().add(filterItem3);
            ++formulaIndex;
            this.filterInfo.getFilterItems().add(filterItem4);
            ++formulaIndex;
            this.filterInfo.getFilterItems().add(filterItem10);
            ++formulaIndex;
            if (this.whichOpen.equals("Auto")) {
                filterItem5 = new FilterItemInfo("elimType", (Object)new Integer(2), CompareType.NOTEQUALS);
                this.filterInfo.getFilterItems().add(filterItem5);
                ++formulaIndex;
            } else if (this.whichOpen.equals("Hand")) {
                filterItem5 = new FilterItemInfo("elimType", (Object)new Integer(2), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItem5);
                ++formulaIndex;
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (this.cbxCurrency.getSelectedItem() != null && !this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            ++formulaIndex;
        }
        if (this.cbxSourceCurrency.getSelectedItem() != null && !this.cbxSourceCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("sourceCurrency.id", (Object)((CurrencyInfo)this.cbxSourceCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            ++formulaIndex;
        }
        if (this.cbxElimType.getSelectedItem() != null && !this.cbxElimType.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterElimType = new FilterItemInfo("elimType", (Object)new Integer(((ElimTypeEnum)((Object)this.cbxElimType.getSelectedItem())).getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterElimType);
            ++formulaIndex;
        }
        if (this.bizDataElement.getValue() != null) {
            FilterItemInfo filterDataElement = new FilterItemInfo("entries.dataElement", (Object)new Integer(((DataElementInfo)this.bizDataElement.getValue()).getInterSeq()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterDataElement);
            ++formulaIndex;
        }
        if (this.bizPrmtItemFrom.getData() != null) {
            String itemNumberFrom = ((RPTItemInfo)this.bizPrmtItemFrom.getData()).getNumber();
            FilterItemInfo filterItemFrom = new FilterItemInfo("item.number", (Object)itemNumberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemFrom);
            ++formulaIndex;
        }
        if (this.bizPrmtItemTo.getData() != null) {
            String itemNumberTo = ((RPTItemInfo)this.bizPrmtItemTo.getData()).getNumber();
            FilterItemInfo filterItemTo2 = new FilterItemInfo("item.number", (Object)itemNumberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo2);
            ++formulaIndex;
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            String numberFrom = this.txtNumberFrom.getText().trim();
            FilterItemInfo filterNumberFrom = new FilterItemInfo("number", (Object)numberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberFrom);
            ++formulaIndex;
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            String numberTo = this.txtNumberTo.getText().trim();
            FilterItemInfo filterNumberTo = new FilterItemInfo("number", (Object)numberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberTo);
            ++formulaIndex;
        }
        if (this.txtDebitFrom.getText() != null && this.txtDebitFrom.getText().trim().length() > 0) {
            BigDecimal debitFrom = this.txtDebitFrom.getBigDecimalValue();
            FilterItemInfo filterDebitFrom = new FilterItemInfo("entries.debit", (Object)debitFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitFrom);
            ++formulaIndex;
        }
        if (this.txtDebitTo.getText() != null && this.txtDebitTo.getText().trim().length() > 0) {
            BigDecimal debitTo = this.txtDebitTo.getBigDecimalValue();
            FilterItemInfo filterDebitTo = new FilterItemInfo("entries.debit", (Object)debitTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitTo);
            ++formulaIndex;
        }
        if (this.txtCreditFrom.getText() != null && this.txtCreditFrom.getText().trim().length() > 0) {
            BigDecimal creditFrom = this.txtCreditFrom.getBigDecimalValue();
            FilterItemInfo filterCreditFrom = new FilterItemInfo("entries.credit", (Object)creditFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditFrom);
            ++formulaIndex;
        }
        if (this.txtCreditTo.getText() != null && this.txtCreditTo.getText().trim().length() > 0) {
            BigDecimal creditTo = this.txtCreditTo.getBigDecimalValue();
            FilterItemInfo filterCreditTo = new FilterItemInfo("entries.credit", (Object)creditTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditTo);
            ++formulaIndex;
        }
        formulaIndex = this.filterInfo.getFilterItems().size();
        if (this.cmbxAuditStatus.getSelectedIndex() > 0) {
            CheckedStatusEnum auditStatus = (CheckedStatusEnum)this.cmbxAuditStatus.getSelectedItem();
            FilterItemInfo item2 = new FilterItemInfo("CheckedStatus", (Object)new Integer(auditStatus.getValue()));
            this.filterInfo.getFilterItems().add(item2);
            ++formulaIndex;
        }
        if (!StringUtils.isEmpty((String)this.txtCreator.getText())) {
            item = new FilterItemInfo("creator.name", (Object)("%" + this.txtCreator.getText() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(item);
            ++formulaIndex;
        }
        if (!StringUtils.isEmpty((String)this.txtAuditor.getText())) {
            item = new FilterItemInfo("auditor.name", (Object)("%" + this.txtAuditor.getText() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(item);
            ++formulaIndex;
        }
        if (this.comboElimMode.getSelectedItem() != null && !this.comboElimMode.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterModeInfo = new FilterItemInfo("eliminationMode.id", (Object)((EliminationModeInfo)this.comboElimMode.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterModeInfo);
            ++formulaIndex;
        }
        if (!StringUtils.isEmpty((String)(customNumber = this.txtCustomNumber.getText()))) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("customNumber", (Object)("%" + customNumber + "%"), CompareType.LIKE));
            ++formulaIndex;
        }
        if (!StringUtils.isEmpty((String)(summary = this.txtSummary.getText().trim()))) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("entries.summary", (Object)("%" + summary + "%"), CompareType.LIKE));
            ++formulaIndex;
        }
        if (this.invCompanyF7.getData() != null) {
            orgId = ((OrgUnitInfo)this.invCompanyF7.getData()).getId().toString();
            filterItemTo = new FilterItemInfo("invCompany.id", (Object)orgId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            ++formulaIndex;
        }
        if (this.targetCompanyF7.getData() != null) {
            orgId = ((OrgUnitInfo)this.targetCompanyF7.getData()).getId().toString();
            filterItemTo = new FilterItemInfo("targetCompany.id", (Object)orgId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            ++formulaIndex;
        }
        if (this.bizCompany.getData() != null) {
            orgId = ((OrgUnitInfo)this.bizCompany.getData()).getId().toString();
            filterItemTo = new FilterItemInfo("company.id", (Object)orgId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            ++formulaIndex;
        }
        if (this.templateF7.getData() != null) {
            Object tempData = this.templateF7.getData();
            HashSet<String> tmplIds = new HashSet<String>();
            if (tempData instanceof Object[]) {
                Object[] tempVals;
                for (Object tempInfo : tempVals = (Object[])tempData) {
                    if (tempInfo == null) continue;
                    tmplIds.add(((InvestTempletInfo)tempInfo).getId().toString());
                }
            }
            if (tmplIds.size() > 0) {
                FilterItemInfo filterItemTo3 = new FilterItemInfo("allElimTemplate.id", tmplIds, CompareType.INCLUDE);
                this.filterInfo.getFilterItems().add(filterItemTo3);
                ++formulaIndex;
            }
        }
        StringBuffer sbFormula = new StringBuffer();
        for (int i = 0; i < formulaIndex; ++i) {
            sbFormula.append(i == 0 ? "(#" : " and (#").append(i).append(")");
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void clearUI() {
        this.cbxCurrency.setSelectedItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll);
        if (this.whichOpen.equals("Hand")) {
            this.cbxElimType.setSelectedItem((Object)ElimTypeEnum.General);
            this.cbxElimType.setEnabled(false);
        } else if (this.whichOpen.equals("Auto")) {
            this.cbxElimType.setSelectedItem((Object)this.selectAll);
            this.cbxElimType.setEnabled(true);
        } else if (this.whichOpen.equals("All")) {
            this.cbxElimType.setSelectedItem((Object)this.selectAll);
            this.cbxElimType.setEnabled(true);
        }
        this.bizDataElement.setValue(null);
        this.bizDataElement.setEnabled(true);
        this.bizPrmtItemFrom.setData(null);
        this.bizPrmtItemTo.setData(null);
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.txtDebitFrom.setValue(null);
        this.txtDebitTo.setValue(null);
        this.txtCreditFrom.setValue(null);
        this.txtCreditTo.setValue(null);
        this.cmbxAuditStatus.setSelectedIndex(0);
        this.txtCreator.setText(null);
        this.txtAuditor.setText(null);
        this.comboElimMode.setSelectedItem((Object)this.selectAll);
        this.txtCustomNumber.setText(null);
        this.txtSummary.setText(null);
        this.invCompanyF7.setData(null);
        this.targetCompanyF7.setData(null);
        this.bizCompany.setData(null);
        this.templateF7.setData(null);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        block13: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            OrgUnitInfo org;
            ObjectUuidPK pk;
            String orgId;
            CurrencyInfo currencyInfo;
            String currencyId;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("elimType")) {
                this.cbxElimType.setSelectedItem((Object)ElimTypeEnum.getEnum(Integer.parseInt(filterItemInfo.getCompareValue().toString())));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.dataElement")) {
                try {
                    this.iDataElement = DataElementFactory.getRemoteInstance();
                    this.bizDataElement.setValue((Object)this.iDataElement.getDataElementByInterSeq((Integer)filterItemInfo.getCompareValue()));
                }
                catch (EASBizException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)e);
                }
                catch (BOSException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxCurrency.setSelectedIndex(j);
                    continue block13;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("sourceCurrency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxSourceCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxSourceCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxSourceCurrency.setSelectedIndex(j);
                    continue block13;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("item.number")) {
                String itemNumber = (String)filterItemInfo.getCompareValue();
                try {
                    RPTItemInfo rptItemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo("select number, name where number = '" + itemNumber + "'");
                    if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                        this.bizPrmtItemFrom.setData((Object)rptItemInfo);
                        continue;
                    }
                    this.bizPrmtItemTo.setData((Object)rptItemInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtNumberFrom.setText(number);
                    continue;
                }
                this.txtNumberTo.setText(number);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.debit")) {
                BigDecimal debit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtDebitFrom.setValue((Object)debit);
                    continue;
                }
                this.txtDebitTo.setValue((Object)debit);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.credit")) {
                BigDecimal credit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtCreditFrom.setValue((Object)credit);
                    continue;
                }
                this.txtCreditTo.setValue((Object)credit);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("CheckedStatus")) {
                Integer auditStatus = (Integer)filterItemInfo.getCompareValue();
                if (auditStatus == 1) {
                    this.cmbxAuditStatus.setSelectedIndex(1);
                    continue;
                }
                this.cmbxAuditStatus.setSelectedIndex(2);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("creator.name")) {
                String creator = (String)filterItemInfo.getCompareValue();
                this.txtCreator.setText(creator.replaceAll("%", ""));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("auditor.name")) {
                String auditor = (String)filterItemInfo.getCompareValue();
                this.txtAuditor.setText(auditor.replaceAll("%", ""));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("eliminationMode.id")) {
                String eliminationModeId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.comboElimMode.getItemCount(); ++j) {
                    EliminationModeInfo elimMode = (EliminationModeInfo)this.comboElimMode.getItemAt(j);
                    if (!eliminationModeId.equals(elimMode.getId().toString())) continue;
                    this.comboElimMode.setSelectedIndex(j);
                    continue block13;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("customNumber")) {
                String customNumber = filterItemInfo.getCompareValue().toString();
                this.txtCustomNumber.setText(customNumber.replaceAll("%", ""));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.summary")) {
                String summary = filterItemInfo.getCompareValue().toString();
                this.txtSummary.setText(summary.replaceAll("%", ""));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("invCompany.id")) {
                orgId = filterItemInfo.getCompareValue().toString();
                BOSUuid uuid = BOSUuid.read((String)orgId);
                pk = new ObjectUuidPK(uuid);
                try {
                    org = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)pk);
                    this.invCompanyF7.setData((Object)org);
                }
                catch (Exception e) {
                    logger.error((Object)"get org error ", (Throwable)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("targetCompany.id")) {
                orgId = filterItemInfo.getCompareValue().toString();
                BOSUuid uuid = BOSUuid.read((String)orgId);
                pk = new ObjectUuidPK(uuid);
                try {
                    org = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)pk);
                    this.targetCompanyF7.setData((Object)org);
                }
                catch (Exception e) {
                    logger.error((Object)"get org error ", (Throwable)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("company.id")) {
                orgId = filterItemInfo.getCompareValue().toString();
                BOSUuid uuid = BOSUuid.read((String)orgId);
                pk = new ObjectUuidPK(uuid);
                try {
                    org = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)pk);
                    this.bizCompany.setData((Object)org);
                }
                catch (Exception e) {
                    logger.error((Object)"get org error ", (Throwable)e);
                }
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("allElimTemplate.id")) continue;
            String templateId = filterItemInfo.getCompareValue().toString();
            BOSUuid uuid = BOSUuid.read((String)templateId);
            pk = new ObjectUuidPK(uuid);
            try {
                InvestTempletInfo template = InvestTempletFactory.getRemoteInstance().getInvestTempletInfo((IObjectPK)pk);
                this.templateF7.setData((Object)template);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"get org error ", (Throwable)e);
            }
        }
    }
}

