/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.ArchivedStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.EliminationCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationHandListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.ConvtEliminationListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptClientHelperUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ElimDynaUIHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.EliminationFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.EliminationTemplateBatchImportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataCatcherListener;
import com.kingdee.eas.fi.rpt.DisplayTemplateTypeEnum;
import com.kingdee.eas.fi.rpt.client.GroupTreecomponent;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.Action;

public class EliminationHandListUI
extends AbstractEliminationHandListUI
implements ICSLContextUI,
DataCatcherListener {
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    ICSLContext ctx = CSLContextHelper.getCSLContext();
    CommonQueryDialog conditionDialog = null;
    EliminationFilterUI conditionPanel = null;
    private List existDyItemEntries = null;
    private List sortedDyItemEntries = null;
    private Map rowMap;
    private GroupTreecomponent tree;
    private boolean isSupportOtherDS = CSLParamUtil.isSupportOtherDS(null);
    private String number = null;

    public void refreshList() throws Exception {
        this.mainQuery = CSLContextHelper.updateCslCtxFilter(this.mainQuery, this.number);
        this.mainQuery.getSorter().clear();
        this.mainQuery.getSorter().add(new SorterItemInfo("number"));
        this.mainQuery.getSorter().add(new SorterItemInfo("entries.seq"));
        super.refreshList();
    }

    public void onLoad() throws Exception {
        this.btnMultiapprove.setEnabled(false);
        this.btnMultiapprove.setVisible(false);
        this.menuItemMultiapprove.setEnabled(false);
        this.btnNextPerson.setEnabled(false);
        this.btnNextPerson.setVisible(false);
        this.menuItemNextPerson.setEnabled(false);
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            this.tree = new GroupTreecomponent((ListUI)this, this.treeView, DisplayTemplateTypeEnum.ELIMINATION, CSLContextHelper.getCSLContext().getCurOrgGroup().castToFullOrgUnitInfo(), CSLContextHelper.getCSLContext().getCurOrgBound());
            this.tree.initialize();
            this.menuItemBatchMove.setCustomAction((Action)this.tree.getActionBatchMove());
            this.menuItemMoveGroupToSub.setCustomAction((Action)this.tree.getActionMoveToSubOrg());
            this.initWorkButton();
            CSLContextHelper.registUIObject(this);
            this.hideUnuseableButtons();
            this.tblMain.setColumnMoveable(true);
            this.tblMain.getViewManager().setFreezeView(0, 2);
            this.showUnEditableData();
            if (CSLContextHelper.getCSLContext().getCurPublishedStatus()) {
                this.rptArchive();
            }
            this.tblMain.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    int row = e.getSelectBlock().getBeginRow();
                    if (row >= 0) {
                        EliminationHandListUI.this.setCntrvlDynamicItem(row);
                    }
                }
            });
        } else {
            SysUtil.abort();
        }
        this.actionImportData.setVisible(true);
        this.actionSubImportData.setVisible(true);
        this.actionImportData.setEnabled(true);
        this.menuItemImportData.setEnabled(true);
        this.actionExportData.setVisible(true);
        this.actionExportData.setEnabled(true);
        ICSLContext cslCtx = CSLContextHelper.getCSLContext();
        OrgTreeInfo orgBound = cslCtx.getCurOrgBound();
        OrgUnitInfo company = cslCtx.getCurOrgGroup();
        if (orgBound != null && orgBound.getName() != null) {
            this.txtOrgBound.setText(orgBound.getName());
        }
        this.comboBoxCompany.removeAllItems();
        if (company != null) {
            this.comboBoxCompany.addItem((Object)company);
        }
        CslRptClientHelperUI.setCruYearAndPeriod(cslCtx, this.spCurYear, this.spCurPeriod);
        if (this.isSupportOtherDS) {
            this.tblMain.getColumn("datacollect").getStyleAttributes().setHided(false);
            if ("BUDGETDATA".equals(this.ctx.getCurDataCollect().getNumber())) {
                this.btnTemplateBatchImport.setEnabled(false);
                this.menuItemBatchImport.setEnabled(false);
            }
        } else {
            this.tblMain.getColumn("datacollect").getStyleAttributes().setHided(true);
        }
        if (CSLContextHelper.getCSLContext().isQueryBudget()) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("budgetHisQueryNotAllow"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refreshList();
        this.initExistDyItemsEntries();
    }

    protected ArrayList getImportParam() {
        String solutionName = "eas.fi.gr.elimination";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"451_EliminationHandListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        try {
            param.putContextParam((Object)"ORGTREE_ID", (Object)CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString());
            param.putContextParam((Object)"PERIOD_TYPE", (Object)CSLContextHelper.getCSLContext().getCurRptPeriodType());
            param.putContextParam((Object)"YEAR", (Object)new Integer(CSLContextHelper.getCSLContext().getCurRptYear()));
            param.putContextParam((Object)"PERIOD", (Object)new Integer(CSLContextHelper.getCSLContext().getCurRptPeriod()));
            param.putContextParam((Object)"DATE", (Object)CSLContextHelper.getCSLContext().getCurReportDate());
            param.putContextParam((Object)"ORGUNIT", (Object)CSLContextHelper.getCSLContext().getCurOrgGroup());
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return paramList;
    }

    @Override
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.ExportData();
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQuery", (Object)this.mainQuery);
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        String solutionName = "eas.fi.gr.elimination";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"451_EliminationHandListUI");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        param.varList.add("var");
        param.putContextParam((Object)"mainQueryPK", (Object)MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.gr.cslrpt.EliminationQueryForExport"));
        return paramList;
    }

    private void initExistDyItemsEntries() throws Exception {
        if (this.existDyItemEntries != null) {
            return;
        }
        String elimTypes = "2";
        ICSLContext context = CSLContextHelper.getCSLContext();
        this.existDyItemEntries = ElimDynaUIHelper.getExistDyItemsEntries(elimTypes, context, this.tblMain, "entries.id");
    }

    private void setCntrvlDynamicItem(int row) {
        if (row > -1) {
            String entryId = this.tblMain.getRow(row).getCell("entries.id").getValue().toString();
            boolean isExistDyitem = false;
            try {
                this.initExistDyItemsEntries();
                if (this.existDyItemEntries != null && this.existDyItemEntries.contains(entryId)) {
                    isExistDyitem = true;
                } else {
                    String orgTreeId = null;
                    if (this.ctx != null && this.ctx.getCurOrgBound() != null && this.ctx.getCurOrgBound().getId() != null) {
                        orgTreeId = this.ctx.getCurOrgBound().getId().toString();
                    }
                    if ((isExistDyitem = ElimDynaUIHelper.isExistsDyitemElimnByEntrieID(entryId, orgTreeId, this.ctx.isQueryBudget())) && this.existDyItemEntries != null && !this.existDyItemEntries.contains(entryId)) {
                        this.existDyItemEntries.add(entryId);
                    }
                }
            }
            catch (Exception e) {
                isExistDyitem = false;
                this.handUIExceptionAndAbort(e);
            }
            this.actionCntrvlDynamicItem.setEnabled(isExistDyitem);
        } else {
            this.actionCntrvlDynamicItem.setEnabled(false);
        }
    }

    protected void rptArchive() {
        this.btnAddNew.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnVoucher.setEnabled(false);
        this.btnDelVoucher.setEnabled(false);
        this.btnMultiapprove.setEnabled(false);
        this.btnCreateTo.setEnabled(false);
        this.btnNextPerson.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnAudit.setEnabled(false);
        this.btnUnAudit.setEnabled(false);
        this.menuItemAddNew.setEnabled(false);
        this.menuItemRemove.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        this.menuItemAudit.setEnabled(false);
        this.menuItemUnAudit.setEnabled(false);
        this.menuItemMultiapprove.setEnabled(false);
        this.menuItemNextPerson.setEnabled(false);
        this.actionAddNew.setEnabled(false);
        this.actionCopyTo.setEnabled(false);
        this.menuItemConvtElimination.setEnabled(false);
        this.btnTemplateBatchImport.setEnabled(false);
        this.menuItemBatchImport.setEnabled(false);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.showUnEditableData();
    }

    private void showUnEditableData() {
        if (this.tblMain != null || this.tblMain.getRowCount() != 0) {
            int n = this.tblMain.getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow row = this.tblMain.getRow(i);
                int currencyPrecision = (Integer)row.getCell("currency.precision").getValue();
                CslClientHelper.setPrecision(currencyPrecision, row, "entries.debit");
                CslClientHelper.setPrecision(currencyPrecision, row, "entries.credit");
                boolean isVisible = true;
                if (row.getCell("isVisible") != null && row.getCell("isVisible").getValue() != null) {
                    isVisible = (Boolean)row.getCell("isVisible").getValue();
                }
                if (isVisible) continue;
                if (row.getCell("entries.debit") != null && row.getCell("entries.debit").getValue() != null) {
                    row.getCell("entries.debit").getStyleAttributes().setBackground(new Color(0xF6F6BF));
                }
                if (row.getCell("entries.credit") == null || row.getCell("entries.credit").getValue() == null) continue;
                row.getCell("entries.credit").getStyleAttributes().setBackground(new Color(0xF6F6BF));
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.groupTableRow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getObjectUpdateId() {
        return super.getSelectedKeyValue();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.doRemove(e);
    }

    private void doRemove(ActionEvent e) throws Exception, BOSException, EASBizException {
        this.checkSelected();
        ArrayList lst = this.getSelectedIdValues();
        ArrayList lstApp = new ArrayList();
        try {
            if (this.confirmRemove()) {
                boolean isDel = this.checkIsExistConvtData(lst, lstApp);
                if (isDel && lstApp.size() > 0) {
                    for (int i = 0; i < lstApp.size(); ++i) {
                        if (lst.contains(lstApp.get(i))) continue;
                        lst.add(lstApp.get(i));
                    }
                }
                if (lst != null && lst.size() == 1) {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)lst.get(0))));
                    this.getSelfInterface().delete((IObjectPK)pk);
                } else if (lst != null && lst.size() > 0) {
                    this.getSelfInterface().removeBatch(lst);
                }
            }
            this.refresh(e);
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
    }

    private boolean checkIsExistConvtData(ArrayList lst, ArrayList lstApp) throws BOSException, Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select id,convertBefore,number where convertBefore in (");
        for (int i = 0; i < lst.size(); ++i) {
            sql.append("'").append(lst.get(i)).append("'").append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        sql.append(" and convertBefore is not null");
        EliminationCollection col = ((IElimination)this.getBizInterface()).getEliminationCollection(sql.toString());
        StringBuffer s = new StringBuffer();
        if (col != null && col.size() > 0) {
            for (int j = 0; j < col.size(); ++j) {
                EliminationInfo info = col.get(j);
                EliminationInfo infoConvtBefore = null;
                StringBuffer sql1 = new StringBuffer();
                sql1.append("select id,number where id =").append("'").append(info.getConvertBefore()).append("'");
                EliminationCollection col1 = ((IElimination)this.getBizInterface()).getEliminationCollection(sql1.toString());
                if (col1 != null && col1.size() > 0) {
                    infoConvtBefore = col1.get(0);
                }
                if (!(lst.contains(info.getId().toString()) && lst.contains(info.getConvertBefore()) || infoConvtBefore == null || s.toString().indexOf(infoConvtBefore.getNumber()) != -1)) {
                    s.append(infoConvtBefore.getNumber()).append(",");
                }
                lst.remove(info.getId().toString());
                lst.remove(info.getConvertBefore());
                if (!lstApp.contains(info.getId().toString())) {
                    lstApp.add(info.getId().toString());
                }
                if (lstApp.contains(info.getConvertBefore())) continue;
                lstApp.add(info.getConvertBefore());
            }
            if (s.length() > 0) {
                s.deleteCharAt(s.length() - 1);
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"39_EliminationHandListUI");
                int isDel = MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"292_AdjustEditUI"), (String)MessageFormat.format(msg, s.toString()));
                if (isDel == 0) {
                    return true;
                }
                if (isDel == 1) {
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.doAudit(e, CheckedStatusEnum.AUDITED);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.showUnEditableData();
    }

    protected void setPreSelecteRow() {
        super.setPreSelecteRow();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int selectedIndex = 0;
        if (selectRows != null && selectRows.length > 0) {
            selectedIndex = selectRows[0];
        }
        if (selectedIndex > this.tblMain.getRowCount()) {
            selectedIndex = this.tblMain.getRowCount() - 1;
        }
        if (this.tblMain.getRow(selectedIndex) != null) {
            this.tblMain.getSelectManager().select(selectedIndex, 0);
            this.tblMain.getLayoutManager().scrollRowToShow(selectedIndex);
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.doAudit(e, CheckedStatusEnum.UNAUDITED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAudit(ActionEvent e, CheckedStatusEnum status) throws Exception, BOSException, EASBizException {
        if (status.getValue() == 2) {
            super.actionAudit_actionPerformed(e);
        } else {
            super.actionUnAudit_actionPerformed(e);
        }
        this.checkSelected();
        ArrayList lst = this.getSelectedIdValues();
        try {
            this.requestAllObjectsLock(lst);
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
            if (status == CheckedStatusEnum.AUDITED) {
                boolean param = Boolean.valueOf(ParamManager.getParamValue(null, null, (String)"GR_CSL_DCBalance"));
                ArrayList<String> NoBalanceEntryIDList = new ArrayList<String>();
                String errMsg = null;
                int n = lst.size();
                for (int i = 0; i < n; ++i) {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)lst.get(i))));
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("*"));
                    selector.add(new SelectorItemInfo("entries.*"));
                    selector.add(new SelectorItemInfo("entries.item.number"));
                    selector.add(new SelectorItemInfo("entries.company.number"));
                    selector.add(new SelectorItemInfo("entries.company.name"));
                    EliminationInfo info = this.getSelfInterface().getEliminationInfo((IObjectPK)pk, selector);
                    if (info.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                        throw new AdjustException(AdjustException.EXIST_AUDITED_DATA);
                    }
                    if (param) {
                        BigDecimal debitSum = new BigDecimal(0.0);
                        BigDecimal creditSum = new BigDecimal(0.0);
                        EliminationEntryCollection eliminationEntryColl = info.getEntries();
                        EliminationEntryInfo eliminationEntryInfo = null;
                        for (int k = 0; eliminationEntryColl != null && k < eliminationEntryColl.size(); ++k) {
                            eliminationEntryInfo = eliminationEntryColl.get(k);
                            if (!eliminationEntryInfo.isIsVisible()) continue;
                            if (eliminationEntryInfo.getDebit() != null) {
                                debitSum = debitSum.add(eliminationEntryInfo.getDebit());
                                continue;
                            }
                            if (eliminationEntryInfo.getCredit() == null) continue;
                            creditSum = creditSum.add(eliminationEntryInfo.getCredit());
                        }
                        if (debitSum.compareTo(creditSum) != 0) {
                            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"8_AdjustListUI");
                            errMsg = MessageFormat.format(msg, info.getNumber(), debitSum, creditSum);
                            NoBalanceEntryIDList.add(errMsg);
                            continue;
                        }
                        this.getSelfInterface().audit((IObjectPK)pk, info, (IObjectPK)userPK);
                        continue;
                    }
                    this.getSelfInterface().audit((IObjectPK)pk, info, (IObjectPK)userPK);
                }
                if (NoBalanceEntryIDList.size() != 0) {
                    StringBuffer ErrMsg = new StringBuffer();
                    for (int i = 0; i < NoBalanceEntryIDList.size(); ++i) {
                        if (i >= 10) {
                            ErrMsg.append("...");
                            break;
                        }
                        ErrMsg.append(NoBalanceEntryIDList.get(i) + ";\r\n");
                    }
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"297_AdjustListUI"), (String)ErrMsg.toString(), (int)8188);
                    this.refreshScrollToSelect(e);
                    return;
                }
            } else if (status == CheckedStatusEnum.UNAUDITED) {
                int n = lst.size();
                for (int i = 0; i < n; ++i) {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)lst.get(i))));
                    EliminationInfo info = this.getSelfInterface().getEliminationInfo((IObjectPK)pk);
                    if (info.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
                        String resName = "Have_Not_Audited";
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)resName));
                        return;
                    }
                    if (info.getArchivedStatus().equals((Object)ArchivedStatusEnum.ARCHIVED)) {
                        String resName1 = "Elim_Has_Archived";
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)resName1));
                        return;
                    }
                    if (!user.getId().equals((Object)info.getAuditor().getId()) && CslRptUtil.canUnAuditCheck(null)) {
                        String resName2 = "Same_Auditor";
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)resName2));
                        return;
                    }
                    this.getSelfInterface().unAudit((IObjectPK)pk, info, (IObjectPK)userPK);
                }
            }
            this.refreshScrollToSelect(e);
            this.setNextMessageText(this.getMainStatusBar().getMsgLabel().getText());
            if (status.getValue() == 2) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"AuditSuccess"));
            } else {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"UnAuditSuccess"));
            }
            this.showMessage();
        }
        finally {
            this.releaseAllObjectsLock(lst);
        }
    }

    @Override
    public void actionTemplateBatchImport_actionPerformed(ActionEvent e) throws Exception {
        super.actionTemplateBatchImport_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"displayTypeId", (Object)this.tree.getRealSelectedNodeKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(EliminationTemplateBatchImportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private void requestAllObjectsLock(ArrayList lst) {
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            super.requestObjectLock(it.next().toString());
        }
    }

    private void releaseAllObjectsLock(ArrayList lst) {
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            super.releaseObjectLock(it.next().toString());
        }
    }

    private IElimination getSelfInterface() throws Exception {
        return EliminationFactory.getRemoteInstance();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filter;
        this.groupTableRow();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = EliminationHandListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        if (!this.isPerformDefaultQuery(iQuery, queryName)) {
            if (this.getConditionDialog().show()) {
                this.mainQuery = this.getConditionDialog().getEntityViewInfoResult();
                filter = this.mainQuery.getFilter();
                if (!this.menuItemShowAutoCreateItems.isSelected()) {
                    filter.getFilterItems().add(new FilterItemInfo("entries.isVisible", (Object)new Integer(1)));
                    String maskString = filter.getMaskString();
                    maskString = maskString + " and #" + (filter.getFilterItems().size() - 1);
                    filter.setMaskString(maskString);
                } else {
                    HashSet<Boolean> set = new HashSet<Boolean>();
                    set.add(new Boolean(false));
                    set.add(new Boolean(true));
                    filter.getFilterItems().add(new FilterItemInfo("entries.isVisible", set, CompareType.INNER));
                    String maskString = filter.getMaskString();
                    maskString = maskString + " and #" + (filter.getFilterItems().size() - 1);
                    filter.setMaskString(maskString);
                }
                this.doQuery(this.conditionDialog);
                if (this.tree != null) {
                    this.tree.refreshTree();
                }
                this.tblMain.removeRows();
                this.showUnEditableData();
            } else {
                SysUtil.abort();
            }
        } else {
            filter = this.mainQuery.getFilter();
            if (!this.menuItemShowAutoCreateItems.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("entries.isVisible", (Object)new Integer(1)));
                String maskString = filter.getMaskString();
                maskString = maskString + " and #" + (filter.getFilterItems().size() - 1);
                filter.setMaskString(maskString);
            } else {
                HashSet<Boolean> set = new HashSet<Boolean>();
                set.add(new Boolean(false));
                set.add(new Boolean(true));
                filter.getFilterItems().add(new FilterItemInfo("entries.isVisible", set, CompareType.INNER));
                String maskString = filter.getMaskString();
                maskString = maskString + " and #" + (filter.getFilterItems().size() - 1);
                filter.setMaskString(maskString);
            }
            if (this.tree != null) {
                this.tree.refreshTree();
            }
            this.tblMain.removeRows();
            this.showUnEditableData();
        }
        String format = CslRptUIUtil.getNationalTimeFormatString();
        if (format != null) {
            this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(format);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        try {
            FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.id", (Object)ctx.getCurOrgBound().getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItem1 = new FilterItemInfo("periodType", (Object)new Integer(ctx.getCurRptPeriodType().getValue()), CompareType.EQUALS);
            FilterItemInfo filterItem2 = new FilterItemInfo("year", (Object)new Integer(ctx.getCurRptYear()), CompareType.EQUALS);
            FilterItemInfo filterItem3 = new FilterItemInfo("period", (Object)new Integer(ctx.getCurRptPeriod()), CompareType.EQUALS);
            FilterItemInfo filterItem4 = new FilterItemInfo("elimType", (Object)new Integer(2), CompareType.EQUALS);
            OrgUnitInfo uif = ctx.getCurOrgGroup();
            this.number = CslRptUIUtil.getCompanyStructureNumber(ctx.getCurOrgBound(), uif);
            FilterItemInfo filterItem5 = new FilterItemInfo("structure.longNumber", (Object)this.number, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItem0);
            sbFormula.append(" #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem3);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem4);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem5);
            sbFormula.append(" and #" + formulaIndex++);
            if (this.isSupportOtherDS) {
                FilterItemInfo filterItem6 = new FilterItemInfo("dataCollect.number", (Object)ctx.getCurDataCollect().getNumber(), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItem6);
                sbFormula.append(" and #" + formulaIndex++);
            } else {
                FilterItemInfo filterItem7 = new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA", CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItem7);
                sbFormula.append(" and #" + formulaIndex++);
            }
            filterInfo.setMaskString(sbFormula.toString());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        evi.setFilter(filterInfo);
        return evi;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            dialog = this.getConditionDialog();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"No_FilterUI"));
            this.handUIException(e);
        }
        return dialog;
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"EliminationQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(455);
            this.conditionDialog.setHeight(350);
            this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Elimination_FilterUI_Title"));
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.gr.cslrpt.client.EliminationHandListUI");
        }
        return this.conditionDialog;
    }

    public EliminationFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new EliminationFilterUI("Hand");
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fi.gr.cslrpt.client.EliminationHandEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EliminationFactory.getRemoteInstance();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemConvtElimination.setEnabled(true);
        this.menuItemConvtElimination.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
    }

    protected void hideUnuseableButtons() {
        this.btnCreateTo.setVisible(false);
        this.actionCreateTo.setEnabled(false);
        this.btnCopyTo.setVisible(false);
        this.actionCopyTo.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.btnTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.btnTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.btnDelVoucher.setVisible(false);
        this.actionDelVoucher.setEnabled(false);
        this.btnVoucher.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.btnFilter.setVisible(false);
        this.actionFilter.setEnabled(false);
    }

    public boolean destroyWindow() {
        CSLContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, (CoreUI)this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        EliminationInfo info = ((IElimination)this.getBizInterface()).getEliminationInfo((IObjectPK)pk);
        if (info.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            String resName = "Can_Not_Edit";
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)resName));
        } else {
            super.requestObjectLock(this.getObjectUpdateId());
            super.actionEdit_actionPerformed(e);
        }
        this.getUIContext().put("existDyItemEntries", this.existDyItemEntries);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"existDyItemEntries", (Object)this.existDyItemEntries);
        uiContext.put((Object)"displayTypeId", (Object)this.tree.getRealSelectedNodeKeyValue());
    }

    private void groupTableRow() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn(0).setGroup(true);
        this.tblMain.getColumn(1).setGroup(true);
        this.tblMain.getColumn(2).setGroup(true);
        this.tblMain.getColumn(3).setGroup(true);
        this.tblMain.getColumn(4).setGroup(true);
        this.tblMain.getColumn(5).setGroup(true);
        this.tblMain.getColumn(6).setGroup(true);
        this.tblMain.getColumn(7).setGroup(true);
        this.tblMain.getColumn(8).setGroup(true);
        this.tblMain.getColumn(9).setGroup(true);
        this.tblMain.getColumn(14).setGroup(true);
        this.tblMain.getColumn(15).setGroup(true);
        this.tblMain.getColumn(16).setGroup(true);
        this.tblMain.getColumn(17).setGroup(true);
        this.tblMain.getColumn(18).setGroup(true);
        this.tblMain.getColumn(0).setMergeable(true);
        this.tblMain.getColumn(1).setMergeable(true);
        this.tblMain.getColumn(2).setMergeable(true);
        this.tblMain.getColumn(3).setMergeable(true);
        this.tblMain.getColumn(4).setMergeable(true);
        this.tblMain.getColumn(5).setMergeable(true);
        this.tblMain.getColumn(6).setMergeable(true);
        this.tblMain.getColumn(7).setMergeable(true);
        this.tblMain.getColumn(8).setMergeable(true);
        this.tblMain.getColumn(9).setMergeable(true);
        this.tblMain.getColumn(14).setMergeable(true);
        this.tblMain.getColumn(15).setMergeable(true);
        this.tblMain.getColumn(16).setMergeable(true);
        this.tblMain.getColumn(17).setMergeable(true);
        this.tblMain.getColumn(18).setMergeable(true);
    }

    @Override
    public void actionCntrvlDynamicItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionCntrvlDynamicItem_actionPerformed(e);
        if (this.tblMain.getSelectManager().get() == null) {
            this.actionCntrvlDynamicItem.setEnabled(false);
            return;
        }
        this.initExistDyItemsEntries();
        int row = this.tblMain.getSelectManager().get().getBeginRow();
        String entryId = (String)this.tblMain.getRow(row).getCell("entries.id").getValue();
        this.prepareOpenDyEdit();
        CslRptUIUtil.createDynamicEditUI(this, entryId, this.sortedDyItemEntries, this.rowMap);
    }

    private void prepareOpenDyEdit() {
        this.rowMap = new HashMap();
        this.sortedDyItemEntries = new ArrayList();
        int rows = this.tblMain.getRowCount();
        for (int i = 0; i < rows; ++i) {
            String entryId = (String)this.tblMain.getRow(i).getCell("entries.id").getValue();
            if (!this.existDyItemEntries.contains(entryId)) continue;
            this.sortedDyItemEntries.add(entryId);
            this.rowMap.put(entryId, new Integer(i + 1));
        }
    }

    @Override
    public void reloadCatchData(List container) {
        try {
            this.existDyItemEntries = null;
            this.initExistDyItemsEntries();
            if (container != null) {
                container.clear();
                container.addAll(this.existDyItemEntries);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FI_GR_CSLREPORT;
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    @Override
    public void actionShowAutoCreateItems_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowAutoCreateItems_actionPerformed(e);
        this.setFilterByIsVisible();
        this.refresh(e);
    }

    private void setFilterByIsVisible() {
        FilterInfo filter = this.getMainQuery().getFilter();
        if (this.menuItemShowAutoCreateItems.isSelected()) {
            String compareVal = "1,0";
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                if (!"entries.isVisible".equalsIgnoreCase(item.getPropertyName())) continue;
                item.setCompareValue((Object)compareVal);
                item.setCompareType(CompareType.INNER);
                break;
            }
        } else {
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                if (!"entries.isVisible".equalsIgnoreCase(item.getPropertyName())) continue;
                item.setCompareValue((Object)new Boolean(true));
                item.setCompareType(CompareType.EQUALS);
                break;
            }
        }
    }

    private void refreshScrollToSelect(ActionEvent e) throws Exception {
        int selectRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        this.setLocatePre(false);
        this.refresh(e);
        this.setLocatePre(true);
        this.tblMain.getRow(selectRowIndex);
        this.tblMain.getSelectManager().select(selectRowIndex, 0);
        this.tblMain.getLayoutManager().scrollRowToShow(selectRowIndex + 26);
    }

    @Override
    public void actionConvtEliminiation_actionPerformed(ActionEvent e) throws Exception {
        super.actionConvtEliminiation_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"UIType", (Object)"Hand");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ConvtEliminationListUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    protected boolean isShowAttachmentAction() {
        return true;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow footRow = super.appendFootRow();
        if (footRow != null) {
            footRow.getCell("entries.debit").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
            footRow.getCell("entries.credit").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        }
        return footRow;
    }

    protected void showSubAttacheMent(AttachmentUIContextInfo attachmentUIContextInfoinfo) {
        this.showAttacheMent();
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        this.showAttacheMent();
    }

    private void showAttacheMent() {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        this.checkSelected();
        if (boID == null) {
            return;
        }
        AttachmentUIContextInfo attachmentUIContextInfoinfo = new AttachmentUIContextInfo();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)boID));
        EliminationInfo eliminationInfo = null;
        try {
            eliminationInfo = ((IElimination)this.getBizInterface()).getEliminationInfo((IObjectPK)pk);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (eliminationInfo != null && eliminationInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            attachmentUIContextInfoinfo.setEdit(false);
        }
        attachmentUIContextInfoinfo.setBoID(boID);
        acm.showAttachmentListUIByBoID((Object)this, attachmentUIContextInfoinfo);
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    @Override
    public void actionSubExportData_actionPerformed(ActionEvent e) throws Exception {
        this.actionExportData_actionPerformed(e);
    }

    @Override
    public void actionSubImportData_actionPerformed(ActionEvent e) throws Exception {
        this.actionImportData_actionPerformed(e);
    }
}

