/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimImportBasicTreeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimRelaOrgTree;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationMode;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RecordTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationImportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AllCompanyImport;
import com.kingdee.eas.fi.gr.cslrpt.client.AllCompanyInOrgnizeImport;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.EliminationListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.IElimImportBasicTree;
import com.kingdee.eas.fi.gr.cslrpt.client.ImportAdjustRecordUI;
import com.kingdee.eas.fi.gr.cslrpt.client.RelatedCompanyImport;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class EliminationImportUI
extends AbstractEliminationImportUI
implements ICSLContextUI {
    private static final Logger logger = CoreUIObject.getLogger(ImportAdjustRecordUI.class);
    private List companyIds;
    private OrgTreeInfo orgTreeInfo = null;
    private OrgUnitInfo orgUnitInfo = null;
    private RptPeriodTypeEnum periodType;
    private int year;
    private int period;
    private ElimImportBasicTreeEnum elimImportbasicType;
    IOrgStructure structure = OrgStructureFactory.getRemoteInstance();
    IElimRelaOrgTree iElimRela = ElimRelaOrgTreeFactory.getRemoteInstance();
    ElimRelaOrgTreeCollection elimRelaCol = null;
    IElimination iElim = EliminationFactory.getRemoteInstance();
    int iMergeMode;
    private IElimImportBasicTree importBasicTree = null;
    private Object isSupportOtherDS;
    private boolean hasBgPermission = false;
    private boolean hasAcPermission = false;
    private boolean first = true;
    protected boolean isFromCslMerge = false;
    protected ICSLContext cslCtx = null;

    public EliminationImportUI() throws Exception {
        this.tblEliminationRecord.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                EliminationImportUI.this.tableValueChange(e);
            }
        });
        this.isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
    }

    public void onLoad() throws Exception {
        this.initCSLContext();
        super.onLoad();
        this.tblEliminationRecord.checkParsed();
        this.orgTreeInfo = this.getCSLContext().getCurOrgBound();
        this.year = this.getCSLContext().getCurRptYear();
        this.period = this.getCSLContext().getCurRptPeriod();
        this.orgUnitInfo = this.getCSLContext().getCurOrgGroup();
        this.periodType = this.getCSLContext().getCurRptPeriodType();
        this.elimRelaCol = new ElimRelaOrgTreeCollection();
        if (this.eliminationImportQuery == null) {
            this.eliminationImportQuery = new EntityViewInfo();
        }
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNone.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        String elimImportType = ParamManager.getParamValue(null, null, (String)"GR_CSL_ELIMIMPORTBASICTREE");
        if (elimImportType != null && !elimImportType.equals("")) {
            if (elimImportType.equals("0")) {
                this.elimImportbasicType = ElimImportBasicTreeEnum.RelatedCompanyImport;
                this.importBasicTree = new RelatedCompanyImport();
            } else if (elimImportType.equals("1")) {
                this.elimImportbasicType = ElimImportBasicTreeEnum.AllCompanyImport;
                this.importBasicTree = new AllCompanyImport();
            } else if (elimImportType.equals("2")) {
                this.elimImportbasicType = ElimImportBasicTreeEnum.AllCompanyInOrgnizeImport;
                this.importBasicTree = new AllCompanyInOrgnizeImport();
            } else {
                throw new BOSException("error trying to get ElimImport type");
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        CslGradeManageUtil.filterElimModeGradeManage((EntityViewInfo)viewInfo, null);
        this.initIsImportBefore();
        this.userDCPermission();
        this.initData();
        this.tblEliminationRecord.getColumn("dcfNumber").getStyleAttributes().setHided(true);
        CslClientHelper.mergeCheckBox(this.tblEliminationRecord, "number", 0, 0);
        CslClientHelper.mergeCheckBox(this.tblEliminationRecord, "number", 1, 1);
        this.formatDataElementValue();
        this.first = false;
    }

    private void formatDataElementValue() {
        int size = this.tblEliminationRecord.getRowCount();
        try {
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblEliminationRecord.getRow(i);
                Integer interSeq = (Integer)row.getCell("dataElement").getValue();
                DataElementInfo into = DataElementProvider.getDataElementInfo(interSeq);
                row.getCell("dataElement").setValue((Object)into.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void userDCPermission() throws Exception {
        try {
            if ("true".equals(this.isSupportOtherDS)) {
                DataCollectCollection datacollect = DataCollectFactory.getRemoteInstance().getDataCollectCollection("select * where number in ('ACTUALDATA','BUDGETDATA')");
                HashMap<String, DataCollectInfo> dataCollectMap = new HashMap<String, DataCollectInfo>();
                for (int i = 0; i < datacollect.size(); ++i) {
                    DataCollectInfo dataCollect = datacollect.get(i);
                    dataCollectMap.put(dataCollect.getNumber(), dataCollect);
                }
                this.hasBgPermission = CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (DataCollectInfo)dataCollectMap.get("BUDGETDATA"));
                this.hasAcPermission = CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (DataCollectInfo)dataCollectMap.get("ACTUALDATA"));
            } else {
                this.tblEliminationRecord.getColumn("dcfname").getStyleAttributes().setHided(true);
                this.tblEliminationRecord.getColumn("dcfNumber").getStyleAttributes().setHided(true);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    private void initIsImportBefore() throws EASBizException {
        if (this.elimImportbasicType.getValue().equals("1")) {
            this.tblEliminationRecord.getColumn("isImportBefore").getStyleAttributes().setHided(false);
        } else {
            this.tblEliminationRecord.getColumn("isImportBefore").getStyleAttributes().setHided(true);
        }
        if (this.importBasicTree != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgUnitInfo", this.orgUnitInfo);
            map.put("year", new Integer(this.year));
            map.put("period", new Integer(this.period));
            map.put("periodType", this.periodType);
            map.put("orgTreeInfo", this.orgTreeInfo);
            if (this.elimImportbasicType.getValue().equals("2")) {
                this.iMergeMode = CSLContextHelper.getSysParamanager().getMergeType();
                if (this.iMergeMode == -1) {
                    throw new SumRptException(SumRptException.PLEASE_SET_SYSPARAMS);
                }
                MergeModeEnum mergeMode = MergeModeEnum.getEnum(this.iMergeMode);
                map.put("mergeMode", (Object)mergeMode);
            }
            map.put("table", this.tblEliminationRecord);
            this.importBasicTree.setBasicParam(map);
        }
    }

    private void initData() throws Exception {
        String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
        this.cmbElimMode.insertItemAt((Object)selectAll, 0);
        this.cmbElimMode.setSelectedItem((Object)selectAll);
        this.cmbElimMode.addItem((Object)"");
        Object elimMode = this.cmbElimMode.getSelectedIndex() > 0 ? this.cmbElimMode.getSelectedItem() : null;
        this.importBasicTree.setElimMode(elimMode);
        IEliminationMode iElimMode = EliminationModeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        CslGradeManageUtil.filterElimModeGradeManage((EntityViewInfo)viewInfo, null);
        EliminationModeCollection col = iElimMode.getEliminationModeCollection(viewInfo);
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                this.cmbElimMode.addItem((Object)col.get(i));
            }
        }
        CurrencyCollection currencyCol = CslRptUIUtil.getCurrencyCollection();
        this.cmbxCurrency.addItem((Object)selectAll);
        this.cmbxSourceCurrency.addItem((Object)selectAll);
        this.cmbxCurrency.addItems(currencyCol.toArray());
        this.cmbxSourceCurrency.addItems(currencyCol.toArray());
        this.companyIds = new ArrayList();
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        Object sourceCurrency = this.cmbxSourceCurrency.getSelectedIndex() > 0 ? this.cmbxSourceCurrency.getSelectedItem() : null;
        Object currency = this.cmbxCurrency.getSelectedIndex() > 0 ? this.cmbxCurrency.getSelectedItem() : null;
        param.put("sourceCurrency", sourceCurrency);
        param.put("currency", currency);
        this.importBasicTree.setCurrency(param);
        this.cmbxElimType.removeAllItems();
        this.cmbxElimType.addItem((Object)selectAll);
        this.cmbxElimType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.cmbxElimType.addItem((Object)ElimTypeEnum.exchange);
        this.cmbxElimType.addItem((Object)ElimTypeEnum.General);
        this.cmbxElimType.addItem((Object)ElimTypeEnum.MAIN_INVEST);
        this.cmbxElimType.addItem((Object)ElimTypeEnum.HK_COST);
        this.cmbxElimType.addItem((Object)ElimTypeEnum.MAIN_COST);
        this.cmbxElimType.addItem((Object)ElimTypeEnum.Main_Invest_New);
        this.cmbxElimType.setSelectedItem((Object)selectAll);
        Object elimType = this.cmbxElimType.getSelectedIndex() > 0 ? this.cmbxElimType.getSelectedItem() : null;
        this.importBasicTree.setElimType(elimType);
        this.importBasicTree.addRecordToTable(this.eliminationImportQuery, this.companyIds);
        this.setPrecision();
        this.cmbxCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        HashMap<String, Object> param = new HashMap<String, Object>(4);
                        Object sourceCurrency = EliminationImportUI.this.cmbxSourceCurrency.getSelectedIndex() > 0 ? EliminationImportUI.this.cmbxSourceCurrency.getSelectedItem() : null;
                        Object currency = EliminationImportUI.this.cmbxCurrency.getSelectedIndex() > 0 ? EliminationImportUI.this.cmbxCurrency.getSelectedItem() : null;
                        param.put("sourceCurrency", sourceCurrency);
                        param.put("currency", currency);
                        EliminationImportUI.this.importBasicTree.setCurrency(param);
                        EliminationImportUI.this.importBasicTree.addRecordToTable(EliminationImportUI.this.eliminationImportQuery, EliminationImportUI.this.companyIds);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    EliminationImportUI.this.tblEliminationRecord.removeRows();
                    EliminationImportUI.this.setPrecision();
                }
            }
        });
        this.cmbxSourceCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        HashMap<String, Object> param = new HashMap<String, Object>(4);
                        Object sourceCurrency = EliminationImportUI.this.cmbxSourceCurrency.getSelectedIndex() > 0 ? EliminationImportUI.this.cmbxSourceCurrency.getSelectedItem() : null;
                        Object currency = EliminationImportUI.this.cmbxCurrency.getSelectedIndex() > 0 ? EliminationImportUI.this.cmbxCurrency.getSelectedItem() : null;
                        param.put("sourceCurrency", sourceCurrency);
                        param.put("currency", currency);
                        EliminationImportUI.this.importBasicTree.setCurrency(param);
                        EliminationImportUI.this.importBasicTree.addRecordToTable(EliminationImportUI.this.eliminationImportQuery, EliminationImportUI.this.companyIds);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    EliminationImportUI.this.tblEliminationRecord.removeRows();
                    EliminationImportUI.this.setPrecision();
                }
            }
        });
        this.cmbxElimType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        Object elimType = EliminationImportUI.this.cmbxElimType.getSelectedIndex() > 0 ? EliminationImportUI.this.cmbxElimType.getSelectedItem() : null;
                        EliminationImportUI.this.importBasicTree.setElimType(elimType);
                        EliminationImportUI.this.importBasicTree.addRecordToTable(EliminationImportUI.this.eliminationImportQuery, EliminationImportUI.this.companyIds);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    EliminationImportUI.this.tblEliminationRecord.removeRows();
                    EliminationImportUI.this.setPrecision();
                }
            }
        });
    }

    private void tableValueChange(KDTDataRequestEvent e) {
        if (this.elimImportbasicType == null) {
            return;
        }
        if (this.elimImportbasicType.getValue().equals("1")) {
            this.doAllCompanyImport(e);
        }
    }

    private void doAllCompanyImport(KDTDataRequestEvent e) {
        if (this.companyIds == null || this.companyIds.size() == 0) {
            return;
        }
        ArrayList list = new ArrayList();
        int n = e.getLastRow();
        for (int i = e.getFirstRow(); i <= n; ++i) {
            this.isImportBefore(i, list);
        }
    }

    private void isImportBefore(int row, ArrayList list) {
        String id = this.tblEliminationRecord.getRow(row).getCell("id").getValue().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select elimId where elimId =").append("'").append(id).append("'");
        sql.append(" and orgTreeId = '").append(this.orgTreeInfo.getId().toString()).append("'");
        boolean exists = true;
        try {
            exists = this.iElimRela.exists(sql.toString());
            if (exists) {
                this.tblEliminationRecord.getRow(row).getCell("isImportBefore").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport"));
                this.setElimRelaCol(id, list);
            } else {
                this.tblEliminationRecord.getRow(row).getCell("isImportBefore").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"794_RptItemDataImport"));
                this.setElimRelaCol(id, list);
            }
        }
        catch (EASBizException e) {
            super.handleControlException();
        }
        catch (BOSException e) {
            super.handleControlException();
        }
    }

    private void setPrecision() {
        this.tblEliminationRecord.refresh();
        int iCurrencyPrecision = 0;
        BigDecimal bgAmount = null;
        int rowCount = this.tblEliminationRecord.getExpandedRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblEliminationRecord.getRow(i);
            iCurrencyPrecision = (Integer)row.getCell("currency.precision").getValue();
            if (iCurrencyPrecision < 0) {
                iCurrencyPrecision = 2;
            }
            BigDecimal bigDecimal = bgAmount = row.getCell("debit") == null ? BigDecimal.valueOf(0L) : (BigDecimal)row.getCell("debit").getValue();
            if (bgAmount == null || bgAmount.compareTo(BigDecimal.valueOf(0L)) == 0) {
                row.getCell("debit").setValue(null);
            } else {
                bgAmount = bgAmount.setScale(iCurrencyPrecision, 4);
                row.getCell("debit").setValue((Object)bgAmount);
            }
            BigDecimal bigDecimal2 = bgAmount = row.getCell("credit") == null ? BigDecimal.valueOf(0L) : (BigDecimal)row.getCell("credit").getValue();
            if (bgAmount == null || bgAmount.compareTo(BigDecimal.valueOf(0L)) == 0) {
                row.getCell("credit").setValue(null);
            } else {
                bgAmount = bgAmount.setScale(iCurrencyPrecision, 4);
                row.getCell("credit").setValue((Object)bgAmount);
            }
            ICell cell = this.tblEliminationRecord.getCell(i, "select");
            if (cell == null) continue;
            cell.getStyleAttributes().setLocked(false);
            cell.setValue((Object)Boolean.FALSE);
        }
        CslClientHelper.mergeCheckBox(this.tblEliminationRecord, "id", 0, 0);
        CslClientHelper.mergeCheckBox(this.tblEliminationRecord, "id", 1, 1);
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        boolean isSupport;
        SorterItemInfo sorter = new SorterItemInfo("number");
        sorter.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorter);
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        if (!(isSupport = CslRptUtil.isSupportOtherDSClient())) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA"));
        } else {
            if (!this.hasBgPermission) {
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA"));
            }
            if (!this.hasAcPermission) {
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("dataCollect.number", (Object)"BUDGETDATA"));
            }
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    @Override
    public void okAction_actionPerformed(ActionEvent e) throws Exception {
        super.okAction_actionPerformed(e);
        this.doAddElimination();
        if (this.getUIContext().get("Owner") instanceof EliminationListUI) {
            ((EliminationListUI)this.getUIContext().get("Owner")).refreshList();
        }
        this.destroyWindow();
    }

    private void doAddElimination() throws BOSException, EASBizException {
        boolean isSunElimination = this.chkSumElimination.isSelected();
        boolean isInitYearProfit = false;
        RptProperties pp = new RptProperties();
        String typeid = (String)this.getUIContext().get("displayTypeId");
        if (typeid != null) {
            pp.setString("displayTypeId", typeid);
        }
        pp.setString("treeId", this.getCSLContext().getCurOrgBound().getId().toString());
        pp.setString("orgUnitId", this.getCSLContext().getCurOrgGroup().getId().toString());
        pp.setInt("year", this.getCSLContext().getCurRptYear());
        pp.setInt("period", this.getCSLContext().getCurRptPeriod());
        pp.setInt("periodType", this.getCSLContext().getCurRptPeriodType().getValue());
        pp.setBoolean("isSunElimination", isSunElimination);
        pp.setBoolean("isInitYearProfit", isInitYearProfit);
        pp.setBoolean("isImport", true);
        ArrayList idList = this.getSelectedEliminationIDs();
        pp.setObject("list", idList);
        pp.setObject("companyIds", this.companyIds);
        String elimImportType = ParamManager.getParamValue(null, null, (String)"GR_CSL_ELIMIMPORTBASICTREE");
        ElimImportBasicTreeEnum elimImportbasicType = null;
        if (elimImportType != null && !elimImportType.equals("")) {
            if (elimImportType.equals("0")) {
                elimImportbasicType = ElimImportBasicTreeEnum.RelatedCompanyImport;
            } else if (elimImportType.equals("1")) {
                elimImportbasicType = ElimImportBasicTreeEnum.AllCompanyImport;
            } else if (elimImportType.equals("2")) {
                elimImportbasicType = ElimImportBasicTreeEnum.AllCompanyInOrgnizeImport;
            } else {
                throw new BOSException("error trying to get ElimImport type");
            }
        }
        pp.setObject("elimImportbasicType", (Object)elimImportbasicType);
        MergeModeEnum mergeMode = CslRptUtil.getMergeMode(this.getCSLContext().getCurOrgBound());
        pp.setObject("mergeMode", (Object)mergeMode);
        boolean isByOrdinal = mergeMode.equals((Object)MergeModeEnum.ORDINAL);
        pp.setBoolean("isByOrdinal", isByOrdinal);
        if (elimImportbasicType != null && (elimImportbasicType.getValue().equals("1") || elimImportbasicType.getValue().equals("2"))) {
            pp.setBoolean("isAllCompanyImport", true);
        } else {
            pp.setBoolean("isAllCompanyImport", false);
        }
        pp.setObject("elimRelaCol", (Object)this.elimRelaCol);
        if (this.getUIContext().get("basic") != null && this.getUIContext().get("basic").equals("yes")) {
            pp.setObject("basic", "yes");
        }
        pp.setObject("dataCollect", this.getCSLContext().getCurDataCollect());
        pp.setObject("KEY_ORGTREE_INFO", this.getCSLContext().getCurOrgBound());
        pp.setObject("KEY_ORGUNIT_INFO", this.getCSLContext().getCurOrgGroup());
        Map result = EliminationFactory.getRemoteInstance().copyHisData(pp);
        this.addNewElimRelaOrgTree(this.tblEliminationRecord, idList);
        if (result.get("message") != null) {
            String msg = String.valueOf(result.get("message"));
            this.showFailMessage(msg);
        }
    }

    private void showFailMessage(String msg) {
        if (msg != null && msg.length() > 0) {
            try {
                UIContext uiCtx = new UIContext((Object)this);
                uiCtx.put((Object)"String", (Object)msg.toString());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e) {
                logger.error((Object)"showEditorPanelUI: ", (Throwable)e);
            }
        }
    }

    private void addNewElimRelaOrgTree(KDTable tblEliminationRecord, ArrayList idList) throws BOSException, EASBizException {
        if (idList != null && idList.size() > 0 && this.elimRelaCol != null && this.elimRelaCol.size() > 0) {
            for (int i = 0; i < this.elimRelaCol.size(); ++i) {
                ElimRelaOrgTreeInfo info = this.elimRelaCol.get(i);
                if (!idList.contains(info.getElimId().toString())) continue;
                this.iElimRela.addnew(info);
            }
        }
    }

    private ArrayList getSelectedEliminationIDs() {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, Boolean> selMap = new HashMap<String, Boolean>();
        boolean select = false;
        for (int i = 0; i < this.tblEliminationRecord.getExpandedRowCount(); ++i) {
            IRow row = this.tblEliminationRecord.getRow(i);
            String id = (String)row.getCell("id").getValue();
            if (!selMap.containsKey(id)) {
                boolean sel = (Boolean)row.getCell("select").getValue();
                selMap.put(id, sel);
                select = sel;
            } else {
                select = (Boolean)selMap.get(id);
            }
            if (!select || list.contains(id)) continue;
            list.add(id);
        }
        if (list.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        return list;
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        CslRptUtil.selectTable(this.tblEliminationRecord, "select", Boolean.TRUE);
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectNone_actionPerformed(e);
        CslRptUtil.selectTable(this.tblEliminationRecord, "select", Boolean.FALSE);
    }

    public boolean destroyWindow() {
        if (!this.isFromCslMerge) {
            CSLContextHelper.unRegistUIObject(this);
        }
        return super.destroyWindow();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
    }

    private void setElimRelaCol(String id, ArrayList list) {
        ElimRelaOrgTreeInfo info = new ElimRelaOrgTreeInfo();
        info.setElimId(id);
        info.setOrgTreeId(this.orgTreeInfo.getId().toString());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setRecordType(RecordTypeEnum.ELIMINATION);
        if (!list.contains(id + this.orgTreeInfo.getId().toString())) {
            list.add(id + this.orgTreeInfo.getId().toString());
            this.elimRelaCol.add(info);
        }
    }

    @Override
    protected void cmbElimMode_itemStateChanged(ItemEvent e) {
        if (!this.first && e.getStateChange() == 1) {
            try {
                Object elimMode = this.cmbElimMode.getSelectedIndex() > 0 ? this.cmbElimMode.getSelectedItem() : null;
                this.importBasicTree.setElimMode(elimMode);
                this.importBasicTree.addRecordToTable(this.eliminationImportQuery, this.companyIds);
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            this.tblEliminationRecord.removeRows();
            this.setPrecision();
        }
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }
}

