/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.fi.gr.cslrpt.DataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationItemMapFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationItemMapInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimTemplet;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationItemMap;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationItemMapEditUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class EliminationItemMapEditUI
extends AbstractEliminationItemMapEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EliminationItemMapEditUI.class);
    private String elimTempletInfoId;
    private List rptItemEntryList = new ArrayList();
    private List tempItemEntryList = new ArrayList();
    private IEliminationItemMap iEliminationItemMap;
    private Map itemDataSrcTypeMap = null;
    private CoreBaseCollection oldCollection;

    public void onLoad() throws Exception {
        super.onLoad();
        this.elimTempletInfoId = (String)this.getUIContext().get("elimTempletInfoId");
        this.tempItemEntryList = (List)this.getUIContext().get("tempItemEntryList");
        this.actionRefresh.setVisible(false);
        this.actionRefresh.setEnabled(false);
        String oprtState = (String)this.getUIContext().get("oprtState");
        if ("VIEW".equals(oprtState)) {
            this.actionSubmit.setEnabled(false);
        }
        if (this.iEliminationItemMap == null) {
            this.iEliminationItemMap = EliminationItemMapFactory.getRemoteInstance();
        }
        this.initRptItemData();
    }

    public void initRptItemData() {
        if (this.itemDataSrcTypeMap == null) {
            this.itemDataSrcTypeMap = new HashMap();
        }
        for (int i = 0; i < this.tempItemEntryList.size(); ++i) {
            ElimTempletEntryInfo entryInfo = (ElimTempletEntryInfo)this.tempItemEntryList.get(i);
            RPTItemInfo itemInfo = entryInfo.getItem();
            DataSrcTypeEnum dataSrc = entryInfo.getDataSrcType();
            if (dataSrc == null || dataSrc.getValue() == 2) continue;
            boolean isDup = false;
            if (itemInfo != null && itemInfo.getNumber() != null) {
                for (int j = 0; j < this.rptItemEntryList.size(); ++j) {
                    RPTItemInfo itemInfo1 = (RPTItemInfo)this.rptItemEntryList.get(j);
                    if (!itemInfo.getNumber().equals(itemInfo1.getNumber())) continue;
                    isDup = true;
                    break;
                }
                if (!isDup) {
                    this.rptItemEntryList.add(itemInfo);
                }
            }
            if (itemInfo == null || itemInfo.getNumber() == null || dataSrc == null) continue;
            this.itemDataSrcTypeMap.put(itemInfo.getNumber(), new Integer(dataSrc.getValue()));
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initTableRows();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.menuItemRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void initTableRows() {
        this.elimItemMapEntries.removeRows(false);
        try {
            StringBuffer itemSql = new StringBuffer("select");
            itemSql.append(" selfCompanyTtem.Id,selfCompanyTtem.Name,selfCompanyTtem.number,");
            itemSql.append(" otherCompanyTtem.Id,otherCompanyTtem.Name,otherCompanyTtem.number,");
            itemSql.append("elimTemple.id ");
            itemSql.append(" where elimTemple='").append(this.elimTempletInfoId).append("'");
            itemSql.append(" order by seq");
            this.oldCollection = EliminationItemMapFactory.getRemoteInstance().getCollection(itemSql.toString());
            for (EliminationItemMapInfo element : this.oldCollection) {
                this.initElimItemList(element.getSelfCompanyTtem());
                this.initElimItemList(element.getOtherCompanyTtem());
            }
            for (EliminationItemMapInfo element : this.oldCollection) {
                IRow row = this.elimItemMapEntries.addRow();
                RPTItemComparator comp = new RPTItemComparator();
                Collections.sort(this.rptItemEntryList, comp);
                this.initElimItemMapEditor(row, element.getSelfCompanyTtem(), element.getOtherCompanyTtem());
            }
            if (this.oldCollection.size() == 0) {
                RPTItemComparator comp = new RPTItemComparator();
                Collections.sort(this.rptItemEntryList, comp);
                IRow row = this.elimItemMapEntries.addRow();
                KDComboBox cbxselfRptItems = new KDComboBox();
                KDComboBox cbxotherRptItems = new KDComboBox();
                row.getCell("selfCompanyTtem").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxselfRptItems));
                row.getCell("otherCompanyTtem").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxotherRptItems));
                for (RPTItemInfo rptItemInfo : this.rptItemEntryList) {
                    cbxselfRptItems.addItem((Object)rptItemInfo);
                    cbxotherRptItems.addItem((Object)rptItemInfo);
                }
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.elimItemMapEntries.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
                EliminationItemMapEditUI.this.tableValueChanged(e);
            }

            public void editCanceled(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                EliminationItemMapEditUI.this.tableValueChanged(e);
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }
        });
    }

    private void initElimItemList(RPTItemInfo existItemInfo) {
        boolean isExist = false;
        for (RPTItemInfo itemInfo : this.rptItemEntryList) {
            if (itemInfo == null || existItemInfo == null || !itemInfo.getNumber().equals(existItemInfo.getNumber())) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            this.rptItemEntryList.add(existItemInfo);
        }
    }

    private void initElimItemMapEditor(IRow row, RPTItemInfo selfItemInfo, RPTItemInfo otherItemInfo) throws BOSException, UIException {
        KDComboBox cbxSelfRptItems = new KDComboBox();
        KDComboBox cbxOtherRptItems = new KDComboBox();
        RPTItemInfo selfItem = null;
        RPTItemInfo otherItem = null;
        int selectSelfIndex = 0;
        int selectOtherIndex = 0;
        int i = 0;
        for (RPTItemInfo rptItemInfo : this.rptItemEntryList) {
            cbxSelfRptItems.addItem((Object)rptItemInfo);
            cbxOtherRptItems.addItem((Object)rptItemInfo);
            if (rptItemInfo.getNumber().equals(selfItemInfo.getNumber())) {
                selfItem = rptItemInfo;
                selectSelfIndex = i;
            }
            if (rptItemInfo.getNumber().equals(otherItemInfo.getNumber())) {
                otherItem = rptItemInfo;
                selectOtherIndex = i;
            }
            ++i;
        }
        row.getCell("selfCompanyTtem").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxSelfRptItems));
        row.getCell("selfCompanyTtem").setUserObject(selfItem);
        KDTDefaultCellEditor cellOtherEditor = new KDTDefaultCellEditor((JComboBox)cbxOtherRptItems);
        row.getCell("otherCompanyTtem").setEditor((ICellEditor)cellOtherEditor);
        row.getCell("otherCompanyTtem").setUserObject((Object)otherItem);
        cbxSelfRptItems.setSelectedIndex(selectSelfIndex);
        cbxOtherRptItems.setSelectedIndex(selectOtherIndex);
        if (selfItem != null) {
            row.getCell("selfCompanyTtem").setValue((Object)selfItem.getName());
        }
        if (otherItem != null) {
            row.getCell("otherCompanyTtem").setValue((Object)otherItem.getName());
        }
    }

    private void tableValueChanged(KDTEditEvent e) {
        int selectRow = e.getRowIndex();
        IRow row = this.elimItemMapEntries.getRow(selectRow);
        KDTable kdtEntry = (KDTable)e.getSource();
        if ((e.getColIndex() == 1 || e.getColIndex() == 2) && e.getValue() != null && e.getOldValue() != e.getValue()) {
            RPTItemInfo rptItem = (RPTItemInfo)e.getValue();
            kdtEntry.getRow(selectRow).getCell(e.getColIndex()).setUserObject((Object)rptItem);
            kdtEntry.getRow(selectRow).getCell(e.getColIndex()).setValue((Object)rptItem.getName(this.getCurrentLocale()));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EliminationItemMapFactory.getRemoteInstance();
    }

    public boolean isModify() {
        if (this.elimItemMapEntries != null) {
            IRow row = null;
            int size = this.oldCollection == null ? 0 : this.oldCollection.size();
            int rowCount = this.elimItemMapEntries.getRowCount();
            if (size > 0 && rowCount == 0) {
                return true;
            }
            if (rowCount == 1 && size == 0 && (row = this.elimItemMapEntries.getRow(0)).getCell("selfCompanyTtem").getValue() == null && row.getCell("otherCompanyTtem").getValue() == null) {
                return false;
            }
            if (rowCount > size && rowCount != 1) {
                return true;
            }
            for (int i = 0; i < rowCount; ++i) {
                RPTItemInfo info;
                if (i + 1 > size) {
                    return true;
                }
                row = this.elimItemMapEntries.getRow(i);
                EliminationItemMapInfo element = (EliminationItemMapInfo)this.oldCollection.get(i);
                if (row.getCell("selfCompanyTtem").getValue() != null) {
                    info = (RPTItemInfo)row.getCell("selfCompanyTtem").getUserObject();
                    if (!element.getSelfCompanyTtem().getNumber().equals(info.getNumber())) {
                        return true;
                    }
                }
                if (row.getCell("otherCompanyTtem").getValue() == null) continue;
                info = (RPTItemInfo)row.getCell("otherCompanyTtem").getUserObject();
                if (element.getOtherCompanyTtem().getNumber().equals(info.getNumber())) continue;
                return true;
            }
        }
        return super.isModify();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        IRow row = this.elimItemMapEntries.addRow();
        KDComboBox cbxselfRptItems = new KDComboBox();
        KDComboBox cbxotherRptItems = new KDComboBox();
        row.getCell("selfCompanyTtem").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxselfRptItems));
        row.getCell("otherCompanyTtem").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxotherRptItems));
        for (RPTItemInfo rptItemInfo : this.rptItemEntryList) {
            cbxselfRptItems.addItem((Object)rptItemInfo);
            cbxotherRptItems.addItem((Object)rptItemInfo);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.initTableRows();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        if (this.elimItemMapEntries.getSelectManager().get() != null) {
            int row = this.elimItemMapEntries.getSelectManager().get().getBeginRow();
            this.elimItemMapEntries.removeRow(row);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        int count = this.elimItemMapEntries.getRowCount();
        String resPath = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg";
        IRPTItem rptItem = RPTItemFactory.getRemoteInstance();
        ArrayList<String> itemList = new ArrayList<String>();
        for (RPTItemInfo rptItemInfo : this.rptItemEntryList) {
            itemList.add(rptItemInfo.getNumber());
        }
        Map rptItemList = rptItem.getRPTItemInfoList(itemList);
        if (count > 0) {
            ArrayList<EliminationItemMapInfo> entries = new ArrayList<EliminationItemMapInfo>();
            for (int i = 0; i < count; ++i) {
                IRow row1 = this.elimItemMapEntries.getRow(i);
                RPTItemInfo selfItemInfo1 = (RPTItemInfo)row1.getCell("selfCompanyTtem").getUserObject();
                RPTItemInfo otherItemInfo1 = (RPTItemInfo)row1.getCell("otherCompanyTtem").getUserObject();
                if (selfItemInfo1 == null || otherItemInfo1 == null) {
                    String msg = EASResource.getString((String)resPath, (String)"RptItemIsNull");
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                } else {
                    String msg;
                    RPTItemInfo itemInfo1 = (RPTItemInfo)rptItemList.get(selfItemInfo1.getNumber());
                    RPTItemInfo itemInfo2 = (RPTItemInfo)rptItemList.get(otherItemInfo1.getNumber());
                    if (itemInfo1 != null && itemInfo2 != null && itemInfo1.getDc().getValue() == itemInfo2.getDc().getValue()) {
                        msg = EASResource.getString((String)resPath, (String)"RptItemIsDiffDC");
                        MsgBox.showInfo((String)msg);
                        SysUtil.abort();
                    }
                    if (this.itemDataSrcTypeMap.get(selfItemInfo1.getNumber()) != null && String.valueOf(2).equals(this.itemDataSrcTypeMap.get(selfItemInfo1.getNumber()).toString()) || this.itemDataSrcTypeMap.get(otherItemInfo1.getNumber()) != null && String.valueOf(2).equals(this.itemDataSrcTypeMap.get(otherItemInfo1.getNumber()).toString())) {
                        msg = EASResource.getString((String)resPath, (String)"RptItemIsDiffSrc");
                        MsgBox.showInfo((String)msg);
                        SysUtil.abort();
                    }
                    if (count > 1) {
                        for (int j = i + 1; j < count; ++j) {
                            String msg2;
                            IRow row2 = this.elimItemMapEntries.getRow(j);
                            RPTItemInfo selfItemInfo2 = (RPTItemInfo)row2.getCell("selfCompanyTtem").getUserObject();
                            RPTItemInfo otherItemInfo2 = (RPTItemInfo)row2.getCell("otherCompanyTtem").getUserObject();
                            if (selfItemInfo2 == null || otherItemInfo2 == null) {
                                msg2 = EASResource.getString((String)resPath, (String)"RptItemIsNull");
                                MsgBox.showInfo((String)msg2);
                                SysUtil.abort();
                            }
                            if (!selfItemInfo1.getNumber().equals(selfItemInfo2.getNumber()) && !selfItemInfo1.getNumber().equals(otherItemInfo2.getNumber()) && !otherItemInfo1.getNumber().equals(selfItemInfo2.getNumber()) && !otherItemInfo1.getNumber().equals(otherItemInfo2.getNumber())) continue;
                            msg2 = EASResource.getString((String)resPath, (String)"RptItemISDup");
                            MsgBox.showInfo((String)msg2);
                            SysUtil.abort();
                        }
                    }
                }
                EliminationItemMapInfo elimItemMapInfo = new EliminationItemMapInfo();
                elimItemMapInfo.setSelfCompanyTtem(selfItemInfo1);
                elimItemMapInfo.setOtherCompanyTtem(otherItemInfo1);
                elimItemMapInfo.setSeq(i + 1);
                ObjectStringPK pk = new ObjectStringPK(this.elimTempletInfoId);
                IElimTemplet elimTemplate = ElimTempletFactory.getRemoteInstance();
                ElimTempletInfo templetInfo = elimTemplate.getElimTempletInfo((IObjectPK)pk);
                elimItemMapInfo.setElimTemple(templetInfo);
                entries.add(elimItemMapInfo);
            }
            this.iEliminationItemMap.saveElimItemMapItems(entries);
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SaveDataSuccess");
            this.setMessageText(msg);
            this.showMessage();
            this.oldCollection = new CoreBaseCollection();
            for (int i = 0; i < entries.size(); ++i) {
                this.oldCollection.add((CoreBaseInfo)((EliminationItemMapInfo)entries.get(i)));
            }
        } else {
            this.iEliminationItemMap.deleteALLElimItems(this.elimTempletInfoId);
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SaveDataSuccess");
            this.setMessageText(msg);
            this.showMessage();
            this.oldCollection = new CoreBaseCollection();
        }
    }

    public class RPTItemComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            RPTItemInfo c1 = (RPTItemInfo)o1;
            RPTItemInfo c2 = (RPTItemInfo)o2;
            return c1.getNumber().compareTo(c2.getNumber());
        }
    }
}

