/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimDataSourceEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationTemplateBatchImportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;

public class EliminationTemplateBatchImportUI
extends AbstractEliminationTemplateBatchImportUI {
    private Boolean select = true;
    private Boolean unSelect = false;
    private static final String TBL_COL_SELECT = "select";
    private static final String TBL_COL_NUMBER = "templatenumber";
    private static final String TBL_COL_NAME = "templatename";
    private static final String TBL_COL_ELIMTYPE = "elimtype";
    private static final String TBL_COL_ELIMINATIOMMODE = "eliminationMode";
    private static final String TBL_COL_SUMMARY = "summary";
    private static final String TBL_COL_ITEM_NUMBER = "itemNumber";
    private static final String TBL_COL_ITEM_NAME = "itemName";
    private static final String TBL_COL_DATAELEMENT = "entries.dataElement";
    private static final String TBL_COL_DATASRCTYPE = "dataSrcType";
    private static final String TBL_COL_DC = "dc";
    private static final String TBL_COL_ISCITEDBYLATE = "IsCitedByLate";
    private static final String TBL_COL_COMPANY = "company.name";
    private static final String TBL_COL_DEBITFORMULA = "debit";
    private static final String TBL_COL_CREDITFORMULA = "credit";
    private int TBL_COL_TEMPLATEENTRYID = -1;
    private String ElimResName = "com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg";
    private Book book;
    private List hasZeroList = new ArrayList();
    private List allNullList = new ArrayList();
    private boolean isSupportCrossMerger = false;
    protected boolean isFromCslMerge = false;
    protected ICSLContext cslCtx = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.initCSLContext();
        super.onLoad();
        this.initMenuBars();
        this.initWorkButtons();
        this.initHeadData();
        this.initTable();
        this.groupTableRow();
        this.isSupportCrossMerger = CSLParamUtil.isSupportCrossMerger(null, this.getCSLContext().getCurOrgBound().getId().toString());
    }

    private void initMenuBars() {
        this.menuBar.setEnabled(false);
        this.menuBar.setVisible(false);
    }

    private void initWorkButtons() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setVisible(true);
        this.btnRefresh.setEnabled(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNo.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll.setEnabled(true);
        this.btnSelectNo.setEnabled(true);
        this.btnAddLine.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnCopyLine.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.btnReset.setVisible(false);
        this.btnSave.setVisible(true);
        this.btnSave.setEnabled(true);
        this.btnSignature.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnViewSignature.setVisible(false);
        this.btnVoucher.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.btnWFViewSubmitProccess.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
    }

    private void initHeadData() throws Exception {
        this.dateBizDate.setValue((Object)new Timestamp(this.getCSLContext().getCurReportDate().getTime()));
        this.dateBizDate.setEnabled(false);
        this.dateBizDate.setEditable(false);
        this.txtCompany.setEditable(false);
        this.comboPeriodType.setSelectedItem((Object)this.getCSLContext().getCurRptPeriodType());
        this.comboPeriodType.setEditable(false);
        this.comboPeriodType.setEnabled(false);
        this.txtCompany.setText(this.getCSLContext().getCurOrgGroup().getName());
        this.txtCompany.setEnabled(false);
        this.txtCompany.setEditable(false);
        CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, true, false);
        CslClientHelper.initCurrencyToCombox((JComboBox)this.comboSourceCurrency, true, false);
        this.comboCurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EliminationTemplateBatchImportUI.this.setPrecision();
                EliminationTemplateBatchImportUI.this.modifySourceCurrencySameAsCurrency();
            }
        });
        KDBizPromptBox companyPromptBox = new KDBizPromptBox();
        companyPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.NewUnionTreeQuery");
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("unit.id"));
        view.getSelector().add(new SelectorItemInfo("unit.number"));
        view.getSelector().add(new SelectorItemInfo("unit.name"));
        view.setFilter(new FilterInfo());
        FilterItemCollection filterItems = view.getFilter().getFilterItems();
        filterItems.add(new FilterItemInfo("tree.id", (Object)this.getCSLContext().getCurOrgBound().getId().toString()));
        filterItems.add(new FilterItemInfo("longNumber", (Object)(this.getCSLContext().getCurOrgGroup().getLongNumber() + "%"), CompareType.LIKE));
        companyPromptBox.setEntityViewInfo(view);
        companyPromptBox.getQueryAgent().setSelectorCollection(view.getSelector());
        companyPromptBox.setEditFormat("$unit.number$");
        companyPromptBox.setDisplayFormat("$name$");
        companyPromptBox.setCommitFormat("$unit.number$");
        companyPromptBox.setHistoryRecordEnabled(false);
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1);
        f7.setRootUnitID(this.getCSLContext().getCurOrgGroup().getId().toString());
        f7.setTreeID(this.getCSLContext().getCurOrgBound().getId().toString());
        f7.setMultiSelect(false);
        f7.setNeedAddOrgRange(false);
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        companyPromptBox.setSelector((KDPromptSelector)f7);
        this.kdtEntries.getColumn(TBL_COL_COMPANY).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)companyPromptBox));
    }

    private void modifySourceCurrencySameAsCurrency() {
        this.comboSourceCurrency.setSelectedItem(this.comboCurrency.getSelectedItem());
    }

    private void setPrecision() {
        CurrencyInfo ci = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        StyleAttributes attrDebit = this.kdtEntries.getColumn(TBL_COL_DEBITFORMULA).getStyleAttributes();
        attrDebit.setNumberFormat(CslRptUIUtil.getFmtStr(ci));
        attrDebit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes attrCredit = this.kdtEntries.getColumn(TBL_COL_CREDITFORMULA).getStyleAttributes();
        attrCredit.setNumberFormat(CslRptUIUtil.getFmtStr(ci));
        attrCredit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void initTable() throws Exception {
        this.TBL_COL_TEMPLATEENTRYID = this.kdtEntries.getColumnCount();
        this.kdtEntries.addColumn(this.TBL_COL_TEMPLATEENTRYID);
        this.kdtEntries.getColumn(this.TBL_COL_TEMPLATEENTRYID).getStyleAttributes().setHided(true);
        this.kdtEntries.checkParsed();
        this.kdtEntries.getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TBL_COL_SELECT).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(TBL_COL_COMPANY).getStyleAttributes().setLocked(false);
        ICSLContext context = this.getCSLContext();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("orgBoundId", context.getCurOrgBound().getId().toString());
        valueMap.put("orgUnitID", context.getCurOrgGroup().getId().toString());
        ElimTempletCollection templetCollection = EliminationFactory.getRemoteInstance().getCurrentEliminationTemplate(valueMap);
        if (templetCollection != null && templetCollection.size() > 0) {
            int rowIndex;
            this.kdtEntries.checkParsed();
            this.kdtEntries.getSelectManager().setSelectMode(2);
            Sheet sheet = this.initBook();
            for (int i = 0; i < templetCollection.size(); ++i) {
                ElimTempletInfo templet = templetCollection.get(i);
                ElimTempletEntryCollection entryColl = templet.getEntries();
                for (int k = 0; k < entryColl.size(); ++k) {
                    IRow r = this.kdtEntries.addRow();
                    r.getCell(TBL_COL_SELECT).setValue((Object)false);
                    r.getCell(TBL_COL_NUMBER).setValue((Object)templet.getNumber());
                    r.getCell(TBL_COL_NAME).setValue((Object)templet.getName());
                    r.getCell(TBL_COL_ELIMTYPE).setValue((Object)templet.getValueType());
                    r.getCell(TBL_COL_ELIMINATIOMMODE).setValue(templet.getEliminationMode() == null ? null : templet.getEliminationMode().getName());
                    if (templet.getEliminationMode() != null) {
                        r.getCell(TBL_COL_ELIMINATIOMMODE).setUserObject((Object)templet.getEliminationMode());
                    }
                    r.getCell(TBL_COL_ISCITEDBYLATE).setValue((Object)templet.getIsCitedByLater());
                    ElimTempletEntryInfo elimTemplateEntryInfo = entryColl.get(k);
                    if (elimTemplateEntryInfo == null) continue;
                    r.getCell("entryid").setValue((Object)templet.getId());
                    r.getCell(this.TBL_COL_TEMPLATEENTRYID).setValue((Object)elimTemplateEntryInfo.getId());
                    r.getCell(TBL_COL_SUMMARY).setValue((Object)elimTemplateEntryInfo.getSummary());
                    r.getCell(TBL_COL_ITEM_NUMBER).setValue((Object)elimTemplateEntryInfo.getItem());
                    r.getCell(TBL_COL_ITEM_NAME).setValue((Object)elimTemplateEntryInfo.getItem().getName());
                    r.getCell(TBL_COL_DATAELEMENT).setValue((Object)DataElementProvider.getDataElementInfo(elimTemplateEntryInfo.getDataElement()));
                    r.getCell(TBL_COL_DATASRCTYPE).setValue((Object)elimTemplateEntryInfo.getDataSrcType());
                    r.getCell(TBL_COL_DC).setValue((Object)elimTemplateEntryInfo.getDC());
                    Cell cell = null;
                    int rowIndex2 = r.getRowIndex();
                    if (elimTemplateEntryInfo.getDebitFormula() != null) {
                        cell = sheet.getCell(rowIndex2, 0, true);
                        cell.setFormula("=" + elimTemplateEntryInfo.getDebitFormula());
                    } else {
                        cell = sheet.getCell(rowIndex2, 0, true);
                        cell.setFormula(null);
                        cell.setValue(Variant.nullVariant);
                    }
                    if (elimTemplateEntryInfo.getCreditFormula() != null) {
                        cell = sheet.getCell(rowIndex2, 1, true);
                        cell.setFormula("=" + elimTemplateEntryInfo.getCreditFormula());
                        continue;
                    }
                    cell = sheet.getCell(rowIndex2, 1, true);
                    cell.setFormula(null);
                    cell.setValue(Variant.nullVariant);
                }
            }
            BigDecimal sumCredit = new BigDecimal(0);
            BigDecimal sumDebit = new BigDecimal(0);
            int dDiffItem = -1;
            int cDiffItem = -1;
            String tmplNumber = null;
            ArrayList<Integer> removeRowIndexList = new ArrayList<Integer>();
            Object[][] values = this.getCalcValues(this.kdtEntries.getRowCount());
            int count = this.kdtEntries.getRowCount();
            for (rowIndex = 0; rowIndex < count; ++rowIndex) {
                IRow row = this.kdtEntries.getRow(rowIndex);
                String number = (String)row.getCell(TBL_COL_NUMBER).getValue();
                DataSrcTypeEnum dataSrcTypeEnum = (DataSrcTypeEnum)((Object)row.getCell(TBL_COL_DATASRCTYPE).getValue());
                DebitOrCreditEnum debitOrCreditEnum = (DebitOrCreditEnum)((Object)row.getCell(TBL_COL_DC).getValue());
                if (tmplNumber == null) {
                    tmplNumber = number;
                } else if (tmplNumber != null && !tmplNumber.equals(number)) {
                    if (dDiffItem > -1 || cDiffItem > -1) {
                        this.setDiffItemValue(dDiffItem, cDiffItem, sumDebit, sumCredit, removeRowIndexList);
                    }
                    sumCredit = new BigDecimal(0);
                    sumDebit = new BigDecimal(0);
                    dDiffItem = -1;
                    cDiffItem = -1;
                    tmplNumber = number;
                }
                if (dataSrcTypeEnum.getValue() == 2 && debitOrCreditEnum.getValue() == 1) {
                    dDiffItem = rowIndex;
                }
                if (dataSrcTypeEnum.getValue() == 2 && debitOrCreditEnum.getValue() == 0) {
                    cDiffItem = rowIndex;
                }
                if (values[rowIndex][0] instanceof Number) {
                    row.getCell(TBL_COL_DEBITFORMULA).setValue(values[rowIndex][0]);
                    sumDebit = sumDebit.add((BigDecimal)values[rowIndex][0]);
                }
                if (values[rowIndex][1] instanceof Number) {
                    row.getCell(TBL_COL_CREDITFORMULA).setValue(values[rowIndex][1]);
                    sumCredit = sumCredit.add((BigDecimal)values[rowIndex][1]);
                }
                if (rowIndex != count - 1) continue;
                if (dDiffItem > -1 || cDiffItem > -1) {
                    this.setDiffItemValue(dDiffItem, cDiffItem, sumDebit, sumCredit, removeRowIndexList);
                }
                sumCredit = new BigDecimal(0);
                sumDebit = new BigDecimal(0);
                dDiffItem = -1;
                cDiffItem = -1;
                tmplNumber = number;
            }
            if (removeRowIndexList != null && !removeRowIndexList.isEmpty()) {
                for (rowIndex = this.kdtEntries.getRowCount(); rowIndex >= 0; --rowIndex) {
                    if (!removeRowIndexList.contains(rowIndex)) continue;
                    this.kdtEntries.removeRow(rowIndex);
                }
            }
        }
    }

    private void setDiffItemValue(int dDiffItem, int cDiffItem, BigDecimal sumDebit, BigDecimal sumCredit, List<Integer> removeRowIndexList) {
        if (dDiffItem > -1 && cDiffItem > -1) {
            BigDecimal diffValue = sumDebit.subtract(sumCredit);
            int compareInt = diffValue.compareTo(BigDecimal.ZERO);
            if (compareInt == 0) {
                removeRowIndexList.add(dDiffItem);
                removeRowIndexList.add(cDiffItem);
            } else if (compareInt == 1) {
                IRow row = this.kdtEntries.getRow(cDiffItem);
                row.getCell(TBL_COL_CREDITFORMULA).setValue((Object)diffValue);
                removeRowIndexList.add(dDiffItem);
            } else if (compareInt == -1) {
                IRow row = this.kdtEntries.getRow(dDiffItem);
                row.getCell(TBL_COL_DEBITFORMULA).setValue((Object)diffValue.abs());
                removeRowIndexList.add(cDiffItem);
            }
        } else if (dDiffItem > -1) {
            BigDecimal diffValue = sumCredit.subtract(sumDebit);
            int compareInt = diffValue.compareTo(BigDecimal.ZERO);
            if (compareInt == 0) {
                removeRowIndexList.add(dDiffItem);
            } else {
                IRow row = this.kdtEntries.getRow(dDiffItem);
                row.getCell(TBL_COL_DEBITFORMULA).setValue((Object)diffValue);
            }
        } else if (cDiffItem > -1) {
            BigDecimal diffValue = sumDebit.subtract(sumCredit);
            int compareInt = diffValue.compareTo(BigDecimal.ZERO);
            if (compareInt == 0) {
                removeRowIndexList.add(cDiffItem);
            } else {
                IRow row = this.kdtEntries.getRow(cDiffItem);
                row.getCell(TBL_COL_CREDITFORMULA).setValue((Object)diffValue);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (this.kdtEntries.getRowCount() == 0) {
                this.actionAddLine_actionPerformed(null);
                this.actionAddLine_actionPerformed(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void groupTableRow() {
        this.kdtEntries.setColumnMoveable(true);
        int size = this.kdtEntries.getRowCount();
        int top = 0;
        int bottom = 0;
        KDTMergeManager mm = this.kdtEntries.getMergeManager();
        String previousdId = "";
        if (this.kdtEntries.getRowCount() > 0) {
            previousdId = this.kdtEntries.getRow(0).getCell(TBL_COL_NUMBER).getValue().toString();
        }
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            String number = (String)row.getCell(TBL_COL_NUMBER).getValue();
            if (number.equalsIgnoreCase(previousdId)) {
                ++bottom;
                if (i != size - 1) continue;
                mm.mergeBlock(top, 0, bottom - 1, 0, 4);
                mm.mergeBlock(top, 1, bottom - 1, 1, 4);
                mm.mergeBlock(top, 2, bottom - 1, 2, 4);
                mm.mergeBlock(top, 3, bottom - 1, 3, 4);
                continue;
            }
            mm.mergeBlock(top, 0, bottom - 1, 0, 4);
            mm.mergeBlock(top, 1, bottom - 1, 1, 4);
            mm.mergeBlock(top, 2, bottom - 1, 2, 4);
            mm.mergeBlock(top, 3, bottom - 1, 3, 4);
            previousdId = number;
            top = bottom++;
            if (i != size - 1) continue;
            mm.mergeBlock(top, 0, bottom - 1, 0, 4);
            mm.mergeBlock(top, 1, bottom - 1, 1, 4);
            mm.mergeBlock(top, 2, bottom - 1, 2, 4);
            mm.mergeBlock(top, 3, bottom - 1, 3, 4);
        }
    }

    private Sheet initBook() throws Exception {
        if (this.book == null) {
            this.book = Book.Manager.getNewBook((String)"Sheet1", (int)1);
            this.book.setCalculate(false);
        }
        Sheet sheet = this.book.getSheet(0);
        FormulaDefinition.registerFormulaToBook((Book)this.book, (ICalculateContextProvider)new ICalculateContextProvider(){

            public IErrorProvider getErrorProvider() {
                return null;
            }

            public IErrorResultProvider getErrorResultProvider() {
                return null;
            }

            public IReportPropertyAdapter getReportAdapter() {
                ICSLContext context = EliminationTemplateBatchImportUI.this.getCSLContext();
                CslReportInfo cslReport = new CslReportInfo();
                try {
                    cslReport.setOrgTree(context.getCurOrgBound());
                    cslReport.setOrgUnit(context.getCurOrgGroup());
                    cslReport.setYear(context.getCurRptYear());
                    cslReport.setPeriod((short)context.getCurRptPeriod());
                    cslReport.setPeriodType(context.getCurRptPeriodType());
                    cslReport.setCurrency((CurrencyInfo)EliminationTemplateBatchImportUI.this.comboCurrency.getSelectedItem());
                    cslReport.setSourceType(RptSrcTypeEnum.CONSOLIDATION);
                    cslReport.setOrgType(OrgType.Company);
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
                CSLPropertyAdapter adapter = new CSLPropertyAdapter(cslReport, null);
                return adapter;
            }

            public ReportVariables getReportVariables() {
                return new ReportVariables();
            }

            public Context getServerContext() {
                return null;
            }
        });
        return sheet;
    }

    private Object[][] getCalcValues(int entrySize) {
        this.book.calc();
        Sheet sheet = this.book.getSheet(0);
        Cell cell = null;
        Object[][] values = new Object[entrySize][2];
        for (int i = 0; i < entrySize; ++i) {
            cell = sheet.getCell(i, 0, false);
            if (cell != null && cell.getValue() != null) {
                values[i][0] = cell.getValue().getValue();
            }
            if ((cell = sheet.getCell(i, 1, false)) == null || cell.getValue() == null) continue;
            values[i][1] = cell.getValue().getValue();
        }
        return values;
    }

    protected void initListener() {
        if (this.getDetailTable() != null) {
            this.getDetailTable().addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        EliminationTemplateBatchImportUI.this.tblDetail_tableSelectChanged(e);
                    }
                    catch (Exception exc) {
                        EliminationTemplateBatchImportUI.this.handUIException(exc);
                    }
                }
            });
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EliminationFactory.getRemoteInstance();
    }

    @Override
    public void actionCreateOp_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateOp_actionPerformed(e);
        int count = this.kdtEntries.getRowCount();
        this.beforeStoreFields(e);
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> unSelectedList = new ArrayList<String>();
        HashMap<String, FullOrgUnitInfo> companyMap = new HashMap<String, FullOrgUnitInfo>();
        boolean isAdded = false;
        for (int i = 0; i < count; ++i) {
            IRow curRow = this.kdtEntries.getRow(i);
            String id = curRow.getCell("entryid").getValue().toString();
            boolean isSelected = (Boolean)curRow.getCell(TBL_COL_SELECT).getValue();
            if (!isSelected) {
                unSelectedList.add(id);
            } else if (!unSelectedList.contains(id) && !ids.contains(id)) {
                isAdded = true;
                String number = curRow.getCell(TBL_COL_NUMBER).getValue().toString();
                if (this.allNullList.contains(number) || this.hasZeroList.contains(number)) continue;
                ids.add(id);
            }
            if (!ids.contains(id)) continue;
            String entryid = curRow.getCell(this.TBL_COL_TEMPLATEENTRYID).getValue().toString();
            FullOrgUnitInfo company = null;
            if (curRow.getCell(TBL_COL_COMPANY).getValue() != null) {
                company = ((CompanyOrgUnitInfo)curRow.getCell(TBL_COL_COMPANY).getValue()).castToFullOrgUnitInfo();
            }
            if (companyMap.containsKey(entryid)) continue;
            companyMap.put(entryid, company);
        }
        int successCount = 0;
        if (!(ids != null && ids.size() != 0 || isAdded)) {
            throw new AdjustException(AdjustException.NOELIMTEMPLATE_SELECTED);
        }
        if (ids.size() > 0) {
            EliminationCollection elims = this.constructEliminationCollection(ids);
            OrgTreeInfo orgTreeInfo = this.getCSLContext().getCurOrgBound();
            FullOrgUnitInfo fullOrgUnit = null;
            CompanyOrgUnitInfo companyOrgUnit = null;
            if (this.getCSLContext().getCurOrgGroup() instanceof FullOrgUnitInfo) {
                fullOrgUnit = (FullOrgUnitInfo)this.getCSLContext().getCurOrgGroup();
            } else if (this.getCSLContext().getCurOrgGroup() instanceof CompanyOrgUnitInfo) {
                companyOrgUnit = (CompanyOrgUnitInfo)this.getCSLContext().getCurOrgGroup();
            }
            int periodType = this.getCSLContext().getCurRptPeriodType().getValue();
            int year = this.getCSLContext().getCurRptYear();
            int period = this.getCSLContext().getCurRptPeriod();
            successCount = elims.size();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("elims", (Object)elims);
            params.put("orgTree", orgTreeInfo);
            params.put("year", year);
            params.put("period", period);
            params.put("periodType", periodType);
            if (fullOrgUnit != null) {
                params.put("orgUnit", fullOrgUnit);
            } else if (companyOrgUnit != null) {
                params.put("orgUnit", companyOrgUnit);
            }
            EliminationFactory.getRemoteInstance().batchGenarateElimnationByTemplate(params);
        }
        StringBuffer msg = new StringBuffer();
        String resource = "com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource";
        msg.append(MessageFormat.format(EASResource.getString((String)resource, (String)"311_AdjustTemplateBatchImportUI"), successCount));
        if (this.hasZeroList.size() + this.allNullList.size() > 0) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"16_AdjustTemplateBatchImportUI");
            msg.append(MessageFormat.format(strMsg, this.hasZeroList.size() + this.allNullList.size()));
        }
        StringBuffer detailedMsg = new StringBuffer();
        if (this.hasZeroList.size() > 0) {
            String hasZero = "";
            for (int i = 0; i < this.hasZeroList.size(); ++i) {
                hasZero = hasZero + this.hasZeroList.get(i) + ",";
            }
            hasZero = hasZero.substring(0, hasZero.length() - 1);
            detailedMsg.append(EASResource.getString((String)resource, (String)"eliminationBatchAddTemplateNumber")).append(" ").append(hasZero);
            detailedMsg.append(" ").append(EASResource.getString((String)resource, (String)"eliminationBatchAddHasZero")).append("\n");
        }
        if (this.allNullList.size() > 0) {
            String allNull = "";
            for (int i = 0; i < this.allNullList.size(); ++i) {
                allNull = allNull + this.allNullList.get(i) + ",";
            }
            allNull = allNull.substring(0, allNull.length() - 1);
            detailedMsg.append(EASResource.getString((String)resource, (String)"eliminationBatchAddTemplateNumber")).append(" ").append(allNull);
            detailedMsg.append(" ").append(EASResource.getString((String)resource, (String)"eliminationBatchAddAllNull"));
        }
        MsgBox.showDetailAndOK((Component)((Object)this), (String)msg.toString(), (String)detailedMsg.toString(), (int)1);
    }

    private EliminationCollection constructEliminationCollection(List ids) throws BOSException {
        EliminationCollection elims = new EliminationCollection();
        EliminationInfo elim = null;
        EliminationEntryInfo elimEntryInfo = null;
        int count = this.kdtEntries.getRowCount();
        OrgTreeInfo orgTreeInfo = this.getCSLContext().getCurOrgBound();
        FullOrgUnitInfo fullOrgUnit = null;
        CompanyOrgUnitInfo companyOrgUnit = null;
        if (this.getCSLContext().getCurOrgGroup() instanceof FullOrgUnitInfo) {
            fullOrgUnit = (FullOrgUnitInfo)this.getCSLContext().getCurOrgGroup();
        } else if (this.getCSLContext().getCurOrgGroup() instanceof CompanyOrgUnitInfo) {
            companyOrgUnit = (CompanyOrgUnitInfo)this.getCSLContext().getCurOrgGroup();
        }
        Date bizDate = (Date)this.dateBizDate.getValue();
        Date createTime = (Date)this.dateCreateTime.getValue();
        CurrencyInfo sourceCurrency = (CurrencyInfo)this.comboSourceCurrency.getSelectedItem();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int periodType = this.getCSLContext().getCurRptPeriodType().getValue();
        int year = this.getCSLContext().getCurRptYear();
        int period = this.getCSLContext().getCurRptPeriod();
        TemplateTypeInfo displayType = null;
        String idString = (String)this.getUIContext().get("displayTypeId");
        if (idString != null) {
            displayType = new TemplateTypeInfo();
            displayType.setId(BOSUuid.read((String)idString));
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            IRow curRow = this.kdtEntries.getRow(i);
            String id = curRow.getCell("entryid").getValue().toString();
            IsCitedByLaterEnum isCitedByLaterEnum = (IsCitedByLaterEnum)((Object)curRow.getCell(TBL_COL_ISCITEDBYLATE).getValue());
            ValueTypeEnum valueTypeEnum = (ValueTypeEnum)((Object)curRow.getCell(TBL_COL_ELIMTYPE).getValue());
            EliminationModeInfo eliminationMode = null;
            if (curRow.getCell(TBL_COL_ELIMINATIOMMODE).getValue() != null) {
                eliminationMode = (EliminationModeInfo)curRow.getCell(TBL_COL_ELIMINATIOMMODE).getUserObject();
            }
            if (!ids.contains(id)) continue;
            if (!idSet.contains(id)) {
                elim = new EliminationInfo();
                elims.add(elim);
                elim.setOrgBound(orgTreeInfo);
                elim.setId(null);
                elim.setNumber(null);
                if (fullOrgUnit != null) {
                    elim.setOrgUnit(fullOrgUnit);
                } else if (companyOrgUnit != null) {
                    elim.setOrgUnit((OrgUnitInfo)companyOrgUnit);
                }
                elim.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                elim.setCreateTime(new Timestamp(createTime.getTime()));
                elim.setDate(bizDate);
                elim.setSourceCurrency(sourceCurrency);
                elim.setCurrency(currency);
                elim.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                elim.setElimType(ElimTypeEnum.General);
                elim.setValueType(valueTypeEnum);
                elim.setIsCitedByLater(isCitedByLaterEnum);
                elim.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                elim.setYear(year);
                elim.setPeriod(period);
                elim.setDisplayTemplateType(displayType);
                elim.setEliminationMode(eliminationMode);
                elim.setElimDataSource(ElimDataSourceEnum.statutoryMerger);
                idSet.add(id);
            }
            elimEntryInfo = new EliminationEntryInfo();
            RPTItemInfo rptItem = (RPTItemInfo)curRow.getCell(TBL_COL_ITEM_NUMBER).getValue();
            if (curRow.getCell(TBL_COL_COMPANY).getValue() != null) {
                FullOrgUnitInfo company = ((CompanyOrgUnitInfo)curRow.getCell(TBL_COL_COMPANY).getValue()).castToFullOrgUnitInfo();
                elimEntryInfo.setCompany(company);
            }
            String summary = (String)curRow.getCell(TBL_COL_SUMMARY).getValue();
            DataElementInfo de = (DataElementInfo)curRow.getCell(TBL_COL_DATAELEMENT).getValue();
            BigDecimal debit = null;
            BigDecimal credit = null;
            if (curRow.getCell(TBL_COL_DEBITFORMULA).getValue() != null) {
                debit = (BigDecimal)curRow.getCell(TBL_COL_DEBITFORMULA).getValue();
                elimEntryInfo.setDebit(debit);
            }
            if (curRow.getCell(TBL_COL_CREDITFORMULA).getValue() != null) {
                credit = (BigDecimal)curRow.getCell(TBL_COL_CREDITFORMULA).getValue();
                elimEntryInfo.setCredit(credit);
            }
            elimEntryInfo.setId(null);
            elimEntryInfo.setItem(rptItem);
            elimEntryInfo.setSummary(summary);
            elimEntryInfo.setDataElement(de.getInterSeq());
            elimEntryInfo.setIsVisible(true);
            if (elim == null || elim.getEntries() == null) continue;
            elim.getEntries().add(elimEntryInfo);
        }
        return elims;
    }

    @Override
    public void actionCancelOp_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            this.kdtEntries.getRow(i).getCell(TBL_COL_SELECT).setValue((Object)this.select);
        }
    }

    @Override
    public void actionSelectNo_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            this.kdtEntries.getRow(i).getCell(TBL_COL_SELECT).setValue((Object)this.unSelect);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntries.removeRows();
        this.initTable();
        this.groupTableRow();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            throw new AdjustException(AdjustException.CURRENCY_BLANK);
        }
        if (this.comboSourceCurrency.getSelectedItem() == null) {
            throw new AdjustException(AdjustException.CURRENCY_BLANK);
        }
        this.verifyEntries();
    }

    private void verifyEntries() throws Exception {
        String number;
        this.hasZeroList.clear();
        this.allNullList.clear();
        if (this.kdtEntries == null || this.kdtEntries.getRowCount() == 0) {
            throw new AdjustException(AdjustException.LINE_NOT_EXIST);
        }
        BigDecimal debitTotal = new BigDecimal("0");
        BigDecimal creditTotal = new BigDecimal("0");
        BigDecimal zero = new BigDecimal("0");
        String tempNum = "";
        boolean isAdd = true;
        boolean isAllZero = false;
        boolean isAllDCBalance = true;
        boolean hasNoComany = false;
        IRow row = null;
        int size = this.kdtEntries.getRowCount();
        ArrayList<String> list = new ArrayList<String>(size);
        StringBuffer key = new StringBuffer();
        String keyElim = "GR_CSL_AllowElimRRTM";
        Object value = null;
        ArrayList<String> notRemoveNulllist = new ArrayList<String>(size);
        ArrayList<String> notRemoveZerolist = new ArrayList<String>(size);
        try {
            value = CslRptUtil.getParamValue(null, null, keyElim);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        boolean allow = "true".equals(value);
        ArrayList<String> selectedList = new ArrayList<String>();
        boolean pass = true;
        for (int i = 0; i < size; ++i) {
            BigDecimal credit;
            BigDecimal debit;
            row = this.kdtEntries.getRow(i);
            String id = row.getCell("entryid").getValue().toString();
            number = row.getCell(TBL_COL_NUMBER).getValue().toString();
            boolean select = (Boolean)row.getCell(TBL_COL_SELECT).getValue();
            if (select && !selectedList.contains(number)) {
                selectedList.add(number);
            }
            if (!selectedList.contains(number)) continue;
            pass = true;
            if (!tempNum.equals(number)) {
                if (debitTotal.compareTo(creditTotal) != 0) {
                    isAllDCBalance = false;
                }
                debitTotal = new BigDecimal("0");
                creditTotal = new BigDecimal("0");
                debit = null;
                credit = null;
                tempNum = number;
            }
            DataBaseInfo rptItem = (DataBaseInfo)row.getCell(TBL_COL_ITEM_NUMBER).getValue();
            debit = (BigDecimal)row.getCell(TBL_COL_DEBITFORMULA).getValue();
            credit = (BigDecimal)row.getCell(TBL_COL_CREDITFORMULA).getValue();
            CslRptUtil.checkNumberLong(debit, 15, 6);
            CslRptUtil.checkNumberLong(credit, 15, 6);
            if (rptItem == null) {
                throw new AdjustException(AdjustException.RPTITEM_BLANK, new Object[]{Integer.toString(i + 1)});
            }
            String s = (String)row.getCell(TBL_COL_SUMMARY).getValue();
            if (!StringUtils.isEmpty((String)s) && s.length() > 255) {
                row.getCell(TBL_COL_SUMMARY).setValue((Object)s.substring(0, 254));
            }
            key.setLength(0);
            DataBaseInfo company = (DataBaseInfo)row.getCell(TBL_COL_COMPANY).getValue();
            DataBaseInfo dataElement = (DataBaseInfo)row.getCell(TBL_COL_DATAELEMENT).getValue();
            if (company != null) {
                key.append(company.getNumber()).append("; ");
            } else {
                hasNoComany = true;
            }
            key.append(number).append("; ");
            key.append(rptItem.getNumber()).append("; ");
            key.append(dataElement.getNumber());
            if (!allow && list.contains(key.toString())) {
                String companyName = company != null ? company.getName() : EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"805_EliminationHandEditUI");
                throw new AdjustException(AdjustException.RPTITEMANDCOMPANY_DUP, new Object[]{companyName, rptItem.getNumber(), dataElement.getName()});
            }
            list.add(key.toString());
            isAdd = true;
            if (row.getCell(TBL_COL_DATAELEMENT).getValue() != null && ((DataElementInfo)row.getCell(TBL_COL_DATAELEMENT).getValue()).getInterSeq() == 2) {
                isAdd = false;
            }
            if (debit != null) {
                if (isAdd && debit.compareTo(zero) != 0) {
                    debitTotal = debitTotal.add(debit);
                    if (!notRemoveNulllist.contains(number)) {
                        notRemoveNulllist.add(number);
                    }
                    if (!notRemoveZerolist.contains(number)) {
                        notRemoveZerolist.add(number);
                    }
                }
                if (debit.compareTo(zero) == 0 && !this.hasZeroList.contains(number)) {
                    this.hasZeroList.add(number);
                }
            }
            if (credit != null) {
                if (isAdd && credit.compareTo(zero) != 0) {
                    creditTotal = creditTotal.add(credit);
                    if (!notRemoveNulllist.contains(number)) {
                        notRemoveNulllist.add(number);
                    }
                    if (!notRemoveZerolist.contains(number)) {
                        notRemoveZerolist.add(number);
                    }
                }
                if (credit.compareTo(zero) == 0 && !this.hasZeroList.contains(number)) {
                    this.hasZeroList.add(number);
                }
            }
            if (debit != null || credit != null || this.allNullList.contains(number)) continue;
            this.allNullList.add(number);
        }
        Iterator notRemoveNullIt = notRemoveNulllist.iterator();
        while (notRemoveNullIt.hasNext()) {
            String number2 = notRemoveNullIt.next().toString();
            if (!this.allNullList.contains(number2)) continue;
            this.allNullList.remove(number2);
        }
        Iterator notRemoveZeroIt = notRemoveZerolist.iterator();
        while (notRemoveZeroIt.hasNext()) {
            number = notRemoveZeroIt.next().toString();
            if (!this.hasZeroList.contains(number)) continue;
            this.hasZeroList.remove(number);
        }
        if (debitTotal.compareTo(creditTotal) != 0) {
            isAllDCBalance = false;
        }
        if (!isAllDCBalance && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.ElimResName, (String)"DC_NOT_EQUAL")) == 2) {
            SysUtil.abort();
        }
        if (hasNoComany) {
            if (this.isSupportCrossMerger) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.ElimResName, (String)"104ElimTempletEditUI.Company_NOTEmpty"));
                SysUtil.abort();
            } else if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.ElimResName, (String)"ElimTempletEditUI.Company_Empty")) == 2) {
                SysUtil.abort();
            }
        }
    }

    public boolean destroyWindow() {
        Object owner = this.getUIContext().get("Owner");
        try {
            if (owner instanceof ListUI) {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return super.destroyWindow();
    }

    protected void initCSLContext() {
        boolean bl = this.isFromCslMerge = this.getUIContext().get("cslCtx") != null;
        if (this.isFromCslMerge) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else if (CSLContextHelper.isInitialized(this.getUIContext())) {
            this.cslCtx = CSLContextHelper.getCSLContext();
        } else {
            SysUtil.abort();
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }
}

