/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimDataSourceEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationMode;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEliminationViewFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EliminationViewFilterUI
extends AbstractEliminationViewFilterUI {
    private static final Logger logger = Logger.getLogger(EliminationViewFilterUI.class);
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private String whichOpen = null;
    private IDataElement iDataElement = null;
    ArrayList permTreeIdList = new ArrayList();
    OrgTreeCollection otc = null;
    private boolean isMergeByFiscalPeriod;
    private boolean isSupport13Period;
    private String openSource = null;
    private Map fiterParam = null;
    private boolean isMerge = false;

    public EliminationViewFilterUI() throws Exception {
    }

    public void onLoad() throws Exception {
        Object o = this.getUIContext().get("openSource");
        if (o == null) {
            this.init(this.openSource);
        } else {
            this.init(o.toString());
        }
        this.initListener();
        this.initInvCompanyAndTargetCompany();
        this.initElimTemplateF7();
        if (this.kdElimDataSource.getItemCount() <= 0) {
            this.kdElimDataSource.addItem((Object)this.selectAll);
            this.kdElimDataSource.addItems(ElimDataSourceEnum.getEnumList().toArray());
            this.kdElimDataSource.setSelectedIndex(0);
        }
    }

    private void initInvCompanyAndTargetCompany() throws Exception {
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1);
        f7.setMultiSelect(false);
        f7.setNeedAddOrgRange(false);
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        this.invCompanyF7.setSelector((KDPromptSelector)f7);
        this.invCompanyF7.setEditable(true);
        this.invCompanyF7.setHRHistoryEnbable(false);
        this.invCompanyF7.setCommitFormat("$number$");
        this.invCompanyF7.setDisplayFormat("$name$");
        this.targetCompanyF7.setSelector((KDPromptSelector)f7);
        this.targetCompanyF7.setEditable(true);
        this.targetCompanyF7.setHRHistoryEnbable(false);
        this.targetCompanyF7.setCommitFormat("$number$");
        this.targetCompanyF7.setDisplayFormat("$name$");
        this.companyF7.setSelector((KDPromptSelector)f7);
        this.companyF7.setEditable(true);
        this.companyF7.setHRHistoryEnbable(false);
        this.companyF7.setCommitFormat("$number$");
        this.companyF7.setDisplayFormat("$name$");
        this.invCompanyF7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                OrgTreeInfo tree = (OrgTreeInfo)EliminationViewFilterUI.this.cbxOrgBound.getSelectedItem();
                if (tree != null) {
                    UnionF7Helper.UnionF7 f7 = (UnionF7Helper.UnionF7)EliminationViewFilterUI.this.invCompanyF7.getSelector();
                    OrgTreeCollection orgTreesByDate = EliminationViewFilterUI.this.getOrgTreesByDate(tree);
                    if (orgTreesByDate != null && !orgTreesByDate.isEmpty()) {
                        f7.setOrgTrees(orgTreesByDate);
                    } else {
                        f7.setTreeID(tree.getId().toString());
                    }
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"HisExchgSelectBound"));
                    SysUtil.abort();
                }
            }
        });
        this.targetCompanyF7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                OrgTreeInfo tree = (OrgTreeInfo)EliminationViewFilterUI.this.cbxOrgBound.getSelectedItem();
                if (tree != null) {
                    UnionF7Helper.UnionF7 f7 = (UnionF7Helper.UnionF7)EliminationViewFilterUI.this.targetCompanyF7.getSelector();
                    OrgTreeCollection orgTreesByDate = EliminationViewFilterUI.this.getOrgTreesByDate(tree);
                    if (orgTreesByDate != null && !orgTreesByDate.isEmpty()) {
                        f7.setOrgTrees(orgTreesByDate);
                    } else {
                        f7.setTreeID(tree.getId().toString());
                    }
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"HisExchgSelectBound"));
                    SysUtil.abort();
                }
            }
        });
        this.companyF7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                OrgTreeInfo tree = (OrgTreeInfo)EliminationViewFilterUI.this.cbxOrgBound.getSelectedItem();
                if (tree != null) {
                    UnionF7Helper.UnionF7 f7 = (UnionF7Helper.UnionF7)EliminationViewFilterUI.this.companyF7.getSelector();
                    OrgTreeCollection orgTreesByDate = EliminationViewFilterUI.this.getOrgTreesByDate(tree);
                    if (orgTreesByDate != null && !orgTreesByDate.isEmpty()) {
                        f7.setOrgTrees(orgTreesByDate);
                    } else {
                        f7.setTreeID(tree.getId().toString());
                    }
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"HisExchgSelectBound"));
                    SysUtil.abort();
                }
            }
        });
    }

    private OrgTreeCollection getOrgTreesByDate(OrgTreeInfo tree) {
        if (this.otc != null && !this.otc.isEmpty()) {
            String number = tree.getNumber();
            Date startDate = this.getStartDate();
            Date endDate = this.getEndDate();
            Iterator it = this.otc.iterator();
            OrgTreeCollection orgtrees = new OrgTreeCollection();
            while (it.hasNext()) {
                OrgTreeInfo treeInfo = (OrgTreeInfo)it.next();
                Timestamp treeStratDate = treeInfo.getStartDate();
                Timestamp treeEndDate = treeInfo.getEndDate();
                if (!(treeStratDate != null && startDate.compareTo(treeStratDate) <= 0 && (treeEndDate == null && endDate.compareTo(treeStratDate) >= 0 || treeEndDate != null && endDate.compareTo(treeEndDate) >= 0)) && (treeStratDate == null || startDate.compareTo(treeStratDate) < 0 || treeEndDate != null && startDate.compareTo(treeEndDate) > 0) || !number.equals(treeInfo.getNumber())) continue;
                orgtrees.add(treeInfo);
            }
            return orgtrees;
        }
        return null;
    }

    private Date getStartDate() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
        int year = this.startYearSpin.getIntegerVlaue();
        int period = this.startPeriodSpin.getIntegerVlaue();
        Date startDate = RPTDateUtil.getPeriodFirstDate(year, period, periodType);
        Timestamp time = new Timestamp(startDate.getTime());
        return time;
    }

    private Date getEndDate() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
        int year = this.endYearSpin.getIntegerVlaue();
        int period = this.endPeriodSpin.getIntegerVlaue();
        Date endDate = RPTDateUtil.getPeriodLastDate(year, period, periodType);
        Timestamp time = new Timestamp(endDate.getTime());
        return time;
    }

    private void initElimTemplateF7() throws Exception {
        this.templateF7.setEditable(false);
        this.templateF7.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.InvestTempleteQuery");
        this.templateF7.setHRHistoryEnbable(false);
        this.templateF7.setCommitFormat("$number$");
        this.templateF7.setDisplayFormat("$name$");
        this.templateF7.setEnabledMultiSelection(true);
    }

    public void initListener() {
        super.initListener();
        CslRptUIUtil.addSynchValueListener((IKDComponent)this.bizPrmtItemFrom, (IKDComponent)this.bizPrmtItemTo);
        CslRptUIUtil.addSynchValueListener((IKDComponent)this.txtNumberFrom, (IKDComponent)this.txtNumberTo);
        CslRptUIUtil.addSynchValueListener((IKDComponent)this.txtDebitFrom, (IKDComponent)this.txtDebitTo);
        CslRptUIUtil.addSynchValueListener((IKDComponent)this.txtCreditFrom, (IKDComponent)this.txtCreditTo);
        this.cbxOrgBound.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EliminationViewFilterUI.this.companyF7.setData(null);
            }
        });
        this.startYearSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EliminationViewFilterUI.this.yearOrPeriodChange(1, e);
            }
        });
        this.startPeriodSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EliminationViewFilterUI.this.yearOrPeriodChange(2, e);
            }
        });
        this.endYearSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EliminationViewFilterUI.this.yearOrPeriodChange(3, e);
            }
        });
        this.endPeriodSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EliminationViewFilterUI.this.yearOrPeriodChange(4, e);
            }
        });
    }

    private void yearOrPeriodChange(int flag, ChangeEvent e) {
        int startYear = (Integer)this.startYearSpin.getValue();
        int startPeriod = (Integer)this.startPeriodSpin.getValue();
        int endYear = (Integer)this.endYearSpin.getValue();
        int endPeriod = (Integer)this.endPeriodSpin.getValue();
        switch (flag) {
            case 1: {
                if (startYear < endYear) break;
                this.endYearSpin.setValue((Object)startYear, false);
                if (startPeriod <= endPeriod) break;
                this.endPeriodSpin.setValue((Object)startPeriod, false);
                break;
            }
            case 2: {
                if (startPeriod <= endPeriod || startYear != endYear) break;
                this.endPeriodSpin.setValue((Object)startPeriod, false);
                break;
            }
            case 3: {
                if (endYear > startYear) break;
                this.startYearSpin.setValue((Object)endYear, false);
                if (endPeriod >= startPeriod) break;
                this.startPeriodSpin.setValue((Object)endPeriod, false);
                break;
            }
            case 4: {
                if (endPeriod >= startPeriod || startYear != endYear) break;
                this.startPeriodSpin.setValue((Object)endPeriod, false);
                break;
            }
        }
    }

    public EliminationViewFilterUI(String openSource) throws Exception {
        this.openSource = openSource;
    }

    public EliminationViewFilterUI(String openSource, boolean isMerge) throws Exception {
        this(openSource);
        this.isMerge = isMerge;
    }

    public void setFiterParam(Map fiterParam) {
        this.fiterParam = fiterParam;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void init(String openSource) throws Exception {
        this.whichOpen = openSource;
        this.isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(null);
        this.isSupport13Period = CslRptUtil.isSupport13Period(null);
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.cbxElimType.addItem((Object)this.selectAll);
        this.cbxElimType.setSelectedItem((Object)this.selectAll);
        this.cbxElimType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.cbxElimType.addItem((Object)ElimTypeEnum.exchange);
        this.cbxElimType.addItem((Object)ElimTypeEnum.General);
        this.cbxElimType.addItem((Object)ElimTypeEnum.MAIN_INVEST);
        this.cbxElimType.addItem((Object)ElimTypeEnum.HK_COST);
        this.cbxElimType.addItem((Object)ElimTypeEnum.MAIN_COST);
        this.cbxElimType.addItem((Object)ElimTypeEnum.Main_Invest_New);
        this.bizDataElement.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        this.bizDataElement.setEditFormat("$number$");
        this.bizDataElement.setDisplayFormat("$name$");
        this.bizDataElement.setEditable(true);
        this.bizDataElement.setCommitFormat("$number$");
        CslGradeManageUtil.setDataElementF7GMFilter((KDBizPromptBox)this.bizDataElement, null, (boolean)false);
        if (this.whichOpen.equals("Hand")) {
            this.cbxElimType.setSelectedItem((Object)ElimTypeEnum.General);
            this.cbxElimType.setEnabled(false);
            this.bizDataElement.setEnabled(true);
        } else if (this.whichOpen.equals("Auto")) {
            this.cbxElimType.setSelectedItem((Object)this.selectAll);
            this.cbxElimType.removeItem((Object)ElimTypeEnum.General);
            this.bizDataElement.setEnabled(true);
        } else if (this.whichOpen.equals("All")) {
            this.cbxElimType.setSelectedIndex(0);
            this.cbxElimType.setEnabled(true);
            this.bizDataElement.setEnabled(true);
        }
        this.cbxCurrency.addItem((Object)this.selectAll);
        this.cbxCurrency.setSelectedIndex(0);
        this.cbxSourceCurrency.addItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedIndex(0);
        CurrencyCollection currencyCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currentInfo = currencyCollection.get(i);
                this.cbxCurrency.addItem((Object)currentInfo);
                this.cbxSourceCurrency.addItem((Object)currentInfo);
                if (this.fiterParam == null || this.fiterParam.get("currencyId") == null || !currentInfo.getId().toString().equals((String)this.fiterParam.get("currencyId"))) continue;
                this.cbxCurrency.setSelectedIndex(i);
                this.cbxSourceCurrency.setSelectedIndex(i);
            }
        }
        this.bizPrmtItemFrom.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemFrom.setEditFormat("$number$");
        this.bizPrmtItemFrom.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemFrom.setEditable(true);
        this.bizPrmtItemFrom.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizPrmtItemFrom, null);
        this.bizPrmtItemTo.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemTo.setEditFormat("$number$");
        this.bizPrmtItemTo.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemTo.setEditable(true);
        this.bizPrmtItemTo.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizPrmtItemTo, null);
        this.txtDebitFrom.setDataType(1);
        this.txtDebitFrom.setPrecision(2);
        this.txtDebitFrom.setNegatived(true);
        this.txtDebitFrom.setEditable(true);
        this.txtDebitFrom.setSupportedEmpty(true);
        this.txtDebitTo.setDataType(1);
        this.txtDebitTo.setPrecision(2);
        this.txtDebitTo.setNegatived(true);
        this.txtDebitTo.setEditable(true);
        this.txtDebitTo.setSupportedEmpty(true);
        this.txtCreditFrom.setDataType(1);
        this.txtCreditFrom.setPrecision(2);
        this.txtCreditFrom.setNegatived(true);
        this.txtCreditFrom.setEditable(true);
        this.txtCreditFrom.setSupportedEmpty(true);
        this.txtCreditTo.setDataType(1);
        this.txtCreditTo.setPrecision(2);
        this.txtCreditTo.setNegatived(true);
        this.txtCreditTo.setEditable(true);
        this.txtCreditTo.setSupportedEmpty(true);
        this.periodTypeCombo.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        this.periodTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptPeriodTypeEnum item = (RptPeriodTypeEnum)e.getItem();
                    if (EliminationViewFilterUI.this.isMergeByFiscalPeriod()) {
                        FiscalPeriodHelper.setSpineRangeByPeriodType(EliminationViewFilterUI.this.startPeriodSpin, item, false);
                        FiscalPeriodHelper.setSpineRangeByPeriodType(EliminationViewFilterUI.this.endPeriodSpin, item, false);
                    } else {
                        EliminationViewFilterUI.this.setPeriodRange(EliminationViewFilterUI.this.startPeriodSpin, item.getValue(), (Integer)EliminationViewFilterUI.this.startYearSpin.getValue());
                        EliminationViewFilterUI.this.setPeriodRange(EliminationViewFilterUI.this.endPeriodSpin, item.getValue(), (Integer)EliminationViewFilterUI.this.endYearSpin.getValue());
                    }
                    int[] period = EliminationViewFilterUI.this.getLastPeriod(item);
                    int curYear = new Integer(period[0]);
                    int curPeriod = new Integer(period[1]);
                    if (EliminationViewFilterUI.this.fiterParam != null && EliminationViewFilterUI.this.fiterParam.get("year") != null && EliminationViewFilterUI.this.fiterParam.get("period") != null) {
                        if ((Integer)EliminationViewFilterUI.this.fiterParam.get("year") > 0) {
                            curYear = (Integer)EliminationViewFilterUI.this.fiterParam.get("year");
                        }
                        if ((Integer)EliminationViewFilterUI.this.fiterParam.get("period") > 0) {
                            curPeriod = (Integer)EliminationViewFilterUI.this.fiterParam.get("period");
                        }
                    }
                    EliminationViewFilterUI.this.startYearSpin.setValue((Object)curYear);
                    EliminationViewFilterUI.this.endYearSpin.setValue((Object)curYear);
                    EliminationViewFilterUI.this.startPeriodSpin.setValue((Object)curPeriod);
                    EliminationViewFilterUI.this.endPeriodSpin.setValue((Object)curPeriod);
                }
            }
        });
        this.endYearSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EliminationViewFilterUI.this.startYearSpinChangeAction(e);
            }
        });
        this.startPeriodSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EliminationViewFilterUI.this.startPeriodSpinChangeAction(e);
            }
        });
        if (this.fiterParam != null && this.fiterParam.get("periodType") != null) {
            this.periodTypeCombo.setSelectedItem((Object)((RptPeriodTypeEnum)this.fiterParam.get("periodType")));
        } else {
            this.periodTypeCombo.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        }
        if (this.fiterParam != null && this.fiterParam.get("year") != null) {
            this.startYearSpin.setValue((Object)((Integer)this.fiterParam.get("year")));
            this.endYearSpin.setValue((Object)((Integer)this.fiterParam.get("year")));
        }
        if (this.fiterParam != null && this.fiterParam.get("period") != null) {
            this.startPeriodSpin.setValue((Object)((Integer)this.fiterParam.get("period")));
            this.endPeriodSpin.setValue((Object)((Integer)this.fiterParam.get("period")));
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        HashSet<String> set = new HashSet<String>();
        OrgTreeCollection treeCol = CslRptUtil.getAllUnionTreesOrderByNumber(null, userInfo.getId().toString(), null, true);
        if (!this.isMerge) {
            treeCol = CslRptUtil.getOrgTreeCollectionFilterProfitOrg(null, treeCol, true);
        }
        if (this.otc != null) {
            this.otc.clear();
        }
        if (treeCol != null && treeCol.size() > 0) {
            for (int i = 0; i < treeCol.size(); ++i) {
                OrgTreeInfo curOrgTreeInfo;
                if (!treeCol.get(i).getStatus().equals((Object)UnionVersionStatusEnum.START) && !treeCol.get(i).getStatus().equals((Object)UnionVersionStatusEnum.ARCHIVE)) continue;
                if (this.otc == null) {
                    this.otc = new OrgTreeCollection();
                }
                if (!this.permTreeIdList.contains(treeCol.get(i).getId().toString())) {
                    this.permTreeIdList.add(treeCol.get(i).getId().toString());
                    this.otc.add(treeCol.get(i));
                }
                if (set.contains(treeCol.get(i).getNumber())) continue;
                set.add(treeCol.get(i).getNumber());
                OrgTreeInfo treeInfo = (OrgTreeInfo)treeCol.get(i).clone();
                treeInfo.remove("type");
                treeInfo.remove("isVersioned");
                this.cbxOrgBound.addItem((Object)treeInfo);
                if (this.fiterParam == null || (curOrgTreeInfo = (OrgTreeInfo)this.fiterParam.get("orgBound")) == null || !treeCol.get(i).getNumber().equals(curOrgTreeInfo.getNumber())) continue;
                this.cbxOrgBound.setSelectedItem((Object)treeCol.get(i));
            }
        }
        if (this.cbxOrgBound.getItemCount() != 0) {
            this.cbxOrgBound.setSelectedIndex(0);
        }
        this.cmbxAuditStatus.addItem((Object)this.selectAll);
        this.cmbxAuditStatus.addItems(CheckedStatusEnum.getEnumList().toArray());
        this.comboElimMode.addItem((Object)this.selectAll);
        IEliminationMode iElimMode = EliminationModeFactory.getRemoteInstance();
        EntityViewInfo elimMode = new EntityViewInfo();
        elimMode.getSelector().add(new SelectorItemInfo("id"));
        elimMode.getSelector().add(new SelectorItemInfo("number"));
        elimMode.getSelector().add(new SelectorItemInfo("name"));
        elimMode.getSorter().add(new SorterItemInfo("number"));
        CslGradeManageUtil.filterElimModeGradeManage((EntityViewInfo)elimMode, null);
        EliminationModeCollection collection = iElimMode.getEliminationModeCollection(elimMode);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                this.comboElimMode.addItem((Object)collection.get(i));
            }
        }
    }

    protected OrgTreeCollection getOrgTreeCollectionFilterProfitOrg(OrgTreeCollection treeCol) throws EASBizException, BOSException {
        treeCol = CslRptUtil.getOrgTreeCollectionFilterProfitOrg(null, treeCol);
        return treeCol;
    }

    protected void startYearSpinChangeAction(ChangeEvent e) {
    }

    protected void startPeriodSpinChangeAction(ChangeEvent e) {
    }

    private int[] getLastPeriod(RptPeriodTypeEnum t) {
        Calendar c = Calendar.getInstance();
        int thismonth = c.get(2);
        do {
            c.add(5, -1);
        } while (c.get(2) == thismonth);
        int[] period = RPTDateUtil.getPeriod(new Date(c.getTimeInMillis()), t);
        return period;
    }

    protected void setPeriodRange(KDSpinner sp, int period_type, int year) {
        int max = 1;
        int min = 1;
        switch (period_type) {
            case 6: {
                break;
            }
            case 5: {
                max = 2;
                break;
            }
            case 4: {
                max = 4;
                break;
            }
            case 3: {
                max = "true".equalsIgnoreCase(String.valueOf(CslRptUtil.isSupport13Period(null))) ? 13 : 12;
                break;
            }
            case 2: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(3, 1);
                } while (cal.get(1) == year);
                max = count;
                break;
            }
            case 1: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(6, 1);
                } while (cal.get(1) == year);
                max = count;
            }
        }
        this.setSpineRange(sp, min, max);
    }

    protected void setSpineRange(KDSpinner sp, int minVal, int maxVal) {
        CslRptUIUtil.setSpineRange(sp, minVal, maxVal);
    }

    public SorterItemCollection getSorterItems() {
        return super.getSorterItems();
    }

    public boolean verify() {
        PeriodCollection periods = null;
        if (this.isMergeByFiscalPeriod()) {
            try {
                periods = FiscalPeriodHelper.getPeriodCollection(null, (OrgTreeInfo)this.cbxOrgBound.getSelectedItem());
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return FiscalPeriodHelper.HaveManyOrgTreeVersion((Component)((Object)this), this.periodTypeCombo, this.startYearSpin, this.endYearSpin, this.startPeriodSpin, this.endPeriodSpin, this.cbxOrgBound, periods, this.isMergeByFiscalPeriod, this.isSupport13Period);
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterItemTo;
        String orgId;
        String summary;
        String customNumber;
        FilterItemInfo item;
        FilterItemInfo filterItemCurrency;
        StringBuffer sbFormula;
        int formulaIndex;
        block49: {
            FilterItemInfo equalsStartYear;
            if (this.filterInfo == null) {
                this.filterInfo = new FilterInfo();
            } else {
                this.filterInfo.getFilterItems().clear();
            }
            formulaIndex = 0;
            sbFormula = new StringBuffer();
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
            FilterItemInfo filterItemPeriodType = new FilterItemInfo("periodType", (Object)new Integer(((RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem()).getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemPeriodType);
            sbFormula.append(" #" + formulaIndex++);
            if (this.startYearSpin.getValue() != null && this.startPeriodSpin.getValue() != null && this.startPeriodSpin.getValue() != null) {
                FilterItemInfo greaterStartYear = new FilterItemInfo("year", (Object)new Integer(this.startYearSpin.getValue().toString()), CompareType.GREATER);
                this.filterInfo.getFilterItems().add(greaterStartYear);
                equalsStartYear = new FilterItemInfo("year", (Object)new Integer(this.startYearSpin.getValue().toString()), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(equalsStartYear);
                FilterItemInfo startPeriod = new FilterItemInfo("period", (Object)new Integer(this.startPeriodSpin.getValue().toString()), CompareType.GREATER_EQUALS);
                this.filterInfo.getFilterItems().add(startPeriod);
                if (formulaIndex == 0) {
                    sbFormula.append(" (#" + formulaIndex++ + " or ( #" + formulaIndex++ + " and #" + formulaIndex++ + "))");
                } else {
                    sbFormula.append(" and (#" + formulaIndex++ + " or ( #" + formulaIndex++ + " and #" + formulaIndex++ + "))");
                }
            }
            if (this.endYearSpin.getValue() != null && this.endPeriodSpin.getValue() != null) {
                FilterItemInfo lessStartYear = new FilterItemInfo("year", (Object)new Integer(this.endYearSpin.getValue().toString()), CompareType.LESS);
                this.filterInfo.getFilterItems().add(lessStartYear);
                equalsStartYear = new FilterItemInfo("year", (Object)new Integer(this.endYearSpin.getValue().toString()), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(equalsStartYear);
                FilterItemInfo equalsEndPeriod = new FilterItemInfo("period", (Object)new Integer(this.endPeriodSpin.getValue().toString()), CompareType.LESS_EQUALS);
                this.filterInfo.getFilterItems().add(equalsEndPeriod);
                if (formulaIndex == 0) {
                    sbFormula.append(" (#" + formulaIndex++ + " or ( #" + formulaIndex++ + " and #" + formulaIndex++ + "))");
                } else {
                    sbFormula.append(" and (#" + formulaIndex++ + " or ( #" + formulaIndex++ + " and #" + formulaIndex++ + "))");
                }
            }
            Integer startYear = (Integer)this.startYearSpin.getValue();
            Integer endYear = (Integer)this.endYearSpin.getValue();
            Integer permStartYear = null;
            Integer permEndYear = null;
            if (startYear <= endYear) {
                permStartYear = startYear;
                permEndYear = endYear;
            } else {
                permStartYear = endYear;
                permEndYear = startYear;
            }
            Integer startPeriod = (Integer)this.startPeriodSpin.getValue();
            Integer endPeriod = (Integer)this.endPeriodSpin.getValue();
            Integer permStartPeriod = null;
            Integer permEndPeriod = null;
            if (startPeriod <= endPeriod) {
                permStartPeriod = startPeriod;
                permEndPeriod = endPeriod;
            } else {
                permStartPeriod = endPeriod;
                permEndPeriod = startPeriod;
            }
            if (this.cbxOrgBound.getItemCount() != 0 && this.cbxOrgBound.getSelectedItem() != null) {
                OrgTreeInfo tree = (OrgTreeInfo)this.cbxOrgBound.getSelectedItem();
                try {
                    PeriodCollection periods = null;
                    if (this.isMergeByFiscalPeriod()) {
                        periods = FiscalPeriodHelper.getPeriodCollection(null, tree);
                    }
                    Map mapResult = FiscalPeriodHelper.getOrgTreeByPeriods(null, periods, tree.getNumber(), permStartYear, permEndYear, startPeriod, endPeriod, periodType.getValue(), this.isMergeByFiscalPeriod, this.isSupport13Period);
                    String treeId = null;
                    if (mapResult.size() > 0 && !mapResult.isEmpty()) {
                        Iterator iter = mapResult.keySet().iterator();
                        if (iter.hasNext() && !this.permTreeIdList.contains(treeId = (String)iter.next())) {
                            treeId = null;
                        }
                        if (treeId != null) {
                            String treeNumber = tree.getNumber();
                            if (treeNumber != null && !treeNumber.equals("")) {
                                FilterItemInfo filterItemNumber = new FilterItemInfo("orgBound.number", (Object)treeNumber, CompareType.EQUALS);
                                this.filterInfo.getFilterItems().add(filterItemNumber);
                                sbFormula.append(" and #" + formulaIndex++);
                            }
                            FilterItemInfo filterItemOrgBound = new FilterItemInfo("orgBound.id", (Object)treeId, CompareType.EQUALS);
                            this.filterInfo.getFilterItems().add(filterItemOrgBound);
                            sbFormula.append("  and  #" + formulaIndex++);
                        } else {
                            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"315_AdjustViewFilterUI"));
                            SysUtil.abort();
                        }
                        break block49;
                    }
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"315_AdjustViewFilterUI"));
                    SysUtil.abort();
                }
                catch (EASBizException e) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"315_AdjustViewFilterUI"));
                    SysUtil.abort();
                }
                catch (BOSException e) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"315_AdjustViewFilterUI"));
                    SysUtil.abort();
                }
            } else {
                FilterItemInfo filterItemOrgBound = new FilterItemInfo("orgBound.id", (Object)"", CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemOrgBound);
                sbFormula.append("  and  #" + formulaIndex++);
            }
        }
        if (this.cbxCurrency.getSelectedItem() != null && !this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.cbxSourceCurrency.getSelectedItem() != null && !this.cbxSourceCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("sourceCurrency.id", (Object)((CurrencyInfo)this.cbxSourceCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.cbxElimType.getSelectedItem() != null && !this.cbxElimType.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterElimType = new FilterItemInfo("elimType", (Object)new Integer(((ElimTypeEnum)((Object)this.cbxElimType.getSelectedItem())).getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterElimType);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.bizDataElement.getValue() != null) {
            FilterItemInfo filterDataElement = new FilterItemInfo("entries.dataElement", (Object)new Integer(((DataElementInfo)this.bizDataElement.getValue()).getInterSeq()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterDataElement);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.bizPrmtItemFrom.getData() != null) {
            String itemNumberFrom = ((RPTItemInfo)this.bizPrmtItemFrom.getData()).getNumber();
            FilterItemInfo filterItemFrom = new FilterItemInfo("item.number", (Object)itemNumberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.bizPrmtItemTo.getData() != null) {
            String itemNumberTo = ((RPTItemInfo)this.bizPrmtItemTo.getData()).getNumber();
            FilterItemInfo filterItemTo2 = new FilterItemInfo("item.number", (Object)itemNumberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo2);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            String numberFrom = this.txtNumberFrom.getText().trim();
            FilterItemInfo filterNumberFrom = new FilterItemInfo("number", (Object)numberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            String numberTo = this.txtNumberTo.getText().trim();
            FilterItemInfo filterNumberTo = new FilterItemInfo("number", (Object)numberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitFrom.getText() != null && this.txtDebitFrom.getText().trim().length() > 0) {
            BigDecimal debitFrom = this.txtDebitFrom.getBigDecimalValue();
            FilterItemInfo filterDebitFrom = new FilterItemInfo("entries.debit", (Object)debitFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitTo.getText() != null && this.txtDebitTo.getText().trim().length() > 0) {
            BigDecimal debitTo = this.txtDebitTo.getBigDecimalValue();
            FilterItemInfo filterDebitTo = new FilterItemInfo("entries.debit", (Object)debitTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditFrom.getText() != null && this.txtCreditFrom.getText().trim().length() > 0) {
            BigDecimal creditFrom = this.txtCreditFrom.getBigDecimalValue();
            FilterItemInfo filterCreditFrom = new FilterItemInfo("entries.credit", (Object)creditFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditTo.getText() != null && this.txtCreditTo.getText().trim().length() > 0) {
            BigDecimal creditTo = this.txtCreditTo.getBigDecimalValue();
            FilterItemInfo filterCreditTo = new FilterItemInfo("entries.credit", (Object)creditTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        formulaIndex = this.filterInfo.getFilterItems().size();
        if (this.cmbxAuditStatus.getSelectedIndex() > 0) {
            CheckedStatusEnum auditStatus = (CheckedStatusEnum)this.cmbxAuditStatus.getSelectedItem();
            FilterItemInfo item2 = new FilterItemInfo("CheckedStatus", (Object)new Integer(auditStatus.getValue()));
            this.filterInfo.getFilterItems().add(item2);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)this.txtCreator.getText())) {
            item = new FilterItemInfo("creator.name", (Object)("%" + this.txtCreator.getText() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(item);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)this.txtAuditor.getText())) {
            item = new FilterItemInfo("auditor.name", (Object)("%" + this.txtAuditor.getText() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(item);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboElimMode.getSelectedItem() != null && !this.comboElimMode.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterModeInfo = new FilterItemInfo("eliminationMode.id", (Object)((EliminationModeInfo)this.comboElimMode.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterModeInfo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)(customNumber = this.txtCustomNumber.getText().trim()))) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("customNumber", (Object)("%" + customNumber + "%"), CompareType.LIKE));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)(summary = this.txtSummary.getText().trim()))) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("entries.summary", (Object)("%" + summary + "%"), CompareType.LIKE));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.invCompanyF7.getData() != null) {
            orgId = ((OrgUnitInfo)this.invCompanyF7.getData()).getId().toString();
            filterItemTo = new FilterItemInfo("invCompany.id", (Object)orgId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.targetCompanyF7.getData() != null) {
            orgId = ((OrgUnitInfo)this.targetCompanyF7.getData()).getId().toString();
            filterItemTo = new FilterItemInfo("targetCompany.id", (Object)orgId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.companyF7.getData() != null) {
            orgId = ((OrgUnitInfo)this.companyF7.getData()).getId().toString();
            filterItemTo = new FilterItemInfo("company.id", (Object)orgId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.templateF7.getData() != null) {
            Object tempData = this.templateF7.getData();
            HashSet<String> tmplIds = new HashSet<String>();
            if (tempData instanceof Object[]) {
                Object[] tempVals;
                for (Object tempInfo : tempVals = (Object[])tempData) {
                    if (tempInfo == null) continue;
                    tmplIds.add(((InvestTempletInfo)tempInfo).getId().toString());
                }
            }
            if (tmplIds.size() > 0) {
                FilterItemInfo filterItemTo3 = new FilterItemInfo("allElimTemplate.id", tmplIds, CompareType.INCLUDE);
                this.filterInfo.getFilterItems().add(filterItemTo3);
                sbFormula.append(" and #" + formulaIndex++);
            }
        }
        if (this.kdElimDataSource.getSelectedIndex() > 0) {
            ElimDataSourceEnum item3 = (ElimDataSourceEnum)((Object)this.kdElimDataSource.getSelectedItem());
            filterItemTo = new FilterItemInfo("elimDataSource", (Object)new Integer(item3.getValue()));
            this.filterInfo.getFilterItems().add(filterItemTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void clearUI() {
        this.cbxCurrency.setSelectedItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll);
        if (this.whichOpen.equals("Hand")) {
            this.cbxElimType.setSelectedItem((Object)ElimTypeEnum.General);
            this.cbxElimType.setEnabled(false);
            this.bizDataElement.setValue(null);
            this.bizDataElement.setEnabled(true);
        } else if (this.whichOpen.equals("Auto")) {
            this.cbxElimType.setSelectedItem((Object)this.selectAll);
            this.cbxElimType.setEnabled(true);
            this.bizDataElement.setValue(null);
            this.bizDataElement.setEnabled(true);
        } else if (this.whichOpen.equals("All")) {
            this.cbxElimType.setSelectedItem((Object)this.selectAll);
            this.cbxElimType.setEnabled(true);
            this.bizDataElement.setValue(null);
            this.bizDataElement.setEnabled(true);
        }
        this.bizPrmtItemFrom.setData(null);
        this.bizPrmtItemTo.setData(null);
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.txtDebitFrom.setValue(null);
        this.txtDebitTo.setValue(null);
        this.txtCreditFrom.setValue(null);
        this.txtCreditTo.setValue(null);
        this.cmbxAuditStatus.setSelectedIndex(0);
        this.txtCreator.setText(null);
        this.txtAuditor.setText(null);
        if (this.cbxOrgBound.getItemCount() != 0) {
            boolean isSelected = false;
            if (this.fiterParam != null) {
                OrgTreeInfo info = (OrgTreeInfo)this.fiterParam.get("orgBound");
                OrgTreeInfo tmpInfo = null;
                if (info != null) {
                    for (int i = 0; i < this.cbxOrgBound.getItemCount(); ++i) {
                        tmpInfo = (OrgTreeInfo)this.cbxOrgBound.getItemAt(i);
                        if (tmpInfo == null || !tmpInfo.getNumber().equals(info.getNumber())) continue;
                        this.cbxOrgBound.setSelectedIndex(i);
                        isSelected = true;
                        break;
                    }
                }
            }
            if (!isSelected) {
                this.cbxOrgBound.setSelectedIndex(0);
            }
        }
        this.periodTypeCombo.setSelectedItem(null);
        this.periodTypeCombo.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.comboElimMode.setSelectedItem((Object)this.selectAll);
        this.txtCustomNumber.setText(null);
        this.txtSummary.setText(null);
        this.invCompanyF7.setData(null);
        this.targetCompanyF7.setData(null);
        this.companyF7.setData(null);
        this.templateF7.setData(null);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        block13: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            OrgUnitInfo org;
            ObjectUuidPK pk;
            String orgId;
            CurrencyInfo currencyInfo;
            String currencyId;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("elimType")) {
                this.cbxElimType.setSelectedItem((Object)ElimTypeEnum.getEnum(Integer.parseInt(filterItemInfo.getCompareValue().toString())));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.dataElement")) {
                try {
                    this.iDataElement = DataElementFactory.getRemoteInstance();
                    this.bizDataElement.setValue((Object)this.iDataElement.getDataElementByInterSeq((Integer)filterItemInfo.getCompareValue()));
                }
                catch (EASBizException e) {
                    logger.error((Object)"getDataElementByInterSeq_EASBizException", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"getDataElementByInterSeq_BOSException", (Throwable)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxCurrency.setSelectedIndex(j);
                    continue block13;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("sourceCurrency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxSourceCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxSourceCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxSourceCurrency.setSelectedIndex(j);
                    continue block13;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("item.number")) {
                String itemNumber = (String)filterItemInfo.getCompareValue();
                try {
                    RPTItemInfo rptItemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo("select number, name where number = '" + itemNumber + "'");
                    if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                        this.bizPrmtItemFrom.setData((Object)rptItemInfo);
                        continue;
                    }
                    this.bizPrmtItemTo.setData((Object)rptItemInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtNumberFrom.setText(number);
                    continue;
                }
                this.txtNumberTo.setText(number);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.debit")) {
                BigDecimal debit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtDebitFrom.setValue((Object)debit);
                    continue;
                }
                this.txtDebitTo.setValue((Object)debit);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.credit")) {
                BigDecimal credit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtCreditFrom.setValue((Object)credit);
                    continue;
                }
                this.txtCreditTo.setValue((Object)credit);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("CheckedStatus")) {
                Integer auditStatus = (Integer)filterItemInfo.getCompareValue();
                if (auditStatus == 1) {
                    this.cmbxAuditStatus.setSelectedIndex(1);
                    continue;
                }
                this.cmbxAuditStatus.setSelectedIndex(2);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("creator.name")) {
                String creator = (String)filterItemInfo.getCompareValue();
                this.txtCreator.setText(creator.replaceAll("%", ""));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("auditor.name")) {
                String auditor = (String)filterItemInfo.getCompareValue();
                this.txtAuditor.setText(auditor.replaceAll("%", ""));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgBound.number")) {
                String treeNumber = (String)filterItemInfo.getCompareValue();
                for (int j = 0; j < this.cbxOrgBound.getItemCount(); ++j) {
                    OrgTreeInfo treeInfo = (OrgTreeInfo)this.cbxOrgBound.getItemAt(j);
                    if (!treeInfo.getNumber().toString().equals(treeNumber)) continue;
                    this.cbxOrgBound.setSelectedItem((Object)treeInfo);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                RptPeriodTypeEnum periodType = RptPeriodTypeEnum.getEnum((int)Integer.parseInt(filterItemInfo.getCompareValue().toString()));
                if (periodType == null) continue;
                this.periodTypeCombo.setSelectedItem((Object)periodType);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                if (CompareType.GREATER.equals((Object)filterItemInfo.getCompareType())) {
                    Integer startYear = new Integer(filterItemInfo.getCompareValue().toString());
                    this.startYearSpin.setValue((Object)startYear);
                    continue;
                }
                if (!CompareType.LESS.equals((Object)filterItemInfo.getCompareType())) continue;
                Integer endYear = new Integer(filterItemInfo.getCompareValue().toString());
                this.endYearSpin.setValue((Object)endYear);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    Integer startPeriod = new Integer(filterItemInfo.getCompareValue().toString());
                    this.startPeriodSpin.setValue((Object)startPeriod);
                    continue;
                }
                Integer endPeriod = new Integer(filterItemInfo.getCompareValue().toString());
                this.endPeriodSpin.setValue((Object)endPeriod);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("eliminationMode.id")) {
                String eliminationModeId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.comboElimMode.getItemCount(); ++j) {
                    EliminationModeInfo elimMode = (EliminationModeInfo)this.comboElimMode.getItemAt(j);
                    if (!eliminationModeId.equals(elimMode.getId().toString())) continue;
                    this.comboElimMode.setSelectedIndex(j);
                    continue block13;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("customNumber")) {
                String customNumber = filterItemInfo.getCompareValue().toString();
                this.txtCustomNumber.setText(customNumber.replaceAll("%", ""));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.summary")) {
                String summary = filterItemInfo.getCompareValue().toString();
                this.txtSummary.setText(summary.replaceAll("%", ""));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("invCompany.id")) {
                orgId = filterItemInfo.getCompareValue().toString();
                BOSUuid uuid = BOSUuid.read((String)orgId);
                pk = new ObjectUuidPK(uuid);
                try {
                    org = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)pk);
                    this.invCompanyF7.setData((Object)org);
                }
                catch (Exception e) {
                    logger.error((Object)"get org error ", (Throwable)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("targetCompany.id")) {
                orgId = filterItemInfo.getCompareValue().toString();
                BOSUuid uuid = BOSUuid.read((String)orgId);
                pk = new ObjectUuidPK(uuid);
                try {
                    org = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)pk);
                    this.targetCompanyF7.setData((Object)org);
                }
                catch (Exception e) {
                    logger.error((Object)"get org error ", (Throwable)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("company.id")) {
                orgId = filterItemInfo.getCompareValue().toString();
                BOSUuid uuid = BOSUuid.read((String)orgId);
                pk = new ObjectUuidPK(uuid);
                try {
                    org = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)pk);
                    this.companyF7.setData((Object)org);
                }
                catch (Exception e) {
                    logger.error((Object)"get org error ", (Throwable)e);
                }
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("allElimTemplate.id")) continue;
            String templateId = filterItemInfo.getCompareValue().toString();
            BOSUuid uuid = BOSUuid.read((String)templateId);
            pk = new ObjectUuidPK(uuid);
            try {
                InvestTempletInfo template = InvestTempletFactory.getRemoteInstance().getInvestTempletInfo((IObjectPK)pk);
                this.templateF7.setData((Object)template);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"get org error ", (Throwable)e);
            }
        }
    }

    public boolean isMergeByFiscalPeriod() {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
        if (p == null) {
            p = RptPeriodTypeEnum.MONTHLY;
        }
        return this.isMergeByFiscalPeriod && !p.equals((Object)RptPeriodTypeEnum.DAILY) && !p.equals((Object)RptPeriodTypeEnum.WEEKLY);
    }
}

