/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractExchAfterElimSumFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import org.apache.log4j.Logger;

public class ExchAfterElimSumFilterUI
extends AbstractExchAfterElimSumFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ExchAfterElimSumFilterUI.class);
    private ICurrency iCurrency = null;
    private CurrencyInfo bsCurrency = CslClientHelper.getCUNaturalCurrency();

    public ExchAfterElimSumFilterUI() throws Exception {
        this.initComponent();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initComponent() throws Exception {
        if (this.iCurrency == null) {
            this.iCurrency = CurrencyFactory.getRemoteInstance();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        CurrencyCollection currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        if (currencyCollection != null && currencyCollection.size() > 0) {
            this.cmbCurrency.addItems(currencyCollection.toArray());
        }
        CslClientHelper.initDataElementCombox(this.cmbDataElement, false, false, false);
        this.clear();
    }

    @Override
    public RptProperties getCustomCondition() {
        try {
            this.loadInitData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.cmbCurrency.getSelectedIndex() >= 0) {
            CurrencyInfo currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
            this.pp.setString("currencyId", currency.getId().toString());
            this.pp.setString("currencyName", currency.getName());
        }
        if (this.cmbDataElement.getSelectedIndex() >= 0) {
            DataElementInfo dataElement = (DataElementInfo)this.cmbDataElement.getSelectedItem();
            this.pp.setString("dataElement", String.valueOf(dataElement.getInterSeq()));
            this.pp.setString("dataElementName", dataElement.getName());
        }
        return this.pp;
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptProperties();
        }
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        int j;
        String currencyId;
        this.pp = ac;
        if (this.pp.containsKey("currencyId") && (currencyId = this.pp.getString("currencyId")) != null) {
            for (j = 0; j < this.cmbCurrency.getItemCount(); ++j) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                this.cmbCurrency.setSelectedIndex(j);
                break;
            }
        }
        if (this.pp.containsKey("dataElement")) {
            String dataElement = this.pp.getString("dataElement");
            for (j = 0; j < this.cmbDataElement.getItemCount(); ++j) {
                DataElementInfo dataElementInfo = (DataElementInfo)this.cmbDataElement.getItemAt(j);
                if (!String.valueOf(dataElementInfo.getInterSeq()).equals(dataElement)) continue;
                this.cmbDataElement.setSelectedIndex(j);
                break;
            }
        }
    }

    public void clear() {
        super.clear();
        for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
            CurrencyInfo info;
            if (!(this.cmbCurrency.getItemAt(i) instanceof CurrencyInfo) || !(info = (CurrencyInfo)this.cmbCurrency.getItemAt(i)).getId().toString().equals(this.bsCurrency.getId().toString())) continue;
            this.cmbCurrency.setSelectedIndex(i);
            break;
        }
        for (int j = 0; j < this.cmbDataElement.getItemCount(); ++j) {
            DataElementInfo dataElementInfo = (DataElementInfo)this.cmbDataElement.getItemAt(j);
            if (dataElementInfo.getInterSeq() != 3) continue;
            this.cmbDataElement.setSelectedIndex(j);
            break;
        }
    }
}

