/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCompanyCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCompanyInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextFactory;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextTemplateCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextTemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogFactory;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SaveFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx.QueryPermissionCompany;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CheckValidException;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractFormulaCalcContextEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.TableSelectedDataBinder;
import com.kingdee.eas.fi.gr.weaverpt.client.ChooseTemplate;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FormulaCalcContextEditUI
extends AbstractFormulaCalcContextEditUI {
    private static final long serialVersionUID = -2971412262200410404L;
    private static final Logger logger = CoreUIObject.getLogger(FormulaCalcContextEditUI.class);
    private SaveFormulaCalcContext saveAction;
    private MessageHandler messageHandler;
    private ControlInit controlInit = new ControlInit();
    public static boolean fromLoadField = false;

    public FormulaCalcContextEditUI() throws Exception {
        this.saveAction = new SaveFormulaCalcContext(new DBHandler(null));
        this.kdtTemplates.checkParsed(false);
        this.kdtCompanys.checkParsed(false);
        this.kdtTemplates.getStyleAttributes().setLocked(true);
        this.kdtCompanys.getStyleAttributes().setLocked(true);
        this.kdtTemplates.getSelectManager().setSelectMode(10);
        this.kdtCompanys.getSelectManager().setSelectMode(10);
        this.cbxOrgType.removeAllItems();
        this.cbxOrgType.addItems((Object[])new OrgType[]{OrgType.Company, OrgType.ProfitCenter});
        this.cbxOrgType.setSelectedIndex(0, false);
        this.initCtrlListener();
    }

    protected void initCtrlListener() {
        final KDTableMoveAction rowMoveAction = new KDTableMoveAction(this.kdtTemplates);
        this.comboReportPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormulaCalcContextEditUI.this.kdtTemplates.removeRows();
            }
        });
        this.cbxOrgType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormulaCalcContextEditUI.this.kdtCompanys.removeRows();
                FormulaCalcContextEditUI.this.kdtTemplates.removeRows();
            }
        });
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToHead();
            }
        });
        this.btnMoveBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToTail();
            }
        });
        this.btnAddTpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FormulaCalcContextEditUI.this.getTmplF7();
                }
                catch (BOSException e1) {
                    logger.error((Object)"AddTplError: ", (Throwable)e1);
                }
            }
        });
        this.btnDelTpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)FormulaCalcContextEditUI.this.kdtTemplates);
                FormulaCalcContextTemplateCollection entrys = (FormulaCalcContextTemplateCollection)((Object)FormulaCalcContextEditUI.this.kdtTemplates.getUserObject());
                HashSet rowIdSet = (HashSet)FormulaCalcContextEditUI.this.kdtTemplates.getClientProperty((Object)"ROW_ID_SET");
                if (rowIdSet == null) {
                    rowIdSet = new HashSet();
                    FormulaCalcContextEditUI.this.kdtTemplates.putClientProperty((Object)"ROW_ID_SET", rowIdSet);
                }
                FormulaCalcContextTemplateInfo entryInfo = null;
                int rowIndex = 0;
                for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
                    rowIndex = selectRowIndexes[i];
                    entryInfo = (FormulaCalcContextTemplateInfo)FormulaCalcContextEditUI.this.kdtTemplates.getRow(rowIndex).getUserObject();
                    rowIdSet.remove(entryInfo.getTemplate().getId().toString());
                    entrys.removeObject((IObjectValue)entryInfo);
                    FormulaCalcContextEditUI.this.kdtTemplates.removeRow(rowIndex);
                }
            }
        });
        this.btnChooseCompany.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FormulaCalcContextEditUI.this.getCompanyF7();
                }
                catch (Exception e1) {
                    logger.error((Object)"AddCompanyError: ", (Throwable)e1);
                }
            }
        });
        this.btnDelCompany.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)FormulaCalcContextEditUI.this.kdtCompanys);
                FormulaCalcContextCompanyCollection entrys = (FormulaCalcContextCompanyCollection)((Object)FormulaCalcContextEditUI.this.kdtCompanys.getUserObject());
                HashSet rowIdSet = (HashSet)FormulaCalcContextEditUI.this.kdtCompanys.getClientProperty((Object)"ROW_ID_SET");
                if (rowIdSet == null) {
                    rowIdSet = new HashSet();
                    FormulaCalcContextEditUI.this.kdtCompanys.putClientProperty((Object)"ROW_ID_SET", rowIdSet);
                }
                FormulaCalcContextCompanyInfo entryInfo = null;
                int rowIndex = 0;
                for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
                    rowIndex = selectRowIndexes[i];
                    entryInfo = (FormulaCalcContextCompanyInfo)FormulaCalcContextEditUI.this.kdtCompanys.getRow(rowIndex).getUserObject();
                    rowIdSet.remove(entryInfo.getCompany().getId().toString());
                    entrys.removeObject((IObjectValue)entryInfo);
                    FormulaCalcContextEditUI.this.kdtCompanys.removeRow(rowIndex);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setBtnStyle();
        this.initWidget();
    }

    private void setBtnStyle() {
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnChooseCompany.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelCompany.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddTpl.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelTpl.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void initWidget() throws Exception {
        String selectId;
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.editData != null && this.editData.getId() != null && (selectId = this.editData.getId().toString()) != null) {
            FormulaCalcContextInfo soluInfo = this.getFormulaCalcContextInfo(selectId);
            this.initWidgetByCreator(userId, soluInfo);
            this.initWidgetByExistLogs(soluInfo);
        }
    }

    private void initWidgetByExistLogs(FormulaCalcContextInfo soluInfo) throws BOSException, EASBizException {
        IFormulaCalcLog formulaCalcLogDao = FormulaCalcLogFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("context", (Object)soluInfo.getId()));
        if (formulaCalcLogDao.exists(filter)) {
            this.txtNumber.enable(false);
            this.txtName.enable(false);
            this.txtName.setEnabled(false);
            this.cbxOrgType.enable(false);
            this.comboReportPeriod.enable(false);
        }
    }

    private void initWidgetByCreator(String userId, FormulaCalcContextInfo soluInfo) {
        String creatorId = soluInfo.getCreator().getId().toString();
        if (!userId.equals(creatorId)) {
            this.btnEdit.setEnabled(false);
        }
    }

    private FormulaCalcContextInfo getFormulaCalcContextInfo(String selectId) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("creator.id");
        FormulaCalcContextInfo soluInfo = FormulaCalcContextFactory.getRemoteInstance().getFormulaCalcContextInfo((IObjectPK)new ObjectUuidPK(selectId), selectors);
        return soluInfo;
    }

    @Override
    public void loadFields() {
        fromLoadField = true;
        super.loadFields();
        fromLoadField = false;
        this.controlInit.defineConvertion();
        try {
            RptPeriodTypeEnum periodType = this.editData.getPeriodType() != null ? this.editData.getPeriodType() : RptPeriodTypeEnum.MONTHLY;
            OrgType orgType = this.editData.getOrgType() != null ? this.editData.getOrgType() : OrgType.Company;
            this.controlInit.init(periodType, orgType);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setOrgType((OrgType)this.cbxOrgType.getSelectedItem());
    }

    protected void setTempEntryOrder() {
        FormulaCalcContextTemplateCollection tpls = (FormulaCalcContextTemplateCollection)((Object)this.kdtTemplates.getUserObject());
        tpls.clear();
        IRow row = null;
        FormulaCalcContextTemplateInfo tpl = null;
        int rowCount = this.kdtTemplates.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtTemplates.getRow(i);
            if (!(row.getUserObject() instanceof FormulaCalcContextTemplateInfo)) continue;
            tpl = (FormulaCalcContextTemplateInfo)row.getUserObject();
            tpl.setOrderIndex(i);
            tpls.add(tpl);
            this.editData.getTemplates().add(tpl);
        }
    }

    protected void setCompEntryOrder() {
        FormulaCalcContextCompanyCollection compEntry = (FormulaCalcContextCompanyCollection)((Object)this.kdtCompanys.getUserObject());
        compEntry.clear();
        FormulaCalcContextCompanyInfo compInfo = null;
        for (int i = 0; i < this.kdtCompanys.getRowCount(); ++i) {
            IRow row = this.kdtCompanys.getRow(i);
            if (!(row.getUserObject() instanceof FormulaCalcContextCompanyInfo)) continue;
            compInfo = (FormulaCalcContextCompanyInfo)row.getUserObject();
            compEntry.add(compInfo);
            this.editData.getCompanys().add(compInfo);
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.setCompEntryOrder();
        this.setTempEntryOrder();
        String[] templateIds = new String[this.editData.getTemplates().size()];
        int size = this.editData.getTemplates().size();
        for (int i = 0; i < size; ++i) {
            templateIds[i] = this.editData.getTemplates().get(i).getTemplate().getId().toString();
        }
        ArrayList<OrgUnitInfo> companys = new ArrayList<OrgUnitInfo>(this.editData.getCompanys().size());
        int size2 = this.editData.getCompanys().size();
        for (int i = 0; i < size2; ++i) {
            companys.add((OrgUnitInfo)this.editData.getCompanys().get(i).getCompany());
        }
        FormulaCalcContextInfo info = null;
        try {
            new QueryPermissionCompany(new DBHandler(null)).check(SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.editData.getOrgType(), companys);
            info = this.saveAction.exec(this.editData, this.editData.getId() == null ? null : this.editData.getId().toString(), this.editData.getNumber(), this.editData.getName(), this.editData.getOffYear(), this.editData.getOffPeriod(), this.editData.getPeriodType(), templateIds, companys, this.editData.getCurrentOrg().getId().toString(), this.editData.getDescription(), this.editData.isIsDoCheckAfterCalc(), this.editData.getOrgType());
        }
        catch (CheckValidException e) {
            this.getMessageHandler().show(e.toMessage());
            SysUtil.abort();
        }
        this.editData = info;
        return new ObjectUuidPK(info.getId());
    }

    protected IObjectValue createNewData() {
        FormulaCalcContextInfo calcCtx = new FormulaCalcContextInfo();
        calcCtx.setCurrentOrg(SysContext.getSysContext().getCurrentFIUnit().castToFullOrgUnitInfo());
        return calcCtx;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FormulaCalcContextFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add("templates.id");
        selectors.add("templates.template.id");
        selectors.add("templates.template.number");
        selectors.add("templates.template.name");
        selectors.add("templates.template.periodType");
        selectors.add("templates.template.templateType");
        selectors.add("templates.orderIndex");
        selectors.add("companys.id");
        selectors.add("companys.company.id");
        selectors.add("companys.company.number");
        selectors.add("companys.company.name");
        selectors.add("currentOrg.id");
        selectors.add("currentOrg.number");
        selectors.add("currentOrg.name");
        return selectors;
    }

    public MessageHandler getMessageHandler() {
        if (this.messageHandler == null) {
            this.messageHandler = new MessageHandler(1);
        }
        return this.messageHandler;
    }

    public boolean destroyWindow() {
        if (this.getUIContext().get("ObjectUpdateLockId") != null) {
            MutexUtil.releaseMutex(Uuid.fromString((String)((String)this.getUIContext().get("ObjectUpdateLockId"))));
        }
        return super.destroyWindow();
    }

    protected void getTmplF7() throws BOSException {
        StringBuffer orgStr = new StringBuffer();
        for (int i = 0; i < this.kdtCompanys.getRowCount(); ++i) {
            if (i > 0) {
                orgStr.append(",");
            }
            orgStr.append("'").append(this.kdtCompanys.getRow(i).getCell("company.id").getValue()).append("'");
        }
        if (orgStr.length() <= 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"868_selectOrg"));
            return;
        }
        List tpls = new ChooseTemplate().open((Component)((Object)this), true, this.getChooseTemplateEntityView(orgStr.toString()), this.btnAddTpl.getText(), this.getChooseTemplateFilterProceccor(), this.getChooseTemplateHiddenColumnSetting());
        this.addTemplates(tpls);
    }

    protected EntityViewInfo getChooseTemplateEntityView(String orgIds) {
        FilterInfo filter = new FilterInfo();
        StringBuffer debars = new StringBuffer();
        debars.append(6).append(",");
        debars.append(10);
        StringBuffer maskString = new StringBuffer();
        int maskIndex = 0;
        filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)debars.toString(), CompareType.INNER));
        maskString.append(" #" + maskIndex++);
        filter.getFilterItems().add(new FilterItemInfo("isfreezed", (Object)new Integer(0), CompareType.EQUALS));
        maskString.append(" and #" + maskIndex++);
        int periodTypeValue = ((RptPeriodTypeEnum)this.comboReportPeriod.getSelectedItem()).getValue();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(periodTypeValue), CompareType.EQUALS));
        maskString.append(" and #" + maskIndex++);
        int orgTypeValue = ((OrgType)this.cbxOrgType.getSelectedItem()).getValue();
        filter.getFilterItems().add(new FilterItemInfo("orgType", (Object)new Integer(orgTypeValue), CompareType.EQUALS));
        maskString.append(" and #" + maskIndex++);
        filter.setMaskString(maskString.toString());
        try {
            String existTemplateIds = this.getExistTemplateIds();
            StringBuffer sqlIn = new StringBuffer();
            sqlIn.append(" id in(select distinct curTemp.fid from t_rpt_template curTemp inner join(");
            sqlIn.append(" select max(temp.FAUDITEDTIME) FAUDITEDTIME,temp.fgroup fgroup from t_csl_templetdispense dis ");
            sqlIn.append(" inner join t_rpt_template temp on temp.fid=dis.fdispensesrcid ");
            sqlIn.append(" where dis.fcompanyid in(").append(orgIds).append(")");
            sqlIn.append(" group by temp.fgroup) disTemp on disTemp.FAUDITEDTIME=curTemp.Fauditedtime and disTemp.fgroup=curTemp.fgroup ");
            if (!StringUtils.isEmpty((String)existTemplateIds)) {
                sqlIn.append(" left join t_rpt_template existTemp on existTemp.fgroup=curTemp.fgroup and existTemp.fid in(").append(existTemplateIds).append(")");
                sqlIn.append(" where existTemp.fid is null ");
            }
            sqlIn.append(" )");
            filter.mergeFilter(new FilterInfo(sqlIn.toString()), "and");
        }
        catch (Exception ex) {
            logger.error((Object)"getChooseTemplateEntityView error.", (Throwable)ex);
            this.handUIException(ex);
            this.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("number0");
        selector.add("templateType");
        selector.add("periodType");
        selector.add("orgType");
        view.setSelector(selector);
        logger.debug((Object)("[Weave]view:" + view));
        return view;
    }

    public String getExistTemplateIds() {
        StringBuffer templateIds = new StringBuffer();
        for (int i = 0; i < this.kdtTemplates.getRowCount(); ++i) {
            if (i > 0) {
                templateIds.append(",");
            }
            templateIds.append("'").append(this.kdtTemplates.getRow(i).getCell("template.id").getValue()).append("'");
        }
        return templateIds.toString();
    }

    protected IProcessor getChooseTemplateFilterProceccor() {
        return new CommonQueryProcessor(){

            public void process() throws Exception {
            }
        };
    }

    protected Map getChooseTemplateHiddenColumnSetting() {
        HashMap<String, Boolean> hiddenColumns = new HashMap<String, Boolean>();
        hiddenColumns.put("sumType", Boolean.TRUE);
        hiddenColumns.put("auditedStatus", Boolean.TRUE);
        hiddenColumns.put("isK3Tpl", Boolean.TRUE);
        return hiddenColumns;
    }

    protected void addTemplates(List<TemplateInfo> templates) throws BOSException {
        int i;
        if (templates.isEmpty()) {
            return;
        }
        TemplateInfo tmpl = null;
        FormulaCalcContextTemplateInfo tmplEntry = null;
        IRow row = null;
        HashSet<String> rowIdSet = new HashSet<String>();
        FormulaCalcContextTemplateCollection entrys = (FormulaCalcContextTemplateCollection)((Object)this.kdtTemplates.getUserObject());
        for (i = 0; entrys != null && i < entrys.size(); ++i) {
            rowIdSet.add(entrys.get(i).getTemplate().getId().toString());
        }
        for (i = 0; i < templates.size(); ++i) {
            tmpl = templates.get(i);
            tmplEntry = new FormulaCalcContextTemplateInfo();
            tmplEntry.setTemplate(tmpl);
            if (rowIdSet.contains(tmpl.getId().toString())) continue;
            row = this.kdtTemplates.addRow();
            row.setUserObject((Object)tmplEntry);
            BindingUtility.loadDataToTableLine((int)row.getRowIndex(), (IObjectValue)tmplEntry, (KDTable)this.kdtTemplates, null, (DataComponentMap)this.getDataBinder().getDataComponentMap());
            rowIdSet.add(tmpl.getId().toString());
            entrys = (FormulaCalcContextTemplateCollection)((Object)this.kdtTemplates.getUserObject());
            entrys.add(tmplEntry);
        }
    }

    private void getCompanyF7() throws EASBizException, BOSException {
        OrgTreeCollection orgTreeColl = CslRptUIUtil.getOrgTreeCollection();
        int orgTypeValue = ((OrgType)this.cbxOrgType.getSelectedItem()).getValue();
        if (orgTreeColl != null) {
            Object selectDatas;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < orgTreeColl.size(); ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(orgTreeColl.get(i).getId().toString()).append("'");
            }
            sb.insert(0, "select id,startDate,endDate,name,number where id in(").append(") and startDate!= null and status=1 and isForBudget<>1 ");
            sb.append(" and (isHide<>1 or isHide is null ) and layerType=").append(orgTypeValue).append(" order by number,startDate asc ");
            orgTreeColl = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(sb.toString());
            UnionF7Helper.UnionF7 unitF7 = new UnionF7Helper.UnionF7((IUIObject)this, 1, true);
            OrgViewType[] orgViewType = null;
            orgViewType = orgTypeValue == 1 ? (orgTreeColl != null && !orgTreeColl.isEmpty() ? new OrgViewType[]{OrgViewType.UNIONDEBT, OrgViewType.COMPANY} : new OrgViewType[]{OrgViewType.COMPANY}) : (orgTreeColl != null && !orgTreeColl.isEmpty() ? new OrgViewType[]{OrgViewType.UNIONDEBT, OrgViewType.PROFITCENTER} : new OrgViewType[]{OrgViewType.PROFITCENTER});
            unitF7.setOrgViewType(orgViewType);
            unitF7.setOrgTrees(orgTreeColl);
            unitF7.setRptAnalysis(true);
            unitF7.setMultiSelect(true);
            unitF7.setPermissionItem(null);
            FilterInfo outerFilterInfo = new FilterInfo();
            if (1 == orgTypeValue) {
                outerFilterInfo.getFilterItems().add(new FilterItemInfo("unit.partFI.isBizUnit", (Object)1));
            } else {
                outerFilterInfo.getFilterItems().add(new FilterItemInfo("unit.partProfitCenter.isBizUnit", (Object)1));
            }
            unitF7.setOuterFilterInfo(outerFilterInfo);
            unitF7.show();
            if (!unitF7.isCanceled() && (selectDatas = unitF7.getData()) != null) {
                FormulaCalcContextCompanyInfo compEntry = null;
                FullOrgUnitInfo org = null;
                Object[] orgs = (Object[])selectDatas;
                HashSet<String> existsIds = new HashSet<String>();
                if (orgs.length > 0) {
                    for (int i = 0; i < this.kdtCompanys.getRowCount(); ++i) {
                        compEntry = (FormulaCalcContextCompanyInfo)this.kdtCompanys.getRow(i).getUserObject();
                        existsIds.add(compEntry.getCompany().getId().toString());
                    }
                    IRow row = null;
                    for (int i = 0; i < orgs.length; ++i) {
                        if (orgs[i] instanceof FullOrgUnitInfo) {
                            org = (FullOrgUnitInfo)orgs[i];
                        } else if (orgs[i] instanceof CompanyOrgUnitInfo) {
                            org = ((CompanyOrgUnitInfo)orgs[i]).castToFullOrgUnitInfo();
                        } else {
                            if (!(orgs[i] instanceof ProfitCenterOrgUnitInfo)) continue;
                            org = ((ProfitCenterOrgUnitInfo)orgs[i]).castToFullOrgUnitInfo();
                        }
                        if (existsIds.contains(org.getId().toString())) continue;
                        compEntry = new FormulaCalcContextCompanyInfo();
                        compEntry.setCompany(org);
                        row = this.kdtCompanys.addRow();
                        row.setUserObject((Object)compEntry);
                        BindingUtility.loadDataToTableLine((int)row.getRowIndex(), (IObjectValue)compEntry, (KDTable)this.kdtCompanys, null, (DataComponentMap)this.getDataBinder().getDataComponentMap());
                    }
                    existsIds.clear();
                }
            }
        }
    }

    protected class ControlInit {
        protected DBHandler dao = new DBHandler(null);

        protected ControlInit() {
        }

        private void init(RptPeriodTypeEnum periodType, OrgType orgType) throws BOSException {
            this.initOrgType(FormulaCalcContextEditUI.this.cbxOrgType);
            FormulaCalcContextEditUI.this.cbxOrgType.setSelectedItem((Object)orgType, false);
            FormulaCalcContextEditUI.this.comboReportPeriod.setSelectedItem((Object)periodType, false);
        }

        private void initOrgType(KDComboBox cbxOrgType) {
        }

        private void defineConvertion() {
            FormulaCalcContextEditUI.this.dataBinder.registerBinding("clientTemplates", IObjectCollection.class, (Component)new TableSelectedDataBinder(FormulaCalcContextEditUI.this.kdtTemplates), "tableData");
            FormulaCalcContextEditUI.this.dataBinder.registerBinding("clientCompanys", IObjectCollection.class, (Component)new TableSelectedDataBinder(FormulaCalcContextEditUI.this.kdtCompanys), "tableData");
        }
    }
}

