/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextFactory;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.SingleDataUpdateWayEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractFormulaCalcExecDispatchUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.util.IDispatchPeriodSource;
import com.kingdee.eas.fi.gr.cslrpt.client.util.SaveJobProcessDef;
import com.kingdee.eas.fi.gr.cslrpt.client.util.ShowDispatchPeriodSettingUI;
import com.kingdee.eas.fi.gr.cslrpt.client.util.TimeDispatchSourceForAutoItem;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.weaverpt.FormatJobProcessSettingAction;
import com.kingdee.eas.fi.rpt.RptCalcSchemeFactory;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class FormulaCalcExecDispatchUI
extends AbstractFormulaCalcExecDispatchUI {
    private static final Logger logger = CoreUIObject.getLogger(FormulaCalcExecDispatchUI.class);
    IDispatchPeriodSource source = null;
    BOSUuid oldJobProcess = null;
    FormulaCalcContextInfo currentInfo = null;
    boolean choose = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.checkHasFormulaCalEntity();
        this.initialCombox();
        this.initPeriodDispatch();
        this.initPeriodWidget();
    }

    private void initPeriodWidget() {
        this.initSpCurPeriodScope();
        this.initPeriodOffset();
        this.initDataUpdateWay();
    }

    private void initDataUpdateWay() {
        Iterator itor = SingleDataUpdateWayEnum.iterator();
        SingleDataUpdateWayEnum curItem = null;
        while (itor.hasNext()) {
            curItem = (SingleDataUpdateWayEnum)((Object)itor.next());
            this.dataUpdateWay.addItem((Object)curItem);
        }
        this.dataUpdateWay.setSelectedItem((Object)this.currentInfo.getDataUpdateType());
    }

    private void initSpCurPeriodScope() {
        CslRptUIUtil.setSpineRange(this.kspPeriodOffset, -13, 0);
    }

    private void initPeriodOffset() {
        this.kspPeriodOffset.setValue((Object)this.currentInfo.getOffPeriod());
    }

    private void initPeriodDispatch() throws Exception {
        if (this.currentInfo.getDispatchPeriod() != null) {
            this.txtTimeDef.setText(this.currentInfo.getDispatchPeriod().toString());
            this.txtTimeDesc.setSelectedItemData((Object)this.getTextByDispatchPeriodId(this.currentInfo.getDispatchPeriod().toString()));
        }
    }

    private void checkHasFormulaCalEntity() {
        if (this.getUIContext().containsKey("currentInfo")) {
            this.currentInfo = (FormulaCalcContextInfo)this.getUIContext().get("currentInfo");
        } else {
            this.disposeUIWindow();
        }
    }

    private void initialCombox() {
        FormulaCalcExecDispatchUI formulaCalcExecDispatchUI = this;
        for (Object obj : formulaCalcExecDispatchUI.txtTimeDesc.getLanguageList()) {
            if (!(obj instanceof LanguageInfo) || !((LanguageInfo)obj).getLocale().getLanguage().equals(SysContext.getSysContext().getLocale().getLanguage())) continue;
            this.txtTimeDesc.setSelectedLanguage((LanguageInfo)obj);
            break;
        }
        if (this.currentInfo.getDispatchCurrency() != null) {
            if (this.currentInfo.getDispatchCurrency().getId() != null) {
                CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, this.currentInfo.getDispatchCurrency().getId().toString(), false);
            }
        } else {
            CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, true, false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnTimeDefine_actionPerformed(ActionEvent e) throws Exception {
        super.btnTimeDefine_actionPerformed(e);
        this.oldJobProcess = this.currentInfo.getDispatchPeriod();
        this.source = new TimeDispatchSourceForAutoItem(this.currentInfo);
        boolean tempchoose = new ShowDispatchPeriodSettingUI((Object)this, this.source, logger).show();
        if (!this.choose) {
            this.choose = tempchoose;
        }
        if (this.choose) {
            new SaveJobProcessDef().exec(this.source);
            this.txtTimeDef.setText(this.source.getJobProcess());
            this.txtTimeDesc.setSelectedItemData((Object)((TimeDispatchSourceForAutoItem)this.source).getText());
        }
    }

    @Override
    protected void btnConform_actionPerformed(ActionEvent e) throws Exception {
        super.btnConform_actionPerformed(e);
        boolean isPeriodUnupdated = this.isPeriodUnupdated();
        boolean isCurrencyUpdated = this.isCurrencyUpdated();
        boolean isScheduleUpdated = this.isScheduleUpdated();
        boolean isDataUpdateWayUpdated = this.isDataUpdateWayUpdated();
        if (isPeriodUnupdated || isCurrencyUpdated || isScheduleUpdated || isDataUpdateWayUpdated) {
            this.updateFormulaCalcCtx();
        } else {
            this.unUpdatedPrompt();
        }
    }

    private boolean isDataUpdateWayUpdated() {
        return !((SingleDataUpdateWayEnum)((Object)this.dataUpdateWay.getSelectedItem())).equals((Object)this.currentInfo.getDataUpdateType());
    }

    private void unUpdatedPrompt() {
        MsgBox.showInfo((Component)((Object)this), (String)ResourceDebugUtil.res("com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", "unUpdatedSchedule", " "));
    }

    private void updateFormulaCalcCtx() throws BOSException, EASBizException {
        try {
            this.currentInfo.setOffPeriod(Integer.parseInt(this.kspPeriodOffset.getValue().toString()));
            this.currentInfo.setDispatchCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
            this.currentInfo.setDataUpdateType((SingleDataUpdateWayEnum)((Object)this.dataUpdateWay.getSelectedItem()));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("dispatchPeriod");
            selector.add("offPeriod");
            selector.add("dispatchCurrency");
            selector.add("dataUpdateType");
            FormulaCalcContextFactory.getRemoteInstance().updatePartial(this.currentInfo, selector);
            this.getMessageHandler().show(ResourceDebugUtil.res("setting.is.success"));
            this.disposeUIWindow();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private boolean isScheduleUpdated() {
        return this.choose;
    }

    private boolean isCurrencyUpdated() {
        String currencyKey = this.getCombCurrencyKey();
        return this.currentInfo.getDispatchCurrency() == null ? currencyKey != null : !this.currentInfo.getDispatchCurrency().getId().toString().equals(currencyKey);
    }

    private String getCombCurrencyKey() {
        String currencyKey = null;
        Object itemObj = this.comboCurrency.getSelectedItem();
        if (itemObj != null) {
            currencyKey = ((CurrencyInfo)itemObj).getId().toString();
        }
        return currencyKey;
    }

    private boolean isPeriodUnupdated() {
        return Integer.parseInt(this.kspPeriodOffset.getValue().toString()) != this.currentInfo.getOffPeriod();
    }

    protected MessageHandler getMessageHandler() {
        return new MessageHandler(1);
    }

    private String getTextByDispatchPeriodId(String dispatchPeriodId) throws Exception {
        if (dispatchPeriodId != null) {
            Map map = RptCalcSchemeFactory.getRemoteInstance().getProcessDef(dispatchPeriodId);
            ScheduleDef schdef = null;
            if (map != null && !map.isEmpty()) {
                schdef = new ScheduleDef(null);
                String define = (String)map.get("rpt_cacl_scheme_define");
                String[] defines = define.split(":");
                schdef.setType(ScheduleType.getEnum((String)defines[0]));
                schdef.setDefine(defines[1]);
                schdef.setBeginTime((Date)map.get("rpt_cacl_scheme_begintime"));
                schdef.setUseCalendar(RptUtil.isTrue(map.get("rpt_cacl_scheme_is_use_calendar ")));
                schdef.setOrgUnitId((String)map.get("rpt_cacl_scheme_org"));
                schdef.setInstructionType(1);
                return new FormatJobProcessSettingAction().action(schdef);
            }
        }
        return null;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }
}

