/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractGroupRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptParaMgrStartergy;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptMenuStrategy;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluCalcHelp;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluInfo;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReportProcess;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptMessage;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptParaMgrStartergy;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.client.RptStrategyManager;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;

public class GroupRptEditUI
extends AbstractGroupRptEditUI
implements IReportProcess {
    private static final long serialVersionUID = -7376184838223602255L;
    private static final String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg";
    IUIWindow reportUI;
    ICSLContext cslCtx = null;
    OrgTreeInfo unitTree;
    OrgUnitInfo company;
    public static final int BATCHSAVE_REPEAT_CSLRPT = 1;
    public static final int BATCHSAVE_REPEAT_RPT = 4;
    public static final int BATCHSAVE_FAILED = 2;
    public static final int BATCHSAVE_SUCCEED = 3;
    Map mapLinkOpenParam = null;
    private boolean isCtrlPress = false;
    boolean isSelect = true;

    public void setData(byte[] data) {
        this.getCurrentReport().setZipData(data);
    }

    public byte[] getData() {
        return this.getCurrentReport().getZipData();
    }

    public IObjectValue getEditDataObject() {
        return this.getCurrentReport();
    }

    public boolean getIsAudited() {
        if (this.getCurrentReport() != null) {
            return this.getCurrentReport().getAuditedStatus().getValue() != 1;
        }
        return false;
    }

    public boolean getIsCommitted() {
        if (this.getCurrentReport() != null) {
            return this.getCurrentReport().getAuditedStatus().getValue() != 1;
        }
        return false;
    }

    public boolean getIsCacl() {
        return false;
    }

    public String getReportUIName() {
        return GroupRptProcessUI.class.getName();
    }

    public RptStrategyManager getRptStrategyManager() {
        RptStrategyManager rptStrategyManager = new RptStrategyManager();
        GroupRptMenuStrategy cslMenu = new GroupRptMenuStrategy();
        cslMenu.setReportBaseInfo(this.getCurrentReport());
        rptStrategyManager.setCslParamStartegy(true);
        rptStrategyManager.setRptMenuStartegy((RptMenuStrategy)cslMenu);
        CslRptParaMgrStartergy para = new CslRptParaMgrStartergy();
        rptStrategyManager.setRptParaMgrStartergy((RptParaMgrStartergy)para);
        return rptStrategyManager;
    }

    private SelectorItemCollection getRptSelectors() {
        SelectorItemCollection sic = this.getSelectors();
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("isCommitReport"));
        return sic;
    }

    private SelectorItemCollection getSelectorsAfterSave() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("dynaRptType"));
        sic.add(new SelectorItemInfo("group"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.dynaRptType"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("reportDate"));
        return sic;
    }

    public Object getSheetparam() {
        return this.getCurrentReport().getSheetParam();
    }

    public Object getSheetparam(String sheetId) {
        RptSheetParamCollection params = this.getCurrentReport().getSheetParam();
        if (params != null && params.size() > 0) {
            int paramsSize = params.size();
            for (int i = 0; i < paramsSize; ++i) {
                if (!params.get(i).getSheetID().trim().equals(sheetId)) continue;
                return params.get(i);
            }
        }
        return null;
    }

    public Object getView(String arg0) throws Exception {
        ObjectStringPK pk = new ObjectStringPK();
        pk.setKeyValue("id", (Object)this.getCurrentReport().getId().toString());
        CslReportInfo reportView = ((ICslReport)this.getBizInterface()).getCslReportInfo((IObjectPK)pk);
        ReportProcessUI reportProcessUI = new ReportProcessUI();
        RptTablePane viewPane = reportProcessUI.loadReportContent(reportView.getKDF(), true);
        return viewPane;
    }

    public RptMessage checkCreatSheet(List rptSheets, RptSheet currentSheet) {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mapLinkOpenParam = (Map)this.getUIContext().get("KEY_LINKOPENRPT_PARAM");
        this.cslCtx = this.mapLinkOpenParam != null ? CSLContextHelper.getCSLContext(this.mapLinkOpenParam) : CSLContextHelper.getCSLContext();
        if (this.getUIContext().get("OpenReport") != null) {
            this.openReportUI();
        } else {
            this.tblTemplate.checkParsed();
            this.menuItemAddNew.setVisible(false);
            this.actionAddNew.setEnabled(false);
            this.tblTemplate.getSelectManager().setSelectMode(10);
            this.initData();
        }
        this.setUITitle(this.getUITitle() + " " + CslRptUtil.getString("AddNew"));
        String format = CslRptUIUtil.getNationalTimeFormatString();
        if (format != null) {
            this.tblTemplate.getColumn("template.lastUpdateTime").getStyleAttributes().setNumberFormat(format);
        }
        this.btnLocation.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.initTxtLocation();
        CslRptUIUtil.addTableSelectedListener(this.tblTemplate, "select");
        this.initTableEvent();
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    private void initTableEvent() {
        this.tblTemplate.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    GroupRptEditUI.this.isCtrlPress = true;
                } else if (e.getKeyCode() == 127) {
                    SysUtil.abort();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (GroupRptEditUI.this.isCtrlPress) {
                    GroupRptEditUI.this.isCtrlPress = false;
                }
            }
        });
        this.tblTemplate.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int count = GroupRptEditUI.this.tblTemplate.getRowCount();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        GroupRptEditUI.this.tblTemplate.getRow(i).getCell("select").setValue((Object)false);
                    }
                }
            }
        });
        this.tblTemplate.getColumn("select").getStyleAttributes().setLocked(false);
    }

    public RptSheetParamInfo processCreat(String sheetId) {
        RptSheetParamInfo newSheetParam = new RptSheetParamInfo();
        newSheetParam.setSheetID(sheetId);
        newSheetParam.setCurrency(this.getCurrentReport().getCurrency());
        newSheetParam.setRelaType(ReportTypeEnum.CSLREPORT);
        newSheetParam.setStartYear(0);
        newSheetParam.setEndYear(0);
        newSheetParam.setStartPeriod(0);
        newSheetParam.setEndPeriod(0);
        newSheetParam.setReportClass(CSLReportGroupEnum.COMMON);
        newSheetParam.setStatus(1);
        newSheetParam.setReport((VirtualSheetParamInfo)this.getCurrentReport());
        return newSheetParam;
    }

    public VirtualSheetParamInfo save() throws Exception {
        IObjectPK pk = ((ICslReport)this.getBizInterface()).submit((CoreBaseInfo)this.getCurrentReport());
        this.setOprtState(OprtState.EDIT);
        CslReportInfo info = (CslReportInfo)this.getBizInterface().getValue(pk, this.getSelectorsAfterSave());
        this.editData.setAuditedStatus(info.getAuditedStatus());
        this.editData.setLastUpdateTime(info.getLastUpdateTime());
        this.editData.getSheetParam().clear();
        this.editData.getSheetParam().addCollection(info.getSheetParam());
        this.editData.getPostils().clear();
        this.editData.getPostils().addCollection(info.getPostils());
        return this.getCurrentReport();
    }

    public void switchReport(String reportId) {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    protected CslReportInfo getReportInfo(String reportID) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), this.getRptSelectors());
    }

    protected String getSelectedTemplateID() {
        Object keyValue;
        int rowIndex;
        IRow row;
        ICell cell;
        boolean tmpSelected = false;
        String selectedKeyValue = null;
        KDTSelectBlock selectBlock = this.tblTemplate.getSelectManager().get();
        if (selectBlock != null && (cell = (row = this.tblTemplate.getRow(rowIndex = selectBlock.getTop())).getCell("template.id")) != null && (keyValue = cell.getValue()) != null) {
            selectedKeyValue = keyValue.toString();
            tmpSelected = true;
        }
        if (!tmpSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return selectedKeyValue;
    }

    private List getSelectedTemplateIdList() {
        ArrayList<String> list = new ArrayList<String>();
        int count = this.tblTemplate.getRowCount();
        if (count > 0) {
            boolean isSelect = false;
            for (int i = 0; i < count; ++i) {
                isSelect = (Boolean)this.tblTemplate.getRow(i).getCell("select").getValue();
                if (!isSelect) continue;
                String id = (String)this.tblTemplate.getRow(i).getCell("template.id").getValue();
                list.add(id);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        if (list.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return list;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.batchAddReport(this.getSelectedTemplateIdList());
        CslRptUIUtil.refreshOwnerTable(this.getUIContext());
    }

    private void batchAddReport(List list) throws Exception {
        int size = list.size();
        if (size == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"526_GroupRptEditUI"));
            this.isSelect = false;
            return;
        }
        HashSet<String> templateIdSet = new HashSet<String>();
        HashMap<String, TemplateInfo> templateInfoMap = new HashMap<String, TemplateInfo>();
        for (int i = 0; i < size; ++i) {
            templateIdSet.add(list.get(i).toString());
        }
        if (templateIdSet.size() > 0) {
            EntityViewInfo v = new EntityViewInfo();
            v.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            f.getFilterItems().add(new FilterItemInfo("id", templateIdSet, CompareType.INCLUDE));
            TemplateCollection templates = TemplateFactory.getRemoteInstance().getTemplateCollection(v);
            for (int i = 0; i < templates.size(); ++i) {
                templateInfoMap.put(templates.get(i).getId().toString(), templates.get(i));
            }
        }
        ArrayList<TemplateInfo> successLst = new ArrayList<TemplateInfo>();
        ArrayList<TemplateInfo> cslRptRepeatLst = new ArrayList<TemplateInfo>();
        ArrayList<TemplateInfo> rptRepeatLst = new ArrayList<TemplateInfo>();
        ArrayList<TemplateInfo> failedLst = new ArrayList<TemplateInfo>();
        for (int i = 0; i < size; ++i) {
            TemplateInfo template = (TemplateInfo)templateInfoMap.get(list.get(i).toString());
            if (template == null) continue;
            int ret = 3;
            try {
                ret = this.addNewEditData(template);
            }
            catch (Exception e) {
                ret = 2;
                if (e instanceof EASBizException) {
                    template.put("ERROR_MSG", (Object)((EASBizException)((Object)e)).getMessage());
                }
                template.put("ERROR_MSG", (Object)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"372_CslRptUIUtil") + "\n" + e.getMessage() != null ? e.getMessage() : ""));
            }
            if (ret == 1) {
                cslRptRepeatLst.add(template);
                continue;
            }
            if (ret == 4) {
                rptRepeatLst.add(template);
                continue;
            }
            if (ret == 2) {
                failedLst.add(template);
                continue;
            }
            successLst.add(template);
        }
        CslRptUIUtil.displayResult((Object)this, successLst, cslRptRepeatLst, rptRepeatLst, failedLst, ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getName());
    }

    private int addNewEditData(TemplateInfo template) throws Exception {
        Date date = (Date)this.datePickerDate.getValue();
        Calendar calendar = Calendar.getInstance();
        int periodType = template.getPeriodType().getValue();
        int year = this.cslCtx.getCurRptYear();
        short period = (short)this.cslCtx.getCurRptPeriod();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int templateType = template.getTemplateType().getValue();
        int reportType = -1;
        switch (templateType) {
            case 1: {
                reportType = 1;
                break;
            }
            case 3: {
                reportType = 2;
                break;
            }
            case 4: {
                reportType = 4;
                break;
            }
            case 5: {
                reportType = 3;
                break;
            }
            case 6: {
                reportType = 1;
                break;
            }
            case 10: {
                reportType = 10;
                break;
            }
            case 11: {
                reportType = 11;
                break;
            }
            case 12: {
                reportType = 12;
                break;
            }
            case 13: {
                reportType = 12;
                break;
            }
            case 15: {
                reportType = 13;
            }
        }
        String existId = this.verifyGroupReport(this.unitTree.getId().toString(), this.company.getId().toString(), periodType, year, period, currency.getId().toString(), template.getId().toString(), reportType, this.cslCtx.getCurDataCollect().getNumber());
        if (existId != null) {
            CslReportInfo info = this.getReportInfo(existId);
            if (info.isIsCommitReport()) {
                return 4;
            }
            return 1;
        }
        if (super.getOprtState() == OprtState.EDIT) {
            ObjectStringPK pk = new ObjectStringPK(this.editData.getId().toString());
            this.editData.setCurrency(currency);
            this.editData.setSourceCurrency(currency);
            this.getBizInterface().submit((IObjectPK)pk, (CoreBaseInfo)this.editData);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
            return 3;
        }
        this.editData = (CslReportInfo)this.createNewData();
        this.editData.setYear(year);
        this.editData.setPeriod(period);
        this.editData.setReportDate(this.cslCtx.getCurReportDate());
        this.editData.setTemplate(template);
        RptSheetParamCollection rptSheetParamCollection = template.getSheetParam();
        if (rptSheetParamCollection != null && rptSheetParamCollection.size() > 0) {
            for (int j = 0; j < rptSheetParamCollection.size(); ++j) {
                rptSheetParamCollection.get(j).setRelaType(ReportTypeEnum.REPORT);
                rptSheetParamCollection.get(j).setStatus(1);
            }
        }
        this.editData.getSheetParam().addCollection(rptSheetParamCollection);
        FormulaSoluInfo formulaSoluInfo = FormulaSoluCalcHelp.getInstance().preTemplateBookFormulaSolu(template.getBook(), this.company, template);
        this.editData.setBook(formulaSoluInfo.getReportBook());
        if (template.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT)) {
            this.editData.setSourceType(RptSrcTypeEnum.DYNAMICNORMALREPORT);
            this.editData.setDynaRptType(template.getDynaRptType());
        } else if (template.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT)) {
            this.editData.setSourceType(RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT);
            this.editData.setDynaRptType(template.getDynaRptType());
        } else {
            this.editData.setSourceType(RptSrcTypeEnum.NORMAL);
        }
        if (this.company instanceof CompanyOrgUnitInfo) {
            this.editData.setCompany((CompanyOrgUnitInfo)this.company);
        } else if (this.company != null) {
            this.editData.setCompany((CompanyOrgUnitInfo)this.company.cast(CompanyOrgUnitInfo.class));
        }
        this.editData.setOrgUnit(this.company);
        this.editData.setCurrency(currency);
        this.editData.setName(template.getName());
        this.editData.setNumber("001");
        this.editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        this.editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        this.editData.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        this.editData.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        this.editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        this.editData.setReportDate(this.cslCtx.getCurReportDate());
        DataCollectInfo dataCollect = this.cslCtx.getCurDataCollect();
        if (dataCollect != null) {
            this.editData.setDataCollect(dataCollect);
            this.editData.setDataCollectNumber(dataCollect.getNumber());
        }
        this.getDynaKeyAndValue(this.editData);
        IObjectPK pk = this.getBizInterface().submit((CoreBaseInfo)this.editData);
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        if (formulaSoluInfo.getId() != null) {
            FormulaSoluCalcHelp.getInstance().saveReportUseFormula(pk.toString(), formulaSoluInfo.getId().toString(), formulaSoluInfo.getData());
        }
        return 3;
    }

    private void getDynaKeyAndValue(CslReportInfo editData) throws Exception {
        if (editData.getBook() == null) {
            return;
        }
        Book book = editData.getBook();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            ArrayList allKeyRow;
            SumcalcRange valueZone;
            Sheet sheet = book.getSheet(i);
            SumcalcRange keyZone = sheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange sumcalcRange = valueZone = sheet.getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            if (keyZone == null) continue;
            HashMap leftKeyColAndAllRow = this.getLeftColAndAllLeftRow(sheet, keyZone);
            if (valueZone == null || leftKeyColAndAllRow.get("leftCol") == null || (allKeyRow = (ArrayList)leftKeyColAndAllRow.get("allRow")).size() == 0) continue;
            ArrayList allValueCol = this.getKeyValueCol(sheet, valueZone, allKeyRow);
            sheet.setUserObject("allValueCol", (Object)allValueCol);
            sheet.setUserObject("keyLeftCol", (Object)((Integer)leftKeyColAndAllRow.get("leftCol")));
            this.reSaveKeyZoneByRange(sheet, allKeyRow, (Integer)leftKeyColAndAllRow.get("leftCol"));
        }
        editData.setNewBook(book);
    }

    private HashMap getLeftColAndAllLeftRow(Sheet sheet, SumcalcRange zone) {
        int i;
        CellBlock block;
        int index;
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        int leftCol = -1;
        ArrayList<Integer> allRow = new ArrayList<Integer>();
        for (index = 0; index < zone.size(); ++index) {
            block = zone.getCellBlock(index);
            for (i = block.getCol(); i <= block.getCol2(); ++i) {
                if (leftCol == -1) {
                    leftCol = i;
                    continue;
                }
                if (leftCol <= i) continue;
                leftCol = i;
            }
        }
        for (index = 0; index < zone.size(); ++index) {
            block = zone.getCellBlock(index);
            for (i = block.getRow(); i <= block.getRow2(); ++i) {
                if (block.getCol() != leftCol || block.getCol2() != leftCol || allRow.contains(new Integer(i))) continue;
                allRow.add(new Integer(i));
            }
        }
        map.put("leftCol", new Integer(leftCol));
        map.put("allRow", allRow);
        return map;
    }

    private ArrayList getKeyValueCol(Sheet sheet, SumcalcRange zone, ArrayList allRow) {
        ArrayList<Integer> valueCol = new ArrayList<Integer>();
        for (int index = 0; index < zone.size(); ++index) {
            CellBlock block = zone.getCellBlock(index);
            for (int i = block.getCol(); i <= block.getCol2(); ++i) {
                if (valueCol.contains(new Integer(i))) continue;
                valueCol.add(new Integer(i));
            }
        }
        return valueCol;
    }

    private void reSaveKeyZoneByRange(Sheet sheet, ArrayList allKeyRow, Integer keyLeftCol) {
        int beginRow;
        SumcalcRange newKeyZone = new SumcalcRange();
        Object[] o = allKeyRow.toArray();
        Arrays.sort(o);
        int endRow = beginRow = ((Integer)o[0]).intValue();
        for (int i = 0; i <= o.length && i != o.length + 1; ++i) {
            CellBlock cb;
            int row;
            if (i != o.length) {
                row = (Integer)o[i];
                if (endRow == row) {
                    ++endRow;
                    continue;
                }
                cb = CellBlock.getNewCellBlock((int)beginRow, (int)keyLeftCol, (int)(endRow - 1), (int)keyLeftCol);
                beginRow = row;
                endRow = row + 1;
                newKeyZone.addRange(sheet.getRange(cb));
                continue;
            }
            row = (Integer)o[o.length - 1];
            if (endRow - 1 != row) continue;
            cb = CellBlock.getNewCellBlock((int)beginRow, (int)keyLeftCol, (int)(endRow - 1), (int)keyLeftCol);
            newKeyZone.addRange(sheet.getRange(cb));
        }
        sheet.setUserObject("DYNAMICSUMKEYZONE", (Object)newKeyZone);
    }

    private boolean getIsCanEdit(String orgBound, String thisCompany, String template) throws BOSException {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection col = filter.getFilterItems();
        col.add(new FilterItemInfo("company", (Object)thisCompany));
        col.add(new FilterItemInfo("orgBound", (Object)orgBound));
        col.add(new FilterItemInfo("dispenseSrcID", (Object)template));
        entityView.setFilter(filter);
        entityView.getSelector().add(new SelectorItemInfo("isAllowChgTemplet"));
        CoreBaseCollection collection = TempletDispenseFactory.getRemoteInstance().getCollection(entityView);
        for (Object obj : collection) {
            if (obj == null || !(obj instanceof TempletDispenseInfo)) continue;
            TempletDispenseInfo info = (TempletDispenseInfo)obj;
            return info.isIsAllowChgTemplet();
        }
        return false;
    }

    protected IObjectValue createNewData() {
        CslReportInfo info = new CslReportInfo();
        info.setSourceType(RptSrcTypeEnum.NORMAL);
        return info;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec;
        block20: {
            exec = null;
            try {
                exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
                exec.option().isAutoTranslateEnum = true;
                int index = 1;
                exec.setParameter(index++, (Object)this.cslCtx.getCurOrgBound().getId().toString());
                if (super.getUIContext() != null && super.getOprtState() == OprtState.EDIT) {
                    exec.setParameter(index++, (Object)this.editData.getCompany().getId().toString());
                } else {
                    exec.setParameter(index++, (Object)this.company.getId().toString());
                }
                exec.setParameter(index++, (Object)new Integer(this.cslCtx.getCurRptPeriodType().getValue()));
                if (super.getUIContext() != null && super.getOprtState() == OprtState.EDIT) {
                    FilterInfo filter = this.groupRptTemplateQuery.getFilter();
                    if (filter == null) {
                        filter = new FilterInfo();
                    }
                    index = filter.getFilterItems().size();
                    StringBuffer maskString = new StringBuffer();
                    if (maskString.length() == 0) {
                        maskString.append(" #").append(index++);
                    } else {
                        maskString.append(filter.getMaskString());
                        maskString.append(" And #").append(index++);
                    }
                    filter.getFilterItems().add(new FilterItemInfo("template.id", (Object)this.editData.getTemplate().getId().toString(), CompareType.EQUALS));
                    filter.setMaskString(maskString.toString());
                    try {
                        FilterInfo dataPermissionFilter = CslRptUtil.getDataPermissionFilter(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.company.getId()), "csl_indirpttmp_view");
                        if (dataPermissionFilter != null) {
                            for (int i = 0; i < dataPermissionFilter.getFilterItems().size(); ++i) {
                                FilterItemInfo filterItemInfo = dataPermissionFilter.getFilterItems().get(i);
                                filterItemInfo.setPropertyName("Template." + filterItemInfo.getPropertyName());
                            }
                            filter.mergeFilter(dataPermissionFilter, "AND");
                        }
                    }
                    catch (Exception e) {
                        this.handUIExceptionAndAbort(e);
                    }
                    this.groupRptTemplateQuery.setFilter(filter);
                    exec.setObjectView(this.groupRptTemplateQuery);
                    break block20;
                }
                if (super.getUIContext() == null || super.getOprtState() != OprtState.ADDNEW) break block20;
                FilterInfo filter = this.groupRptTemplateQuery.getFilter();
                if (filter == null) {
                    filter = new FilterInfo();
                }
                index = filter.getFilterItems().size();
                StringBuffer maskString = new StringBuffer();
                if (maskString.length() == 0) {
                    maskString.append(" #").append(index++);
                } else {
                    maskString.append(filter.getMaskString());
                    maskString.append(" And #").append(index++);
                }
                filter.getFilterItems().add(new FilterItemInfo("template.versionStatus", (Object)new Integer(1), CompareType.EQUALS));
                if (this.cslCtx.getCurDataCollect() != null && this.cslCtx.getCurDataCollect().getNumber() != null && !this.cslCtx.getCurDataCollect().getNumber().equals("ACTUALDATA")) {
                    filter.getFilterItems().add(new FilterItemInfo("template.templateType", (Object)new Integer(15), CompareType.NOTEQUALS));
                    maskString.append(" And #").append(index++);
                    filter.getFilterItems().add(new FilterItemInfo("template.includeOtherDC", (Object)new Integer(1), CompareType.EQUALS));
                    maskString.append(" And #").append(index++);
                }
                filter.setMaskString(maskString.toString());
                try {
                    FilterInfo dataPermissionFilter = CslRptUtil.getDataPermissionFilter(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.company.getId()), "rpt_template_view");
                    if (dataPermissionFilter != null) {
                        for (int i = 0; i < dataPermissionFilter.getFilterItems().size(); ++i) {
                            FilterItemInfo filterItemInfo = dataPermissionFilter.getFilterItems().get(i);
                            filterItemInfo.setPropertyName("Template." + filterItemInfo.getPropertyName());
                        }
                        filter.mergeFilter(dataPermissionFilter, "AND");
                    }
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
                this.groupRptTemplateQuery.setFilter(filter);
                exec.setObjectView(this.groupRptTemplateQuery);
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
        }
        return exec;
    }

    protected void initData() throws Exception {
        this.unitTree = this.cslCtx.getCurOrgBound();
        if (this.getOprtState().equals("ADDNEW")) {
            IOrgUnitCommon orgCommon = OrgUnitCommonFactory.getRemoteInstance();
            OrgUnitInfo currOrg = (OrgUnitInfo)this.getUIContext().get("company");
            Object orgUnit = null;
            orgUnit = currOrg.isIsProfitOrgUnit() ? orgCommon.getRelationUnit(((OrgUnitInfo)this.getUIContext().get("company")).getId(), OrgType.ProfitCenter) : orgCommon.getCompany(((OrgUnitInfo)this.getUIContext().get("company")).getId());
            this.company = orgUnit;
        } else {
            this.company = super.getOprtState() == OprtState.EDIT && this.editData != null && this.editData.getCompany() != null ? this.editData.getCompany() : SysContext.getSysContext().getCurrentFIUnit();
        }
        super.setDataObject("groupRptTemplateQuery", (IObjectValue)new EntityViewInfo());
        CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, true, false);
        String currentCompany = this.company.getId().toString();
        CurrencyInfo currCurrency = RptNewUIUtil.getCompanyBasicCurrency((OrgType)OrgType.Company, (String)currentCompany);
        this.selectedCurrency(currCurrency);
        Date curDate = this.cslCtx.getCurReportDate();
        this.datePickerDate.setValue((Object)curDate);
        this.datePickerDate.setEnabled(false);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            CurrencyInfo o = null;
            String id = this.editData.getCurrency().getId().toString();
            int j = this.comboCurrency.getItemCount();
            for (int i = 0; i < j; ++i) {
                o = (CurrencyInfo)this.comboCurrency.getItemAt(i);
                if (!o.getId().toString().equalsIgnoreCase(id)) continue;
                this.comboCurrency.setSelectedIndex(i);
                break;
            }
        }
        this.txtPeriodType.setText(this.cslCtx.getCurRptPeriodType().getAlias());
        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"116_GroupRptEditUI");
        this.txtYearAndPeriod.setText(MessageFormat.format(msg, this.cslCtx.getCurRptYear() + "", this.cslCtx.getCurRptPeriod() + ""));
        this.txtPeriodType.setEditable(false);
        this.txtYearAndPeriod.setEditable(false);
    }

    private void selectedCurrency(CurrencyInfo currCurrency) {
        CurrencyCollection initCurrencyCollection = CslRptUIUtil.getCurrencyCollection();
        if (currCurrency != null) {
            String currencyID = currCurrency.getId().toString();
            int size = initCurrencyCollection.size();
            for (int i = 0; i < size; ++i) {
                if (!initCurrencyCollection.get(i).getId().toString().equals(currencyID)) continue;
                this.comboCurrency.setSelectedIndex(i);
                break;
            }
        }
    }

    private void setCurrentReport(CslReportInfo report) {
        this.editData = report;
    }

    private CslReportInfo getCurrentReport() {
        return this.editData;
    }

    private void initTmpTable(HashSet templates) {
        if (templates == null || templates.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"GroupRptEditUI.Msg_EmptyTemplate"));
            return;
        }
        this.tblTemplate.getSelectManager().setSelectMode(2);
        this.tblTemplate.getStyleAttributes().setLocked(true);
        this.tblTemplate.removeRows();
        if (templates != null && templates.size() > 0) {
            for (TemplateInfo info : templates) {
                IRow r = this.tblTemplate.addRow();
                r.getCell(0).setValue((Object)info.getName());
                r.getCell(1).setValue((Object)info.getPeriodType());
                r.getCell(2).setValue((Object)info.getLastUpdateTime());
                r.getCell(3).setValue((Object)info.getDescription());
                r.getCell(4).setValue((Object)info.getTemplateType());
                r.getCell(5).setValue((Object)info.getId().toString());
            }
        }
    }

    private void openReportUI() throws Exception {
        IUIWindow window;
        String reportID = (String)this.getUIContext().get("ID");
        this.setCurrentReport(this.getReportInfo(reportID));
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"ID", (Object)reportID);
        uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"superParent", this.getUIContext().get("superParent"));
        if (this.getUIContext().get("canAddAttachement") != null) {
            uiContext.put((Object)"canAddAttachement", this.getUIContext().get("canAddAttachement"));
        }
        this.reportUI = window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getReportUIName(), (Map)uiContext, null, this.getOprtState());
        window.getUIObject().setUITitle(CslRptUIUtil.getUITitle((VirtualSheetParamInfo)this.editData, this.getOprtState()));
        window.show();
    }

    private String verifyGroupReport(String treeID, String companyID, int periodType, int year, int period, String currencyID, String templateID, int reportType, String dataCollectNumber) throws Exception {
        String reportId = null;
        if (super.getOprtState() == OprtState.EDIT) {
            reportId = this.editData.getId().toString();
        }
        String rptId = CslRptUIUtil.getReportByOldVersionTmp2(treeID, companyID, periodType, year, period, currencyID, templateID, reportType, reportId, dataCollectNumber);
        return rptId;
    }

    public boolean destroyWindow() {
        Object owner;
        if (this.getOprtState().equals("EDIT")) {
            super.releaseObjectLock(this.editData.getId().toString());
        }
        if ((owner = this.getUIContext().get("Owner")) instanceof ListUI) {
            try {
                if (this.getUIContext().get("OPEN_REPORT_WITH_OA") == null) {
                    ((ListUI)owner).actionRefresh_actionPerformed(null);
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return super.destroyWindow();
    }

    public void submitWorkFlow() throws Exception {
    }

    public PostilCollection getRptPostilColl() {
        for (int i = 0; i < this.editData.getPostils().size(); ++i) {
            if (this.editData.getPostils().get(i).getPostilType().getValue() == 1) continue;
            this.editData.getPostils().removeObject(i);
            --i;
        }
        return this.editData.getPostils();
    }

    public RptMessage checkCreatSheet(List rptSheets) {
        return null;
    }

    protected void onSelectTabChanged(KDTable currentTable) {
    }

    public boolean isModify() {
        return false;
    }

    @Override
    protected void tblTemplate_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.isSelect = true;
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getSelectedTemplateID());
            this.batchAddReport(list);
            if (this.isSelect) {
                this.destroyWindow();
            }
        } else if (e.getButton() == 1 && e.getClickCount() == 1 && this.isCtrlPress) {
            IRow row = this.tblTemplate.getRow(e.getRowIndex());
            boolean isSelect = (Boolean)row.getCell("select").getValue();
            row.getCell("select").setValue((Object)(!isSelect ? 1 : 0));
            this.tblTemplate.checkParsed();
        }
    }

    @Override
    public void actionLocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocation_actionPerformed(e);
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblTemplate.getColumnIndex("template.number");
            int colIndex2 = this.tblTemplate.getColumnIndex("template.name");
            CslRptUIUtil.tableMainLocate(this.tblTemplate, search, new int[]{colIndex1, colIndex2});
        }
    }

    @Override
    public void actionDisplay_actionPerformed(ActionEvent e) throws Exception {
        CslRptUIUtil.tableSelectDisplay(this.tblTemplate, "select", this.btnDisplay);
    }
}

