/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalcUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IHisCslReport;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RptSystemFrom;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractGroupRptListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CopyGroupRptHisDataListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptClientHelperUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.GenerateNextYearInitDataUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MaintainYearInitDataUI;
import com.kingdee.eas.fi.gr.cslrpt.client.NeedRefreshable;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.gr.dynamic.client.GroupMultiRptProcessUI;
import com.kingdee.eas.fi.newrpt.IReportBatchCalculateFacade;
import com.kingdee.eas.fi.newrpt.ReportBatchCalculateFacadeFactory;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.RegisterWindowKeyListenerHelper;
import com.kingdee.eas.fi.newrpt.client.util.MutexHelp;
import com.kingdee.eas.fi.newrpt.rptInExcel.client.GroupRpt_RptInExcelImportWizardUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.client.GenVoucherUtilForClient;
import com.kingdee.eas.fi.rpt.client.GenerateNextYearInitUI;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.client.ReportUpgradeUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.MenuEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class GroupRptListUI
extends AbstractGroupRptListUI
implements ICSLContextUI,
Runnable {
    private static final Logger logger = Logger.getLogger(GroupRptListUI.class);
    private List canMaintainReportIDList = null;
    private List canGenReportIDList = null;
    private static final long serialVersionUID = 411788630260481028L;
    private static final String UIMSG_INFO_RPTISCOMMITED = "RptIsCommited";
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    CommonQueryDialog conditionDialog = null;
    private CommonQueryDialog commqueryDialog = null;
    GroupRptFilterUI conditionPanel = null;
    ICSLContext cslCtx = CSLContextHelper.getCSLContext();
    OrgUnitInfo company = null;
    OrgTreeInfo orgBound = null;
    int year = 0;
    int period = 0;
    int periodType = 0;
    private FilterInfo currentFilter = null;
    private boolean isMergeByFiscalPeriod;
    private PeriodCollection periods = null;
    private CslReportCollection reportCalcColl;
    private Set<BOSUuid> noGroupIdSets = new HashSet<BOSUuid>();
    private boolean isFill = false;

    public GroupRptListUI() throws Exception {
        this.tblMain.checkParsed();
        this.isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                GroupRptListUI.this.setRptFromValue(e);
            }
        });
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = null;
        try {
            dialog = this.getConditionDialog();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return dialog;
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK mainQueryPk = this.initQueryBudget();
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPk);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"GroupRpt_FilterUI_Title"));
            this.conditionDialog.setWidth(330);
            this.conditionDialog.setHeight(250);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.gr.cslrpt.client.GroupRptListUI");
        }
        return this.conditionDialog;
    }

    public GroupRptFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new GroupRptFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
            this.conditionPanel.setReportType(1);
        }
        return this.conditionPanel;
    }

    public String getReportUIName() {
        return ReportProcessUI.class.getName();
    }

    public void onLoad() throws Exception {
        this.menuItemRptInExcel.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.tblMain.checkParsed();
        this.isFill = true;
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            this.mainQuery.setIngorePreOrders(true);
            CSLContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.orgBound = this.cslCtx.getCurOrgBound();
        this.company = this.cslCtx.getCurOrgGroup();
        this.year = this.cslCtx.getCurRptYear();
        this.period = this.cslCtx.getCurRptPeriod();
        this.periodType = this.cslCtx.getCurRptPeriodType().getValue();
        if (this.period == 12 || this.period == 13) {
            this.btGenerateNextYearInit.setEnabled(true);
            this.generateNextYearInit.setEnabled(true);
        } else {
            this.btGenerateNextYearInit.setEnabled(false);
            this.generateNextYearInit.setEnabled(false);
        }
        this.initTree();
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getViewManager().setFreezeView(0, 4);
        Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
        if ("true".equals(isSupportOtherDS)) {
            this.tblMain.getColumn("dataCollect").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("dataCollect").getStyleAttributes().setHided(true);
        }
        this.btnBatchCommit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemBatchCommit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionBatchCommit.setEnabled(true);
        this.btnBatchAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemBatchAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionBatchAudit.setEnabled(true);
        this.btnCopyHisRpt.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
        this.menuItemCopyHisRpt.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
        this.actionCopyHisRpt.setEnabled(true);
        this.maintainYearInitDataKDMenu.setVisible(false);
        this.maintainYearInitDataKDMenu.setEnabled(false);
        this.maintainYearInitDataKDMenuItem.setVisible(false);
        this.maintainYearInitDataKDMenuItem.setEnabled(false);
        this.generateYearInitDataKDMenuItem.setVisible(false);
        this.generateYearInitDataKDMenuItem.setEnabled(false);
        if (CSLContextHelper.getCSLContext().getCurPublishedStatus()) {
            this.rptArchive();
        }
        ReportUpgradeUI.registerBackDoorAction((KDPanel)this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ReportUpgradeUI.upgrade((List)GroupRptListUI.this.getSelectedIdValues(), (ICoreBase)GroupRptListUI.this.getBizInterface(), (Object)GroupRptListUI.this);
                }
                catch (Exception e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
        ICSLContext cslCtx = CSLContextHelper.getCSLContext();
        OrgTreeInfo orgBound = cslCtx.getCurOrgBound();
        OrgUnitInfo company = cslCtx.getCurOrgGroup();
        if (orgBound != null && orgBound.getName() != null) {
            this.txtOrgBound.setText(orgBound.getName());
        }
        this.comboBoxCompany.removeAllItems();
        if (company != null) {
            this.comboBoxCompany.addItem((Object)company);
        }
        CslRptClientHelperUI.setCruYearAndPeriod(cslCtx, this.spCurYear, this.spCurPeriod);
        this.mainQueryPK = this.initQueryBudget();
        if (this.ctx.getCurDataCollect() != null && this.ctx.getCurDataCollect().getNumber() != null && "BUDGETDATA".equals(this.ctx.getCurDataCollect().getNumber())) {
            this.maintainYearInitDataKDMenu.setEnabled(false);
        }
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent event) {
                int keyCode = event.getKeyCode();
                if (keyCode == 122 && event.isControlDown() && event.isShiftDown()) {
                    CslRptUtil cslrpt = new CslRptUtil();
                    cslrpt.exportReportByKDS(GroupRptListUI.this.exportReoprtByKDS());
                }
            }

            @Override
            public void keyPressed(KeyEvent event) {
            }

            @Override
            public void keyTyped(KeyEvent event) {
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock block = e.getSelectBlock();
                if (block != null) {
                    for (int i = block.getBeginRow(); i <= block.getEndRow(); ++i) {
                        if (GroupRptListUI.this.tblMain.getRow(i) == null || GroupRptListUI.this.tblMain.getRow(i).getCell("sourceType") == null) continue;
                        BizEnumValueDTO rptType = (BizEnumValueDTO)GroupRptListUI.this.tblMain.getRow(i).getCell("sourceType").getValue();
                        if (rptType != null && RptSrcTypeEnum.CONSOLIDATION.getName().equals(rptType.getName())) {
                            GroupRptListUI.this.maintainYearInitDataKDMenu.setEnabled(false);
                            break;
                        }
                        GroupRptListUI.this.maintainYearInitDataKDMenu.setEnabled(true);
                        break;
                    }
                }
            }
        });
        if (this.isMergeByFiscalPeriod && this.periods == null) {
            this.periods = FiscalPeriodHelper.getPeriodCollection(null, cslCtx.getCurOrgBound());
        }
        this.actionBatchQueueCalc.setEnabled(false);
        this.btnBatchQueueCalc.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        CslRptUIUtil.changeActionEnabledByTableSelect(this.tblMain, (ItemAction)this.actionEdit);
    }

    private Map exportReoprtByKDS() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ICslReport iReport = null;
        IHisCslReport iHisReport = null;
        byte[] repPackData = null;
        try {
            String selectId = this.getSelectedKeyValue();
            if (this.ctx.isQueryBudget()) {
                iHisReport = HisCslReportFactory.getRemoteInstance();
                HisCslReportInfo hisReportInfo = iHisReport.getHisCslReportInfo("select * where id = '" + selectId + "'");
                repPackData = hisReportInfo.getZipData();
            } else {
                iReport = CslReportFactory.getRemoteInstance();
                CslReportInfo reportInfo = iReport.getCslReportInfo("select * where id = '" + selectId + "'");
                repPackData = reportInfo.getZipData();
            }
            params.put("ids", this.getSelectIds());
            params.put("selectId", selectId);
            params.put("repPackData", repPackData);
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        return params;
    }

    private ArrayList getSelectIds() throws Exception {
        int selectRowCount = this.tblMain.getSelectManager().size();
        KDTSelectBlock selectBlock = null;
        ArrayList<Object> selectIds = new ArrayList<Object>();
        for (int i = 0; i < selectRowCount; ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                String id = this.tblMain.getRow(j).getCell("id").getValue().toString();
                if (id == null) continue;
                selectIds.add(this.tblMain.getRow(j).getCell("id").getValue());
            }
        }
        return selectIds;
    }

    protected void rptArchive() {
        this.btnAddNew.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnBatchAudit.setEnabled(false);
        this.btnBatchCommit.setEnabled(false);
        this.menuItemAddNew.setEnabled(false);
        this.menuItemBatchAudit.setEnabled(false);
        this.menuItemBatchCommit.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        this.menuItemExportData.setEnabled(false);
        this.menuItemImportData.setEnabled(false);
        this.menuItemPublishReport.setEnabled(false);
        this.menuItemRemove.setEnabled(false);
        this.btnCopyHisRpt.setEnabled(false);
        this.menuItemCopyHisRpt.setEnabled(false);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, (CoreUI)this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (CSLContextHelper.getCSLContext().isQueryBudget()) {
            return HisCslReportFactory.getRemoteInstance();
        }
        return CslReportFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return GroupRptEditUI.class.getName();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getObjectUpdateId() {
        return super.getSelectedKeyValue();
    }

    protected CslReportInfo getReportInfo(String reportID) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), this.getSelectors());
    }

    protected HisCslReportInfo getHisReportInfo(String reportID) throws Exception {
        IHisCslReport iReport = (IHisCslReport)this.getBizInterface();
        return iReport.getHisCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), this.getSelectors());
    }

    protected CslReportInfo getReportInfo(String reportID, SelectorItemCollection selectors) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return (CslReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), selectors);
    }

    protected HisCslReportInfo getHisReportInfo(String reportID, SelectorItemCollection selectors) throws Exception {
        IHisCslReport iReport = (IHisCslReport)this.getBizInterface();
        return (HisCslReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), selectors);
    }

    @Override
    public void actionGenerateNextYearInit_actionPerformed(ActionEvent e) throws Exception {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPk = new ObjectUuidPK(userInfo.getId());
        ObjectUuidPK orgUnitPk = new ObjectUuidPK(this.cslCtx.getCurOrgGroup().getId());
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgUnitPk, "csl_indirpt_update");
        UIContext uiContext = new UIContext((Object)this);
        Object currencyId = null;
        if (this.mainQuery != null) {
            FilterItemCollection filterItems = this.mainQuery.getFilter().getFilterItems();
            for (int i = 0; i < filterItems.size(); ++i) {
                if (!"currency.id".equals(filterItems.get(i).getPropertyName())) continue;
                currencyId = filterItems.get(i).getCompareValue();
                break;
            }
        }
        uiContext.put((Object)"selectedCompany", (Object)this.getSelectedCompany());
        uiContext.put((Object)"UnitSet", this.noGroupIdSets);
        uiContext.put((Object)"currencyId", this.cslCtx.getCurCurrency() != null ? this.cslCtx.getCurCurrency().getId() : currencyId);
        uiContext.put((Object)"year", (Object)this.year);
        uiContext.put((Object)"period", (Object)this.period);
        uiContext.put((Object)"periodType", (Object)RptPeriodTypeEnum.getEnum((int)this.periodType));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(GenerateNextYearInitUI.class.getName(), (Map)uiContext);
        if (uiWindow.getUIObject() instanceof NeedRefreshable && ((NeedRefreshable)uiWindow.getUIObject()).isNeed()) {
            ((NeedRefreshable)uiWindow.getUIObject()).toRefresh();
        }
        uiWindow.show();
    }

    private OrgUnitInfo getSelectedCompany() {
        OrgUnitInfo orgUnit;
        DefaultKingdeeTreeNode treeNode;
        OrgUnitInfo obj;
        if (this.treeCompany.getSelectionCount() > 0 && (obj = OrgClientUtils.getOrgUnitFromTreeNode((DefaultKingdeeTreeNode)(treeNode = (DefaultKingdeeTreeNode)this.treeCompany.getLastSelectedPathComponent()))) != null && obj instanceof OrgUnitInfo && !(orgUnit = obj).isIsGrouping()) {
            return orgUnit;
        }
        return null;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo selectedCompany = this.getSelectedCompany(false);
        BOSUuid pk = selectedCompany.getId();
        IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        OrgUnitInfo info = iOrgUnit.getOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
        if (info.isIsGrouping()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Can_Not_Be_Group"));
            return;
        }
        super.actionAddNew_actionPerformed(e);
        this.tblMain.removeRows();
    }

    @Override
    public void actionParamManage_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.openReport(OprtState.EDIT);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        this.mainQueryPK = this.initQueryBudget();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = GroupRptListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            if (this.commqueryDialog == null) {
                this.commqueryDialog = this.initCommonQueryDialog();
                this.commqueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"GroupRpt_FilterUI_Title"));
            }
            if (this.commqueryDialog.show()) {
                this.doQuery(this.commqueryDialog);
                this.mainQuery = this.commqueryDialog.getEntityViewInfoResult();
                this.currentFilter = this.mainQuery.getFilter();
            } else {
                SysUtil.abort();
            }
        } else if (this.mainQuery != null) {
            this.currentFilter = this.mainQuery.getFilter();
        }
        this.filterQuery();
        String format = CslRptUIUtil.getNationalTimeFormatString();
        if (format != null) {
            this.tblMain.getColumn("year").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("period").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("commitTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("receiveTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(format);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        CslRptCalcUtil.batchCheckMutexLock((Component)((Object)this), this.getSelectedIdValues(), true, false);
        this.batchRemoveReport();
        this.refresh(e);
    }

    private void batchRemoveReport() throws Exception, BOSException, EASBizException {
        if (this.confirmRemove()) {
            ArrayList list = this.getSelectedIdValues();
            StringBuffer msg = new StringBuffer();
            int successCount = 0;
            for (int i = 0; i < list.size(); ++i) {
                String resultMsg = this.removeReport((String)list.get(i));
                if (!StringUtils.isEmpty((String)resultMsg)) {
                    msg.append(resultMsg).append("\n");
                    continue;
                }
                ++successCount;
            }
            if (msg.length() > 0) {
                MessageFormat format = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"removeSuccessMessage"));
                MsgBox.showDetailAndOK((Component)((Object)this), (String)format.format(new Object[]{list.size(), successCount, list.size() - successCount}), (String)msg.toString(), (int)1);
                SysUtil.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String removeReport(String reportId) throws Exception, BOSException, EASBizException {
        try {
            try {
                this.setOprtState("REMOVE");
                this.pubFireVOChangeListener(reportId);
            }
            catch (Throwable ex) {
                this.handUIException(ex);
                this.abort();
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("committedStatus"));
            sic.add(new SelectorItemInfo("publishedStatus"));
            sic.add(new SelectorItemInfo("sourceType"));
            sic.add(new SelectorItemInfo("name"));
            CslReportInfo report = this.getReportInfo(reportId, sic);
            if (report.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || report.getSourceType() == RptSrcTypeEnum.DYNAMICCSLREPORT) {
                String string = "[" + report.getName() + "]" + CslRptUtil.getString("GroupRptCslOnlyForQuery");
                return string;
            }
            if (report.getSourceType().equals((Object)RptSrcTypeEnum.SUM) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT)) {
                String string = "[" + report.getName() + "]" + CslRptUtil.getString("GroupRptSumOnlyForQuery");
                return string;
            }
            if (report != null) {
                if (report.getCommittedStatus().getValue() != 1) {
                    String string = "[" + report.getName() + "]" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)UIMSG_INFO_RPTISCOMMITED);
                    return string;
                }
                if (report.getPublishedStatus().getValue() != 1) {
                    String string = "[" + report.getName() + "]" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptIsPublished");
                    return string;
                }
            }
            if (report == null) return null;
            if (report.getCommittedStatus().getValue() != 1) return null;
            if (report.getPublishedStatus().getValue() != 1) return null;
            ArrayList<String> list = new ArrayList<String>();
            list.add(report.getId().toString());
            this.getCoreBaseInterface().delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)report.getId().toString())));
            ItemFormulaCheckResultFactory.getRemoteInstance().batchDelete(list);
            return null;
        }
        finally {
            try {
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(reportId);
            }
            catch (Throwable throwable) {}
        }
    }

    private void openReport(String state) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("data.*"));
        ReportBaseInfo report = null;
        report = this.ctx.isQueryBudget() ? this.getHisReportInfo(id, sic) : this.getReportInfo(id, sic);
        if (!this.ctx.isQueryBudget() && OprtState.EDIT.equals(state)) {
            this.openCheck((CslReportInfo)report);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"superParent", this.getUIContext().get("Owner"));
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        uiContext.put((Object)"ISQUERYBUDGET", (Object)new Integer(CslRptUtil.isQueryBudget()));
        uiContext.put((Object)"company", (Object)this.getSelectedCompany(true));
        String processUI = null;
        if (report.getSourceType() == RptSrcTypeEnum.NORMAL || report.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || report.getSourceType() == RptSrcTypeEnum.COMMITREPORT) {
            processUI = GroupRptProcessUI.class.getName();
        } else if (report.getSourceType() == RptSrcTypeEnum.SUM || report.getSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT) {
            processUI = SumRptProcessUI.class.getName();
            uiContext.put((Object)"CanEdit", (Object)Boolean.FALSE);
        } else if (!this.ctx.isQueryBudget() && report.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT) {
            processUI = GroupMultiRptProcessUI.class.getName();
        } else {
            processUI = CslRptProcessUI.class.getName();
            uiContext.put((Object)"CanEdit", (Object)Boolean.FALSE);
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create(processUI, (Map)uiContext, null, state);
        window.show();
    }

    private void openCheck(CslReportInfo report) {
        if (report.getSourceType() == RptSrcTypeEnum.CONSOLIDATION || report.getSourceType() == RptSrcTypeEnum.DYNAMICCSLREPORT) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("GroupRpt_Cannot_Modify_CSL"));
            SysUtil.abort();
        }
        if (report.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || report.getSourceType().equals((Object)RptSrcTypeEnum.SUM) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT)) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("GroupRptSumOnlyForQuery"));
            SysUtil.abort();
        }
        if (report != null && report.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AUDITTED_REPORT_CANNOT_MODIFY"));
            SysUtil.abort();
        }
        if (report != null && report.getCommittedStatus() == CommittedStatusEnum.GROUPCOMMITTED) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptIsGroupCommited"));
            SysUtil.abort();
        }
        if (report != null && report.getCommittedStatus() == CommittedStatusEnum.COMMITTED) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CAN_NOT_MODIFY_COMMITTED_REPORT"));
            SysUtil.abort();
        }
        if (report != null && report.getPublishedStatus().getValue() == 2) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptIsPublished"));
            SysUtil.abort();
        }
        super.requestObjectLock(this.getObjectUpdateId());
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.openReport(OprtState.VIEW);
    }

    protected void filterQuery() throws Exception {
        FilterInfo filter;
        FilterItemCollection fic;
        DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)this.treeCompany.getLastSelectedPathComponent();
        if (currentNode == null) {
            this.filterQueryNull();
            return;
        }
        if (NewOrgUtils.isTreeNodeDisabled((DefaultKingdeeTreeNode)currentNode)) {
            this.filterQueryNull();
            this.actionAddNew.setEnabled(false);
            this.actionView.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionQuery.setEnabled(false);
            this.initQueryBudget();
            return;
        }
        this.actionAddNew.setEnabled(true);
        this.actionView.setEnabled(true);
        this.actionEdit.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.actionQuery.setEnabled(true);
        this.initQueryBudget();
        Object orgStructure = currentNode.getUserObject();
        if (orgStructure == null) {
            this.filterQueryNull();
            return;
        }
        if (this.currentFilter == null) {
            this.currentFilter = new FilterInfo();
        }
        if ((fic = (filter = (FilterInfo)this.currentFilter.clone()).getFilterItems()) == null) {
            fic = new FilterItemCollection();
        }
        StringBuffer maskString = new StringBuffer();
        int index = fic.size();
        if (filter.getMaskString() != null) {
            maskString.append("(" + filter.getMaskString() + ")");
        }
        fic.add(new FilterItemInfo("tree.id", (Object)this.orgBound.getId(), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        FullOrgUnitInfo orgUnit = ((OrgStructureInfo)orgStructure).getUnit();
        if (orgUnit == null) {
            this.filterQueryNull();
            return;
        }
        fic.add(new FilterItemInfo("orgUnit.id", (Object)orgUnit.getId(), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("orgUnit2.id", (Object)orgUnit.getId(), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("year", (Object)new Integer(this.year), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("period", (Object)new Integer(this.period), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("periodType", (Object)new Integer(this.periodType), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("dataCollectNumber", (Object)this.cslCtx.getCurDataCollect().getNumber(), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        String ms = maskString.toString();
        if (ms.startsWith(" and ")) {
            ms = ms.substring(" and ".length());
        }
        filter.setMaskString(ms);
        if (this.isFill) {
            this.isFill = false;
        }
        this.mainQuery.setFilter(filter);
        this.execQuery();
        if (CSLContextHelper.getCSLContext().getCurPublishedStatus()) {
            this.rptArchive();
        }
    }

    private void filterQueryNull() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"IMPOSSIBLE_VALUE(*_*)", CompareType.EQUALS));
        try {
            filter.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)this.cslCtx.getCurDataCollect().getNumber(), CompareType.EQUALS));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.mainQuery.setFilter(filter);
        this.execQuery();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        OrgUnitInfo selectedCompany = this.getSelectedCompany(false);
        uiContext.put((Object)"company", (Object)selectedCompany);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() != 0) {
            if (this.btnView.isVisible() && this.btnView.isEnabled() && this.tblMain.getRowCount() != 0 && this.tblMain.getSelectManager().size() != 0) {
                if (this.actionEdit.isVisible() && this.actionEdit.isEnabled()) {
                    this.checkSelected();
                    String selectId = this.getSelectedKeyValue();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("publishedStatus"));
                    sic.add(new SelectorItemInfo("auditedStatus"));
                    sic.add(new SelectorItemInfo("committedStatus"));
                    sic.add(new SelectorItemInfo("sourceType"));
                    CslReportInfo report = this.getReportInfo(selectId, sic);
                    if (report.getCommittedStatus() == CommittedStatusEnum.GROUPCOMMITTED || report.getAuditedStatus() == AuditedStatusEnum.AUDITED || report.getCommittedStatus() == CommittedStatusEnum.COMMITTED || report.getPublishedStatus().getValue() == 2) {
                        this.openReport(OprtState.VIEW);
                    } else {
                        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
                        if (PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPK, null, "rpt_report_update")) {
                            this.actionEdit_actionPerformed(new ActionEvent(this.btnEdit, 0, "Double Clicked"));
                        } else {
                            this.actionView_actionPerformed(new ActionEvent(this.btnView, 0, "Double Clicked"));
                        }
                    }
                } else {
                    this.actionView_actionPerformed(new ActionEvent(this.btnView, 0, "Double Clicked"));
                }
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    @Override
    protected void treeCompany_valueChanged(TreeSelectionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode;
        OrgUnitInfo obj;
        super.treeCompany_valueChanged(e);
        this.filterQuery();
        if (this.treeCompany.getSelectionCount() > 0 && (obj = OrgClientUtils.getOrgUnitFromTreeNode((DefaultKingdeeTreeNode)(treeNode = (DefaultKingdeeTreeNode)this.treeCompany.getLastSelectedPathComponent()))) != null && obj instanceof OrgUnitInfo) {
            OrgUnitInfo orgUnit = obj;
            if (this.period == 12 || this.period == 13) {
                if (orgUnit.isIsGrouping()) {
                    this.btGenerateNextYearInit.setEnabled(false);
                    this.generateNextYearInit.setEnabled(false);
                } else {
                    this.btGenerateNextYearInit.setEnabled(true);
                    this.generateNextYearInit.setEnabled(true);
                }
            }
            if (orgUnit.isIsGrouping() || this.ctx.isQueryBudget()) {
                this.actionBatchQueueCalc.setEnabled(false);
            } else {
                this.actionBatchQueueCalc.setEnabled(true);
            }
        }
    }

    private OrgUnitInfo getSelectedCompany(boolean includeGroup) {
        DefaultKingdeeTreeNode treeNode;
        OrgUnitInfo obj;
        OrgUnitInfo selectedCompany = null;
        boolean companySelected = false;
        if (this.treeCompany.getSelectionCount() > 0 && (obj = OrgClientUtils.getOrgUnitFromTreeNode((DefaultKingdeeTreeNode)(treeNode = (DefaultKingdeeTreeNode)this.treeCompany.getLastSelectedPathComponent()))) != null && obj instanceof OrgUnitInfo) {
            OrgUnitInfo orgUnit = obj;
            if (includeGroup) {
                return orgUnit;
            }
            if (!orgUnit.isIsGrouping()) {
                companySelected = true;
                selectedCompany = orgUnit;
            }
        }
        if (!companySelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_CompanyNull"));
            SysUtil.abort();
        }
        return selectedCompany;
    }

    private void initTree() throws EASBizException, BOSException {
        OrgTreeInfo treeInfo = this.cslCtx.getCurOrgBound();
        OrgUnitInfo currCompany = this.cslCtx.getCurOrgGroup();
        DefaultKingdeeTreeNode rootNode = CslOrgTreeUtil.getUnionDebtTree(currCompany, treeInfo, false);
        DefaultTreeModel model2 = new DefaultTreeModel((TreeNode)rootNode);
        this.treeCompany.setModel((TreeModel)model2);
        this.treeCompany.setSelectionNode(rootNode);
        model2.setAsksAllowsChildren(true);
        this.processNodeIcon(rootNode);
        this.treeCompany.expandAllNodes(true, (TreeNode)rootNode);
        if (MergeModeEnum.ORDINAL.equals((Object)CslRptUtil.getMergeMode(this.ctx.getCurOrgBound()))) {
            int n = rootNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.treeCompany.removeAllChildrenFromParent((MutableTreeNode)((DefaultKingdeeTreeNode)rootNode.getChildAt(i)));
            }
        }
        this.getAllNoGrouping(rootNode);
    }

    private void getAllNoGrouping(DefaultKingdeeTreeNode rootNode) {
        this.saveNoodeId((TreeNode)rootNode);
        if (rootNode.getChildCount() > 0) {
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                this.getAllNoGrouping((DefaultKingdeeTreeNode)rootNode.getChildAt(i));
            }
        }
    }

    private void saveNoodeId(TreeNode node) {
        OrgUnitInfo orgUnit;
        OrgUnitInfo objRoot = OrgClientUtils.getOrgUnitFromTreeNode((DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)node));
        if (objRoot != null && objRoot instanceof OrgUnitInfo && !(orgUnit = objRoot).isIsGrouping()) {
            this.noGroupIdSets.add(orgUnit.getId());
        }
    }

    private void processNodeIcon(DefaultKingdeeTreeNode node) {
        FullOrgUnitInfo orgUnit;
        if (node == null) {
            return;
        }
        boolean isGroup = false;
        Object orgStructure = node.getUserObject();
        if (orgStructure != null && (orgUnit = ((OrgStructureInfo)orgStructure).getUnit()) != null) {
            isGroup = orgUnit.isIsGrouping();
        }
        if (!node.isLeaf() || isGroup) {
            node.setAllowsChildren(true);
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.processNodeIcon((DefaultKingdeeTreeNode)node.getChildAt(i));
            }
        } else {
            node.setAllowsChildren(false);
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.isFill) {
            return;
        }
        super.tblMain_doRequestRowSet(e);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getOnloadFilter();
    }

    private FilterInfo getOnloadFilter() {
        FilterInfo filter = null;
        try {
            filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            if (fic == null) {
                fic = new FilterItemCollection();
            }
            StringBuffer maskString = new StringBuffer();
            int index = fic.size();
            if (filter.getMaskString() != null) {
                maskString.append("(" + filter.getMaskString() + ")");
            }
            fic.add(new FilterItemInfo("tree.id", (Object)this.cslCtx.getCurOrgBound().getId(), CompareType.EQUALS));
            maskString.append(" and #" + index++);
            fic.add(new FilterItemInfo("year", (Object)new Integer(this.cslCtx.getCurRptYear()), CompareType.EQUALS));
            maskString.append(" and #" + index++);
            fic.add(new FilterItemInfo("period", (Object)new Integer(this.cslCtx.getCurRptPeriod()), CompareType.EQUALS));
            maskString.append(" and #" + index++);
            fic.add(new FilterItemInfo("periodType", (Object)new Integer(this.cslCtx.getCurRptPeriodType().getValue()), CompareType.EQUALS));
            maskString.append(" and #" + index++);
            fic.add(new FilterItemInfo("dataCollectNumber", (Object)this.cslCtx.getCurDataCollect().getNumber(), CompareType.EQUALS));
            maskString.append(" and #" + index++);
            String ms = maskString.toString();
            if (ms.startsWith(" and ")) {
                ms = ms.substring(" and ".length());
            }
            filter.setMaskString(ms);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filter;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    private CslReportCollection getReportStatusById(List ids) throws Exception {
        HashSet set = new HashSet(ids);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isSupportGroup"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("auditedStatus"));
        view.getSelector().add(new SelectorItemInfo("publishedStatus"));
        view.getSelector().add(new SelectorItemInfo("committedStatus"));
        view.getSelector().add(new SelectorItemInfo("sourceType"));
        view.getSelector().add(new SelectorItemInfo("cslReport"));
        view.getSelector().add(new SelectorItemInfo("year"));
        view.getSelector().add(new SelectorItemInfo("period"));
        view.getSelector().add(new SelectorItemInfo("PeriodType"));
        view.getSelector().add(new SelectorItemInfo("PublicStatus"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        return CslReportFactory.getRemoteInstance().getCslReportCollection(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBatchCommit_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        CslReportCollection reports = this.getReportStatusById(list);
        boolean bExists = RptUtilForClient.checkExistsRequisition((IObjectCollection)reports);
        if (bExists && (i = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"528_GroupRptListUI"))) != 0) {
            SysUtil.abort();
        }
        Iterator iter = reports.iterator();
        while (iter.hasNext()) {
            CslReportInfo report = (CslReportInfo)iter.next();
            if (report.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT)) {
                MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("GroupRptCslOnlyForQuery"));
                SysUtil.abort();
            }
            if (!report.getSourceType().equals((Object)RptSrcTypeEnum.SUM) && !report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT)) continue;
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("GroupRptSumOnlyForQuery"));
            SysUtil.abort();
        }
        ArrayList lockObjectIdList = new ArrayList();
        try {
            MutexHelp.requestDataObjectLock((CoreUI)this, (List)list, lockObjectIdList);
            CslRptUIUtil.batchCommit(this, list);
        }
        catch (Throwable e1) {
            this.handUIException(e1);
            this.abort();
        }
        finally {
            MutexHelp.releaseDataObjectLock((CoreUI)this, lockObjectIdList);
        }
    }

    @Override
    public void actionBatchAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("sourceType"));
        for (String element : list) {
            CslReportInfo report = this.getReportInfo(element, sic);
            if (report.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT)) {
                MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("GroupRptCslOnlyForQuery"));
                SysUtil.abort();
            }
            if (!report.getSourceType().equals((Object)RptSrcTypeEnum.SUM) && !report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT)) continue;
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("GroupRptSumOnlyForQuery"));
            SysUtil.abort();
        }
        CslRptCalcUtil.batchCheckMutexLock((Component)((Object)this), list, true, true);
        CslRptUIUtil.batchAudit(this, this.tblMain, list);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String boID = this.getSelectedKeyValue();
        boolean isEdit = true;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("sourceType"));
        if (this.ctx.isQueryBudget()) {
            isEdit = false;
        } else {
            CslReportInfo report = this.getReportInfo(boID, sic);
            AuditedStatusEnum auditStatus = report.getAuditedStatus();
            if (auditStatus.getValue() == 2) {
                isEdit = false;
            }
        }
        RptUtil.showAttachmentListUIByBoID((boolean)true, (String)boID, (Object)this, (boolean)isEdit);
    }

    @Override
    protected void maintainYearInitDataKDMenu_menuSelected(MenuEvent e) throws Exception {
        ArrayList reportIDList = this.getSelectedIdValues();
        this.canMaintainReportIDList = new ArrayList();
        this.canGenReportIDList = new ArrayList();
        Iterator reportIDIt = reportIDList.iterator();
        CslReportInfo clsReportInfo = null;
        while (reportIDIt.hasNext()) {
            String reportID = (String)reportIDIt.next();
            clsReportInfo = CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectUuidPK(reportID));
            if (clsReportInfo == null) continue;
            this.canMaintainReportIDList.add(reportID);
            if (!FiscalPeriodHelper.isGeneratePeriod(this.periods, clsReportInfo.getYear(), clsReportInfo.getPeriod(), clsReportInfo.getPeriodType(), this.isMergeByFiscalPeriod)) continue;
            this.canGenReportIDList.add(reportID);
        }
        if (this.canMaintainReportIDList.size() <= 0) {
            this.maintainYearInitDataKDMenuItem.setEnabled(false);
        } else {
            this.maintainYearInitDataKDMenuItem.setEnabled(true);
        }
        if (this.canGenReportIDList.size() <= 0) {
            this.generateYearInitDataKDMenuItem.setEnabled(false);
        } else {
            this.generateYearInitDataKDMenuItem.setEnabled(true);
        }
        if (this.ctx.getCurDataCollect() != null && this.ctx.getCurDataCollect().getNumber() != null && "BUDGETDATA".equals(this.ctx.getCurDataCollect().getNumber())) {
            this.maintainYearInitDataKDMenu.setEnabled(false);
        }
        super.maintainYearInitDataKDMenu_menuSelected(e);
    }

    @Override
    protected void maintainYearInitDataKDMenuItem_actionPerformed(ActionEvent e) throws Exception {
        super.maintainYearInitDataKDMenuItem_actionPerformed(e);
        if (this.canMaintainReportIDList != null && this.canMaintainReportIDList.size() > 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ReportIDList", (Object)this.canMaintainReportIDList);
            uiContext.put((Object)"CompanyDisplayName", (Object)((DefaultKingdeeTreeNode)this.treeCompany.getLastSelectedPathComponent()).getText());
            uiContext.put((Object)"ParentUI", (Object)this);
            uiContext.put((Object)"RptSourceType", (Object)new Integer(7));
            uiContext.put((Object)"KEY_DATACOLLECT_NUMBER", (Object)this.ctx.getCurDataCollect().getNumber());
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MaintainYearInitDataUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            window.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"GroupRptList_Dialog_RptSelect"));
        }
    }

    @Override
    protected void generateYearInitDataKDMenuItem_actionPerformed(ActionEvent e) throws Exception {
        super.generateYearInitDataKDMenuItem_actionPerformed(e);
        if (this.canGenReportIDList != null && this.canGenReportIDList.size() > 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ReportIDList", (Object)this.canGenReportIDList);
            if (this.treeCompany != null && this.treeCompany.getLastSelectedPathComponent() != null) {
                uiContext.put((Object)"CompanyDisplayName", (Object)((DefaultKingdeeTreeNode)this.treeCompany.getLastSelectedPathComponent()).getText());
            } else {
                uiContext.put((Object)"CompanyDisplayName", (Object)SysContext.getSysContext().getCurrentOrgUnit().getName());
            }
            uiContext.put((Object)"KEY_DATACOLLECT_NUMBER", (Object)this.ctx.getCurDataCollect().getNumber());
            if (this.canGenReportIDList.size() == 1) {
                CslReportInfo clsReportInfo = CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectUuidPK((String)this.canGenReportIDList.get(0)));
                uiContext.put((Object)"Year", (Object)String.valueOf(clsReportInfo.getYear()));
                uiContext.put((Object)"Period", (Object)String.valueOf(clsReportInfo.getPeriod()));
                clsReportInfo = null;
            }
            uiContext.put((Object)"ParentUI", (Object)this);
            uiContext.put((Object)"RptSourceType", (Object)new Integer(7));
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GenerateNextYearInitDataUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            window.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"GroupRptList_Dialog_RptSelect"));
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FI_GR_CSLREPORT;
    }

    protected boolean isShowAttachmentAction() {
        return true;
    }

    @Override
    public void actionGenVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String oql = GenVoucherUtilForClient.getInstance().getGenVoucherOql(this.tblMain);
        CoreBaseCollection reports = CslReportFactory.getRemoteInstance().getCollection(oql);
        Map returnDetail = GenVoucherUtilForClient.getInstance().genVoucher(reports);
        int succeCount = (Integer)returnDetail.get("succeCount");
        int errorCount = (Integer)returnDetail.get("errorCount");
        String msgDetail = (String)returnDetail.get("detailMsg");
        if (succeCount > 0) {
            this.setMessageText(msgDetail);
            this.showMessage();
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)MessageFormat.format(CslRptUtil.getString("succeErrorCount"), succeCount, errorCount), (String)msgDetail, (int)1);
        }
    }

    @Override
    public void actionCopyHisRpt_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        OrgUnitInfo selectedCompany = this.getSelectedCompany(true);
        if (selectedCompany != null) {
            uiContext.put((Object)"selectCompanyId", (Object)selectedCompany.getId().toString());
            uiContext.put((Object)"companyisIsGrouping", (Object)selectedCompany.isIsGrouping());
        }
        IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(CopyGroupRptHisDataListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        CopyGroupRptHisDataListUI copyHisDataListUI = (CopyGroupRptHisDataListUI)curUIWindow.getUIObject();
        curUIWindow.show();
    }

    private MetaDataPK initQueryBudget() {
        MetaDataPK mdPK = null;
        try {
            if (CSLContextHelper.getCSLContext().isQueryBudget()) {
                mdPK = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"HisGroupRptQuery");
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionBatchAudit.setEnabled(false);
                this.actionBatchCommit.setEnabled(false);
                this.actionCopyHisRpt.setEnabled(false);
                this.actionAddNew.setVisible(false);
                this.actionEdit.setVisible(false);
                this.actionRemove.setVisible(false);
                this.actionBatchAudit.setVisible(false);
                this.actionBatchCommit.setVisible(false);
                this.actionCopyHisRpt.setVisible(false);
                this.menuEdit.setEnabled(false);
                this.menuEdit.setVisible(false);
                this.maintainYearInitDataKDMenu.setVisible(false);
                this.maintainYearInitDataKDMenu.setEnabled(false);
                this.maintainYearInitDataKDMenuItem.setVisible(false);
                this.maintainYearInitDataKDMenuItem.setEnabled(false);
                this.generateYearInitDataKDMenuItem.setVisible(false);
                this.generateYearInitDataKDMenuItem.setEnabled(false);
            } else {
                mdPK = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"GroupRptQuery");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        return mdPK;
    }

    public void afterActionPerformed(ActionEvent e) {
        super.afterActionPerformed(e);
        this.initQueryBudget();
    }

    @Override
    public void actionBatchQueueCalc_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectIds();
        int confirm = MsgBox.showConfirm2((Component)((Object)this), (String)RptUtil.getReportResource((String)"ReportBatchCalcIntoQueue"));
        if (!MsgBox.isYes((int)confirm)) {
            SysUtil.abort();
        }
        this.reportCalcColl = CslRptUIUtil.getUnauditedAndNoLuolieCslRptList(ids);
        if (this.reportCalcColl == null || this.reportCalcColl.size() == 0) {
            return;
        }
        CslReportCollection needCalRptColl = CslRptUIUtil.getNeedCalCslRportColl((CoreUIObject)this, this.reportCalcColl);
        if (needCalRptColl.size() == 0) {
            return;
        }
        this.reportCalcColl = needCalRptColl;
        Thread t = new Thread(this);
        t.setName("Cslreport batch calc");
        t.start();
    }

    @Override
    public void run() {
        try {
            logger.info((Object)"rptreport queue calc start");
            IReportBatchCalculateFacade iBatchCalc = ReportBatchCalculateFacadeFactory.getRemoteInstance();
            int size = this.reportCalcColl.size();
            ArrayList<CslReportInfo> needCalList = new ArrayList<CslReportInfo>(size);
            for (int i = 0; i < size; ++i) {
                needCalList.add(this.reportCalcColl.get(i));
            }
            List returnList = iBatchCalc.batchQueueCalcCslReport(needCalList, null);
            logger.info((Object)"report queue calc end");
        }
        catch (Exception e1) {
            logger.info((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void setRptFromValue(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            ICell rptFromCell;
            if (this.tblMain.getRow(i) == null || (rptFromCell = this.tblMain.getRow(i).getCell("rptFrom")).getValue() == null) continue;
            rptFromCell.setValue((Object)RptSystemFrom.getEnum(rptFromCell.getValue().toString()));
        }
    }

    protected void initKeyStroke() {
        super.initKeyStroke();
        RegisterWindowKeyListenerHelper.registerClearCacheKeyListener((CoreUI)this);
    }

    @Override
    public void actionRptInExcel_actionPerformed(ActionEvent e) throws Exception {
        if (!GroupRptListUI.class.getName().equals(this.getClass().getName())) {
            return;
        }
        super.actionRptInExcel_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"parentUI", (Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GroupRpt_RptInExcelImportWizardUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }
}

