/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractGroupTemplateProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.DataElementRelatingSetUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptTmpGuilde_FromCslRptTmp;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsTemplateItemReviseHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.TemplateSumTypeEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.template.GroupTemplateProcessMenuStrategy;
import com.kingdee.eas.fi.gr.cslrpt.client.template.TemplateProcessBookProvider;
import com.kingdee.eas.fi.gr.dynamic.client.TemplateWizardUICreator;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.ReportMenuState;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.util.RowColChangeUtils;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneRecordCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneRecordFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneRecordInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.InvestElimManuScriptWizardUI;
import com.kingdee.eas.fi.newrpt.util.ParamCache;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSumTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateHelper;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VersionStatusEnum;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.fi.rpt.util.TemplateVersionMgr;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class GroupTemplateProcessUI
extends AbstractGroupTemplateProcessUI {
    private static final long serialVersionUID = 6443030412107044164L;
    private TemplateSumTypeEditUI sumTypeUI;
    private boolean isDynaSum = false;
    private boolean isSupport = false;
    private CslRptUIUtil cslRptUIUtil;

    private void copyActualFormulaToBudgetFormula() {
        Book book = this.getBook();
        if (book != null) {
            int sheetCount = this.getBook().getSheetCount();
            for (int k = 0; k < sheetCount; ++k) {
                Sheet sheet = book.getSheet(k);
                int maxRowIndex = sheet.getMaxRowIndex() + 1;
                for (int i = 0; i <= maxRowIndex; ++i) {
                    int maxColIndex = sheet.getMaxColIndex() + 1;
                    for (int j = 0; j <= maxColIndex; ++j) {
                        Cell cell = sheet.getCell(i, j, false);
                        if (cell == null || cell == null) continue;
                        String formula = TemplateHelper.getFormulaFromUserObject((Cell)cell, (String)"0");
                        cell.setUserObject("1", (Object)formula);
                        if (formula == null) continue;
                        cell.setFormula(formula);
                    }
                }
            }
        }
    }

    public GroupTemplateProcessUI() throws Exception {
        this.setMenuStrategy((IMenuStrategy)new GroupTemplateProcessMenuStrategy());
        this.setBookProvider(new TemplateProcessBookProvider());
        this.isDynaSum = CslRptUtil.getCslParamForDynamicSumRpt(null);
    }

    private RptPeriodTypeEnum getPeriodType() {
        return ((TemplateProcessBookProvider)this.getBookProvider()).getTemplateInfo().getPeriodType();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemValidation.setVisible(true);
        this.menuItemValidation.setEnabled(true);
        this.setCopyImportStatus();
        TemplateInfo template = (TemplateInfo)this.getEditData();
        if (template.getVersionStatus().equals((Object)VersionStatusEnum.VERSION) && template.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED)) {
            this.actionToolsRptAudit.setEnabled(false);
        }
        this.enableMnsMenu(template);
        this.menuItemAudit.setMnemonic('E');
        this.menuInsert.add((Component)this.menuItemInsertPic, 8);
        this.menuItemInsertPic.setVisible(true);
        this.menuItemInsertPic.setEnabled(true);
        this.actionInsertPicture.setVisible(true);
        this.actionInsertPicture.setEnabled(true);
        this.showBtnByOrgAndEntityStatus();
        if (template.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICCSLREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICSUMREPORT)) {
            this.kDMenuRowColChange.setVisible(true);
        }
    }

    private void showBtnByOrgAndEntityStatus() {
        TemplateInfo templateInfo;
        String CurrentOrgID;
        String CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (CurrentCreateOrgID.equals(CurrentOrgID = (templateInfo = this.getTemplateProvider().getTemplateInfo()).getCompany().getId().toString())) {
            this.menuItemAudit.setEnabled(true);
            this.menuItemUndo.setEnabled(true);
            if (templateInfo.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED) || this.getOprtState() == OprtState.VIEW) {
                this.actionSave.setEnabled(false);
            } else {
                this.actionSave.setEnabled(true);
            }
        } else {
            this.menuItemAudit.setEnabled(false);
            this.menuItemUndo.setEnabled(false);
            this.actionSave.setEnabled(false);
        }
    }

    private void enableMnsMenu(TemplateInfo template) {
        if (template.getTemplateType().equals((Object)RptTmpTypeEnum.MANUSCRIPT)) {
            this.menuDataElementRelating.setEnabled(true);
            this.menuDataElementRelating.setVisible(true);
            VariableEntry entry = this.getBookProperties().getVariables().get("isSupport", this.getBook().getName());
            if (entry == null) {
                entry = new VariableEntry("isSupport", this.getBook().getName());
                this.isSupport = false;
            } else {
                this.isSupport = Boolean.valueOf(entry.getValue());
            }
            if (this.isSupport) {
                this.menuItemSupportInputElimNumByHand.setSelected(true);
            } else {
                this.menuItemSupportInputElimNumByHand.setSelected(false);
            }
            if (this.getOprtState().equals(OprtState.VIEW)) {
                this.menuItemSupportInputElimNumByHand.setEnabled(false);
            } else {
                this.menuItemSupportInputElimNumByHand.setEnabled(true);
                BookProperties p = this.getBookProperties();
                entry.setValue(String.valueOf(this.isSupport));
                entry.setVisible(false);
                p.getVariables().addOrReplace(entry);
                p.restoreToBook(this.getBook());
            }
            this.menuItemSupportInputElimNumByHand.setVisible(true);
            this.menuItemSupportInputElimNumByHand.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GroupTemplateProcessUI.this.menuItemSupportInputElimNumByHand.isSelected()) {
                        GroupTemplateProcessUI.this.isSupport = true;
                    } else {
                        GroupTemplateProcessUI.this.isSupport = false;
                    }
                    BookProperties p = GroupTemplateProcessUI.this.getBookProperties();
                    VariableEntry entry = new VariableEntry("isSupport", GroupTemplateProcessUI.this.getBook().getName());
                    entry.setValue(String.valueOf(GroupTemplateProcessUI.this.isSupport));
                    entry.setVisible(false);
                    p.getVariables().addOrReplace(entry);
                    p.restoreToBook(GroupTemplateProcessUI.this.getBook());
                }
            });
        } else if (template.getTemplateType().equals((Object)RptTmpTypeEnum.INVESTELIMMANUSCRIPT)) {
            this.menuSendMail.setVisible(false);
            this.rMenuSendMail.setVisible(false);
            this.menuFormulaState.setVisible(false);
            this.menuItemViewItemFormula.setVisible(false);
            if (template.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED)) {
                this.actionInvestElimMnsTmplWizard.setVisible(false);
            } else {
                this.actionInvestElimMnsTmplWizard.setVisible(true);
            }
        }
    }

    protected void onSheetActive(Sheet sheet) {
        super.onSheetActive(sheet);
        int reportClass = this.getVariables().getIntValue("SheetClass", sheet.getSheetName(), 1);
        boolean isElimination = reportClass == 10;
        boolean isExchange = reportClass == 20;
        TemplateInfo template = (TemplateInfo)this.getEditData();
        boolean isInvestManuScript = false;
        if (template.getTemplateType().equals((Object)RptTmpTypeEnum.INVESTELIMMANUSCRIPT)) {
            isInvestManuScript = true;
        }
        if (isInvestManuScript) {
            this.getMenuStrategy().enableVisibleMenu("menuTool/miInnerCompanyFill", false, false);
            this.getMenuStrategy().enableVisibleMenu("menuTool/orgBoundSelect", false, false);
        } else {
            this.getMenuStrategy().enableVisibleMenu("menuTool/miInnerCompanyFill", true, isElimination || isExchange);
            this.getMenuStrategy().enableVisibleMenu("menuTool/orgBoundSelect", true, isElimination || isExchange);
        }
    }

    protected void initActions() {
        super.initActions();
        this.menuItemInsertItemFormula.setCustomAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GroupTemplateProcessUI.this.getSpreadManager().doPickItemFormulaAction();
            }
        });
        if (this.getTemplateProvider().getTemplateInfo().getTemplateType().equals((Object)RptTmpTypeEnum.MANUSCRIPT)) {
            this.menuItemClearItemFormula.setCustomAction((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GroupTemplateProcessUI.this.getBook().getActiveSheet().getSelectionRange().clear(false, false, false, false, new String[]{"ITEM"});
                    MnsTemplateItemReviseHelper.clearItemSheet(GroupTemplateProcessUI.this.getBook().getActiveSheet(), false);
                }
            });
            this.menuItemRightClearItemFormula.setCustomAction(this.menuItemClearItemFormula.getAction());
        }
    }

    protected CoreBaseInfo getEditData() {
        return (CoreBaseInfo)this.getBookProvider().getEditValue();
    }

    private void setCopyImportStatus() {
        RptTmpTypeEnum templateType = ((TemplateInfo)this.getEditData()).getTemplateType();
        if (templateType.equals((Object)RptTmpTypeEnum.SUMREPORT) || templateType.equals((Object)RptTmpTypeEnum.CSLREPORT) || templateType.equals((Object)RptTmpTypeEnum.MANUSCRIPT) || templateType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || templateType.equals((Object)RptTmpTypeEnum.DYNAMICSUMREPORT) || templateType.equals((Object)RptTmpTypeEnum.DYNAMICCSLREPORT)) {
            this.itemCopyImport.setVisible(true);
            this.itemCopyImport.setEnabled(true);
            this.actionFileCopyImport.setEnabled(true);
            this.actionFileCopyImport.setVisible(true);
        } else {
            this.itemCopyImport.setVisible(false);
            this.actionFileCopyImport.setEnabled(false);
        }
    }

    public IObjectPK getTemplatePK() {
        return new ObjectUuidPK(this.getEditData().getId());
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        TemplateInfo templateInfo = this.getTemplateProvider().getTemplateInfo();
        BOSUuid id = templateInfo.getId();
        if (CslRptUIUtil.isInWorkFlowProcessing(id)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"TemplateInWorkFlowAlready"));
            SysUtil.abort();
        }
        this.checkIsTmpOrgCurrentOrg();
        ObjectStringPK pk = null;
        if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT) && CslRptUIUtil.isAuditedForTemplet((IObjectPK)(pk = new ObjectStringPK(this.getEditData().getId().toString())))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_TmpAudited"));
            return;
        }
        super.actionSave_actionPerformed(e);
        this.saveSceneRecordForInvestElimMns();
    }

    private void saveSceneRecordForInvestElimMns() throws Exception {
        TemplateInfo templateInfo = this.getTemplateProvider().getTemplateInfo();
        RptTmpTypeEnum tmpType = templateInfo.getTemplateType();
        String tmplid = templateInfo.getId().toString();
        String split = ",";
        if (tmpType.getValue() == 21) {
            Book book = templateInfo.getBook();
            int sheetCount = book.getSheetCount();
            SceneRecordCollection sceneRecords = new SceneRecordCollection();
            for (int i = 0; i < sheetCount; ++i) {
                String[] sceneIds;
                Sheet sheet = book.getSheet(i);
                if (sheet.getUserObject("sceneIds") == null) continue;
                String sceneIdsString = String.valueOf(sheet.getUserObject("sceneIds").getValue());
                for (String sceneId : sceneIds = sceneIdsString.split(split)) {
                    SceneRecordInfo sceneRecord = new SceneRecordInfo();
                    sceneRecord.setTemplate(templateInfo);
                    SceneInfo sceneInfo = new SceneInfo();
                    sceneInfo.setId(BOSUuid.read((String)sceneId));
                    sceneRecord.setScene(sceneInfo);
                    sceneRecord.setSheet(sheet.getID());
                    sceneRecords.add(sceneRecord);
                }
            }
            if (sceneRecords.size() > 0) {
                if (SceneRecordFactory.getRemoteInstance().exists("where template = '" + tmplid + "'")) {
                    SceneRecordFactory.getRemoteInstance().delete("where template = '" + tmplid + "'");
                }
                Iterator it = sceneRecords.iterator();
                while (it.hasNext()) {
                    SceneRecordFactory.getRemoteInstance().addnew((SceneRecordInfo)it.next());
                }
            }
        }
    }

    private void checkIsTmpOrgCurrentOrg() {
        TemplateInfo templateInfo;
        String CurrentOrgID;
        String CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (!CurrentCreateOrgID.equals(CurrentOrgID = (templateInfo = this.getTemplateProvider().getTemplateInfo()).getCompany().getId().toString())) {
            String promptMsg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"892CannotUpdateTempletNotCurremtOrg");
            MsgBox.showInfo((String)promptMsg);
            SysUtil.abort();
        }
    }

    public void actionToolsRptAudit_actionPerformed(ActionEvent e) throws Exception {
        ITemplate it;
        String hint;
        ParamCache.cacheParams((String[])new String[]{"GR_CSL_CheckNumber", "GR_CSL_SyncTemplateReport"});
        Book book = this.getBook();
        CslRptUIUtil.dynaTemplateAudit((TemplateInfo)this.getEditData(), book);
        if (((TemplateInfo)this.getEditData()).getAuditedStatus().equals((Object)AuditedStatusEnum.UNAUDITED)) {
            this.actionToolsCheckItemFormula_actionPerformed(e);
        }
        if (this.isModify()) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"PleaseSave"));
            SysUtil.abort();
        }
        if (CslRptUIUtil.isInWorkFlowProcessing(this.getEditData().getId())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"TemplateInWorkFlowAlready"));
            SysUtil.abort();
        }
        TemplateInfo template = (TemplateInfo)this.getEditData();
        this.isDynaSum = CslRptUtil.getCslParamForDynamicSumRpt(null);
        if (this.isDynaSum && template.getAuditedStatus().equals((Object)AuditedStatusEnum.UNAUDITED)) {
            this.checkDynamicSumKeyZone();
        }
        if (ParamCache.getParamValue((String)"GR_CSL_SyncTemplateReport") && !StringUtils.isEmpty((String)(hint = CslReportFactory.getRemoteInstance().getUnCommittedReport(template.getId().toString(), false)))) {
            MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"504_GroupNormalProcessUI"), (String)hint);
            return;
        }
        if (TemplateVersionMgr.isNewGroupVersion((String)template.getVersionNumber()) && template.isIsAutoUpdate() && template.getAuditedStatus().equals((Object)AuditedStatusEnum.UNAUDITED)) {
            if (this.oprtState == OprtState.EDIT) {
                this.actionSave_actionPerformed(e);
            }
            if (MsgBox.showConfirm2((String)CslRptUtil.getStringWithCR("Template_Audit_AutoUpdate_Confirm")) != 0) {
                return;
            }
        }
        if (template.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED) && !(it = TemplateFactory.getRemoteInstance()).isLastestVersion(template.getId().toString(), true, false)) {
            MsgBox.showError((String)CslRptUtil.getString("GroupNormalTemplateExistsNewVersion"));
            SysUtil.abort();
        }
        this.getTemplateProvider().auditGroupTemplate((Object)this);
        if (this.isDynaSum) {
            SumcalcRange keyRange = this.getBook().getActiveSheet().getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)this.getBook().getActiveSheet().getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange valueRange = this.getBook().getActiveSheet().getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)this.getBook().getActiveSheet().getUserObjectValue("DYNAMICSUMVALUEZONE");
            this.paintBackColor(this.getBook().getActiveSheet(), keyRange);
            this.paintBackColor(this.getBook().getActiveSheet(), valueRange);
        }
        this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"505_GroupNormalProcessUI"));
        super.actionToolsRptAudit_actionPerformed(e);
        this.enableMnsMenu(template);
        this.actionViewItemFormula_actionPerformed(e);
    }

    public void actionToolsWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        ObjectStringPK pk = new ObjectStringPK(this.getEditData().getId().toString());
        if (CslRptUIUtil.isAuditedForTemplet((IObjectPK)pk)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_TmpAudited"));
        } else {
            super.actionToolsWorkFlow_actionPerformed(e);
            this.actionToolsCheckItemFormula_actionPerformed(e);
            if (this.isDynaSum) {
                this.checkDynamicSumKeyZone();
            }
            CslRptUIUtil.checkForTempletAudit((IObjectPK)pk);
            this.wfContext.addToDataMap((Object)this.getEditData().getId().toString(), (IObjectValue)this.getEditData());
            TemplateFactory.getRemoteInstance().submitCslWF(this.getEditData().getId());
            this.showSuccessMsg(RptUtil.getResourceSince51((String)"SubmitSuccess"));
        }
    }

    @Override
    public void actionSaveSumZone_actionPerformed(ActionEvent e) throws Exception {
        super.actionSaveSumZone_actionPerformed(e);
    }

    private void setShortCutKeyForAuditAction(CoreUIObject ui, Action action, String helper) {
        if (ui == null || action == null) {
            return;
        }
        KeyStroke ks = KeyStroke.getKeyStroke("control shift " + helper);
        IUIWindow wnd = ui.getUIWindow();
        JRootPane jp = null;
        JLayeredPane lp = null;
        if (wnd instanceof JFrame) {
            jp = ((JFrame)wnd).getRootPane();
            lp = ((JFrame)wnd).getLayeredPane();
        }
        String strKey = "CONTROL_SHIFT_" + helper;
        if (jp != null) {
            jp.getActionMap().put(strKey, action);
            jp.getInputMap(2).put(ks, strKey);
        }
        if (lp != null) {
            lp.getActionMap().put(strKey, action);
            lp.getInputMap(2).put(ks, strKey);
        }
    }

    public void onShow() {
        super.onShow();
        this.setShortCutKeyForAuditAction((CoreUIObject)this, (Action)this.actionSaveSumZone, "S");
        if (this.getTemplateProvider().getTemplateInfo().getTemplateType().equals((Object)RptTmpTypeEnum.MANUSCRIPT)) {
            MnsTemplateItemReviseHelper.registerDefaultItemFormulaChangeListener(this.getSpreadManager());
        }
    }

    private TemplateProcessBookProvider getTemplateProvider() {
        return (TemplateProcessBookProvider)this.getBookProvider();
    }

    @Override
    public void actionToolsWorkDraftWizard_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolsWorkDraftWizard_actionPerformed(e);
        CslRptUIUtil.setDataElementRelatingColor(-1, this.getBook());
        TemplateInfo ti = (TemplateInfo)this.getEditData();
        if (ti.getTemplateType().getValue() != 1 && ti.getTemplateType().getValue() != 14) {
            this.getCslRptUIUtilInstance().WorkDraftWizard((Object)this, ti, this.getUIContext());
        }
        CslRptUIUtil.setDataElementRelatingColor(super.getBookProperties().getDataElementRelating(), this.getBook());
        this.repaint();
    }

    @Override
    public void actionToolsWorkDraftRowWizard_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolsWorkDraftRowWizard_actionPerformed(e);
        TemplateInfo ti = (TemplateInfo)this.getEditData();
        if (ti.getTemplateType().getValue() != 1) {
            this.getCslRptUIUtilInstance().WorkDraftRowWizard((Object)this, ti, this.getUIContext());
        }
        CslRptUIUtil.setDataElementRelatingColor(super.getBookProperties().getDataElementRelating(), this.getBook());
        this.repaint();
    }

    @Override
    public void actionToolsWorkDraftColumnWizard_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolsWorkDraftColumnWizard_actionPerformed(e);
        TemplateInfo ti = (TemplateInfo)this.getEditData();
        if (ti.getTemplateType().getValue() != 1) {
            HashMap point = CslRptUtil.getBasePosition(this.getBook().getActiveSheet());
            if (point == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"530_GroupTemplateProcessUI"));
                SysUtil.abort();
            }
            this.getCslRptUIUtilInstance().WorkDraftColumnWizard((Object)this, ti, this.getUIContext());
        }
        CslRptUIUtil.setDataElementRelatingColor(super.getBookProperties().getDataElementRelating(), this.getBook());
        this.repaint();
    }

    private CslRptUIUtil getCslRptUIUtilInstance() {
        if (this.cslRptUIUtil == null) {
            this.cslRptUIUtil = new CslRptUIUtil();
        }
        return this.cslRptUIUtil;
    }

    @Override
    public void actionDataTempletWizard_actionPerformed(ActionEvent e) throws Exception {
        TemplateInfo ti;
        super.actionDataTempletWizard_actionPerformed(e);
        if (this.isSheetBookProtected()) {
            this.abort();
        }
        if ((ti = (TemplateInfo)this.getEditData()).getTemplateType().getValue() != 1) {
            this.getCslRptUIUtilInstance().editTmpGuide((Object)this, ti, this.getUIContext());
        }
        this.getMenuStrategy().refreshMenu(new ReportMenuState(this.getOprtState(), this.getBookProvider()), true);
    }

    public void actionInnerCompanyFill_actionPerformed(ActionEvent e) throws Exception {
        super.actionInnerCompanyFill_actionPerformed(e);
    }

    @Override
    public void actionModifyDynaRange_actionPerformed(ActionEvent e) throws Exception {
        super.actionModifyDynaRange_actionPerformed(e);
        TemplateWizardUICreator.show((IUIObject)this, (SpreadManager)this.getSpreadManager(), (IBookProvider)this.getBookProvider(), (boolean)false, (boolean)true);
    }

    protected void initSumTypeUI() throws Exception {
        if (this.sumTypeUI == null) {
            String uiclass = TemplateSumTypeEditUI.class.getName();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"EIDT_DATA", (Object)this.getBookProvider().getEditValue());
            IUIFactory factory = UIFactory.createUIFactory();
            IUIWindow newWindow = factory.create(uiclass, (Map)uiContext, null, OprtState.VIEW);
            this.sumTypeUI = (TemplateSumTypeEditUI)newWindow.getUIObject();
        } else {
            this.sumTypeUI.onLoad();
        }
    }

    @Override
    public void actionSumType_actionPerformed(ActionEvent e) throws Exception {
        boolean isByitem;
        super.actionSumType_actionPerformed(e);
        TemplateInfo template = null;
        RptSumTypeEnum oldTemplateType = null;
        template = (TemplateInfo)this.getBookProvider().getEditValue();
        if (template != null && template.getSumType() != null) {
            oldTemplateType = template.getSumType();
        }
        if (this.sumTypeUI == null) {
            this.initSumTypeUI();
        }
        this.sumTypeUI.getUIWindow().show();
        template = (TemplateInfo)this.getBookProvider().getEditValue();
        boolean isRepaint = false;
        boolean bl = isByitem = template.getSumType().getValue() == 2;
        if (template != null && template.getSumType() != null && oldTemplateType != null && oldTemplateType.getValue() == 1 && isByitem) {
            Book book = this.getBook();
            if (book != null && book.getSheetCount() > 0) {
                int sheetCount = book.getSheetCount();
                for (int i = 0; i < sheetCount; ++i) {
                    Sheet sheet = book.getSheet(i);
                    if (sheet.getUserObjectValue("DYNAMICSUMKEYZONE") != null) {
                        isRepaint = true;
                    }
                    sheet.removeUserObject("DYNAMICSUMVALUEZONE");
                    sheet.removeUserObject("DYNAMICSUMKEYZONE");
                }
            }
            if (isRepaint) {
                this.repaint();
            }
        }
        IMenuStrategy menuStrategy = this.getMenuStrategy();
        menuStrategy.enableVisibleMenu("menuEdit/menuSumRange", !isByitem, !isByitem, true);
        menuStrategy.enableVisibleMenu("menuView/menuItemViewSumRange", !isByitem, !isByitem);
        this.menuRCSumZone.setVisible(!isByitem);
    }

    @Override
    public void actionDataElementRelating_actionPerformed(ActionEvent e) throws Exception {
        super.actionDataElementRelating_actionPerformed(e);
        BookProperties p = this.getBookProperties();
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"dataElementRelating", (Object)p.getDataElementRelating());
        ctx.put((Object)"isEditable", (Object)Boolean.TRUE);
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataElementRelatingSetUI.class.getName(), (Map)ctx);
        DataElementRelatingSetUI setui = (DataElementRelatingSetUI)ui.getUIObject();
        ui.show();
        if (!setui.isCancel()) {
            p.setDataElementRelating(setui.getResult());
            p.restoreToBook(this.getBook());
            CslRptUIUtil.setDataElementRelatingColor(setui.getResult(), this.getBook());
        }
        this.repaint();
    }

    @Override
    public void actionImportFromCslRptTmp_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportFromCslRptTmp_actionPerformed(e);
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"KEY_KDTABLE", (Object)this.getBook().getActiveSheet());
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MnsRptTmpGuilde_FromCslRptTmp.class.getName(), (Map)ctx);
        ui.show();
        this.repaint();
    }

    @Override
    public void actionInvestElimMnsTmplWizard_actionPerformed(ActionEvent e) throws Exception {
        super.actionInvestElimMnsTmplWizard_actionPerformed(e);
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"KEY_KDTABLE", (Object)this.getBook().getActiveSheet());
        ctx.put((Object)"spreadManager", (Object)this.getSpreadManager());
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvestElimManuScriptWizardUI.class.getName(), (Map)ctx);
        ui.show();
        this.repaint();
    }

    @Override
    public void actionRowColChange_actionPerformed(ActionEvent e) throws Exception {
        RowColChangeUtils.showGuide((IUIObject)this, (SpreadManager)this.getSpreadManager(), (Book)this.getBook());
    }
}

