/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimImportBasicTreeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimRelaOrgTree;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.RecordTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractImportEliminationForBudgetUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class ImportEliminationForBudgetUI
extends AbstractImportEliminationForBudgetUI
implements ICSLContextUI {
    private List companyIds;
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private OrgTreeInfo orgTreeInfo = null;
    private OrgUnitInfo orgUnitInfo = null;
    private RptPeriodTypeEnum periodType;
    private int year;
    private int period;
    private ElimImportBasicTreeEnum elimImportbasicType;
    IOrgStructure structure = OrgStructureFactory.getRemoteInstance();
    IElimRelaOrgTree iElimRela = ElimRelaOrgTreeFactory.getRemoteInstance();
    IElimination iElim = EliminationFactory.getRemoteInstance();
    ElimRelaOrgTreeCollection elimRelaCol = null;
    private ArrayList selectedImportedIdList = new ArrayList();
    private Map importedAdjustRela = new HashMap();
    private HashMap msgMap = new HashMap();
    private List auditedRecord = new ArrayList();
    private Map selectedEntryIdList = new HashMap();

    public ImportEliminationForBudgetUI() throws Exception {
        this.tblEliminationRecord.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ImportEliminationForBudgetUI.this.tableValueChange(e);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            this.orgTreeInfo = this.ctx.getCurOrgBound();
            this.year = this.ctx.getCurRptYear();
            this.period = this.ctx.getCurRptPeriod();
            this.orgUnitInfo = this.ctx.getCurOrgGroup();
            this.periodType = this.ctx.getCurRptPeriodType();
        } else {
            SysUtil.abort();
        }
        if (this.eliminationImportQuery == null) {
            this.eliminationImportQuery = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)""));
            this.eliminationImportQuery.setFilter(filter);
        }
        this.elimRelaCol = new ElimRelaOrgTreeCollection();
        this.initOrgTree();
        this.initYearAndPeriod();
        this.initCurrency();
        this.initData();
        CslClientHelper.mergeCheckBox(this.tblEliminationRecord, "id", 1, 1);
        CslClientHelper.mergeCheckBox(this.tblEliminationRecord, "id", 2, 2);
        this.tblEliminationRecord.checkParsed();
        this.tblEliminationRecord.getColumn("debit").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.tblEliminationRecord.getColumn("credit").getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
    }

    private void initOrgTree() throws BOSException {
        String oql = "select id, number, name, basic where type = 8 and status = 1 and id <> '" + this.orgTreeInfo.getId().toString() + "'";
        OrgTreeCollection col = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(oql);
        int selected = 0;
        for (int i = 0; i < col.size(); ++i) {
            OrgTreeInfo tree = col.get(i);
            if (tree.isBasic()) {
                selected = i;
            }
            this.cmbOrgTree.addItem((Object)tree);
        }
        this.cmbOrgTree.setSelectedIndex(selected);
    }

    private void initYearAndPeriod() {
        int max;
        SpinnerNumberModel yearModel = new SpinnerNumberModel(this.year, 1, 4000, 1);
        this.spiStartYear.setModel((SpinnerModel)yearModel);
        yearModel = new SpinnerNumberModel(this.year, 1, 4000, 1);
        this.spiEndYear.setModel((SpinnerModel)yearModel);
        switch (this.periodType.getValue()) {
            case 1: {
                max = 366;
                break;
            }
            case 2: {
                max = 52;
                break;
            }
            case 3: {
                max = 12;
                break;
            }
            case 4: {
                max = 4;
                break;
            }
            case 5: {
                max = 2;
                break;
            }
            case 6: {
                max = 1;
                break;
            }
            default: {
                max = 12;
            }
        }
        SpinnerNumberModel periodModel = new SpinnerNumberModel(this.period, 1, max, 1);
        this.spiStartPeriod.setModel((SpinnerModel)periodModel);
        periodModel = new SpinnerNumberModel(this.period, 1, max, 1);
        this.spiEndPeriod.setModel((SpinnerModel)periodModel);
    }

    private void initCurrency() {
        CurrencyCollection collection = CslRptUIUtil.getCurrencyCollection();
        String path = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
        this.cmbxCurrency.addItem((Object)EASResource.getString((String)path, (String)"SelectAll"));
        this.cmbxCurrency.addItems(collection.toArray());
        this.cmbxSourceCurrency.addItem((Object)EASResource.getString((String)path, (String)"SelectAll"));
        this.cmbxSourceCurrency.addItems(collection.toArray());
        this.cmbxElimType.insertItemAt((Object)EASResource.getString((String)path, (String)"SelectAll"), 0);
        this.cmbxElimType.setSelectedItem((Object)EASResource.getString((String)path, (String)"SelectAll"));
    }

    private void initData() throws EASBizException, BOSException {
        String elimImportType = ParamManager.getParamValue(null, null, (String)"GR_CSL_ELIMIMPORTBASICTREE");
        if (elimImportType != null && !elimImportType.equals("")) {
            if (elimImportType.equals("0")) {
                this.elimImportbasicType = ElimImportBasicTreeEnum.RelatedCompanyImport;
            } else if (elimImportType.equals("1")) {
                this.elimImportbasicType = ElimImportBasicTreeEnum.AllCompanyImport;
            } else if (elimImportType.equals("2")) {
                this.elimImportbasicType = ElimImportBasicTreeEnum.AllCompanyInOrgnizeImport;
            } else {
                throw new BOSException("error trying to get ElimImport type");
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNone.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnRefreshValue.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    private void tableValueChange(KDTDataRequestEvent e) {
        HashMap resultMap;
        ArrayList list = new ArrayList();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgTreeId", this.orgTreeInfo.getId().toString());
        param.put("recordType", (Object)RecordTypeEnum.BUDGET_ELIM);
        param.put("year", new Integer(this.year));
        param.put("period", new Integer(this.period));
        try {
            param.put("dataCollectNumber", CSLContextHelper.getCSLContext().getCurDataCollect().getNumber());
        }
        catch (BOSException e2) {
            this.handleException((Exception)((Object)e2));
        }
        ArrayList<String> ids = new ArrayList<String>();
        int n = e.getLastRow();
        for (int i = e.getFirstRow(); i <= n; ++i) {
            String id = this.tblEliminationRecord.getRow(i).getCell("id").getValue().toString();
            ids.add(id);
        }
        try {
            resultMap = this.iElimRela.existsRecords(param, ids);
        }
        catch (Exception e1) {
            resultMap = new HashMap();
        }
        int n2 = e.getLastRow();
        for (int i = e.getFirstRow(); i <= n2; ++i) {
            String id = this.tblEliminationRecord.getRow(i).getCell("id").getValue().toString();
            Map map = (Map)resultMap.get(id);
            this.isImportBefore(i, map, list);
        }
    }

    private void isImportBefore(int row, Map resultMap, List list) {
        Boolean isAudited;
        String id = this.tblEliminationRecord.getRow(row).getCell("id").getValue().toString();
        boolean exists = true;
        if (resultMap.containsKey("msg")) {
            this.msgMap.put(id, resultMap.get("msg"));
        }
        if ((isAudited = (Boolean)resultMap.get("isAudited")) != null && isAudited.booleanValue()) {
            this.auditedRecord.add(id);
        }
        if (exists = resultMap.get("isImportBefore") != null && (Boolean)resultMap.get("isImportBefore") != false) {
            this.tblEliminationRecord.getRow(row).getCell("isImportBefore").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport"));
            String importedId = (String)resultMap.get("importedId");
            this.importedAdjustRela.put(id, importedId);
            this.setElimRelaCol(id, list);
        } else {
            this.tblEliminationRecord.getRow(row).getCell("isImportBefore").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"794_RptItemDataImport"));
            this.setElimRelaCol(id, list);
        }
    }

    private void setPrecision() {
        this.tblEliminationRecord.refresh();
        int iCurrencyPrecision = 0;
        BigDecimal bgAmount = null;
        int rowCount = this.tblEliminationRecord.getExpandedRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblEliminationRecord.getRow(i);
            iCurrencyPrecision = (Integer)row.getCell("currency.precision").getValue();
            if (iCurrencyPrecision < 0) {
                iCurrencyPrecision = 2;
            }
            BigDecimal bigDecimal = bgAmount = row.getCell("debit") == null ? BigDecimal.valueOf(0L) : (BigDecimal)row.getCell("debit").getValue();
            if (bgAmount == null || bgAmount.compareTo(BigDecimal.valueOf(0L)) == 0) {
                row.getCell("debit").setValue(null);
            } else {
                bgAmount = bgAmount.setScale(iCurrencyPrecision, 4);
                row.getCell("debit").setValue((Object)bgAmount);
            }
            BigDecimal bigDecimal2 = bgAmount = row.getCell("credit") == null ? BigDecimal.valueOf(0L) : (BigDecimal)row.getCell("credit").getValue();
            if (bgAmount == null || bgAmount.compareTo(BigDecimal.valueOf(0L)) == 0) {
                row.getCell("credit").setValue(null);
            } else {
                bgAmount = bgAmount.setScale(iCurrencyPrecision, 4);
                row.getCell("credit").setValue((Object)bgAmount);
            }
            ICell cell = this.tblEliminationRecord.getCell(i, "select");
            if (cell == null) continue;
            cell.getStyleAttributes().setLocked(false);
            cell.setValue((Object)Boolean.FALSE);
        }
        CslClientHelper.mergeCheckBox(this.tblEliminationRecord, "id", 1, 1);
        CslClientHelper.mergeCheckBox(this.tblEliminationRecord, "id", 2, 2);
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemInfo sorter = new SorterItemInfo("number");
        sorter.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorter);
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    @Override
    public void okAction_actionPerformed(ActionEvent e) throws Exception {
        super.okAction_actionPerformed(e);
        ArrayList selectIdList = this.getSelectedEliminationIDs();
        boolean isCover = this.showMsg(selectIdList);
        if (isCover) {
            ArrayList<String> deleted = new ArrayList<String>();
            for (int i = 0; i < this.selectedImportedIdList.size(); ++i) {
                String oldId = (String)this.selectedImportedIdList.get(i);
                String newId = (String)this.importedAdjustRela.get(oldId);
                if (deleted.contains(newId)) continue;
                deleted.add(newId);
                try {
                    this.iElim.delete((IObjectPK)new ObjectStringPK(newId));
                    continue;
                }
                catch (Exception ex) {
                    selectIdList.remove(oldId);
                }
            }
            this.doAddElimination(selectIdList);
        }
        this.destroyWindow();
    }

    private void doAddElimination(List idList) throws BOSException, EASBizException {
        boolean isSunElimination = this.chkSumElimination.isSelected();
        boolean isInitYearProfit = false;
        RptProperties pp = new RptProperties();
        String typeid = (String)this.getUIContext().get("displayTypeId");
        if (typeid != null) {
            pp.setString("displayTypeId", typeid);
        }
        pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
        pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
        pp.setInt("year", this.ctx.getCurRptYear());
        pp.setInt("period", this.ctx.getCurRptPeriod());
        pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
        pp.setBoolean("isSunElimination", isSunElimination);
        pp.setBoolean("isInitYearProfit", isInitYearProfit);
        pp.setBoolean("isImport", true);
        pp.setObject("companyIds", this.companyIds);
        if (this.elimImportbasicType.getValue().equals("1") || this.elimImportbasicType.getValue().equals("2")) {
            pp.setBoolean("isAllCompanyImport", true);
        } else {
            pp.setBoolean("isAllCompanyImport", false);
        }
        pp.setObject("elimRelaCol", (Object)this.elimRelaCol);
        pp.setObject("list", idList);
        pp.setObject("dataCollect", CSLContextHelper.getCSLContext().getCurDataCollect());
        pp.setObject("KEY_ORGTREE_INFO", this.ctx.getCurOrgBound());
        pp.setObject("KEY_ORGUNIT_INFO", this.ctx.getCurOrgGroup());
        EliminationFactory.getRemoteInstance().copyHisData(pp);
    }

    private boolean showMsg(ArrayList idList) {
        StringBuffer s = new StringBuffer();
        if (this.msgMap.size() > 0 && idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                if (!this.msgMap.containsKey(idList.get(i).toString())) continue;
                s.append(this.msgMap.get(idList.get(i).toString()));
            }
        }
        if (s.toString().length() > 0) {
            int select = MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"531_ImportAdjustForBudgetUI"), (String)s.toString());
            return 0 == select;
        }
        return true;
    }

    private ArrayList getSelectedEliminationIDs() {
        this.selectedImportedIdList.clear();
        this.selectedEntryIdList.clear();
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> unSelectedIds = new ArrayList<String>();
        int rowCount = 0;
        String id = null;
        for (int i = 0; i < this.tblEliminationRecord.getExpandedRowCount(); ++i) {
            List<String> entryIds;
            String entryid;
            IRow row = this.tblEliminationRecord.getRow(i);
            id = (String)row.getCell(0).getValue();
            if (Boolean.TRUE.equals(row.getCell(1).getValue())) {
                ++rowCount;
                if (unSelectedIds.contains(id) || this.auditedRecord.contains(id)) continue;
                if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport").equals(row.getCell("isImportBefore").getValue().toString()) && !this.selectedImportedIdList.contains(id)) {
                    this.selectedImportedIdList.add(id);
                }
                if (!list.contains(id)) {
                    list.add(id);
                }
                entryid = (String)row.getCell("entryId").getValue();
                if (this.selectedEntryIdList.containsKey(id)) {
                    entryIds = (List)this.selectedEntryIdList.get(id);
                } else {
                    entryIds = new ArrayList();
                    this.selectedEntryIdList.put(id, entryIds);
                }
                entryIds.add(entryid);
                continue;
            }
            if (!list.contains(id) && !unSelectedIds.contains(id)) {
                unSelectedIds.add(id);
            }
            if (!list.contains(id)) continue;
            entryid = (String)row.getCell("entryId").getValue();
            if (this.selectedEntryIdList.containsKey(id)) {
                entryIds = (List)this.selectedEntryIdList.get(id);
            } else {
                entryIds = new ArrayList();
                this.selectedEntryIdList.put(id, entryIds);
            }
            entryIds.add(entryid);
        }
        if (rowCount == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        return list;
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        CslRptUtil.selectTable(this.tblEliminationRecord, "select", Boolean.TRUE);
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectNone_actionPerformed(e);
        CslRptUtil.selectTable(this.tblEliminationRecord, "select", Boolean.FALSE);
    }

    public boolean destroyWindow() {
        CSLContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        CSLContextHelper.update(arg0, this);
    }

    private void setElimRelaCol(String id, List list) {
        ElimRelaOrgTreeInfo info = new ElimRelaOrgTreeInfo();
        info.setElimId(id);
        info.setOrgTreeId(this.orgTreeInfo.getId().toString());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setRecordType(RecordTypeEnum.BUDGET_ELIM);
        if (!list.contains(id + this.orgTreeInfo.getId().toString())) {
            list.add(id + this.orgTreeInfo.getId().toString());
            this.elimRelaCol.add(info);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.companyIds = new ArrayList();
        this.selectedImportedIdList.clear();
        this.importedAdjustRela.clear();
        this.tblEliminationRecord.checkParsed();
        if (this.elimImportbasicType.equals((Object)ElimImportBasicTreeEnum.RelatedCompanyImport)) {
            this.fillQuery1(this.eliminationImportQuery, this.companyIds);
        } else if (this.elimImportbasicType.equals((Object)ElimImportBasicTreeEnum.AllCompanyImport)) {
            this.fillQuery2(this.eliminationImportQuery, this.companyIds);
        } else {
            this.fillQuery3(this.eliminationImportQuery, this.companyIds);
        }
        SorterItemCollection sorter = this.eliminationImportQuery.getSorter();
        sorter.clear();
        sorter.add(new SorterItemInfo("number"));
        sorter.add(new SorterItemInfo("entries.id"));
        this.tblEliminationRecord.removeRows();
        this.setPrecision();
    }

    private void fillQuery1(EntityViewInfo query, List companyIds) throws BOSException {
        int elimType;
        int size;
        IOrgStructure structure = OrgStructureFactory.getRemoteInstance();
        EntityViewInfo structureView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(this.orgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)this.orgTreeInfo.getId().toString(), CompareType.EQUALS));
        structureView.setFilter(filterInfo);
        CoreBaseCollection collection = structure.getCollection(structureView);
        OrgStructureInfo base = null;
        StringBuffer companys = new StringBuffer("");
        for (int i = 0; i < collection.size(); ++i) {
            base = (OrgStructureInfo)collection.get(i);
            companys.append("" + base.getUnit().getId().toString() + ",");
            companyIds.add(base.getUnit().getId().toString());
        }
        if (companys.lastIndexOf(",") != -1) {
            companys.deleteCharAt(companys.lastIndexOf(","));
        }
        FilterInfo filter = new FilterInfo();
        StringBuffer mask = new StringBuffer();
        int startYear = this.spiStartYear.getIntegerVlaue();
        int startPeriod = this.spiStartPeriod.getIntegerVlaue();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(startPeriod), CompareType.GREATER_EQUALS));
        mask.append("(#0 or (#1 and #2)) ");
        int endYear = this.spiEndYear.getIntegerVlaue();
        int endPeriod = this.spiEndPeriod.getIntegerVlaue();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(endYear), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(endYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(endPeriod), CompareType.LESS_EQUALS));
        mask.append(" and (#3 or (#4 and #5))");
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(this.periodType.getValue())));
        mask.append(" and #6");
        OrgTreeInfo tree = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
        filter.getFilterItems().add(new FilterItemInfo("orgBound.number", (Object)tree.getNumber()));
        mask.append(" and #7");
        filter.getFilterItems().add(new FilterItemInfo("entries.company.id", (Object)companys.toString(), CompareType.INCLUDE));
        mask.append(" and #8");
        filter.getFilterItems().add(new FilterItemInfo("isCitedByLater", (Object)new Integer(1)));
        mask.append(" and #9");
        Object obj = this.cmbxCurrency.getSelectedItem();
        if (obj instanceof CurrencyInfo) {
            CurrencyInfo currencyinfo = (CurrencyInfo)obj;
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyinfo.getId().toString()));
            size = filter.getFilterItems().size();
            mask.append(" and #").append(size - 1);
        }
        if ((obj = this.cmbxSourceCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            CurrencyInfo sourceCurrencyinfo = (CurrencyInfo)obj;
            filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)sourceCurrencyinfo.getId().toString()));
            size = filter.getFilterItems().size();
            mask.append(" and #").append(size - 1);
        }
        if ((elimType = this.cmbxElimType.getSelectedIndex()) > 0) {
            ElimTypeEnum type = ElimTypeEnum.getEnum(elimType);
            filter.getFilterItems().add(new FilterItemInfo("elimType", (Object)new Integer(type.getValue())));
            int size2 = filter.getFilterItems().size();
            mask.append(" and #").append(size2 - 1);
        }
        filter.setMaskString(mask.toString());
        query.setFilter(filter);
    }

    private void fillQuery2(EntityViewInfo query, List companyIds) throws BOSException {
        List col = this.iElim.getEliminationIdBySql(this.createSql(companyIds));
        StringBuffer sql = new StringBuffer();
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                sql.append(col.get(i).toString()).append(",");
            }
            if (sql.length() > 0) {
                sql.deleteCharAt(sql.length() - 1);
            }
        } else {
            sql.append("");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INCLUDE));
        query.setFilter(filter);
    }

    private void fillQuery3(EntityViewInfo query, List companyIds) throws BOSException, EASBizException {
        List col = this.iElim.getEliminationIdBySql(this.createSql(companyIds));
        ArrayList lastList = new ArrayList();
        this.checkCurCompanyIsContainBasicCompany(col, lastList, companyIds);
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        int formulaIndex = 0;
        if (lastList.size() > 0) {
            for (int i = 0; i < lastList.size(); ++i) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)lastList.get(i).toString(), CompareType.EQUALS));
                if (i == lastList.size() - 1) {
                    sbFormula.append(" #" + formulaIndex++);
                    continue;
                }
                sbFormula.append(" #" + formulaIndex++).append(" or");
            }
            filter.setMaskString(sbFormula.toString());
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"", CompareType.EQUALS));
        }
        query.setFilter(filter);
    }

    private String createSql(List companyIds) throws BOSException {
        int elimType;
        IOrgStructure structure = OrgStructureFactory.getRemoteInstance();
        EntityViewInfo structureView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(this.orgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)this.orgTreeInfo.getId().toString(), CompareType.EQUALS));
        structureView.setFilter(filterInfo);
        CoreBaseCollection collection = structure.getCollection(structureView);
        OrgStructureInfo base = null;
        StringBuffer companys = new StringBuffer("");
        for (int i = 0; i < collection.size(); ++i) {
            base = (OrgStructureInfo)collection.get(i);
            companys.append("'").append(base.getUnit().getId().toString()).append("',");
            companyIds.add(base.getUnit().getId().toString());
        }
        if (companys.lastIndexOf(",") != -1) {
            companys.deleteCharAt(companys.lastIndexOf(","));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select e.fid");
        sql.append(" from t_csl_elimination e join t_csl_eliminationEntry entry");
        sql.append(" on e.FId = entry.FEliminationId");
        sql.append(" join t_org_tree tree on e.FOrgBoundId = tree.FId");
        int startYear = this.spiStartYear.getIntegerVlaue();
        int startPeriod = this.spiStartPeriod.getIntegerVlaue();
        sql.append(" where (e.FYear > ").append(startYear);
        sql.append(" or (e.FYear = ").append(startYear).append(" and e.FPeriod >= ").append(startPeriod);
        int endYear = this.spiEndYear.getIntegerVlaue();
        int endPeriod = this.spiEndPeriod.getIntegerVlaue();
        sql.append(")) and (e.FYear < ").append(endYear);
        sql.append(" or (e.FYear = ").append(endYear).append(" and e.FPeriod <= ").append(endPeriod);
        sql.append(")) and e.FPeriodType = ").append(this.periodType.getValue());
        OrgTreeInfo tree = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
        sql.append(" and tree.FNumber = '").append(tree.getNumber()).append("'");
        sql.append(" and entry.FCompanyId in (").append(companys.toString()).append(")");
        Object obj = this.cmbxCurrency.getSelectedItem();
        if (obj instanceof CurrencyInfo) {
            CurrencyInfo currencyinfo = (CurrencyInfo)obj;
            sql.append(" and e.FCurrencyID = '").append(currencyinfo.getId().toString()).append("'");
        }
        if ((obj = this.cmbxSourceCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            CurrencyInfo sourceCurrencyinfo = (CurrencyInfo)obj;
            sql.append(" and e.FSourceCurrencyID = '").append(sourceCurrencyinfo.getId().toString()).append("'");
        }
        if ((elimType = this.cmbxElimType.getSelectedIndex()) > 0) {
            sql.append(" and e.FElimType = ").append(elimType);
        }
        sql.append(" and e.FIsCitedByLater = 1");
        return sql.toString();
    }

    private void checkCurCompanyIsContainBasicCompany(List col, ArrayList lastList, List curCompanyIds) throws BOSException {
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                String id = (String)col.get(i);
                EliminationEntryCollection entries = EliminationEntryFactory.getRemoteInstance().getEliminationEntryCollection("select id, company where elimination ='" + id + "'");
                boolean bt = true;
                for (int j = 0; j < entries.size(); ++j) {
                    EliminationEntryInfo entry = entries.get(j);
                    if (entry.getCompany() == null) continue;
                    String companyId = entry.getCompany().getId().toString();
                    if (curCompanyIds.contains(companyId)) {
                        bt = true;
                        continue;
                    }
                    bt = false;
                    break;
                }
                if (!bt) continue;
                lastList.add(id);
            }
        }
    }
}

