/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IRptBase;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IInterDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSumFactory;
import com.kingdee.eas.fi.gr.cslrpt.InterDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInterAfterElimSumReportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslBaseConditionUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.InterAfterElimSumFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.List;
import java.util.Observable;
import org.apache.log4j.Logger;

public class InterAfterElimSumReportUI
extends AbstractInterAfterElimSumReportUI
implements ICSLContextUI {
    private static final Logger logger = CoreUIObject.getLogger(InterAfterElimSumReportUI.class);
    private InterAfterElimSumFilterUI panelUI = new InterAfterElimSumFilterUI();
    private List lstAllItems = null;

    public InterAfterElimSumReportUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getViewManager().setFreezeView(0, 2);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    protected KDTable getPrintTable() {
        return this.tblMain;
    }

    @Override
    protected Variant getPrintVariant(String varName) {
        return null;
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.menuItemRefresh.setEnabled(true);
        this.menuItemQuery.setEnabled(true);
    }

    @Override
    public void query(Object condition) throws Exception {
        this.pp = (RptProperties)condition;
        super.doLayout();
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        this.pp.setString("treeId", ctx.getCurOrgBound().getId().toString());
        this.pp.setString("orgUnitLongNumber", ctx.getCurOrgGroup().getLongNumber());
        this.pp.setString("year", String.valueOf(ctx.getCurRptYear()));
        this.pp.setString("period", String.valueOf(ctx.getCurRptPeriod()));
        this.pp.setString("periodType", String.valueOf(ctx.getCurRptPeriodType().getValue()));
        this.pp.setString("dataCollection", ctx.getCurDataCollect().getNumber());
        if (this.pp.getObject("currencyId") == null) {
            this.pp.setString("currencyId", CslClientHelper.getCUNaturalCurrency().getId().toString());
        }
        if (this.pp.getObject("currencyName") == null) {
            this.pp.setString("currencyName", CslClientHelper.getCUNaturalCurrency().getName());
        }
        if (this.pp.getObject("dataElement") == null) {
            this.pp.setString("dataElement", String.valueOf(4));
        }
        if (this.pp.getObject("dataElementName") == null) {
            String oql = "select name where interSeq = 4";
            DataElementInfo deInfo = DataElementFactory.getRemoteInstance().getDataElementInfo(oql);
            this.pp.setString("dataElementName", deInfo.getName());
        }
        this.pp.setBoolean("isQueryHisBudget", (Boolean)ctx.isQueryBudget());
        this.txtCurrency.setText(this.pp.getString("currencyName"));
        this.txtDataElement.setText(this.pp.getString("dataElementName"));
        for (int i = this.tblMain.getColumnCount() - 1; i >= 2; --i) {
            this.tblMain.removeColumn(i);
        }
        IInterDataProvider iInterData = InterDataProviderFactory.getRemoteInstance();
        this.lstAllItems = iInterData.getAfterElimRptItems(this.pp, 1);
        String[] strCurItem = null;
        IColumn column = null;
        int size = this.lstAllItems.size();
        for (int i = 0; i < size; ++i) {
            strCurItem = (String[])this.lstAllItems.get(i);
            column = this.tblMain.addColumn(2 + i);
            column.setKey(strCurItem[0]);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
            this.tblMain.getHeadRow(0).getCell(2 + i).setValue((Object)strCurItem[1]);
        }
        this.tblMain.removeRows(true);
    }

    @Override
    public IRptBase getInitRemoteInstance() throws BOSException {
        return InterCheckSumFactory.getRemoteInstance();
    }

    @Override
    public CslBaseConditionUI getQueryDialogUserPanel() {
        return this.panelUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int length = e.getLastRow() - e.getFirstRow() + 1;
        this.pp.setInt("from", from);
        this.pp.setInt("length", length);
        try {
            IInterDataProvider iInterData = InterDataProviderFactory.getRemoteInstance();
            ICSLContext ctx = CSLContextHelper.getCSLContext();
            this.pp.setBoolean("isQueryHisBudget", (Boolean)ctx.isQueryBudget());
            List lstKeys = iInterData.getAfterElimKeys(this.pp, 1);
            if (lstKeys == null || lstKeys.size() <= 0) {
                return;
            }
            RptRowSet rst = iInterData.getAfterElimData(this.pp, lstKeys, 1);
            if (rst == null) {
                return;
            }
            String oldFromCompanyId = null;
            String oldTargetCompanyId = null;
            String fromCompanyId = null;
            String targetCompanyId = null;
            IRow row = null;
            int rowIndex = from;
            while (rst.next()) {
                fromCompanyId = rst.getString("fromCompanyId");
                targetCompanyId = rst.getString("targetCompanyId");
                if (oldFromCompanyId == null || oldTargetCompanyId == null) {
                    oldFromCompanyId = fromCompanyId;
                    oldTargetCompanyId = targetCompanyId;
                    row = this.tblMain.addRow(rowIndex);
                    ++rowIndex;
                }
                if (!oldFromCompanyId.equals(fromCompanyId) || !oldTargetCompanyId.equals(targetCompanyId)) {
                    row = this.tblMain.addRow(rowIndex);
                    ++rowIndex;
                } else {
                    row = this.tblMain.getRow(rowIndex - 1);
                }
                this.setRowData(row, rst);
                oldFromCompanyId = fromCompanyId;
                oldTargetCompanyId = targetCompanyId;
                this.groupTableRow();
            }
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        catch (EASBizException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    private void setRowData(IRow row, RptRowSet rst) {
        row.getCell("company").setValue((Object)rst.getString("Company"));
        row.getCell("targetCompany").setValue((Object)rst.getString("TargetCompany"));
        int currencyPrecision = rst.getInt("currencyPrecision");
        Object oldItemMoney = row.getCell(rst.getString("ItemId")).getValue();
        BigDecimal bdNewItemMoney = new BigDecimal("0");
        bdNewItemMoney = oldItemMoney != null && oldItemMoney instanceof BigDecimal ? rst.getBigDecimal("Money").add((BigDecimal)oldItemMoney) : rst.getBigDecimal("Money");
        row.getCell(rst.getString("ItemId")).setValue((Object)bdNewItemMoney.setScale(currencyPrecision, 4));
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.query(this.pp);
    }

    private void groupTableRow() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn(0).setGroup(true);
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        CSLContextHelper.update(arg0, this);
    }

    @Override
    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }
}

