/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.CheckageConfirmEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalYearPeriodDateTmp;
import com.kingdee.eas.fi.gr.cslrpt.IElimTemplet;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSolutionFactory;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSolutionInfo;
import com.kingdee.eas.fi.gr.cslrpt.InterDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInterAndExchCheckageFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class InterAndExchCheckageFilterUI
extends AbstractInterAndExchCheckageFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InterAndExchCheckageFilterUI.class);
    private boolean hasLoadInitData;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private IElimTemplet iElimTemplet = null;
    private CurrencyInfo bsCurrency = null;
    private int bsCurrency2;
    private FiscalYearPeriodDateTmp fiscalRefCtrl;
    private Map<String, Integer> orgTree_Seq = new HashMap<String, Integer>();
    private Map itemDataFilterUIInfo = null;
    CurrencyCollection currencyCollection = null;
    private static final String BLANK = "";
    private static final String EQUAL = "=";
    private static final String LESS_THAN = "<";
    private static final String MORE_THAN = ">";
    private static final String NOT_EQUAL = "<>";

    public InterAndExchCheckageFilterUI() throws Exception {
        this.initComponent();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void initComponent() throws Exception {
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.cmbCurrency.addItem((Object)this.selectAll);
        if (this.currencyCollection == null) {
            this.currencyCollection = (CurrencyCollection)this.getItemDataFilterUIInfo(null, false).get("currencyCollection");
        }
        if (this.currencyCollection != null && this.currencyCollection.size() > 0) {
            this.cmbCurrency.addItems(this.currencyCollection.toArray());
        }
        CompanyOrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.bsCurrency = orgUnitInfo.getBaseCurrency();
        for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
            CurrencyInfo info;
            if (!(this.cmbCurrency.getItemAt(i) instanceof CurrencyInfo) || !(info = (CurrencyInfo)this.cmbCurrency.getItemAt(i)).getId().toString().equals(this.bsCurrency.getId().toString())) continue;
            this.bsCurrency = new CurrencyInfo();
            this.bsCurrency.setId(info.getId());
            this.bsCurrency.setNumber(info.getNumber());
            this.bsCurrency.setName(info.getName());
            this.cmbCurrency.setSelectedIndex(i);
            this.bsCurrency2 = i;
            break;
        }
        this.cmbCurrency.setSelectedItem((Object)this.bsCurrency);
        this.refreshOrgTree(true);
        if (this.iElimTemplet == null) {
            this.iElimTemplet = ElimTempletFactory.getRemoteInstance();
        }
        this.cmbConfirmStatus.addItem((Object)this.selectAll);
        this.cmbConfirmStatus.addItem((Object)CheckageConfirmEnum.Audit);
        this.cmbConfirmStatus.addItem((Object)CheckageConfirmEnum.Confirm);
        this.cmbConfirmStatus.addItem((Object)CheckageConfirmEnum.UnConfirm);
        Iterator itor = RptPeriodTypeEnum.iterator();
        RptPeriodTypeEnum curItem = null;
        while (itor.hasNext()) {
            curItem = (RptPeriodTypeEnum)itor.next();
            this.cmbSourceType.addItem((Object)curItem);
        }
        this.cmbSourceType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        int[] defaultYearOrMonth = this.getCurrYearOrPeriod();
        this.spinYear.setValue((Object)new Integer(defaultYearOrMonth[0]));
        this.spinPeriod.setValue((Object)new Integer(defaultYearOrMonth[1]));
        this.spinYear.setEditable(true);
        this.spinPeriod.setEditable(true);
        this.cmbSourceType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterAndExchCheckageFilterUI.this.refreshTimeInfo(InterAndExchCheckageFilterUI.this.dpkDate.getSqlDate());
                InterAndExchCheckageFilterUI.this.refresh13Period();
            }
        });
        this.dpkDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e != null && e.getNewValue() instanceof Date) {
                    InterAndExchCheckageFilterUI.this.refreshTimeInfo((Date)e.getNewValue());
                    InterAndExchCheckageFilterUI.this.refreshOrgTree(false);
                    InterAndExchCheckageFilterUI.this.refresh13Period();
                }
            }
        });
        this.cmbOrgTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterAndExchCheckageFilterUI.this.refreshF7Company();
                InterAndExchCheckageFilterUI.this.refreshCompany();
                InterAndExchCheckageFilterUI.this.refreshInterCheckSolu();
            }
        });
        try {
            boolean isMergeFiscalPeriod;
            this.initTimeCtrlValAndStatusByBaseOrgBound(true);
            boolean bl = isMergeFiscalPeriod = this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod();
            if (isMergeFiscalPeriod && this.pp != null && this.pp.getInt("year") > 0 && this.pp.getInt("period") > 0) {
                this.spinYear.setValue((Object)new Integer(this.pp.getInt("year")));
                this.spinPeriod.setValue((Object)new Integer(this.pp.getInt("period")));
            } else if (!isMergeFiscalPeriod && this.pp != null) {
                this.dpkDate.setValue((Object)CslRptUIUtil.getRptDateFromProp(this.pp));
            }
        }
        catch (EASBizException e1) {
            logger.error((Object)BLANK, (Throwable)e1);
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            logger.error((Object)BLANK, (Throwable)e1);
            this.handUIException(e1);
        }
        this.F7Company.setRequired(true);
        this.F7Company.setEditable(false);
        this.bizCompany.setRequired(false);
        this.bizCompany.setEditable(false);
        this.kDBizInterCheckSolu.setEditable(false);
        Object[] compareArr = new String[]{BLANK, EQUAL, LESS_THAN, MORE_THAN, NOT_EQUAL};
        this.cbCompare.addItems(compareArr);
        this.cbCompare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InterAndExchCheckageFilterUI.BLANK.equals(InterAndExchCheckageFilterUI.this.cbCompare.getSelectedItem().toString())) {
                    InterAndExchCheckageFilterUI.this.txtValue.setValue(null);
                    InterAndExchCheckageFilterUI.this.txtValue.setEnabled(false);
                } else {
                    InterAndExchCheckageFilterUI.this.txtValue.setEnabled(true);
                }
            }
        });
        this.cbCompare.setSelectedItem((Object)BLANK);
        this.chkShowNotZero.setVisible(false);
    }

    private Map getItemDataFilterUIInfo(Date rptDate, boolean reQuery) {
        String key;
        if (this.itemDataFilterUIInfo == null) {
            this.itemDataFilterUIInfo = new HashMap();
        }
        if (rptDate == null) {
            Date date = new Date(System.currentTimeMillis());
            rptDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
        }
        if (!this.itemDataFilterUIInfo.containsKey(key = RPTDateUtil.getSimpleDateFormat(rptDate))) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("rptDate", rptDate);
            paramMap.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            try {
                Map returnMap = InterDataProviderFactory.getRemoteInstance().getItemDataFilterInfo(paramMap);
                this.itemDataFilterUIInfo.put(key, returnMap);
                this.currencyCollection = (CurrencyCollection)returnMap.get("currencyCollection");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return (Map)this.itemDataFilterUIInfo.get(key);
    }

    private void initTimeCtrlValAndStatusByBaseOrgBound(boolean isAddListener) throws BOSException, EASBizException {
        RptPeriodTypeEnum periodType;
        OrgTreeInfo choosedOrgTreeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
        if (choosedOrgTreeInfo == null) {
            return;
        }
        int[] currYearOrPeriod = this.getCurrYearOrPeriod();
        if (this.fiscalRefCtrl == null) {
            this.fiscalRefCtrl = new FiscalYearPeriodDateTmp(choosedOrgTreeInfo, this.cmbSourceType, this.dpkDate, this.spinYear, this.spinPeriod);
            this.fiscalRefCtrl.setComboOrgBound(this.cmbOrgTree, true, null);
        }
        if ((periodType = (RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem()) == null) {
            periodType = RptPeriodTypeEnum.MONTHLY;
            this.cmbSourceType.setSelectedItem((Object)periodType);
        }
        this.fiscalRefCtrl.initTimeCtrlValAndStatus(periodType, choosedOrgTreeInfo, currYearOrPeriod[0], currYearOrPeriod[1], (CoreUIObject)this, isAddListener, null);
    }

    private int[] getCurrYearOrPeriod() {
        Calendar ca = Calendar.getInstance();
        return new int[]{ca.get(1), ca.get(2) + 1};
    }

    private void refreshOrgTree(boolean isSelectBaseOrgTree) {
        OrgTreeInfo prevSelectOrgTree = null;
        if (this.cmbOrgTree.getSelectedItem() != null) {
            prevSelectOrgTree = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
        }
        int index = this.initCmbOrgTree(isSelectBaseOrgTree, null);
        OrgTreeInfo nextSelectOrgTree = null;
        if (this.cmbOrgTree.getItemAt(index) != null) {
            nextSelectOrgTree = (OrgTreeInfo)this.cmbOrgTree.getItemAt(index);
        }
        if (prevSelectOrgTree != null && nextSelectOrgTree != null && prevSelectOrgTree.getId().toString().equals(nextSelectOrgTree.getId().toString())) {
            int i;
            ActionListener[] savedActionListeners = null;
            savedActionListeners = this.cmbOrgTree.getActionListeners();
            if (savedActionListeners != null) {
                for (i = 0; i < savedActionListeners.length; ++i) {
                    this.cmbOrgTree.removeActionListener(savedActionListeners[i]);
                }
            }
            this.cmbOrgTree.setSelectedIndex(index);
            if (savedActionListeners != null) {
                for (i = 0; i < savedActionListeners.length; ++i) {
                    this.cmbOrgTree.addActionListener(savedActionListeners[i]);
                }
            }
        } else if (this.cmbOrgTree.getItemCount() > 0) {
            this.cmbOrgTree.setSelectedIndex(index);
        }
    }

    private int initCmbOrgTree(boolean isSelectBaseOrgTree, Date rptDate) {
        OrgTreeCollection collection = new OrgTreeCollection();
        int index = 0;
        try {
            OrgTreeInfo prevSelectOrgTree = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            if (rptDate == null) {
                rptDate = (Date)this.dpkDate.getValue();
            }
            if ((collection = (OrgTreeCollection)this.getItemDataFilterUIInfo(rptDate, true).get("orgTreeCollection")) == null || collection.size() == 0) {
                return 0;
            }
            DefaultComboBoxModel<OrgTreeInfo> model = new DefaultComboBoxModel<OrgTreeInfo>();
            this.orgTree_Seq.clear();
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                OrgTreeInfo orgTreeInfo = collection.get(i);
                this.orgTree_Seq.put(orgTreeInfo.getNumber(), i);
                if (!isSelectBaseOrgTree && prevSelectOrgTree != null && orgTreeInfo.getNumber() != null && orgTreeInfo.getNumber().equals(prevSelectOrgTree.getNumber())) {
                    index = i;
                } else if (isSelectBaseOrgTree && orgTreeInfo.isBasic()) {
                    index = i;
                }
                model.addElement(orgTreeInfo);
            }
            this.cmbOrgTree.setModel(model);
        }
        catch (Exception e) {
            logger.error((Object)"initCmbOrgTree_BOSException", (Throwable)e);
        }
        return index;
    }

    private void refreshCompany() {
        this.bizCompany.setValue(null);
        if (this.cmbOrgTree.getSelectedItem() != null) {
            this.bizCompany.setEnabled(true);
            OrgTreeInfo treeInfo = null;
            treeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1);
            f7.setTreeID(treeInfo.getId().toString());
            f7.setNeedAddOrgRange(false);
            f7.setCtrlUnitPK(treeInfo.getCU());
            f7.setMultiSelect(false);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            this.bizCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
            try {
                this.bizCompany.setFilterInfoProducer(f7.getOrgUnitFilterInfoProducer());
            }
            catch (Exception e) {
                logger.error((Object)"getOrgUnitFilterInfoProducer_Exception", (Throwable)e);
            }
            this.bizCompany.setSelector((KDPromptSelector)f7);
            this.bizCompany.setEditable(true);
        } else {
            this.bizCompany.setEnabled(false);
        }
    }

    private void refreshF7Company() {
        this.F7Company.setValue(null);
        OrgTreeInfo orgTreeInfo = null;
        if (this.cmbOrgTree.getSelectedItem() != null) {
            FullOrgUnitInfo oldOrgUnitInfo;
            UnionF7Helper.UnionF7 f7;
            boolean notOld = true;
            orgTreeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            UnionF7Helper.UnionF7 oldf7 = (UnionF7Helper.UnionF7)this.F7Company.getSelector();
            if (oldf7 == null || !orgTreeInfo.getId().toString().equals(oldf7.getTreeID())) {
                f7 = UnionF7Helper.getUnionF7((IUIObject)this, (int)2);
                f7.setTreeID(orgTreeInfo.getId().toString());
            } else {
                f7 = oldf7;
                notOld = false;
            }
            Map unitsMap = null;
            if (notOld) {
                String unitsSql = BLANK;
                try {
                    unitsSql = UnionF7Helper.getUnionSQLByUserPKAndTreePK((IObjectPK)CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), (IObjectPK)CslRptUtil.getPK((IObjectValue)orgTreeInfo));
                    f7.filterUnitSql(unitsSql);
                    unitsMap = this.getFullOrgUnitCollection(unitsSql);
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
            }
            if (null != (oldOrgUnitInfo = (FullOrgUnitInfo)this.F7Company.getValue()) && null != unitsMap && !unitsMap.isEmpty()) {
                FullOrgUnitInfo newOrgUnitInfo = (FullOrgUnitInfo)unitsMap.get(oldOrgUnitInfo.getNumber().toString());
                if (null != newOrgUnitInfo) {
                    this.F7Company.setValue((Object)newOrgUnitInfo);
                } else {
                    this.F7Company.setValue(null);
                }
            }
            this.F7Company.setSelector((KDPromptSelector)f7);
            this.F7Company.setEnabled(true);
        } else {
            this.F7Company.setValue(null);
            this.F7Company.setEnabled(false);
        }
    }

    public void refreshInterCheckSolu() {
        this.kDBizInterCheckSolu.setValue(null);
        if (this.cmbOrgTree.getSelectedItem() != null) {
            this.kDBizInterCheckSolu.setEnabled(true);
            OrgTreeInfo treeInfo = null;
            treeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            this.kDBizInterCheckSolu.setEditable(true);
            this.kDBizInterCheckSolu.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.InterCheckSolutionQuery");
            this.kDBizInterCheckSolu.setEditFormat("$number$");
            this.kDBizInterCheckSolu.setDisplayFormat("$name$");
            this.kDBizInterCheckSolu.setCommitFormat("$number$");
            this.kDBizInterCheckSolu.setEnableToMaintainBizdata(true);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("orgTreeId", treeInfo.getId().toString());
            param.put("elimType", (Object)ElimTypeEnum.InterAndExch);
            param.put("isFromMerge", Boolean.TRUE);
            param.put("isByCompany", Boolean.FALSE);
            this.kDBizInterCheckSolu.putMaintainUIContext((Object)"orgBoundid", (Object)treeInfo.getId().toString());
            this.kDBizInterCheckSolu.putMaintainUIContext((Object)"params", param);
            this.kDBizInterCheckSolu.putMaintainUIContext((Object)"isByCompany", (Object)Boolean.FALSE);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgBoundID", (Object)treeInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isFromMerge", (Object)Boolean.TRUE));
            view.setFilter(filter);
            view.setSelector(sic);
            this.kDBizInterCheckSolu.setEntityViewInfo(view);
        } else {
            this.kDBizInterCheckSolu.setEnabled(false);
            this.kDBizInterCheckSolu.setEnableToMaintainBizdata(false);
        }
    }

    private Map getFullOrgUnitCollection(String unitsSql) throws BOSException {
        if (null == unitsSql || unitsSql.length() == 0) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        try {
            filterInfo.mergeFilter(new FilterInfo(" id in (" + unitsSql + ")"), "AND");
            viewInfo.setFilter(filterInfo);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(viewInfo);
        int iSize = fullOrgUnitCollection.size();
        HashMap<String, FullOrgUnitInfo> newMap = null;
        if (null != fullOrgUnitCollection && iSize > 0) {
            FullOrgUnitInfo orgUnitInfo = null;
            newMap = new HashMap<String, FullOrgUnitInfo>(iSize);
            for (int i = 0; i < iSize; ++i) {
                orgUnitInfo = fullOrgUnitCollection.get(i);
                newMap.put(orgUnitInfo.getNumber(), orgUnitInfo);
            }
        }
        return newMap;
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem();
        if (p == null || newDate == null) {
            return;
        }
        if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod()) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.spinYear.setValue((Object)new Integer(times.get(0).toString()));
        this.spinPeriod.setValue((Object)new Integer(times.get(1).toString()));
        this.dpkDate.setValue(times.get(2), false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            OrgUnitInfo orgUnitInfo;
            this.pp = new RptProperties();
            OrgTreeInfo treeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            if (null != treeInfo && treeInfo.getId() != null) {
                this.pp.setString("treeId", treeInfo.getId().toString());
            }
            if (null != (orgUnitInfo = OrgClientUtils.getPromptValue((KDBizPromptBox)this.F7Company)) && orgUnitInfo.getId() != null) {
                this.pp.setString("orgUnitId", orgUnitInfo.getId().toString());
            }
            Date date = new Date(System.currentTimeMillis());
            Date preDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
            this.dpkDate.setValue((Object)preDate);
            Calendar ca = Calendar.getInstance();
            int year = ca.get(1);
            int month = ca.get(2) + 1 - 1;
            if (month == 0) {
                month = 12;
                --year;
                if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isSupport13Period()) {
                    month = 13;
                }
            }
            this.spinYear.setValue((Object)new Integer(year));
            this.spinPeriod.setValue((Object)new Integer(month));
            this.pp.setInt("year", year);
            this.pp.setInt("period", month);
            this.pp.setInt("periodType", 3);
            if (!StringUtils.isEmpty((String)this.cbCompare.getSelectedItem().toString())) {
                this.pp.setString("compare", this.cbCompare.getSelectedItem().toString());
                this.pp.setString("value", this.txtValue.getNumberValue().toString());
            }
        }
    }

    private void fillDataToUI() {
        String fromCurrencyId;
        boolean isMergeFiscalPeriod;
        this.clearUI();
        if (this.pp != null) {
            int periodType = 3;
            try {
                periodType = this.pp.getInt("periodType");
                this.cmbSourceType.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)periodType));
            }
            catch (NullPointerException e) {
                this.cmbSourceType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
            }
        }
        boolean isOrgTreeSelected = false;
        OrgTreeInfo treeInfo = null;
        Integer seq = -1;
        if (this.pp.containsKey("treeId") && this.pp.getObject("treeId") != null) {
            String treeId = (String)this.pp.getObject("treeId");
            if (!this.orgTree_Seq.isEmpty()) {
                try {
                    treeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo("select id,name,number where id='" + treeId + "'");
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                seq = this.orgTree_Seq.get(treeInfo.getNumber());
                if (seq != null && seq >= 0) {
                    this.cmbOrgTree.setSelectedIndex(seq.intValue());
                    isOrgTreeSelected = true;
                }
                if (!isOrgTreeSelected) {
                    this.initCmbOrgTree(false, CslRptUIUtil.getRptDateFromProp(this.pp));
                    seq = this.orgTree_Seq.get(treeInfo.getNumber());
                    if (seq != null && seq >= 0) {
                        this.cmbOrgTree.setSelectedIndex(seq.intValue());
                        isOrgTreeSelected = true;
                    }
                }
            }
        }
        try {
            this.initTimeCtrlValAndStatusByBaseOrgBound(false);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        boolean bl = isMergeFiscalPeriod = this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod();
        if (isMergeFiscalPeriod && this.pp.containsKey("year") && this.pp.containsKey("period")) {
            this.spinYear.setValue((Object)new Integer(this.pp.getInt("year")));
            this.spinPeriod.setValue((Object)new Integer(this.pp.getInt("period")));
        } else if (!isMergeFiscalPeriod) {
            this.dpkDate.setValue((Object)CslRptUIUtil.getRptDateFromProp(this.pp));
            if (this.pp != null && this.pp.containsKey("period") && this.pp.getInt("period") == 13 && this.fiscalRefCtrl != null && this.fiscalRefCtrl.isSupport13Period() && this.pp.getInt("periodType") == 3) {
                this.spinPeriod.setValue((Object)new Integer(this.pp.getInt("period")));
            }
            if (treeInfo != null && (seq = this.orgTree_Seq.get(treeInfo.getNumber())) != null && seq >= 0) {
                this.cmbOrgTree.setSelectedIndex(seq.intValue());
                isOrgTreeSelected = true;
            }
        }
        this.refreshF7Company();
        this.refreshCompany();
        this.refreshInterCheckSolu();
        if (this.pp.containsKey("fromCurrency") && (fromCurrencyId = this.pp.getString("fromCurrency")) != null) {
            for (int j = 1; j < this.cmbCurrency.getItemCount(); ++j) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(fromCurrencyId)) continue;
                this.cmbCurrency.setSelectedIndex(j);
                break;
            }
        }
        if (treeInfo != null && !isOrgTreeSelected) {
            this.F7Company.setValue(null);
            return;
        }
        if (this.pp.containsKey("orgUnitId")) {
            String orgUnitId = this.pp.getString("orgUnitId");
            try {
                if (orgUnitId != null) {
                    FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
                    this.F7Company.setValue((Object)orgUnitInfo);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.pp.containsKey("interCheckSolu")) {
            String interCheckSoluId = this.pp.getString("interCheckSolu");
            try {
                InterCheckSolutionInfo interCheckSoluInfo = InterCheckSolutionFactory.getRemoteInstance().getInterCheckSolutionInfo((IObjectPK)new ObjectUuidPK(interCheckSoluId));
                if (interCheckSoluInfo != null) {
                    this.kDBizInterCheckSolu.setData((Object)interCheckSoluInfo);
                } else {
                    this.kDBizInterCheckSolu.setData(null);
                }
            }
            catch (Exception currencyInfo) {
                // empty catch block
            }
        }
        if (this.pp.containsKey("targetCompany") && this.pp.getObject("targetCompany") != null) {
            String companyId = (String)this.pp.getObject("targetCompany");
            try {
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.bizCompany.setData((Object)companyInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.pp.containsKey("confirmStatus")) {
            int status = this.pp.getInt("confirmStatus");
            if (status == 2) {
                this.cmbConfirmStatus.setSelectedIndex(2);
            } else if (status == 1) {
                this.cmbConfirmStatus.setSelectedIndex(3);
            } else if (status == 0) {
                this.cmbConfirmStatus.setSelectedIndex(1);
            }
        }
        if (this.pp.containsKey("isShowNotZero")) {
            this.chkShowNotZero.setSelected(this.pp.getBoolean("isShowNotZero"));
        }
        if (this.pp.containsKey("compare")) {
            String compare = this.pp.getString("compare");
            for (int k = 1; k < this.cbCompare.getItemCount(); ++k) {
                String item = (String)this.cbCompare.getItemAt(k);
                if (!compare.equals(item)) continue;
                this.cbCompare.setSelectedIndex(k);
                break;
            }
        }
        if (this.pp.containsKey("value")) {
            BigDecimal newValue = new BigDecimal(this.pp.getString("value"));
            this.txtValue.setNumberValue((Number)newValue);
        }
    }

    @Override
    public RptProperties getCustomCondition() {
        OrgTreeInfo treeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
        String targetCompanyid = null;
        if (this.bizCompany.getValue() != null && !(this.bizCompany.getValue() instanceof String)) {
            targetCompanyid = ((OrgUnitInfo)this.bizCompany.getValue()).getId().toString();
        } else if (this.bizCompany.getValue() != null && this.bizCompany.getValue() instanceof String) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"340_CopyHisDataFilterUI"));
            SysUtil.abort();
        }
        if (treeInfo != null && treeInfo.getId() != null) {
            this.pp.setString("treeId", treeInfo.getId().toString());
        } else {
            this.pp.setString("treeId", null);
        }
        OrgUnitInfo F7orgUnitInfo = OrgClientUtils.getPromptValue((KDBizPromptBox)this.F7Company);
        if (null != F7orgUnitInfo && F7orgUnitInfo.getId() != null) {
            this.pp.setString("orgUnitId", F7orgUnitInfo.getId().toString());
        }
        this.pp.setInt("year", Integer.parseInt(this.spinYear.getValue().toString()));
        this.pp.setInt("period", Integer.parseInt(this.spinPeriod.getValue().toString()));
        this.pp.setInt("periodType", ((RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem()).getValue());
        this.pp.setString("targetCompany", targetCompanyid == null ? null : targetCompanyid);
        this.pp.setString("fromCurrency", null);
        String interCheckSoluId = null;
        if (this.kDBizInterCheckSolu.getValue() != null && this.kDBizInterCheckSolu.getValue() instanceof InterCheckSolutionInfo) {
            interCheckSoluId = ((InterCheckSolutionInfo)this.kDBizInterCheckSolu.getValue()).getId().toString();
        } else if (this.kDBizInterCheckSolu.getValue() != null && this.kDBizInterCheckSolu.getValue() instanceof String) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"340_CopyHisDataFilterUI"));
            SysUtil.abort();
        }
        this.pp.setString("interCheckSolu", interCheckSoluId == null ? null : interCheckSoluId);
        this.pp.setBoolean("isShowNotZero", (Boolean)this.chkShowNotZero.isSelected());
        this.pp.setString("fromCurrency", this.cmbCurrency.getSelectedIndex() == 0 ? null : ((CurrencyInfo)this.cmbCurrency.getSelectedItem()).getId().toString());
        if (this.cmbConfirmStatus.getSelectedIndex() > 0) {
            this.pp.setInt("confirmStatus", ((CheckageConfirmEnum)((Object)this.cmbConfirmStatus.getSelectedItem())).getValue());
        } else {
            this.pp.remove("confirmStatus");
        }
        this.pp.setBoolean("isByCompany", new Boolean(false));
        if (!StringUtils.isEmpty((String)this.cbCompare.getSelectedItem().toString())) {
            this.pp.setString("compare", this.cbCompare.getSelectedItem().toString());
            this.pp.setString("value", this.txtValue.getNumberValue().toString());
        } else {
            this.pp.remove("compare");
            this.pp.remove("value");
        }
        return this.pp;
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        this.fillDataToUI();
    }

    @Override
    public Object getParam() {
        return this.getCustomCondition();
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    @Override
    public CustomerParams getCustomerParams() {
        this.getCustomCondition();
        CustomerParams cp = new CustomerParams();
        if (this.pp.getString("company") != null && this.pp.getString("company") != null) {
            cp.addCustomerParam("company", this.pp.getString("company").toString());
        }
        if (this.pp.getString("fromCurrency") != null && this.pp.getString("fromCurrency") != null) {
            cp.addCustomerParam("fromCurrency", this.pp.getString("fromCurrency").toString());
        }
        if (this.pp.getString("templet") != null && this.pp.getString("templet") != null) {
            cp.addCustomerParam("templet", this.pp.getString("templet").toString());
        }
        if (this.pp.getBoolean("isShowNotZero") || !this.pp.getBoolean("isShowNotZero")) {
            cp.addCustomerParam("isShowNotZero", String.valueOf(this.pp.getBoolean("isShowNotZero")));
        }
        if (this.pp.getString("treeId") != null && this.pp.getString("treeId") != null) {
            cp.addCustomerParam("treeId", this.pp.getString("treeId").toString());
        }
        if (this.pp.getString("orgUnitId") != null && this.pp.getString("orgUnitId") != null) {
            cp.addCustomerParam("orgUnitId", this.pp.getString("orgUnitId").toString());
        }
        if (this.pp.containsKey("confirmStatus")) {
            cp.addCustomerParam("confirmStatus", String.valueOf(this.pp.getInt("confirmStatus")));
        }
        cp.addCustomerParam("year", String.valueOf(this.pp.getInt("year")));
        cp.addCustomerParam("period", String.valueOf(this.pp.getInt("period")));
        cp.addCustomerParam("periodType", String.valueOf(this.pp.getInt("periodType")));
        cp.addCustomerParam("targetCompany", this.pp.getString("targetCompany"));
        cp.addCustomerParam("interCheckSolu", this.pp.getString("interCheckSolu"));
        if (this.pp.containsKey("compare")) {
            cp.addCustomerParam("compare", this.pp.getString("compare"));
            cp.addCustomerParam("value", this.pp.getString("value"));
        }
        return cp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        RptProperties condition = new RptProperties();
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("company") != null) {
            condition.setString("company", cp.getCustomerParam("company"));
        }
        if (cp.getCustomerParam("targetCompany") != null) {
            condition.setString("targetCompany", cp.getCustomerParam("targetCompany"));
        }
        if (cp.getCustomerParam("interCheckSolu") != null) {
            condition.setString("interCheckSolu", cp.getCustomerParam("interCheckSolu"));
        }
        if (cp.getCustomerParam("fromCurrency") != null) {
            condition.setString("fromCurrency", cp.getCustomerParam("fromCurrency"));
        }
        if (cp.getCustomerParam("templet") != null) {
            condition.setString("templet", cp.getCustomerParam("templet"));
        }
        if (cp.getCustomerParam("isShowNotZero") != null) {
            if (cp.getCustomerParam("isShowNotZero").equalsIgnoreCase("true")) {
                condition.setBoolean("isShowNotZero", new Boolean(true));
            } else {
                condition.setBoolean("isShowNotZero", new Boolean(false));
            }
        }
        if (cp.getCustomerParam("treeId") != null) {
            condition.setString("treeId", cp.getCustomerParam("treeId"));
        }
        if (cp.getCustomerParam("orgUnitId") != null) {
            condition.setString("orgUnitId", cp.getCustomerParam("orgUnitId"));
        }
        if (cp.getCustomerParam("year") != null && !cp.getCustomerParam("year").equals(BLANK)) {
            condition.setInt("year", new Integer(cp.getCustomerParam("year")));
        }
        if (cp.getCustomerParam("period") != null && !cp.getCustomerParam("period").equals(BLANK)) {
            condition.setInt("period", new Integer(cp.getCustomerParam("period")));
        }
        if (cp.getCustomerParam("periodType") != null && !cp.getCustomerParam("periodType").equals(BLANK)) {
            condition.setInt("periodType", new Integer(cp.getCustomerParam("periodType")));
        }
        if (cp.getInt("confirmStatus") > 0) {
            condition.setInt("confirmStatus", cp.getInt("confirmStatus"));
        }
        if (cp.getCustomerParam("compare") != null) {
            condition.setString("compare", cp.getCustomerParam("compare"));
            condition.setString("value", cp.getCustomerParam("value"));
        }
        this.setCustomCondition(condition);
    }

    private void clearUI() {
        this.F7Company.setValue(null);
        this.bizCompany.setValue(null);
        this.cmbCurrency.setSelectedItem((Object)this.bsCurrency);
        this.kDBizInterCheckSolu.setValue(null);
        this.cmbConfirmStatus.setSelectedIndex(0);
        if (this.cmbOrgTree.getSelectedIndex() != -1) {
            this.cmbOrgTree.setSelectedIndex(0);
        }
        if (this.cbCompare.getSelectedIndex() != -1) {
            this.txtValue.setNumberValue(null);
            this.cbCompare.setSelectedIndex(0);
        }
    }

    public void clear() {
        super.clear();
        this.clearUI();
        this.pp = null;
        try {
            this.loadInitData();
            this.fillDataToUI();
            Date date = new Date(System.currentTimeMillis());
            Date preDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
            this.dpkDate.setValue((Object)preDate);
            this.cmbCurrency.setSelectedIndex(this.bsCurrency2);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean verify() {
        if (null == this.dpkDate.getValue()) {
            Date date = new Date(System.currentTimeMillis());
            Date preDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
            this.dpkDate.setValue((Object)preDate);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"780_PKDATE_IS_NOT_NULL"));
            SysUtil.abort();
        }
        if (this.F7Company.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NoFindOrgGroup"));
            return false;
        }
        if (!StringUtils.isEmpty((String)this.cbCompare.getSelectedItem().toString()) && this.txtValue.getNumberValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource.893_InterCheckageConditionUI"));
            return false;
        }
        return true;
    }

    public Dimension getSize() {
        return new Dimension(320, 296);
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.client", "MInterAndExchCheckageFilterUI");
    }

    private void refresh13Period() {
        if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isSupport13Period()) {
            int periodType = 0;
            if (BLANK.equals(this.cmbSourceType.getSelectedItem()) || this.cmbSourceType.getSelectedItem() == null) {
                periodType = 0;
            } else {
                RptPeriodTypeEnum rptPeriodTypeEnum = (RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem();
                int n = periodType = rptPeriodTypeEnum == null ? 0 : rptPeriodTypeEnum.getValue();
            }
            if (3 == periodType && RPTDateUtil.isYearLastPeriod((Date)this.dpkDate.getValue(), RptPeriodTypeEnum.MONTHLY)) {
                this.spinPeriod.setEnabled(true);
                CslRptUIUtil.setSpineRange(this.spinPeriod, 12, 13);
            } else {
                this.spinPeriod.setEnabled(false);
                CslRptUIUtil.setSpineRange(this.spinPeriod, 0, 365);
            }
        }
    }
}

