/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.Checkage;
import com.kingdee.eas.fi.gr.cslrpt.CheckageConfirmEnum;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DiffHandleStrategy;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationItemMapFactory;
import com.kingdee.eas.fi.gr.cslrpt.ExchCheckageFactory;
import com.kingdee.eas.fi.gr.cslrpt.ExchCheckageInfo;
import com.kingdee.eas.fi.gr.cslrpt.IExchCheckage;
import com.kingdee.eas.fi.gr.cslrpt.IInterCheck;
import com.kingdee.eas.fi.gr.cslrpt.IInterDataCheckage;
import com.kingdee.eas.fi.gr.cslrpt.IInterDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckException;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckFactory;
import com.kingdee.eas.fi.gr.cslrpt.InterDataCheckageFactory;
import com.kingdee.eas.fi.gr.cslrpt.InterDataCheckageInfo;
import com.kingdee.eas.fi.gr.cslrpt.InterDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.InterTradeClientUtils;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInterAndExchDiffHandleUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslBaseMainUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class InterAndExchDiffHandleUI
extends AbstractInterAndExchDiffHandleUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(InterAndExchDiffHandleUI.class);
    private static final String TB_ID = "fid";
    private static final String TB_NUMBER = "number";
    private static final String TB_ELIMTEMPLET = "elimTemplet";
    private static final String TB_COMPANY = "company";
    private static final String TB_TARGETCOMPANY = "targetCompany";
    private static final String TB_ELIMTYPE = "elimType";
    private static final String TB_ELIMTEMPLETID = "elimTempletId";
    private static final String TB_DIFFMODE = "diffMode";
    private static final String TB_DETAIL_COMPANY = "company";
    private static final String TB_DETAIL_TARGET_COMPANY = "targetCompany";
    private static final String TB_DETAIL_ITEM_NUMBER = "itemNumber";
    private static final String TB_DETAIL_ITEM_NAME = "itemName";
    private static final String TB_DETAIL_DATAELEMENT = "dataElement";
    private static final String TB_DETAIL_DEBIT = "debit";
    private static final String TB_DETAIL_CREDIT = "credit";
    private static final String TB_DETAIL_VALID_DEBIT = "valiDebit";
    private static final String TB_DETAIL_VALID_CREDIT = "valiCredit";
    private static final String TB_DETAIL_DC = "dc";
    private static final String TB_DETAIL_COMPANYID = "companyId";
    private static final String TB_DETAIL_TARGETCOMPANYID = "targetCompanyId";
    private String oldId = null;
    private String newId = null;
    private boolean bNeedReleaseLock = false;
    List debitList = new ArrayList();
    List creditList = new ArrayList();
    private List companyIds = new ArrayList();
    private Map companyMap = null;
    private int isIncludeDiffItem = 0;
    private Map mapDiffItemNumbers = new HashMap();
    private BigDecimal debitTotal = null;
    private BigDecimal creditTotal = null;
    private BigDecimal validDebitTotal = null;
    private BigDecimal validCreditTotal = null;
    private int iCurrencyPrecision = 0;
    private BigDecimal rawDiffValue = null;
    private BigDecimal diffValue = null;
    private boolean oneEqualsInputed = false;
    private BigDecimal oldValue = null;
    private int singleDC = 0;
    private int dc = 0;
    private IRowSet rs = null;
    private boolean isInit = false;
    private String minTotal = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"labMinTotal").toString();
    private String total = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"labTotal").toString();
    private boolean fireDiffMode = true;
    private boolean canCheckageNotBalance = false;
    private boolean isOldData = true;

    public void onLoad() throws Exception {
        this.canCheckageNotBalance = CSLParamUtil.canCheckOnNotBalance(null);
        this.kdtEntries.checkParsed();
        this.kdtEntries.getSelectManager().setSelectMode(2);
        this.kdtEntryDetails.checkParsed();
        this.iCurrencyPrecision = Integer.parseInt(this.getUIContext().get("currency.precision").toString());
        this.hiddenEntryDetails();
        this.getAndFillEntryData();
        super.onLoad();
        this.initEntryTable();
        KeyStroke ks = KeyStroke.getKeyStroke(61, 0);
        String strKey = "InterUI.EQUALS";
        this.getActionMap().remove(strKey);
        this.getActionMap().put(strKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InterAndExchDiffHandleUI.this.setCellDiffValue();
                }
                catch (Exception e1) {
                    InterAndExchDiffHandleUI.this.handUIException(e1);
                }
            }
        });
        this.getInputMap(2).put(ks, strKey);
        KeyStroke Zks = KeyStroke.getKeyStroke(90, 1);
        String ZstrKey = "InterUI.Z";
        this.getActionMap().remove(ZstrKey);
        this.getActionMap().put(ZstrKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InterAndExchDiffHandleUI.this.setCellDiffValue();
                }
                catch (Exception e1) {
                    InterAndExchDiffHandleUI.this.handUIException(e1);
                }
            }
        });
        this.getInputMap(2).put(Zks, ZstrKey);
    }

    protected void setCellDiffValue() {
        boolean isHand = DiffModeEnum.FetchHandCraft.equals(this.comboDiffMode.getSelectedItem());
        if (isHand && this.oneEqualsInputed) {
            KDTSelectManager manager = this.kdtEntryDetails.getSelectManager();
            int rowIndex = manager.getActiveRowIndex();
            int columnIndex = manager.getActiveColumnIndex();
            int creditColIndex = this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_CREDIT).getColumnIndex();
            int debitColIndex = this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_DEBIT).getColumnIndex();
            if (creditColIndex == columnIndex || debitColIndex == columnIndex) {
                BigDecimal diffVal = BigDecimal.ZERO;
                try {
                    diffVal = new BigDecimal(this.txtConfirmDiffVal.getValue().toString());
                }
                catch (Exception e) {
                    logger.error((Object)"get diff Value error", (Throwable)e);
                }
                BigDecimal setCellValue = debitColIndex == columnIndex ? this.oldValue.subtract(diffVal) : this.oldValue.add(diffVal);
                this.kdtEntryDetails.getCell(rowIndex, columnIndex).setValue(null);
                this.kdtEntryDetails.getCell(rowIndex, columnIndex).setValue((Object)setCellValue);
            }
            this.oneEqualsInputed = false;
        }
    }

    protected void initListener() {
        this.initEntryDetailTable();
        this.kdtEntries.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock b = e.getSelectBlock();
                if (b.getBeginRow() == b.getEndRow()) {
                    IRow row = InterAndExchDiffHandleUI.this.kdtEntries.getRow(b.getBeginRow());
                    InterAndExchDiffHandleUI.this.reSetSplitPane(row);
                    try {
                        InterAndExchDiffHandleUI.this.getAndFillEntryDetailsData();
                    }
                    catch (BOSException e1) {
                        InterAndExchDiffHandleUI.this.handUIException(e1);
                    }
                } else {
                    InterAndExchDiffHandleUI.this.hiddenEntryDetails();
                }
            }
        });
        this.comboDiffMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && InterAndExchDiffHandleUI.this.fireDiffMode) {
                    InterAndExchDiffHandleUI.this.diffModeChangePerformed();
                }
            }
        });
        this.kdtEntries.getSelectManager().select(0, 0);
    }

    private void initEntryTable() {
        this.actionSubmit.setEnabled(false);
        this.btnSubmit.setEnabled(false);
        this.menuItemSubmit.setEnabled(false);
        this.txtNumber.setEnabled(false);
        this.comboCheckedStatus.setEnabled(false);
        this.txtDiffValue.setEnabled(false);
        this.txtDebitTotal.setEnabled(false);
        this.txtCreditTotal.setEnabled(false);
        this.txtValidDebitTotal.setEnabled(false);
        this.txtValidCreditTotal.setEnabled(false);
        this.txtConfirmDiffVal.setEnabled(false);
        this.comboDiffMode.setEnabled(false);
        this.kdtEntries.getColumn(TB_NUMBER).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_ELIMTEMPLET).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("company").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("targetCompany").getStyleAttributes().setLocked(true);
        this.txtValidDebitTotal.setMaximumValue(null);
        this.txtValidDebitTotal.setMinimumValue(null);
        this.txtValidCreditTotal.setMaximumValue(null);
        this.txtValidCreditTotal.setMinimumValue(null);
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setSupportedEmpty(true);
        formatField.setPrecision(this.iCurrencyPrecision);
        KDTDefaultCellEditor dcEditor = new KDTDefaultCellEditor((JTextField)formatField);
        this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_CREDIT).setEditor((ICellEditor)dcEditor);
        this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_DEBIT).setEditor((ICellEditor)dcEditor);
    }

    private void initEntryDetailTable() {
        this.actionSubmit.setEnabled(true);
        this.btnSubmit.setEnabled(true);
        this.menuItemSubmit.setEnabled(true);
        this.comboDiffMode.setEnabled(true);
        this.kdtEntryDetails.getColumn("company").getStyleAttributes().setLocked(true);
        this.kdtEntryDetails.getColumn("targetCompany").getStyleAttributes().setLocked(true);
        this.kdtEntryDetails.getColumn(TB_DETAIL_ITEM_NUMBER).getStyleAttributes().setLocked(true);
        this.kdtEntryDetails.getColumn(TB_DETAIL_ITEM_NAME).getStyleAttributes().setLocked(true);
        this.kdtEntryDetails.getColumn(TB_DETAIL_DEBIT).getStyleAttributes().setLocked(true);
        this.kdtEntryDetails.getColumn(TB_DETAIL_CREDIT).getStyleAttributes().setLocked(true);
        this.kdtEntryDetails.getColumn(TB_DETAIL_DATAELEMENT).getStyleAttributes().setLocked(true);
        String diffMode = this.getSelectedRowKeyValue(TB_DIFFMODE);
        if (String.valueOf((Object)DiffModeEnum.FetchHandCraft).equals(diffMode)) {
            this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_DEBIT).getStyleAttributes().setLocked(false);
            this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_CREDIT).getStyleAttributes().setLocked(false);
        } else {
            this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_DEBIT).getStyleAttributes().setLocked(true);
            this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_CREDIT).getStyleAttributes().setLocked(true);
        }
        this.kdtEntryDetails.getColumn(TB_DETAIL_DEBIT).getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.kdtEntryDetails.getColumn(TB_DETAIL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntryDetails.getColumn(TB_DETAIL_CREDIT).getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.kdtEntryDetails.getColumn(TB_DETAIL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_DEBIT).getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_CREDIT).getStyleAttributes().setNumberFormat("%R-{#,##0.00}f");
        this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IRow footRow = null;
        KDTFootManager footRowManager = this.kdtEntryDetails.getFootManager();
        if (footRowManager != null) {
            footRow = footRowManager.getFootRow(0);
        } else {
            footRowManager = new KDTFootManager(this.kdtEntryDetails);
            footRowManager.addFootView();
            this.kdtEntryDetails.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
        }
        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
        footRow.getCell(0).setValue((Object)this.total);
        footRow.getCell(TB_DETAIL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        footRow.getCell(TB_DETAIL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        footRow.getCell(TB_DETAIL_VALID_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        footRow.getCell(TB_DETAIL_VALID_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        ValueChangeListener v = new ValueChangeListener(this.comboDiffMode, this.kdtEntryDetails, this.txtValidDebitTotal, this.txtValidCreditTotal);
        this.kdtEntryDetails.addKDTPropertyChangeListener((KDTPropertyChangeListener)v);
        this.kdtEntryDetails.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
                InterAndExchDiffHandleUI.this.oneEqualsInputed = true;
                int creditColIndex = InterAndExchDiffHandleUI.this.kdtEntryDetails.getColumn(InterAndExchDiffHandleUI.TB_DETAIL_VALID_CREDIT).getColumnIndex();
                int debitColIndex = InterAndExchDiffHandleUI.this.kdtEntryDetails.getColumn(InterAndExchDiffHandleUI.TB_DETAIL_VALID_DEBIT).getColumnIndex();
                if (creditColIndex == e.getColIndex() || debitColIndex == e.getColIndex()) {
                    Object oldValueObj = InterAndExchDiffHandleUI.this.kdtEntryDetails.getCell(e.getRowIndex(), e.getColIndex()).getValue();
                    InterAndExchDiffHandleUI.this.oldValue = oldValueObj == null ? BigDecimal.ZERO : new BigDecimal(oldValueObj.toString());
                }
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                InterAndExchDiffHandleUI.this.tableValueChanged(e);
                InterAndExchDiffHandleUI.this.oneEqualsInputed = false;
                InterAndExchDiffHandleUI.this.oldValue = null;
            }
        });
    }

    private void getAndFillEntryData() throws BOSException, EASBizException {
        Map param = (Map)this.getUIContext().get("param");
        List list = (List)this.getUIContext().get("idList");
        param.put("idList", list);
        IInterDataProvider iInterData = InterDataProviderFactory.getRemoteInstance();
        Map result = iInterData.getCheckProfileData(param);
        IRowSet rst = (IRowSet)result.get("result");
        if (rst == null || rst.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"923_checkNotExist"));
            SysUtil.abort();
            return;
        }
        this.kdtEntries.setRefresh(false);
        int rowIndex = 0;
        try {
            while (rst.next()) {
                IRow row = this.kdtEntries.addRow(rowIndex++);
                String[] colNames = new String[this.kdtEntries.getColumns().getColumns().size()];
                for (int i = 0; i < colNames.length; ++i) {
                    KDTColumn col = (KDTColumn)this.kdtEntries.getColumns().getColumns().get(i);
                    colNames[i] = col.getKey();
                }
                for (int n = 0; n < colNames.length; ++n) {
                    row.getCell(colNames[n]).setValue(rst.getObject(n + 1));
                }
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        this.kdtEntries.setRefresh(true);
        this.kdtEntries.reLayoutAndPaint();
        this.groupTableRow();
    }

    private void groupTableRow() {
        this.kdtEntries.getGroupManager().setGroup(true);
        this.kdtEntries.getColumn(TB_ID).setGroup(true);
        this.kdtEntries.getColumn(TB_NUMBER).setGroup(true);
        this.kdtEntries.getColumn(TB_ELIMTEMPLET).setGroup(true);
        this.kdtEntries.getColumn(TB_ID).setMergeable(true);
        this.kdtEntries.getColumn(TB_NUMBER).setMergeable(true);
        this.kdtEntries.getColumn(TB_ELIMTEMPLET).setMergeable(true);
    }

    private void hiddenEntryDetails() {
        this.kDSplitPane1.remove((Component)this.kDContainer1);
        this.kDSplitPane1.setDividerSize(0);
        this.kDSplitPane1.setDividerLocation(1.0);
    }

    private void reSetSplitPane(IRow row) {
        this.kDSplitPane1.remove((Component)this.kDContainer1);
        this.kDSplitPane1.setDividerSize(10);
        this.kDSplitPane1.setDividerLocation(0.4);
        this.kDSplitPane1.setOneTouchExpandable(true);
        this.kDSplitPane1.setHasDividerPointer(true);
        this.kDContainer1.setFocusTraversalKeysEnabled(true);
        this.kDSplitPane1.add((Component)this.kDContainer1);
        this.kdtEntryDetails.removeRows();
    }

    private String getSelectedRowKeyValue(String key) {
        KDTSelectBlock selectBlock = this.kdtEntries.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.kdtEntries.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(key);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    private void diffModeChangePerformed() {
        CoreBaseCollection cbaseColl = new CoreBaseCollection();
        String templetId = this.getSelectedRowKeyValue(TB_ELIMTEMPLETID);
        try {
            StringBuffer buffer = new StringBuffer("SELECT");
            buffer.append(" selfCompanyTtem.Id, selfCompanyTtem.Name, selfCompanyTtem.number,").append(" otherCompanyTtem.Id, otherCompanyTtem.Name, otherCompanyTtem.number,").append(" elimTemple.id ").append(" WHERE elimTemple='").append(templetId).append("'").append(" ORDER BY seq");
            cbaseColl = EliminationItemMapFactory.getRemoteInstance().getCollection(buffer.toString());
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        Checkage checkage = this.getCheckage();
        DiffModeEnum diffMode = (DiffModeEnum)((Object)this.comboDiffMode.getSelectedItem());
        checkage.setCbaseColl(cbaseColl);
        DiffHandleStrategy strategy = new DiffHandleStrategy(diffMode.getValue(), checkage);
        strategy.execute();
        boolean isFetchHandCraft = DiffModeEnum.FetchHandCraft.equals((Object)diffMode);
        if (isFetchHandCraft) {
            checkage.setValiCreditTotal(checkage.getCreditTotal());
            checkage.setValiDebitTotal(checkage.getDebitTotal());
        }
        this.fillDataIntoTable(checkage);
        this.setControlEditable(isFetchHandCraft);
    }

    private Checkage getCheckage() {
        ArrayList entries = new ArrayList();
        BigDecimal debitAll = new BigDecimal("0");
        BigDecimal creditAll = new BigDecimal("0");
        boolean isSameCompany = false;
        for (int i = 0; i < this.kdtEntryDetails.getRowCount(); ++i) {
            IRow row = this.kdtEntryDetails.getRow(i);
            if (row.getCell(TB_DETAIL_ITEM_NUMBER) == null || row.getCell(TB_DETAIL_ITEM_NUMBER).getValue() == null) continue;
            String strItemNumber = row.getCell(TB_DETAIL_ITEM_NUMBER).getValue().toString();
            HashMap<String, Object> entry = new HashMap<String, Object>();
            Object dataElement = row.getCell(TB_DETAIL_DATAELEMENT).getValue();
            if (dataElement == null || !(dataElement instanceof DataElementInfo)) continue;
            entry.put("dataelement", ((DataElementInfo)dataElement).getNumber());
            entry.put("itemnumber", strItemNumber);
            entry.put(TB_DETAIL_DC, row.getCell(TB_DETAIL_DC).getValue());
            entry.put("dataSrcType", this.mapDiffItemNumbers.containsKey(strItemNumber) ? new Integer(2) : new Integer(1));
            entry.put("isIncludeDiffItem", new Integer(this.isIncludeDiffItem));
            entry.put(TB_DETAIL_DEBIT, row.getCell(TB_DETAIL_DEBIT).getValue());
            entry.put(TB_DETAIL_CREDIT, row.getCell(TB_DETAIL_CREDIT).getValue());
            entry.put("validebit", row.getCell(TB_DETAIL_DEBIT).getValue());
            entry.put("valicredit", row.getCell(TB_DETAIL_CREDIT).getValue());
            entry.put("companyid", row.getCell(TB_DETAIL_COMPANYID).getValue());
            entry.put("targetcompanyid", row.getCell(TB_DETAIL_TARGETCOMPANYID).getValue());
            entry.put("seq", new Integer(i + 1));
            debitAll = debitAll.add(new BigDecimal(row.getCell(TB_DETAIL_DEBIT).getValue().toString()));
            creditAll = creditAll.add(new BigDecimal(row.getCell(TB_DETAIL_CREDIT).getValue().toString()));
            entries.add(entry);
            if (!row.getCell(TB_DETAIL_COMPANYID).getValue().equals(row.getCell(TB_DETAIL_TARGETCOMPANYID).getValue())) continue;
            isSameCompany = true;
        }
        Checkage checkage = new Checkage();
        checkage.setDebitTotal(debitAll);
        checkage.setCreditTotal(creditAll);
        BigDecimal diffValue = CslConstant.BGZERO;
        diffValue = debitAll.subtract(creditAll);
        checkage.setDiffValue(diffValue);
        checkage.setAbsDiffValue(diffValue.abs());
        DiffModeEnum diffMode = (DiffModeEnum)((Object)this.comboDiffMode.getSelectedItem());
        checkage.setDiffMode(diffMode.getValue());
        checkage.setSameCompany(isSameCompany);
        checkage.setCheckedParty(this.isOldData ? 0 : 1);
        checkage.setEntries(entries);
        return checkage;
    }

    private void fillDataIntoTable(Checkage checkage) {
        List entries = checkage.getEntries();
        BigDecimal debitTotal = CslConstant.BGZERO;
        BigDecimal creditTotal = CslConstant.BGZERO;
        int size = entries.size();
        int addRow = 0;
        HashMap<String, BigDecimal[]> groupKey_values = new HashMap<String, BigDecimal[]>();
        for (int i = 0; i < size; ++i) {
            Map entry = (Map)entries.get(i);
            int rowIndex = (Integer)entry.get("seq") - 1 + addRow;
            IRow row = this.kdtEntryDetails.getRow(rowIndex);
            if (row.getCell("company").getValue().equals(this.minTotal)) continue;
            row.getCell(TB_DETAIL_VALID_DEBIT).setValue(entry.get("validebit"));
            row.getCell(TB_DETAIL_VALID_CREDIT).setValue(entry.get("valicredit"));
            debitTotal = debitTotal.add(entry.get("validebit") == null ? CslConstant.BGZERO : (BigDecimal)entry.get("validebit"));
            creditTotal = creditTotal.add(entry.get("valicredit") == null ? CslConstant.BGZERO : (BigDecimal)entry.get("valicredit"));
            if (!this.addLitterTotleRow(groupKey_values, row, i == size - 1, false) || i == size - 1) continue;
            ++addRow;
        }
        this.txtValidDebitTotal.setValue((Object)checkage.getValiDebitTotal());
        this.txtValidCreditTotal.setValue((Object)checkage.getValiCreditTotal());
        this.txtConfirmDiffVal.setValue((Object)debitTotal.subtract(creditTotal));
        this.setTotle(false);
    }

    private void setControlEditable(boolean isFetchHand) {
        this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_DEBIT).getStyleAttributes().setLocked(!isFetchHand);
        this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_CREDIT).getStyleAttributes().setLocked(!isFetchHand);
    }

    private void getAndFillEntryDetailsData() throws BOSException {
        this.isInit = true;
        IInterCheck iInterCheck = InterCheckFactory.getRemoteInstance();
        IExchCheckage checkageData = ExchCheckageFactory.getRemoteInstance();
        IRow row = null;
        String currentId = this.getSelectedRowKeyValue(TB_ID);
        try {
            this.initSingleDC();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        try {
            this.rs = iInterCheck.getCheckageRecord(currentId, this.getElimType());
            if (this.rs == null) {
                return;
            }
            this.resetControlValue();
            this.kdtEntryDetails.removeRows();
            this.rs.beforeFirst();
            boolean first = true;
            this.companyMap = new HashMap();
            this.companyIds.clear();
            String strItemNumber = null;
            DiffModeEnum diffMode = null;
            HashMap<String, BigDecimal[]> groupKey_values = new HashMap<String, BigDecimal[]>();
            while (this.rs.next()) {
                if (this.rs.getInt("fdatasrctype") == 2) {
                    this.isIncludeDiffItem = 1;
                    strItemNumber = this.rs.getString("FItemNumber");
                    if (strItemNumber != null && !this.mapDiffItemNumbers.containsKey(strItemNumber)) {
                        this.mapDiffItemNumbers.put(strItemNumber, strItemNumber);
                    }
                }
                if (first && this.rs.getString("FNumber") != null && this.rs.getString(TB_ID) != null) {
                    first = false;
                    this.txtDescription.setText(this.rs.getString("FDescription"));
                    this.txtNumber.setText(this.getSelectedRowKeyValue(TB_NUMBER));
                    this.comboCheckedStatus.setSelectedItem((Object)(this.rs.getInt("FCheckedStatus") == 2 ? CheckageConfirmEnum.Confirm : CheckageConfirmEnum.UnConfirm));
                    diffMode = this.getDiffModeEnum(this.rs.getInt("FDiffMode"));
                    this.rawDiffValue = this.rs.getBigDecimal("FDiffValue") == null ? new BigDecimal("0") : this.rs.getBigDecimal("FDiffValue");
                    this.diffValue = this.rawDiffValue.abs();
                    this.companyMap.put(this.rs.getString("fcompanyName"), this.rs.getString("fcompanyid"));
                    this.companyMap.put(this.rs.getString("ftargetcompanyName"), this.rs.getString("ftargetcompanyid"));
                    this.setControlEditable(DiffModeEnum.FetchHandCraft.equals((Object)diffMode));
                }
                this.companyMap.put(this.rs.getString("fitemname"), this.rs.getString("fitemid"));
                row = this.kdtEntryDetails.addRow();
                row.getCell("company").setValue((Object)this.rs.getString("FCompanyName"));
                row.getCell("targetCompany").setValue((Object)this.rs.getString("FTargetCompanyName"));
                row.getCell(TB_DETAIL_ITEM_NUMBER).setValue((Object)this.rs.getString("FItemNumber"));
                row.getCell(TB_DETAIL_ITEM_NAME).setValue((Object)this.rs.getString("FItemName"));
                row.getCell(TB_DETAIL_DATAELEMENT).setValue((Object)DataElementProvider.getDataElementInfo(this.rs.getInt("fdataelement")));
                row.getCell(TB_DETAIL_DEBIT).setValue((Object)this.rs.getBigDecimal("FDebit"));
                row.getCell(TB_DETAIL_CREDIT).setValue((Object)this.rs.getBigDecimal("FCredit"));
                row.getCell(TB_DETAIL_VALID_DEBIT).setValue((Object)this.rs.getBigDecimal("FValiDebit"));
                row.getCell(TB_DETAIL_VALID_CREDIT).setValue((Object)this.rs.getBigDecimal("FValiCredit"));
                row.getCell(TB_DETAIL_DC).setValue((Object)new Integer(this.rs.getInt("FDC")));
                row.getCell(TB_DETAIL_COMPANYID).setValue((Object)this.rs.getString("FCompanyId"));
                row.getCell(TB_DETAIL_TARGETCOMPANYID).setValue((Object)this.rs.getString("FTargetCompanyId"));
                this.addLitterTotleRow(groupKey_values, row, this.rs.isLast(), true);
                String amount = null;
                String companyid = this.rs.getString("fcompanyid") + this.rs.getString("ftargetcompanyid");
                amount = this.rs.getBigDecimal("FDebit").compareTo(SysConstant.BIGZERO) > 0 ? "-" + this.rs.getBigDecimal("FDebit").setScale(10).toString() + TB_DETAIL_DEBIT : this.rs.getBigDecimal("FDebit").setScale(10).toString().replaceAll("-", "") + TB_DETAIL_DEBIT;
                if (this.rs.getBigDecimal("FDebit") != null && this.rs.getBigDecimal("FDebit").compareTo(SysConstant.BIGZERO) != 0) {
                    if (this.creditList.contains(this.rs.getBigDecimal("FDebit").setScale(10).toString() + TB_DETAIL_CREDIT)) {
                        this.creditList.remove(this.rs.getBigDecimal("FDebit").setScale(10).toString() + TB_DETAIL_CREDIT);
                    } else if (this.debitList.contains(amount)) {
                        this.debitList.remove(amount);
                    } else {
                        this.debitList.add(this.rs.getBigDecimal("FDebit").setScale(10).toString() + TB_DETAIL_DEBIT);
                    }
                    if (!this.companyIds.contains(companyid)) {
                        this.companyIds.add(companyid);
                    }
                }
                amount = this.rs.getBigDecimal("FCredit").compareTo(SysConstant.BIGZERO) > 0 ? "-" + this.rs.getBigDecimal("FCredit").setScale(10).toString() + TB_DETAIL_CREDIT : this.rs.getBigDecimal("FCredit").setScale(10).toString().replaceAll("-", "") + TB_DETAIL_CREDIT;
                if (this.rs.getBigDecimal("FCredit") == null || this.rs.getBigDecimal("FCredit").compareTo(SysConstant.BIGZERO) == 0) continue;
                if (this.debitList.contains(this.rs.getBigDecimal("FCredit").setScale(10).toString() + TB_DETAIL_DEBIT)) {
                    this.debitList.remove(this.rs.getBigDecimal("FCredit").setScale(10).toString() + TB_DETAIL_DEBIT);
                } else if (this.creditList.contains(amount)) {
                    this.creditList.remove(amount);
                } else {
                    this.creditList.add(this.rs.getBigDecimal("FCredit").setScale(10).toString() + TB_DETAIL_CREDIT);
                }
                if (this.companyIds.contains(companyid)) continue;
                this.companyIds.add(companyid);
            }
            this.checkEnable(true);
            if (diffMode != null) {
                this.fireDiffMode = false;
                this.comboDiffMode.setSelectedItem(diffMode);
                this.fireDiffMode = true;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.calcuTotalValue(this.rs);
        this.doPrecision();
        this.isInit = false;
        this.checkHasAudited();
    }

    private void resetControlValue() {
        this.debitTotal = CslConstant.BGZERO;
        this.creditTotal = CslConstant.BGZERO;
        this.validDebitTotal = CslConstant.BGZERO;
        this.validCreditTotal = CslConstant.BGZERO;
        this.rawDiffValue = CslConstant.BGZERO;
        this.diffValue = CslConstant.BGZERO;
    }

    private void calcuTotalValue(IRowSet rs) {
        if (rs == null) {
            return;
        }
        this.debitTotal = new BigDecimal("0");
        this.creditTotal = new BigDecimal("0");
        this.validDebitTotal = new BigDecimal("0");
        this.validCreditTotal = new BigDecimal("0");
        this.txtDiffValue.setPrecision(this.iCurrencyPrecision);
        try {
            rs.beforeFirst();
            while (rs.next()) {
                this.debitTotal = this.debitTotal.add(rs.getBigDecimal("FDebit"));
                this.creditTotal = this.creditTotal.add(rs.getBigDecimal("FCredit"));
                this.validDebitTotal = this.validDebitTotal.add(rs.getBigDecimal("FValiDebit"));
                this.validCreditTotal = this.validCreditTotal.add(rs.getBigDecimal("FValiCredit"));
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        this.txtDebitTotal.setPrecision(this.iCurrencyPrecision);
        this.txtCreditTotal.setPrecision(this.iCurrencyPrecision);
        this.txtValidDebitTotal.setPrecision(this.iCurrencyPrecision);
        this.txtValidCreditTotal.setPrecision(this.iCurrencyPrecision);
        this.txtDiffValue.setPrecision(this.iCurrencyPrecision);
        this.txtConfirmDiffVal.setPrecision(this.iCurrencyPrecision);
        this.txtDebitTotal.setValue((Object)this.debitTotal.setScale(this.iCurrencyPrecision, 4));
        this.txtCreditTotal.setValue((Object)this.creditTotal.setScale(this.iCurrencyPrecision, 4));
        this.txtValidDebitTotal.setValue((Object)this.validDebitTotal.setScale(this.iCurrencyPrecision, 4));
        this.txtValidCreditTotal.setValue((Object)this.validCreditTotal.setScale(this.iCurrencyPrecision, 4));
        this.txtDiffValue.setValue((Object)this.debitTotal.subtract(this.creditTotal).setScale(this.iCurrencyPrecision, 4));
        this.txtConfirmDiffVal.setValue((Object)this.validDebitTotal.subtract(this.validCreditTotal).setScale(this.iCurrencyPrecision, 4));
        this.rawDiffValue = this.debitTotal.subtract(this.creditTotal);
        this.diffValue = this.rawDiffValue.abs();
        this.setTotle(true);
    }

    private void setTotle(boolean isSetNotValid) {
        KDTFootManager footManager = this.kdtEntryDetails.getFootManager();
        if (footManager != null) {
            IRow footRow = footManager.getFootRow(0);
            if (isSetNotValid) {
                footRow.getCell(TB_DETAIL_DEBIT).setValue(this.txtDebitTotal.getValue());
                footRow.getCell(TB_DETAIL_CREDIT).setValue(this.txtCreditTotal.getValue());
            }
            footRow.getCell(TB_DETAIL_VALID_DEBIT).setValue(this.txtValidDebitTotal.getValue());
            footRow.getCell(TB_DETAIL_VALID_CREDIT).setValue(this.txtValidCreditTotal.getValue());
        }
    }

    private void doPrecision() {
        int iRowCount = this.kdtEntryDetails.getRowCount();
        BigDecimal debit = null;
        BigDecimal credit = null;
        BigDecimal valiDebit = null;
        BigDecimal valiCredit = null;
        for (int i = 0; i < iRowCount; ++i) {
            debit = (BigDecimal)this.kdtEntryDetails.getCell(i, TB_DETAIL_DEBIT).getValue();
            credit = (BigDecimal)this.kdtEntryDetails.getCell(i, TB_DETAIL_CREDIT).getValue();
            valiDebit = (BigDecimal)this.kdtEntryDetails.getCell(i, TB_DETAIL_VALID_DEBIT).getValue();
            valiCredit = (BigDecimal)this.kdtEntryDetails.getCell(i, TB_DETAIL_VALID_CREDIT).getValue();
            if (this.iCurrencyPrecision == 0) {
                this.iCurrencyPrecision = 2;
            }
            if (debit != null) {
                debit = debit.setScale(this.iCurrencyPrecision, 4);
            }
            if (credit != null) {
                credit = credit.setScale(this.iCurrencyPrecision, 4);
            }
            if (valiDebit != null) {
                valiDebit = valiDebit.setScale(this.iCurrencyPrecision, 4);
            }
            if (valiCredit != null) {
                valiCredit = valiCredit.setScale(this.iCurrencyPrecision, 4);
            }
            this.kdtEntryDetails.getCell(i, TB_DETAIL_DEBIT).setValue((Object)debit);
            this.kdtEntryDetails.getCell(i, TB_DETAIL_CREDIT).setValue((Object)credit);
            this.kdtEntryDetails.getCell(i, TB_DETAIL_VALID_DEBIT).setValue((Object)valiDebit);
            this.kdtEntryDetails.getCell(i, TB_DETAIL_VALID_CREDIT).setValue((Object)valiCredit);
        }
    }

    private DiffModeEnum getDiffModeEnum(int diffMode) {
        DiffModeEnum diffEnum;
        switch (diffMode) {
            case 5: {
                diffEnum = DiffModeEnum.FetchAverage;
                break;
            }
            case 1: {
                diffEnum = DiffModeEnum.FetchBig;
                break;
            }
            case 4: {
                diffEnum = DiffModeEnum.FetchCredit;
                break;
            }
            case 3: {
                diffEnum = DiffModeEnum.FetchDebit;
                break;
            }
            case 10: {
                diffEnum = DiffModeEnum.FetchHandCraft;
                break;
            }
            case 2: {
                diffEnum = DiffModeEnum.FetchSmall;
                break;
            }
            case 6: {
                diffEnum = DiffModeEnum.FetchZero;
                break;
            }
            default: {
                diffEnum = DiffModeEnum.FetchHandCraft;
            }
        }
        return diffEnum;
    }

    private Map getCheckageMap(IRowSet rs, String currentId) {
        HashMap<String, Object> checkageMap = new HashMap<String, Object>();
        HashMap entries = new HashMap();
        checkageMap.put("id", currentId);
        checkageMap.put("description", this.txtDescription.getText());
        checkageMap.put(TB_DIFFMODE, this.comboDiffMode.getSelectedItem());
        checkageMap.put("entries", entries);
        HashMap recordMap = new HashMap();
        HashMap<String, BigDecimal> moneyMap = null;
        BigDecimal zero = new BigDecimal("0");
        int n = this.kdtEntryDetails.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntryDetails.getRow(i);
            if (row.getCell("company").getValue().equals(this.minTotal) || row.getCell(TB_DETAIL_DEBIT).getValue() == null && ((BigDecimal)row.getCell(TB_DETAIL_DEBIT).getValue()).compareTo(zero) == 0 && row.getCell(TB_DETAIL_CREDIT).getValue() == null && ((BigDecimal)row.getCell(TB_DETAIL_CREDIT).getValue()).compareTo(zero) == 0 && row.getCell(TB_DETAIL_VALID_DEBIT).getValue() == null && ((BigDecimal)row.getCell(TB_DETAIL_VALID_DEBIT).getValue()).compareTo(zero) == 0 && row.getCell(TB_DETAIL_VALID_CREDIT).getValue() == null && ((BigDecimal)row.getCell(TB_DETAIL_VALID_CREDIT).getValue()).compareTo(zero) == 0) continue;
            BigDecimal debit = (BigDecimal)this.kdtEntryDetails.getRow(i).getCell(TB_DETAIL_DEBIT).getValue();
            BigDecimal credit = (BigDecimal)this.kdtEntryDetails.getRow(i).getCell(TB_DETAIL_CREDIT).getValue();
            BigDecimal validebit = (BigDecimal)this.kdtEntryDetails.getRow(i).getCell(TB_DETAIL_VALID_DEBIT).getValue();
            BigDecimal valicredit = (BigDecimal)this.kdtEntryDetails.getRow(i).getCell(TB_DETAIL_VALID_CREDIT).getValue();
            debit = debit == null ? this.setDefualtValue(debit) : debit;
            credit = credit == null ? this.setDefualtValue(credit) : credit;
            validebit = validebit == null ? this.setDefualtValue(validebit) : validebit;
            valicredit = valicredit == null ? this.setDefualtValue(valicredit) : valicredit;
            moneyMap = new HashMap<String, BigDecimal>();
            moneyMap.put(TB_DETAIL_DEBIT, debit.setScale(this.iCurrencyPrecision, 4));
            moneyMap.put(TB_DETAIL_CREDIT, credit.setScale(this.iCurrencyPrecision, 4));
            moneyMap.put(TB_DETAIL_VALID_DEBIT, validebit.setScale(this.iCurrencyPrecision, 4));
            moneyMap.put(TB_DETAIL_VALID_CREDIT, valicredit.setScale(this.iCurrencyPrecision, 4));
            recordMap.put((String)row.getCell("company").getValue() + (String)row.getCell("targetCompany").getValue() + (String)row.getCell(TB_DETAIL_ITEM_NUMBER).getValue() + ((DataElementInfo)row.getCell(TB_DETAIL_DATAELEMENT).getValue()).getInterSeq(), moneyMap);
        }
        String sKey = null;
        try {
            rs.beforeFirst();
            boolean first = true;
            while (rs.next()) {
                if (first) {
                    first = false;
                    checkageMap.put("id", currentId);
                    checkageMap.put("diffmode", this.comboDiffMode.getSelectedItem());
                }
                if (!recordMap.containsKey(sKey = rs.getString("fcompanyname") + rs.getString("ftargetcompanyname") + rs.getString("fitemnumber") + rs.getInt("fdataelement"))) continue;
                ((Map)recordMap.get(sKey)).put("companyid", rs.getString("fcompanyid") == null ? this.companyMap.get(rs.getString("fcompanyname")) : rs.getString("fcompanyid"));
                ((Map)recordMap.get(sKey)).put("targetcompanyid", rs.getString("ftargetcompanyid") == null ? this.companyMap.get(rs.getString("ftargetcompanyname")) : rs.getString("ftargetcompanyid"));
                ((Map)recordMap.get(sKey)).put("itemid", rs.getString("fitemid") == null ? this.companyMap.get(rs.getString("fitemname")) : rs.getString("fitemid"));
                ((Map)recordMap.get(sKey)).put("itemnumber", rs.getString("fitemnumber"));
                ((Map)recordMap.get(sKey)).put("dataelement", new Integer(rs.getInt("fdataelement")));
            }
            Set keys = recordMap.keySet();
            Iterator it = keys.iterator();
            HashSet detail = new HashSet();
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                detail.add(recordMap.get(obj));
            }
            checkageMap.put("entries", detail);
        }
        catch (SQLException e1) {
            this.handUIException(e1);
        }
        return checkageMap;
    }

    private BigDecimal setDefualtValue(BigDecimal debit) {
        return new BigDecimal(0.0);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.verifyInput();
        Map uiContext = this.getUIContext();
        List myID = (List)uiContext.get("myID");
        String selectId = this.getSelectedRowKeyValue(TB_ID);
        Map checkageMap = this.getCheckageMap(this.rs, selectId);
        Map param = (Map)this.getUIContext().get("param");
        ArrayList errorList = new ArrayList();
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(selectId);
        boolean ret = false;
        IInterCheck iInterCheck = InterCheckFactory.getRemoteInstance();
        if (!list.isEmpty()) {
            InterTradeClientUtils.checkedReceivedReport((Map<Object, Object>)param, list, this.getElimType(), CheckageConfirmEnum.Confirm);
            ret = iInterCheck.saveCheckageRecord(checkageMap, this.getElimType());
        }
        if (ret) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
            this.comboCheckedStatus.setSelectedItem((Object)CheckageConfirmEnum.Confirm);
            this.checkEnable(false);
        }
        this.doPrecision();
    }

    private void verifyInput() throws InterCheckException {
        BigDecimal validDebitAmt = null;
        BigDecimal validCreditAmt = null;
        boolean validDebitAmtGreaterZero = false;
        boolean validCreditAmtGreaterZero = false;
        IRow row = null;
        int n = this.kdtEntryDetails.getRowCount();
        for (int i = 0; i < n; ++i) {
            try {
                row = this.kdtEntryDetails.getRow(i);
                if (row.getCell("company").getValue().equals(this.minTotal)) continue;
                validDebitAmt = (BigDecimal)row.getCell(TB_DETAIL_VALID_DEBIT).getValue();
                validCreditAmt = (BigDecimal)row.getCell(TB_DETAIL_VALID_CREDIT).getValue();
            }
            catch (Exception e) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Control_Error"));
                return;
            }
            validDebitAmtGreaterZero = validDebitAmt != null && validDebitAmt.signum() != 0;
            boolean bl = validCreditAmtGreaterZero = validCreditAmt != null && validCreditAmt.signum() != 0;
            if (!validDebitAmtGreaterZero || !validCreditAmtGreaterZero || validDebitAmt.compareTo(validCreditAmt) != 0) continue;
            throw new InterCheckException(InterCheckException.VDEBIT_VCREDIT_GREATER_ZERO_C, new Object[]{String.valueOf(i + 1)});
        }
        if (this.txtValidDebitTotal.getBigDecimalValue() != null && this.txtValidCreditTotal.getBigDecimalValue() != null && this.txtValidDebitTotal.getBigDecimalValue().compareTo(this.txtValidCreditTotal.getBigDecimalValue()) != 0) {
            if (this.canCheckageNotBalance) {
                int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CHECK_DEBIT_EQUALS_CREDIT"));
                if (result != 0) {
                    SysUtil.abort();
                }
            } else {
                throw new InterCheckException(InterCheckException.CHECK_DEBIT_EQUALS_CREDIT);
            }
        }
    }

    private void checkHasAudited() {
        if (this.rs == null) {
            return;
        }
        int checkedStatus = 0;
        try {
            this.rs.beforeFirst();
            while (this.rs.next()) {
                if (this.rs.getInt("FCheckedStatus") <= 0) continue;
                checkedStatus = this.rs.getInt("FCheckedStatus");
                break;
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        boolean b = checkedStatus == 2;
        this.actionSubmit.setEnabled(!b);
        this.btnSubmit.setEnabled(!b);
        this.menuItemSubmit.setEnabled(!b);
        this.comboDiffMode.setEnabled(!b);
        DiffModeEnum diffMode = (DiffModeEnum)((Object)this.comboDiffMode.getSelectedItem());
        if (diffMode.getValue() == 10) {
            this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_DEBIT).getStyleAttributes().setLocked(b);
            this.kdtEntryDetails.getColumn(TB_DETAIL_VALID_CREDIT).getStyleAttributes().setLocked(b);
        }
        if (!b) {
            this.releaseObjectLock();
            this.requestObjectLock();
        }
    }

    private void releaseObjectLock() {
        if (this.oldId != null) {
            IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
            iMC.releaseObjIDForUpdate(this.oldId);
            logger.debug((Object)("release oldid :" + this.oldId));
        }
    }

    public boolean destroyWindow() {
        Object owner = this.getUIContext().get("Owner");
        if (owner instanceof CslBaseMainUI) {
            try {
                ((CslBaseMainUI)((Object)owner)).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        this.releaseObjectLock();
        return super.destroyWindow();
    }

    private void requestObjectLock() {
        this.newId = this.getSelectedRowKeyValue(TB_ID);
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        boolean bingo = iMC.requestObjIDForUpdate(this.newId, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        if (!bingo) {
            this.oldId = null;
            this.bNeedReleaseLock = false;
            logger.debug((Object)("request newid :" + this.newId + " FAIL!"));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Msg_CurrentRecordLocked"));
            this.actionSubmit.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.comboDiffMode.setEnabled(false);
        } else {
            this.oldId = this.newId;
            logger.debug((Object)("request newid :" + this.newId + " OK!"));
            this.bNeedReleaseLock = true;
            this.actionSubmit.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.menuItemSubmit.setEnabled(true);
            this.comboDiffMode.setEnabled(true);
        }
    }

    private void initSingleDC() throws Exception {
        if (this.getElimType() == ElimTypeEnum.exchange) {
            IExchCheckage checkageData = ExchCheckageFactory.getRemoteInstance();
            try {
                ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedRowKeyValue(TB_ID));
                ExchCheckageInfo info = checkageData.getExchCheckageInfo("select singleDC, isOldData where id ='" + pk.toString() + "'");
                if (info != null) {
                    this.singleDC = info.isSingleDC() ? 1 : 0;
                    this.isOldData = info.isIsOldData();
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            IInterDataCheckage interData = InterDataCheckageFactory.getRemoteInstance();
            try {
                ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedRowKeyValue(TB_ID));
                InterDataCheckageInfo info = interData.getInterDataCheckageInfo((IObjectPK)pk);
                if (info != null) {
                    this.singleDC = info.isSingleDC() ? 1 : 0;
                    this.isOldData = info.isIsOldData();
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private ElimTypeEnum getElimType() {
        ElimTypeEnum elimType = null;
        try {
            elimType = ElimTypeEnum.getEnum(Integer.parseInt(this.getSelectedRowKeyValue(TB_ELIMTYPE)));
        }
        catch (NumberFormatException e) {
            this.handUIException(e);
        }
        return elimType;
    }

    private void tableValueChanged(KDTEditEvent e) {
        BigDecimal validDebit_Total = new BigDecimal("0");
        BigDecimal validCredit_Total = new BigDecimal("0");
        if (this.comboDiffMode.getSelectedItem().equals((Object)DiffModeEnum.FetchHandCraft)) {
            boolean isValidCredit;
            boolean isValidDebit = e.getColIndex() == this.kdtEntryDetails.getColumnIndex(TB_DETAIL_VALID_DEBIT);
            boolean bl = isValidCredit = e.getColIndex() == this.kdtEntryDetails.getColumnIndex(TB_DETAIL_VALID_CREDIT);
            if (isValidDebit || isValidCredit) {
                BigDecimal[] totles = this.sumVaildTotle(isValidDebit);
                validDebit_Total = totles[0];
                validCredit_Total = totles[1];
            }
            this.txtValidDebitTotal.setValue((Object)validDebit_Total.setScale(this.iCurrencyPrecision, 4));
            this.txtValidCreditTotal.setValue((Object)validCredit_Total.setScale(this.iCurrencyPrecision, 4));
            this.txtConfirmDiffVal.setValue((Object)validDebit_Total.subtract(validCredit_Total).setScale(this.iCurrencyPrecision, 4));
            this.setTotle(false);
        }
        if (e.getColIndex() == this.kdtEntryDetails.getColumnIndex(TB_DETAIL_VALID_DEBIT) || e.getColIndex() == this.kdtEntryDetails.getColumnIndex(TB_DETAIL_VALID_CREDIT)) {
            if (this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue() == null) {
                this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal("0").setScale(this.iCurrencyPrecision, 4));
            } else {
                try {
                    this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal(this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue().toString()).setScale(this.iCurrencyPrecision, 4));
                }
                catch (Exception e1) {
                    this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal("0").setScale(this.iCurrencyPrecision, 4));
                }
            }
        }
    }

    private BigDecimal[] sumVaildTotle(boolean isValidDebit) {
        BigDecimal debit = null;
        BigDecimal credit = null;
        BigDecimal validDebit_Total = new BigDecimal("0");
        BigDecimal validCredit_Total = new BigDecimal("0");
        HashMap<String, BigDecimal[]> groupKey_values = new HashMap<String, BigDecimal[]>();
        int rowCount = this.kdtEntryDetails.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdtEntryDetails.getRow(i);
            if (this.addLitterTotleRow(groupKey_values, row, i == rowCount - 1, false) && i != rowCount - 1) {
                ++rowCount;
                ++i;
            }
            if (row.getCell("company").getValue().equals(this.minTotal)) continue;
            debit = row.getCell(TB_DETAIL_VALID_DEBIT).getValue() == null ? new BigDecimal("0") : new BigDecimal(row.getCell(TB_DETAIL_VALID_DEBIT).getValue().toString());
            BigDecimal bigDecimal = credit = row.getCell(TB_DETAIL_VALID_CREDIT).getValue() == null ? new BigDecimal("0") : new BigDecimal(row.getCell(TB_DETAIL_VALID_CREDIT).getValue().toString());
            if (debit.compareTo(BigDecimal.ZERO) != 0 && credit.compareTo(BigDecimal.ZERO) != 0) {
                debit = isValidDebit ? debit : BigDecimal.ZERO;
                credit = isValidDebit ? BigDecimal.ZERO : credit;
                row.getCell(isValidDebit ? TB_DETAIL_VALID_CREDIT : TB_DETAIL_VALID_DEBIT).setValue((Object)new BigDecimal("0").setScale(this.iCurrencyPrecision, 4));
            }
            validDebit_Total = validDebit_Total.add(debit);
            validCredit_Total = validCredit_Total.add(credit);
        }
        return new BigDecimal[]{validDebit_Total, validCredit_Total};
    }

    private void cellValueChanged(KDTActiveCellEvent e) {
        BigDecimal validDebit_Total = new BigDecimal("0");
        BigDecimal validCredit_Total = new BigDecimal("0");
        if (this.comboDiffMode.getSelectedItem().equals((Object)DiffModeEnum.FetchHandCraft)) {
            boolean isValidCredit;
            boolean isValidDebit = e.getColumnIndex() == this.kdtEntryDetails.getColumnIndex(TB_DETAIL_VALID_DEBIT);
            boolean bl = isValidCredit = e.getColumnIndex() == this.kdtEntryDetails.getColumnIndex(TB_DETAIL_VALID_CREDIT);
            if (isValidDebit || isValidCredit) {
                BigDecimal[] totle = this.sumVaildTotle(isValidDebit);
                validDebit_Total = totle[0];
                validCredit_Total = totle[1];
            }
            this.txtValidDebitTotal.setValue((Object)validDebit_Total.setScale(this.iCurrencyPrecision, 4));
            this.txtValidCreditTotal.setValue((Object)validCredit_Total.setScale(this.iCurrencyPrecision, 4));
            this.txtConfirmDiffVal.setValue((Object)validDebit_Total.subtract(validCredit_Total).setScale(this.iCurrencyPrecision, 4));
            this.setTotle(false);
        }
        if (e.getColumnIndex() == this.kdtEntryDetails.getColumnIndex(TB_DETAIL_VALID_DEBIT) || e.getColumnIndex() == this.kdtEntryDetails.getColumnIndex(TB_DETAIL_VALID_CREDIT)) {
            if (this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColumnIndex()).getValue() == null) {
                this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColumnIndex()).setValue((Object)new BigDecimal("0").setScale(this.iCurrencyPrecision, 4));
            } else {
                try {
                    this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColumnIndex()).setValue((Object)new BigDecimal(this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColumnIndex()).getValue().toString()).setScale(this.iCurrencyPrecision, 4));
                }
                catch (Exception e1) {
                    this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColumnIndex()).setValue((Object)new BigDecimal("0").setScale(this.iCurrencyPrecision, 4));
                }
            }
        }
    }

    private void checkEnable(boolean enable) {
        this.comboDiffMode.setEnabled(enable);
        this.btnSubmit.setEnabled(enable);
        this.menuItemSubmit.setEnabled(enable);
    }

    private boolean addLitterTotleRow(Map<String, BigDecimal[]> groupKey_values, IRow row, boolean isLastRow, boolean isSetNotValid) {
        BigDecimal[] values = null;
        boolean isAddRow = false;
        HashMap<String, Integer> keys = new HashMap<String, Integer>();
        if (isSetNotValid) {
            keys.put(TB_DETAIL_DEBIT, 0);
            keys.put(TB_DETAIL_CREDIT, 1);
        }
        keys.put(TB_DETAIL_VALID_DEBIT, 2);
        keys.put(TB_DETAIL_VALID_CREDIT, 3);
        if (row.getCell("company").getValue().equals(this.minTotal) && groupKey_values.size() == 1) {
            values = groupKey_values.values().iterator().next();
            for (String curKey : keys.keySet()) {
                row.getCell(curKey).setValue((Object)values[(Integer)keys.get(curKey)]);
            }
            groupKey_values.clear();
            return isAddRow;
        }
        String key = row.getCell("company").getValue().toString() + row.getCell("targetCompany").getValue().toString();
        values = groupKey_values.get(key);
        BigDecimal tmpValue = null;
        Object cellValue = null;
        if (values == null || isLastRow) {
            if (groupKey_values.size() == 1) {
                IRow nextRow = this.kdtEntryDetails.getRow(isLastRow ? row.getRowIndex() + 1 : row.getRowIndex() - 1);
                if (nextRow == null || !nextRow.getCell("company").getValue().equals(this.minTotal)) {
                    isAddRow = true;
                    nextRow = this.kdtEntryDetails.addRow(isLastRow ? row.getRowIndex() + 1 : row.getRowIndex());
                    nextRow.getStyleAttributes().setBackground(Color.decode("#FFFF9C"));
                    nextRow.getCell("company").setValue((Object)this.minTotal);
                    nextRow.getCell(TB_DETAIL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    nextRow.getCell(TB_DETAIL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    nextRow.getCell(TB_DETAIL_VALID_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    nextRow.getCell(TB_DETAIL_VALID_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    nextRow.getCell(TB_DETAIL_DEBIT).getStyleAttributes().setLocked(true);
                    nextRow.getCell(TB_DETAIL_CREDIT).getStyleAttributes().setLocked(true);
                    nextRow.getCell(TB_DETAIL_VALID_DEBIT).getStyleAttributes().setLocked(true);
                    nextRow.getCell(TB_DETAIL_VALID_CREDIT).getStyleAttributes().setLocked(true);
                }
                values = groupKey_values.values().iterator().next();
                for (String curKey : keys.keySet()) {
                    if (isLastRow) {
                        cellValue = row.getCell(curKey).getValue();
                        tmpValue = cellValue == null ? BigDecimal.ZERO : new BigDecimal(cellValue.toString());
                        values[((Integer)keys.get((Object)curKey)).intValue()] = values[(Integer)keys.get(curKey)].add(tmpValue);
                    }
                    nextRow.getCell(curKey).setValue((Object)values[(Integer)keys.get(curKey)]);
                }
            }
            groupKey_values.clear();
            values = new BigDecimal[4];
            groupKey_values.put(key, values);
            for (String curKey : keys.keySet()) {
                cellValue = row.getCell(curKey).getValue();
                values[((Integer)keys.get((Object)curKey)).intValue()] = tmpValue = cellValue == null ? BigDecimal.ZERO : new BigDecimal(cellValue.toString());
            }
        } else {
            for (String curKey : keys.keySet()) {
                cellValue = row.getCell(curKey).getValue();
                tmpValue = cellValue == null ? BigDecimal.ZERO : new BigDecimal(cellValue.toString());
                values[((Integer)keys.get((Object)curKey)).intValue()] = values[(Integer)keys.get(curKey)].add(tmpValue);
            }
        }
        keys.clear();
        return isAddRow;
    }

    private boolean checkValMoneyFormat(String formulaString) {
        String pattern = "^[+-]?\\d+(\\.\\d+)?$";
        Pattern patt = Pattern.compile(pattern);
        Matcher matcher = patt.matcher(formulaString);
        return matcher.find();
    }

    private class ValueChangeListener
    implements KDTPropertyChangeListener {
        private KDComboBox comboDiffMode = null;
        private KDTable kdtEntryDetails = null;
        private KDFormattedTextField txtValidDebitTotal = null;
        private KDFormattedTextField txtValidCreditTotal = null;
        private boolean isTragChange = true;

        public ValueChangeListener(KDComboBox mode, KDTable table, KDFormattedTextField debit, KDFormattedTextField credit) {
            this.comboDiffMode = mode;
            this.kdtEntryDetails = table;
            this.txtValidDebitTotal = debit;
            this.txtValidCreditTotal = credit;
        }

        public void propertyChange(KDTPropertyChangeEvent evt) {
            ICell cell;
            if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue") && this.isTragChange) {
                try {
                    this.isTragChange = false;
                    ICell cell2 = this.kdtEntryDetails.getCell(evt.getRowIndex(), evt.getColIndex());
                    if (cell2 != null && (evt.getOldValue() != null && evt.getOldValue().equals(cell2.getValue()) || evt.getOldValue() == null && cell2.getValue() == null)) {
                        cell2.setValue(evt.getNewValue());
                    }
                    this.tableValueChanged(evt);
                }
                finally {
                    this.isTragChange = true;
                }
            }
            int creditColIndex = this.kdtEntryDetails.getColumn(InterAndExchDiffHandleUI.TB_DETAIL_VALID_CREDIT).getColumnIndex();
            int debitColIndex = this.kdtEntryDetails.getColumn(InterAndExchDiffHandleUI.TB_DETAIL_VALID_DEBIT).getColumnIndex();
            if ((creditColIndex == evt.getColIndex() || debitColIndex == evt.getColIndex()) && (cell = this.kdtEntryDetails.getCell(evt.getRowIndex(), evt.getColIndex())) != null) {
                Object oldValueObj = cell.getValue();
                InterAndExchDiffHandleUI.this.oldValue = oldValueObj == null ? BigDecimal.ZERO : new BigDecimal(oldValueObj.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tableValueChanged(KDTPropertyChangeEvent e) {
            boolean tmpTragChange = this.isTragChange;
            try {
                this.isTragChange = false;
                BigDecimal validDebit_Total = new BigDecimal("0");
                BigDecimal validCredit_Total = new BigDecimal("0");
                if (InterAndExchDiffHandleUI.this.isInit) {
                    return;
                }
                int selectRow = e.getRowIndex();
                IRow sRow = this.kdtEntryDetails.getRow(selectRow);
                if (e.getColIndex() == this.kdtEntryDetails.getColumnIndex(InterAndExchDiffHandleUI.TB_DETAIL_VALID_DEBIT) || e.getColIndex() == this.kdtEntryDetails.getColumnIndex(InterAndExchDiffHandleUI.TB_DETAIL_VALID_CREDIT)) {
                    Object debitValue = sRow.getCell(InterAndExchDiffHandleUI.TB_DETAIL_VALID_DEBIT).getValue();
                    Object creditValue = sRow.getCell(InterAndExchDiffHandleUI.TB_DETAIL_VALID_CREDIT).getValue();
                    if (debitValue != null && debitValue.toString().length() != 0 && !InterAndExchDiffHandleUI.this.checkValMoneyFormat(debitValue.toString())) {
                        sRow.getCell(InterAndExchDiffHandleUI.TB_DETAIL_VALID_DEBIT).setValue(null);
                    }
                    if (creditValue != null && creditValue.toString().length() != 0 && !InterAndExchDiffHandleUI.this.checkValMoneyFormat(creditValue.toString())) {
                        sRow.getCell(InterAndExchDiffHandleUI.TB_DETAIL_VALID_CREDIT).setValue(null);
                    }
                }
                if (this.comboDiffMode.getSelectedItem().equals((Object)DiffModeEnum.FetchHandCraft) || InterAndExchDiffHandleUI.this.singleDC == 1) {
                    boolean isValidCredit;
                    boolean isValidDebit = e.getColIndex() == this.kdtEntryDetails.getColumnIndex(InterAndExchDiffHandleUI.TB_DETAIL_VALID_DEBIT);
                    boolean bl = isValidCredit = e.getColIndex() == this.kdtEntryDetails.getColumnIndex(InterAndExchDiffHandleUI.TB_DETAIL_VALID_CREDIT);
                    if (isValidDebit || isValidCredit) {
                        BigDecimal[] totle = InterAndExchDiffHandleUI.this.sumVaildTotle(isValidDebit);
                        validDebit_Total = totle[0];
                        validCredit_Total = totle[1];
                    }
                    this.txtValidDebitTotal.setValue((Object)validDebit_Total.setScale(InterAndExchDiffHandleUI.this.iCurrencyPrecision, 4));
                    this.txtValidCreditTotal.setValue((Object)validCredit_Total.setScale(InterAndExchDiffHandleUI.this.iCurrencyPrecision, 4));
                    InterAndExchDiffHandleUI.this.setTotle(false);
                }
                if (e.getColIndex() == this.kdtEntryDetails.getColumnIndex(InterAndExchDiffHandleUI.TB_DETAIL_VALID_DEBIT) || e.getColIndex() == this.kdtEntryDetails.getColumnIndex(InterAndExchDiffHandleUI.TB_DETAIL_VALID_CREDIT)) {
                    if (this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue() == null) {
                        this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal("0").setScale(InterAndExchDiffHandleUI.this.iCurrencyPrecision, 4));
                    } else {
                        try {
                            this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal(this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue().toString()).setScale(InterAndExchDiffHandleUI.this.iCurrencyPrecision, 4));
                        }
                        catch (Exception e1) {
                            this.kdtEntryDetails.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)new BigDecimal("0").setScale(InterAndExchDiffHandleUI.this.iCurrencyPrecision, 4));
                        }
                    }
                }
            }
            finally {
                this.isTragChange = tmpTragChange;
            }
        }
    }
}

