/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.CheckageConfirmEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimTemplet;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInterCheckageConditionUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class InterCheckageConditionUI
extends AbstractInterCheckageConditionUI {
    private static final Logger logger = Logger.getLogger(InterCheckageConditionUI.class);
    private boolean hasLoadInitData;
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private IElimTemplet iElimTemplet = null;
    private static final String BLANK = "";
    private static final String EQUAL = "=";
    private static final String LESS_THAN = "<";
    private static final String MORE_THAN = ">";
    private static final String NOT_EQUAL = "<>";

    public InterCheckageConditionUI() throws Exception {
        this.initComponent();
    }

    public void initComponent() throws Exception {
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.comboCurrency.addItem((Object)this.selectAll);
        if (this.iCurrency == null) {
            this.iCurrency = CurrencyFactory.getRemoteInstance();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        CurrencyCollection currencyCollection = null;
        try {
            currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            this.comboCurrency.addItems(currencyCollection.toArray());
        }
        this.comboElimTemplet.addItem((Object)this.selectAll);
        this.comboElimTemplet.addItems(this.getDisedElimTemplateRecords().toArray());
        this.cbxConfirmStatus.addItem((Object)this.selectAll);
        this.cbxConfirmStatus.addItem((Object)CheckageConfirmEnum.Audit);
        this.cbxConfirmStatus.addItem((Object)CheckageConfirmEnum.Confirm);
        this.cbxConfirmStatus.addItem((Object)CheckageConfirmEnum.UnConfirm);
        this.cbxConfirmStatus.setRequired(true);
        this.bizPrmtCompany.setRequired(false);
        Object[] compareArr = new String[]{BLANK, EQUAL, LESS_THAN, MORE_THAN, NOT_EQUAL};
        this.cbCompare.addItems(compareArr);
        this.cbCompare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InterCheckageConditionUI.BLANK.equals(InterCheckageConditionUI.this.cbCompare.getSelectedItem().toString())) {
                    InterCheckageConditionUI.this.txtValue.setValue(null);
                    InterCheckageConditionUI.this.txtValue.setEnabled(false);
                } else {
                    InterCheckageConditionUI.this.txtValue.setEnabled(true);
                }
            }
        });
        this.cbCompare.setSelectedItem((Object)BLANK);
        this.chkShowNotZero.setVisible(false);
    }

    private ElimTempletCollection getDisedElimTemplateRecords() throws BOSException, Exception {
        ElimTempletCollection elimTempletCollection;
        if (this.iElimTemplet == null) {
            this.iElimTemplet = ElimTempletFactory.getRemoteInstance();
        }
        if ((elimTempletCollection = this.iElimTemplet.getElimTemplateByTreeAndCompany(this.ctx.getCurOrgGroup().getId().toString(), this.ctx.getCurOrgBound().getId().toString(), 2, 2, 1)) == null) {
            elimTempletCollection = new ElimTempletCollection();
        }
        return elimTempletCollection;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptProperties();
            this.pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
            this.pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
            this.pp.setInt("year", this.ctx.getCurRptYear());
            this.pp.setInt("period", this.ctx.getCurRptPeriod());
            this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
            if (!StringUtils.isEmpty((String)this.cbCompare.getSelectedItem().toString())) {
                this.pp.setString("compare", this.cbCompare.getSelectedItem().toString());
                this.pp.setString("value", this.txtValue.getNumberValue().toString());
            }
            if (this.pp.containsKey("compare")) {
                String compare = this.pp.getString("compare");
                for (int k = 1; k < this.cbCompare.getItemCount(); ++k) {
                    String item = (String)this.cbCompare.getItemAt(k);
                    if (!compare.equals(item)) continue;
                    this.cbCompare.setSelectedIndex(k);
                    break;
                }
            }
            if (this.pp.containsKey("value")) {
                BigDecimal newValue = new BigDecimal(this.pp.getString("value"));
                this.txtValue.setNumberValue((Number)newValue);
            }
        }
    }

    private void fillDataToUI() {
        String fromCurrencyId;
        this.clearUI();
        if (this.pp.containsKey("fromCurrency") && (fromCurrencyId = this.pp.getString("fromCurrency")) != null) {
            for (int j = 1; j < this.comboCurrency.getItemCount(); ++j) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(fromCurrencyId)) continue;
                this.comboCurrency.setSelectedIndex(j);
                break;
            }
        }
        if (this.pp.containsKey("templet")) {
            String templetId = this.pp.getString("templet");
            for (int k = 1; k < this.comboElimTemplet.getItemCount(); ++k) {
                ElimTempletInfo templetInfo = (ElimTempletInfo)this.comboElimTemplet.getItemAt(k);
                if (!templetInfo.getId().toString().equals(templetId)) continue;
                this.comboElimTemplet.setSelectedIndex(k);
                break;
            }
        }
        try {
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
            f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
            f7.setCtrlUnitPK(this.ctx.getCurOrgBound().getCU());
            f7.setMultiSelect(false);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            this.bizPrmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
            this.bizPrmtCompany.setFilterInfoProducer(f7.getOrgUnitFilterInfoProducer());
            this.bizPrmtCompany.setSelector((KDPromptSelector)f7);
            this.bizPrmtCompany.setEditable(true);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        if (this.pp.containsKey("company") && this.pp.getObject("company") != null) {
            String companyId = (String)this.pp.getObject("company");
            try {
                FullOrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.bizPrmtCompany.setData((Object)companyInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.pp.containsKey("confirmStatus")) {
            int status = this.pp.getInt("confirmStatus");
            if (status == 2) {
                this.cbxConfirmStatus.setSelectedIndex(2);
            } else if (status == 1) {
                this.cbxConfirmStatus.setSelectedIndex(3);
            } else if (status == 0) {
                this.cbxConfirmStatus.setSelectedIndex(1);
            }
        }
        if (this.pp.containsKey("isShowNotZero")) {
            this.chkShowNotZero.setSelected(this.pp.getBoolean("isShowNotZero"));
        }
        if (this.pp.containsKey("compare")) {
            String compare = this.pp.getString("compare");
            for (int k = 1; k < this.cbCompare.getItemCount(); ++k) {
                String item = (String)this.cbCompare.getItemAt(k);
                if (!compare.equals(item)) continue;
                this.cbCompare.setSelectedIndex(k);
                break;
            }
        }
        if (this.pp.containsKey("value")) {
            BigDecimal newValue = new BigDecimal(this.pp.getString("value"));
            this.txtValue.setNumberValue((Number)newValue);
        }
    }

    @Override
    public RptProperties getCustomCondition() {
        try {
            this.pp.setString("treeId", this.ctx.getCurOrgBound().getId().toString());
            this.pp.setString("orgUnitId", this.ctx.getCurOrgGroup().getId().toString());
            this.pp.setInt("year", this.ctx.getCurRptYear());
            this.pp.setInt("period", this.ctx.getCurRptPeriod());
            this.pp.setInt("periodType", this.ctx.getCurRptPeriodType().getValue());
        }
        catch (BOSException e) {
            logger.error((Object)"getCustomCondition_BOSException", (Throwable)e);
        }
        this.pp.setString("company", this.bizPrmtCompany.getValue() == null ? null : ((OrgUnitInfo)this.bizPrmtCompany.getValue()).getId().toString());
        this.pp.setString("fromCurrency", this.comboCurrency.getSelectedIndex() == 0 ? null : ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        this.pp.setString("templet", this.comboElimTemplet.getSelectedIndex() == 0 ? null : ((ElimTempletInfo)this.comboElimTemplet.getSelectedItem()).getId().toString());
        this.pp.setBoolean("isShowNotZero", (Boolean)this.chkShowNotZero.isSelected());
        if (this.cbxConfirmStatus.getSelectedIndex() > 0) {
            this.pp.setInt("confirmStatus", ((CheckageConfirmEnum)((Object)this.cbxConfirmStatus.getSelectedItem())).getValue());
        } else {
            this.pp.remove("confirmStatus");
        }
        if (!StringUtils.isEmpty((String)this.cbCompare.getSelectedItem().toString())) {
            this.pp.setString("compare", this.cbCompare.getSelectedItem().toString());
            this.pp.setString("value", this.txtValue.getNumberValue().toString());
        } else {
            this.pp.remove("compare");
            this.pp.remove("value");
        }
        return this.pp;
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        this.fillDataToUI();
    }

    @Override
    public Object getParam() {
        return this.getCustomCondition();
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    @Override
    public CustomerParams getCustomerParams() {
        this.getCustomCondition();
        CustomerParams cp = new CustomerParams();
        if (this.pp.getString("company") != null && this.pp.getString("company") != null) {
            cp.addCustomerParam("company", this.pp.getString("company").toString());
        }
        if (this.pp.getString("fromCurrency") != null && this.pp.getString("fromCurrency") != null) {
            cp.addCustomerParam("fromCurrency", this.pp.getString("fromCurrency").toString());
        }
        if (this.pp.getString("templet") != null && this.pp.getString("templet") != null) {
            cp.addCustomerParam("templet", this.pp.getString("templet").toString());
        }
        if (this.pp.getBoolean("isShowNotZero") || !this.pp.getBoolean("isShowNotZero")) {
            cp.addCustomerParam("isShowNotZero", String.valueOf(this.pp.getBoolean("isShowNotZero")));
        }
        if (this.pp.getString("treeId") != null && this.pp.getString("treeId") != null) {
            cp.addCustomerParam("treeId", this.pp.getString("treeId").toString());
        }
        if (this.pp.getString("orgUnitId") != null && this.pp.getString("orgUnitId") != null) {
            cp.addCustomerParam("orgUnitId", this.pp.getString("orgUnitId").toString());
        }
        if (this.pp.containsKey("confirmStatus")) {
            cp.addCustomerParam("confirmStatus", String.valueOf(this.pp.getInt("confirmStatus")));
        }
        cp.addCustomerParam("year", String.valueOf(this.pp.getInt("year")));
        cp.addCustomerParam("period", String.valueOf(this.pp.getInt("period")));
        cp.addCustomerParam("periodType", String.valueOf(this.pp.getInt("periodType")));
        if (this.pp.containsKey("compare")) {
            cp.addCustomerParam("compare", this.pp.getString("compare"));
            cp.addCustomerParam("value", this.pp.getString("value"));
        }
        return cp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        RptProperties condition = new RptProperties();
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("company") != null) {
            condition.setString("company", cp.getCustomerParam("company"));
        }
        if (cp.getCustomerParam("fromCurrency") != null) {
            condition.setString("fromCurrency", cp.getCustomerParam("fromCurrency"));
        }
        if (cp.getCustomerParam("templet") != null) {
            condition.setString("templet", cp.getCustomerParam("templet"));
        }
        if (cp.getCustomerParam("isShowNotZero") != null) {
            if (cp.getCustomerParam("isShowNotZero").equalsIgnoreCase("true")) {
                condition.setBoolean("isShowNotZero", new Boolean(true));
            } else {
                condition.setBoolean("isShowNotZero", new Boolean(false));
            }
        }
        if (cp.getCustomerParam("treeId") != null) {
            condition.setString("treeId", cp.getCustomerParam("treeId"));
        }
        if (cp.getCustomerParam("orgUnitId") != null) {
            condition.setString("orgUnitId", cp.getCustomerParam("orgUnitId"));
        }
        if (cp.getCustomerParam("year") != null && !cp.getCustomerParam("year").equals(BLANK)) {
            condition.setInt("year", new Integer(cp.getCustomerParam("year")));
        }
        if (cp.getCustomerParam("year") != null && !cp.getCustomerParam("year").equals(BLANK)) {
            condition.setInt("period", new Integer(cp.getCustomerParam("period")));
        }
        if (cp.getCustomerParam("year") != null && !cp.getCustomerParam("year").equals(BLANK)) {
            condition.setInt("periodType", new Integer(cp.getCustomerParam("periodType")));
        }
        if (cp.getInt("confirmStatus") > 0) {
            condition.setInt("confirmStatus", cp.getInt("confirmStatus"));
        }
        if (cp.getCustomerParam("compare") != null) {
            condition.setString("compare", cp.getCustomerParam("compare"));
            condition.setString("value", cp.getCustomerParam("value"));
        }
        this.setCustomCondition(condition);
    }

    private void clearUI() {
        this.bizPrmtCompany.setValue(null);
        this.comboCurrency.setSelectedItem((Object)this.selectAll);
        this.comboElimTemplet.setSelectedItem((Object)this.selectAll);
        this.cbxConfirmStatus.setSelectedIndex(0);
        if (this.cbCompare.getSelectedIndex() != -1) {
            this.txtValue.setNumberValue(null);
            this.cbCompare.setSelectedIndex(0);
        }
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public boolean verify() {
        if (!StringUtils.isEmpty((String)this.cbCompare.getSelectedItem().toString()) && this.txtValue.getNumberValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource.893_InterCheckageConditionUI"));
            return false;
        }
        return true;
    }

    public Dimension getSize() {
        return new Dimension(320, 286);
    }
}

