/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckFactory;
import com.kingdee.eas.fi.gr.cslrpt.LimitTokenEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInterExchLimitAmountSettingUI;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.LimitAmountInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InterExchLimitAmountSettingUI
extends AbstractInterExchLimitAmountSettingUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(InterExchLimitAmountSettingUI.class);
    private BigDecimal oldLimitAmount;
    boolean isSave = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSelfListener();
        this.loadData();
    }

    private void loadData() throws EASBizException, BOSException {
        LimitAmountInfo limitAmountInfo;
        this.cmbToken.removeAllItems();
        this.cmbToken.addItems(LimitTokenEnum.getEnumList().toArray());
        this.txtLimitNumber.setValue((Object)CslConstant.BGZERO);
        this.txtLimitNumber.setHorizontalAlignment(4);
        this.txtLimitNumber.setPrecision(2);
        Map limit = InterCheckFactory.getRemoteInstance().getLimitAmount(this.getParams(false));
        if (limit != null && (limitAmountInfo = (LimitAmountInfo)limit.get(this.getUIContext().get("OrgUnitID"))) != null) {
            this.txtLimitNumber.setValue((Object)limitAmountInfo.getLimitAmount());
            this.cmbToken.setSelectedItem((Object)LimitTokenEnum.getEnum(limitAmountInfo.getToken()));
        }
        this.oldLimitAmount = this.txtLimitNumber.getBigDecimalValue();
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 130);
    }

    private void initSelfListener() {
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InterCheckFactory.getRemoteInstance().saveLimitAmount(InterExchLimitAmountSettingUI.this.getParams(true));
                    InterExchLimitAmountSettingUI.this.isSave = true;
                    InterExchLimitAmountSettingUI.this.destroyWindow();
                }
                catch (Exception e1) {
                    InterExchLimitAmountSettingUI.this.handUIExceptionAndAbort(e1);
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterExchLimitAmountSettingUI.this.isSave = false;
                InterExchLimitAmountSettingUI.this.destroyWindow();
            }
        });
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.isModify() && !this.isSave) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                try {
                    InterCheckFactory.getRemoteInstance().saveLimitAmount(this.getParams(true));
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
            } else if (result == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean isModify() {
        return this.txtLimitNumber.getBigDecimalValue() != null && this.oldLimitAmount != null && this.oldLimitAmount.compareTo(this.txtLimitNumber.getBigDecimalValue()) != 0;
    }

    private Map<String, Object> getParams(boolean isSave) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("OrgTreeID", this.getUIContext().get("OrgTreeID"));
        params.put("OrgUnitID", this.getUIContext().get("OrgUnitID"));
        params.put("Year", this.getUIContext().get("Year"));
        params.put("Period", this.getUIContext().get("Period"));
        params.put("PeriodType", this.getUIContext().get("PeriodType"));
        params.put("elimType", this.getUIContext().get("elimType"));
        if (isSave) {
            params.put("token", ((LimitTokenEnum)((Object)this.cmbToken.getSelectedItem())).getValue());
            BigDecimal bigDecimalValue = this.txtLimitNumber.getBigDecimalValue();
            if (bigDecimalValue.precision() - bigDecimalValue.scale() > 15) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"734_CslRptUtil"));
                SysUtil.abort();
            }
            params.put("Value", bigDecimalValue);
        }
        return params;
    }
}

