/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalYearPeriodDateTmp;
import com.kingdee.eas.fi.gr.cslrpt.InterDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInterItemDataFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class InterItemDataFilterUI
extends AbstractInterItemDataFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InterItemDataFilterUI.class);
    private boolean hasLoadInitData;
    CurrencyCollection currencyCollection = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
    private ICurrency iCurrency1 = null;
    CurrencyInfo baseCurrency = null;
    private int bsCurrency2;
    private FiscalYearPeriodDateTmp fiscalRefCtrl;
    private Map itemDataFilterUIInfo = null;
    List orgList = new ArrayList();
    private OrgViewType orgViewType = OrgViewType.COMPANY;

    public InterItemDataFilterUI() throws Exception {
    }

    public InterItemDataFilterUI(OrgViewType orgType) throws Exception {
        this();
        this.orgViewType = orgType;
    }

    public void onLoad() throws Exception {
        this.myInit();
        super.onLoad();
    }

    private void myInit() {
        Date date = new Date(System.currentTimeMillis());
        Date preDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
        this.kdpDate.setValue((Object)preDate);
        int[] defaultYearOrMonth = this.getCurrYearOrPeriod();
        this.kspYear.setValue((Object)new Integer(defaultYearOrMonth[0]));
        this.kspPeriod.setValue((Object)new Integer(defaultYearOrMonth[1]));
        this.kspYear.setEnabled(false);
        this.kspPeriod.setEnabled(false);
        this.kspYear.setEditable(true);
        this.kspPeriod.setEditable(true);
        this.cmbSourceType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY, false);
        this.initCmbOrgTree(true, null);
        if (this.currencyCollection == null) {
            this.currencyCollection = (CurrencyCollection)this.getItemDataFilterUIInfo(null, false).get("currencyCollection");
        }
        this.cmbCurrency.addItem((Object)this.selectAll);
        if (this.currencyCollection != null && this.currencyCollection.size() > 0) {
            this.cmbCurrency.addItems(this.currencyCollection.toArray());
        }
        CompanyOrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        CurrencyInfo bsCurrency = orgUnitInfo.getBaseCurrency();
        for (int j = 0; j < this.cmbCurrency.getItemCount(); ++j) {
            CurrencyInfo info;
            if (!(this.cmbCurrency.getItemAt(j) instanceof CurrencyInfo) || !(info = (CurrencyInfo)this.cmbCurrency.getItemAt(j)).getId().toString().equals(bsCurrency.getId().toString())) continue;
            this.baseCurrency = new CurrencyInfo();
            this.baseCurrency.setId(info.getId());
            this.baseCurrency.setNumber(info.getNumber());
            this.baseCurrency.setName(info.getName());
            this.bsCurrency2 = j;
            this.cmbCurrency.setSelectedIndex(j);
            break;
        }
        this.cmbSourceType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterItemDataFilterUI.this.refreshTimeInfo(InterItemDataFilterUI.this.kdpDate.getSqlDate());
                InterItemDataFilterUI.this.refresh13Period();
            }
        });
        this.kdpDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e != null && e.getNewValue() instanceof Date) {
                    InterItemDataFilterUI.this.refreshTimeInfo((Date)e.getNewValue());
                    InterItemDataFilterUI.this.refreshOrgTree(false);
                    InterItemDataFilterUI.this.refresh13Period();
                }
            }
        });
        this.cmbOrgTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterItemDataFilterUI.this.refreshCompany();
            }
        });
        try {
            this.initTimeCtrlValAndStatusByBaseOrgBound(true, (OrgTreeInfo)this.cmbOrgTree.getSelectedItem());
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.handUIException(e1);
        }
        this.bizCompany.setRequired(false);
    }

    private Map getItemDataFilterUIInfo(Date rptDate, boolean reQuery) {
        String key;
        if (this.itemDataFilterUIInfo == null) {
            this.itemDataFilterUIInfo = new HashMap();
        }
        if (rptDate == null) {
            Date date = new Date(System.currentTimeMillis());
            rptDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
        }
        if (!this.itemDataFilterUIInfo.containsKey(key = RPTDateUtil.getSimpleDateFormat(rptDate))) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("rptDate", rptDate);
            paramMap.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            paramMap.put("orgViewType", this.orgViewType);
            try {
                Map returnMap = InterDataProviderFactory.getRemoteInstance().getItemDataFilterInfo(paramMap);
                this.itemDataFilterUIInfo.put(key, returnMap);
                this.currencyCollection = (CurrencyCollection)returnMap.get("currencyCollection");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return (Map)this.itemDataFilterUIInfo.get(key);
    }

    private void initTimeCtrlValAndStatusByBaseOrgBound(boolean isAddListener, OrgTreeInfo choosedOrgTreeInfo) throws BOSException, EASBizException {
        RptPeriodTypeEnum periodType;
        if (choosedOrgTreeInfo == null) {
            return;
        }
        int[] currYearOrPeriod = new int[]{this.pp.getInt("year"), this.pp.getInt("period")};
        if (this.fiscalRefCtrl == null) {
            this.fiscalRefCtrl = new FiscalYearPeriodDateTmp(choosedOrgTreeInfo, this.cmbSourceType, this.kdpDate, this.kspYear, this.kspPeriod);
            this.fiscalRefCtrl.setComboOrgBound(this.cmbOrgTree, true, null);
        }
        if ((periodType = (RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem()) == null) {
            periodType = RptPeriodTypeEnum.MONTHLY;
            this.cmbSourceType.setSelectedItem((Object)periodType);
        }
        this.fiscalRefCtrl.initTimeCtrlValAndStatus(periodType, choosedOrgTreeInfo, currYearOrPeriod[0], currYearOrPeriod[1], (CoreUIObject)this, isAddListener, null);
    }

    private int[] getCurrYearOrPeriod() {
        Object o = this.kdpDate.getValue();
        Calendar ca = Calendar.getInstance();
        if (o != null && o instanceof Date) {
            ca.setTime((Date)o);
        }
        return new int[]{ca.get(1), ca.get(2) + 1};
    }

    private void refreshOrgTree(boolean isSelectBaseOrgTree) {
        int index = this.initCmbOrgTree(isSelectBaseOrgTree, null);
        this.refreshCompany();
        if (this.cmbOrgTree.getSelectedItem() != null) {
            this.cmbOrgTree.setSelectedIndex(index);
        }
    }

    private int initCmbOrgTree(boolean isSelectBaseOrgTree, Date rptDate) {
        OrgTreeCollection collection = new OrgTreeCollection();
        int index = 0;
        try {
            OrgTreeInfo prevSelectOrgTree = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            if (rptDate == null) {
                rptDate = (Date)this.kdpDate.getValue();
            }
            if ((collection = (OrgTreeCollection)this.getItemDataFilterUIInfo(rptDate, true).get("orgTreeCollection")) == null) {
                return 0;
            }
            DefaultComboBoxModel<OrgTreeInfo> model = new DefaultComboBoxModel<OrgTreeInfo>();
            this.orgList.clear();
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                String seq = String.valueOf(i);
                OrgTreeInfo orgTreeInfo = collection.get(i);
                this.orgList.add(orgTreeInfo.getId().toString());
                this.orgList.add(seq);
                if (!isSelectBaseOrgTree && prevSelectOrgTree != null && orgTreeInfo.getNumber() != null && orgTreeInfo.getNumber().equals(prevSelectOrgTree.getNumber())) {
                    index = i;
                } else if (isSelectBaseOrgTree && orgTreeInfo.isBasic()) {
                    index = i;
                }
                model.addElement(orgTreeInfo);
            }
            this.cmbOrgTree.setModel(model);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return index;
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem();
        if (p == null || newDate == null) {
            return;
        }
        if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod()) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.kspYear.setValue((Object)new Integer(times.get(0).toString()));
        this.kspPeriod.setValue((Object)new Integer(times.get(1).toString()));
        this.kdpDate.setValue(times.get(2), false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillPeriodType();
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptProperties();
            OrgTreeInfo treeInfo = null;
            treeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
            String companyId = orgUnitInfo.getId().toString();
            if (null != treeInfo && treeInfo.getId() != null) {
                this.pp.setString("treeId", treeInfo.getId().toString());
            }
            this.pp.setString("orgUnitId", companyId);
            String requestId = null;
            if (this.bizCompany.getData() != null) {
                requestId = ((CompanyOrgUnitInfo)this.bizCompany.getData()).getId().toString();
            }
            Date date = new Date(System.currentTimeMillis());
            Date preDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
            this.kdpDate.setValue((Object)preDate);
            Calendar ca = Calendar.getInstance();
            int year = ca.get(1);
            int month = ca.get(2) + 1 - 1;
            if (month == 0) {
                month = 12;
                --year;
                if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isSupport13Period()) {
                    month = 13;
                }
            }
            this.pp.setInt("year", year);
            this.pp.setInt("period", month);
            this.pp.setInt("periodType", 3);
        }
    }

    private void fillDataToUI() {
        boolean isMergeFiscalPeriod;
        this.clearUI();
        this.pp.setObject("allCurrency", this.currencyCollection);
        if (this.pp.getString("toCurrency") != null) {
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                String id;
                if (!(this.cmbCurrency.getItemAt(i) instanceof CurrencyInfo) || !(id = ((CurrencyInfo)this.cmbCurrency.getItemAt(i)).getId().toString()).equals(this.pp.getString("toCurrency"))) continue;
                this.cmbCurrency.setSelectedIndex(i);
                break;
            }
        }
        this.initCmbOrgTree(false, CslRptUIUtil.getRptDateFromProp(this.pp));
        if (this.pp.containsKey("treeId") && this.pp.getObject("treeId") != null) {
            String treeId = (String)this.pp.getObject("treeId");
            if (this.orgList != null && this.orgList.size() > 0) {
                for (int i = 0; i < this.orgList.size(); ++i) {
                    if (i % 2 != 0 || !this.orgList.get(i).toString().equals(treeId)) continue;
                    this.cmbOrgTree.setSelectedIndex(Integer.valueOf(this.orgList.get(i + 1).toString()).intValue());
                }
            }
        }
        try {
            this.initTimeCtrlValAndStatusByBaseOrgBound(false, (OrgTreeInfo)this.cmbOrgTree.getSelectedItem());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        boolean bl = isMergeFiscalPeriod = this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod();
        if (isMergeFiscalPeriod && this.pp.containsKey("year") && this.pp.containsKey("period")) {
            this.kspYear.setValue((Object)new Integer(this.pp.getInt("year")));
            this.kspPeriod.setValue((Object)new Integer(this.pp.getInt("period")));
        } else if (!isMergeFiscalPeriod) {
            this.kdpDate.setValue((Object)CslRptUIUtil.getRptDateFromProp(this.pp));
            if (this.pp != null && this.pp.containsKey("period") && this.pp.getInt("period") == 13 && this.fiscalRefCtrl != null && this.fiscalRefCtrl.isSupport13Period() && this.pp.getInt("periodType") == 3) {
                this.kspPeriod.setValue((Object)new Integer(this.pp.getInt("period")));
            }
            if (this.pp.containsKey("treeId") && this.pp.getObject("treeId") != null) {
                String treeId = (String)this.pp.getObject("treeId");
                if (this.orgList != null && this.orgList.size() > 0) {
                    for (int i = 0; i < this.orgList.size(); ++i) {
                        if (i % 2 != 0 || !this.orgList.get(i).toString().equals(treeId)) continue;
                        this.cmbOrgTree.setSelectedIndex(Integer.valueOf(this.orgList.get(i + 1).toString()).intValue());
                    }
                }
            }
        }
        this.refreshCompany();
        if (this.pp.containsKey("targetCompany") && this.pp.getObject("targetCompany") != null) {
            String companyId = (String)this.pp.getObject("targetCompany");
            try {
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.bizCompany.setData((Object)companyInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void refreshCompany() {
        OrgTreeInfo treeInfo = null;
        this.bizCompany.setValue(null);
        if (this.cmbOrgTree.getSelectedItem() != null) {
            this.bizCompany.setEnabled(true);
            treeInfo = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1);
            f7.setTreeID(treeInfo.getId().toString());
            f7.setNeedAddOrgRange(false);
            f7.setCtrlUnitPK(treeInfo.getCU());
            f7.setMultiSelect(false);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            this.bizCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
            try {
                this.bizCompany.setFilterInfoProducer(f7.getOrgUnitFilterInfoProducer());
            }
            catch (Exception e) {
                logger.error((Object)"getOrgUnitFilterInfoProducer_Exception", (Throwable)e);
            }
            this.bizCompany.setSelector((KDPromptSelector)f7);
            this.bizCompany.setEditable(true);
        } else {
            this.bizCompany.setEnabled(false);
        }
    }

    private void fillPeriodType() {
        this.cmbSourceType.removeAllItems();
        Iterator itor = RptPeriodTypeEnum.iterator();
        RptPeriodTypeEnum curItem = null;
        while (itor.hasNext()) {
            curItem = (RptPeriodTypeEnum)itor.next();
            this.cmbSourceType.addItem((Object)curItem);
            int type = this.pp.getInt("periodType");
            if (type != curItem.getValue()) continue;
            this.cmbSourceType.setSelectedItem((Object)curItem);
        }
    }

    private void fillStrPeriodType() {
        this.cmbSourceType.removeAllItems();
        Iterator itor = RptPeriodTypeEnum.iterator();
        RptPeriodTypeEnum curItem = null;
        while (itor.hasNext()) {
            int type;
            curItem = (RptPeriodTypeEnum)itor.next();
            this.cmbSourceType.addItem((Object)curItem);
            if (!this.pp.containsKey("periodType") || (type = this.pp.getInt("periodType")) != curItem.getValue()) continue;
            this.cmbSourceType.setSelectedItem((Object)curItem);
        }
    }

    private void doFillDataToUI() {
        String fromCurrencyId;
        if (this.pp.containsKey("toCurrency") && (fromCurrencyId = this.pp.getString("toCurrency")) != null) {
            for (int j = 1; j < this.cmbCurrency.getItemCount(); ++j) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getItemAt(j);
                if (!currencyInfo.getId().toString().equals(fromCurrencyId)) continue;
                this.cmbCurrency.setSelectedIndex(j);
                break;
            }
        }
        if (this.pp.containsKey("treeId") && this.pp.getObject("treeId") != null) {
            String treeId = (String)this.pp.getObject("treeId");
            if (this.orgList != null && this.orgList.size() > 0) {
                for (int i = 0; i < this.orgList.size(); ++i) {
                    if (i % 2 != 0 || !this.orgList.get(i).toString().equals(treeId)) continue;
                    this.cmbOrgTree.setSelectedIndex(Integer.valueOf(this.orgList.get(i + 1).toString()).intValue());
                }
            }
        }
        if (this.pp.containsKey("targetCompany") && this.pp.getObject("targetCompany") != null) {
            String companyId = (String)this.pp.getObject("targetCompany");
            try {
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.bizCompany.setData((Object)companyInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void clearUI() {
        this.bizCompany.setValue(null);
        this.cmbCurrency.setSelectedItem((Object)this.baseCurrency);
        if (this.cmbOrgTree.getSelectedIndex() != -1) {
            this.cmbOrgTree.setSelectedIndex(0);
        }
    }

    public void clear() {
        this.clearUI();
        this.pp = null;
        try {
            this.loadInitData();
            this.fillDataToUI();
            this.cmbSourceType.setSelectedIndex(2);
            Date date = new Date(System.currentTimeMillis());
            Date preDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
            this.kdpDate.setValue((Object)preDate);
            this.cmbCurrency.setSelectedIndex(this.bsCurrency2);
            this.fillPeriodType();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public RptProperties getCustomCondition() {
        OrgTreeInfo treeInfo = (OrgTreeInfo)this.cmbOrgTree.getShowSelectedItem();
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        String companyId = orgUnitInfo.getId().toString();
        String targetCompanyId = null;
        if (this.bizCompany.getValue() != null && !(this.bizCompany.getValue() instanceof String)) {
            targetCompanyId = ((OrgUnitInfo)this.bizCompany.getValue()).getId().toString();
        } else if (this.bizCompany.getValue() != null && this.bizCompany.getValue() instanceof String) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"340_CopyHisDataFilterUI"));
            SysUtil.abort();
        }
        if (treeInfo != null && treeInfo.getId() != null) {
            this.pp.setString("treeId", treeInfo.getId().toString());
        } else {
            this.pp.setString("treeId", null);
        }
        this.pp.setString("orgUnitId", companyId);
        this.pp.setInt("year", Integer.parseInt(this.kspYear.getValue().toString()));
        this.pp.setInt("period", Integer.parseInt(this.kspPeriod.getValue().toString()));
        this.pp.setInt("periodType", ((RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem()).getValue());
        this.pp.setString("company", companyId == null ? null : companyId);
        this.pp.setString("targetCompany", targetCompanyId == null ? null : targetCompanyId);
        this.pp.setString("fromCurrency", null);
        this.pp.setString("toCurrency", this.cmbCurrency.getSelectedIndex() <= 0 ? null : ((CurrencyInfo)this.cmbCurrency.getSelectedItem()).getId().toString());
        this.pp.setBoolean("isByCompany", new Boolean(true));
        return this.pp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        RptProperties condition = new RptProperties();
        if (cp == null) {
            return;
        }
        condition.putAll(cp.getCustomerParamsHashMap());
        if (cp.getCustomerParam("year") != null && !cp.getCustomerParam("year").equals("")) {
            condition.setInt("year", Integer.parseInt(cp.getCustomerParam("year")));
        }
        if (cp.getCustomerParam("period") != null && !cp.getCustomerParam("period").equals("")) {
            condition.setInt("period", Integer.parseInt(cp.getCustomerParam("period")));
        }
        if (cp.getCustomerParam("periodType") != null && !cp.getCustomerParam("periodType").equals("")) {
            condition.setInt("periodType", Integer.parseInt(cp.getCustomerParam("periodType")));
        }
        this.setCustomCondition(condition);
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        this.doFillDataToUI();
        this.fillStrPeriodType();
        this.fillDataToUI();
    }

    @Override
    public Object getParam() {
        return this.getCustomCondition();
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    public Dimension getSize() {
        return new Dimension(320, 286);
    }

    public boolean verify() {
        if (null == this.kdpDate.getValue()) {
            Date date = new Date(System.currentTimeMillis());
            Date preDate = RPTDateUtil.getPrevMonthLastDayByDate(date);
            this.kdpDate.setValue((Object)preDate);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"780_PKDATE_IS_NOT_NULL"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        if (OrgViewType.COMPANY.equals((Object)this.orgViewType)) {
            return new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.client", "InterItemDataFilterUI");
        }
        return new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.client", "MInterItemDataFilterUI");
    }

    private void refresh13Period() {
        if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isSupport13Period()) {
            int periodType = 0;
            if ("".equals(this.cmbSourceType.getSelectedItem()) || this.cmbSourceType.getSelectedItem() == null) {
                periodType = 0;
            } else {
                RptPeriodTypeEnum rptPeriodTypeEnum = (RptPeriodTypeEnum)this.cmbSourceType.getSelectedItem();
                int n = periodType = rptPeriodTypeEnum == null ? 0 : rptPeriodTypeEnum.getValue();
            }
            if (3 == periodType && RPTDateUtil.isYearLastPeriod((Date)this.kdpDate.getValue(), RptPeriodTypeEnum.MONTHLY)) {
                this.kspPeriod.setEnabled(true);
                CslRptUIUtil.setSpineRange(this.kspPeriod, 12, 13);
            } else {
                this.kspPeriod.setEnabled(false);
                CslRptUIUtil.setSpineRange(this.kspPeriod, 0, 365);
            }
        }
    }
}

