/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CompanyTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationMode;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.InvestDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestItemDCRuleEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestNewAdjustElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptControlTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractInvestTempletEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaSelector;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class InvestTempletEditUI
extends AbstractInvestTempletEditUI {
    private static final long serialVersionUID = -926190110526247625L;
    private static final Logger logger = CoreUIObject.getLogger(InvestTempletEditUI.class);
    private static final int TB_ITEM_NUMBER = 1;
    private static final int TB_ITEM_NAME = 2;
    private static final int TB_DEBITFORMULA = 6;
    private static final int TB_CREDITFORMULA = 7;
    private static final String DEBIT_FORMULA = "debitFormula";
    private static final String CREDIT_FORMULA = "creditFormula";
    private static final String TB_DATAELEMENT = "dataElement";
    ArrayList userDefined = new ArrayList();

    public InvestTempletEditUI() throws Exception {
        this.comboElimMode.addItem((Object)new EliminationModeInfo());
        IEliminationMode iElimMode = EliminationModeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        CslGradeManageUtil.filterElimModeGradeManage((EntityViewInfo)viewInfo, null);
        EliminationModeCollection collection = iElimMode.getEliminationModeCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                this.comboElimMode.addItem((Object)collection.get(i));
            }
        }
    }

    private void initHeadData() throws BOSException {
        this.kdtEntries.checkParsed();
        this.initComboTempletTypeItems();
        this.comboElimType.setAccessAuthority(0);
        this.txtNumber.setAccessAuthority(0);
        this.comboInvestNewType.setAccessAuthority(0);
        this.comboElimType.setEnabled(false);
        if (this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
            this.comboInvestNewType.setEnabled(true);
        } else {
            this.comboInvestNewType.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.txtNumber.setEditable(false);
        } else {
            this.txtNumber.setEditable(true);
        }
        this.kdtEntries.getColumn("rptItem.name").getStyleAttributes().setLocked(true);
        if (!this.getOprtState().equals(OprtState.ADDNEW) && !this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
            this.kdtEntries.getColumn("dcType").getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(DEBIT_FORMULA).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(CREDIT_FORMULA).getStyleAttributes().setLocked(true);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.kdtEntries.getColumn("rptItem.number").getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn("companyType").getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_DATAELEMENT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn("dcType").getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(DEBIT_FORMULA).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(CREDIT_FORMULA).getStyleAttributes().setLocked(true);
        } else {
            this.kdtEntries.getColumn("rptItem.number").getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn("companyType").getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(TB_DATAELEMENT).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn("dcType").getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(DEBIT_FORMULA).getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn(CREDIT_FORMULA).getStyleAttributes().setLocked(false);
        }
        if (this.editData.getEliminationMode() != null) {
            for (int i = 0; i < this.comboElimMode.getItemCount(); ++i) {
                EliminationModeInfo elimMode = (EliminationModeInfo)this.comboElimMode.getItemAt(i);
                if (elimMode == null || !this.editData.getEliminationMode().getId().equals((Object)elimMode.getId())) continue;
                this.comboElimMode.setSelectedIndex(i);
                break;
            }
        }
    }

    private void initComboTempletTypeItems() {
        boolean isAddNew = this.getOprtState().equals(OprtState.ADDNEW);
        InvestTempletEnum selectedItem = null;
        if (!isAddNew) {
            selectedItem = (InvestTempletEnum)((Object)this.comboTempletType.getSelectedItem());
        }
        this.comboTempletType.removeAllItems();
        int elimTypeValue = ((ElimTypeEnum)((Object)this.comboElimType.getSelectedItem())).getValue();
        if (isAddNew && elimTypeValue == 7) {
            ArrayList<InvestTempletEnum> newInvestTemplate = new ArrayList<InvestTempletEnum>();
            newInvestTemplate.add(InvestTempletEnum.MAIN_INVEST_SURPLUS);
            newInvestTemplate.add(InvestTempletEnum.MAIN_INVEST_LONG_TERM);
            newInvestTemplate.add(InvestTempletEnum.MAIN_INVEST_SHAREHOLDER_RIGHT);
            newInvestTemplate.add(InvestTempletEnum.MAIN_INVEST_SHAREHOLDER_PL);
            newInvestTemplate.add(InvestTempletEnum.MAIN_INVEST_ID_OWNERS_EQUITY);
            newInvestTemplate.add(InvestTempletEnum.MAIN_INVEST_ID_PROFITDIST);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_ID_BEFOREYEAR);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_ID_THISYEAR);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_ID_FEWSHARESHOLDER);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_ID_OTHERRIGHT);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_IUD_BEFOREYEAR);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_IUD_THISYEAR);
            newInvestTemplate.add(InvestTempletEnum.MAIN_INVEST_UID_LONG_TERM);
            newInvestTemplate.add(InvestTempletEnum.MAIN_INVEST_UID_INVESTMENT_INCOME);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_UID_WITHDRAWAL);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_UID_THISYEAR_OTHER);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_UID_PROFITDIST);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_UID_OTHERRIGHT);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_UIUD_BEFOREYEAR);
            newInvestTemplate.add(InvestTempletEnum.MAIN_COST_UIUD_THISYEAR);
            this.comboTempletType.addItems(newInvestTemplate.toArray());
        } else {
            List investTemplate = InvestTempletEnum.getEnumList();
            this.comboTempletType.addItems(investTemplate.toArray());
            if (!isAddNew) {
                this.comboTempletType.setSelectedItem((Object)selectedItem);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
        }
    }

    private void storeEntries(KDTable table, IRow row, IObjectValue obj) {
        CompanyTypeEnum companyType;
        InvestTempletEntryInfo lineInfo = (InvestTempletEntryInfo)obj;
        if (row.getCell("rptItem.number").getValue() instanceof RPTItemInfo) {
            lineInfo.setItem(((RPTItemInfo)row.getCell("rptItem.number").getValue()).getId().toString());
        } else if (row.getCell("rptItem.number").getValue() instanceof String) {
            lineInfo.setItem(row.getCell("rptItem.number").getValue().toString());
        } else {
            row.getCell("rptItem.number").setValue(null);
        }
        InvestItemDCRuleEnum dc = (InvestItemDCRuleEnum)((Object)row.getCell("dcType").getValue());
        if (dc != null) {
            lineInfo.setDcType(dc);
        }
        lineInfo.setDebitFormula(row.getCell(DEBIT_FORMULA).getValue() == null ? null : row.getCell(DEBIT_FORMULA).getValue().toString());
        lineInfo.setCreditFormula(row.getCell(CREDIT_FORMULA).getValue() == null ? null : row.getCell(CREDIT_FORMULA).getValue().toString());
        DataElementInfo element = (DataElementInfo)row.getCell(TB_DATAELEMENT).getValue();
        if (element != null) {
            lineInfo.setDataElement(((DataElementInfo)row.getCell(TB_DATAELEMENT).getValue()).getInterSeq());
        }
        if ((companyType = (CompanyTypeEnum)((Object)row.getCell("companyType").getValue())) != null) {
            lineInfo.setCompanyType((CompanyTypeEnum)((Object)row.getCell("companyType").getValue()));
        }
        lineInfo.setControlAttr(RPTItemControlEnum.CUSTOM);
        lineInfo.setType(RptControlTypeEnum.OTHER);
        lineInfo.setIsSumItemExtend(false);
        lineInfo.setSummary(row.getCell("summary").getValue() != null && row.getCell("summary").getValue().toString().length() > 0 ? row.getCell("summary").getValue().toString() : this.editData.getName());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().equals("")) {
            this.txtNumber.requestFocus(true);
            throw new AdjustException(AdjustException.NUMBER_BLANK);
        }
        if (this.editData.getName() == null || this.editData.getName().trim().equals("")) {
            this.txtName.requestFocus(true);
            throw new AdjustException(AdjustException.NAME_BLANK);
        }
        if (this.editData.getTempletType() == null) {
            this.comboTempletType.requestFocus(true);
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"536_InvestTempletEditUI")));
        }
        InvestNewAdjustElimTypeEnum investNewType = this.editData.getInvestNewType();
        if (this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New) && (investNewType == null || InvestNewAdjustElimTypeEnum.EMPTY_VALUE.equals((Object)investNewType))) {
            this.comboInvestNewType.requestFocus(true);
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"537_InvestTempletEditUI")));
        }
        if (this.editData.getEntries() == null || this.editData.getEntries().size() == 0) {
            throw new AdjustException(AdjustException.LINE_NOT_EXIST);
        }
        if (this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
            InvestTempletEntryCollection col = this.editData.getEntries();
            for (int i = 0; i < col.size(); ++i) {
                InvestTempletEntryInfo entryInfo = col.get(i);
                if (entryInfo.getItem() == null) {
                    throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"538_InvestTempletEditUI")));
                }
                if (entryInfo.getDcType() == null) {
                    throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"539_InvestTempletEditUI")));
                }
                CompanyTypeEnum companyType = entryInfo.getCompanyType();
                if (companyType == null) {
                    throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"540_InvestTempletEditUI")));
                }
                if (entryInfo.getDataElement() == 0) {
                    throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"541_InvestTempletEditUI")));
                }
                if (!companyType.equals((Object)CompanyTypeEnum.FROM_BALANCE) && !companyType.equals((Object)CompanyTypeEnum.FROM_CONSTANT) && entryInfo.getDebitFormula() == null && entryInfo.getCreditFormula() == null) {
                    if (investNewType.equals((Object)InvestNewAdjustElimTypeEnum.INVEST_ADJUST)) {
                        throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"542_InvestTempletEditUI")));
                    }
                    if (entryInfo.getItem() == null) continue;
                    RPTItemInfo itemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo((IObjectPK)new ObjectUuidPK(entryInfo.getItem()));
                    if (!itemInfo.getControl().equals((Object)RPTItemControlEnum.FUNDED_INVEST) && !itemInfo.getControl().equals((Object)RPTItemControlEnum.INVEST_INCOME)) {
                        throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"543_InvestTempletEditUI")));
                    }
                }
                if (companyType.equals((Object)CompanyTypeEnum.FROM_CONSTANT) && (entryInfo.getDebitFormula() == null || "0".equals(entryInfo.getDebitFormula())) && (entryInfo.getCreditFormula() == null || "0".equals(entryInfo.getCreditFormula()))) {
                    throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"905_InvestTempletEditUI")));
                }
                if (entryInfo.getDebitFormula() != null && entryInfo.getDebitFormula().length() > 2000) {
                    throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustTemplet_TooLongDebitFormula")), new Object[]{new Integer(i)});
                }
                if (entryInfo.getCreditFormula() == null || entryInfo.getCreditFormula().length() <= 2000) continue;
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustTemplet_TooLongCreditFormula")), new Object[]{new Integer(i)});
            }
        }
        int size1 = this.editData.getEntries().size();
        int dcount = 0;
        int ccount = 0;
        for (int i = 0; i < size1; ++i) {
            InvestTempletEntryInfo entryInfo = this.editData.getEntries().get(i);
            if (!entryInfo.getCompanyType().equals((Object)CompanyTypeEnum.FROM_BALANCE)) continue;
            if (entryInfo.getDcType().equals((Object)InvestItemDCRuleEnum.DEBIT)) {
                ++dcount;
                continue;
            }
            ++ccount;
        }
        if (dcount >= 2 || ccount >= 2) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"544_InvestTempletEditUI"));
            SysUtil.abort();
            return;
        }
    }

    @Override
    public void storeFields() {
        if (this.getOprtState().equals(OprtState.VIEW) || !this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
            this.editData.setSyncOldValue(true);
        }
        this.addCreatrOrg();
        this.editData.copyNewToOld();
        super.storeFields();
        InvestTempletEntryCollection col = this.editData.getEntries();
        if (this.userDefined.size() > 0 && !this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
            block2: for (int i = 0; i < this.userDefined.size(); ++i) {
                Integer rowIndex = (Integer)this.userDefined.get(i);
                IRow row = this.kdtEntries.getRow(rowIndex.intValue());
                if (row == null) continue;
                Integer isUserDefinded = (Integer)row.getCell("isUserDefinded").getValue();
                String entryId = (String)row.getCell("id").getValue();
                if (isUserDefinded != 1 || col == null || col.size() <= 0) continue;
                for (int j = 0; j < col.size(); ++j) {
                    InvestTempletEntryInfo entry = col.get(j);
                    if (!entry.getId().toString().equals(entryId)) continue;
                    if (row.getCell("rptItem.number").getValue() == null) {
                        entry.setItem(null);
                    } else {
                        String number = row.getCell("rptItem.number").getValue().toString();
                        String id = null;
                        try {
                            RPTItemInfo info = RPTItemFactory.getRemoteInstance().getRPTItemInfo("select id where number = '" + number + "'");
                            id = info.getId().toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        entry.setItem(id);
                    }
                    DataElementInfo dataElement = (DataElementInfo)row.getCell(TB_DATAELEMENT).getValue();
                    entry.setDataElement(dataElement.getInterSeq());
                    CompanyTypeEnum companyType = (CompanyTypeEnum)((Object)row.getCell("companyType").getValue());
                    entry.setCompanyType(companyType);
                    entry.setIsUserDefinded(true);
                    entry.setSummary(row.getCell("summary").getValue() != null && row.getCell("summary").getValue().toString().length() > 0 ? row.getCell("summary").getValue().toString() : this.editData.getName());
                    continue block2;
                }
            }
        } else {
            this.editData.setSyncOldValue(true);
            this.putTableData2Entries();
            this.editData.setSyncOldValue(false);
        }
    }

    private void addCreatrOrg() {
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
    }

    protected IObjectValue createNewData() {
        this.kdtEntries.removeRows();
        InvestTempletInfo info = new InvestTempletInfo();
        info.setElimType(ElimTypeEnum.Main_Invest_New);
        this.kdtEntries.addRow();
        this.kdtEntries.addRow();
        return info;
    }

    private void doPreNext() {
        boolean isEdit;
        for (int i = 0; i < this.kdtEntries.getRowCount() && !(isEdit = this.isEdited(i)); ++i) {
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        String id = this.idList.getCurrentID();
        this.bindDataToTable(id);
        this.doPreNext();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        String id = this.idList.getCurrentID();
        this.bindDataToTable(id);
        this.doPreNext();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        String id = this.idList.getCurrentID();
        this.bindDataToTable(id);
        this.doPreNext();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        String id = this.idList.getCurrentID();
        this.bindDataToTable(id);
        this.doPreNext();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InvestTempletFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuSubmitOption.setVisible(false);
        this.btnPCVoucher.setVisible(false);
        this.btnDelPCVoucher.setVisible(false);
        this.actionPCVoucher.setVisible(false);
        this.actionDelPCVoucher.setVisible(false);
        this.menuBiz.setVisible(false);
        this.initHeadData();
        this.initEntryTable();
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.bindDataToTable(this.idList.getCurrentID());
        } else {
            this.putTableData2Entries();
        }
        this.hideUnuseableButtons();
        this.kdtEntries.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                InvestTempletEditUI.this.selectTable(e);
            }
        });
        this.initDCEditable();
        if (this.getUIContext().get("status") != null) {
            this.actionCopy_actionPerformed(null);
            this.txtNumber.setEditable(true);
            this.txtNumber.setText(null);
            this.txtName.setName(null);
            this.editData.setId(null);
        }
        this.initRowMoveListener();
    }

    private void initRowMoveListener() {
        final KDTableMoveAction rowMoveAction = new KDTableMoveAction(this.kdtEntries);
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToHead();
            }
        });
        this.btnMoveBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToTail();
            }
        });
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntries.addRow();
    }

    protected void addLine(KDTable table) {
        this.kdtEntries.addRow();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.initHeadData();
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntries == null) {
            return;
        }
        if (this.kdtEntries.getSelectManager().size() > 0) {
            int top = this.kdtEntries.getSelectManager().get().getTop();
            if (this.isTableColumnSelected(this.kdtEntries)) {
                this.kdtEntries.addRow();
            } else {
                this.kdtEntries.addRow(top);
            }
        } else {
            this.kdtEntries.addRow();
        }
    }

    private void hideUnuseableButtons() {
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.actionSave.setEnabled(false);
        this.btnCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.btnCopyFrom.setVisible(false);
        this.actionCopyFrom.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemCopyFrom.setVisible(false);
        this.menuItemCreateFrom.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        }
        if (!this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
            this.actionEdit.setEnabled(false);
        }
        this.menuItemViewDoProccess.setVisible(false);
        this.actionViewDoProccess.setEnabled(false);
        this.menuItemViewSubmitProccess.setVisible(false);
        this.actionViewSubmitProccess.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.btnCopy.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.menuItemRemove.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.menuItemSubmit.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.menuItemNextPerson.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionWorkFlowG.setEnabled(false);
        this.btnStatus();
    }

    private void bindDataToTable(String templetID) throws Exception {
        this.kdtEntries.removeRows();
        IInvestDataProvider iInvestDataProvider = InvestDataProviderFactory.getRemoteInstance();
        boolean isMondify = false;
        List list = iInvestDataProvider.getDatasByInvestTempletID(templetID);
        if (list != null) {
            HashMap map = null;
            int rowCount = list.size();
            this.kdtEntries.addRows(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                map = (HashMap)list.get(i);
                IRow row = this.kdtEntries.getRow(i);
                row.getCell(0).setValue(map.get("summary"));
                Integer isUserDefinded = (Integer)map.get("isUserDefinded");
                row.getCell("isUserDefinded").setValue((Object)isUserDefinded);
                if (isUserDefinded == 1 && this.getOprtState().equals(OprtState.EDIT)) {
                    this.userDefined.add(new Integer(i));
                    this.actionSubmit.setEnabled(true);
                }
                if (isUserDefinded == 1 && (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW))) {
                    this.userDefined.add(new Integer(i));
                }
                RPTItemInfo item = new RPTItemInfo();
                if (map.get("itemId") != null) {
                    item.setId(BOSUuid.read((String)map.get("itemId").toString()));
                    item.setNumber(map.get("number").toString());
                    row.getCell("rptItem.number").setValue((Object)item);
                } else {
                    isMondify = true;
                }
                row.getCell(2).setValue(map.get("name"));
                row.getCell(3).setValue((Object)CompanyTypeEnum.getEnum((Integer)map.get("companytype")));
                row.getCell(4).setValue((Object)DataElementProvider.getDataElementInfo((Integer)map.get("dataelement")));
                int dcType = (Integer)map.get("dctype");
                if (dcType == 1 || dcType == 2) {
                    row.getCell(5).setValue((Object)InvestItemDCRuleEnum.getEnum(dcType));
                } else {
                    row.getCell(5).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"DebitOrCredit"));
                }
                row.getCell(DEBIT_FORMULA).setValue(map.get("fdebitformula"));
                row.getCell(CREDIT_FORMULA).setValue(map.get("FCreditFormula"));
                String entryId = (String)map.get("entryId");
                row.getCell("id").setValue((Object)entryId);
            }
            if (isMondify && this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"545_InvestTempletEditUI"));
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"AddAttrRptItem"));
        }
        this.editData.setSyncOldValue(true);
        this.putTableData2Entries();
        this.editData.setSyncOldValue(false);
    }

    private void putTableData2Entries() {
        if (this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
            int i;
            int size = this.kdtEntries.getRowCount();
            int entrySize = this.editData.getEntries().size();
            for (i = 0; i < size; ++i) {
                IRow row = this.kdtEntries.getRow(i);
                InvestTempletEntryInfo entryInfo = this.editData.getEntries().get(i);
                if (entryInfo == null) {
                    entryInfo = new InvestTempletEntryInfo();
                    entryInfo.setControlAttr(RPTItemControlEnum.CUSTOM);
                    entryInfo.setType(RptControlTypeEnum.OTHER);
                    this.editData.getEntries().add(entryInfo);
                    this.editData.copyNewToOld();
                }
                this.storeEntries(this.kdtEntries, row, (IObjectValue)entryInfo);
            }
            if (size < entrySize) {
                for (i = size; i < entrySize; ++i) {
                    this.editData.getEntries().removeObject(size);
                }
            }
        }
    }

    private void selectTable(KDTSelectEvent e) {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        int begin = e.getSelectBlock().getBeginRow();
        this.isEdited(begin);
    }

    private boolean isEdited(int begin) {
        IRow row = this.kdtEntries.getRow(begin);
        if (this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New) && row != null) {
            row.getCell("rptItem.number").getStyleAttributes().setLocked(false);
            row.getCell("companyType").getStyleAttributes().setLocked(false);
            row.getCell(TB_DATAELEMENT).getStyleAttributes().setLocked(false);
            row.getCell("dcType").getStyleAttributes().setLocked(false);
            InvestItemDCRuleEnum dcType = (InvestItemDCRuleEnum)((Object)row.getCell("dcType").getValue());
            if (InvestItemDCRuleEnum.DEBIT.equals((Object)dcType)) {
                row.getCell(DEBIT_FORMULA).getStyleAttributes().setLocked(false);
            } else {
                row.getCell(CREDIT_FORMULA).getStyleAttributes().setLocked(false);
            }
            return false;
        }
        if (row != null && row.getCell("isUserDefinded") != null && row.getCell("isUserDefinded").getValue() != null) {
            Integer isUserDefinded = (Integer)row.getCell("isUserDefinded").getValue();
            if (isUserDefinded == 1) {
                row.getCell("rptItem.number").getStyleAttributes().setLocked(false);
                row.getCell("companyType").getStyleAttributes().setLocked(false);
                row.getCell(TB_DATAELEMENT).getStyleAttributes().setLocked(false);
                row.getCell("dcType").getStyleAttributes().setLocked(true);
                row.getCell(DEBIT_FORMULA).getStyleAttributes().setLocked(true);
                row.getCell(CREDIT_FORMULA).getStyleAttributes().setLocked(true);
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(false);
                return true;
            }
            row.getCell("rptItem.number").getStyleAttributes().setLocked(true);
            row.getCell("companyType").getStyleAttributes().setLocked(true);
            row.getCell(TB_DATAELEMENT).getStyleAttributes().setLocked(true);
            row.getCell("dcType").getStyleAttributes().setLocked(true);
            row.getCell(DEBIT_FORMULA).getStyleAttributes().setLocked(true);
            row.getCell(CREDIT_FORMULA).getStyleAttributes().setLocked(true);
            this.actionEdit.setEnabled(false);
            return false;
        }
        return false;
    }

    private void initEntryTable() throws Exception {
        KDComboBox cmbCompanyType = new KDComboBox();
        this.initCompanyType(cmbCompanyType);
        this.getDetailTable().getColumn("companyType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbCompanyType));
        KDBizPromptBox bizBoxDataElement = new KDBizPromptBox();
        bizBoxDataElement.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        bizBoxDataElement.setEditFormat("$number$");
        bizBoxDataElement.setDisplayFormat("$number$");
        bizBoxDataElement.setEditable(true);
        bizBoxDataElement.setCommitFormat("$number$");
        CslGradeManageUtil.setDataElementF7GMFilter((KDBizPromptBox)bizBoxDataElement, null, (boolean)false);
        this.kdtEntries.getColumn(TB_DATAELEMENT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBoxDataElement));
        KDComboBox dcType = new KDComboBox();
        dcType.addItem((Object)InvestItemDCRuleEnum.DEBIT);
        dcType.addItem((Object)InvestItemDCRuleEnum.CREDIT);
        dcType.setSelectedIndex(0);
        this.getDetailTable().getColumn("dcType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)dcType));
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)bizBoxItem);
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
        bizBoxItem.setEditFormat("$number$");
        bizBoxItem.setDisplayFormat("$number$");
        bizBoxItem.setEditable(true);
        bizBoxItem.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)bizBoxItem, null);
        this.getDetailTable().getColumn("rptItem.number").setEditor((ICellEditor)itemEditor);
        KDPromptBox prmtBoxD = new KDPromptBox();
        this.putClientProperty("selectCategory", "cslrptformula");
        prmtBoxD.setSelector((KDPromptSelector)new FormulaSelector((CoreUIObject)this, 0));
        prmtBoxD.setEditable(true);
        KDTDefaultCellEditor formulaEditorD = new KDTDefaultCellEditor((IKDEditor)prmtBoxD);
        this.getDetailTable().getColumn(DEBIT_FORMULA).setEditor((ICellEditor)formulaEditorD);
        KDPromptBox prmtBoxC = new KDPromptBox();
        prmtBoxC.setSelector((KDPromptSelector)new FormulaSelector((CoreUIObject)this, 0));
        prmtBoxC.setEditable(true);
        KDTDefaultCellEditor formulaEditorC = new KDTDefaultCellEditor((IKDEditor)prmtBoxC);
        this.getDetailTable().getColumn(CREDIT_FORMULA).setEditor((ICellEditor)formulaEditorC);
        this.kdtEntries.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                InvestTempletEditUI.this.tableValueChanged(e);
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.kdtEntries.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                InvestTempletEditUI.this.fillFormula(e);
            }
        });
    }

    private void fillFormula(KDTActiveCellEvent e) {
        int rowIndex = e.getRowIndex();
        if (rowIndex > this.kdtEntries.getRowCount() || rowIndex < 0) {
            return;
        }
        this.putClientProperty("clientProperty_formula_debit", null);
        this.putClientProperty("clientProperty_formula_credit", null);
        int colIndex = e.getColumnIndex();
        Object formulaObj = this.kdtEntries.getRow(rowIndex).getCell(colIndex).getValue();
        if (formulaObj != null && formulaObj.toString().trim().length() > 0) {
            this.putClientProperty("clientProperty_formula_credit", formulaObj.toString());
        }
    }

    public void initDataElementCombox(KDComboBox combo, boolean isIncludeEmpty, boolean isIncludeUnUsed) throws Exception {
        DataElementCollection dataElements = null;
        combo.removeAllItems();
        if (isIncludeEmpty) {
            DataElementInfo nullInfo = new DataElementInfo();
            combo.addItem((Object)nullInfo);
            combo.setSelectedItem((Object)nullInfo);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!isIncludeUnUsed) {
            StringBuffer s = new StringBuffer();
            filter.getFilterItems().add(new FilterItemInfo("isUsedElim", (Object)Boolean.TRUE));
            s.append("#0");
            if (!this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
                filter.getFilterItems().add(new FilterItemInfo("interSeq", (Object)new Integer(1), CompareType.EQUALS));
                s.append(" and ( #1");
                filter.getFilterItems().add(new FilterItemInfo("interSeq", (Object)new Integer(2), CompareType.EQUALS));
                s.append(" or #2");
                filter.getFilterItems().add(new FilterItemInfo("interSeq", (Object)new Integer(3), CompareType.EQUALS));
                s.append(" or #3");
                filter.getFilterItems().add(new FilterItemInfo("interSeq", (Object)new Integer(4), CompareType.EQUALS));
                s.append(" or #4");
                filter.getFilterItems().add(new FilterItemInfo("interSeq", (Object)new Integer(5), CompareType.EQUALS));
                s.append(" or #5)");
            }
            filter.setMaskString(s.toString());
            view.setFilter(filter);
        }
        try {
            CslGradeManageUtil.filterDataElementGradeManage((EntityViewInfo)view, null);
            dataElements = DataElementFactory.getRemoteInstance().getDataElementCollection(view);
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        if (dataElements != null && dataElements.size() > 0) {
            combo.addItems(dataElements.toArray());
        }
    }

    private void initCompanyType(KDComboBox cmbCompanyType) {
        cmbCompanyType.addItem((Object)CompanyTypeEnum.FROM_INVEST);
        cmbCompanyType.addItem((Object)CompanyTypeEnum.TO_INVEST);
        cmbCompanyType.addItem((Object)CompanyTypeEnum.FROM_BALANCE);
        cmbCompanyType.addItem((Object)CompanyTypeEnum.FROM_CONSTANT);
        cmbCompanyType.setSelectedIndex(0);
    }

    private void tableValueChanged(KDTEditEvent e) {
        KDTable kdtEntry;
        int selectRow;
        block18: {
            selectRow = e.getRowIndex();
            kdtEntry = (KDTable)e.getSource();
            if (e.getColIndex() == 1) {
                if (e.getValue() != null && e.getOldValue() != e.getValue()) {
                    RPTItemInfo rptItem = (RPTItemInfo)e.getValue();
                    kdtEntry.getRow(selectRow).getCell(2).setValue((Object)rptItem.getName(this.getCurrentLocale()));
                    try {
                        IRow row = this.kdtEntries.getRow(selectRow);
                        IRPTItem ir = RPTItemFactory.getRemoteInstance();
                        DataElementInfo dataElement = ir.getReportClassDataElement(rptItem.getId().toString());
                        if (dataElement == null) {
                            dataElement = DataElementProvider.getDataElementInfo("ENDBALANCE");
                            row.getCell(TB_DATAELEMENT).setValue((Object)dataElement);
                            break block18;
                        }
                        row.getCell(TB_DATAELEMENT).setValue((Object)dataElement);
                    }
                    catch (BOSException e1) {
                        logger.error((Object)"getDataElement_BOSException", (Throwable)e1);
                    }
                    catch (EASBizException e1) {
                        logger.error((Object)"getDataElement_EASBizException", (Throwable)e1);
                    }
                } else if (kdtEntry.getRow(selectRow).getCell(1).getValue() == null) {
                    kdtEntry.getRow(selectRow).getCell(2).setValue(null);
                }
            }
        }
        if (kdtEntry.getColumnKey(e.getColIndex()).equals("dcType")) {
            InvestItemDCRuleEnum dccc = (InvestItemDCRuleEnum)((Object)kdtEntry.getRow(selectRow).getCell("dcType").getValue());
            this.setDCEditable(kdtEntry.getRow(selectRow), dccc);
        }
        if (e.getColIndex() == 7 || e.getColIndex() == 6) {
            Object formulaObj = this.kdtEntries.getRow(selectRow).getCell(e.getColIndex()).getValue();
            if (formulaObj != null && formulaObj.toString().trim().length() > 0) {
                CompanyTypeEnum companyType = (CompanyTypeEnum)((Object)kdtEntry.getRow(selectRow).getCell("companyType").getValue());
                if (CompanyTypeEnum.FROM_CONSTANT.equals((Object)companyType)) {
                    this.checkFormulaIsNum(kdtEntry, formulaObj, selectRow, e.getColIndex());
                } else {
                    this.putClientProperty("clientProperty_formula_credit", formulaObj.toString());
                }
            } else {
                this.putClientProperty("clientProperty_formula_credit", null);
            }
        }
        if (kdtEntry.getColumnKey(e.getColIndex()).equals("companyType")) {
            CompanyTypeEnum companyType = (CompanyTypeEnum)((Object)kdtEntry.getRow(selectRow).getCell("companyType").getValue());
            if (!CompanyTypeEnum.FROM_CONSTANT.equals((Object)companyType)) {
                return;
            }
            Object debit_formulaObj = kdtEntry.getRow(selectRow).getCell(6).getValue();
            Object credit_formulaObj = kdtEntry.getRow(selectRow).getCell(7).getValue();
            if (debit_formulaObj != null && debit_formulaObj.toString().trim().length() > 0) {
                this.checkFormulaIsNum(kdtEntry, debit_formulaObj, selectRow, 6);
            }
            if (credit_formulaObj != null && credit_formulaObj.toString().trim().length() > 0) {
                this.checkFormulaIsNum(kdtEntry, credit_formulaObj, selectRow, 7);
            }
        }
    }

    private void checkFormulaIsNum(KDTable kdtEntry, Object formulaObj, int selectRow, int colIndex) {
        try {
            new BigDecimal(formulaObj.toString().trim());
            this.putClientProperty("clientProperty_formula_credit", formulaObj.toString());
        }
        catch (Exception e1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"901_InvestTempletEditUI_FormulaDefinitionError"));
            kdtEntry.getRow(selectRow).getCell(colIndex).setValue(null);
            this.putClientProperty("clientProperty_formula_credit", null);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.editData.copyNewToOld();
    }

    private void btnStatus() {
        if (this.editData != null) {
            if (!this.getOprtState().equals(OprtState.VIEW) && this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
                this.actionSubmit.setEnabled(true);
                this.btnAddLine.setVisible(true);
                this.btnRemoveLine.setVisible(true);
                this.menuItemAddLine.setVisible(true);
                this.menuItemRemoveLine.setVisible(true);
                this.actionAddLine.setEnabled(true);
                this.actionRemoveLine.setEnabled(true);
            } else {
                this.btnAddLine.setVisible(false);
                this.btnRemoveLine.setVisible(false);
                this.menuItemAddLine.setVisible(false);
                this.menuItemRemoveLine.setVisible(false);
                this.actionAddLine.setEnabled(false);
                this.actionRemoveLine.setEnabled(false);
                this.btnSubmit.setEnabled(false);
            }
            if (this.getOprtState().equals(OprtState.EDIT) && this.editData.getElimType().equals((Object)ElimTypeEnum.Main_Invest_New)) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(this.getOprtState().equals(OprtState.ADDNEW));
            }
        }
        this.btnInsertLine.setVisible(false);
        this.menuItemInsertLine.setVisible(false);
        this.actionInsertLine.setEnabled(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionRemove.setEnabled(false);
        this.btnStatus();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.item"));
        sic.add(new SelectorItemInfo("entries.isUserDefinded"));
        sic.add(new SelectorItemInfo("entries.companyType"));
        sic.add(new SelectorItemInfo("entries.dataElement"));
        sic.add(new SelectorItemInfo("trackRecordCreator.id"));
        return sic;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        InvestTempletEntryInfo entry = new InvestTempletEntryInfo();
        entry.setControlAttr(RPTItemControlEnum.CUSTOM);
        entry.setType(RptControlTypeEnum.OTHER);
        return entry;
    }

    private void initDCEditable() {
        if (this.editData.getInvestNewType() != null) {
            int rowCount = this.kdtEntries.getExpandedRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.kdtEntries.getRow(i);
                if (!(row.getCell("dcType").getValue() instanceof InvestItemDCRuleEnum)) continue;
                InvestItemDCRuleEnum dccc = (InvestItemDCRuleEnum)((Object)row.getCell("dcType").getValue());
                this.setDCEditable(row, dccc);
            }
        }
    }

    private void setDCEditable(IRow row, InvestItemDCRuleEnum dc) {
        if (dc == InvestItemDCRuleEnum.DEBIT) {
            row.getCell(DEBIT_FORMULA).getStyleAttributes().setLocked(false);
            row.getCell(CREDIT_FORMULA).getStyleAttributes().setLocked(true);
            row.getCell(CREDIT_FORMULA).setValue(null);
        } else if (dc == InvestItemDCRuleEnum.CREDIT) {
            row.getCell(CREDIT_FORMULA).getStyleAttributes().setLocked(false);
            row.getCell(DEBIT_FORMULA).getStyleAttributes().setLocked(true);
            row.getCell(DEBIT_FORMULA).setValue(null);
        }
    }

    protected BOSObjectType getBOSObjectType() {
        return null;
    }
}

