/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractItemDataImportWizardPage3UI;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataImportWizard;
import com.kingdee.eas.fi.gr.cslrpt.client.TextMsgBox;
import com.kingdee.eas.fi.gr.cslrpt.util.DispensePropertyHelperForItemDataInit;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ItemDataImportWizardPage3UI
extends AbstractItemDataImportWizardPage3UI {
    private static final Logger logger = CoreUIObject.getLogger(ItemDataImportWizardPage3UI.class);
    private ArrayList filesList = null;
    private Map parentParams = null;

    public ItemDataImportWizardPage3UI(Map parentParams) throws Exception {
        this.parentParams = parentParams;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Icon getImage() {
        return ItemDataImportWizard.getWizardImage();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblFileList.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int colIndex = ItemDataImportWizardPage3UI.this.tblFileList.getSelectManager().getActiveColumnIndex();
                int rowIndex = ItemDataImportWizardPage3UI.this.tblFileList.getSelectManager().getActiveRowIndex();
                ICell cell = ItemDataImportWizardPage3UI.this.tblFileList.getCell(rowIndex, colIndex);
                if (cell != null && cell.getUserObject() != null) {
                    UIContext ctx = new UIContext();
                    ctx.put((Object)"Title", (Object)DispensePropertyHelperForItemDataInit.getString("excelErrorTitle", null));
                    ctx.put((Object)"TextLabel", (Object)DispensePropertyHelperForItemDataInit.getString("excelErrorLabel", null));
                    ctx.put((Object)"TextMsg", (Object)cell.getUserObject().toString());
                    TextMsgBox.showMessageByModel(ctx);
                }
            }
        });
    }

    public void loadPage() {
        super.loadPage();
        this.tblFileList.getSelectManager().setSelectMode(1);
        this.lblHint.setText(DispensePropertyHelperForItemDataInit.getString("Dispense_Import_Doing_Caption", null));
        this.filesList = this.getMyWizard().getFilesToImport();
        this.tblFileList.setRefresh(false);
        this.tblFileList.removeRows();
        this.tblFileList.getStyleAttributes().setLocked(true);
        this.tblFileList.addRows(this.filesList.size());
        for (int i = 0; i < this.filesList.size(); ++i) {
            File file = (File)this.filesList.get(i);
            this.tblFileList.getCell(i, "name").setValue((Object)file.getName());
        }
        this.tblFileList.getStyleAttributes().setBackground(new Color(240, 240, 240));
        this.tblFileList.setRefresh(true);
        ArrayList list = this.getMyWizard().getFilesToImport();
        DispensePropertyHelperForItemDataInit helper = new DispensePropertyHelperForItemDataInit();
        Map result = null;
        ArrayList<Object[]> fileCompanyMsg = new ArrayList<Object[]>();
        HashMap<String, ArrayList<Object>> params = new HashMap<String, ArrayList<Object>>();
        params.put("companyMsg", fileCompanyMsg);
        params.put("userOrgList", (ArrayList<Object>)this.parentParams.get("orgIds"));
        params.put("excelOrgTreeId", (ArrayList<Object>)this.parentParams.get("excelOrgTreeId"));
        ArrayList reportList = new ArrayList();
        ArrayList positionList = new ArrayList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                result = helper.output((File)list.get(i), params);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
            if (result.get("excelErrorMsg") == null) {
                this.fill_tblFileList(true, i, result);
                Object[] companyArray = new Object[]{result.get("excelCompanyNum"), result.get("excelYear"), result.get("excelUnitName")};
                fileCompanyMsg.add(companyArray);
                continue;
            }
            this.fill_tblFileList(false, i, result);
        }
        this.lblHint.setText(DispensePropertyHelperForItemDataInit.getString("Dispense_Import_Finish_Caption", null));
    }

    private boolean hasSamFile() {
        return false;
    }

    private void fill_tblFileList(boolean isOk, int i, Map result) {
        this.tblFileList.getCell(i, "companyNumber").setValue(result.get("excelCompanyNum"));
        if (result.get("excelUnitName") != null) {
            this.tblFileList.getCell(i, "companyName").setValue(result.get("excelUnitName"));
        } else {
            this.tblFileList.getCell(i, "companyName").setValue(result.get("excelCompanyName"));
        }
        this.tblFileList.getCell(i, "year").setValue(result.get("excelYear"));
        if (isOk) {
            this.tblFileList.getRow(i).getStyleAttributes().setBackground(Color.WHITE);
            this.tblFileList.getCell(i, "result").setValue((Object)DispensePropertyHelperForItemDataInit.getString("xlsSuccess", null));
        } else {
            this.tblFileList.getCell(i, "result").setValue((Object)DispensePropertyHelperForItemDataInit.getString("importXlsFailed", null));
            this.tblFileList.getCell(i, "result").getStyleAttributes().setLocked(false);
            ICell resultCell = this.tblFileList.getCell(i, "result");
            resultCell.getStyleAttributes().setUnderline(true);
            resultCell.getStyleAttributes().setFontColor(Color.blue);
            resultCell.setUserObject((Object)result.get("excelErrorMsg").toString());
        }
    }

    private ItemDataImportWizard getMyWizard() {
        return (ItemDataImportWizard)super.getWizard();
    }

    public ArrayList getFilesVerified() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.filesList.size(); ++i) {
            if (!Boolean.TRUE.equals(this.tblFileList.getCell(i, "select").getValue())) continue;
            list.add(this.filesList.get(i));
        }
        return list;
    }
}

