/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractItemDataImportWizardUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataImportWizard;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataImportWizardPage1UI;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataImportWizardPage2UI;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataImportWizardPage3UI;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataYearInitCslRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLIOUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.DispensePropertyHelperForItemDataInit;
import com.kingdee.eas.fi.newrpt.NewRptConstant;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.client.ItemDataYearInitUI;
import com.kingdee.eas.framework.client.wizard.IWizard;
import com.kingdee.eas.framework.client.wizard.IWizardPage;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.stefan.snrpc.util.StringUtil;

public class ItemDataImportWizardUI
extends AbstractItemDataImportWizardUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemDataImportWizardUI.class);
    private String exportTemplePath = "com/kingdee/eas/fi/gr/cslrpt/yearinit/ImportTemplate.xls";

    public ItemDataImportWizardUI() throws Exception {
        this.btnFinish.setEnabled(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setWizard((IWizard)new ItemDataImportWizard(this.getUIContext().get("UIParams")));
        this.btnFinish.setEnabled(false);
        this.btnHelp.setVisible(false);
    }

    private ItemDataImportWizard getMyWizard() {
        return (ItemDataImportWizard)super.getWizard();
    }

    protected void btnBack_actionPerformed(ActionEvent e) throws Exception {
        super.btnBack_actionPerformed(e);
        this.btnFinish.setEnabled(false);
    }

    protected void btnNext_actionPerformed(ActionEvent e) throws Exception {
        ItemDataImportWizard wizard = (ItemDataImportWizard)this.getWizard();
        if (this.getCurrentPage() instanceof ItemDataImportWizardPage1UI) {
            String filename = ((ItemDataImportWizardPage1UI)this.getCurrentPage()).getFilename();
            File file = new File(filename);
            if (!file.exists()) {
                MsgBox.showError((String)DispensePropertyHelperForItemDataInit.getString("Dispense_Import_Error_SelectAvailableFile"));
                return;
            }
            wizard.setFilesLocation(file);
            super.btnNext_actionPerformed(e);
            this.btnNext.setEnabled(false);
        }
    }

    protected void btnFinish_actionPerformed(ActionEvent e) throws Exception {
        if (this.getCurrentPage() instanceof ItemDataImportWizardPage2UI) {
            ItemDataImportWizard wizard = this.getMyWizard();
            ArrayList filesToImport = ((ItemDataImportWizardPage2UI)this.getCurrentPage()).getFilesToImport();
            if (!filesToImport.isEmpty()) {
                for (int i = 0; i < filesToImport.size(); ++i) {
                    File file;
                    Object obj = filesToImport.get(i);
                    if (!(obj instanceof File) || (file = (File)obj).exists()) continue;
                    MsgBox.showError((String)(file.getName() + " " + DispensePropertyHelperForItemDataInit.getString("downtemplate.has.not.file")));
                    return;
                }
            } else {
                MsgBox.showError((String)DispensePropertyHelperForItemDataInit.getString("Dispense_Import_Error_SelectFile"));
                return;
            }
            wizard.setFilesToImport(filesToImport);
            IWizard wizard2 = this.getWizard();
            IWizardPage[] pages = wizard2.getPages();
            int index = wizard2.getPageCount() - 1;
            this.showPage(pages[index]);
            this.btnCancel.setEnabled(false);
            this.btnBack.setEnabled(false);
            this.btnFinish.setText(DispensePropertyHelperForItemDataInit.getString("Dispense_Button_Close_Text"));
        } else if (this.getCurrentPage() instanceof ItemDataImportWizardPage3UI) {
            this.destroyWindow();
            if (this.getUIContext().get("parentUI") instanceof ItemDataYearInitCslRptEditUI) {
                ((ItemDataYearInitCslRptEditUI)this.getUIContext().get("parentUI")).actionRefresh_actionPerformed(null);
            } else if (this.getUIContext().get("parentUI") instanceof ItemDataYearInitUI) {
                ((ItemDataYearInitUI)this.getUIContext().get("parentUI")).actionRefresh_actionPerformed(null);
            }
        }
    }

    @Override
    protected void exportTemplate_actionPerformed(ActionEvent e) throws Exception {
        File file;
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(DispensePropertyHelperForItemDataInit.getString("exportTemplate"));
        FileFilter excelFileFilter = CSLIOUtils.getExcelFileFilter();
        fc.addChoosableFileFilter(excelFileFilter);
        fc.setFileFilter(excelFileFilter);
        if (fc.showSaveDialog((Component)((Object)this)) == 0 && (file = fc.getSelectedFile()) != null) {
            String extType = "";
            String path = file.getAbsolutePath();
            FileFilter ext = fc.getFileFilter();
            if (ext.getDescription().indexOf(".xls") > -1) {
                extType = ".xls";
            }
            if (extType != null && !ext.accept(file)) {
                path = path + extType;
            }
            if ((file = new File(path)).isFile()) {
                if (MsgBox.showConfirm2((Component)((Object)this), (String)RptResourceHelper.getString((String)"file-overwrite-confirm")) != 0) {
                    return;
                }
                file.delete();
            }
            if (StringUtil.isEmpty((String)extType)) {
                MsgBox.showInfo((String)DispensePropertyHelperForItemDataInit.getString("onlyXls"));
            }
            KDSBook kdsbook = this.traslateKDSBookFromXls(this.exportTemplePath);
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
            em.setExporterParmeter(ExporterParameter.PAGE_SIZE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
            try {
                em.exportToExcel(kdsbook, path);
            }
            catch (RuntimeException error) {
                StringBuffer errorMsg = new StringBuffer();
                if (error.getCause() != null) {
                    errorMsg.append(error.getCause().getMessage());
                }
                errorMsg.append(error.getMessage());
                MsgBox.showDetailAndOK((Component)((Object)this), (String)DispensePropertyHelperForItemDataInit.getString("exportTemplateError"), (String)errorMsg.toString(), (int)0);
                SysUtil.abort();
            }
            MsgBox.showInfo((String)DispensePropertyHelperForItemDataInit.getString("exportSuccess"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KDSBook traslateKDSBookFromXls(String fileName) {
        KDSBook kdsbook = null;
        boolean isSuccess = true;
        fileName = "/" + fileName;
        InputStream stream = null;
        try {
            stream = NewRptConstant.class.getResourceAsStream(fileName);
            if (stream == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"284_NoExistStandardTemp"));
                isSuccess = false;
            }
            kdsbook = POIXlsReader.parse((InputStream)stream);
        }
        catch (Exception e) {
            logger.info((Object)"no file path");
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"285_ErrorStardandTemp"));
            isSuccess = false;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"stream.close()_error", (Throwable)e);
                }
            }
        }
        if (kdsbook == null || !isSuccess) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"285_ErrorStardandTemp"));
            SysUtil.abort();
        }
        return kdsbook;
    }
}

