/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTVertical;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderException;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.TablePreferHelperYearInit;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractItemDataYearInitBaseEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.designer.ItemDataYearInitTableSorter;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ItemDataYearInitBaseEditUI
extends AbstractItemDataYearInitBaseEditUI
implements ICSLContextUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemDataYearInitBaseEditUI.class);
    protected EntityViewInfo entityViewInfo = new EntityViewInfo();
    protected String COL_ID = "id";
    protected String COL_SELECT = "select";
    protected String COL_ITEM_NUMBER = "number";
    protected String COL_ITEM_NAME = "name";
    protected String COL_CURRENCY_NAME = "currency.name";
    protected String COL_CURRENCY_NUMBER = "currency.number";
    protected String COL_SOURCECURRENCY_NAME = "sourceCurrency.name";
    protected String COL_SOURCECURRENCY_NUMBER = "sourceCurrency.number";
    protected String COL_YEAR = "year";
    protected String COL_PERIOD = "period";
    protected String COL_DEBITFORMULA = "debit";
    protected String COL_CREDITFORMULA = "credit";
    protected String COL_VALUETYPE = "valueType";
    protected String COL_DATAELEMENT = "dataElement";
    protected String COL_CONVERTSTATUS = "convertStatus";
    protected Integer STATUS_ADDNEW = new Integer(1);
    protected Integer STATUS_DELETE = new Integer(2);
    protected Integer STATUS_UPDATE = new Integer(3);
    protected OrgTreeInfo curOrgBound = null;
    protected OrgUnitInfo orgUnit = null;
    protected Integer curYear = null;
    protected CurrencyInfo currency = null;
    protected CurrencyInfo sourceCurrency = null;
    protected ReportClassInfo reportClass = null;
    protected ValueTypeEnum valueType = null;
    protected DataElementInfo dataElement = null;
    protected Integer period = null;
    protected ItemDataYearInitTableSorter tableSorter;
    private IObjectCollection cacheDataCollection = null;
    private List deleteIdList = new ArrayList();
    private HashMap changedInfosMap = new HashMap();
    protected DataCollectInfo dataCollectInfo;
    KDBizPromptBox bizBoxItem = null;
    protected boolean isCslRpt = true;

    public ItemDataYearInitBaseEditUI() throws Exception {
        this.initWorkButton();
    }

    private ItemDataYearInitInfo createNewInfo() {
        ItemDataYearInitInfo info = new ItemDataYearInitInfo();
        if (this.kDPmt_OrgUnit.getData() != null && this.kDPmt_OrgUnit.getData() instanceof OrgUnitInfo) {
            info.setOrgUnit(((OrgUnitInfo)this.kDPmt_OrgUnit.getData()).castToFullOrgUnitInfo());
            info.setOrgUnitNumber(info.getOrgUnit().getNumber());
        }
        info.setOrgTree(this.curOrgBound);
        info.setOrgTreeNumber(info.getOrgTree().getNumber());
        return info;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_save"));
        this.actionRefresh.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_refresh"));
        this.actionAddRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionDelRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionAddBatch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_newbatch"));
    }

    protected void initHelper() {
        if (this.tHelper != null) {
            return;
        }
        this.tHelperPrint = this.tHelper = new TablePreferHelperYearInit(this);
    }

    public void onLoad() throws Exception {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            CSLContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.initialHead();
        this.storeHeadData();
        if (this.orgUnit != null) {
            this.loadData();
        }
        this.kDPmt_OrgUnit.setRequired(true);
        this.tableSorter = new ItemDataYearInitTableSorter(this.kDTMain){

            protected void afterSort() {
                super.afterSort();
                for (int i = 0; i < ItemDataYearInitBaseEditUI.this.kDTMain.getRowCount(); ++i) {
                    IRow row = ItemDataYearInitBaseEditUI.this.kDTMain.getRow(i);
                    Object obj = row.getCell(ItemDataYearInitBaseEditUI.this.COL_ITEM_NUMBER).getValue();
                    if (obj == null || !(obj instanceof RPTItemInfo)) continue;
                    ItemDataYearInitBaseEditUI.this.setColor(row, ((RPTItemInfo)obj).getDc());
                }
            }
        };
        this.kDTMain.getColumn(this.COL_DATAELEMENT).getStyleAttributes().setLocked(true);
        this.kDTMain.getColumn("dataCollect").getStyleAttributes().setLocked(true);
        this.dataCollectInfo = CSLContextHelper.getCSLContext().getCurDataCollect();
        Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
        if ("true".equals(isSupportOtherDS)) {
            this.kDTMain.getColumn("dataCollect").getStyleAttributes().setHided(false);
        } else {
            this.kDTMain.getColumn("dataCollect").getStyleAttributes().setHided(true);
        }
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void loadData() throws BOSException, Exception {
        this.deleteIdList.clear();
        this.cacheDataCollection = this.getBizInterface().getCollection(this.getEntityViewInfo());
        for (ItemDataYearInitInfo element : this.cacheDataCollection) {
            this.deleteIdList.add(element.getId());
        }
    }

    private void saveData() throws BOSException, Exception {
        ItemDataYearInitFactory.getRemoteInstance().saveData(this.changedInfosMap);
    }

    private void storeHeadData() throws BOSException {
        this.orgUnit = (OrgUnitInfo)this.kDPmt_OrgUnit.getValue();
        this.curYear = (Integer)this.kDSp_Year.getValue();
        this.currency = (CurrencyInfo)this.kDPmt_Currency.getValue();
        this.sourceCurrency = (CurrencyInfo)this.kDPmt_SourceCurrency.getValue();
        if (this.kDCmb_ItemClass.getSelectedItem() instanceof ReportClassInfo) {
            this.reportClass = (ReportClassInfo)this.kDCmb_ItemClass.getSelectedItem();
        }
        this.valueType = (ValueTypeEnum)((Object)this.kDComb_ValueType.getSelectedItem());
        this.dataElement = (DataElementInfo)this.cmbDataElement.getSelectedItem();
        this.period = new Integer(CSLContextHelper.getCSLContext().getCurRptPeriod());
    }

    private void initialHead() throws Exception, BOSException {
        this.kDTMain.checkParsed();
        this.initReportClassData();
        this.setOrgUnitF7();
        this.curOrgBound = CSLContextHelper.getCSLContext().getCurOrgBound();
        this.kDSp_Year.setValue((Object)new Integer(CSLContextHelper.getCSLContext().getCurRptYear()));
        this.kDSp_Year.setUserObject(this.kDSp_Year.getValue());
        String numberFmt = FMClientHelper.getNumberFtm((int)2);
        if (this.kDTMain.getColumn("debit") != null) {
            this.kDTMain.getColumn("debit").getStyleAttributes().setNumberFormat(numberFmt);
        }
        if (this.kDTMain.getColumn("credit") != null) {
            this.kDTMain.getColumn("credit").getStyleAttributes().setNumberFormat(numberFmt);
        }
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setSupportedEmpty(true);
        formatField.setPrecision(6);
        KDTDefaultCellEditor dcEditor = new KDTDefaultCellEditor((JTextField)formatField);
        this.kDTMain.getColumn(this.COL_DEBITFORMULA).setEditor((ICellEditor)dcEditor);
        this.kDTMain.getColumn(this.COL_CREDITFORMULA).setEditor((ICellEditor)dcEditor);
        this.addControlListener();
        this.initEntryTable();
        this.initDataElement();
    }

    private void initDataElement() {
        this.cmbDataElement.addItem((Object)DataElementProvider.getDataElementInfo("YTBEGIN"));
        this.cmbDataElement.addItem((Object)DataElementProvider.getDataElementInfo("YTDAMOUNT"));
        this.cmbDataElement.setSelectedIndex(0);
    }

    @Override
    protected void cmbDataElement_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbDataElement_itemStateChanged(e);
        this.kDTMain.checkParsed();
        if (((DataElementInfo)e.getItem()).getNumber().equals("YTDAMOUNT")) {
            this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setHided(false);
            for (int i = 0; i < this.kDTMain.getRowCount(); ++i) {
                this.kDTMain.getRow(i).getCell(this.COL_PERIOD).setValue((Object)new Integer(CSLContextHelper.getCSLContext().getCurRptPeriod()));
                this.kDTMain.getRow(i).getCell(this.COL_DATAELEMENT).setValue(this.cmbDataElement.getSelectedItem());
            }
            this.actionRefresh_actionPerformed(null);
        } else {
            this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setHided(true);
            for (int i = 0; i < this.kDTMain.getRowCount(); ++i) {
                this.kDTMain.getRow(i).getCell(this.COL_DATAELEMENT).setValue(this.cmbDataElement.getSelectedItem());
            }
            this.actionRefresh_actionPerformed(null);
        }
    }

    private void initReportClassData() throws Exception {
        CoreBaseCollection reportClassCL = ReportClassFactory.getRemoteInstance().getCollection();
        this.kDCmb_ItemClass.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg.all"));
        if (reportClassCL != null && reportClassCL.size() > 0) {
            int j = reportClassCL.size();
            for (int i = 0; i < j; ++i) {
                this.kDCmb_ItemClass.addItem((Object)reportClassCL.getObject(i));
            }
        }
    }

    protected void orgUnitDataChange(DataChangeEvent e) {
        if (e.getNewValue() != e.getOldValue()) {
            try {
                this.actionRefresh_actionPerformed(null);
                if (this.isRptYearInit() && this.kDPmt_OrgUnit.getData() != null) {
                    CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizBoxItem, (String)((OrgUnitInfo)this.kDPmt_OrgUnit.getData()).getId().toString());
                }
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    private void addControlListener() {
        this.kDTMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int first = e.getFirstRow();
                int count = e.getLastRow() - e.getFirstRow() + 1;
                Object tmp = null;
                for (int i = first; i < first + count; ++i) {
                    IRow row = ItemDataYearInitBaseEditUI.this.kDTMain.getRow(i);
                    tmp = row.getCell(ItemDataYearInitBaseEditUI.this.COL_ITEM_NUMBER).getValue();
                    if (tmp == null || !(tmp instanceof RPTItemInfo)) continue;
                    ItemDataYearInitBaseEditUI.this.setColor(row, ((RPTItemInfo)tmp).getDc());
                }
            }
        });
        this.kDSp_Year.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ItemDataYearInitBaseEditUI.this.storeToFields();
                    if (ItemDataYearInitBaseEditUI.this.changedInfosMap.size() != 0) {
                        int status = MsgBox.showConfirm3((String)(CslRptUtil.getString("YearInitHintBeforeSave") + CslRptUtil.getString("_changeYear")));
                        if (status == 0) {
                            ItemDataYearInitBaseEditUI.this.actionSave_actionPerformed(null);
                        } else if (status != 1) {
                            ItemDataYearInitBaseEditUI.this.kDSp_Year.setValue(ItemDataYearInitBaseEditUI.this.kDSp_Year.getUserObject(), false);
                            return;
                        }
                    }
                    ItemDataYearInitBaseEditUI.this.kDSp_Year.setUserObject(ItemDataYearInitBaseEditUI.this.kDSp_Year.getValue());
                    ItemDataYearInitBaseEditUI.this.actionRefresh_actionPerformed(null);
                }
                catch (Exception e1) {
                    if (e1 instanceof AbortException) {
                        ItemDataYearInitBaseEditUI.this.kDSp_Year.setValue(ItemDataYearInitBaseEditUI.this.kDSp_Year.getUserObject(), false);
                    }
                    ItemDataYearInitBaseEditUI.this.handUIException(e1);
                }
            }
        });
        this.kDPmt_OrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                ItemDataYearInitBaseEditUI.this.preChangeForComp(e, "org");
            }
        });
        this.kDPmt_OrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                ItemDataYearInitBaseEditUI.this.orgUnitDataChange(e);
            }
        });
        this.kDPmt_Currency.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                ItemDataYearInitBaseEditUI.this.preChangeForComp(e, "currency");
            }
        });
        this.kDPmt_Currency.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() != e.getOldValue()) {
                    try {
                        ItemDataYearInitBaseEditUI.this.actionRefresh_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        ItemDataYearInitBaseEditUI.this.handUIException(e1);
                    }
                }
            }
        });
        this.kDPmt_SourceCurrency.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                ItemDataYearInitBaseEditUI.this.preChangeForComp(e, "srcCurrency");
            }
        });
        this.kDPmt_SourceCurrency.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() != e.getOldValue()) {
                    try {
                        ItemDataYearInitBaseEditUI.this.actionRefresh_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        ItemDataYearInitBaseEditUI.this.handUIException(e1);
                    }
                }
            }
        });
        this.kDCmb_ItemClass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        ItemDataYearInitBaseEditUI.this.actionRefresh_actionPerformed(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.kDComb_ValueType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    ItemDataYearInitBaseEditUI.this.actionRefresh_actionPerformed(null);
                }
                catch (Exception e1) {
                    ItemDataYearInitBaseEditUI.this.handUIException(e1);
                }
            }
        });
    }

    private void preChangeForComp(PreChangeEvent e, String compName) {
        try {
            this.storeToFields();
            if (this.changedInfosMap.size() != 0) {
                String tailInfo = "";
                switch (compName) {
                    case "org": {
                        tailInfo = CslRptUtil.getString("_changeOrg");
                        break;
                    }
                    case "currency": {
                        tailInfo = CslRptUtil.getString("_changeCurrency");
                        break;
                    }
                    case "srcCurrency": {
                        tailInfo = CslRptUtil.getString("_changeSrcCurrency");
                        break;
                    }
                    default: {
                        tailInfo = "";
                    }
                }
                int status = MsgBox.showConfirm3((String)(CslRptUtil.getString("YearInitHintBeforeSave") + tailInfo));
                if (status == 0) {
                    this.actionSave_actionPerformed(null);
                } else if (status != 1) {
                    e.setResult(0);
                }
            }
        }
        catch (Exception e1) {
            if (e1 instanceof AbortException) {
                e.setResult(0);
            }
            this.handUIException(e1);
        }
    }

    public boolean isModify(AbstractObjectValue oldData, AbstractObjectValue editData) {
        return !ObjectValueUtil.objectValueEquals((AbstractObjectValue)oldData, (AbstractObjectValue)editData);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.kDPmt_OrgUnit.getData() == null) {
            MsgBox.showInfo((String)CslRptUtil.getString("YearInitSelectOrgFirst"));
            SysUtil.abort();
        }
        StringBuilder saveFailInfoSb = new StringBuilder();
        if (this.kDTMain != null && this.kDTMain.getRowCount() > 0) {
            boolean isRowSaveFail = false;
            int j = this.kDTMain.getRowCount();
            for (int i = 0; i < j; ++i) {
                IRow curRow;
                if (isRowSaveFail) {
                    saveFailInfoSb.append("\n");
                    isRowSaveFail = false;
                }
                if ((curRow = this.kDTMain.getRow(i)).getCell(this.COL_ITEM_NUMBER).getValue() == null) {
                    isRowSaveFail = true;
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Item_Blank2"));
                }
                if (curRow.getCell(this.COL_CURRENCY_NAME).getValue() == null) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CURRENCY_CANNOT_EMPTY2"));
                }
                if (curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue() == null) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SOURCECURRENCY_CANNOT_EMPTY2"));
                }
                if (curRow.getCell(this.COL_VALUETYPE).getValue() == null) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"VALUETYPE_CANNOT_EMPTY"));
                }
                if (curRow.getCell(this.COL_DATAELEMENT).getValue() == null) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DATAELEMENT_CANNOT_EMPTY"));
                }
                if (curRow.getCell(this.COL_CONVERTSTATUS).getValue().equals((Object)ConvertStatusEnum.Converted) && curRow.getCell(this.COL_CURRENCY_NAME).getValue() != null && curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue() != null && ((CurrencyInfo)curRow.getCell(this.COL_CURRENCY_NAME).getValue()).getNumber().equals(((CurrencyInfo)curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue()).getNumber())) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"YearInitSameCurrencyAfterConvert"));
                }
                if (curRow.getCell(this.COL_CONVERTSTATUS).getValue().equals((Object)ConvertStatusEnum.BeforeConvert) && curRow.getCell(this.COL_CURRENCY_NAME).getValue() != null && curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue() != null && !((CurrencyInfo)curRow.getCell(this.COL_CURRENCY_NAME).getValue()).getNumber().equals(((CurrencyInfo)curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue()).getNumber())) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"YearInitDifCurrencyBeforeConvert"));
                }
                Object debitFormula = curRow.getCell(this.COL_DEBITFORMULA).getValue();
                Object creditFormula = curRow.getCell(this.COL_CREDITFORMULA).getValue();
                if (debitFormula != null && creditFormula != null && !StringUtils.isEmpty((String)debitFormula.toString()) && ((BigDecimal)debitFormula).compareTo(new BigDecimal("0")) != 0 && !StringUtils.isEmpty((String)creditFormula.toString()) && ((BigDecimal)creditFormula).compareTo(new BigDecimal("0")) != 0) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(CslRptUtil.getString("YearInitMutexCreditAndDebit"));
                }
                if (!isRowSaveFail || saveFailInfoSb.substring(saveFailInfoSb.length() - 1).toString().equals("\uff01") || saveFailInfoSb.substring(saveFailInfoSb.length() - 1).toString().equals("!")) continue;
                saveFailInfoSb.append("\uff01");
            }
            if (saveFailInfoSb.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"saveFail"), (String)saveFailInfoSb.toString(), (int)2);
                SysUtil.abort();
            }
        }
    }

    public void loadFromFields() throws BOSException {
        super.loadFields();
        if (this.cacheDataCollection != null && this.cacheDataCollection.size() > 0) {
            int j = this.cacheDataCollection.size();
            for (int i = 0; i < j; ++i) {
                ItemDataYearInitInfo dataInfo = (ItemDataYearInitInfo)this.cacheDataCollection.getObject(i);
                IRow curRow = this.kDTMain.addRow();
                this.setPrecision(curRow.getRowIndex(), dataInfo.getCurrency());
                curRow.getCell(this.COL_ID).setValue((Object)dataInfo.getId().toString());
                curRow.getCell(this.COL_ITEM_NUMBER).setValue((Object)dataInfo.getItem());
                curRow.getCell(this.COL_ITEM_NAME).setValue((Object)dataInfo.getItem().getName());
                this.setColor(curRow, dataInfo.getItem().getDc());
                curRow.getCell(this.COL_CURRENCY_NAME).setValue((Object)dataInfo.getCurrency());
                curRow.getCell(this.COL_CURRENCY_NUMBER).setValue((Object)dataInfo.getCurrency().getNumber());
                curRow.getCell(this.COL_SOURCECURRENCY_NAME).setValue((Object)dataInfo.getSourceCurrency());
                curRow.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue((Object)dataInfo.getSourceCurrency().getNumber());
                curRow.getCell(this.COL_YEAR).setValue((Object)new Integer(dataInfo.getYear()));
                curRow.getCell(this.COL_DEBITFORMULA).setValue((Object)dataInfo.getDebit());
                curRow.getCell(this.COL_CREDITFORMULA).setValue((Object)dataInfo.getCredit());
                curRow.getCell(this.COL_VALUETYPE).setValue((Object)dataInfo.getValueType());
                if (4 == dataInfo.getDataElement()) {
                    curRow.getCell(this.COL_SELECT).getStyleAttributes().setLocked(false);
                } else {
                    curRow.getCell(this.COL_SELECT).getStyleAttributes().setLocked(true);
                }
                curRow.getCell(this.COL_DATAELEMENT).setValue((Object)DataElementProvider.getDataElementInfo(dataInfo.getDataElement()));
                curRow.getCell(this.COL_CONVERTSTATUS).setValue((Object)dataInfo.getConvertStatus());
                curRow.getCell(this.COL_PERIOD).setValue((Object)new Integer(dataInfo.getPeriod()));
                curRow.getCell("dataCollect").setValue((Object)dataInfo.getDataCollect().getName());
            }
        }
    }

    public void storeToFields() {
        this.changedInfosMap.clear();
        if (this.deleteIdList.isEmpty() && this.cacheDataCollection != null) {
            for (ItemDataYearInitInfo element : this.cacheDataCollection) {
                this.deleteIdList.add(element.getId());
            }
        }
        if (this.kDTMain != null && this.kDTMain.getRowCount() > 0) {
            ItemDataYearInitInfo dataInfo = null;
            int j = this.kDTMain.getRowCount();
            for (int i = 0; i < j; ++i) {
                IRow curRow = this.kDTMain.getRow(i);
                if (curRow.getCell(this.COL_SELECT).getValue() != null) continue;
                Object obj = curRow.getCell("id").getValue();
                dataInfo = obj != null ? (ItemDataYearInitInfo)((ItemDataYearInitInfo)this.cacheDataCollection.getObject((Object)BOSUuid.read((String)((String)obj)))).clone() : this.createNewInfo();
                dataInfo.setItem((RPTItemInfo)curRow.getCell("number").getValue());
                dataInfo.setCurrency((CurrencyInfo)curRow.getCell("currency.name").getValue());
                dataInfo.setSourceCurrency((CurrencyInfo)curRow.getCell("sourceCurrency.name").getValue());
                dataInfo.setYear((Integer)curRow.getCell("year").getValue());
                BigDecimal debit = null;
                if (curRow.getCell("debit").getValue() instanceof BigDecimal) {
                    debit = (BigDecimal)curRow.getCell("debit").getValue();
                } else if (curRow.getCell("debit").getValue() != null) {
                    debit = new BigDecimal(curRow.getCell("debit").getValue().toString());
                }
                dataInfo.setDebit(debit);
                BigDecimal credit = null;
                if (curRow.getCell("credit").getValue() instanceof BigDecimal) {
                    credit = (BigDecimal)curRow.getCell("credit").getValue();
                } else if (curRow.getCell("credit").getValue() != null) {
                    credit = new BigDecimal(curRow.getCell("credit").getValue().toString());
                }
                dataInfo.setCredit(credit);
                dataInfo.setValueType((ValueTypeEnum)((Object)curRow.getCell("valueType").getValue()));
                dataInfo.setDataElement(((DataElementInfo)curRow.getCell("dataElement").getValue()).getInterSeq());
                dataInfo.setConvertStatus((ConvertStatusEnum)((Object)curRow.getCell(this.COL_CONVERTSTATUS).getValue()));
                dataInfo.setDataCollect(this.dataCollectInfo);
                dataInfo.setDataCollectNumber(this.dataCollectInfo.getNumber());
                if (curRow.getCell(this.COL_PERIOD) != null && curRow.getCell(this.COL_PERIOD).getValue() != null) {
                    dataInfo.setPeriod((Integer)curRow.getCell(this.COL_PERIOD).getValue());
                }
                if (obj == null) {
                    this.changedInfosMap.put(dataInfo, this.STATUS_ADDNEW);
                    continue;
                }
                this.deleteIdList.remove(dataInfo.getId());
                if (!this.isModify((AbstractObjectValue)dataInfo, (AbstractObjectValue)this.cacheDataCollection.getObject((Object)BOSUuid.read((String)((String)obj))))) continue;
                this.changedInfosMap.put(dataInfo, this.STATUS_UPDATE);
            }
        }
        for (BOSUuid element : this.deleteIdList) {
            this.changedInfosMap.put(this.cacheDataCollection.getObject((Object)element), this.STATUS_DELETE);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ItemDataYearInitFactory.getRemoteInstance();
    }

    @Override
    public void actionAddBatch_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.actionAddBatch_actionPerformed(e);
        if (this.isRptYearInit() && this.kDPmt_OrgUnit.getData() == null) {
            MsgBox.showInfo((String)CslRptUtil.getString("YearInitSelectOrgFirst"));
            SysUtil.abort();
        }
        CurrencyInfo currency = (CurrencyInfo)this.kDPmt_Currency.getData();
        CurrencyInfo sourceCurrency = (CurrencyInfo)this.kDPmt_SourceCurrency.getData();
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        bizBoxItem.setVisible(false);
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        if (this.reportClass instanceof ReportClassInfo && this.kDCmb_ItemClass.getSelectedIndex() != 0) {
            ReportClassInfo reportClass = (ReportClassInfo)this.kDCmb_ItemClass.getSelectedItem();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("reportClass.id", (Object)reportClass.getId().toString()));
            viewInfo.setFilter(filter);
            bizBoxItem.setEntityViewInfo(viewInfo);
        }
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)bizBoxItem, this.isRptYearInit() ? ((OrgUnitInfo)this.kDPmt_OrgUnit.getData()).getId().toString() : null);
        bizBoxItem.setEnabledMultiSelection(true);
        bizBoxItem.setDataBySelector();
        if (bizBoxItem.getData() == null) {
            SysUtil.abort();
        }
        Object[] rptItemArray = (Object[])bizBoxItem.getData();
        ArrayList<Object> l = new ArrayList<Object>(rptItemArray.length);
        for (i = 0; i < rptItemArray.length; ++i) {
            if (rptItemArray[i] == null) {
                SysUtil.abort();
            }
            l.add(rptItemArray[i]);
        }
        Collections.sort(l);
        for (i = 0; i < l.size(); ++i) {
            RPTItemInfo element = (RPTItemInfo)l.get(i);
            IRow iRow = this.kDTMain.addRow();
            iRow.getCell(this.COL_SELECT).getStyleAttributes().setLocked(true);
            iRow.getCell(this.COL_ITEM_NUMBER).setValue((Object)element);
            iRow.getCell(this.COL_ITEM_NAME).setValue((Object)element.getName());
            this.setColor(iRow, element.getDc());
            if (currency != null) {
                iRow.getCell(this.COL_CURRENCY_NAME).setValue((Object)currency);
                iRow.getCell(this.COL_CURRENCY_NUMBER).setValue((Object)currency.getName());
            }
            if (sourceCurrency != null) {
                iRow.getCell(this.COL_SOURCECURRENCY_NAME).setValue((Object)sourceCurrency);
                iRow.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue((Object)sourceCurrency.getName());
            }
            iRow.getCell(this.COL_YEAR).setValue((Object)this.curYear);
            iRow.getCell(this.COL_VALUETYPE).setValue((Object)this.valueType);
            iRow.getCell(this.COL_DATAELEMENT).setValue((Object)((DataElementInfo)this.cmbDataElement.getSelectedItem()));
            if (currency != null && sourceCurrency != null) {
                if (currency.getNumber().equals(sourceCurrency.getNumber())) {
                    iRow.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
                } else {
                    iRow.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
                }
            } else {
                iRow.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
            }
            DataElementInfo info = (DataElementInfo)this.cmbDataElement.getSelectedItem();
            if (info.getNumber().equals("YTDAMOUNT")) {
                this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setHided(false);
                iRow.getCell(this.COL_PERIOD).setValue((Object)new Integer(CSLContextHelper.getCSLContext().getCurRptPeriod()));
            } else if (info.getNumber().equals("YTBEGIN")) {
                this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setHided(true);
            }
            String dataCollect = this.dataCollectInfo.getNumber();
            if (dataCollect.equals("ACTUALDATA")) {
                dataCollect = DataCollectConstant.getActualDC().getName(SysContext.getSysContext().getLocale());
            } else if (dataCollect.equals("BUDGETDATA")) {
                dataCollect = DataCollectConstant.getBudgetDC().getName(SysContext.getSysContext().getLocale());
            }
            iRow.getCell("dataCollect").setValue((Object)dataCollect);
        }
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddRow_actionPerformed(e);
        if (this.isRptYearInit()) {
            if (this.kDPmt_OrgUnit.getData() == null) {
                MsgBox.showInfo((String)CslRptUtil.getString("YearInitSelectOrgFirst"));
                SysUtil.abort();
            }
            CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizBoxItem, (String)((OrgUnitInfo)this.kDPmt_OrgUnit.getData()).getId().toString());
        }
        IRow iRow = this.kDTMain.addRow();
        iRow.getCell(this.COL_SELECT).getStyleAttributes().setLocked(true);
        iRow.getCell(this.COL_YEAR).setValue((Object)this.curYear);
        iRow.getCell(this.COL_VALUETYPE).setValue((Object)this.valueType);
        iRow.getCell(this.COL_DATAELEMENT).setValue((Object)((DataElementInfo)this.cmbDataElement.getSelectedItem()));
        String dataCollect = this.dataCollectInfo.getNumber();
        if (dataCollect.equals("ACTUALDATA")) {
            dataCollect = DataCollectConstant.getActualDC().getName(SysContext.getSysContext().getLocale());
        } else if (dataCollect.equals("BUDGETDATA")) {
            dataCollect = DataCollectConstant.getBudgetDC().getName(SysContext.getSysContext().getLocale());
        }
        iRow.getCell("dataCollect").setValue((Object)dataCollect);
        this.kDTMain.checkParsed();
        if (((DataElementInfo)this.cmbDataElement.getSelectedItem()).getNumber().equals("YTDAMOUNT")) {
            this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setHided(false);
            for (int i = 0; i < this.kDTMain.getRowCount(); ++i) {
                this.kDTMain.getRow(i).getCell(this.COL_PERIOD).setValue((Object)new Integer(CSLContextHelper.getCSLContext().getCurRptPeriod()));
                this.kDTMain.getRow(i).getCell(this.COL_DATAELEMENT).setValue(this.cmbDataElement.getSelectedItem());
            }
        } else {
            this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setHided(true);
        }
        CurrencyInfo currency = (CurrencyInfo)this.kDPmt_Currency.getData();
        CurrencyInfo sourceCurrency = (CurrencyInfo)this.kDPmt_SourceCurrency.getData();
        if (currency != null) {
            iRow.getCell(this.COL_CURRENCY_NAME).setValue((Object)currency);
            iRow.getCell(this.COL_CURRENCY_NUMBER).setValue((Object)currency.getName());
        }
        if (sourceCurrency != null) {
            iRow.getCell(this.COL_SOURCECURRENCY_NAME).setValue((Object)sourceCurrency);
            iRow.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue((Object)sourceCurrency.getName());
        }
        if (currency != null && sourceCurrency != null && !currency.getName().equals(sourceCurrency.getName())) {
            iRow.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
        } else {
            iRow.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
        }
        if (this.kDTMain.getRowCount() > 0) {
            int preTableHeght = (int)this.kDTMain.getBounds().getHeight();
            int rowHight = this.kDTMain.getBody().getRowHeight(0);
            if (this.kDTMain.getRowCount() < preTableHeght / rowHight - 2) {
                KDTVertical vertical = this.kDTMain.getLayoutManager().getVertical(1);
                vertical.repaint();
                vertical.scrollToPosition(0);
                this.kDTMain.getSelectManager().select(this.kDTMain.getRowCount() - 1, 0);
            } else {
                KDTVertical vertical = this.kDTMain.getLayoutManager().getVertical(1);
                vertical.repaint();
                vertical.scrollToPosition(this.kDTMain.getRowCount() - (preTableHeght / rowHight - 2));
                this.kDTMain.getSelectManager().select(this.kDTMain.getRowCount() - 1, 0);
            }
        }
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelRow_actionPerformed(e);
        if (this.kDTMain.getSelectManager().size() > 0) {
            this.deleteSelectedRows();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    protected void deleteSelectedRows() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        KDTSelectBlock selectBlock = null;
        int size = this.kDTMain.getSelectManager().size();
        if (size == 0 || this.kDTMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            selectBlock = this.kDTMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                Integer tempIndex = new Integer(j);
                if (list.contains(tempIndex)) continue;
                list.add(tempIndex);
            }
        }
        Object[] index = list.toArray();
        Arrays.sort(index);
        for (int i = index.length; i > 0; --i) {
            this.kDTMain.removeRow(((Integer)index[i - 1]).intValue());
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.kDPmt_OrgUnit.getData() == null) {
            this.setMessageText(CslRptUtil.getString("YearInitSelectOrgFirst"));
            this.showMessage();
            SysUtil.abort();
        }
        if (this.kDSp_Year.getValue() == null || this.kDSp_Year.getIntegerVlaue() < 1900) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("YearInitSelectCorrectYear"));
            SysUtil.abort();
        }
        this.kDTMain.removeRows();
        this.storeHeadData();
        this.loadData();
        this.loadFromFields();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.beforeExit(e);
        super.actionExitCurrent_actionPerformed(e);
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.beforeExit(null);
        }
        catch (Exception e) {
            if (e instanceof AbortException) {
                return false;
            }
            super.handUIException((Throwable)e);
        }
        return super.checkBeforeWindowClosing();
    }

    private void beforeExit(ActionEvent e) throws Exception {
        this.storeToFields();
        if (this.changedInfosMap.size() != 0) {
            int status = MsgBox.showConfirm3((String)(CslRptUtil.getString("YearInitHintBeforeSave") + CslRptUtil.getString("_exit")));
            if (status == 2) {
                SysUtil.abort();
            } else if (status == 0) {
                this.actionSave_actionPerformed(e);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        long startTime = System.currentTimeMillis();
        super.actionSave_actionPerformed(e);
        this.beforeStoreFields(e);
        this.storeToFields();
        this.checkDataRepeat();
        this.saveData();
        this.actionRefresh_actionPerformed(e);
        long counter = System.currentTimeMillis() - startTime;
        BigDecimal time = new BigDecimal(String.valueOf((double)counter / 1000.0)).setScale(2, 4);
        Object[] param = new Object[]{time.toString()};
        super.setMessageText(CslRptUtil.getStringWithFormat("YearInitSaveOK", param));
        super.showMessage();
        this.tableSorter.setOrder(0);
        this.tableSorter.sort("number");
    }

    public void checkDataRepeat() throws ItemDataProviderException {
        HashSet<Integer> rowset = new HashSet<Integer>();
        ArrayList repeatList = new ArrayList();
        ArrayList<Integer> repeatItemRow = null;
        for (int i = 0; i < this.kDTMain.getRowCount() - 1; ++i) {
            if (rowset.contains(i)) continue;
            repeatItemRow = new ArrayList<Integer>();
            for (int j = i + 1; j < this.kDTMain.getRowCount(); ++j) {
                String number = this.kDTMain.getRow(i).getCell("number").getValue().toString();
                String currency = this.kDTMain.getRow(i).getCell("currency.name").getValue().toString();
                String sourceCurrency = this.kDTMain.getRow(i).getCell("sourceCurrency.name").getValue().toString();
                String convertStatus = this.kDTMain.getRow(i).getCell("convertStatus").getValue().toString();
                String valueType = this.kDTMain.getRow(i).getCell("valueType").getValue().toString();
                if (!number.equals(this.kDTMain.getRow(j).getCell("number").getValue().toString()) || !currency.equals(this.kDTMain.getRow(j).getCell("currency.name").getValue().toString()) || !sourceCurrency.equals(this.kDTMain.getRow(j).getCell("sourceCurrency.name").getValue().toString()) || !convertStatus.equals(this.kDTMain.getRow(j).getCell("convertStatus").getValue().toString()) || !valueType.equals(this.kDTMain.getRow(j).getCell("valueType").getValue().toString())) continue;
                if (!repeatItemRow.contains(i + 1)) {
                    repeatItemRow.add(i + 1);
                }
                repeatItemRow.add(j + 1);
                rowset.add(j);
            }
            if (repeatItemRow.size() == 0) continue;
            repeatList.add(repeatItemRow);
        }
        StringBuffer repeatException = new StringBuffer("");
        if (repeatList.size() > 0) {
            for (int i = 0; i < repeatList.size(); ++i) {
                repeatException.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"884_dataRepeat", (Object[])new Object[]{repeatList.get(i).toString()}));
                repeatException.append("\n");
            }
            MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"889_doubleData"), (String)repeatException.toString());
            SysUtil.abort();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    protected EntityViewInfo getEntityViewInfo() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        if (this.isCslRpt) {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgTreeNumber", (Object)this.curOrgBound.getNumber()));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitNumber", (Object)this.orgUnit.getNumber()));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.orgUnit.getId().toString()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("year", (Object)this.curYear));
        String dataCollect = this.dataCollectInfo == null ? CSLContextHelper.getCSLContext().getCurDataCollect().getNumber() : this.dataCollectInfo.getNumber();
        filterInfo.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)dataCollect));
        if (this.kDPmt_Currency.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currency.getId().toString()));
        }
        if (this.kDPmt_SourceCurrency.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)this.sourceCurrency.getId().toString()));
        }
        if (this.kDCmb_ItemClass.getSelectedItem() instanceof ReportClassInfo) {
            filterInfo.getFilterItems().add(new FilterItemInfo("item.reportClass.id", (Object)this.reportClass.getId().toString()));
        }
        if (this.cmbDataElement.getSelectedItem() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("dataElement", (Object)new Integer(this.dataElement.getInterSeq())));
        }
        if (((DataElementInfo)this.cmbDataElement.getSelectedItem()).getInterSeq() == 3 && this.period != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)this.period));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("mergeType", (Object)new Integer(0)));
        this.entityViewInfo.setFilter(filterInfo);
        this.entityViewInfo.getSelector().clear();
        this.entityViewInfo.put("selector", (Object)this.getSelectorItemCollection());
        this.entityViewInfo.getSorter().clear();
        this.entityViewInfo.getSorter().add(new SorterItemInfo("item.number"));
        return this.entityViewInfo;
    }

    protected SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("item.id"));
        sic.add(new SelectorItemInfo("item.number"));
        sic.add(new SelectorItemInfo("item.name"));
        sic.add(new SelectorItemInfo("item.dc"));
        sic.add(new SelectorItemInfo("Item.reportClass.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("debit"));
        sic.add(new SelectorItemInfo("credit"));
        sic.add(new SelectorItemInfo("valueType"));
        sic.add(new SelectorItemInfo("convertStatus"));
        sic.add(new SelectorItemInfo("dataElement"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        return sic;
    }

    protected void setOrgUnitF7() throws Exception {
    }

    private void initEntryTable() throws Exception {
        this.kDTMain.checkParsed();
        KDCheckBox chkSelect = new KDCheckBox();
        chkSelect.setSelected(false);
        KDTDefaultCellEditor selectEditor = new KDTDefaultCellEditor((JCheckBox)chkSelect);
        this.kDTMain.getColumn(this.COL_SELECT).setEditor((ICellEditor)selectEditor);
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setSupportedEmpty(true);
        formatField.setPrecision(5);
        KDTDefaultCellEditor dcEditor = new KDTDefaultCellEditor((JTextField)formatField);
        this.kDTMain.getColumn(this.COL_DEBITFORMULA).setEditor((ICellEditor)dcEditor);
        this.kDTMain.getColumn(this.COL_CREDITFORMULA).setEditor((ICellEditor)dcEditor);
        KDTDefaultCellEditor currencyEditor = new KDTDefaultCellEditor((IKDEditor)CslRptUIUtil.getCurrencyF7());
        this.kDTMain.getColumn(this.COL_CURRENCY_NAME).setEditor((ICellEditor)currencyEditor);
        this.kDTMain.getColumn(this.COL_CURRENCY_NAME).getStyleAttributes().setLocked(false);
        this.kDTMain.getColumn(this.COL_CURRENCY_NUMBER).getStyleAttributes().setHided(true);
        KDTDefaultCellEditor sourceCurrencyEditor = new KDTDefaultCellEditor((IKDEditor)CslRptUIUtil.getCurrencyF7());
        this.kDTMain.getColumn(this.COL_SOURCECURRENCY_NAME).setEditor((ICellEditor)sourceCurrencyEditor);
        this.kDTMain.getColumn(this.COL_SOURCECURRENCY_NAME).getStyleAttributes().setLocked(false);
        this.kDTMain.getColumn(this.COL_SOURCECURRENCY_NUMBER).getStyleAttributes().setHided(true);
        this.bizBoxItem = new KDBizPromptBox();
        this.bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizBoxItem.setEditFormat("$number$");
        this.bizBoxItem.setDisplayFormat("$number$");
        this.bizBoxItem.setEditable(true);
        this.bizBoxItem.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizBoxItem, null);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)this.bizBoxItem);
        this.kDTMain.getColumn(this.COL_ITEM_NUMBER).setEditor((ICellEditor)itemEditor);
        KDComboBox cmbDataElement = new KDComboBox();
        cmbDataElement.addItem((Object)DataElementProvider.getDataElementInfo(3));
        cmbDataElement.addItem((Object)DataElementProvider.getDataElementInfo(5));
        this.kDTMain.getColumn(this.COL_DATAELEMENT).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDataElement));
        KDComboBox cmbValueType = new KDComboBox();
        cmbValueType.addItem((Object)ValueTypeEnum.MONEY);
        cmbValueType.addItem((Object)ValueTypeEnum.QUANTITY);
        this.kDTMain.getColumn(this.COL_VALUETYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbValueType));
        KDComboBox cmbConvertStatus = new KDComboBox();
        cmbConvertStatus.addItem((Object)ConvertStatusEnum.BeforeConvert);
        cmbConvertStatus.addItem((Object)ConvertStatusEnum.Converted);
        this.kDTMain.getColumn(this.COL_CONVERTSTATUS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbConvertStatus));
        this.kDTMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                ItemDataYearInitBaseEditUI.this.tableValueChanged(e);
            }
        });
        this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setLocked(true);
    }

    private void tableValueChanged(KDTEditEvent e) {
        Object obj;
        CurrencyInfo currency;
        int selectRow = e.getRowIndex();
        KDTable kdtEntry = (KDTable)e.getSource();
        IRow row = kdtEntry.getRow(selectRow);
        if (e.getColIndex() == kdtEntry.getColumnIndex(this.COL_ITEM_NUMBER) && e.getValue() != null && e.getOldValue() != e.getValue()) {
            row.getCell(this.COL_CREDITFORMULA).setValue(null);
            row.getCell(this.COL_DEBITFORMULA).setValue(null);
            RPTItemInfo rptItem = (RPTItemInfo)e.getValue();
            row.getCell(this.COL_ITEM_NAME).setValue((Object)rptItem.getName(this.getCurrentLocale()));
            this.setColor(row, rptItem.getDc());
        }
        if (e.getColIndex() == kdtEntry.getColumnIndex(this.COL_CURRENCY_NAME) && e.getValue() != null && e.getOldValue() != e.getValue()) {
            row.getCell(this.COL_CREDITFORMULA).setValue(null);
            row.getCell(this.COL_DEBITFORMULA).setValue(null);
            currency = (CurrencyInfo)e.getValue();
            this.setPrecision(e.getRowIndex(), currency);
            row.getCell(this.COL_CURRENCY_NUMBER).setValue((Object)currency.getName(this.getCurrentLocale()));
            obj = row.getCell(this.COL_SOURCECURRENCY_NAME).getValue();
            if (obj != null) {
                if (currency.getNumber().equals(((CurrencyInfo)obj).getNumber())) {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
                } else {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
                }
            }
        }
        if (e.getColIndex() == kdtEntry.getColumnIndex(this.COL_SOURCECURRENCY_NAME) && e.getValue() != null && e.getOldValue() != e.getValue()) {
            row.getCell(this.COL_CREDITFORMULA).setValue(null);
            row.getCell(this.COL_DEBITFORMULA).setValue(null);
            currency = (CurrencyInfo)e.getValue();
            this.setPrecision(e.getRowIndex(), currency);
            row.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue((Object)currency.getName(this.getCurrentLocale()));
            obj = row.getCell(this.COL_CURRENCY_NAME).getValue();
            if (obj != null) {
                if (currency.getNumber().equals(((CurrencyInfo)obj).getNumber())) {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
                } else {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
                }
            }
        }
        if (e.getColIndex() == kdtEntry.getColumnIndex(this.COL_DEBITFORMULA) || e.getColIndex() == kdtEntry.getColumnIndex(this.COL_CREDITFORMULA)) {
            Object debitFormula = row.getCell(this.COL_DEBITFORMULA).getValue();
            Object creditFormula = row.getCell(this.COL_CREDITFORMULA).getValue();
            if (debitFormula != null && creditFormula != null && !StringUtils.isEmpty((String)debitFormula.toString()) && ((BigDecimal)debitFormula).compareTo(new BigDecimal("0")) != 0 && !StringUtils.isEmpty((String)creditFormula.toString()) && ((BigDecimal)creditFormula).compareTo(new BigDecimal("0")) != 0) {
                MsgBox.showInfo((Component)((Object)this), (String)CslRptUtil.getString("YearInitMutexCreditAndDebit"));
                row.getCell(e.getColIndex()).setValue(null);
            }
        }
    }

    void setPrecision(int rowIndex, CurrencyInfo currency) {
        StyleAttributes attrDebit = this.kDTMain.getRow(rowIndex).getCell(this.COL_DEBITFORMULA).getStyleAttributes();
        attrDebit.setNumberFormat(CslRptUIUtil.getFmtStr(currency));
        attrDebit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes attrCredit = this.kDTMain.getRow(rowIndex).getCell(this.COL_CREDITFORMULA).getStyleAttributes();
        attrCredit.setNumberFormat(CslRptUIUtil.getFmtStr(currency));
        attrCredit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void setPrecisionEditor(int precision) {
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setSupportedEmpty(true);
        formatField.setPrecision(precision);
        KDTDefaultCellEditor dcEditor = new KDTDefaultCellEditor((JTextField)formatField);
        this.kDTMain.getColumn(this.COL_DEBITFORMULA).setEditor((ICellEditor)dcEditor);
        this.kDTMain.getColumn(this.COL_CREDITFORMULA).setEditor((ICellEditor)dcEditor);
    }

    protected boolean isRptYearInit() {
        return false;
    }

    protected void setColor(IRow row, DebitOrCreditEnum dc) {
    }
}

