/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractItemHisExchgRateListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.util.CslGradeManageUtilClient;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ItemHisExchgRateListUI
extends AbstractItemHisExchgRateListUI {
    private static final Logger logger = Logger.getLogger(ItemHisExchgRateListUI.class);
    private OrgUnitInfo company = SysContext.getSysContext().getCurrentOrgUnit();
    private boolean selfGradeOnly = false;

    public ItemHisExchgRateListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ItemHisExchgRateListUI.this.fillTable(e);
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void changeBtnSateByCreateCompany() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (!this.tblMain.getRow(selectRow).getCell("trackRecordCreatorid").getValue().toString().equals(this.company.getId().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ItemHisExchgRateFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fi.gr.cslrpt.client.ItemHisExchgRateEditUI";
    }

    public void onLoad() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    ItemHisExchgRateListUI.this.tblMain_afterDataFill(e);
                }
                catch (Exception exc) {
                    ItemHisExchgRateListUI.this.handUIException(exc);
                }
            }
        });
        this.tblMain.setColumnMoveable(true);
        super.onLoad();
        this.menuItemQuery.setVisible(true);
        this.menuItemQuery.setEnabled(true);
        String format = CslRptUIUtil.getNationalDateFormatString();
        if (format != null) {
            this.tblMain.getColumn("orgBound.startDate").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("changeDate").getStyleAttributes().setNumberFormat(format);
        }
        this.addSeletedChangedListener();
        CslGradeManageUtil.showBtnByCurrentOrg((KDWorkButton)this.btnUpdateMaintainOrg);
    }

    private void addSeletedChangedListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    ItemHisExchgRateListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    ItemHisExchgRateListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.changeBtnSateByCreateCompany();
    }

    private void tblMain_afterDataFill(KDTDataRequestEvent e) {
        int iRowCount = this.tblMain.getRowCount();
        int iCurrencyPrecision = 0;
        BigDecimal bgAmount = null;
        for (int i = 0; i < iRowCount; ++i) {
            iCurrencyPrecision = (Integer)this.tblMain.getCell(i, this.tblMain.getColumnIndex("currencyPrecision")).getValue();
            if (iCurrencyPrecision == 0) {
                iCurrencyPrecision = 2;
            }
            String numberFmt = FMClientHelper.getNumberFtm((int)iCurrencyPrecision);
            this.tblMain.getCell(i, this.tblMain.getColumnIndex("changeAmount")).getStyleAttributes().setNumberFormat(numberFmt);
            bgAmount = (BigDecimal)this.tblMain.getCell(i, this.tblMain.getColumnIndex("changeAmount")).getValue();
            if (bgAmount == null) {
                bgAmount = new BigDecimal(0.0);
            }
            bgAmount = bgAmount.setScale(iCurrencyPrecision, 4);
            this.tblMain.getCell(i, this.tblMain.getColumnIndex("changeAmount")).setValue((Object)bgAmount);
        }
        Object isSupportOtherDS = null;
        try {
            isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
            if ("true".equals(isSupportOtherDS)) {
                this.tblMain.getColumn("dataCollect").getStyleAttributes().setHided(false);
            } else {
                this.tblMain.getColumn("dataCollect").getStyleAttributes().setHided(true);
            }
        }
        catch (EASBizException e1) {
            logger.error((Object)"getParamValue_EASBizException", (Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)"getParamValue_BOSException", (Throwable)e1);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getFilterInfo();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FI_GR_CSLREPORT;
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    private FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filter, (String)"trackRecordCreator.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        Set setOrgsNumber = null;
        Set setOrgUnitsNumber = null;
        Set setOrgRange = null;
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            RptProperties rptProperties = new RptProperties();
            rptProperties.setObject("userPK", userPK);
            Map map = ItemHisExchgRateFactory.getRemoteInstance().getAuthorizedOrgsNumber(rptProperties);
            if (map.isEmpty()) {
                return filter;
            }
            setOrgsNumber = (Set)map.get("orgCompany");
            setOrgUnitsNumber = (Set)map.get("UnionDebt");
            setOrgRange = (Set)map.get("orgRange");
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        int index = 0;
        StringBuffer sbBuffer = new StringBuffer(20);
        if (null != setOrgsNumber && setOrgsNumber.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)setOrgsNumber, CompareType.INCLUDE));
            sbBuffer.append(" #" + index++);
        }
        boolean bFlag = false;
        if (null != setOrgRange && setOrgRange.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("orgBound.number", (Object)setOrgRange, CompareType.INCLUDE));
            if (index == 0) {
                sbBuffer.append(" #" + index++);
            } else {
                sbBuffer.append(" or (#" + index++);
                bFlag = true;
            }
            if (null != setOrgUnitsNumber && setOrgUnitsNumber.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("orgBoundGrp.number", (Object)setOrgUnitsNumber, CompareType.INCLUDE));
                if (bFlag) {
                    sbBuffer.append(" AND #" + index++ + ")");
                } else {
                    sbBuffer.append(" AND #" + index++);
                }
            } else {
                sbBuffer.append(")");
            }
        }
        filter.setMaskString(sbBuffer.toString());
        return filter;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.allowModify(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"454_ElimInvestDataMaintainListUI"));
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtilClient.judgeAndPromptSelectedRow((KDTable)this.tblMain, (int[])KDTableUtil.getSelectedRows((KDTable)this.tblMain), (String)"trackRecordCreatorid", (String)this.company.getId().toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"455_ElimInvestDataMaintainListUI"), (String)"noeqCreateOrgRemove");
        super.actionRemove_actionPerformed(e);
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            Object recordCreatorid;
            if (this.tblMain.getRow(i) == null || (recordCreatorid = this.tblMain.getRow(i).getCell("trackRecordCreatorid").getValue()) == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    private boolean allowModify(String Msg) {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return false;
            }
            Object createUnit = row.getCell("trackRecordCreatorid").getValue();
            if (createUnit != null && createUnit.equals(this.company.getId().toString())) {
                return true;
            }
            MsgBox.showInfo((String)Msg);
            SysUtil.abort();
        }
        return false;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return CslRptUtil.getCurrentChckPermOrgPk(action);
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.changeFilterByFlag();
        this.actionRefresh_actionPerformed(e);
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("trackRecordCreator.id", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"trackRecordCreator.id".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg((String)"T_CSL_ItemHisExchgRate", (String)"FTrackRecordCreatorID", (ArrayList)this.getSelectedIdValues());
        this.actionRefresh_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        String solutionName = "eas.fi.gr.pp.ppItemHisExchgRate";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"926_ItemHisExchgRateTitle");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        String solutionName = "eas.fi.gr.ppItemHisExchgRate";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"926_ItemHisExchgRateTitle");
        param.datataskMode = 1;
        param.putContextParam((Object)"mainQuery", (Object)this.mainQuery);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.ExportData();
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQueryPK", (Object)MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateQuery"));
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(para, 1);
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }
}

