/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class KDTableUtilForRpt {
    private static Logger log = Logger.getLogger(KDTableUtilForRpt.class);

    public static void addSelectedRow(KDTable table, int rowIndex) {
        KDTSelectBlock block = new KDTSelectBlock();
        block.setTop(rowIndex);
        block.setBottom(rowIndex);
        block.setLeft(0);
        block.setRight(table.getColumnCount());
        block.setTable(table);
        table.getSelectManager().add(block);
        log.error((Object)("select block:" + block.toString()));
    }

    public static void removeAllSelectedRow(KDTable table, boolean isfireActiveCellEvent) {
        table.getSelectManager().removeAll(isfireActiveCellEvent);
    }

    public static String getSelectedFieldValueBy(KDTable table, String fieldName) {
        List[] selectedValues = KDTableUtilForRpt.getSelectedFieldsValueBy(table, new String[]{fieldName});
        if (selectedValues.length == 0 || selectedValues[0].isEmpty() || selectedValues[0].get(0) == null) {
            return null;
        }
        return selectedValues[0].get(0).toString();
    }

    public static List[] getSelectedFieldsValueBy(KDTable table, String[] fieldNames) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        if (selectRows.length <= 0) {
            return new LinkedList[0];
        }
        int columnSize = fieldNames.length;
        ICell cell = null;
        List[] fieldValues = new LinkedList[selectRows.length];
        for (int rowIndex = 0; rowIndex < selectRows.length; ++rowIndex) {
            fieldValues[rowIndex] = new LinkedList();
        }
        int returnRowIndex = 0;
        int i = 0;
        int size = selectRows.length;
        while (i < size) {
            int rowIndex = selectRows[i];
            IRow row = table.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
                Object keyValue;
                cell = row.getCell(fieldNames[columnIndex]);
                if (cell == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                    SysUtil.abort();
                }
                if ((keyValue = cell.getValue()) == null) continue;
                fieldValues[returnRowIndex].add(keyValue.toString());
            }
            ++i;
            ++returnRowIndex;
        }
        return fieldValues;
    }
}

