/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.MessageTemplateFactory;
import com.kingdee.eas.fi.gr.cslrpt.MessageTemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractMailMessageTemplateUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

public class MailMessageTemplateUI
extends AbstractMailMessageTemplateUI {
    private static final Logger logger = CoreUIObject.getLogger(MailMessageTemplateUI.class);
    public Object isSupportDC = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
    public boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l17");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTextArea1.setMaxLength(5000);
        this.btnSave.setEnabled(true);
        String orgId = (String)this.getUIContext().get("ORG_ID");
        if (orgId != null) {
            this.setDefaultMessage(orgId);
        }
    }

    public void setDefaultMessage(String orgId) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("orgID"));
        view.getSelector().add(new SelectorItemInfo("SMSMessageTemplate"));
        view.getSelector().add(new SelectorItemInfo("EMailMEssageTemplate"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgId));
        view.setFilter(filter);
        CoreBaseCollection c = MessageTemplateFactory.getRemoteInstance().getCollection(view);
        if (c != null && c.size() > 0) {
            MessageTemplateInfo template = (MessageTemplateInfo)c.get(0);
            byte[] data = template.getEMailMEssageTemplate();
            if (data != null && data.length > 0) {
                String msg = this.bytesToString(data);
                if (msg.trim().length() == 0) {
                    this.setDefaultMsg();
                } else {
                    this.kDTextArea1.setText(msg);
                }
            } else {
                this.setDefaultMsg();
            }
        } else {
            this.setDefaultMsg();
        }
    }

    public void setDefaultMsg() throws Exception {
        StringBuffer emailShow = new StringBuffer();
        emailShow.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a3")).append(" ");
        if ("true".equals(this.isSupportDC)) {
            emailShow.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a3_SupportDC")).append(" ");
        }
        emailShow.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a3_periodType"));
        if (!this.isMergeByFiscalPeriod) {
            emailShow.append(" ").append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a3_rptdate"));
        }
        emailShow.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a3_end"));
        String email = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a0") + "\uff0c" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a1") + "\r\n\r\n" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a2") + "\r\n\r\n" + emailShow.toString() + "\r\n\r\n" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a4") + "\r\n\r\n" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a9") + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a5") + "\r\n\r\n" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a6") + "\r\n\r\n" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a7") + "\r\n\r\n" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.a8") + "\r\n\r\n";
        this.kDTextArea1.setText(email);
        this.actionSave_actionPerformed(null);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        String orgId = (String)this.getUIContext().get("ORG_ID");
        if (orgId != null) {
            this.saveTemplate(orgId);
        }
        this.disposeUIWindow();
    }

    public void saveTemplate(String orgId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgId));
        view.setFilter(filter);
        CoreBaseCollection c = MessageTemplateFactory.getRemoteInstance().getCollection(view);
        if (c != null && c.size() > 0) {
            MessageTemplateInfo template = (MessageTemplateInfo)c.get(0);
            String msg = this.kDTextArea1.getText();
            if (msg != null) {
                template.setEMailMEssageTemplate(this.StringToBytes(msg));
            } else {
                template.setEMailMEssageTemplate(null);
            }
            MessageTemplateFactory.getRemoteInstance().submit((CoreBaseInfo)template);
        } else {
            MessageTemplateInfo template = new MessageTemplateInfo();
            template.setOrgID(orgId);
            String msg = this.kDTextArea1.getText();
            if (msg != null) {
                template.setEMailMEssageTemplate(this.StringToBytes(msg));
            } else {
                template.setEMailMEssageTemplate(null);
            }
            MessageTemplateFactory.getRemoteInstance().submit((CoreBaseInfo)template);
        }
    }

    public String bytesToString(byte[] bytes) {
        ByteArrayInputStream srcIn = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream in = new ObjectInputStream(srcIn);
            return (String)in.readObject();
        }
        catch (IOException e) {
            logger.error((Object)"bytesToString_IOException", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"bytesToString_ClassNotFoundException", (Throwable)e);
        }
        return null;
    }

    public byte[] StringToBytes(String str) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(o);
            out.writeObject(str);
            return o.toByteArray();
        }
        catch (IOException e) {
            logger.error((Object)"StringToBytes_IOException", (Throwable)e);
            return null;
        }
    }
}

