/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.MaintainYearInitDataFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractMaintainYearInitDataUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class MaintainYearInitDataUI
extends AbstractMaintainYearInitDataUI {
    private static final Logger logger = CoreUIObject.getLogger(MaintainYearInitDataUI.class);
    private List reportIDList = null;
    private GroupRptProcessUI parentGroupRptProcessUI = null;
    private boolean isBuildByParentGroupRptProcessUI = false;
    private Integer rptSourceType = null;
    private static final String RPTITEM_NUMBER_COLUMN = "rptItemNumberColumn";
    private static final String RPTITEM_NAME_COLUMN = "rptItemNameColumn";
    private static final String CURRENCY_COLUMN = "currencyColumn";
    private static final String YEAR_COLUMN = "yearColumn";
    private static final String CREDIT_COLUMN = "creditColumn";
    private static final String DEBIT_COLUMN = "debitColumn";
    private static final String DATA_ELEMENT_COLUMN = "dataElementColumn";
    private static final String VALUE_TYPE_COLUMN = "valueTypeColumn";
    private static final String ORGTREE_COLUMN = "orgTreeColumn";
    private static final String SOURCECURRECY_COLUMN = "sourceCurrecy";
    private Map<String, Object> maintainYearInitData = null;

    public void onLoad() throws Exception {
        Object parentUI;
        super.onLoad();
        this.saveKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.reportIDList = (List)this.getUIContext().get("ReportIDList");
        String companyDisplayName = (String)this.getUIContext().get("CompanyDisplayName");
        if (companyDisplayName == null) {
            companyDisplayName = "";
        }
        if ((parentUI = this.getUIContext().get("ParentUI")) != null) {
            if (parentUI instanceof GroupRptProcessUI) {
                this.isBuildByParentGroupRptProcessUI = true;
                this.parentGroupRptProcessUI = (GroupRptProcessUI)parentUI;
            } else {
                this.isBuildByParentGroupRptProcessUI = false;
            }
        }
        this.rptSourceType = (Integer)this.getUIContext().get("RptSourceType");
        this.companyDisplayNameKDLabel.setText(companyDisplayName);
        this.maintainYearInitData = (Map)this.getUIContext().get("maintainYearInitData");
        this.buildTable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.printKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.printPreviewKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    protected void rptItemKDTable_editStopped(KDTEditEvent e) throws Exception {
        super.rptItemKDTable_editStopped(e);
        int rowIndex = e.getRowIndex();
        BigDecimal debit = (BigDecimal)this.rptItemKDTable.getCell(rowIndex, CREDIT_COLUMN).getValue();
        BigDecimal credit = (BigDecimal)this.rptItemKDTable.getCell(rowIndex, DEBIT_COLUMN).getValue();
        BigDecimal zero = new BigDecimal("0");
        if (rowIndex >= 0 && rowIndex < this.rptItemKDTable.getRowCount() && debit != null && credit != null) {
            this.rptItemKDTable.getCell(rowIndex, e.getColIndex()).setValue(null);
        }
    }

    @Override
    protected void genYearInitDataKDWorkButton_actionPerformed(ActionEvent e) throws Exception {
        super.genYearInitDataKDWorkButton_actionPerformed(e);
        boolean hasValue = false;
        int rowCount = this.rptItemKDTable.getRowCount();
        IRow tableRow = null;
        for (int i = 0; i < rowCount; ++i) {
            tableRow = this.rptItemKDTable.getRow(i);
            if (tableRow.getCell(DEBIT_COLUMN).getValue() == null && tableRow.getCell(CREDIT_COLUMN).getValue() == null) continue;
            hasValue = true;
            break;
        }
        if (hasValue) {
            int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"MaintainYearInitData_Dialog_ConverData"));
            if (result == 0) {
                this.getYearInitDataFromCurrentTable();
            }
        } else {
            this.getYearInitDataFromCurrentTable();
        }
    }

    @Override
    protected void saveKDWorkButton_actionPerformed(ActionEvent e) throws Exception {
        this.checkInput();
        super.saveKDWorkButton_actionPerformed(e);
        int rowCount = this.rptItemKDTable.getRowCount();
        if (rowCount == 0) {
            return;
        }
        ArrayList<HashMap> valuelist = new ArrayList<HashMap>(rowCount);
        ArrayList valueList = null;
        HashMap valueMap = null;
        HashMap orgUnitMap = new HashMap();
        IRow tableRow = null;
        Object userObject = null;
        HashMap itemDataYearInitHashMap = null;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            tableRow = this.rptItemKDTable.getRow(rowIndex);
            userObject = tableRow.getCell(RPTITEM_NUMBER_COLUMN).getUserObject();
            if (userObject == null || !(userObject instanceof ArrayList)) continue;
            valueList = (ArrayList)userObject;
            int valueMapCount = valueList.size();
            for (int valueMapIndex = 0; valueMapIndex < valueMapCount; ++valueMapIndex) {
                valueMap = (HashMap)valueList.get(valueMapIndex);
                itemDataYearInitHashMap = this.getItemDataYearInitHashMap(valueMap, tableRow);
                valuelist.add(itemDataYearInitHashMap);
            }
        }
        if (valuelist.size() == 0) {
            return;
        }
        boolean isOk = MaintainYearInitDataFacadeFactory.getRemoteInstance().updateItemDataYearInit(valuelist);
        if (isOk) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"MaintainYearInitData_Dialog_SaveSuccess"));
        }
    }

    private HashMap getItemDataYearInitHashMap(HashMap valueMap, IRow tableRow) {
        HashMap<String, Object> itemDataYearInitHashMap = new HashMap<String, Object>();
        if ((Integer)valueMap.get("RptSourceType") == 7 || (Integer)valueMap.get("RptSourceType") == 1) {
            itemDataYearInitHashMap.put("OrgTreeID", null);
            itemDataYearInitHashMap.put("OrgTreeNumber", null);
        } else {
            itemDataYearInitHashMap.put("OrgTreeID", valueMap.get("OrgTreeID"));
            itemDataYearInitHashMap.put("OrgTreeNumber", valueMap.get("OrgTreeNumber"));
        }
        itemDataYearInitHashMap.put("OrgUnitNumber", valueMap.get("OrgUnitNumber"));
        itemDataYearInitHashMap.put("OrgUnitID", valueMap.get("OrgUnitID"));
        itemDataYearInitHashMap.put("Year", (Integer)valueMap.get("Year"));
        itemDataYearInitHashMap.put("RptItemID", valueMap.get("RptItemID"));
        itemDataYearInitHashMap.put("CurrencyID", valueMap.get("CurrencyID"));
        itemDataYearInitHashMap.put("srcCurrencyId", valueMap.get("srcCurrencyId"));
        itemDataYearInitHashMap.put("DataElement", valueMap.get("DataElement"));
        itemDataYearInitHashMap.put("ValueType", valueMap.get("ValueType"));
        itemDataYearInitHashMap.put("Period", valueMap.get("Period"));
        itemDataYearInitHashMap.put("Debit", tableRow.getCell(DEBIT_COLUMN).getValue());
        itemDataYearInitHashMap.put("Credit", tableRow.getCell(CREDIT_COLUMN).getValue());
        itemDataYearInitHashMap.put("CurrentUserID", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        itemDataYearInitHashMap.put("ControlUnitID", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        itemDataYearInitHashMap.put("MergeType", this.isManageMerge() ? 1 : 0);
        return itemDataYearInitHashMap;
    }

    protected KDTable getTableForPrintSetting() {
        return this.rptItemKDTable;
    }

    @Override
    protected void printKDWorkButton_actionPerformed(ActionEvent e) throws Exception {
        super.printKDWorkButton_actionPerformed(e);
        this.preparePrintPage(this.rptItemKDTable);
        this.rptItemKDTable.getPrintManager().print();
    }

    @Override
    protected void printPreviewKDWorkButton_actionPerformed(ActionEvent e) throws Exception {
        super.printPreviewKDWorkButton_actionPerformed(e);
        this.preparePrintPage(this.rptItemKDTable);
        this.rptItemKDTable.getPrintManager().printPreview();
    }

    @Override
    public void storeFields() {
        this.checkInput();
        super.storeFields();
    }

    private void getYearInitDataFromCurrentTable() throws Exception {
        if (this.isBuildByParentGroupRptProcessUI) {
            this.getYearInitDataFromCurrentTableByParentGroupRptProcessUI();
        } else {
            this.getYearInitDataFromCurrentTableByReportID();
        }
    }

    private void buildTable() throws Exception {
        List valueList;
        this.rptItemKDTable.checkParsed();
        if (this.reportIDList != null && (valueList = MaintainYearInitDataFacadeFactory.getRemoteInstance().getRptItemInfoByReportIDList(this.reportIDList, 5)) != null) {
            this.rptItemKDTable.getColumn(RPTITEM_NUMBER_COLUMN).getStyleAttributes().setLocked(true);
            this.rptItemKDTable.getColumn(RPTITEM_NAME_COLUMN).getStyleAttributes().setLocked(true);
            this.rptItemKDTable.getColumn(CURRENCY_COLUMN).getStyleAttributes().setLocked(true);
            this.rptItemKDTable.getColumn(SOURCECURRECY_COLUMN).getStyleAttributes().setLocked(true);
            this.rptItemKDTable.getColumn(YEAR_COLUMN).getStyleAttributes().setLocked(true);
            this.rptItemKDTable.getColumn(DATA_ELEMENT_COLUMN).getStyleAttributes().setLocked(true);
            this.rptItemKDTable.getColumn(ORGTREE_COLUMN).getStyleAttributes().setLocked(true);
            this.rptItemKDTable.getColumn(VALUE_TYPE_COLUMN).getStyleAttributes().setLocked(true);
            this.rptItemKDTable.getColumn(CREDIT_COLUMN).getStyleAttributes().setLocked(false);
            this.rptItemKDTable.getColumn(DEBIT_COLUMN).getStyleAttributes().setLocked(false);
            KDFormattedTextField formatField = new KDFormattedTextField();
            formatField.setDataType(1);
            formatField.setSupportedEmpty(true);
            formatField.setPrecision(5);
            KDTDefaultCellEditor dcEditor = new KDTDefaultCellEditor((JTextField)formatField);
            this.rptItemKDTable.getColumn(CREDIT_COLUMN).setEditor((ICellEditor)dcEditor);
            this.rptItemKDTable.getColumn(DEBIT_COLUMN).setEditor((ICellEditor)dcEditor);
            this.rptItemKDTable.setRefresh(false);
            this.rptItemKDTable.removeRows();
            Iterator valueIt = valueList.iterator();
            while (valueIt.hasNext()) {
                this.buildTableRow((HashMap)valueIt.next());
            }
            this.rptItemKDTable.setRefresh(true);
            this.rptItemKDTable.repaint();
        }
        this.rptItemKDTable.getColumn(ORGTREE_COLUMN).getStyleAttributes().setHided(true);
    }

    private void buildTableRow(HashMap valueMap) throws Exception {
        String currentRptItemNumber = (String)valueMap.get("RptItemNumber");
        int valueType = (Integer)valueMap.get("ValueType");
        if (currentRptItemNumber == null || currentRptItemNumber.equals("")) {
            return;
        }
        int rowCount = this.rptItemKDTable.getRowCount();
        IRow tableRow = null;
        ArrayList<HashMap> valueList = null;
        for (int i = 0; i < rowCount; ++i) {
            tableRow = this.rptItemKDTable.getRow(i);
            if (!currentRptItemNumber.equals(tableRow.getCell(RPTITEM_NUMBER_COLUMN).getValue()) || !ValueTypeEnum.getEnum(valueType).getAlias().equals(((ValueTypeEnum)((Object)tableRow.getCell(VALUE_TYPE_COLUMN).getValue())).getAlias())) continue;
            String tempStr = (String)tableRow.getCell(ORGTREE_COLUMN).getValue();
            if (this.rptSourceType == 7) {
                tableRow.getCell(ORGTREE_COLUMN).setValue((Object)(tempStr + "/" + valueMap.get("OrgTreeName")));
            }
            valueList = (ArrayList<HashMap>)tableRow.getCell(RPTITEM_NUMBER_COLUMN).getUserObject();
            valueList.add(valueMap);
            return;
        }
        tableRow = this.rptItemKDTable.addRow();
        tableRow.getCell(RPTITEM_NUMBER_COLUMN).setValue(valueMap.get("RptItemNumber"));
        tableRow.getCell(RPTITEM_NAME_COLUMN).setValue(valueMap.get("RptItemName"));
        tableRow.getCell(SOURCECURRECY_COLUMN).setValue(valueMap.get("srcCurrencyName"));
        tableRow.getCell(CURRENCY_COLUMN).setValue(valueMap.get("CurrencyName"));
        tableRow.getCell(YEAR_COLUMN).setValue(valueMap.get("Year"));
        BigDecimal zero = new BigDecimal("0");
        BigDecimal credit = new BigDecimal("0");
        BigDecimal debit = new BigDecimal("0");
        credit = (BigDecimal)valueMap.get("Credit");
        debit = (BigDecimal)valueMap.get("Debit");
        if (credit != null && !credit.equals(zero)) {
            tableRow.getCell(CREDIT_COLUMN).setValue(valueMap.get("Credit"));
            tableRow.getCell(DEBIT_COLUMN).setValue(null);
        } else if (credit != null && credit.equals(zero) && debit == null) {
            tableRow.getCell(CREDIT_COLUMN).setValue(valueMap.get("Credit"));
            tableRow.getCell(DEBIT_COLUMN).setValue(null);
        } else if (debit != null && !debit.equals(zero)) {
            tableRow.getCell(CREDIT_COLUMN).setValue(null);
            tableRow.getCell(DEBIT_COLUMN).setValue(valueMap.get("Debit"));
        } else if (debit != null && debit.equals(zero) && credit == null) {
            tableRow.getCell(CREDIT_COLUMN).setValue(null);
            tableRow.getCell(DEBIT_COLUMN).setValue(valueMap.get("Debit"));
        } else {
            tableRow.getCell(CREDIT_COLUMN).setValue(null);
            tableRow.getCell(DEBIT_COLUMN).setValue(null);
        }
        tableRow.getCell(DATA_ELEMENT_COLUMN).setValue((Object)DataElementProvider.getDataElementName((Integer)valueMap.get("DataElement")));
        tableRow.getCell(VALUE_TYPE_COLUMN).setValue((Object)ValueTypeEnum.getEnum((Integer)valueMap.get("ValueType")));
        if (this.rptSourceType == 1) {
            if (CSLContextHelper.getCSLContext() == null || CSLContextHelper.getCSLContext().getCurOrgBound() == null) {
                tableRow.getCell(ORGTREE_COLUMN).setValue(valueMap.get("OrgTreeName"));
            } else {
                tableRow.getCell(ORGTREE_COLUMN).setValue((Object)CSLContextHelper.getCSLContext().getCurOrgBound().getName());
            }
        }
        if (this.rptSourceType == 7 || this.rptSourceType == 34) {
            tableRow.getCell(ORGTREE_COLUMN).setValue(valueMap.get("OrgTreeName"));
        }
        valueList = new ArrayList<HashMap>();
        valueList.add(valueMap);
        tableRow.getCell(RPTITEM_NUMBER_COLUMN).setUserObject(valueList);
    }

    private void getYearInitDataFromCurrentTableByParentGroupRptProcessUI() throws Exception {
        if (this.parentGroupRptProcessUI != null) {
            int rowCount = this.rptItemKDTable.getRowCount();
            BigDecimal value = null;
            Cell tableCell = null;
            HashMap valueMap = null;
            BigDecimal zero = new BigDecimal("0");
            for (int i = 0; i < rowCount; ++i) {
                value = null;
                tableCell = null;
                IRow tableRow = this.rptItemKDTable.getRow(i);
                Object userObject = tableRow.getCell(RPTITEM_NUMBER_COLUMN).getUserObject();
                if (userObject != null && userObject instanceof ArrayList) {
                    valueMap = (HashMap)((ArrayList)userObject).get(0);
                    Sheet sheet = this.parentGroupRptProcessUI.getBook().getSheetByID((String)valueMap.get("RptItemSheetID"));
                    if (sheet == null) continue;
                    tableCell = sheet.getCell(((Integer)valueMap.get("RptItemPosY")).intValue(), ((Integer)valueMap.get("RptItemPosX")).intValue(), false);
                    if (tableCell != null && tableCell.getValue() != null) {
                        Variant valueObject = tableCell.getValue();
                        if (valueObject.getValue() instanceof BigDecimal) {
                            value = (BigDecimal)valueObject.getValue();
                        } else if (valueObject.getValue() instanceof String) {
                            try {
                                value = new BigDecimal((String)valueObject.getValue());
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                    }
                }
                if (valueMap != null && !valueMap.isEmpty() && valueMap.get("RptItemDC") != null && (Integer)valueMap.get("RptItemDC") == 1) {
                    tableRow.getCell(DEBIT_COLUMN).setValue(value);
                    tableRow.getCell(CREDIT_COLUMN).setValue(null);
                }
                if (valueMap == null || valueMap.isEmpty() || valueMap.get("RptItemDC") == null || (Integer)valueMap.get("RptItemDC") != 0) continue;
                tableRow.getCell(CREDIT_COLUMN).setValue(value);
                tableRow.getCell(DEBIT_COLUMN).setValue(null);
            }
        }
    }

    private void getYearInitDataFromCurrentTableByReportID() throws Exception {
        if (this.reportIDList != null && this.maintainYearInitData != null) {
            int rowCount = this.rptItemKDTable.getRowCount();
            BigDecimal value = null;
            HashMap valueMap = null;
            for (int i = 0; i < rowCount; ++i) {
                value = null;
                IRow tableRow = this.rptItemKDTable.getRow(i);
                Object userObject = tableRow.getCell(RPTITEM_NUMBER_COLUMN).getUserObject();
                if (userObject != null && userObject instanceof ArrayList) {
                    valueMap = (HashMap)((ArrayList)userObject).get(0);
                    if (tableRow.getCell(RPTITEM_NUMBER_COLUMN).getValue() != null) {
                        String itemNumber = (String)tableRow.getCell(RPTITEM_NUMBER_COLUMN).getValue();
                        ValueTypeEnum valueTypeEnum = (ValueTypeEnum)((Object)tableRow.getCell(VALUE_TYPE_COLUMN).getValue());
                        int valuetyep = valueTypeEnum.getValue();
                        String key = itemNumber + valuetyep;
                        Object valueObject = this.maintainYearInitData.get(key);
                        if (valueObject instanceof BigDecimal) {
                            value = (BigDecimal)valueObject;
                        } else if (valueObject instanceof String) {
                            try {
                                value = new BigDecimal((String)valueObject);
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                    }
                }
                if (valueMap != null && valueMap.get("RptItemDC") != null && (Integer)valueMap.get("RptItemDC") == 1) {
                    tableRow.getCell(DEBIT_COLUMN).setValue(value);
                    tableRow.getCell(CREDIT_COLUMN).setValue(null);
                }
                if (valueMap == null || valueMap.get("RptItemDC") == null || (Integer)valueMap.get("RptItemDC") != 0) continue;
                tableRow.getCell(DEBIT_COLUMN).setValue(null);
                tableRow.getCell(CREDIT_COLUMN).setValue(value);
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void checkInput() {
        String message = null;
        int rowCount = this.rptItemKDTable.getRowCount();
        IRow tableRow = null;
        String msg = null;
        for (int i = 0; i < rowCount; ++i) {
            tableRow = this.rptItemKDTable.getRow(i);
            if (tableRow.getCell(DEBIT_COLUMN).getValue() == null || tableRow.getCell(CREDIT_COLUMN).getValue() == null || Double.parseDouble(tableRow.getCell(DEBIT_COLUMN).getValue().toString()) == 0.0 || Double.parseDouble(tableRow.getCell(CREDIT_COLUMN).getValue().toString()) == 0.0) continue;
            msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"49_MaintainYearInitDataUI");
            message = MessageFormat.format(msg, tableRow.getCell(RPTITEM_NUMBER_COLUMN).getValue().toString(), tableRow.getCell(RPTITEM_NAME_COLUMN).getValue().toString());
            break;
        }
        if (message != null) {
            MsgBox.showInfo((Component)((Object)this), message);
            SysUtil.abort();
        }
    }

    protected boolean isManageMerge() {
        return false;
    }
}

