/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.OrgTreePeriodFactory;
import com.kingdee.eas.fi.gr.cslrpt.OrgTreePeriodInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractOrgTreePeriodEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class OrgTreePeriodEditUI
extends AbstractOrgTreePeriodEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgTreePeriodEditUI.class);
    private OrgTreeInfo curOrgTreeInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.orgTree.setEditable(false);
        this.periodType.setEditable(false);
        this.orgTree.setDisplayFormat("$name$");
        this.orgTree.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.OrgTreePeriodTreeF7Query");
        EntityViewInfo v = this.getCurOrgCuView();
        this.orgTree.setEntityViewInfo(v);
        this.periodType.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.PeriodTypeQuery");
        if (this.oprtState.equals(OprtState.EDIT)) {
            this.curOrgTreeInfo = (OrgTreeInfo)this.orgTree.getData();
        }
    }

    private EntityViewInfo getCurOrgCuView() {
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String cuID = SysContext.getSysContext().getCurrentOrgUnit().getCU().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isForBudget", (Object)0, CompareType.EQUALS));
        v.setFilter(filter);
        return v;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getCompany() == null) {
            this.editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        }
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getCompany().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return new OrgTreePeriodInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrgTreePeriodFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.orgTree.getData();
        if (orgTreeInfo != null) {
            String orgTreeId = orgTreeInfo.getId().toString();
            if (!(this.oprtState.equals(OprtState.EDIT) && this.curOrgTreeInfo != null && orgTreeId.equals(this.curOrgTreeInfo.getId().toString()) || !this.getBizInterface().exists("select 1 where orgTree.id='" + orgTreeId + "'"))) {
                MsgBox.showWarning((String)CslRptUtil.getString("orgTreeHasPeriodType"));
                return;
            }
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void verifyInput() throws Exception {
        if (this.orgTree.getData() == null) {
            MsgBox.showError((String)CslRptUtil.getString("orgTreeNotNull"));
            SysUtil.abort();
            return;
        }
        if (this.periodType.getData() == null) {
            MsgBox.showError((String)CslRptUtil.getString("periodTypeNotNull"));
            SysUtil.abort();
            return;
        }
    }

    public boolean isModify() {
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            return false;
        }
        return super.isModify();
    }

    private void initUI() {
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnReset.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuEdit.setEnabled(false);
        this.menuView.setVisible(false);
        this.menuView.setEnabled(false);
        this.menuBiz.setVisible(false);
        this.menuBiz.setEnabled(false);
    }
}

