/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.OrgTreePeriodFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractOrgTreePeriodListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.OrgTreePeriodEditUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class OrgTreePeriodListUI
extends AbstractOrgTreePeriodListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgTreePeriodListUI.class);
    private OrgUnitInfo company = SysContext.getSysContext().getCurrentOrgUnit();
    private boolean selfGradeOnly = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                OrgTreePeriodListUI.this.fillTable(e);
            }
        });
        this.addSeletedChangedListener();
        CslGradeManageUtil.showBtnByCurrentOrg((KDWorkButton)this.btnUpdateMaintainOrg);
    }

    private void addSeletedChangedListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    OrgTreePeriodListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    OrgTreePeriodListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.changeBtnSateByCreateCompany();
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            Object recordCreatorid;
            if (this.tblMain.getRow(i) == null || (recordCreatorid = this.tblMain.getRow(i).getCell("company").getValue()) == null || recordCreatorid.equals(company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    private void changeBtnSateByCreateCompany() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (!this.tblMain.getRow(selectRow).getCell("company").getValue().toString().equals(this.company.getId().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrgTreePeriodFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return OrgTreePeriodEditUI.class.getName();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission();
        if (this.isSelectedOrgTreeStarted()) {
            MsgBox.showWarning((String)CslRptUtil.getString("orgTreeNoEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission();
        if (this.isSelectedOrgTreeStarted()) {
            MsgBox.showWarning((String)CslRptUtil.getString("orgTreeNoDelete"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    private void initUI() {
        this.btnLocate.setVisible(false);
        this.menuItemLocate.setVisible(false);
    }

    private boolean isSelectedOrgTreeStarted() throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String orgTreeNumber = (String)this.tblMain.getRow(selectRows[0]).getCell("orgTreeNumber").getValue();
        return OrgTreeFactory.getRemoteInstance().exists("select 1 where number='" + orgTreeNumber + "' and status=1");
    }

    private void checkPermission() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String companyId = (String)this.tblMain.getRow(selectRows[0]).getCell("company").getValue();
        String curCompanyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        if (companyId != null && curCompanyId != null && !curCompanyId.equals(companyId)) {
            MsgBox.showWarning((String)CslRptUtil.getString("noEditOrDelete"));
            SysUtil.abort();
            return;
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return CslRptUtil.getCurrentChckPermOrgPk(action);
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.changeFilterByFlag();
        this.actionRefresh_actionPerformed(e);
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"company.id".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub((FilterInfo)filterInfo, (String)"company.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"company.id", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg((String)"T_CSL_OrgTreePeriod", (String)"FCompanyId", (ArrayList)super.getSelectedIdValues());
        this.actionRefresh_actionPerformed(e);
    }
}

