/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.InitOrgUnitF7ByOrgType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgUnitF7SelectorForCslRpt
extends KDDialog
implements KDPromptSelector {
    private static final Logger logger = Logger.getLogger(OrgUnitF7SelectorForCslRpt.class);
    private FormulaWizardUI formulaWizardUI = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    private int iSelectMode;
    private OrgUnitInfo orgUnit = null;
    protected UnionF7Helper.UnionF7 f7 = null;

    public OrgUnitF7SelectorForCslRpt() {
        this.iSelectMode = 3;
    }

    public OrgUnitF7SelectorForCslRpt(int iMode) {
        this.iSelectMode = iMode;
    }

    public void show() {
        String orgNumber = this.formulaWizardUI.getParam("fiOrgUnit");
        if (!StringUtils.isEmpty((String)orgNumber)) {
            try {
                this.orgUnit = new InitOrgUnitF7ByOrgType().orgUnitByNumber(this.formulaWizardUI.getRptOrgType(), orgNumber);
            }
            catch (BOSException e) {
                MsgBox.showError((Component)this.formulaWizardUI, (String)e.getMessage());
                SysUtil.abort();
            }
            catch (EASBizException e) {
                MsgBox.showError((Component)this.formulaWizardUI, (String)e.getMessage());
                SysUtil.abort();
            }
        }
        this.createOrgTree();
    }

    public boolean isCanceled() {
        return false;
    }

    public Object getData() {
        return this.orgUnit;
    }

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }

    public void createOrgTree() {
        Object obj = null;
        boolean isSupport13Period = CslRptUtil.isSupport13Period(null);
        if (this.getFormulaWizardUI() != null) {
            obj = ((KDPromptBox)this.getFormulaWizardUI().getParamComponent("orgTreeCslRpt")).getData();
        }
        boolean isHisRateData = this.formulaWizardUI.getFormula().getName().equalsIgnoreCase("HisRateData");
        String orgTreeID = null;
        if (obj instanceof String) {
            String orgTreeNumber = (String)obj;
            String rptPeriodType = this.getFormulaWizardUI().getParam("rptPeriodType");
            String year = this.getFormulaWizardUI().getParam("year");
            String period = this.getFormulaWizardUI().getParam("period");
            if (!isHisRateData && this.getFormulaWizardUI().getRptContext() == null) {
                if (orgTreeNumber != null) {
                    try {
                        OrgTreeCollection orgTreeCollection = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("where number = '" + orgTreeNumber + "' order by startDate desc ");
                        if (orgTreeCollection != null && orgTreeCollection.size() > 0) {
                            orgTreeID = orgTreeCollection.get(0).getId().toString();
                        }
                        if (StringUtils.isEmpty((String)orgTreeID)) {
                            String strErr = EASResource.getString((String)this.resClassName, (String)"pleaseSelectOrgTree");
                            MsgBox.showInfo((String)strErr);
                            return;
                        }
                    }
                    catch (BOSException e) {
                        logger.error((Object)"getOrgTreeCollection_BOSException", (Throwable)e);
                    }
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"582_OrgUnitF7SelectorForCslRpt"));
                    ((KDPromptBox)this.getFormulaWizardUI().getParamComponent("orgTreeCslRpt")).setData(null);
                    ((KDPromptBox)this.getFormulaWizardUI().getParamComponent("orgTreeCslRpt")).requestFocus(true);
                    return;
                }
            }
            if (this.getFormulaWizardUI().getRptContext() != null) {
                Object info = this.getFormulaWizardUI().getRptContext().getReportInfo();
                if (!isHisRateData && info != null && info instanceof ReportBaseInfo) {
                    ReportBaseInfo cslInfo = (ReportBaseInfo)info;
                    List list = RPTDate13Util.getRptYearAndPeriodAndDate(cslInfo.getYear(), cslInfo.getPeriod(), rptPeriodType == null ? cslInfo.getPeriodType().getValue() : FormulaAdapter.getRptPeriodType(rptPeriodType.trim()), Integer.parseInt(year), Integer.parseInt(period), isSupport13Period);
                    Timestamp date = new Timestamp(((Date)list.get(2)).getTime());
                    try {
                        OrgTreeCollection orgTreeCollection;
                        orgTreeID = UnionVersionControllerFacadeFactory.getRemoteInstance().getID(orgTreeNumber, date);
                        if (StringUtils.isEmpty((String)orgTreeID) && (orgTreeCollection = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("where number = '" + orgTreeNumber + "' order by startDate desc ")) != null && orgTreeCollection.size() > 0) {
                            orgTreeID = orgTreeCollection.get(0).getId().toString();
                        }
                        if (StringUtils.isEmpty((String)orgTreeID)) {
                            String strErr = EASResource.getString((String)this.resClassName, (String)"pleaseSelectOrgTree");
                            MsgBox.showInfo((String)strErr);
                            return;
                        }
                    }
                    catch (EASBizException e) {
                        logger.error((Object)"getOrgTreeCollection_EASBizException", (Throwable)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)"getOrgTreeCollection_BOSException", (Throwable)e);
                    }
                }
            }
        } else if (obj instanceof OrgTreeInfo && StringUtils.isEmpty((String)(orgTreeID = ((OrgTreeInfo)obj).getId().toString()))) {
            String strErr = EASResource.getString((String)this.resClassName, (String)"pleaseSelectOrgTree");
            MsgBox.showInfo((String)strErr);
            return;
        }
        this.f7 = new UnionF7Helper.UnionF7((IUIObject)this.getFormulaWizardUI(), this.iSelectMode);
        this.f7.setMultiSelect(false);
        this.f7.setTreeID(orgTreeID);
        this.f7.setShowAssistantOrg(true);
        this.f7.setCheckedAssistantOrgChkBox(true);
        this.f7.show();
        if (!this.f7.isCanceled()) {
            this.orgUnit = (OrgUnitInfo)this.f7.getData();
        }
    }
}

