/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgUnitF7SelectorForCslRptOnlyCompany
extends KDDialog
implements KDPromptSelector {
    private static final Logger logger = Logger.getLogger(OrgUnitF7SelectorForCslRptOnlyCompany.class);
    private FormulaWizardUI formulaWizardUI = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    private int iSelectMode;
    private OrgUnitInfo orgUnit = null;

    public OrgUnitF7SelectorForCslRptOnlyCompany() {
        this.iSelectMode = 1;
    }

    public OrgUnitF7SelectorForCslRptOnlyCompany(int iMode) {
        this.iSelectMode = iMode;
    }

    public void show() {
        this.createOrgTree();
    }

    public boolean isCanceled() {
        return false;
    }

    public Object getData() {
        return this.orgUnit;
    }

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }

    public void createOrgTree() {
        Object obj = null;
        boolean isSupport13Period = CslRptUtil.isSupport13Period(null);
        if (this.getFormulaWizardUI() != null) {
            obj = ((KDPromptBox)this.getFormulaWizardUI().getParamComponent("orgTreeCslRpt")).getData();
        }
        String orgTreeID = null;
        if (obj instanceof String) {
            String orgTreeNumber = (String)obj;
            String rptPeriodType = this.getFormulaWizardUI().getParam("rptPeriodType");
            String year = this.getFormulaWizardUI().getParam("year");
            String period = this.getFormulaWizardUI().getParam("period");
            if (!this.formulaWizardUI.getFormula().getName().equalsIgnoreCase("RefDM") && (StringUtils.isEmpty((String)rptPeriodType) || StringUtils.isEmpty((String)year) || StringUtils.isEmpty((String)period))) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"583_OrgUnitF7SelectorForCslRptOnlyCompany"));
                return;
            }
            if (this.getFormulaWizardUI().getRptContext() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"582_OrgUnitF7SelectorForCslRpt"));
                ((KDPromptBox)this.getFormulaWizardUI().getParamComponent("orgTreeCslRpt")).setData(null);
                ((KDPromptBox)this.getFormulaWizardUI().getParamComponent("orgTreeCslRpt")).requestFocus(true);
                return;
            }
            Object info = this.getFormulaWizardUI().getRptContext().getReportInfo();
            if (info != null && info instanceof CslReportInfo) {
                CslReportInfo cslInfo = (CslReportInfo)info;
                List list = RPTDate13Util.getRptYearAndPeriodAndDate(cslInfo.getYear(), cslInfo.getPeriod(), FormulaAdapter.getRptPeriodType(rptPeriodType.trim()), Integer.parseInt(year), Integer.parseInt(period), isSupport13Period);
                Timestamp date = new Timestamp(((Date)list.get(2)).getTime());
                try {
                    orgTreeID = UnionVersionControllerFacadeFactory.getRemoteInstance().getID(orgTreeNumber, date);
                    if (StringUtils.isEmpty((String)orgTreeID)) {
                        String strErr = EASResource.getString((String)this.resClassName, (String)"pleaseSelectOrgTree");
                        MsgBox.showInfo((String)strErr);
                        return;
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)"getID_EASBizException", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"getID_BOSException", (Throwable)e);
                }
            } else if (info != null) {
                try {
                    OrgTreeCollection orgTreeCollection = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("where number = '" + orgTreeNumber + "' and status=" + 1 + " order by startDate desc ");
                    if (orgTreeCollection != null && orgTreeCollection.size() > 0) {
                        orgTreeID = orgTreeCollection.get(0).getId().toString();
                    }
                    if (StringUtils.isEmpty((String)orgTreeID)) {
                        String strErr = EASResource.getString((String)this.resClassName, (String)"pleaseSelectOrgTree");
                        MsgBox.showInfo((String)strErr);
                        return;
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)"getOrgTreeCollection_BOSException", (Throwable)e);
                }
            }
        } else if (obj instanceof OrgTreeInfo && StringUtils.isEmpty((String)(orgTreeID = ((OrgTreeInfo)obj).getId().toString()))) {
            String strErr = EASResource.getString((String)this.resClassName, (String)"pleaseSelectOrgTree");
            MsgBox.showInfo((String)strErr);
            return;
        }
        String orgUnitGroupID = null;
        if (this.getFormulaWizardUI() != null) {
            obj = ((KDPromptBox)this.getFormulaWizardUI().getParamComponent("orgUnitCslRptOnlyGroup")).getData();
        }
        if (obj != null) {
            if (obj instanceof String) {
                if (!StringUtils.isEmpty((String)orgTreeID)) {
                    String orgUnitGroupNumber = (String)obj;
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeID));
                    filter.getFilterItems().add(new FilterItemInfo("unit.number", (Object)orgUnitGroupNumber));
                    view.setFilter(filter);
                    view.getSelector().add(new SelectorItemInfo("unit.id"));
                    try {
                        OrgStructureCollection structInfos = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(view);
                        if (structInfos != null && structInfos.size() > 0) {
                            orgUnitGroupID = structInfos.get(0).getUnit().getId().toString();
                        }
                    }
                    catch (BOSException e) {
                        logger.error((Object)"getOrgStructureCollection_BOSException", (Throwable)e);
                    }
                }
            } else {
                orgUnitGroupID = ((OrgUnitInfo)obj).getId().toString();
            }
        }
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this.getFormulaWizardUI(), this.iSelectMode);
        f7.setMultiSelect(false);
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        f7.setTreeID(orgTreeID);
        if (!StringUtils.isEmpty((String)orgUnitGroupID) && !StringUtils.isEmpty((String)orgTreeID)) {
            f7.setRootUnitID(orgUnitGroupID);
        }
        f7.setNeedAddOrgRange(false);
        f7.show();
        this.orgUnit = (OrgUnitInfo)f7.getData();
    }
}

