/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AbstractOtherOwnerRightInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.IOtherOwnerRight;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.OtherOwnerRightEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.OtherOwnerRightFactory;
import com.kingdee.eas.fi.gr.cslrpt.OtherOwnerRightInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractOtherOwnerRightEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OtherOwnerRightEditUI
extends AbstractOtherOwnerRightEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherOwnerRightEditUI.class);
    private RPTItemInfo sumitem;
    private ArrayList list = new ArrayList();
    private boolean isItemNull = true;
    private String highMaintainLowLevel = "true";

    public OtherOwnerRightEditUI() throws Exception {
        this.prmtCurrency.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CurrencyInfo currency = (CurrencyInfo)OtherOwnerRightEditUI.this.prmtCurrency.getData();
                KDFormattedTextField formatField = new KDFormattedTextField();
                formatField.setDataType(1);
                formatField.setSupportedEmpty(true);
                CurrencyInfo info = null;
                try {
                    info = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
                }
                catch (EASBizException e) {
                    logger.error((Object)"getCurrencyInfo_EASBizException", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"getCurrencyInfo_BOSException", (Throwable)e);
                }
                if (info != null) {
                    formatField.setPrecision(info.getPrecision());
                } else {
                    formatField.setPrecision(6);
                }
                KDTDefaultCellEditor dcEditor = new KDTDefaultCellEditor((JTextField)formatField);
                OtherOwnerRightEditUI.this.kdtEntries.getColumn("changeMoney").setEditor((ICellEditor)dcEditor);
            }
        });
    }

    public void onLoad() throws Exception {
        String titleTail;
        super.onLoad();
        this.highMaintainLowLevel = ParamManager.getParamValue(null, null, (String)"GR_CSL_HIGHERUPFINANCEORGMAINTAINLOWERLEVEVL");
        this.initData();
        this.HideButton();
        IRPTItem irptItem = RPTItemFactory.getRemoteInstance();
        String oql = " where isFreezed = 0 and control = 20";
        boolean exists = irptItem.exists(oql);
        if (!exists) {
            this.isItemNull = false;
            throw new AdjustException(AdjustException.OWNERRIGHT_ISNULL);
        }
        this.sumitem = irptItem.getRPTItemInfo(oql);
        String patternString = "([\\(]*)([^\\+|^\\-|^\\(|^\\))]{1,})([\\+|\\-|\\(|\\)]*)";
        Pattern pt = Pattern.compile("([\\(]*)([^\\+|^\\-|^\\(|^\\))]{1,})([\\+|\\-|\\(|\\)]*)");
        this.setList();
        this.displayFormula(this.sumitem, 0, pt, this.getList());
        this.initEntryTable();
        if ("ADDNEW".equals(this.getOprtState())) {
            titleTail = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew");
            this.setNaturalCurrency();
        } else {
            titleTail = "VIEW".equals(this.getOprtState()) ? EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View") : EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit");
        }
        if ("EDIT".equals(this.getOprtState()) && "false".equals(this.highMaintainLowLevel)) {
            this.actionRemove.setEnabled(false);
        }
        this.setUITitle(this.getUITitle() + " " + titleTail);
        this.setControlStatus();
        this.initPrecision();
        this.btnAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertIntoLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public boolean isModify() {
        if (this.isItemNull) {
            if (super.isModify()) {
                if (this.getOprtState().equals("ADDNEW")) {
                    IObjectValue tmpInfo = this.createNewData();
                    ((AbstractOtherOwnerRightInfo)tmpInfo).setChangeDate(this.editData.getChangeDate());
                    return !ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)((AbstractObjectValue)tmpInfo), (AbstractObjectValue)this.editData);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void initData() throws EASBizException, BOSException {
        if (this.highMaintainLowLevel.equals("true")) {
            CompanyF7Helper.initCompanyBizUnitF7((KDBizPromptBox)this.prmtCompany, (boolean)false, (boolean)true, (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        } else {
            HashSet<String> disablePermSet = new HashSet<String>();
            disablePermSet.add(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            NewOrgViewF7PromptDialog f7 = CompanyF7Helper.getDisablePermCompanyBizUnitF7(disablePermSet);
            f7.setNeedAddOrgRange(false);
            this.prmtCompany.setSelector((KDPromptSelector)f7);
            this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
            this.prmtCompany.setEditable(true);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtCompany.setEntityViewInfo(view);
        }
        this.prmtCurrency.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.app.CslCurrencyQuery");
        this.prmtCurrency.setEditFormat("$number$");
        this.prmtCurrency.setDisplayFormat("$name$");
        this.prmtCurrency.setEditable(true);
        this.prmtCurrency.setCommitFormat("$number$");
        this.kdtEntries.getSelectManager().setSelectMode(10);
        this.mainTainRecord();
    }

    private void initPrecision() throws EASBizException, BOSException {
        CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getData();
        String numberFmt = CslRptUIUtil.getFmtStr(currency);
        IColumn column = this.kdtEntries.getColumn("fewStockholderAmount");
        column.getStyleAttributes().setNumberFormat(numberFmt);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column = this.kdtEntries.getColumn("changeMoney");
        column.getStyleAttributes().setNumberFormat(numberFmt);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column = this.kdtEntries.getColumn("fewStockholderAmount");
        column.getStyleAttributes().setNumberFormat(numberFmt);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column = this.kdtEntries.getColumn("changeMoney");
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column = this.kdtEntries.getColumn("fewStockholderRate");
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.btnAddNewLine.setEnabled(true);
        this.btnDeleteLine.setEnabled(true);
        this.btnInsertIntoLine.setEnabled(true);
        this.btnCalFewStockHolder.setEnabled(true);
        this.pkChangeDate.setEditable(true);
        if (this.getOprtState() == OprtState.ADDNEW) {
            Timestamp time = new Timestamp(System.currentTimeMillis());
            this.pkChangeDate.setValue((Object)time);
        }
        this.kdtEntries.getColumn("fewStockholderRate").setWidth(180);
        this.kdtEntries.getColumn("fewStockholderAmount").setWidth(180);
        this.kdtEntries.getColumn("fewStockholderRate").getStyleAttributes().setNumberFormat("0.0000000000000%");
    }

    private void mainTainRecord() throws EASBizException, BOSException {
        if (this.getUIContext().get("ID") != null) {
            String id = this.getUIContext().get("ID").toString();
            OtherOwnerRightInfo info = OtherOwnerRightFactory.getRemoteInstance().getOtherOwnerRightInfo("select trackRecordCreator where id='" + id + "'");
            String recordId = info.getTrackRecordCreator() == null ? "" : info.getTrackRecordCreator().getId().toString();
            boolean isCanMainTain = recordId.equals(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            if (isCanMainTain) {
                this.actionCopy.setEnabled(true);
                this.actionAddNew.setEnabled(true);
                if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
                    this.actionEdit.setEnabled(false);
                } else {
                    this.actionEdit.setEnabled(true);
                }
            } else {
                this.actionCopy.setEnabled(false);
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
            }
        }
    }

    private void initEntryTable() throws Exception {
        this.kdtEntries.checkParsed();
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
        bizBoxItem.setEditable(true);
        bizBoxItem.setEditFormat("$number$");
        bizBoxItem.setDisplayFormat("$name$");
        bizBoxItem.setCommitFormat("$number$");
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn(0).setRenderer((IBasicRender)avr);
        FilterInfo info = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (this.getList().size() != 0) {
            for (int i = 0; i < this.getList().size(); ++i) {
                info.getFilterItems().add(new FilterItemInfo("number", this.getList().get(i), CompareType.EQUALS));
                sbFormula.append("#");
                sbFormula.append(i);
                if (i == this.getList().size() - 1) continue;
                sbFormula.append(" or ");
            }
        } else {
            info.getFilterItems().add(new FilterItemInfo("control", (Object)new Integer(20), CompareType.LIKE));
            sbFormula.append("#0");
        }
        info.setMaskString(sbFormula.toString());
        viewInfo.setFilter(info);
        bizBoxItem.setEntityViewInfo(viewInfo);
        this.kdtEntries.getColumn(2).getStyleAttributes().setLocked(true);
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)bizBoxItem, null);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)bizBoxItem);
        this.getDetailTable().getColumn(0).setEditor((ICellEditor)itemEditor);
    }

    private void displayFormula(RPTItemInfo item, int level, Pattern pt, ArrayList list) throws Exception {
        String formula = item.getSumItemFormula();
        if (StringUtils.isEmpty((String)formula)) {
            return;
        }
        Matcher matcher = pt.matcher(formula);
        while (matcher.find()) {
            String oql;
            IRPTItem irptItem = RPTItemFactory.getRemoteInstance();
            item = irptItem.getRPTItemInfo(oql = " where number = '" + matcher.group(2) + "'");
            if (StringUtils.isEmpty((String)item.getSumItemFormula())) {
                if (list.contains(item.getNumber())) continue;
                list.add(item.getNumber());
                continue;
            }
            this.displayFormula(item, level + 1, pt, list);
        }
    }

    public void setList() {
        this.list.clear();
    }

    public ArrayList getList() {
        return this.list;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        Calendar ca = Calendar.getInstance();
        ca.setTime((Date)this.pkChangeDate.getValue());
        int year = ca.get(1);
        int month = ca.get(2);
        int day = ca.get(5);
        ca.set(year, month, day, 0, 0, 0);
        Timestamp stamp = new Timestamp(ca.getTimeInMillis());
        this.editData.setSyncOldValue(true);
        this.editData.setChangeDate(stamp);
        if (this.getUIContext() != null && this.getUIContext().get("isModify") == null) {
            this.editData.setTrackRecordCreator(SysContext.getSysContext().getCurrentFIUnit());
        } else if (this.getUIContext() != null && this.getUIContext().get("isModify") != null) {
            this.editData.setChangeDate(null);
            this.getUIContext().remove("isModify");
        }
        this.editData.setSyncOldValue(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        this.pkChangeDate.setValue((Object)time);
        this.setNaturalCurrency();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    public void actionAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    @Override
    public void actionInsertIntoLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    @Override
    public void actionCalFewStockHolder_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtCompany.getValue() != null && this.pkChangeDate.getSqlDate() != null) {
            if (!(this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo)) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"585_OtherOwnerRightEditUI"));
                return;
            }
            CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getData();
            String numberFmt = CslRptUIUtil.getFmtStr(currency);
            this.kdtEntries.getColumn("changeMoney").getStyleAttributes().setNumberFormat(numberFmt);
            String companyId = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
            BigDecimal mid = ((IOtherOwnerRight)this.getBizInterface()).calFewStockHolder(companyId, this.pkChangeDate.getSqlDate());
            BigDecimal result = new BigDecimal(100.0);
            result = result.subtract(mid);
            BigDecimal money = null;
            if (this.kdtEntries.getExpandedRowCount() == 0) {
                throw new AdjustException(AdjustException.LINE_NOT_EXIST);
            }
            int size = this.kdtEntries.getRowCount();
            BigDecimal hund = new BigDecimal(100.0);
            hund = hund.setScale(currency.getPrecision(), 4);
            BigDecimal rateResult = result.divide(hund, 15, 4);
            for (int i = 0; i < size; ++i) {
                this.kdtEntries.getRow(i).getCell(2).setValue((Object)rateResult);
                if (this.kdtEntries.getRow(i).getCell(1).getValue() == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"changeMoney_NotNull"));
                    continue;
                }
                if (this.prmtCurrency.getData() == null) {
                    throw new AdjustException(AdjustException.CURRENCY_BLANK);
                }
                money = new BigDecimal(this.kdtEntries.getRow(i).getCell(1).getValue().toString());
                this.kdtEntries.getRow(i).getCell(3).getStyleAttributes().setNumberFormat(numberFmt);
                this.kdtEntries.getRow(i).getCell(3).setValue((Object)money.multiply(rateResult));
            }
        } else if (this.prmtCompany.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"Select_OrgUnit"));
        } else if (this.pkChangeDate.getSqlDate() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"changeDate_IsNull"));
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"Select_OrgUnit"));
        }
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        return new OtherOwnerRightInfo();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new OtherOwnerRightEntryInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OtherOwnerRightFactory.getRemoteInstance();
    }

    public void HideButton() {
        this.btnPCVoucher.setVisible(false);
        this.btnDelPCVoucher.setVisible(false);
        this.actionPCVoucher.setVisible(false);
        this.actionDelPCVoucher.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnAddLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.btnVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.btnWFViewSubmitProccess.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnAttachment.setVisible(false);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.pkChangeDate.getValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ChangeDateIsNull")));
        }
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        if (this.getOprtState() == OprtState.ADDNEW) {
            Timestamp time = new Timestamp(System.currentTimeMillis());
            this.pkChangeDate.setValue((Object)time);
        }
    }

    private void setNaturalCurrency() {
        CurrencyInfo natureCurrency = CslClientHelper.getCUNaturalCurrency();
        if (natureCurrency != null) {
            this.prmtCurrency.setData((Object)natureCurrency);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection src = super.getSelectors();
        src.add(new SelectorItemInfo("trackRecordCreator"));
        return src;
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setControlStatus();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setControlStatus();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setControlStatus();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setControlStatus();
    }

    private void setControlStatus() {
        if (this.editData != null && this.editData.getId() != null) {
            String recordId = this.editData.getTrackRecordCreator() == null ? "" : this.editData.getTrackRecordCreator().getId().toString();
            boolean isCanMainTain = recordId.equals(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            if (isCanMainTain) {
                this.actionCopy.setEnabled(true);
                this.actionAddNew.setEnabled(true);
                this.actionRemove.setEnabled(true);
                if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
                    this.actionEdit.setEnabled(false);
                } else {
                    this.actionEdit.setEnabled(true);
                }
            } else {
                this.actionCopy.setEnabled(false);
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
        }
    }

    protected BOSObjectType getBOSObjectType() {
        return null;
    }
}

