/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.OtherOwnerRightFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractOtherOwnerRightListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.OtherOwnerRightEditUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class OtherOwnerRightListUI
extends AbstractOtherOwnerRightListUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherOwnerRightListUI.class);
    private String highMaintainLowLevel = "true";
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private boolean selfGradeOnly = false;

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    public OtherOwnerRightListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                OtherOwnerRightListUI.this.fillTable(e);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("entries.fewStockholderRate").getStyleAttributes().setNumberFormat("0.0000%");
        int maxPrecision = 2;
        KDTDefaultCellEditor editor = FMClientHelper.getCurrencyEditor((int)maxPrecision);
        String numberFmt = FMClientHelper.getNumberFtm((int)maxPrecision);
        this.tblMain.getColumn("entries.fewStockholderAmount").getStyleAttributes().setNumberFormat(numberFmt);
        this.tblMain.getColumn("entries.fewStockholderAmount").setEditor((ICellEditor)editor);
        this.tblMain.getColumn("entries.changeMoney").getStyleAttributes().setNumberFormat(numberFmt);
        this.tblMain.getColumn("entries.changeMoney").setEditor((ICellEditor)editor);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn(0).setGroup(true);
        this.tblMain.getColumn(1).setGroup(true);
        this.tblMain.getColumn(2).setGroup(true);
        this.tblMain.getColumn(3).setGroup(true);
        this.tblMain.getColumn(0).setMergeable(true);
        this.tblMain.getColumn(1).setMergeable(true);
        this.tblMain.getColumn(2).setMergeable(true);
        this.tblMain.getColumn(3).setMergeable(true);
        this.hidButton();
        this.menuItemLocate.setVisible(false);
        this.btnLocate.setVisible(false);
        this.refresh(null);
        this.addSeletedChangedListener();
        CslGradeManageUtil.showBtnByCurrentOrg((KDWorkButton)this.btnUpdateMaintainOrg);
    }

    private void addSeletedChangedListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    OtherOwnerRightListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    OtherOwnerRightListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.changeBtnSateByCreateCompany();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = e.getLastRow();
        for (int i = e.getFirstRow(); i <= n; ++i) {
            Object recordCreatorid = this.tblMain.getRow(i).getCell("trackRecordCreatorid").getValue();
            if (recordCreatorid == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    private void changeBtnSateByCreateCompany() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (!this.tblMain.getRow(selectRow).getCell("trackRecordCreatorid").getValue().toString().equals(this.company.getId().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected String getEditUIName() {
        return OtherOwnerRightEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OtherOwnerRightFactory.getRemoteInstance();
    }

    protected void hidButton() {
        this.menuWorkFlow.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.btnCopyTo.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.menuBiz.setVisible(false);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FI_GR_CSLREPORT;
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            boolean isCanMainTain = CslRptUIUtil.checkCanMainTain(this.highMaintainLowLevel, row, (OrgUnitInfo)this.company);
            if (isCanMainTain) {
                super.actionEdit_actionPerformed(e);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"533_InvestDayListUI"));
                SysUtil.abort();
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String format;
        super.actionQuery_actionPerformed(e);
        this.tblMain.removeRows();
        String dateTime = CslRptUIUtil.getNationalTimeFormatString();
        if (dateTime != null) {
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(dateTime);
            this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(dateTime);
        }
        if ((format = CslRptUIUtil.getNationalDateFormatString()) != null) {
            this.tblMain.getColumn("changeDate").getStyleAttributes().setNumberFormat(format);
        }
        this.refreshList();
    }

    protected ArrayList getSelectedIdValues() {
        return CslClientHelper.getSelectedConditionalIdValues(super.getSelectedIdValues(), this.tblMain, "trackRecordCreatorid", this.company.getId().toString(), this.getKeyFieldName(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"534_InvestDayListUI"), true);
    }

    protected BOSObjectType getBOSObjectType() {
        return null;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return CslRptUtil.getCurrentChckPermOrgPk(action);
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.changeFilterByFlag();
        this.actionRefresh_actionPerformed(e);
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("TRACKRECORDCREATOR", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"TRACKRECORDCREATOR".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub((FilterInfo)filterInfo, (String)"TRACKRECORDCREATOR", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"TRACKRECORDCREATOR", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg((String)"T_CSL_OtherOwnerRight", (String)"FTrackRecordCreatorID", (ArrayList)super.getSelectedIdValues());
        this.actionRefresh_actionPerformed(e);
    }
}

