/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRPTInterItemDataFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;

public class RPTInterItemDataFilterUI
extends AbstractRPTInterItemDataFilterUI {
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private ICSLContext ctx = null;

    public RPTInterItemDataFilterUI() throws Exception {
        this.init();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("company.name"));
        sorter.add(new SorterItemInfo("currency.name"));
        sorter.add(new SorterItemInfo("targetCurrency.name"));
        sorter.add(new SorterItemInfo("targetCompany.name"));
        sorter.add(new SorterItemInfo("itemNumber"));
        return sorter;
    }

    public FilterInfo getFilterInfo() {
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        try {
            FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.id", (Object)this.ctx.getCurOrgBound().getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItem1 = new FilterItemInfo("periodType", (Object)new Integer(this.ctx.getCurRptPeriodType().getValue()), CompareType.EQUALS);
            FilterItemInfo filterItem2 = new FilterItemInfo("year", (Object)new Integer(this.ctx.getCurRptYear()), CompareType.EQUALS);
            FilterItemInfo filterItem3 = new FilterItemInfo("period", (Object)new Integer(this.ctx.getCurRptPeriod()), CompareType.EQUALS);
            FilterItemInfo filterItem4 = new FilterItemInfo("commitedStatus", (Object)new Integer(3), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem0);
            sbFormula.append(" #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem3);
            sbFormula.append(" and #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem4);
            sbFormula.append(" and #" + formulaIndex++);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (this.comboCurrency.getSelectedItem() != null && !this.comboCurrency.getSelectedItem().toString().equals(this.selectAll)) {
            FilterItemInfo filterItemInfo1 = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemInfo1);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboTargetCurrency.getSelectedItem() != null && !this.comboTargetCurrency.getSelectedItem().toString().equals(this.selectAll)) {
            FilterItemInfo filterItemInfo2 = new FilterItemInfo("targetCurrency.id", (Object)((CurrencyInfo)this.comboTargetCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemInfo2);
            sbFormula.append(" and #" + formulaIndex++);
        }
        try {
            OrgUnitInfo uif = this.bizPrmtCompany.getData() != null ? (OrgUnitInfo)this.bizPrmtCompany.getData() : this.ctx.getCurOrgGroup();
            if (uif.isIsGrouping()) {
                CustomerParams cp = new CustomerParams();
                cp.addCustomerParam("FullOrgUnitID", uif.getId().toString());
                this.setCustomerParams(cp);
                ArrayList arr = CslRptUtil.getAuthenticUnits(this.ctx.getCurOrgBound().getId().toString(), uif.getId().toString(), (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.client", "RPTInterItemDataListUI"), (IMetaDataPK)new MetaDataPK("actionView"), 1);
                OrgUnitInfo ouif = null;
                int n = arr.size();
                if (n > 0) {
                    sbFormula.append(" and (");
                }
                for (int i = 0; i < n; ++i) {
                    ouif = (OrgUnitInfo)arr.get(i);
                    if (i > 0) {
                        sbFormula.append("\tor \t");
                    }
                    String companyId = ouif.getId().toString();
                    FilterItemInfo filterItemCompany = new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS);
                    this.filterInfo.getFilterItems().add(filterItemCompany);
                    FilterItemInfo filterItemTgtCompany = new FilterItemInfo("targetCompany.id", (Object)companyId, CompareType.EQUALS);
                    this.filterInfo.getFilterItems().add(filterItemTgtCompany);
                    sbFormula.append(" ( #").append(formulaIndex++).append(" or  #").append(formulaIndex++).append(" )");
                }
                if (n > 0) {
                    sbFormula.append(" )");
                }
            } else {
                this.setCustomerParams(null);
                String companyId = uif.getId().toString();
                FilterItemInfo filterItemCompany = new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemCompany);
                FilterItemInfo filterItemTgtCompany = new FilterItemInfo("targetCompany.id", (Object)companyId, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemTgtCompany);
                sbFormula.append("  and ( #" + formulaIndex++).append(" or #").append(formulaIndex++).append(" )");
            }
        }
        catch (EASBizException e2) {
            this.handUIException(e2);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void init() {
        this.ctx = CSLContextHelper.getCSLContext();
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.comboCurrency.addItem((Object)this.selectAll);
        this.comboCurrency.setSelectedIndex(0);
        this.comboTargetCurrency.addItem((Object)this.selectAll);
        this.comboTargetCurrency.setSelectedIndex(0);
        CurrencyCollection currencyCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(viewInfo, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.comboCurrency.addItem((Object)currencyCollection.get(i));
                this.comboTargetCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        try {
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
            f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
            f7.setCtrlUnitPK(this.ctx.getCurOrgBound().getCU());
            f7.setMultiSelect(false);
            this.bizPrmtCompany.setSelector((KDPromptSelector)f7);
            this.bizPrmtCompany.setEditable(true);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private void clearUI() {
        this.bizPrmtCompany.setData(null);
        this.comboCurrency.setSelectedItem((Object)this.selectAll);
        this.comboTargetCurrency.setSelectedItem((Object)this.selectAll);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        block4: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            CurrencyInfo currencyInfo;
            String currencyId;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.comboCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.comboCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.comboCurrency.setSelectedIndex(j);
                    continue block4;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("targetCurrency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.comboTargetCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.comboTargetCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.comboTargetCurrency.setSelectedIndex(j);
                    continue block4;
                }
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("company.id") && !filterItemInfo.getPropertyName().equalsIgnoreCase("targetCompany.id")) continue;
            String companyId = (String)filterItemInfo.getCompareValue();
            try {
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                this.bizPrmtCompany.setData((Object)companyInfo);
                continue;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.getCustomerParams() != null) {
            CustomerParams cp = this.getCustomerParams();
            String cu = cp.getCustomerParam("FullOrgUnitID");
            try {
                this.bizPrmtCompany.setData((Object)FullOrgUnitFactory.getRemoteInstance().getCollection("where id='" + cu + "'"));
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
    }
}

