/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCheckResultTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.FormulaDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRPTItemCheckFormulaEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CheckFormulaIfClauseUtil;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RPTItemCheckFormulaEditUI
extends AbstractRPTItemCheckFormulaEditUI
implements IFormulaPickerListener {
    String uiTitle = "CheckFormula_UITitle";
    boolean isLeft = true;
    private boolean isCopyNew = false;

    public void onLoad() throws Exception {
        this.menuSubmitOption.setVisible(false);
        this.menuBiz.setVisible(false);
        this.cbxOperateSymbol.removeAllItems();
        this.cbxOperateSymbol.addItem((Object)OperateSymbolEnum.EQUAL);
        this.cbxOperateSymbol.addItem((Object)OperateSymbolEnum.MORE);
        this.cbxOperateSymbol.addItem((Object)OperateSymbolEnum.LESS);
        this.cbxOperateSymbol.addItem((Object)OperateSymbolEnum.MOREANDEQUAL);
        this.cbxOperateSymbol.addItem((Object)OperateSymbolEnum.LESSANDEQUAL);
        this.cbxOperateSymbol.addItem((Object)OperateSymbolEnum.UNEQUAL);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        super.onLoad();
        this.btnLFormula.setToolTipText(this.resHelper.getString("btnLFormula.text"));
        this.btnRFormula.setToolTipText(this.resHelper.getString("btnRFormula.text"));
        this.btnLFormula.setIcon(EASResource.getIcon((String)"imgTbtn_formulaguide"));
        this.btnRFormula.setIcon(EASResource.getIcon((String)"imgTbtn_formulaguide"));
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
            this.btnLFormula.setEnabled(false);
            this.btnRFormula.setEnabled(false);
            this.txtLformula.setEditable(false);
            this.txtRformula.setEditable(false);
            this.btnFormulaWizard.setEnabled(false);
            this.btnValidityCheck.setEnabled(false);
            this.btnForbidSub.setEnabled(false);
            this.btnShowError.setEnabled(false);
            this.btnPostil.setEnabled(false);
        } else if ("EDIT".equals(this.oprtState)) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
            this.btnFormulaWizard.setEnabled(true);
            this.btnValidityCheck.setEnabled(true);
        }
        this.fmtTextRange.setDataType(1);
        this.fmtTextRange.setPrecision(4);
        this.txtPrompt.setMaxLength(200);
        if (this.getUIContext().get("COPY_NEW") != null) {
            this.editData.setId(null);
            this.txtName.setText(null);
            this.txtNumber.setText(null);
            this.actionRemove.setEnabled(false);
            this.editData.setName(null);
            this.editData.setNumber(null);
            this.isCopyNew = true;
        }
        this.initButton();
    }

    private void initButton() {
        this.btnFormulaWizard.setIcon(EASResource.getIcon((String)"imgTbtn_importformulaguide"));
        this.btnValidityCheck.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.kDLabel1.setLocation(this.kDLabel1.getX(), this.kDLabel1.getY() - 20);
        this.btnFormulaWizard.setLocation(this.btnFormulaWizard.getX(), this.btnFormulaWizard.getY() - 20);
        this.btnValidityCheck.setLocation(this.btnValidityCheck.getX(), this.btnValidityCheck.getY() - 20);
        this.kDScrollPane1.setBounds(this.kDScrollPane1.getX(), this.kDScrollPane1.getY() - 20, this.kDScrollPane1.getWidth(), this.kDScrollPane1.getHeight() + 20);
        if (this.f7MaintainCU.getData() == null) {
            this.f7MaintainCU.setData((Object)SysContext.getSysContext().getCurrentCtrlUnit());
        }
        if (this.getUIContext().get("maintainCU") != null) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.btnFormulaWizard.setEnabled(false);
            this.btnValidityCheck.setEnabled(false);
            this.txtAdvance.setEnabled(false);
            this.btnLFormula.setEnabled(false);
            this.btnRFormula.setEnabled(false);
            this.txtLformula.setEnabled(false);
            this.txtRformula.setEnabled(false);
            this.cbxOperateSymbol.setEnabled(false);
            this.fmtTextRange.setEnabled(false);
            this.btnForbidSub.setEnabled(false);
            this.btnShowError.setEnabled(false);
            this.btnPostil.setEnabled(false);
            this.txtPrompt.setEnabled(false);
            this.actionSubmit.setEnabled(true);
            this.actionAddNew.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionFirst.setEnabled(false);
            this.actionPre.setEnabled(false);
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
            this.f7MaintainCU.setEnabled(true);
        }
    }

    protected IObjectValue createNewData() {
        RPTItemCheckFormulaInfo info = new RPTItemCheckFormulaInfo();
        info.setOperateSymbol(OperateSymbolEnum.EQUAL);
        info.setRange(new BigDecimal("0"));
        if (this.f7MaintainCU.getData() == null) {
            this.f7MaintainCU.setData((Object)SysContext.getSysContext().getCurrentCtrlUnit());
        }
        info.setMaintainCU((CtrlUnitInfo)this.f7MaintainCU.getData());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RPTItemCheckFormulaFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fmtTextRange.setValue((Object)this.editData.getRange());
        if (this.editData.getCheckResult() != null) {
            int selected = this.editData.getCheckResult().getValue();
            switch (selected) {
                case 1: {
                    this.btnForbidSub.setSelected(true);
                    break;
                }
                case 2: {
                    this.btnShowError.setSelected(true);
                    break;
                }
                case 3: {
                    this.btnPostil.setSelected(true);
                }
            }
        } else {
            this.btnForbidSub.setSelected(true);
            this.editData.setCheckResult(FormulaCheckResultTypeEnum.UNCONFIRM);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtNumber.setText(null);
            this.txtName.setText(null);
        }
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        this.addCreatrOrg();
        super.storeFields();
        if (this.editData == null) {
            return;
        }
        this.editData.setRFormula(this.txtRformula.getText());
        this.editData.setRange(this.fmtTextRange.getBigDecimalValue() == null ? new BigDecimal("0.0") : new BigDecimal(this.fmtTextRange.getBigDecimalValue().toString()));
    }

    private void addCreatrOrg() {
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnLFormula.setEnabled(true);
        this.btnRFormula.setEnabled(true);
        this.txtLformula.setEditable(true);
        this.txtRformula.setEditable(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnLFormula.setEnabled(true);
        this.btnRFormula.setEnabled(true);
        this.txtLformula.setEditable(true);
        this.txtRformula.setEditable(true);
        if (this.f7MaintainCU.getData() == null) {
            this.f7MaintainCU.setData((Object)SysContext.getSysContext().getCurrentCtrlUnit());
        }
    }

    private boolean checkExistsFormula(Expression stmt, String formula) {
        Expression expr;
        if (stmt instanceof FunctionExpr) {
            String funName = ((FunctionExpr)stmt).funcionName;
            if (funName.equalsIgnoreCase(formula)) {
                return true;
            }
        } else if (stmt instanceof BinaryOperationExpr) {
            Expression expr2 = ((BinaryOperationExpr)stmt).left;
            if (this.checkExistsFormula(expr2, formula)) {
                return true;
            }
            expr2 = ((BinaryOperationExpr)stmt).right;
            if (this.checkExistsFormula(expr2, formula)) {
                return true;
            }
        } else if (stmt instanceof UnaryOperationExpr && this.checkExistsFormula(expr = ((UnaryOperationExpr)stmt).operand, formula)) {
            return true;
        }
        return false;
    }

    private List checkFormulaFormat(Expression stmt) throws CheckFormulaException {
        ArrayList<String> result;
        block17: {
            block15: {
                block20: {
                    List param;
                    String item;
                    String funName;
                    block19: {
                        block18: {
                            block16: {
                                result = new ArrayList<String>();
                                if (!(stmt instanceof FunctionExpr)) break block15;
                                funName = ((FunctionExpr)stmt).funcionName;
                                item = null;
                                FunctionExpr expr = (FunctionExpr)stmt;
                                param = expr.parameters;
                                if (!funName.equalsIgnoreCase("AcctItem")) break block16;
                                item = ((StringExpr)param.get((int)4)).value;
                                if (StringUtils.isEmpty((String)item)) {
                                    throw new CheckFormulaException(CheckFormulaException.ITEM_BLANK);
                                }
                                if (!result.contains(item)) {
                                    result.add(item);
                                }
                                if (StringUtils.isEmpty((String)(item = ((StringExpr)param.get((int)5)).value))) {
                                    throw new CheckFormulaException(CheckFormulaException.ITEM_BLANK);
                                }
                                if (result.contains(item)) break block17;
                                result.add(item);
                                break block17;
                            }
                            if (!funName.equalsIgnoreCase("DyItem")) break block18;
                            item = ((StringExpr)param.get((int)4)).value;
                            if (StringUtils.isEmpty((String)item)) {
                                throw new CheckFormulaException(CheckFormulaException.ITEM_BLANK);
                            }
                            if (result.contains(item)) break block17;
                            result.add(item);
                            break block17;
                        }
                        if (!funName.equalsIgnoreCase("Item") && !funName.equalsIgnoreCase("DItem")) break block19;
                        item = ((StringExpr)param.get((int)0)).value;
                        if (StringUtils.isEmpty((String)item)) {
                            throw new CheckFormulaException(CheckFormulaException.ITEM_BLANK);
                        }
                        if (!result.contains(item)) {
                            result.add(item);
                        }
                        for (int i = 0; i < param.size(); ++i) {
                            Object obj = param.get(i);
                            if (!(obj instanceof FunctionExpr) && !(obj instanceof BinaryOperationExpr)) continue;
                            throw new CheckFormulaException(CheckFormulaException.ITEMNOTCONTAINFORMULA);
                        }
                        break block17;
                    }
                    if (!funName.equalsIgnoreCase("HisRateData")) break block20;
                    item = ((StringExpr)param.get((int)3)).value;
                    if (StringUtils.isEmpty((String)item)) {
                        throw new CheckFormulaException(CheckFormulaException.ITEM_BLANK);
                    }
                    if (result.contains(item)) break block17;
                    result.add(item);
                    break block17;
                }
                throw new CheckFormulaException(CheckFormulaException.CONTAINVALIDFORMULA);
            }
            if (stmt instanceof BinaryOperationExpr) {
                String item;
                int i;
                String operation = ((BinaryOperationExpr)stmt).getOperation();
                if (!this.isvalidOperation(operation)) {
                    throw new CheckFormulaException(CheckFormulaException.INVALIDOPERATION);
                }
                Expression expr = ((BinaryOperationExpr)stmt).left;
                List list = this.checkFormulaFormat(expr);
                for (i = 0; i < list.size(); ++i) {
                    item = (String)list.get(i);
                    if (result.contains(item)) continue;
                    result.add(item);
                }
                expr = ((BinaryOperationExpr)stmt).right;
                list = this.checkFormulaFormat(expr);
                for (i = 0; i < list.size(); ++i) {
                    item = (String)list.get(i);
                    if (result.contains(item)) continue;
                    result.add(item);
                }
            } else if (stmt instanceof UnaryOperationExpr) {
                Expression expr = ((UnaryOperationExpr)stmt).operand;
                List list = this.checkFormulaFormat(expr);
                for (int i = 0; i < list.size(); ++i) {
                    String item = (String)list.get(i);
                    if (result.contains(item)) continue;
                    result.add(item);
                }
            }
        }
        return result;
    }

    private boolean isvalidOperation(String operation) {
        return "+".equals(operation) || "-".equals(operation) || "*".equals(operation) || "/".equals(operation);
    }

    private void checkFormulaFormat(String formulaString) throws CheckFormulaException, BOSException {
        Expression stmt;
        try {
            stmt = ExcelFormulaPaserHelper.parse((String)formulaString);
        }
        catch (Exception e) {
            throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, e);
        }
        List items = this.checkFormulaFormat(stmt);
        if (items.size() <= 0) {
            throw new CheckFormulaException(CheckFormulaException.CHECKFORMULA_MUSTHAVEITEM_29);
        }
        CslRptUtil.checkFormulaItemExists(null, items, CheckFormulaException.RPTITEMNOTEXISTS);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String exceptionStr;
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().equals("")) {
            throw new CheckFormulaException(CheckFormulaException.NUMBER_BLANK);
        }
        if (this.editData.getName() == null || this.editData.getName().trim().equals("")) {
            throw new CheckFormulaException(CheckFormulaException.NAME_BLANK);
        }
        if ("EDIT".equals(this.oprtState)) {
            boolean isExist;
            String id = this.editData.getId().toString();
            RPTItemCheckFormulaInfo oldInfo = RPTItemCheckFormulaFactory.getRemoteInstance().getRPTItemCheckFormulaInfo((IObjectPK)new ObjectUuidPK(id));
            String oldNumber = oldInfo.getNumber();
            String oldName = oldInfo.getName();
            String newNumber = this.editData.getNumber();
            String newName = this.editData.getName();
            if (!(oldNumber.equals(newNumber) && oldName.equals(newName) || !(isExist = FormulaDispenseFactory.getRemoteInstance().exists("select id where checkFormula = '" + id + "'")))) {
                throw new CheckFormulaException(CheckFormulaException.ITEMCHECKFORMULA_DISPENSED);
            }
        }
        if (this.editData.getMaintainCU() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"629_RPTItemCheckFormulaEditUI"));
            SysUtil.abort();
        }
        if (this.editData.getLFormula() == null || this.editData.getLFormula().trim().equals("")) {
            throw new CheckFormulaException(CheckFormulaException.LFORMULA_BLANK);
        }
        if (this.editData.getRFormula() == null || this.editData.getRFormula().trim().equals("")) {
            throw new CheckFormulaException(CheckFormulaException.RFORMULA_BLANK);
        }
        try {
            this.checkFormulaFormat(this.editData.getLFormula());
        }
        catch (CheckFormulaException e1) {
            exceptionStr = e1.getMessage();
            if (!StringUtils.isEmpty((String)e1.getMessage())) {
                exceptionStr = MessageFormat.format(exceptionStr, this.editData.getLFormula());
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, (Throwable)((Object)e1), new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"808_RPTItemCheckFormulaEditUI")}).getMessage(), (String)exceptionStr, (int)0);
            SysUtil.abort();
        }
        try {
            this.checkFormulaFormat(this.editData.getRFormula());
        }
        catch (CheckFormulaException e1) {
            exceptionStr = e1.getMessage();
            if (!StringUtils.isEmpty((String)e1.getMessage())) {
                exceptionStr = MessageFormat.format(exceptionStr, this.editData.getRFormula());
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, (Throwable)((Object)e1), new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"809_RPTItemCheckFormulaEditUI")}).getMessage(), (String)exceptionStr, (int)0);
            SysUtil.abort();
        }
    }

    public void pickerSetout(FormulaPickerUI picker) {
    }

    public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
        if (isOk && this.isLeft) {
            this.txtLformula.setText(this.txtLformula.getText() + formulaLine);
        } else if (isOk && !this.isLeft) {
            this.txtRformula.setText(this.txtRformula.getText() + formulaLine);
        }
    }

    @Override
    public void actionLFormula_actionPerformed(ActionEvent e) throws Exception {
        this.isLeft = true;
        FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
        picker.addFormulaPickerListener((IFormulaPickerListener)this);
        picker.setFilter("include:categorys{CslRptFormula},groups{5},formulas{Item,DItem}");
        picker.setFilter("include:categorys{CslRptFormula},groups{6},formulas{AcctItem,DyItem,HisRateData}");
        picker.open();
    }

    @Override
    public void actionRFormula_actionPerformed(ActionEvent e) throws Exception {
        this.isLeft = false;
        FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
        picker.addFormulaPickerListener((IFormulaPickerListener)this);
        picker.setFilter("include:categorys{CslRptFormula},groups{5},formulas{Item,DItem}");
        picker.setFilter("include:categorys{CslRptFormula},groups{6},formulas{AcctItem,DyItem,HisRateData}");
        picker.open();
    }

    @Override
    public void actionFormulaWizard_actionPerformed(ActionEvent e) throws Exception {
        super.actionFormulaWizard_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"textArea", (Object)this.txtAdvance);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FormulaWizardUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionValidityCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionValidityCheck_actionPerformed(e);
        CheckFormulaIfClauseUtil.checkIfClause(this.txtAdvance.getText());
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CheckFormula", (String)"CheckSuccesfull"));
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("maintainCU") != null) {
            this.verify(e);
            RPTItemCheckFormulaFactory.getRemoteInstance().updateMaintainCU(this.editData.getId().toString(), this.editData.getMaintainCU().getId().toString());
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
            IObjectValue subMitValue = this.getValue((IObjectPK)pk);
            this.getUIContext().put("ID", pk.toString());
            this.getUIContext().put("InitDataObject", subMitValue);
            this.setSave(true);
            this.setSaved(true);
            this.afterSubmitEdit((IObjectPK)new ObjectStringPK(this.editData.getId().toString()));
            return;
        }
        if (this.btnForbidSub.isSelected()) {
            this.editData.setCheckResult(FormulaCheckResultTypeEnum.UNCONFIRM);
        }
        if (this.btnShowError.isSelected()) {
            this.editData.setCheckResult(FormulaCheckResultTypeEnum.SHOWERROR);
        }
        if (this.btnPostil.isSelected()) {
            this.editData.setCheckResult(FormulaCheckResultTypeEnum.HASPOSTIL);
        }
        CheckFormulaIfClauseUtil.checkIfClause(this.txtAdvance.getText());
        super.actionSubmit_actionPerformed(e);
        this.isCopyNew = false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("CheckResult"));
        sic.add(new SelectorItemInfo("trackRecordCreator"));
        return sic;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnFormulaWizard.setEnabled(true);
        this.btnValidityCheck.setEnabled(true);
        this.btnForbidSub.setEnabled(true);
        this.btnShowError.setEnabled(true);
        this.btnPostil.setEnabled(true);
        this.btnLFormula.setEnabled(true);
        this.btnRFormula.setEnabled(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public boolean isModify() {
        if (this.isCopyNew) {
            return true;
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        if (!(!OprtState.ADDNEW.equals(this.getOprtState()) || StringUtils.isEmpty((String)this.txtName.getText()) && StringUtils.isEmpty((String)this.txtNumber.getText()) && StringUtils.isEmpty((String)this.txtPrompt.getText()) && StringUtils.isEmpty((String)this.txtLformula.getText()) && StringUtils.isEmpty((String)this.txtRformula.getText()) && StringUtils.isEmpty((String)this.txtAdvance.getText()))) {
            return true;
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            return super.isModify();
        }
        return false;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof UINewFrame) {
            UINewFrame uiFrame = (UINewFrame)this.getUIWindow();
            uiFrame.setResizable(false);
        }
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (!b) {
            RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
        }
        return b;
    }
}

