/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractReceiveImportWizardPage3UI;
import com.kingdee.eas.fi.gr.cslrpt.client.ReceiveImportWizard;
import com.kingdee.eas.fi.gr.cslrpt.util.DispensePropertyHelper;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class ReceiveImportWizardPage3UI
extends AbstractReceiveImportWizardPage3UI {
    private ArrayList filesList = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Icon getImage() {
        return ReceiveImportWizard.getWizardImage();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void loadPage() {
        super.loadPage();
        this.tblFileList.getSelectManager().setSelectMode(10);
        this.lblHint.setText(DispensePropertyHelper.getString("Dispense_Import_Doing_Caption", null));
        this.filesList = this.getMyWizard().getFilesToImport();
        this.tblFileList.setRefresh(false);
        this.tblFileList.removeRows();
        this.tblFileList.getStyleAttributes().setLocked(true);
        this.tblFileList.addRows(this.filesList.size());
        for (int i = 0; i < this.filesList.size(); ++i) {
            File file = (File)this.filesList.get(i);
            this.tblFileList.getCell(i, "name").setValue((Object)file.getName());
        }
        this.tblFileList.getStyleAttributes().setBackground(new Color(240, 240, 240));
        this.tblFileList.setRefresh(true);
        ArrayList list = this.getMyWizard().getFilesToImport();
        DispensePropertyHelper helper = new DispensePropertyHelper();
        String result = null;
        CslReportInfo cslReport = null;
        ArrayList<CslReportInfo> reportList = new ArrayList<CslReportInfo>();
        ArrayList<Integer> positionList = new ArrayList<Integer>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                cslReport = new CslReportInfo();
                result = helper.output((File)list.get(i), cslReport);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
            if (result == null) {
                reportList.add(cslReport);
                positionList.add(new Integer(i));
            } else {
                this.fill_tblFileList(false, i, result, cslReport);
            }
            this.tblFileList.getColumn("dataCollect").setWidth(80);
        }
        this.checkCslReportList(reportList, positionList);
        this.lblHint.setText(DispensePropertyHelper.getString("Dispense_Import_Finish_Caption", null));
    }

    private void fill_tblFileList(boolean isOk, int i, String result, CslReportInfo cslReport) {
        if (isOk) {
            this.tblFileList.getRow(i).getStyleAttributes().setBackground(Color.WHITE);
        }
        this.tblFileList.getCell(i, "result").setValue((Object)result);
        if (cslReport != null) {
            this.tblFileList.getCell(i, "report").setValue((Object)cslReport.getName());
            this.tblFileList.getCell(i, "company").setValue((Object)cslReport.getOrgUnit());
            this.tblFileList.getCell(i, "periodType").setValue((Object)cslReport.getPeriodType());
            this.tblFileList.getCell(i, "year").setValue((Object)new Integer(cslReport.getYear()));
            this.tblFileList.getCell(i, "period").setValue((Object)new Short(cslReport.getPeriod()));
            this.tblFileList.getCell(i, "currency").setValue((Object)cslReport.getCurrency());
            this.tblFileList.getCell(i, "lastUpdateTime").setValue(cslReport.get("EXCEL_DATE"));
        }
        if (!isOk) {
            KDTMergeManager mergeManager = this.tblFileList.getMergeManager();
            int resultIndex = this.tblFileList.getColumnIndex("result");
            int colCount = this.tblFileList.getColumnCount();
            mergeManager.mergeBlock(i, resultIndex, i, colCount);
        }
    }

    private void checkCslReportList(List reportList, List positionList) {
        if (reportList.isEmpty()) {
            return;
        }
        try {
            Map returnMap = CheckFormulaFactory.getRemoteInstance().checkCslReportList(reportList, -1);
            List checkResult = (List)returnMap.get("checkResult");
            CslReportInfo cslReport = null;
            for (int i = 0; i < reportList.size(); ++i) {
                String result;
                cslReport = (CslReportInfo)reportList.get(i);
                int position = (Integer)positionList.get(i);
                Boolean ispass = (Boolean)checkResult.get(i);
                if (ispass.booleanValue()) {
                    result = DispensePropertyHelper.getString("Dispense_Import_OK");
                    this.fill_tblFileList(true, position, result, cslReport);
                    continue;
                }
                result = DispensePropertyHelper.getCSLRPTAutoGenerateResource("764_DispensePropertyHelper", null);
                this.fill_tblFileList(false, position, result, cslReport);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    private ReceiveImportWizard getMyWizard() {
        return (ReceiveImportWizard)super.getWizard();
    }

    public ArrayList getFilesVerified() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.filesList.size(); ++i) {
            if (!Boolean.TRUE.equals(this.tblFileList.getCell(i, "select").getValue())) continue;
            list.add(this.filesList.get(i));
        }
        return list;
    }
}

