/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.MAGroupFactory;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.MAGroupOrgFacadeFactory;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.client.MAGroupReF7;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.MessageTemplateFactory;
import com.kingdee.eas.fi.gr.cslrpt.MessageTemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractReceiveReportMessageSenderUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MailMessageTemplateUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageTemplateUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ReportFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SMSMessageTemplateUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.SendMail;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ReceiveReportMessageSenderUI
extends AbstractReceiveReportMessageSenderUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveReportMessageSenderUI.class);
    private HashMap filterMap = null;
    private boolean isMergeByFiscalPeriod;
    private boolean isSupportOtherDS = false;
    private boolean isSupport13Period = false;
    private HashMap companyMap = new HashMap();
    private CommonQueryDialog conditionDialog = null;

    public ReceiveReportMessageSenderUI() throws Exception {
        boolean[] values = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_SupportOtherDS", "GR_CSL_Support13Period", "GR_CSL_MergeByFiscalPeriod"});
        this.isSupportOtherDS = values[0];
        this.isSupport13Period = values[1];
        this.isMergeByFiscalPeriod = values[2];
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource.cb");
    }

    private void isHideDataCollect() throws EASBizException, BOSException {
        if (this.isSupportOtherDS) {
            this.kDTable1.getColumn("dcfname").setWidth(60);
        } else {
            this.kDTable1.getColumn("dcfname").getStyleAttributes().setHided(true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnReceiverSet.setVisible(false);
        this.btnClearAll.setEnabled(true);
        this.btnEmail.setEnabled(true);
        this.btnEmailEdit.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.btnReceiverSet.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnSMS.setEnabled(true);
        this.btnSMSEdit.setEnabled(true);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnEmail.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
        this.btnSMS.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
        this.btnMessage.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
        this.btnSMSEdit.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.btnEmailEdit.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.btnMessageEdit.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        MAGroupReF7 mAGroupReF7 = new MAGroupReF7((IUIObject)this);
        this.kDBizPromptBox1.setSelector((KDPromptSelector)mAGroupReF7);
        ArrayList list = (ArrayList)this.getUIContext().get("REPORT_LIST");
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                HashMap data = (HashMap)list.get(i);
                if (data.get("YEAR") != null) {
                    data.put("YEAR", new Integer(Integer.parseInt(data.get("YEAR").toString())));
                }
                if (data.get("PERIOD") != null) {
                    data.put("PERIOD", new Integer(Integer.parseInt(data.get("PERIOD").toString())));
                }
                if (data.get("PERIODTYPE") != null) {
                    data.put("PERIODTYPE", new Integer(Integer.parseInt(data.get("PERIODTYPE").toString())));
                }
                if (data.get("COMMITTEDSTATUS") != null) {
                    data.put("COMMITTEDSTATUS", new Integer(Integer.parseInt(data.get("COMMITTEDSTATUS").toString())));
                }
                if (data.get("SOURCETYPE") == null) continue;
                data.put("SOURCETYPE", new Integer(Integer.parseInt(data.get("SOURCETYPE").toString())));
            }
        }
        this.initTable();
        this.isHideDataCollect();
        this.addSendEmailWindowKeyListener();
    }

    private void addSendEmailWindowKeyListener() {
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(119, 3);
            inputMap.put(keyStroke, "debuglogger");
            actionMap.remove("debuglogger");
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReceiveReportMessageSenderUI.this.setDebuglogger();
                }
            };
            actionMap.put("debuglogger", action);
        }
    }

    private void setDebuglogger() {
        if (!DebugLogger.isDebug) {
            DebugLogger.isDebug = true;
            this.setMessageText(" Debug Send Email is Open ");
        } else {
            DebugLogger.isDebug = false;
            this.setMessageText(" Debug Send Email is Off ");
        }
        try {
            ReportFactory.getRemoteInstance().setDebugLogger(DebugLogger.isDebug);
            this.showMessage();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initTable() {
        this.kDTable1.checkParsed();
        for (int i = 1; i < 9; ++i) {
            this.getTable().getColumn(i).getStyleAttributes().setLocked(true);
        }
        this.getTable().getColumn("1").setEditor((ICellEditor)new EditorFactory.BooleanEditor());
        Integer defaultYear = new Integer(Integer.parseInt(this.getUIContext().get("YEAR").toString()));
        Integer defaultPeriod = new Integer(Integer.parseInt(this.getUIContext().get("PERIOD").toString()));
        String CurrencyName = (String)this.getUIContext().get("CURRENCYNAME");
        Integer nullValue = new Integer("-1");
        ArrayList list = (ArrayList)this.getUIContext().get("REPORT_LIST");
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                HashMap data = (HashMap)list.get(i);
                this.companyMap.put(data.get("ORGUNIT.ID"), data.get("ORGUNIT.NAME"));
                Integer year = null;
                if (data.get("YEAR") != null && data.get("YEAR").toString().trim().length() > 0) {
                    year = new Integer(Integer.parseInt(data.get("YEAR").toString()));
                }
                if (year == null || year.equals(nullValue)) {
                    year = defaultYear;
                }
                data.put("YEAR", year);
                Integer period = null;
                if (data.get("PERIOD") != null && data.get("PERIOD").toString().trim().length() > 0) {
                    period = new Integer(Integer.parseInt(data.get("PERIOD").toString()));
                }
                if (period == null || period.equals(nullValue)) {
                    period = defaultPeriod;
                }
                data.put("PERIOD", period);
                if (data.get("CURRENCY.NAME") == null) {
                    data.put("CURRENCY.NAME", CurrencyName);
                }
                if (data.get("REPORTDATE") != null) continue;
                year = new Integer(Integer.parseInt(data.get("YEAR").toString()));
                period = new Integer(Integer.parseInt(data.get("PERIOD").toString()));
                RptPeriodTypeEnum periodType = RptPeriodTypeEnum.getEnum((int)Integer.parseInt(data.get("PERIODTYPE").toString()));
                List rt = RPTDate13Util.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), 0, 0, this.isSupport13Period);
                Date date = (Date)rt.get(2);
                java.sql.Date dateSQL = new java.sql.Date(date.getYear(), date.getMonth(), date.getDate());
                data.put("REPORTDATE", dateSQL);
            }
        }
        this.loadDataToTable();
    }

    private boolean hasSomeTable(HashMap map) {
        if (map == null) {
            return false;
        }
        for (int i = 0; i < this.getTable().getRowCount(); ++i) {
            HashMap map2 = (HashMap)this.getTable().getRow(i).getUserObject();
            if (!this.reportEqual(map, map2)) continue;
            return true;
        }
        return false;
    }

    private boolean reportEqual(HashMap map1, HashMap map2) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null && map2 != null || map1 != null && map2 == null) {
            return false;
        }
        for (String field : map1.keySet()) {
            Object obj2;
            Object obj1;
            if (field.equals("TREE.ID") || this.objectEqual(obj1 = map1.get(field), obj2 = map2.get(field))) continue;
            return false;
        }
        return true;
    }

    private boolean objectEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2.equals(o1);
    }

    private void loadDataToTable() {
        this.getTable().removeRows();
        HashMap dataMap = this.getData();
        if (dataMap == null) {
            return;
        }
        for (ArrayList list : dataMap.values()) {
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = (HashMap)list.get(i);
                if (this.hasSomeTable(map)) continue;
                IRow row = this.getTable().addRow();
                row.getCell(0).setValue((Object)new Boolean(true));
                row.setUserObject((Object)map);
                row.getCell("2").setValue(map.get("ORGUNIT.NUMBER"));
                row.getCell("3").setValue(map.get("ORGUNIT.NAME"));
                row.getCell("4").setValue(map.get("NAME"));
                int cState = Integer.parseInt(map.get("COMMITTEDSTATUS").toString());
                if (cState == -1) {
                    row.getCell("5").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l1"));
                } else {
                    row.getCell("5").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l2"));
                }
                row.getCell("dcfname").setValue(map.get("DCFNAME") == null ? map.get("dcfname") : map.get("DCFNAME"));
                row.getCell("6").setValue((Object)RptPeriodTypeEnum.getEnum((int)Integer.parseInt(map.get("PERIODTYPE").toString())).getAlias());
                if (map.get("YEAR").toString().equals("-1")) {
                    row.getCell("7").setValue(null);
                } else {
                    row.getCell("7").setValue(map.get("YEAR"));
                }
                if (map.get("PERIOD").toString().equals("-1")) {
                    row.getCell("8").setValue(null);
                } else {
                    row.getCell("8").setValue(map.get("PERIOD"));
                }
                row.getCell("9").setValue((Object)RptSrcTypeEnum.getEnum((int)Integer.parseInt(map.get("SOURCETYPE").toString())).getAlias());
            }
        }
    }

    private HashMap getData() {
        ArrayList list = (ArrayList)this.getUIContext().get("REPORT_LIST");
        if (list == null) {
            return null;
        }
        HashMap returnMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            ArrayList<HashMap> cgList;
            HashMap data = (HashMap)list.get(i);
            if (this.filterMap != null && this.filterMap.keySet().size() > 0) {
                boolean isPass = true;
                for (String key : this.filterMap.keySet()) {
                    if (data.get(key) == null || this.filterMap.get(key) == null || this.filterMap.get(key).toString().equals(data.get(key).toString())) continue;
                    isPass = false;
                    break;
                }
                if (!isPass) continue;
            }
            if ((cgList = (ArrayList<HashMap>)returnMap.get(data.get("ORGUNIT.NAME"))) == null) {
                cgList = new ArrayList<HashMap>();
                returnMap.put(data.get("ORGUNIT.NAME"), cgList);
            }
            cgList.add(data);
        }
        if (returnMap.keySet().size() == 0) {
            return null;
        }
        return returnMap;
    }

    private KDTable getTable() {
        return this.kDTable1;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    private CommonQueryDialog getQueryDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            MetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.app", "ReceiveQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPk);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(250);
            this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l3"));
            this.conditionDialog.addUserPanel((KDPanel)new ReportFilterUI());
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        }
        return this.conditionDialog;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getQueryDialog().show()) {
            FilterInfo filter = this.getQueryDialog().getEntityViewInfoResult().getFilter();
            this.filterMap = new HashMap();
            for (FilterItemInfo item : filter.getFilterItems()) {
                Object info;
                if (item.getPropertyName().equalsIgnoreCase("COMPANY")) {
                    String company = (String)item.getCompareValue();
                    this.filterMap.put("ORGUNIT.ID", company);
                }
                if (item.getPropertyName().equalsIgnoreCase("TEMPLATE_NUMBER")) {
                    this.filterMap.put("TEMPLATE.NUMBER", (String)item.getCompareValue());
                }
                if (item.getPropertyName().equalsIgnoreCase("TEMPLATE_NAME")) {
                    this.filterMap.put("TEMPLATE.NAME", (String)item.getCompareValue());
                }
                if (item.getPropertyName().equalsIgnoreCase("ORG_TREE_ID")) {
                    this.filterMap.put("TREE.ID", (String)item.getCompareValue());
                }
                if (item.getPropertyName().equalsIgnoreCase("RPT_PERIOD_TYPE")) {
                    info = (Integer)item.getCompareValue();
                    this.filterMap.put("PERIODTYPE", info);
                }
                if (item.getPropertyName().equalsIgnoreCase("RPT_TEMP_TYPE")) {
                    info = (Integer)item.getCompareValue();
                    this.filterMap.put("TEMPLATE.TEMPLATETYPE", info);
                }
                if (item.getPropertyName().equalsIgnoreCase("CURRENCY")) {
                    info = (String)item.getCompareValue();
                    this.filterMap.put("CURRENCY.ID", info);
                }
                if (!item.getPropertyName().equalsIgnoreCase("DATE")) continue;
                java.sql.Date date = (java.sql.Date)item.getCompareValue();
                this.filterMap.put("REPORTDATE", date);
            }
            this.loadDataToTable();
        }
    }

    @Override
    public void actionSMSEdit_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ORG_ID", this.getUIContext().get("ORG_ID"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SMSMessageTemplateUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionEMailEdit_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ORG_ID", this.getUIContext().get("ORG_ID"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MailMessageTemplateUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionReceiverSet_actionPerformed(ActionEvent e) throws Exception {
        super.actionReceiverSet_actionPerformed(e);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.getTable().getRowCount(); ++i) {
            this.getTable().getRow(i).getCell("1").setValue((Object)new Boolean(true));
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.getTable().getRowCount(); ++i) {
            this.getTable().getRow(i).getCell("1").setValue((Object)new Boolean(false));
        }
    }

    @Override
    public void actionNoticeEmail_actionPerformed(ActionEvent e) throws Exception {
        this.sendMail();
    }

    @Override
    public void actionNoticeSMS_actionPerformed(ActionEvent e) throws Exception {
        this.sendSMS();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
    }

    private HashMap getSelectedReports() {
        HashMap map = new HashMap();
        for (int i = 0; i < this.getTable().getRowCount(); ++i) {
            IRow row = this.getTable().getRow(i);
            if (!((Boolean)row.getCell("1").getValue()).booleanValue()) continue;
            HashMap date = (HashMap)row.getUserObject();
            ArrayList<HashMap> list = (ArrayList<HashMap>)map.get(date.get("ORGUNIT.ID"));
            if (list == null) {
                list = new ArrayList<HashMap>();
                map.put(date.get("ORGUNIT.ID"), list);
            }
            list.add(date);
        }
        return map;
    }

    private HashMap getMessage(int type) throws BOSException {
        HashMap<String, MessageContent> list = new HashMap<String, MessageContent>();
        HashMap map = this.getSelectedReports();
        for (String cid : map.keySet()) {
            MessageContent content = new MessageContent();
            content.cid = cid;
            if (type == 2 || type == 3) {
                content.emailContent = type == 2 ? this.getEmailTemplate() : this.getMessageTemplate();
                StringBuffer buf = new StringBuffer();
                ArrayList reports = (ArrayList)map.get(cid);
                for (int i = 0; i < reports.size(); ++i) {
                    HashMap date = (HashMap)reports.get(i);
                    if (i == 0) {
                        String currName;
                        String periodType;
                        String period;
                        String year;
                        String companyName;
                        block13: {
                            companyName = (String)date.get("ORGUNIT.NAME");
                            if (companyName == null) {
                                companyName = "";
                            }
                            year = date.get("YEAR").toString();
                            period = date.get("PERIOD").toString();
                            periodType = RptPeriodTypeEnum.getEnum((int)Integer.parseInt(date.get("PERIODTYPE").toString())).toString();
                            currName = null;
                            String currency = date.get("CURRENCY.NAME").toString();
                            String currKey = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l25");
                            if (currKey.equals(currency)) {
                                try {
                                    if (CompanyOrgUnitFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(date.get("ORGUNIT.ID").toString()))) {
                                        CompanyOrgUnitInfo orgInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select baseCurrency.id,baseCurrency.number,baseCurrency.name where id = '" + date.get("ORGUNIT.ID").toString() + "'");
                                        currName = orgInfo.getBaseCurrency().getName(SysContext.getSysContext().getLocale());
                                        break block13;
                                    }
                                    currName = currency;
                                }
                                catch (EASBizException e) {
                                    logger.error((Object)"getCompanyOrgUnitInfo_EASBizException", (Throwable)e);
                                }
                            } else {
                                currName = currency;
                            }
                        }
                        String reportDate = date.get("REPORTDATE").toString();
                        String dataCollectName = date.get("DCFNAME") == null ? null : date.get("DCFNAME").toString();
                        content.emailContent = content.emailContent.replaceAll("\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l4") + "\\]", companyName);
                        content.emailContent = content.emailContent.replaceAll("\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l5") + "\\]", year);
                        content.emailContent = content.emailContent.replaceAll("\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l6") + "\\]", period);
                        content.emailContent = content.emailContent.replaceAll("\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l7") + "\\]", periodType);
                        content.emailContent = content.emailContent.replaceAll("\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l8") + "\\]", currName);
                        if (this.isMergeByFiscalPeriod) {
                            content.emailContent = content.emailContent.replaceAll("\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l9") + "\\]", reportDate);
                        }
                        content.emailContent = dataCollectName != null ? content.emailContent.replaceAll("\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.DATACOLLECT") + "\\]", dataCollectName) : content.emailContent.replaceAll("\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.DATACOLLECT") + "\\]", DataCollectConstant.getActualDC().getName());
                    }
                    buf.append("\t");
                    buf.append(date.get("TEMPLATE.NUMBER")).append("\t").append(date.get("NAME") + "\r\n");
                }
                if (buf.length() > 0) {
                    String reportList = buf.toString();
                    String key = "\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l23") + "\\] \\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l24") + "\\]";
                    content.emailContent = content.emailContent.replaceAll(key, reportList);
                }
                Date date = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String date2 = sdf.format(date);
                String receiver = this.getReceiverName();
                content.emailContent = content.emailContent.replaceAll("\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l22") + "\\]", receiver);
                content.emailContent = content.emailContent.replaceAll("\\[" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l11") + "\\]", date2);
            }
            if (type == 1) {
                content.smsContent = this.getSMSTemplate();
            }
            list.put(cid, content);
        }
        return list;
    }

    private String getReceiverName() {
        List persons = new ArrayList();
        StringBuffer sb = new StringBuffer();
        Locale local = SysContext.getSysContext().getLocale();
        try {
            persons = this.receiverInfo();
            if (persons != null && persons.size() > 0) {
                for (int i = 0; i < persons.size(); ++i) {
                    PersonInfo personInfo = (PersonInfo)persons.get(i);
                    if (personInfo.getName(local) == null || personInfo.getEmail() == null) continue;
                    sb.append(personInfo.getName(local));
                    if (i >= persons.size() - 1) continue;
                    sb.append("\uff0c");
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"getReceiverName_EASBizException", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"getReceiverName_BOSException", (Throwable)e);
        }
        return sb.toString();
    }

    private List receiverInfo() throws EASBizException, BOSException {
        Object l = this.kDBizPromptBox1.getValue();
        ArrayList list = new ArrayList();
        ArrayList<PersonInfo> personList = new ArrayList<PersonInfo>();
        if (l == null) {
            return null;
        }
        if (l instanceof ArrayList) {
            list = (ArrayList)l;
        }
        for (MAGroupInfo mAGroupInfo : list) {
            mAGroupInfo = MAGroupFactory.getRemoteInstance().getMAGroupInfo((IObjectPK)new ObjectUuidPK(mAGroupInfo.getId()));
            for (int i = 0; i < mAGroupInfo.getEntries().size(); ++i) {
                PersonInfo personInfo;
                if (mAGroupInfo.getEntries().get(i).getPersonnel() == null || (personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)mAGroupInfo.getEntries().get(i).getPersonnel().getId().toString())))) == null || personList.contains(personInfo)) continue;
                personList.add(personInfo);
            }
        }
        return personList;
    }

    private String getSMSTemplate() throws BOSException {
        String orgId = (String)this.getUIContext().get("ORG_ID");
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("orgID"));
        view.getSelector().add(new SelectorItemInfo("SMSMessageTemplate"));
        view.getSelector().add(new SelectorItemInfo("EMailMEssageTemplate"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgId));
        view.setFilter(filter);
        CoreBaseCollection c = MessageTemplateFactory.getRemoteInstance().getCollection(view);
        if (c != null && c.size() > 0) {
            MessageTemplateInfo template = (MessageTemplateInfo)c.get(0);
            byte[] data = template.getSMSMessageTemplate();
            if (data != null && data.length > 0) {
                String msg = this.bytesToString(data);
                if (msg.trim().length() == 0) {
                    return this.getDefaultSMS();
                }
                return msg;
            }
            return this.getDefaultSMS();
        }
        return this.getDefaultSMS();
    }

    private String getDefaultSMS() {
        String sms = "";
        sms = CslRptUIUtil.getSMSMessageTemplate();
        return sms.replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r");
    }

    private String getEmailTemplate() throws BOSException {
        String orgId = (String)this.getUIContext().get("ORG_ID");
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("orgID"));
        view.getSelector().add(new SelectorItemInfo("SMSMessageTemplate"));
        view.getSelector().add(new SelectorItemInfo("EMailMEssageTemplate"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgId));
        view.setFilter(filter);
        CoreBaseCollection c = MessageTemplateFactory.getRemoteInstance().getCollection(view);
        if (c != null && c.size() > 0) {
            MessageTemplateInfo template = (MessageTemplateInfo)c.get(0);
            byte[] data = template.getEMailMEssageTemplate();
            if (data != null && data.length > 0) {
                String msg = this.bytesToString(data);
                if (msg.trim().length() == 0) {
                    return this.getDefaultMsg();
                }
                return msg;
            }
            return this.getDefaultMsg();
        }
        return this.getDefaultMsg();
    }

    private String getDefaultMsg() {
        String email = "";
        email = CslRptUIUtil.getEMialMessageTemplate();
        return email.replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r");
    }

    private String bytesToString(byte[] bytes) {
        ByteArrayInputStream srcIn = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream in = new ObjectInputStream(srcIn);
            return (String)in.readObject();
        }
        catch (IOException e) {
            logger.error((Object)"bytesToString_IOException", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"bytesToString_ClassNotFoundException", (Throwable)e);
        }
        return null;
    }

    private HashMap getReceivers() throws BOSException, EASBizException, UuidException {
        HashMap<String, Receivers> map = new HashMap<String, Receivers>();
        Object l = this.kDBizPromptBox1.getValue();
        ArrayList list = new ArrayList();
        if (l == null) {
            return null;
        }
        if (l instanceof ArrayList) {
            list = (ArrayList)l;
        }
        for (MAGroupInfo mAGroupInfo : list) {
            mAGroupInfo = MAGroupFactory.getRemoteInstance().getMAGroupInfo((IObjectPK)new ObjectUuidPK(mAGroupInfo.getId()));
            String cid = null;
            if (mAGroupInfo.getOrgType().equals("6")) {
                String orgId = mAGroupInfo.getOrgUnit();
                if (orgId != null) {
                    OrgStructureInfo orgStructureInfo = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo((IObjectPK)new ObjectUuidPK(orgId));
                    cid = orgStructureInfo.getUnit().getId().toString();
                }
            } else {
                cid = MAGroupOrgFacadeFactory.getRemoteInstance().getCompanyOrgUnit(mAGroupInfo.getOrgUnit());
                if (StringUtils.isEmpty((String)cid)) {
                    cid = mAGroupInfo.getOrgUnit();
                }
            }
            Receivers rcvers = new Receivers();
            map.put(cid, rcvers);
            for (int i = 0; i < mAGroupInfo.getEntries().size(); ++i) {
                PersonInfo personInfo;
                if (mAGroupInfo.getEntries().get(i).getPersonnel() == null || (personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)mAGroupInfo.getEntries().get(i).getPersonnel().getId().toString())))) == null) continue;
                rcvers.persons.add(personInfo);
            }
        }
        return map;
    }

    private void sendMail() throws BOSException, EASBizException {
        HashMap messages = this.getMessage(2);
        this.debugSendEMail(messages);
        HashMap receiver = this.getReceivers();
        if (receiver == null || receiver.keySet().size() == 0) {
            String str = "";
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"No_Accept");
            MsgBox.showInfo((Component)((Object)this), (String)str);
            return;
        }
        if (messages == null || messages.keySet().size() == 0) {
            String str = null;
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l13");
            MsgBox.showInfo((Component)((Object)this), (String)str);
            return;
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        StringBuffer errorInfo = new StringBuffer();
        for (String cid : messages.keySet()) {
            MessageContent content = (MessageContent)messages.get(cid);
            Receivers rcver = (Receivers)receiver.get(cid);
            if (rcver != null) {
                String rcEAdds = rcver.getEmailAdds();
                if (rcEAdds != null) {
                    String str = null;
                    str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l14");
                    String[] param = new String[]{str, content.emailContent, rcEAdds};
                    list.add(param);
                    continue;
                }
                String companyName = (String)this.companyMap.get(cid);
                errorInfo.append("[" + companyName + "] ");
                continue;
            }
            String companyName = (String)this.companyMap.get(cid);
            errorInfo.append("[" + companyName + "] ");
        }
        if (errorInfo.length() > 0) {
            String str = null;
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l15");
            int rt = MsgBox.showConfirm2((Component)((Object)this), (String)(errorInfo.toString() + str));
            if (rt == 0) {
                this.sendEMail(list);
            }
        } else {
            this.sendEMail(list);
        }
    }

    private void debugSendEMail(HashMap messages) throws BOSException, EASBizException {
        if (!DebugLogger.isDebug) {
            return;
        }
        if (messages == null || messages.keySet().size() == 0) {
            String str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l13");
            MsgBox.showInfo((Component)((Object)this), (String)str);
            return;
        }
        SendMail cn = new SendMail(true, null);
        Iterator it = messages.keySet().iterator();
        String title = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l14");
        String content = null;
        while (it.hasNext()) {
            String cid = (String)it.next();
            MessageContent msgcontent = (MessageContent)messages.get(cid);
            content = msgcontent.emailContent;
            cn.sendEmail(title, content == null ? "testing" : content);
        }
    }

    private void sendEMail(ArrayList list) throws BOSException, EASBizException {
        IMessageCenter sender = MessageCenterFactory.getRemoteInstance();
        for (int i = 0; i < list.size(); ++i) {
            String[] addr = (String[])list.get(i);
            sender.sendEmail(addr[0], addr[1], addr[2], null, null);
        }
    }

    private void sendSMS() throws BOSException, EASBizException {
        HashMap receiver = this.getReceivers();
        HashMap messages = this.getMessage(1);
        if (receiver == null) {
            String str = null;
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"No_Accept");
            MsgBox.showInfo((Component)((Object)this), (String)str);
            return;
        }
        if (messages.keySet().size() == 0) {
            String str = null;
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"No_SelectReport");
            MsgBox.showInfo((Component)((Object)this), (String)str);
            return;
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        StringBuffer errorInfo = new StringBuffer();
        for (String cid : messages.keySet()) {
            MessageContent content = (MessageContent)messages.get(cid);
            Receivers rcver = (Receivers)receiver.get(cid);
            if (rcver != null) {
                String rcSMSAdds = rcver.getSMSAddrs();
                if (rcSMSAdds != null) {
                    String[] param = new String[]{content.smsContent, rcSMSAdds};
                    list.add(param);
                    continue;
                }
                String companyName = (String)this.companyMap.get(cid);
                errorInfo.append("[" + companyName + "] ");
                continue;
            }
            String companyName = (String)this.companyMap.get(cid);
            errorInfo.append("[" + companyName + "] ");
        }
        if (errorInfo.length() > 0) {
            String str = null;
            str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l16");
            int rt = MsgBox.showConfirm2((Component)((Object)this), (String)(errorInfo.toString() + str));
            if (rt == 0) {
                this.sendSMS(list);
            }
        } else {
            this.sendSMS(list);
        }
    }

    private void sendSMS(ArrayList list) throws EASBizException, BOSException {
        RPTDataServiceFactory.getRemoteInstance().sendSMS(list);
    }

    @Override
    public void actionMessageEdit_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ORG_ID", this.getUIContext().get("ORG_ID"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MessageTemplateUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionNoticeMessage_actionPerformed(ActionEvent e) throws Exception {
        this.sendMessage();
    }

    private void sendMessage() throws Exception {
        HashMap messages = this.getMessage(3);
        HashMap receiver = this.getReceivers();
        if (receiver == null || receiver.keySet().size() == 0) {
            String str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"No_Accept");
            MsgBox.showInfo((Component)((Object)this), (String)str);
            return;
        }
        if (messages == null || messages.keySet().size() == 0) {
            String str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l13");
            MsgBox.showInfo((Component)((Object)this), (String)str);
            return;
        }
        this.saveMsg(messages, receiver);
    }

    private void saveMsg(final HashMap messages, final HashMap receiver) throws Exception {
        LongTimeDialog dialog = new LongTimeDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                for (String cid : messages.keySet()) {
                    MessageContent content = (MessageContent)messages.get(cid);
                    Receivers rcver = (Receivers)receiver.get(cid);
                    if (rcver == null) continue;
                    String title = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.l14");
                    String cont = content.emailContent;
                    ArrayList persons = rcver.persons;
                    List userInfos = ReceiveReportMessageSenderUI.this.getReceiver(persons);
                    for (UserInfo userInfo : userInfos) {
                        BMCMessageInfo bmsgInfo = ReceiveReportMessageSenderUI.this.getMsgInfo(title, cont, userInfo);
                        IBMCMessage iBMCMessage = BMCMessageFactory.getRemoteInstance();
                        iBMCMessage.addnew((CoreBaseInfo)bmsgInfo);
                    }
                }
                return "";
            }

            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((Component)((Object)ReceiveReportMessageSenderUI.this), (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"send_success"));
            }
        });
        dialog.show();
    }

    private List<UserInfo> getReceiver(ArrayList persons) throws Exception {
        ArrayList<UserInfo> users = new ArrayList<UserInfo>();
        HashSet<String> personIds = new HashSet<String>();
        int size = persons.size();
        for (int i = 0; i < size; ++i) {
            PersonInfo personInfo = (PersonInfo)persons.get(i);
            personIds.add(personInfo.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", personIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isLocked", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)0));
        view.setFilter(filter);
        UserCollection coll = UserFactory.getRemoteInstance().getUserCollection(view);
        if (coll != null && !coll.isEmpty()) {
            int size2 = coll.size();
            for (int i = 0; i < size2; ++i) {
                UserInfo userInfo = coll.get(i);
                users.add(userInfo);
            }
        }
        return users;
    }

    private BMCMessageInfo getMsgInfo(String title, String content, UserInfo userInfo) throws Exception {
        BMCMessageInfo info = new BMCMessageInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        IUser iUser = UserFactory.getRemoteInstance();
        UserInfo defUserInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
        info.setTitle(title);
        info.setBody(content);
        info.setSender(defUserInfo.getName());
        info.setBizType(MsgBizType.URGENT);
        info.setPriority(MsgPriority.HIGH);
        info.setType(MsgType.NOTICE);
        info.setStatus(MsgStatus.UNREADED);
        info.setNreceivers(userInfo.getName());
        info.setReceiver(userInfo.getId().toString());
        return info;
    }

    private String getMessageTemplate() throws BOSException {
        String orgId = (String)this.getUIContext().get("ORG_ID");
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("orgID"));
        view.getSelector().add(new SelectorItemInfo("messageTemplate"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgId));
        view.setFilter(filter);
        CoreBaseCollection c = MessageTemplateFactory.getRemoteInstance().getCollection(view);
        if (c != null && c.size() > 0) {
            MessageTemplateInfo template = (MessageTemplateInfo)c.get(0);
            byte[] data = template.getMessageTemplate();
            if (data != null && data.length > 0) {
                String msg = this.bytesToString(data);
                if (msg.trim().length() == 0) {
                    return this.getDefaultMessage();
                }
                return msg;
            }
            return this.getDefaultMessage();
        }
        return this.getDefaultMessage();
    }

    private String getDefaultMessage() {
        String email = "";
        email = this.getMessageTemplateMsg();
        return email.replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r");
    }

    private String getMessageTemplateMsg() {
        StringBuffer message = new StringBuffer();
        message.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"a1")).append("\r\n\r\n").append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"383_CslRptUIUtil")).append("\r\n\r\n").append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"238_MessageFillAndSendUtils")).append("\r\n\r\n").append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"239_MessageFillAndSendUtils")).append("\r\n\r\n");
        return message.toString().replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r");
    }

    private class Receivers {
        String cid;
        ArrayList persons = new ArrayList();

        Receivers() {
        }

        String getEmailAdds() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.persons.size(); ++i) {
                PersonInfo person;
                if (i > 0) {
                    buf.append(",");
                }
                if ((person = (PersonInfo)this.persons.get(i)).getEmail() == null) continue;
                buf.append(person.getEmail());
            }
            if (buf.length() > 0) {
                return buf.toString();
            }
            return null;
        }

        String getSMSAddrs() {
            StringBuffer buf = new StringBuffer();
            int count = 0;
            for (int i = 0; i < this.persons.size(); ++i) {
                PersonInfo person = (PersonInfo)this.persons.get(i);
                if (person.getCell() == null) continue;
                if (++count > 1) {
                    buf.append(",");
                }
                buf.append(person.getCell());
            }
            if (buf.length() == 0) {
                return null;
            }
            return buf.toString();
        }
    }

    private static class MessageContent {
        String cid;
        String emailContent;
        String smsContent;

        private MessageContent() {
        }
    }

    class _CommonQueryDialog
    extends CommonQueryDialog {
        _CommonQueryDialog() {
        }
    }
}

