/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IRptControl;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptControlCollection;
import com.kingdee.eas.fi.gr.cslrpt.RptControlFactory;
import com.kingdee.eas.fi.gr.cslrpt.RptControlInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRptControlF7;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.IKDPromptSelector2;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RptControlF7
extends AbstractRptControlF7
implements IKDPromptSelector2 {
    private int selectedControl = 0;
    private String itemNumber = null;
    private int rowIndex = 0;
    private boolean isCheck = true;
    private static final Logger logger = CoreUIObject.getLogger(RptControlF7.class);
    private boolean isCancel = false;
    private Window owner = null;
    private IUIObject uiOwner = null;
    RptControlCollection rc = null;
    Hashtable hSingle = new Hashtable();
    private String selectPath = null;
    private static RPTItemControlEnum data = null;

    public boolean isCheck() {
        return this.isCheck;
    }

    public void setCheck(boolean isCheck) {
        this.isCheck = isCheck;
    }

    public void setInputData(HashMap params) throws Exception {
        this.selectedControl = (Integer)params.get("control");
        this.itemNumber = (String)params.get("itemNumber");
    }

    public RptControlF7() throws Exception {
    }

    public RptControlF7(IUIObject ui) throws Exception {
        this.uiOwner = ui;
    }

    public RptControlF7(IUIObject ui, boolean ischeck) throws Exception {
        this.uiOwner = ui;
        this.setCheck(ischeck);
    }

    public void onLoad() throws Exception {
        if (this.getUIContext() != null && this.getUIContext().get("isCheck") != null) {
            this.setCheck((Boolean)this.getUIContext().get("isCheck"));
        }
        super.onLoad();
        this.initData();
        this.initControl();
        this.init();
    }

    private void initControl() {
        this.kdControl.checkParsed();
        this.kdControl.getDataRequestManager().putBindContents("control", RPTItemControlEnum.class.getName(), "control");
        this.kdControl.getIndexColumn().getStyleAttributes().setHided(true);
        this.kdControl.getSelectManager().setSelectMode(2);
        this.kdControl.setEditable(false);
    }

    private void initData() throws BOSException {
        IRptControl i = null;
        if (this.rc == null) {
            i = RptControlFactory.getRemoteInstance();
        }
        if (i != null) {
            this.rc = i.getRptControlCollection(" order by type, index");
        }
        if (i != null) {
            IRowSet rsSingle = i.getSelectedCollection(this.itemNumber);
            try {
                while (rsSingle.next()) {
                    this.hSingle.put(RPTItemControlEnum.getEnum(rsSingle.getInt("FControl")), rsSingle.getString("FItemNumber") + " " + rsSingle.getString("FItemName"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private void init() {
        this.initTreeData();
        this.initTableData();
    }

    private int getSelectedType() {
        int type = 0;
        if (this.rc != null) {
            Iterator it = this.rc.iterator();
            RptControlInfo obj = null;
            while (it.hasNext()) {
                obj = (RptControlInfo)it.next();
                if (obj.getControl() == null || obj.getControl().getValue() != this.selectedControl) continue;
                type = obj.getType().getValue();
            }
        }
        return type;
    }

    private void initTableData() {
        if (this.rc != null) {
            this.bindDataToTable(this.kdControl, this.rc);
            this.kdControl.getSelectManager().select(this.rowIndex, 0, this.rowIndex, 0);
        }
    }

    private void bindDataToTable(KDTable table, RptControlCollection collection) {
        if (collection == null) {
            return;
        }
        table.setUserObject((Object)collection);
        table.removeRows();
        if (this.selectPath != null) {
            int rowCount = 0;
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                RptControlInfo obj = (RptControlInfo)collection.getObject(i);
                if (!this.selectPath.endsWith(obj.getType().toString())) continue;
                IRow row = table.addRow(rowCount);
                this.loadLineFields(table, row, (IObjectValue)obj);
                if (obj.getControl().getValue() == this.selectedControl) {
                    this.rowIndex = rowCount;
                }
                ++rowCount;
            }
        }
    }

    private void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        if (obj == null) {
            return;
        }
        row.setUserObject((Object)obj);
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getFieldName();
            if (StringUtils.isEmpty((String)bindField)) continue;
            row.getCell(i).setValue((Object)RPTItemControlEnum.getEnum((Integer)obj.get(bindField)));
            if (!this.isCheck() || !this.hSingle.containsKey((Object)RPTItemControlEnum.getEnum((Integer)obj.get(bindField)))) continue;
            row.getCell(i).getStyleAttributes().setBackground(new Color(228, 228, 228));
            row.getCell(i).getStyleAttributes().setLocked(true);
        }
    }

    private void initTreeData() {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
        node.setText(CslRptUtil.getString("RptControlItemControl"));
        node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_close"));
        node.setCustomOpenIcon(EASResource.getIcon((String)"imgTree_folder_open"));
        DefaultKingdeeTreeNode n1 = this.createNodes(node);
        KingdeeTreeModel tree = new KingdeeTreeModel((TreeNode)node);
        this.kDTree1.setModel((TreeModel)tree);
        this.kDTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                RptControlF7.this.kdTree_ValueChanged(e);
            }
        });
        this.kDTree1.setSelectionNode(n1);
    }

    private DefaultKingdeeTreeNode createNodes(DefaultKingdeeTreeNode top) {
        DefaultKingdeeTreeNode entry = null;
        DefaultKingdeeTreeNode ret = null;
        boolean selectedNode = false;
        int selectedType = this.getSelectedType();
        Iterator it = this.rc.iterator();
        RptControlInfo i = null;
        Hashtable<String, String> h = new Hashtable<String, String>();
        while (it.hasNext()) {
            i = (RptControlInfo)it.next();
            String name = i.getType().toString();
            if (h.containsKey(name)) continue;
            entry = new DefaultKingdeeTreeNode();
            entry.setUserObject((Object)i.getType());
            entry.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
            if (!(selectedNode || selectedType != 0 && i.getType().getValue() != selectedType)) {
                ret = entry;
                selectedNode = true;
            }
            top.add((MutableTreeNode)entry);
            h.put(name, i.getType().getAlias());
        }
        return ret;
    }

    private void kdTree_ValueChanged(TreeSelectionEvent e) {
        String[] s = e.getNewLeadSelectionPath().toString().split(",");
        if (s.length < 2) {
            this.kdControl.removeRows(true);
            return;
        }
        this.selectPath = s[1].trim().replaceAll("]", "");
        this.initTableData();
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public Object getData() {
        return data;
    }

    public void show() {
        try {
            if (this.uiOwner != null) {
                this.owner = ComponentUtil.getOwnerWindow((Component)((Component)this.uiOwner));
            }
            UIContext uiContext = new UIContext((Object)this.owner);
            uiContext.put((Object)"isCheck", (Object)new Boolean(this.isCheck()));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.RptControlF7", (Map)uiContext);
            uiWindow.show();
            this.isCancel = ((RptControlF7)uiWindow.getUIObject()).isCancel;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        super.getUIWindow().close();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.isCancel = false;
        if (this.isCheck()) {
            this.CheckSelected();
        }
        this.doSelected();
    }

    private void CheckSelected() throws EASBizException, BOSException {
        RPTItemControlEnum control;
        if (this.kdControl.getSelectManager().get() != null && this.hSingle.containsKey((Object)(control = (RPTItemControlEnum)((Object)this.kdControl.getCell(this.kdControl.getSelectManager().get().getBeginRow(), this.kdControl.getSelectManager().get().getBeginCol()).getValue())))) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("name"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("control", (Object)new Integer(control.getValue()), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0), CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            view.setFilter(filter);
            RPTItemCollection col = RPTItemFactory.getRemoteInstance().getRPTItemCollection(view);
            if (col == null || col.size() == 0) {
                return;
            }
            RPTItemInfo info = col.get(0);
            this.hSingle.put(control, info.getNumber() + " " + info.getName());
            data = null;
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_RptControlIsSingle")), new Object[]{this.hSingle.get((Object)((RPTItemControlEnum)((Object)this.kdControl.getCell(this.kdControl.getSelectManager().get().getBeginRow(), this.kdControl.getSelectManager().get().getBeginCol()).getValue())))});
        }
    }

    private void doSelected() {
        if (this.kdControl.getSelectManager().get() != null) {
            data = (RPTItemControlEnum)((Object)this.kdControl.getCell(this.kdControl.getSelectManager().get().getBeginRow(), this.kdControl.getSelectManager().get().getBeginCol()).getValue());
            this.selectedControl = data.getValue();
            super.getUIWindow().close();
        } else {
            this.selectedControl = 0;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SelectItemControl"));
        }
    }

    @Override
    protected void kdControl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.btnOK_actionPerformed(null);
        }
    }
}

