/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptItemConvDifferenceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RptItemConvDifferenceInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRptItemConvDiffEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptItemConvDiffEditUI
extends AbstractRptItemConvDiffEditUI {
    private static final long serialVersionUID = -6109968556448089034L;
    private static final Logger logger = CoreUIObject.getLogger(RptItemConvDiffEditUI.class);
    private static final String resClassName = "com.kingdee.eas.fi.gr.cslrpt.ItemRelationshipResource";
    private static final String formulaFilter = "include:categorys{CslRptFormula,assistant,common},groups{4,5,10},formulas{Item,DItem,RptDate,If}";
    private HashMap insertMap;
    private PickerListener pickerListener = null;

    public RptItemConvDiffEditUI() throws Exception {
        this.initOperateMap();
    }

    @Override
    public void storeFields() {
        this.addCreatrOrg();
        super.storeFields();
    }

    private void addCreatrOrg() {
        this.editData.setSyncOldValue(true);
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("trackRecordCreator"));
        return sic;
    }

    private void initOperateMap() {
        this.insertMap = new HashMap(15, 0.75f);
        this.insertMap.put(this.btnPlus, "+");
        this.insertMap.put(this.btnMinus, "-");
        this.insertMap.put(this.btnMultiply, "*");
        this.insertMap.put(this.btnDivision, "/");
        this.insertMap.put(this.btnBracket, "()");
    }

    private void init() {
        CslClientHelper.initDataElementCombox(this.comboDataElement, false, true, false);
        if (this.editData != null) {
            for (int i = 0; i < this.comboDataElement.getItemCount(); ++i) {
                DataElementInfo eleInfo = (DataElementInfo)this.comboDataElement.getItemAt(i);
                if (!eleInfo.getId().equals((Object)this.editData.getDataElement().getId())) continue;
                this.comboDataElement.setSelectedIndex(i);
                break;
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonsAndMenu();
        this.setRptItemPromptBox();
    }

    private void setButtonsAndMenu() {
        this.actionInsertOperate.setEnabled(true);
        this.btnFormula.setIcon(EASResource.getIcon((String)"imgTbtn_formulaguide"));
        this.txtformula.setSelectAllOnFocus(false);
        this.btnSave.setEnabled(false);
        this.btnSave.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.menuItemPrint.setEnabled(true);
        this.menuItemPrintPreview.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.actionPrint.setVisible(true);
        this.actionPrint.setEnabled(true);
        this.actionPrintPreview.setVisible(true);
        this.actionPrintPreview.setEnabled(true);
    }

    private void setRptItemPromptBox() {
        try {
            this.prmtRptItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
            EntityViewInfo view = this.getConvDiffItem();
            CslGradeManageUtil.filterRptItemGradeManage((EntityViewInfo)view, null);
            this.prmtRptItem.setEntityViewInfo(view);
            this.prmtRptItem.setEditFormat("$number$");
            this.prmtRptItem.setDisplayFormat("$number$ - $name$");
            this.prmtRptItem.setCommitFormat("$number$");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected EntityViewInfo getConvDiffItem() {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isSumItem", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSumItem", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("SpecSumFormula", null, CompareType.EMPTY));
        StringBuffer sbFormular = new StringBuffer();
        sbFormular.append(" #0 or ( #1 and #2)");
        filterInfo.setMaskString(sbFormular.toString());
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.editData.getRptItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"4RptItemNotNull"));
            SysUtil.abort();
        }
        this.checkFormula();
    }

    private void checkFormula() throws CheckFormulaException, BOSException {
        Expression stmt;
        String formulaStr = this.txtformula.getText().trim();
        if (StringUtils.isEmpty((String)formulaStr)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"19_Formula_Is_Null"));
            SysUtil.abort();
        }
        try {
            stmt = ExcelFormulaPaserHelper.parse((String)formulaStr);
        }
        catch (Exception e) {
            throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, e, new Object[]{""});
        }
        Set items = this.checkFormulaFormat(stmt);
        CslRptUtil.checkFormulaItemExists(null, items, CheckFormulaException.RPTITEMNOTEXISTINFORMULA);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set checkFormulaFormat(Expression stmt) throws CheckFormulaException {
        HashSet<String> result = new HashSet<String>();
        if (stmt instanceof FunctionExpr) {
            String funName = ((FunctionExpr)stmt).funcionName;
            String item = null;
            FunctionExpr expr = (FunctionExpr)stmt;
            List param = expr.parameters;
            if (funName.equalsIgnoreCase("Item") && (!(param.get(3) instanceof StringExpr) || param.size() != 5)) {
                throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, new Object[]{""});
            }
            if (funName.equalsIgnoreCase("DItem") && (!(param.get(4) instanceof StringExpr) || param.size() != 6)) {
                throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, new Object[]{""});
            }
            if (funName.equalsIgnoreCase("Item") && (!(param.get(3) instanceof StringExpr) || param.size() != 5)) {
                throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, new Object[]{""});
            }
            if (funName.equalsIgnoreCase("DItem") && (!(param.get(4) instanceof StringExpr) || param.size() != 6)) {
                throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, new Object[]{""});
            }
            if (funName.equalsIgnoreCase("rptdate")) return result;
            if (funName.equalsIgnoreCase("if")) {
                for (Object curParam : param) {
                    Set list = this.checkFormulaFormat((Expression)curParam);
                    result.addAll(list);
                }
                return result;
            } else {
                if (!funName.equalsIgnoreCase("Item") && !funName.equalsIgnoreCase("DItem")) throw new CheckFormulaException(CheckFormulaException.ITEMCONVDIFFCONTAININVAILDFORMULA);
                item = ((StringExpr)param.get((int)0)).value;
                if (StringUtils.isEmpty((String)item)) {
                    throw new CheckFormulaException(CheckFormulaException.ITEM_BLANK);
                }
                result.add(item);
                for (int i = 0; i < param.size(); ++i) {
                    Object obj = param.get(i);
                    if (!(obj instanceof FunctionExpr) && !(obj instanceof BinaryOperationExpr)) continue;
                    throw new CheckFormulaException(CheckFormulaException.ITEMNOTCONTAINFORMULA);
                }
            }
            return result;
        } else if (stmt instanceof BinaryOperationExpr) {
            Expression expr = ((BinaryOperationExpr)stmt).left;
            Set list = this.checkFormulaFormat(expr);
            result.addAll(list);
            expr = ((BinaryOperationExpr)stmt).right;
            list = this.checkFormulaFormat(expr);
            result.addAll(list);
            return result;
        } else {
            if (!(stmt instanceof UnaryOperationExpr)) return result;
            Expression expr = ((UnaryOperationExpr)stmt).operand;
            Set list = this.checkFormulaFormat(expr);
            result.addAll(list);
        }
        return result;
    }

    protected IObjectValue createNewData() {
        RptItemConvDifferenceInfo info = new RptItemConvDifferenceInfo();
        info.setDataElement(this.getDataElementInfo(4));
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptItemConvDifferenceFactory.getRemoteInstance();
    }

    private DataElementInfo getDataElementInfo(int innerValue) {
        return DataElementProvider.getDataElementInfo(innerValue);
    }

    @Override
    public void actionInsertOperate_actionPerformed(ActionEvent e) throws Exception {
        Object src = e.getSource();
        if (src == this.btnFormula) {
            this.insertFormula();
        } else {
            this.insertOperator((String)this.insertMap.get(src), src == this.btnBracket);
        }
    }

    private void insertFormula() {
        if (this.pickerListener == null) {
            this.pickerListener = new PickerListener();
        }
        try {
            FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
            picker.setRptContext((RptContextManager)this.getUIContext().get("REPORT_CONTEXT"));
            picker.addFormulaPickerListener((IFormulaPickerListener)this.pickerListener);
            picker.setExtendable(false);
            picker.open(formulaFilter, null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void insertOperator(String word, boolean isBracket) {
        int pos = this.txtformula.getCaretPosition();
        this.txtformula.insert(word, pos);
        if (isBracket) {
            this.txtformula.setCaretPosition(pos + 1);
        }
        this.txtformula.requestFocus();
    }

    public void onShow() throws Exception {
        super.onShow();
        CslRptUIUtil.setWindowIsNotResizable(this.getUIWindow());
    }

    private class PickerListener
    implements IFormulaPickerListener {
        private PickerListener() {
        }

        public void pickerSetout(FormulaPickerUI picker) {
        }

        public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
            if (isOk) {
                RptItemConvDiffEditUI.this.insertOperator(formulaLine, false);
            }
        }
    }
}

