/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassCollection;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRptItemFillEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.IRptItemFillListener;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class RptItemFillEditUI
extends AbstractRptItemFillEditUI {
    private RPTItemCollection rptc = null;
    private RPTItemCollection rptcSelected = null;
    private String flag = "";
    private RPTItemGroupEnum itemGroup;
    private String SELECT_ALL = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
    private IRptItemFillListener fillListener = null;
    private Sheet sheet;

    public void setFillListener(IRptItemFillListener listener) {
        this.fillListener = listener;
        this.loadRptItem(null);
    }

    public RptItemFillEditUI() throws Exception {
        this.initListeners();
    }

    public RPTItemCollection getRptc() {
        if (this.rptc == null) {
            this.rptc = new RPTItemCollection();
        }
        return this.rptc;
    }

    public RPTItemCollection getRptcSelected() {
        if (this.rptcSelected == null) {
            this.rptcSelected = new RPTItemCollection();
        }
        return this.rptcSelected;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParament();
        this.loadRptItem(null);
        this.initItemType();
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptItemFillEditUI.this.moveDown();
            }
        });
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptItemFillEditUI.this.moveUp();
            }
        });
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
    }

    protected boolean moveDown() {
        IRow row;
        int r;
        int rowcount = this.tblRptItemSelected.getRowCount();
        IRow[] rows = this.getTableSelection(this.tblRptItemSelected);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[rows.length - 1].getRowIndex() == rowcount - 1) {
                return false;
            }
        } else {
            return false;
        }
        this.tblRptItemSelected.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = rows.length - 1; i >= 0 && (r = (row = rows[i]).getRowIndex()) != rowcount - 1; --i) {
            moved = true;
            this.tblRptItemSelected.removeRow(r);
            this.tblRptItemSelected.addRow(r + 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.tblRptItemSelected);
            sel.setTop(r + 1);
            sel.setBottom(r + 1);
            sel.setMode(2);
            this.tblRptItemSelected.getSelectManager().add(sel);
        }
        if (moved) {
            this.tblRptItemSelected.setRefresh(true);
        }
        return true;
    }

    protected boolean moveUp() {
        IRow[] rows = this.getTableSelection(this.tblRptItemSelected);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[0].getRowIndex() == 0) {
                return false;
            }
        } else {
            return false;
        }
        this.tblRptItemSelected.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            int r = rows[i].getRowIndex();
            if (r == 0) break;
            moved = true;
            this.tblRptItemSelected.removeRow(r);
            this.tblRptItemSelected.addRow(r - 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.tblRptItemSelected);
            sel.setTop(r - 1);
            sel.setBottom(r - 1);
            sel.setMode(2);
            this.tblRptItemSelected.getSelectManager().add(sel);
        }
        if (moved) {
            this.tblRptItemSelected.setRefresh(true);
        }
        return true;
    }

    protected IRow[] getTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            for (int row = block.getBeginRow(); row <= block.getEndRow(); ++row) {
                rows.add(tbl.getRow(row));
            }
        }
        return rows.toArray(new IRow[rows.size()]);
    }

    private void initListeners() {
        this.tblRptItem.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() > 1) {
                    try {
                        RptItemFillEditUI.this.addAction_actionPerformed(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.tblRptItemSelected.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() > 1) {
                    try {
                        RptItemFillEditUI.this.reduceAction_actionPerformed(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void initItemType() throws BOSException {
        ReportClassCollection collection = ReportClassFactory.getRemoteInstance().getReportClassCollection("select id, name");
        this.comboItemType.addItem((Object)this.SELECT_ALL);
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            this.comboItemType.addItem((Object)collection.get(i));
        }
        this.comboItemType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RptItemFillEditUI.this.loadRptItem(RptItemFillEditUI.this.comboItemType.getSelectedItem());
            }
        });
    }

    @Override
    public void addAction_actionPerformed(ActionEvent e) throws Exception {
        super.addAction_actionPerformed(e);
        RPTItemCollection rptItemcol = this.getSelectedCollectionFromTable(this.tblRptItem);
        this.getRptcSelected().addCollection(rptItemcol);
        this.addCollectionToTable(this.getRptcSelected(), this.tblRptItemSelected);
        this.addCollectionToTable(this.getRptc(), this.tblRptItem);
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void okAction_actionPerformed(ActionEvent e) throws Exception {
        super.okAction_actionPerformed(e);
        ArrayList<DataElementInfo> dataElements = new ArrayList<DataElementInfo>();
        if (RPTItemGroupEnum.TRADE.equals((Object)this.itemGroup)) {
            if (!this.chkAmout.isSelected() && !this.chkYtdAmount.isSelected()) {
                throw new AdjustException(AdjustException.MUST_SELECT_ONE);
            }
            if (this.chkAmout.isSelected()) {
                dataElements.add(DataElementProvider.getDataElementInfo(2));
            }
            if (this.chkYtdAmount.isSelected()) {
                dataElements.add(DataElementProvider.getDataElementInfo(3));
            }
        }
        this.destroyWindow();
        this.rptcSelected = this.getRptcFromTable(this.tblRptItemSelected);
        if (this.sheet == null && this.fillListener != null) {
            this.fillListener.applySelectionRPTItem(this.rptcSelected, dataElements);
        } else if (this.sheet != null) {
            if (RPTItemGroupEnum.CUSSEND.equals((Object)this.itemGroup)) {
                CslRptUIUtil.fillCussentRptItem(this.sheet, this.rptcSelected, false, true, true);
            } else {
                CslRptUIUtil.fillRptItem(this.sheet, this.rptcSelected, false, false, true);
            }
        }
    }

    @Override
    public void reduceAction_actionPerformed(ActionEvent e) throws Exception {
        super.reduceAction_actionPerformed(e);
        RPTItemCollection rptItemcol = this.getSelectedCollectionFromTable(this.tblRptItemSelected);
        this.getRptc().addCollection(rptItemcol);
        this.addCollectionToTable(this.getRptcSelected(), this.tblRptItemSelected);
        this.addCollectionToTable(this.getRptc(), this.tblRptItem);
    }

    private RPTItemCollection getRptItemCollection(Object item) throws BOSException {
        IRPTItem iRptItem = RPTItemFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.flag == null || !"KEY_RPTFLAG_SELECT".equals(this.flag) && !"KEY_RPTFLAG_MNS".equals(this.flag)) {
            if (this.itemGroup == RPTItemGroupEnum.TRADE) {
                filter.getFilterItems().add(new FilterItemInfo("itemGroup", (Object)new Integer(3)));
            } else if (this.itemGroup == RPTItemGroupEnum.CUSSEND) {
                filter.getFilterItems().add(new FilterItemInfo("itemGroup", (Object)new Integer(1)));
            }
            filter.getFilterItems().add(new FilterItemInfo("isSumItem", (Object)new Boolean(false)));
        }
        filter.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0)));
        if (item instanceof ReportClassInfo) {
            filter.getFilterItems().add(new FilterItemInfo("reportClass", (Object)((ReportClassInfo)item).getId().toString()));
        }
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        viewInfo.setFilter(filter);
        return iRptItem.getRPTItemCollection(viewInfo);
    }

    private RPTItemCollection getRptcFromTable(KDTable table) {
        RPTItemCollection rptItemcol = new RPTItemCollection();
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            rptItemcol.add((RPTItemInfo)table.getRow(i).getCell(3).getValue());
        }
        return rptItemcol;
    }

    private RPTItemCollection getRptctemp(KDTable table) {
        RPTItemCollection rptc = null;
        if (table.equals(this.tblRptItem)) {
            rptc = this.getRptc();
        } else if (table.equals(this.tblRptItemSelected)) {
            rptc = this.getRptcSelected();
        }
        return rptc;
    }

    private RPTItemCollection getSelectedCollectionFromTable(KDTable table) {
        RPTItemCollection rptItemcol = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                if (rptItemcol == null) {
                    rptItemcol = new RPTItemCollection();
                }
                RPTItemInfo rptInfo = (RPTItemInfo)table.getRow(j).getCell(3).getValue();
                rptItemcol.add(rptInfo);
                this.getRptctemp(table).remove(rptInfo);
            }
        }
        return rptItemcol;
    }

    private void addCollectionToTable(RPTItemCollection rptc, KDTable table) {
        table.checkParsed();
        table.removeRows();
        int count = rptc.size();
        for (int i = 0; i < count; ++i) {
            RPTItemInfo rpt = rptc.get(i);
            IRow r = table.addRow();
            r.getCell(0).setValue((Object)rpt.getNumber());
            r.getCell(1).setValue((Object)rpt.getName());
            r.getCell(2).setValue((Object)rpt.getId());
            r.getCell(3).setValue((Object)rpt);
        }
    }

    private void initParament() {
        this.sheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        this.flag = (String)this.getUIContext().get("KEY_RPTFLAG");
        this.itemGroup = (RPTItemGroupEnum)((Object)this.getUIContext().get("itemGroup"));
        if (this.flag != null && this.flag.equals("KEY_RPTFLAG_MNS")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"Mns_Row_Guide"));
            this.chkAmout.setEnabled(false);
            this.chkYtdAmount.setEnabled(false);
        }
        if (!RPTItemGroupEnum.TRADE.equals((Object)this.itemGroup)) {
            int offset = this.lblDataElements.getHeight() + 3;
            int halfOffset = offset / 2;
            this.lblDataElements.setVisible(false);
            this.chkAmout.setVisible(false);
            this.chkYtdAmount.setVisible(false);
            Rectangle bounds = this.tblRptItem.getBounds();
            bounds.height += offset;
            this.tblRptItem.setBounds(bounds);
            bounds = this.tblRptItemSelected.getBounds();
            bounds.height += offset;
            this.tblRptItemSelected.setBounds(bounds);
            Point location = this.btnAdd.getLocation();
            location.y += halfOffset;
            this.btnAdd.setLocation(location);
            location = this.btnAddAll.getLocation();
            location.y += halfOffset;
            this.btnAddAll.setLocation(location);
            location = this.btnReduce.getLocation();
            location.y += halfOffset;
            this.btnReduce.setLocation(location);
            location = this.btnReduceAll.getLocation();
            location.y += halfOffset;
            this.btnReduceAll.setLocation(location);
        }
    }

    public void loadRptItem(Object item) {
        this.tblRptItemSelected.checkParsed();
        this.tblRptItem.checkParsed();
        try {
            if (item != null) {
                this.getRptc().clear();
            }
            this.getRptc().addCollection(this.getRptItemCollection(item));
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (item == null) {
            int count = this.getRptcSelected().size();
            for (int i = 0; i < count; ++i) {
                this.getRptc().remove(this.getRptcSelected().get(i));
            }
            this.addCollectionToTable(this.getRptcSelected(), this.tblRptItemSelected);
        }
        this.addCollectionToTable(this.getRptc(), this.tblRptItem);
    }

    @Override
    public void addAllAction_actionPerformed(ActionEvent e) throws Exception {
        super.addAllAction_actionPerformed(e);
        this.getRptcSelected().addCollection(this.getRptc());
        this.getRptc().clear();
        this.addCollectionToTable(this.getRptcSelected(), this.tblRptItemSelected);
        this.addCollectionToTable(this.getRptc(), this.tblRptItem);
    }

    @Override
    public void reduceAllAction_actionPerformed(ActionEvent e) throws Exception {
        super.reduceAllAction_actionPerformed(e);
        this.getRptc().addCollection(this.getRptcSelected());
        this.getRptcSelected().clear();
        this.addCollectionToTable(this.getRptcSelected(), this.tblRptItemSelected);
        this.addCollectionToTable(this.getRptc(), this.tblRptItem);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnReduce.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnReduceAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
    }

    class RowIdxComparer
    implements Comparator {
        RowIdxComparer() {
        }

        public int compare(Object row1, Object row2) {
            return ((IRow)row1).getRowIndex() - ((IRow)row2).getRowIndex();
        }
    }
}

