/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.IRptItemRelationship;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationShipException;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationShipScopeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipCollection;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipFactory;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractRptItemRelationshipEditUI;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class RptItemRelationshipEditUI
extends AbstractRptItemRelationshipEditUI {
    private static final long serialVersionUID = 3394164609493015453L;
    private static final Logger logger = CoreUIObject.getLogger(RptItemRelationshipEditUI.class);
    private static final String resClassName = "com.kingdee.eas.fi.gr.cslrpt.ItemRelationshipResource";
    private static final String TB_ITEM_NUMBER = "itemNumber";
    private static final String TB_ITEM_NAME = "itemName";
    private static final String TB_DATAELEMENT = "dataElement";
    private static final String SPLIT = ";";

    public void onLoad() throws Exception {
        super.onLoad();
        this.hideUnuseableButtons();
        this.init();
        this.initListeners();
        if (this.getUIContext().containsKey("isCopyToNew")) {
            this.actionCopy_actionPerformed(null);
        }
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.prmtItem, null);
    }

    private void init() throws Exception {
        this.remove((Component)this.btnAddEntry);
        this.remove((Component)this.btnInsertEntry);
        this.remove((Component)this.btnDelEntry);
        this.btnAddEntry.setText(null);
        this.btnAddEntry.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertEntry.setText(null);
        this.btnInsertEntry.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDelEntry.setText(null);
        this.btnDelEntry.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kDItemRelationship.addButton((JButton)this.btnAddEntry);
        this.kDItemRelationship.addButton((JButton)this.btnInsertEntry);
        this.kDItemRelationship.addButton((JButton)this.btnDelEntry);
        this.kDItemRelationship.setEnableActive(false);
        this.prmtItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
        this.prmtItem.setEditFormat("$number$");
        this.prmtItem.setDisplayFormat("$number$ - $name$");
        this.prmtItem.setEditable(true);
        this.prmtItem.setCommitFormat("$number$");
        this.prmtItem.setRequired(true);
        this.comboScope.setRequired(true);
        this.relationPrmtDataElement.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        this.relationPrmtDataElement.setEditFormat("$number$");
        this.relationPrmtDataElement.setDisplayFormat("$name$");
        this.relationPrmtDataElement.setEditable(true);
        this.relationPrmtDataElement.setRequired(true);
        this.relationPrmtDataElement.setCommitFormat("$number$");
        CslGradeManageUtil.setDataElementF7GMFilter((KDBizPromptBox)this.relationPrmtDataElement, null, (boolean)true);
        if (this.editData != null) {
            this.relationPrmtDataElement.setValue((Object)this.getDataElementInfo(this.editData.getDataElement()));
        }
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
        bizBoxItem.setEditFormat("$number$");
        bizBoxItem.setDisplayFormat("$number$");
        bizBoxItem.setEditable(true);
        bizBoxItem.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)bizBoxItem, null);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)bizBoxItem);
        this.kdtEntries.getColumn(TB_ITEM_NUMBER).setEditor((ICellEditor)itemEditor);
        this.kdtEntries.getColumn(TB_ITEM_NAME).getStyleAttributes().setLocked(true);
        KDBizPromptBox bizDataElement = new KDBizPromptBox();
        bizDataElement.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        bizDataElement.setEditFormat("$number$");
        bizDataElement.setDisplayFormat("$name$");
        bizDataElement.setEditable(true);
        bizDataElement.setCommitFormat("$number$");
        CslGradeManageUtil.setDataElementF7GMFilter((KDBizPromptBox)bizDataElement, null, (boolean)true);
        this.kdtEntries.getColumn(TB_DATAELEMENT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizDataElement));
    }

    private void initListeners() {
        KDTEditAdapter editAdapter = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    RptItemRelationshipEditUI.this.tableValueChanged(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
        };
        this.kdtEntries.addKDTEditListener((KDTEditListener)editAdapter);
    }

    private void tableValueChanged(KDTEditEvent e) throws BOSException, EASBizException {
        int selectRow = e.getRowIndex();
        KDTable kdtEntry = (KDTable)e.getSource();
        IRow row = kdtEntry.getRow(selectRow);
        if (e.getColIndex() == this.kdtEntries.getColumnIndex(TB_ITEM_NUMBER) && e.getValue() != null && e.getOldValue() != e.getValue()) {
            RPTItemInfo rptItem = (RPTItemInfo)e.getValue();
            RptItemRelationshipEntryInfo entry = (RptItemRelationshipEntryInfo)row.getUserObject();
            entry.setTargetItem(rptItem);
            row.getCell(TB_ITEM_NAME).setValue((Object)rptItem.getName(this.getCurrentLocale()));
            IRPTItem ir = RPTItemFactory.getRemoteInstance();
            DataElementInfo dataElement = ir.getReportClassDataElement(rptItem.getId().toString());
            if (dataElement == null) {
                dataElement = DataElementProvider.getDataElementInfo("ENDBALANCE");
            }
            row.getCell(TB_DATAELEMENT).setValue((Object)dataElement);
        }
    }

    private void hideUnuseableButtons() {
        this.actionRelationDiagram.setEnabled(false);
        this.actionRelationDiagram.setVisible(false);
        this.menuItemSubmit.setEnabled(false);
        this.menuItemSubmit.setVisible(false);
        this.btnSubmit.setEnabled(false);
        this.btnSubmit.setVisible(false);
        this.actionSubmit.setEnabled(false);
        this.menuSubmitOption.setEnabled(false);
        this.menuSubmitOption.setVisible(false);
        this.actionSubmitOption.setEnabled(false);
        this.MenuItemAttachment.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.menuItemCreateFrom.setEnabled(false);
        this.menuItemCreateFrom.setVisible(false);
        this.btnCreateFrom.setEnabled(false);
        this.btnCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.menuItemCopyFrom.setEnabled(false);
        this.menuItemCopyFrom.setVisible(false);
        this.btnCopyFrom.setEnabled(false);
        this.btnCopyFrom.setVisible(false);
        this.actionCopyFrom.setEnabled(false);
        this.menuItemTraceUp.setEnabled(false);
        this.menuItemTraceUp.setVisible(false);
        this.btnTraceUp.setEnabled(false);
        this.btnTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.menuItemTraceDown.setEnabled(false);
        this.menuItemTraceDown.setVisible(false);
        this.btnTraceDown.setEnabled(false);
        this.btnTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.menuBiz.setVisible(false);
        this.menuBiz.setEnabled(false);
        this.menuWorkflow.setVisible(false);
        this.menuWorkflow.setEnabled(false);
        this.btnWorkFlowG.setEnabled(false);
        this.btnWorkFlowG.setVisible(false);
        this.actionWorkFlowG.setEnabled(false);
        this.menuItemAuditResult.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.btnMultiapprove.setVisible(false);
        this.btnMultiapprove.setEnabled(false);
        this.actionMultiapprove.setEnabled(false);
        this.btnNextPerson.setVisible(false);
        this.btnNextPerson.setEnabled(false);
        this.actionNextPerson.setEnabled(false);
        this.actionCopyLine.setEnabled(false);
        this.btnCopyLine.setVisible(false);
        this.btnCopyLine.setEnabled(false);
        this.menuItemCopyLine.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals(OprtState.ADDNEW) && this.kdtEntries.getRowCount() == 0) {
            try {
                this.actionAddLine_actionPerformed(null);
                this.actionAddLine_actionPerformed(null);
            }
            catch (Exception e) {
                this.handUIException(e);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.relationPrmtDataElement.setValue((Object)this.getDataElementInfo(this.editData.getDataElement()));
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            RptItemRelationshipEntryInfo entryInfo = this.editData.getEntries().get(i);
            if (entryInfo == null) continue;
            row.setUserObject((Object)entryInfo);
            row.getCell(TB_DATAELEMENT).setValue((Object)this.getDataElementInfo(entryInfo.getDataElement()));
        }
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else if (!this.getOprtState().equals(OprtState.EDIT)) {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.oprtState)) {
            this.setUITitle(EASResource.getString((String)resClassName, (String)"16addnew"));
        } else if ("EDIT".equals(this.oprtState)) {
            this.setUITitle(EASResource.getString((String)resClassName, (String)"17edit"));
        } else if ("VIEW".equals(this.oprtState)) {
            this.setUITitle(EASResource.getString((String)resClassName, (String)"18view"));
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        RptItemRelationshipEntryInfo lineInfo = (RptItemRelationshipEntryInfo)obj;
        row.getCell(TB_ITEM_NUMBER).setValue((Object)(lineInfo.getTargetItem() == null ? null : lineInfo.getTargetItem()));
        row.getCell(TB_ITEM_NAME).setValue(lineInfo.getTargetItem() == null ? null : lineInfo.getTargetItem().getName(this.getCurrentLocale()));
        row.getCell(TB_DATAELEMENT).setValue((Object)DataElementProvider.getDataElementInfo(lineInfo.getDataElement()));
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewData() {
        RptItemRelationshipInfo info = new RptItemRelationshipInfo();
        info.setDataElement(4);
        info.setIsFreezed(false);
        info.setScope(RptItemRelationShipScopeEnum.AdjustAndElimination);
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        RptItemRelationshipEntryInfo entryInfo = new RptItemRelationshipEntryInfo();
        entryInfo.setDataElement(4);
        return entryInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptItemRelationshipFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
        this.addCreatrOrg();
        super.storeFields();
        this.editData.setSyncOldValue(false);
        int size = this.kdtEntries.getRowCount();
        this.editData.setDataElement(((DataElementInfo)this.relationPrmtDataElement.getValue()).getInterSeq());
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            RptItemRelationshipEntryInfo entryInfo = this.editData.getEntries().get(i);
            this.storeEntries(this.kdtEntries, row, entryInfo);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.relationPrmtDataElement.getValue() == null) {
            throw new RptItemRelationShipException(RptItemRelationShipException.DATAELEMENT_BLANK);
        }
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            if (row.getCell(TB_DATAELEMENT).getValue() != null) continue;
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)resClassName, (String)"21EntryDataElementNotNull"), i + 1));
            SysUtil.abort();
        }
    }

    private void addCreatrOrg() {
        this.editData.setSyncOldValue(true);
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
    }

    private void storeEntries(KDTable kdtEntries, IRow row, RptItemRelationshipEntryInfo entryInfo) {
        if (row.getCell(TB_ITEM_NUMBER).getValue() instanceof RPTItemInfo) {
            entryInfo.setTargetItem((RPTItemInfo)row.getCell(TB_ITEM_NUMBER).getValue());
        } else {
            row.getCell(TB_ITEM_NUMBER).setValue(null);
        }
        if (row.getCell(TB_DATAELEMENT) != null && row.getCell(TB_DATAELEMENT).getValue() != null) {
            entryInfo.setDataElement(((DataElementInfo)row.getCell(TB_DATAELEMENT).getValue()).getInterSeq());
        }
    }

    private void commonValidate() {
        if (this.editData.getItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"4RptItemNotNull"));
            SysUtil.abort();
        }
        if (this.editData.getRemark() != null && this.editData.getRemark().length() > 256) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"5RemarkOverLength"));
            SysUtil.abort();
        }
        if (this.editData.getEntries() == null || this.editData.getEntries().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"6EntryNotExist"));
            SysUtil.abort();
        }
        RptItemRelationshipEntryCollection cEntryCollection = this.editData.getEntries();
        RptItemRelationshipEntryInfo entryInfo = null;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < cEntryCollection.size(); ++i) {
            String key;
            entryInfo = cEntryCollection.get(i);
            if (entryInfo.getTargetItem() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)resClassName, (String)"7EntryRptItemNotNull"), i + 1));
                SysUtil.abort();
            }
            if (set.contains(key = entryInfo.getTargetItem().getId().toString() + SPLIT + entryInfo.getDataElement())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"8EntryRepeat"));
                SysUtil.abort();
            }
            set.add(key);
        }
    }

    private void connectionValidate() {
        int rowCount = this.kdtEntries.getRowCount();
        if (this.prmtItem.getValue() == null) {
            return;
        }
        RPTItemInfo rptItemInfo = (RPTItemInfo)this.prmtItem.getValue();
        String itemNumber = rptItemInfo.getNumber();
        int dataElement = ((DataElementInfo)this.relationPrmtDataElement.getValue()).getInterSeq();
        for (int i = 0; i < rowCount; ++i) {
            int m;
            RPTItemInfo targetItemInfo = (RPTItemInfo)this.kdtEntries.getRow(i).getCell(TB_ITEM_NUMBER).getValue();
            int targetDe = ((DataElementInfo)this.kdtEntries.getRow(i).getCell(TB_DATAELEMENT).getValue()).getInterSeq();
            if (targetDe == dataElement && targetItemInfo.getNumber().equals(itemNumber)) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)resClassName, (String)"9ForbidRelation_1"), i + 1));
                SysUtil.abort();
            }
            List list = this.getParentNumbers(itemNumber);
            for (m = 0; list != null && m < list.size(); ++m) {
                if (!list.get(m).equals(targetItemInfo.getNumber())) continue;
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)resClassName, (String)"10ForbidRelation_2"), i + 1));
                SysUtil.abort();
            }
            list = this.getParentNumbers(targetItemInfo.getNumber());
            for (m = 0; list != null && m < list.size(); ++m) {
                if (!list.get(m).equals(itemNumber)) continue;
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)resClassName, (String)"10ForbidRelation_6"), i + 1));
                SysUtil.abort();
            }
            if (dataElement != 3 || !rptItemInfo.isIsProfitAndLosses() || targetDe != 4 || targetItemInfo.getControl().getValue() != 27 && targetItemInfo.getControl().getValue() != 28) continue;
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)resClassName, (String)"11ForbidRelation_3"), i + 1));
            SysUtil.abort();
        }
    }

    private List getParentNumbers(String number) {
        if (number.indexOf(46) == -1) {
            return null;
        }
        ArrayList<String> numbers = new ArrayList<String>();
        int end = number.length();
        while ((end = number.lastIndexOf(46, end)) > 0) {
            numbers.add(number.substring(0, end));
            --end;
        }
        return numbers;
    }

    private void crossLoopValidate(IRptItemRelationship irship) throws BOSException {
        RptItemRelationshipCollection coll;
        String oql = "select id,dataElement,item.number,item.id,entries,entries.dataElement,entries.targetItem.number";
        if (this.editData != null && this.editData.getId() != null) {
            oql = oql + " where id != '" + this.editData.getId().toString() + "'";
        }
        if ((coll = irship.getRptItemRelationshipCollection(oql)) != null && coll.size() > 0) {
            String body;
            HashMap map = new HashMap();
            String head = null;
            for (int i = 0; i < coll.size(); ++i) {
                head = coll.get(i).getItem().getNumber() + SPLIT + coll.get(i).getDataElement();
                HashSet<String> set = new HashSet<String>();
                map.put(head, set);
                for (int j = 0; j < coll.get(i).getEntries().size(); ++j) {
                    body = coll.get(i).getEntries().get(j).getTargetItem().getNumber() + SPLIT + coll.get(i).getEntries().get(j).getDataElement();
                    set.add(body);
                }
            }
            RptItemRelationshipEntryCollection cEntryCollection = this.editData.getEntries();
            RptItemRelationshipEntryInfo entryInfo = null;
            head = this.editData.getItem().getNumber() + SPLIT + this.editData.getDataElement();
            for (int i = 0; i < cEntryCollection.size(); ++i) {
                entryInfo = cEntryCollection.get(i);
                body = entryInfo.getTargetItem().getNumber() + SPLIT + entryInfo.getDataElement();
                Map m = this.check(map, new HashMap(2), body, head);
                if (!m.containsKey("true")) continue;
                String s = m.get("true").toString();
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)resClassName, (String)"12ForbidRelation_4_1") + "\r\n" + s));
                SysUtil.abort();
            }
        }
    }

    private Map check(Map itemMap, Map map, String body, String head) {
        body = this.contains(itemMap.keySet(), body);
        if (body != null) {
            StringBuffer msg = null;
            if (map.containsKey("msg")) {
                msg = (StringBuffer)map.get("msg");
                msg.append("\r\n ").append(EASResource.getString((String)resClassName, (String)"13ForbidRelation_4_2")).append(" [");
            } else {
                msg = new StringBuffer(EASResource.getString((String)resClassName, (String)"14ForbidRelation_4_3")).append(" [");
            }
            msg.append(body.split(SPLIT)[0]).append(" ");
            msg.append(this.getDataElementInfo(new Integer(body.split(SPLIT)[1])).getName());
            msg.append("]");
            Set bodySet = (Set)itemMap.remove(body);
            if (bodySet.contains(head)) {
                msg.append("\r\n ").append(EASResource.getString((String)resClassName, (String)"13ForbidRelation_4_2")).append(" [").append(head.split(SPLIT)[0]).append(" ");
                msg.append(this.getDataElementInfo(new Integer(head.split(SPLIT)[1])).getName());
                msg.append("]");
                map.put("true", msg.toString());
            } else {
                Iterator iter = bodySet.iterator();
                map.put("msg", msg);
                while (iter.hasNext()) {
                    map = this.check(itemMap, map, iter.next().toString(), head);
                }
            }
        }
        return map;
    }

    private DataElementInfo getDataElementInfo(int innerValue) {
        return DataElementProvider.getDataElementInfo(innerValue);
    }

    private String contains(Set set, String key) {
        if (set.contains(key)) {
            return key;
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String curKey = iter.next().toString();
            String itemNumber = curKey.split(SPLIT)[0];
            if (itemNumber.indexOf(".") <= 0 || !itemNumber.startsWith(key.split(SPLIT)[0])) continue;
            return curKey;
        }
        return null;
    }

    private void uniqueValidate(IRptItemRelationship irship) throws BOSException {
        CoreBaseCollection collection;
        StringBuffer oql = new StringBuffer("select id where item.id = '");
        oql.append(this.editData.getItem().getId().toString()).append("' ");
        oql.append(" and dataElement = ").append(this.editData.getDataElement());
        if (this.getOprtState().equals(OprtState.EDIT) && this.editData.getId() != null) {
            oql.append(" and id != '").append(this.editData.getId().toString()).append("' ");
        }
        if ((collection = irship.getCollection(oql.toString())) != null && collection.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"15ForbidRelation_5"));
            SysUtil.abort();
        }
    }

    private void validateBeforeSave() throws BOSException {
        this.commonValidate();
        this.connectionValidate();
        IRptItemRelationship irship = RptItemRelationshipFactory.getRemoteInstance();
        this.uniqueValidate(irship);
        this.crossLoopValidate(irship);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.validateBeforeSave();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.editData.setIsFreezed(false);
    }

    public boolean isModify() {
        if (this.getUIContext() != null && this.getUIContext().containsKey("isCopyToNew") && this.getOprtState().equals(OprtState.ADDNEW)) {
            return true;
        }
        return super.isModify();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo(TB_DATAELEMENT));
        sic.add(new SelectorItemInfo("scope"));
        sic.add(new SelectorItemInfo("item.id"));
        sic.add(new SelectorItemInfo("item.name"));
        sic.add(new SelectorItemInfo("item.number"));
        sic.add(new SelectorItemInfo("item.isProfitAndLosses"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.dataElement"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.targetItem.id"));
        sic.add(new SelectorItemInfo("entries.targetItem.number"));
        sic.add(new SelectorItemInfo("entries.targetItem.name"));
        sic.add(new SelectorItemInfo("entries.targetItem.control"));
        sic.add(new SelectorItemInfo("trackRecordCreator"));
        return sic;
    }
}

