/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.SJSParamterHelper;
import com.kingdee.eas.fi.gr.cslrpt.SJSReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractSJSTemplateInputUI;
import com.kingdee.eas.fi.gr.cslrpt.client.PathSelector;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSumTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BookHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class SJSTemplateInputUI
extends AbstractSJSTemplateInputUI {
    private static final Logger logger = CoreUIObject.getLogger(SJSTemplateInputUI.class);
    private Integer EXIST = new Integer(1);
    private Integer OVER = new Integer(2);
    private Integer ADD = new Integer(0);
    private Point basePoint = null;

    private void initBasePoint() {
        this.basePoint = new Point();
        this.basePoint.x = 3;
        this.basePoint.y = 0;
    }

    public SJSTemplateInputUI() throws Exception {
        this.initBasePoint();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String easHome = System.getProperty("EAS_HOME") + File.separator + "client" + File.separator + "template" + File.separator + "CslRptTemplate";
        File file = new File(FilenameUtils.normalize((String)easHome));
        if (!file.exists()) {
            file.mkdirs();
        }
        this.bpbFilePath.setSelector((KDPromptSelector)new PathSelector((Component)((Object)this), "OPEN", 0));
    }

    public static void showDialogWindows(IUIObject ui) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SJSTemplateInputUI.class.getName(), (Map)uiContext, null, "EDIT");
        uiWindow.show();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        String filePath = this.bpbFilePath.getText();
        if (filePath != null && filePath.length() > 0) {
            this.importTemplate(filePath);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"683_SJSTemplateInputUI"));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importTemplate(String filePath) throws BOSException, Exception {
        SAXBuilder builder = new SAXBuilder();
        Document inputDoc = null;
        Element bgInfo = null;
        String bglb = null;
        String bgnd = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"684_SJSTemplateInputUI"));
                return;
            }
            inputDoc = builder.build(file);
            bgInfo = inputDoc.getRootElement().getChild("bz_ggzt");
            bglb = bgInfo.getChild("row").getAttributeValue("bglb");
            bgnd = bgInfo.getChild("row").getAttributeValue("bgnd");
        }
        catch (Exception e) {
            logger.error((Object)"importTemplate_Exception", (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("101", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"685_SJSTemplateInputUI")));
        }
        String clPath = SJSReportInfo.class.getName();
        InputStream is = null;
        try {
            is = Class.forName(clPath).getResourceAsStream("config/sjs_temp_column.xml");
            Document colDoc = builder.build(is);
            Element quarterEl = null;
            if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"663_SJSMessageOutUI").equals(bglb)) {
                quarterEl = colDoc.getRootElement().getChild("First");
            }
            if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"664_SJSMessageOutUI").equals(bglb)) {
                quarterEl = colDoc.getRootElement().getChild("Second");
            }
            if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"665_SJSMessageOutUI").equals(bglb)) {
                quarterEl = colDoc.getRootElement().getChild("Third");
            }
            if (EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"666_SJSMessageOutUI").equals(bglb)) {
                quarterEl = colDoc.getRootElement().getChild("Fourth");
            }
            if (quarterEl == null) {
                MsgBox.showInfo((Component)((Object)this), (String)"The imported Template is invalid! \n Please choose other Template!");
                return;
            }
            inputDoc = this.clearData(inputDoc, quarterEl);
            int tempCount = this.getTemplateCount(inputDoc, quarterEl);
            bglb = quarterEl.getName();
            Integer type = this.isExists(bgnd, bglb, tempCount);
            if (type.intValue() == this.EXIST.intValue()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"686_SJSTemplateInputUI"));
                return;
            }
            if (type.intValue() == this.OVER.intValue()) {
                int i = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"687_SJSTemplateInputUI"));
                if (i != 0) {
                    return;
                }
                this.buildTemplate(inputDoc, quarterEl, filePath, bgnd, bglb);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"688_SJSTemplateInputUI"));
                this.disposeUIWindow();
            } else {
                this.buildTemplate(inputDoc, quarterEl, filePath, bgnd, bglb);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"688_SJSTemplateInputUI"));
                this.disposeUIWindow();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    logger.error((Object)"is.close()_error", (Throwable)e);
                }
            }
        }
    }

    public int getTemplateCount(Document inputDoc, Element quarterEl) {
        List tempList = inputDoc.getRootElement().getChildren();
        int count = 0;
        block0: for (int i = 0; i < tempList.size(); ++i) {
            Element temp = (Element)tempList.get(i);
            String tempNumber = temp.getName();
            List colTempList = quarterEl.getChildren(tempNumber);
            if (colTempList == null || colTempList.size() <= 0) continue;
            List rows = temp.getChildren();
            ArrayList<String> lbs = new ArrayList<String>();
            for (int j = 0; j < rows.size(); ++j) {
                Element row = (Element)rows.get(j);
                if (row.getAttribute("lb") == null) {
                    lbs.add("");
                    ++count;
                    continue block0;
                }
                String lb = row.getAttributeValue("lb");
                if (lbs.contains(lb)) continue;
                lbs.add(lb);
                ++count;
            }
        }
        return count;
    }

    private Document clearData(Document inputDoc, Element el) {
        Element rootEl = inputDoc.getRootElement();
        List list = rootEl.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Element temp = (Element)list.get(i);
            String tempName = temp.getName();
            Element colChild = el.getChild(tempName);
            if (colChild == null) continue;
            List rowList = temp.getChildren();
            for (int j = 0; j < rowList.size(); ++j) {
                Element row = (Element)rowList.get(j);
                List colList = colChild.getChildren();
                for (int k = 0; k < colList.size(); ++k) {
                    String dm;
                    boolean isdata;
                    Element range = (Element)colList.get(k);
                    boolean bl = isdata = range.getAttributeValue("isdata").equals("true");
                    if (!isdata || row.getAttribute(dm = range.getAttributeValue("dm")) == null) continue;
                    row.removeAttribute(dm);
                }
            }
        }
        return inputDoc;
    }

    public void buildTemplate(Document inputDoc, Element quarterEl, String filePath, String bgnd, String bglb) throws Exception {
        List tempList = inputDoc.getRootElement().getChildren();
        for (int i = 0; i < tempList.size(); ++i) {
            int j;
            Element temp = (Element)tempList.get(i);
            String tempNumber = temp.getName();
            List colTempList = quarterEl.getChildren(tempNumber);
            if (colTempList == null || colTempList.size() <= 0) continue;
            List rows = temp.getChildren();
            ArrayList<String> lbs = new ArrayList<String>();
            for (j = 0; j < rows.size(); ++j) {
                Element row = (Element)rows.get(j);
                if (row.getAttribute("lb") == null) {
                    lbs.add("");
                    break;
                }
                String lb = row.getAttributeValue("lb");
                if (lbs.contains(lb)) continue;
                lbs.add(lb);
            }
            for (j = 0; j < lbs.size(); ++j) {
                String lb = lbs.get(j).toString();
                for (int k = 0; k < colTempList.size(); ++k) {
                    Element colTemp = (Element)colTempList.get(k);
                    String tempName = colTemp.getAttributeValue("name");
                    if (!lb.equals(colTemp.getAttributeValue("lb"))) continue;
                    ArrayList<SJSReportInfo> rowList = new ArrayList<SJSReportInfo>();
                    ArrayList<String> colList = new ArrayList<String>();
                    int num = 1;
                    Book book = BookHelper.getNewBook();
                    book.clear();
                    ReportVariables cv = (ReportVariables)book.getUserObjectValue("VARIABLES");
                    if (cv == null) {
                        cv = new ReportVariables();
                        cv.add(new VariableEntry("SheetClass", tempNumber));
                        book.setUserObject("VARIABLES", (Object)cv);
                    }
                    Sheet sheet = new Sheet(book, tempNumber);
                    sheet.setName(tempNumber);
                    book.insertSheet(0, sheet);
                    List cols = colTemp.getChildren();
                    int lastCol = 0;
                    for (int n = 0; n < cols.size(); ++n) {
                        Element col = (Element)cols.get(n);
                        int row1 = Integer.parseInt(col.getAttributeValue("row1"));
                        int col1 = Integer.parseInt(col.getAttributeValue("col1"));
                        int row2 = Integer.parseInt(col.getAttributeValue("row2"));
                        int col2 = Integer.parseInt(col.getAttributeValue("col2"));
                        String width = col.getAttributeValue("width");
                        String mc = col.getAttributeValue("mc");
                        String dm = col.getAttributeValue("dm");
                        if (col.getAttributeValue("isdata").equals("true")) {
                            colList.add(dm);
                        }
                        num = row2;
                        lastCol = col2;
                        Range range = sheet.getRange(this.basePoint.x + row1, this.basePoint.y + col1, this.basePoint.x + row2, this.basePoint.y + col2);
                        if (width != null && width.length() > 0) {
                            sheet.getColRange(this.basePoint.y + col1, this.basePoint.y + col2).setColumnWidth(Integer.parseInt(width));
                        }
                        this.setRange(range, mc, true);
                    }
                    int rowCount = 0;
                    for (int n = 0; n < rows.size(); ++n) {
                        Element row = (Element)rows.get(n);
                        String kmmc = row.getAttributeValue("kmmc");
                        String kmdm = row.getAttributeValue("kmdm");
                        boolean sfxkm = row.getAttributeValue("sfxkm").equals("true");
                        int sj = Integer.parseInt(row.getAttributeValue("kmmcsj"));
                        String templb = row.getAttributeValue("lb");
                        if (templb != null && !templb.equals(lb)) continue;
                        int begin = this.basePoint.x + num + 1;
                        StringBuffer sbSj = new StringBuffer();
                        for (int m = 0; m < sj; ++m) {
                            sbSj.append(" ");
                        }
                        Range range = sheet.getRange(begin + rowCount, this.basePoint.y);
                        sheet.getColRange(0, 0).setColumnWidth(260);
                        range.setFormula(sbSj.toString() + kmmc);
                        SJSReportInfo rptInfo = new SJSReportInfo(kmmc, kmdm, sfxkm);
                        rowList.add(rptInfo);
                        ++rowCount;
                    }
                    this.setRange(sheet.getRange(this.basePoint.x, this.basePoint.y, this.basePoint.x + num, this.basePoint.y), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"689_SJSTemplateInputUI"), true);
                    this.setRange(sheet.getRange(this.basePoint.x - 3, this.basePoint.y, this.basePoint.x - 3, this.basePoint.y + lastCol), tempName, true);
                    this.setHormula(sheet, lastCol);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("rowList", rowList);
                    map.put("colList", colList);
                    map.put("num", String.valueOf(num + 1));
                    map.put("xml", this.getStringFromXML(inputDoc));
                    sheet.getRange(this.basePoint.x, this.basePoint.y).setUserObject("rpt", (Object)SJSParamterHelper.getStringFromMap(map));
                    sheet.getRange(this.basePoint.x, this.basePoint.y).setUserObject("list", rowList);
                    this.setBorderAndBackColor(sheet, rowCount, lastCol, num);
                    TemplateInfo info = this.addTemplateInfo(book, bgnd, bglb, tempNumber, tempName, lb);
                    this.saveOrUpdateTemp(info);
                }
            }
        }
    }

    private TemplateInfo addTemplateInfo(Book book, String bgnd, String bglb, String tempNumber, String tempName, String lb) throws IOException, EASBizException, BOSException {
        TemplateInfo tempInfo = new TemplateInfo();
        tempInfo.setId(BOSUuid.create((BOSObjectType)tempInfo.getBOSType()));
        tempInfo.setNumber("sjs" + bgnd + "" + bglb + "_" + tempNumber.substring(2) + (lb.equals("0") ? "" : lb));
        tempInfo.setName(tempName);
        tempInfo.setTemplateType(RptTmpTypeEnum.CSLREPORT);
        tempInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        tempInfo.setAuditor(null);
        tempInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        tempInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        tempInfo.setIsFreezed(false);
        tempInfo.setStartDate(new Date(System.currentTimeMillis()));
        tempInfo.setSumType(RptSumTypeEnum.NULL);
        tempInfo.setCompany(RptUtilForClient.getCurrentCompany());
        CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
        ctrlUnitInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        tempInfo.setMaintainCU(ctrlUnitInfo);
        tempInfo.setBook(book);
        return tempInfo;
    }

    private void saveOrUpdateTemp(TemplateInfo tempInfo) throws IOException, Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("where number = '").append(tempInfo.getNumber()).append("'");
        boolean exists = this.getRemoteInstance().exists(sb.toString());
        if (exists) {
            TemplateInfo temp = this.getRemoteInstance().getTemplateInfo(sb.toString());
            this.getRemoteInstance().getCollection(sb.toString());
            AuditedStatusEnum auditedEnum = temp.getAuditedStatus();
            if (auditedEnum.getValue() == 2) {
                return;
            }
            temp.setBook(tempInfo.getBook());
            this.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(temp.getId()), (CoreBaseInfo)temp);
        } else {
            TemplateFactory.getRemoteInstance().addnew((CoreBaseInfo)tempInfo);
        }
    }

    private ITemplate getRemoteInstance() throws BOSException {
        return TemplateFactory.getRemoteInstance();
    }

    private Integer isExists(String bgnd, String bglb, int tempCount) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("where number like 'sjs");
        sb.append(bgnd).append("").append(bglb);
        sb.append("%'");
        boolean exists = this.getRemoteInstance().exists(sb.toString());
        if (exists) {
            String sbStr = sb.toString();
            sbStr = sbStr + " and auditedStatus = 1";
            boolean isAudited = this.getRemoteInstance().exists(sbStr);
            if (isAudited) {
                return this.OVER;
            }
            int size = this.getRemoteInstance().getCollection(sb.toString()).size();
            if (tempCount == size) {
                return this.EXIST;
            }
            return this.OVER;
        }
        return this.ADD;
    }

    private String getStringFromXML(Document doc) throws JDOMException, IOException {
        XMLOutputter outPut = new XMLOutputter();
        return outPut.outputString(doc);
    }

    private void setHormula(Sheet sheet, int col) {
        this.setRange(sheet.getRange(this.basePoint.x - 1, this.basePoint.y), "=CONCATENATE(\"" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"810_SJSTemplateInputUI") + "\",getOrgName(\"Company\"))", false);
        this.setRange(sheet.getRange(this.basePoint.x - 1, this.basePoint.y + col / 2), "=rptDate(\"" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"811_SJSTemplateInputUI") + "\")", false);
        this.setRange(sheet.getRange(this.basePoint.x - 1, this.basePoint.y + col), "=CONCATENATE(\"" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"812_SJSTemplateInputUI") + "\",getCurrency(\"name\"),\"" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"813_SJSTemplateInputUI") + "\")", false);
    }

    private void setRange(Range range, String context, boolean isMerge) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        range.setFormula(context);
        range.setStyle(sa, Styles.getEmptySA());
        if (isMerge) {
            range.merge();
        }
    }

    private void setBorderAndBackColor(Sheet sheet, int rowCount, int colCount, int num) {
        this.setBackColorAndLock(sheet, rowCount, colCount, num);
        this.setBorderColor(sheet.getRange(this.basePoint.x, this.basePoint.y, this.basePoint.x + rowCount + num, this.basePoint.y + colCount), rowCount, Color.black);
    }

    private void setBackColorAndLock(Sheet sheet, int rowCount, int colCount, int num) {
        Protection pro = sheet.getSheetOption().getProtection(true);
        pro.appendOperation(4);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setFontSize(10);
        sa.setLocked(true);
        sheet.getSheetRange().setStyle(sa, Styles.getEmptySA());
        sa.setBackground(Color.lightGray);
        sheet.getRange(this.basePoint.x, this.basePoint.y, this.basePoint.x + rowCount + num, colCount).setStyle(sa, Styles.getEmptySA());
        sa.setBackground(Color.white);
        sa.setLocked(false);
        sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getRange(this.basePoint.x + num + 1, this.basePoint.y + 1, this.basePoint.x + rowCount + num, this.basePoint.y + colCount).setStyle(sa, Styles.getEmptySA());
        sa.setBackground(Color.lightGray);
        sa.setLocked(true);
        sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        List list = (List)sheet.getRange(this.basePoint.x, this.basePoint.y).getUserObject("list");
        for (int i = 0; i < list.size(); ++i) {
            SJSReportInfo rptInfo = (SJSReportInfo)list.get(i);
            if (!rptInfo.isSfxkm()) continue;
            sheet.getRange(this.basePoint.x + i + num + 1, this.basePoint.y, this.basePoint.x + i + num + 1, colCount).setStyle(sa, Styles.getEmptySA());
        }
        pro.start();
    }

    private void setBorderColor(Range range, int size, Color color) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.RIGHT, color);
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.BOTTOM, color);
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.LEFT, color);
        sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.TOP, color);
        StyleAttributes saInnerBorder = Styles.getEmptySA();
        saInnerBorder.setBorderPenStyle(Styles.Position.INNER_H, PenStyle.PS_SOLID);
        saInnerBorder.setBorderColor(Styles.Position.INNER_H, color);
        saInnerBorder.setBorderLineStyle(Styles.Position.INNER_H, LineStyle.SINGLE_LINE);
        saInnerBorder.setBorderPenStyle(Styles.Position.INNER_V, PenStyle.PS_SOLID);
        saInnerBorder.setBorderColor(Styles.Position.INNER_V, color);
        saInnerBorder.setBorderLineStyle(Styles.Position.INNER_V, LineStyle.SINGLE_LINE);
        range.setStyle(sa, saInnerBorder);
    }
}

