/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.SaveAsEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractSaveAsNewVersionUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SaveAsNewVersionUI
extends AbstractSaveAsNewVersionUI {
    private static final Logger logger = CoreUIObject.getLogger(SaveAsNewVersionUI.class);
    private static final String ID = "ID";
    private CslReportInfo info = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initButton();
        this.init();
    }

    private void init() throws EASBizException, BOSException, IOException {
        String reportId = this.getUIContext().get(ID).toString();
        StringBuffer oql = new StringBuffer();
        oql.append("select *,template.name, orgUnit.name,currency.name  where id = '").append(reportId).append("'");
        CslReportCollection col = CslReportFactory.getRemoteInstance().getCslReportCollection(oql.toString());
        this.info = col.get(0);
        this.txtName.setText(this.info.getName());
        this.prmtCompany.setData((Object)this.info.getOrgUnit().getName());
        this.prmtTemplate.setData((Object)this.info.getTemplate().getName());
        this.comboPeriodType.setSelectedItem((Object)this.info.getPeriodType().getAlias());
        this.prmtCurrency.setData((Object)this.info.getCurrency().getName());
        this.txtYear.setText(new Integer(this.info.getYear()).toString());
        this.txtPeriod.setText(new Integer(this.info.getPeriod()).toString());
        this.txtSrcType.setText(this.info.getSourceType().getAlias());
        this.txtRemark.setText(this.info.getRemark());
        if (this.getUIContext().get("view") == null) {
            this.setNumber(this.info);
            Book book1 = (Book)this.getUIContext().get("BOOK");
            this.info.setBook(book1);
        } else {
            this.txtNumber.setText(this.info.getNumber());
        }
        this.info.setSourceType(this.info.getSourceType());
    }

    private void setNumber(CslReportInfo info) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select saveAsVersionNum where orgUnit.id = '").append(info.getOrgUnit().getId().toString());
        oql.append("' and template.id = '").append(info.getTemplate().getId().toString());
        oql.append("' and sourceType = ").append(info.getSourceType().getValue());
        oql.append(" and currency.id = '").append(info.getCurrency().getId().toString()).append("' ");
        oql.append(" and sourceCurrency.id = '").append(info.getSourceCurrency().getId().toString()).append("' ");
        oql.append(" and dataCollectNumber = '").append(info.getDataCollectNumber()).append("' ");
        oql.append(" and adjustStatus = ").append(info.getAdjustStatus().getValue()).append(" ");
        oql.append(" and isSaveAs = ").append(1).append(" and orgTree.id= '").append(info.getOrgTree().getId()).append("' ").append(" order by saveAsVersionNum desc");
        boolean exist = CslReportFactory.getRemoteInstance().exists(oql.toString());
        if (exist) {
            CslReportCollection col = CslReportFactory.getRemoteInstance().getCslReportCollection(oql.toString());
            CslReportInfo info1 = col.get(0);
            int version = info1.getSaveAsVersionNum() + 1;
            String versionNum = "V" + version + ".0";
            info.setIsSaveAs(SaveAsEnum.isHistory);
            info.setSaveAsVersionNum(version);
            this.txtNumber.setText(versionNum);
        } else {
            info.setIsSaveAs(SaveAsEnum.isHistory);
            info.setSaveAsVersionNum(1);
            this.txtNumber.setText("V1.0");
        }
    }

    private void initButton() {
        this.txtNumber.setEnabled(true);
        this.txtName.setEnabled(true);
        this.prmtCompany.setEnabled(false);
        this.prmtTemplate.setEnabled(false);
        this.comboPeriodType.setEnabled(false);
        this.prmtCurrency.setEnabled(false);
        this.txtYear.setEnabled(false);
        this.txtPeriod.setEnabled(false);
        this.txtSrcType.setEnabled(false);
        this.txtRemark.setEnabled(true);
        this.btnOk.setEnabled(true);
        this.btnClear.setEnabled(true);
        if (this.getUIContext().get("view") != null) {
            this.btnOk.setEnabled(false);
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_Title"));
        }
    }

    public boolean isModify() {
        return false;
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.setInfo();
        IObjectPK pk = CslReportFactory.getRemoteInstance().addnew((CoreBaseInfo)this.info);
        if (pk != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
            this.getUIWindow().close();
        }
    }

    private void setInfo() throws AdjustException, EASBizException {
        if (this.txtRemark.getText().length() > 1000) {
            throw new AdjustException(AdjustException.REMARKISOVERLENGTH);
        }
        this.info.setRemark(this.txtRemark.getText());
        this.info.setId(null);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NumberNull")));
        }
        this.info.setNumber(this.txtNumber.getText());
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            this.txtName.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NameNull")));
        }
        this.info.setName(this.txtName.getText());
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected IObjectValue createNewData() {
        return new CslReportInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    public static void main(String[] args) {
        String version = "V1.0";
        String reg = "\\d";
        Pattern p = Pattern.compile(reg, 2);
        Matcher m = p.matcher(version);
        if (m.find()) {
            int vNum = new Integer(m.group()) + 1;
            version = vNum + ".0";
        }
    }
}

