/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslSendEmailToCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslSendEmailToFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslSendEmailToFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslSendEmailToInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractSendMessageUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SendMessageUI
extends AbstractSendMessageUI {
    private static final Logger logger = CoreUIObject.getLogger(SendMessageUI.class);
    private List list = null;
    private HashSet CompanyIdSet = null;
    private HashMap CompanyId_CSLreportList_Map = null;
    private HashMap CompanyId_SendMessage_Map = null;
    CslReportCollection cslReportCollection = null;
    private String firstId = null;
    private boolean isSuccess;

    public void onLoad() throws Exception {
        super.onLoad();
        String msg = this.getUIContext().get("message").toString();
        this.list = (List)this.getUIContext().get("ids");
        this.initControl(msg, this.list);
    }

    private void initControl(String msg, List list) throws BOSException, EASBizException {
        int i;
        Font font = new Font("Scrif", 1, 12);
        this.txtTitle.setFont(font);
        this.txtTitle.setText(msg);
        this.txtTitle.setEditable(false);
        StringBuffer sql = new StringBuffer();
        sql.append("select number,name,year,period,currency.name,commitor.id,orgUnit.name where id in (");
        if (list != null && list.size() > 0) {
            for (i = 0; i < list.size(); ++i) {
                sql.append("'");
                sql.append(list.get(i).toString());
                sql.append("'");
                sql.append(",");
            }
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        this.cslReportCollection = CslReportFactory.getRemoteInstance().getCslReportCollection(sql.toString());
        this.CompanyIdSet = new HashSet();
        for (i = 0; i < this.cslReportCollection.size(); ++i) {
            CslReportInfo info = this.cslReportCollection.get(i);
            if (info.getOrgUnit().getId() == null || info.getOrgUnit().getId().toString().length() <= 0) continue;
            this.CompanyIdSet.add(info.getOrgUnit().getId().toString());
        }
        Iterator it = this.CompanyIdSet.iterator();
        this.CompanyId_CSLreportList_Map = new HashMap();
        int k = 0;
        while (it.hasNext()) {
            String id = (String)it.next();
            if (k == 0) {
                this.firstId = id;
            }
            ArrayList<CslReportInfo> l = new ArrayList<CslReportInfo>();
            for (int i2 = 0; i2 < this.cslReportCollection.size(); ++i2) {
                CslReportInfo info = this.cslReportCollection.get(i2);
                if (info.getOrgUnit().getId() == null || !info.getOrgUnit().getId().toString().equals(id)) continue;
                l.add(info);
            }
            this.CompanyId_CSLreportList_Map.put(id, l);
            ++k;
        }
        StringBuffer text = new StringBuffer();
        this.CompanyId_SendMessage_Map = this.returnMap(this.CompanyId_CSLreportList_Map);
        if (this.CompanyId_SendMessage_Map != null && this.CompanyId_SendMessage_Map.size() > 0) {
            for (String id : this.CompanyIdSet) {
                text = text.append(this.CompanyId_SendMessage_Map.get(id).toString());
            }
        }
        this.txtMsg.setText(text.toString());
        this.txtMsg.setEditable(this.cslReportCollection != null && this.cslReportCollection.size() == 1);
    }

    private HashMap returnMap(HashMap map) {
        HashMap<String, String> hashMapString = new HashMap<String, String>();
        if (!map.isEmpty()) {
            Set set = map.entrySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                StringBuffer bf = new StringBuffer();
                Map.Entry e = it.next();
                String id = (String)e.getKey();
                ArrayList l = (ArrayList)e.getValue();
                for (int i = 0; i < l.size(); ++i) {
                    CslReportInfo cslReportInfo = (CslReportInfo)l.get(i);
                    bf.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"reportNumber") + ":").append(cslReportInfo.getNumber()).append("_").append(cslReportInfo.getName()).append(" ");
                    bf.append(cslReportInfo.getYear()).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Year")).append(cslReportInfo.getPeriod()).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"qi")).append(cslReportInfo.getCurrency().getName()).append(" ").append(cslReportInfo.getOrgUnit().getName()).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"someReport")).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"returnBack")).append("\r\n");
                }
                hashMapString.put(id, bf.toString());
            }
            return hashMapString;
        }
        return null;
    }

    private void SendEmail(HashMap m) {
        if (!m.isEmpty()) {
            Set set = m.entrySet();
            Iterator it = set.iterator();
            String title = new String(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"returnEmail"));
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String id = (String)e.getKey();
                String contentValue = (String)e.getValue();
                try {
                    IUser user = UserFactory.getRemoteInstance();
                    UserInfo userInfo = user.getUserInfo((IObjectPK)new ObjectStringPK(id));
                    IPerson person = PersonFactory.getRemoteInstance();
                    if (userInfo.getPerson() != null && userInfo.getPerson().getId() != null) {
                        PersonInfo personInfo = person.getPersonInfo((IObjectPK)new ObjectUuidPK(userInfo.getPerson().getId()));
                        if (personInfo.getEmail() == null || personInfo.getEmail().length() == 0) {
                            MsgBox.showError((String)(personInfo.getName() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"returnMessage")));
                            SysUtil.abort();
                            continue;
                        }
                        IMessageCenter sender = MessageCenterFactory.getRemoteInstance();
                        sender.sendEmail(title, contentValue, personInfo.getEmail(), null, null);
                        continue;
                    }
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"noCommitorToPerson"));
                    SysUtil.abort();
                }
                catch (EASBizException e1) {
                    this.handUIException(e1);
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"noCommitor"));
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
        this.isSuccess = false;
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionOk_actionPerformed(e);
        this.sendInformation();
        this.getUIWindow().close();
        this.isSuccess = true;
    }

    private void sendInformation() throws BOSException, EASBizException {
        boolean isBlured = this.isEmailCheckBox.isSelected();
        if (isBlured) {
            if (this.txtMsg.getText() != null && this.txtMsg.getText().length() > 0) {
                this.CompanyId_SendMessage_Map.put(this.firstId, this.txtMsg.getText());
            }
            ArrayList<String> list = null;
            CslSendEmailToCollection cslSendEmailToCollection = CslSendEmailToFactory.getRemoteInstance().getCslSendEmailToCollection();
            if (cslSendEmailToCollection != null && cslSendEmailToCollection.size() > 0) {
                list = new ArrayList<String>();
                for (int k = 0; k < cslSendEmailToCollection.size(); ++k) {
                    CslSendEmailToInfo cslSendEmailToInfo = cslSendEmailToCollection.get(k);
                    list.add(cslSendEmailToInfo.getMagroupresolventid().toString());
                }
            }
            CslSendEmailToFacadeFactory.getRemoteInstance().SendEmailTo(this.CompanyId_SendMessage_Map, list);
        }
    }

    private void sendBack() throws Exception, BOSException, EASBizException {
        String s = null;
        int n = (Integer)this.getUIContext().get("amount");
        int iCount = CslRptUIUtil.getCyConvertRptCount(this.list);
        if (iCount > 0 && MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)(s = MessageFormat.format(CslRptUtil.getString("existsConvertRpt"), new Integer(iCount)))))) {
            return;
        }
        String result = RPTDataServiceFactory.getRemoteInstance().sendBackOneReport(this.list, this.txtMsg.getText());
        if (result == null || result.length() == 0) {
            s = MessageFormat.format(CslRptUtil.getString("RptReceive_Hint_SuccessSendBack"), new Integer(n));
            MsgBox.showInfo((String)s);
        } else {
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"Title", (Object)CslRptUtil.getString("ReceiveSendBackFail"));
            ctx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
            SimpleNotePad.showMessageByModel(ctx, result);
        }
        this.getUIWindow().close();
        this.isSuccess = true;
    }

    private void check() {
        OrgTreeInfo treeInfo = (OrgTreeInfo)this.getUIContext().get("treeInfo");
        String s = null;
        String msg = this.getUIContext().get("message").toString();
        if (treeInfo == null) {
            s = CslRptUtil.getString("ReceiveUnReceiveFail");
            MsgBox.showError((String)(msg + " ," + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"pleaseSelect")));
            return;
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCancel.setEnabled(true);
        this.btnOk.setEnabled(true);
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public KDTextArea getTxtMsg() {
        return this.txtMsg;
    }
}

